/*
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/model/SelectionModel","./SelectionPlugin","../utils/TableUtils","../library"],function(e,t,o,i){"use strict";var n=i.SelectionMode;var l=t.extend("sap.ui.table.plugins.SelectionModelSelection",{metadata:{library:"sap.ui.table",properties:{selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:n.MultiToggle}},events:{selectionChange:{parameters:{indices:{type:"int[]"},selectAll:{type:"boolean"}}}}}});l.prototype.init=function(){t.prototype.init.apply(this,arguments);this.oSelectionModel=new e(c(this.getSelectionMode()))};l.prototype.exit=function(){t.prototype.exit.apply(this,arguments);if(this.oSelectionModel){this.oSelectionModel.destroy();this.oSelectionModel=null}};l.prototype.onActivate=function(e){t.prototype.onActivate.apply(this,arguments);this.oSelectionModel.attachSelectionChanged(s,this);o.Hook.register(e,o.Hook.Keys.Table.TotalRowCountChanged,S,this);this._iTotalRowCount=e._getTotalRowCount()};l.prototype.onDeactivate=function(e){t.prototype.onDeactivate.apply(this,arguments);this.oSelectionModel.detachSelectionChanged(s,this);this.oSelectionModel.clearSelection();d(this,this.getTableBinding());o.Hook.deregister(e,o.Hook.Keys.Table.TotalRowCountChanged,S,this)};l.prototype.setSelected=function(e,t,o){if(!this.isIndexSelectable(e.getIndex())){return}if(o&&o.range){var i=this.getSelectedIndex();if(i>=0){this.addSelectionInterval(i,e.getIndex())}}else if(t){this.addSelectionInterval(e.getIndex(),e.getIndex())}else{this.removeSelectionInterval(e.getIndex(),e.getIndex())}};l.prototype.isSelected=function(e){return this.isIndexSelected(e.getIndex())};l.prototype.getRenderConfig=function(){return{headerSelector:{type:"toggle",visible:o.hasSelectAll(this.getTable()),selected:this.getSelectableCount()>0&&this.getSelectableCount()===this.getSelectedCount()}}};function r(e){var t=e.getTable(),o;if(e.getSelectableCount()>e.getSelectedCount()){t._iSourceRowIndex=0;e.selectAll();o=true}else{t._iSourceRowIndex=-1;e.clearSelection();o=false}t._iSourceRowIndex=undefined;return o}l.prototype.onHeaderSelectorPress=function(){if(this.getRenderConfig().headerSelector.visible){r(this)}};l.prototype.onKeyboardShortcut=function(e,t){if(e==="toggle"&&r(this)===false){t?.setMarked("sapUiTableClearAll")}else if(e==="clear"){this.clearSelection();t?.setMarked("sapUiTableClearAll")}};l.prototype.addSelectionInterval=function(e,t){if(!this.oSelectionModel||this.getSelectionMode()===n.None){return}this.oSelectionModel.addSelectionInterval(e,t)};l.prototype.clearSelection=function(){if(this.oSelectionModel){this.oSelectionModel.clearSelection()}};l.prototype.getSelectedIndex=function(){if(this.oSelectionModel){return this.oSelectionModel.getLeadSelectedIndex()}return-1};l.prototype.getSelectedIndices=function(){if(this.oSelectionModel){return this.oSelectionModel.getSelectedIndices()}return[]};l.prototype.getSelectableCount=function(){var e=this.getTableBinding();return e?e.getLength():0};l.prototype.getSelectedCount=function(){return this.getSelectedIndices().length};l.prototype.isIndexSelectable=function(e){return e>=0&&e<=this._getHighestSelectableIndex()};l.prototype.isIndexSelected=function(e){return this.getSelectedIndices().indexOf(e)!==-1};l.prototype.removeSelectionInterval=function(e,t){if(this.oSelectionModel){this.oSelectionModel.removeSelectionInterval(e,t)}};l.prototype.selectAll=function(){if(!this.oSelectionModel||this.getSelectionMode()!==n.MultiToggle){return}this.oSelectionModel.selectAll(this._getHighestSelectableIndex())};l.prototype.setSelectedIndex=function(e){if(this.getSelectionMode()===n.None){return}if(e===-1){this.clearSelection()}else{this.setSelectionInterval(e,e)}};l.prototype.setSelectionInterval=function(e,t){if(!this.oSelectionModel||this.getSelectionMode()===n.None){return}this.oSelectionModel.setSelectionInterval(e,t)};l.prototype.setSelectionMode=function(e){var t=this.getSelectionMode();this.setProperty("selectionMode",e);if(this.getSelectionMode()!==t){this.clearSelection()}if(this.oSelectionModel){this.oSelectionModel.setSelectionMode(c(this.getSelectionMode()))}return this};function c(t){return t===n.MultiToggle?e.MULTI_SELECTION:e.SINGLE_SELECTION}l.prototype._getHighestSelectableIndex=function(){var e=this.getTableBinding();return e?e.getLength()-1:-1};l.prototype.onTableRowsBound=function(e){t.prototype.onTableRowsBound.apply(this,arguments);a(this,e)};l.prototype.onTableUnbindRows=function(){t.prototype.onTableUnbindRows.apply(this,arguments);this._bSuppressSelectionChangeEvent=true;this.clearSelection();delete this._bSuppressSelectionChangeEvent};function s(e){var t=e.getParameter("rowIndices");var o=e.getParameter("selectAll");if(!this._bSuppressSelectionChangeEvent){this.fireSelectionChange({rowIndices:t,selectAll:o,_internalTrigger:this._bInternalTrigger})}}function a(e,t){if(t){t.attachChange(h,e)}}function d(e,t){if(t){t.detachChange(h,e)}}function h(e){var t=typeof e==="object"?e.getParameter("reason"):e;if(t==="sort"||t==="filter"){this.clearSelection()}}function S(){var e=this.getTable()._getTotalRowCount();if(this._iTotalRowCount>0&&this._iTotalRowCount!==e){this._bInternalTrigger=true;this.clearSelection();delete this._bInternalTrigger}this._iTotalRowCount=e}return l});
//# sourceMappingURL=SelectionModelSelection.js.map