/*
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["../utils/TableUtils","./RowMode","sap/ui/Device","sap/ui/thirdparty/jquery"],function(t,e,o,jQuery){"use strict";var i=t.createWeakMapFacade();var a=e.extend("sap.ui.table.rowmodes.Auto",{metadata:{library:"sap.ui.table",properties:{minRowCount:{type:"int",defaultValue:5,group:"Appearance"},maxRowCount:{type:"int",defaultValue:-1,group:"Appearance"},fixedTopRowCount:{type:"int",defaultValue:0,group:"Appearance"},fixedBottomRowCount:{type:"int",defaultValue:0,group:"Appearance"},rowContentHeight:{type:"int",defaultValue:0,group:"Appearance"},hideEmptyRows:{type:"boolean",defaultValue:false,group:"Appearance",visibility:"hidden"}}},constructor:function(t){Object.defineProperty(this,"bLegacy",{value:typeof t==="boolean"?t:false});e.apply(this,arguments)}});var s={};function n(t){var e=t.getTable();var i=e?e.getDomRef("tableCCnt"):null;if(i&&o.browser.chrome&&window.devicePixelRatio!==1){var a=document.createElement("table");var s=a.insertRow();var n=t.getRowContentHeight();var r;a.classList.add("sapUiTableCtrl");s.classList.add("sapUiTableTr");if(n>0){s.style.height=t.getBaseRowHeightOfTable()+"px"}i.appendChild(a);r=s.getBoundingClientRect().height;i.removeChild(a);return r}else{return t.getBaseRowHeightOfTable()}}a.prototype.init=function(){e.prototype.init.apply(this,arguments);i(this).iPendingStartTableUpdateSignals=0;i(this).bRowCountAutoAdjustmentActive=false;i(this).iLastAvailableSpace=0;i(this).rowCount=-1;i(this).bTableIsFlexItem=false;i(this).adjustRowCountToAvailableSpaceAsync=t.throttleFrameWise(this.adjustRowCountToAvailableSpace.bind(this))};a.prototype.attachEvents=function(){e.prototype.attachEvents.apply(this,arguments);t.addDelegate(this.getTable(),s,this)};a.prototype.detachEvents=function(){e.prototype.detachEvents.apply(this,arguments);t.removeDelegate(this.getTable(),s)};a.prototype.cancelAsyncOperations=function(){e.prototype.cancelAsyncOperations.apply(this,arguments);this.stopAutoRowMode()};a.prototype.registerHooks=function(){e.prototype.registerHooks.apply(this,arguments);t.Hook.register(this.getTable(),t.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this);t.Hook.register(this.getTable(),t.Hook.Keys.Table.UpdateSizes,this._onUpdateTableSizes,this)};a.prototype.deregisterHooks=function(){e.prototype.deregisterHooks.apply(this,arguments);t.Hook.deregister(this.getTable(),t.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this);t.Hook.deregister(this.getTable(),t.Hook.Keys.Table.UpdateSizes,this._onUpdateTableSizes,this)};a.prototype.getFixedTopRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getFixedRowCount():0}return this.getProperty("fixedTopRowCount")};a.prototype.getFixedBottomRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getFixedBottomRowCount():0}return this.getProperty("fixedBottomRowCount")};a.prototype.getMinRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getMinAutoRowCount():0}return this.getProperty("minRowCount")};a.prototype.getRowContentHeight=function(){if(this.bLegacy){var t=this.getTable();return t?t.getRowHeight():0}return this.getProperty("rowContentHeight")};a.prototype.setHideEmptyRows=function(t){this.setProperty("hideEmptyRows",t);if(t){this.disableNoData()}else{this.enableNoData()}return this};a.prototype.getHideEmptyRows=function(){return this.getProperty("hideEmptyRows")};a.prototype._getMinRowCount=function(){var t=this.getMinRowCount();var e=this.getMaxRowCount();if(e>=0){return Math.min(t,e)}else{return t}};a.prototype.getMinRequestLength=function(){var e=this.getTable();var i=this.getConfiguredRowCount();if(u(this)||e&&!e._bContextsAvailable){var a=Math.ceil(o.resize.height/t.DefaultRowHeight.sapUiSizeCondensed);i=Math.max(i,a)}return i};a.prototype.updateTable=function(){if(this.getHideEmptyRows()&&this.getComputedRowCounts().count===0){var t=this.getConfiguredRowCount();if(t>0){this.getRowContexts(t)}}return e.prototype.updateTable.apply(this,arguments)};a.prototype.getComputedRowCounts=function(){if(u(this)){return{count:0,scrollable:0,fixedTop:0,fixedBottom:0}}var t=this.getConfiguredRowCount();var e=this.getFixedTopRowCount();var o=this.getFixedBottomRowCount();if(this.getHideEmptyRows()){t=Math.min(t,this.getTotalRowCountOfTable())}return this.computeStandardizedRowCounts(t,e,o)};a.prototype.getTableStyles=function(){var t="0px";if(u(this)){t="auto"}else{var e=this.getConfiguredRowCount();if(e===0||e===this._getMinRowCount()){t="auto"}}return{height:t}};a.prototype.getTableBottomPlaceholderStyles=function(){if(!this.getHideEmptyRows()){return undefined}var t;if(u(this)){t=this._getMinRowCount()}else{t=this.getConfiguredRowCount()-this.getComputedRowCounts().count}return{height:t*this.getBaseRowHeightOfTable()+"px"}};a.prototype.getRowContainerStyles=function(){return{height:this.getComputedRowCounts().count*Math.max(this.getBaseRowHeightOfTable(),n(this))+"px"}};a.prototype.renderRowStyles=function(t){var e=this.getRowContentHeight();if(e>0){t.style("height",this.getBaseRowHeightOfTable()+"px")}};a.prototype.renderCellContentStyles=function(t){var e=this.getRowContentHeight();if(this.bLegacy){if(e>0){t.style("max-height",e+"px")}return}if(e<=0){e=this.getDefaultRowContentHeightOfTable()}if(e>0){t.style("max-height",e+"px")}};a.prototype.getBaseRowContentHeight=function(){return Math.max(0,this.getRowContentHeight())};a.prototype._onTableRefreshRows=function(){var t=this.getConfiguredRowCount();if(t>0){if(!u(this)){this.initTableRowsAfterDataRequested(t)}this.getRowContexts(t)}};a.prototype.getConfiguredRowCount=function(){var t=Math.max(0,this.getMinRowCount(),i(this).rowCount);var e=this.getMaxRowCount();if(e>=0){t=Math.min(t,e)}return t};a.prototype.startAutoRowMode=function(){i(this).adjustRowCountToAvailableSpaceAsync(t.RowsUpdateReason.Render,true)};a.prototype.stopAutoRowMode=function(){this.deregisterResizeHandler();i(this).adjustRowCountToAvailableSpaceAsync.cancel();i(this).bRowCountAutoAdjustmentActive=false;l(this)};a.prototype.registerResizeHandler=function(e){var o=this.getTable();if(o){t.registerResizeHandler(o,"AutoRowMode",this.onResize.bind(this),null,e===true);t.registerResizeHandler(o,"AutoRowMode-BeforeTable",this.onResize.bind(this),"before");t.registerResizeHandler(o,"AutoRowMode-AfterTable",this.onResize.bind(this),"after")}};a.prototype.deregisterResizeHandler=function(){var e=this.getTable();if(e){t.deregisterResizeHandler(e,["AutoRowMode, AutoRowMode-BeforeTable, AutoRowMode-AfterTable"])}};a.prototype.onResize=function(e){var o=e.oldSize.height;var a=e.size.height;if(o!==a){r(this);i(this).adjustRowCountToAvailableSpaceAsync(t.RowsUpdateReason.Resize)}};a.prototype._onUpdateTableSizes=function(e){if(e===t.RowsUpdateReason.Resize||e===t.RowsUpdateReason.Render){return}if(i(this).bRowCountAutoAdjustmentActive){r(this);i(this).adjustRowCountToAvailableSpaceAsync(e)}};a.prototype.adjustRowCountToAvailableSpace=function(e,o){o=o===true;var a=this.getTable();var s=a?a.getDomRef():null;if(!a||a._bInvalid||!s||!sap.ui.getCore().isThemeApplied()){l(this);return}i(this).bTableIsFlexItem=window.getComputedStyle(s.parentNode).display==="flex";if(s.scrollHeight===0){if(o){this.registerResizeHandler(!i(this).bTableIsFlexItem);i(this).bRowCountAutoAdjustmentActive=true}l(this);return}var r=this.determineAvailableSpace();var u=this.getConfiguredRowCount();var h=Math.floor(r/n(this));var p=this.getComputedRowCounts().count;var g;i(this).rowCount=h;g=this.getComputedRowCounts().count;if(this.bLegacy){a.setProperty("visibleRowCount",g,true)}if(p!==g){this.updateTable(e)}else{if(u!==h||e===t.RowsUpdateReason.Zoom){this.applyTableStyles();this.applyRowContainerStyles();this.applyTableBottomPlaceholderStyles()}if(!this._bFiredRowsUpdatedAfterRendering&&a.getRows().length>0){this.fireRowsUpdated(e)}}if(o){this.registerResizeHandler(!i(this).bTableIsFlexItem);i(this).bRowCountAutoAdjustmentActive=true}l(this)};a.prototype.determineAvailableSpace=function(){var t=this.getTable();var e=t?t.getDomRef():null;var a=t?t.getDomRef("tableCCnt"):null;var s=t?t.getDomRef("placeholder-bottom"):null;if(!e||!a||!e.parentNode){return 0}var n=0;var r=a.clientHeight;var l=s?s.clientHeight:0;if(i(this).bTableIsFlexItem){var u=e.childNodes;for(var h=0;h<u.length;h++){n+=u[h].offsetHeight}n-=r-l}else{n=e.scrollHeight-r-l}var p=t._getScrollExtension();if(!p.isHorizontalScrollbarVisible()){var g={};g[o.browser.BROWSER.CHROME]=16;g[o.browser.BROWSER.FIREFOX]=16;g[o.browser.BROWSER.SAFARI]=16;g[o.browser.BROWSER.ANDROID]=8;n+=g[o.browser.name]}var d=i(this).bTableIsFlexItem?e:e.parentNode;var R=Math.max(0,Math.floor(jQuery(d).height()-n));var f=Math.abs(R-i(this).iLastAvailableSpace);if(f>=5){i(this).iLastAvailableSpace=R}return i(this).iLastAvailableSpace};s.onBeforeRendering=function(t){var e=t&&t.isMarked("renderRows");if(!e){this.stopAutoRowMode()}};s.onAfterRendering=function(t){var e=t&&t.isMarked("renderRows");if(!e){this.startAutoRowMode()}};function r(e){i(e).iPendingStartTableUpdateSignals++;t.Hook.call(e.getTable(),t.Hook.Keys.Signal,"StartTableUpdate")}function l(e){for(var o=0;o<i(e).iPendingStartTableUpdateSignals;o++){t.Hook.call(e.getTable(),t.Hook.Keys.Signal,"EndTableUpdate")}i(e).iPendingStartTableUpdateSignals=0}function u(t){return i(t).rowCount===-1}return a});
//# sourceMappingURL=Auto.js.map