/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
(function(e){"use strict";var t;if(e.module){t=e.module;e.module=undefined}sap.ui.define(["sap/base/util/extend","sap/base/util/ObjectPath","sap/ui/thirdparty/jquery","sap/ui/Global","sap/ui/base/Object","sap/ui/core/Element","sap/ui/core/StaticArea","sap/ui/core/mvc/View","sap/ui/test/matchers/Ancestor","sap/ui/test/matchers/MatcherFactory","sap/ui/test/pipelines/MatcherPipeline","sap/ui/test/_OpaLogger"],function(e,t,i,n,r,o,l,s,a,u,g,c){var d=r.extend("sap.ui.test.OpaPlugin",{constructor:function(){r.call(this);this._oLogger=c.getLogger("sap.ui.test.Opa5");this._oMatcherFactory=new u},getAllControls:function(e,t){var i=o.registry.filter(h(e));this._oLogger.debug("Found "+i.length+" controls"+(e?" of type '"+(t||e)+"'":"")+" in page");return i},getView:function(e){var t=this.getAllControls(s,"View");var i=t.filter(function(t){return t.getViewName()===e});this._oLogger.debug("Found "+i.length+" views with viewName '"+e+"'");if(i.length>1){i=i.filter(function(e){var t=e.$();return t.length>0&&t.is(":visible")&&t.css("visibility")!=="hidden"});this._oLogger.debug("Found "+i.length+" visible views with viewName '"+e+"'");if(i.length!==1){this._oLogger.debug("Cannot identify controls uniquely. Please provide viewId to locate the exact view.");i=[]}}return i[0]},_getMatchingView:function(e){var t=null;var i;if(e.viewName){var n=(e.viewNamespace||"")+"."+(e.viewName||"");i=n.replace(/\.+/g,".").replace(/^\.|\.$/g,"")}if(e.viewId){var r=o.getElementById(e.viewId);if(r instanceof s&&(!i||r.getViewName()===i)){t=r}}else{t=this.getView(i)}this._oLogger.debug("Found "+(t?"":"no ")+"view with ID '"+e.viewId+"' and viewName '"+i+"'");return t},getControlInView:function(e){var t=typeof e.id==="string",i;if(e.viewName||e.viewId){i=this._getMatchingView(e)}if(!i){return t?null:[]}var n=i.getViewName();var r=e.fragmentId?e.fragmentId+d.VIEW_ID_DELIMITER:"";if(Array.isArray(e.id)){var o=[];var l=[];e.id.map(function(e){return r+e}).forEach(function(e){var t=i.byId(e);if(t){o.push(t)}else{l.push(e)}});this._oLogger.debug("Found "+o.length+" controls with ID contained in "+e.id+" in view '"+n+"'"+l.length?". Found no controls matching the subset of IDs "+l:"");if(o.length&&e.controlType){var s=this._filterUniqueControlsByCondition(o,h(e.controlType));this._oLogger.debug("Found "+(s.length?s.length:"no")+" controls in view '"+n+"' with control type matching '"+e.sOriginalControlType+"' and ID contained in "+e.id);if(s.length!==o.length){this._oLogger.error("Some results don't match the desired controlType '"+e.sOriginalControlType+"'. Please double check the expected controlType - this might lead to unexpected test results!")}}return o}if(t){var a=r+e.id;var u=i.byId(a)||null;if(u){if(h(e.controlType)(u)){this._oLogger.debug("Found control with ID '"+a+"' and controlType '"+e.sOriginalControlType+"' in view '"+n+"'")}else{this._oLogger.error("Found control with ID '"+a+"' in view '"+n+"' but it does not have required controlType '"+e.sOriginalControlType+"'. Please double check the expected controlType - this might lead to unexpected test results!")}return u}else{this._oLogger.debug("Found no control with ID '"+a+"' in view '"+n+"'");return u}}var g=this.getAllControlsWithTheParent(i,e.controlType,e.sOriginalControlType);var c=this._isRegExp(e.id);if(c){g=g.filter(function(t){var n=this._getUnprefixedControlId(t.getId(),i.getId(),e.fragmentId);return e.id.test(n)}.bind(this))}this._oLogger.debug("Found "+g.length+" controls of type "+e.sOriginalControlType+(c?" with ID matching "+e.id:"")+" in view '"+n+"'");return g},getAllControlsWithTheParent:function(e,t,i){var n=new a(e);return this._filterUniqueControlsByCondition(this.getAllControls(t,i),n)},getAllControlsInContainer:function(e,t,i,n){var r=h(t),o=this._filterUniqueControlsByCondition(this._getControlsInContainer(e),r);this._oLogger.debug("Found "+o.length+" controls in "+(n?n:"container")+" with controlType '"+i+"'");return o},_getControlsInStaticArea:function(e){var t=i(l.getDomRef());var n=this._getControlsInContainer(t)||[];if(e.id){n=this._filterUniqueControlsByCondition(n,function(t){var i=t.getId(),n;if(e.viewName||e.viewId){n=this._getMatchingView(e)}if(n){if(this._isControlInView(t,n.getViewName())){i=this._getUnprefixedControlId(t.getId(),n.getId(),e.fragmentId)}}var r=false;if(typeof e.id==="string"){r=i===e.id}if(this._isRegExp(e.id)){r=e.id.test(i)}if(Array.isArray(e.id)){r=e.id.filter(function(e){return e===i}).length>0}return r}.bind(this));this._oLogger.debug("Found "+(n.length?n.length:"no")+" controls in the static area with ID matching '"+e.id+"'"+(e.fragmentId?" and fragmentId: '"+e.fragmentId+"'":""))}if(n.length&&e.controlType){var r=h(e.controlType);n=this._filterUniqueControlsByCondition(n,r);this._oLogger.debug("Found "+(n.length?n.length:"no")+" controls in the static area with control type matching '"+e.sOriginalControlType+"'")}if(e.id&&typeof e.id==="string"){return n[0]||null}else{return n}},_getControlsInContainer:function(e){var t=e.find("*").control();var i=[];t.forEach(function(e){var t=!i.filter(function(t){return t.getId()===e.getId()}).length;if(t){i.push(e)}});return i},_isControlInView:function(e,t){if(!e){return false}if(e.getViewName&&e.getViewName()===t){return true}else{return this._isControlInView(e.getParent(),t)}},_isRegExp:function(e){return Object.prototype.toString.call(e)==="[object RegExp]"},getMatchingControls:function(e){var t=null;e=e||{};var i=this._modifyControlType(e);if(!i){return typeof e.id==="string"?t:[]}if(e.searchOpenDialogs){t=this._getControlsInStaticArea(e)}else if(e.viewName||e.viewId){t=this.getControlInView(e)}else if(e.id){t=this.getControlByGlobalId(e)}else if(e.controlType){t=this.getAllControls(e.controlType,e.sOriginalControlType)}else{t=this.getAllControls()}if(!t){return t}var n=this._oMatcherFactory.getStateMatchers({visible:e.visible,interactable:e.interactable,enabled:typeof e.enabled==="undefined"?e.interactable:e.enabled,editable:typeof e.editable==="undefined"?false:e.editable});var r=d._oMatcherPipeline.process({control:t,matchers:n});if(!r){if(Array.isArray(t)){return[]}if(t){return null}return t}return r},_getFilteredControls:function(t){var i=this._filterControlsByCondition(t);var n=e({},t);["interactable","visible","enabled","editable"].forEach(function(e){delete n[e]});return i===d.FILTER_FOUND_NO_CONTROLS?d.FILTER_FOUND_NO_CONTROLS:this._filterControlsByMatchers(n,i)},_filterControlsByCondition:function(e){var t=null;var i=this._isLookingForAControl(e);if(i){t=this.getMatchingControls(e)}var n=[typeof e.id==="string"&&!t,this._isRegExp(e.id)&&!t.length,Array.isArray(e.id)&&(!t||t.length!==e.id.length),e.controlType&&Array.isArray(t)&&!t.length,!e.id&&(e.viewName||e.viewId||e.searchOpenDialogs)&&!t.length];return n.some(Boolean)?d.FILTER_FOUND_NO_CONTROLS:t},_filterControlsByMatchers:function(t,i){var n=e({},t);var r=this._oMatcherFactory.getFilteringMatchers(n);var o=this._isLookingForAControl(t);var l=null;if((i||!o)&&r.length){l=d._oMatcherPipeline.process({matchers:r,control:i});if(!l){return d.FILTER_FOUND_NO_CONTROLS}}else{l=i}return l},getControlByGlobalId:function(e){var t=h(e.controlType);if(typeof e.id==="string"){var i=o.getElementById(e.id)||null;if(i&&!t(i)){this._oLogger.error("A control with global ID '"+e.id+"' is found but does not have required controlType '"+e.sOriginalControlType+"'. Found control is '"+i+"' but null is returned instead");return null}this._oLogger.debug("Found "+(i?"":"no ")+"control with the global ID '"+e.id+"'");return i}var n=[];var r=this._isRegExp(e.id);if(r){o.registry.forEach(function(t,i){if(e.id.test(i)){n.push(i)}})}else if(Array.isArray(e.id)){n=e.id}var l=[];var s=[];n.forEach(function(e){var i=o.getElementById(e);if(i&&t(i)&&!i.bIsDestroyed){l.push(i)}else{s.push(e)}});var a=!r&&s.length?". Found no controls of matching the subset of IDs "+s:"";this._oLogger.debug("Found "+l.length+" controls of type "+e.sOriginalControlType+(r?" with ID matching '":" with ID contained in '")+e.id+a);return l},getControlConstructor:function(e){var i=e.replace(/\./g,"/");var r=sap.ui.require(i);if(r==null){if(n.lazyRequire._isStub(e)){this._oLogger.debug("The control type "+e+" is currently a lazy stub.");return null}r=t.get(e);if(typeof r==="function"){this._oLogger.debug("The control type "+e+" could only be retrieved via global name.")}}if(!r){this._oLogger.debug("The control type "+e+" is undefined.");return null}if(typeof r!=="function"){this._oLogger.debug("The control type "+e+" must be a function.");return null}return r},_isLookingForAControl:function(e){return Object.keys(e).some(function(t){return d._aControlSelectorsForMatchingControls.indexOf(t)!==-1&&!!e[t]})},_filterUniqueControlsByCondition:function(e,t){return e.filter(function(e,i,n){var r=!!t(e);return r&&n.indexOf(e)===i})},_modifyControlType:function(e){var t=e.controlType;if(typeof t!=="string"){if(t&&t._sapUiLazyLoader){this._oLogger.debug("The control type is currently a lazy stub");return false}return true}var i=this.getControlConstructor(t);if(!i){return false}e.sOriginalControlType=t;e.controlType=i;return true},_getUnprefixedControlId:function(e,t,i){var n=e.replace(t+d.VIEW_ID_DELIMITER,"");if(i){if(n.startsWith(i+d.VIEW_ID_DELIMITER)){n=n.replace(i+d.VIEW_ID_DELIMITER,"")}else{n=""}}return n}});function h(e){return function(t){if(!e){return true}return t instanceof e}}d._oMatcherPipeline=new g;d._aControlSelectorsForMatchingControls=["id","viewName","viewId","controlType","searchOpenDialogs"];d.FILTER_FOUND_NO_CONTROLS="FILTER_FOUND_NO_CONTROL";d.VIEW_ID_DELIMITER="--";return d});if(t){e.module=t}})(window);
//# sourceMappingURL=OpaPlugin.js.map