/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/Object","sap/base/util/extend","sap/ui/testrecorder/CommunicationBus","sap/ui/testrecorder/CommunicationChannels","sap/ui/testrecorder/mutationObservers/AppMutationObserver","sap/ui/testrecorder/mutationObservers/ElementMutationObserver","sap/ui/support/supportRules/ui/external/Highlighter","sap/ui/test/_ControlFinder","sap/ui/testrecorder/inspector/ControlAPI","sap/ui/testrecorder/inspector/ControlInspectorRepo","sap/ui/testrecorder/Constants","sap/ui/testrecorder/DialectRegistry","sap/ui/testrecorder/Dialects","sap/ui/testrecorder/controlSelectors/ControlSelectorGenerator","sap/ui/testrecorder/codeSnippets/POMethodUtil","sap/ui/testrecorder/codeSnippets/RawSnippetUtil","sap/ui/testrecorder/codeSnippets/CodeSnippetProvider","sap/ui/testrecorder/ui/models/SharedModel"],function(e,t,i,r,s,n,o,p,a,l,c,d,u,h,g,E,b,C){"use strict";var S=null;var f=new o(c.HIGHLIGHTER_ID);var m=Object.assign({},C.getData().settings);var I=e.extend("sap.ui.testrecorder.inspector.ControlInspector",{constructor:function(){if(!S){e.apply(this,arguments);this._appObserver=new s(this.getAllControlData.bind(this));this._selectedElementObserver=new n(this.getControlData.bind(this))}else{return S}}});I.prototype.init=function(){this._appObserver.start();i.subscribe(r.REQUEST_ALL_CONTROLS_DATA,this.getAllControlData.bind(this));i.subscribe(r.REQUEST_CONTROL_DATA,this.getControlData.bind(this));i.subscribe(r.REQUEST_CODE_SNIPPET,this.getCodeSnippet.bind(this));i.subscribe(r.HIGHLIGHT_CONTROL,this.highlightControl.bind(this));i.subscribe(r.SET_DIALECT,this.setDialect.bind(this));i.subscribe(r.UPDATE_SETTINGS,this.updateSettings.bind(this));i.subscribe(r.CLEAR_SNIPPETS,this.clearSnippets.bind(this))};I.prototype.getAllControlData=function(){i.publish(r.RECEIVE_ALL_CONTROLS_DATA,{renderedControls:a.getAllControlData().renderedControls,framework:a.getFrameworkData().framework});l.clear()};I.prototype.getControlData=function(e){var t=e.domElementId?document.getElementById(e.domElementId):sap.ui.getCore().byId(e.controlId).getDomRef();this._selectedElementObserver.stop();this._selectedElementObserver.start(t);var s=a.getControlData(e);i.publish(r.RECEIVE_CONTROL_DATA,s)};I.prototype.getCodeSnippet=function(e){var s=Object.assign({},e,{settings:m});var n=l.findSelector(e.domElementId);var o=n?Promise.resolve(n):h.getSelector(s);return o.then(function(e){n=e;return b.getSnippet({controlSelector:e,action:s.action,assertion:s.assertion,settings:m})}).then(function(i){l.save(e,n,i);var r=m.multipleSnippets?l.getSnippets():[i];if(d.getActiveDialect()===u.RAW){return E.getJSON(r,m)}else{return g.getPOMethod(r,t({action:e.action,assertion:e.assertion},m),d.getActiveDialect()===u.WDI5)}}).then(function(e){i.publish(r.RECEIVE_CODE_SNIPPET,{codeSnippet:e})}).catch(function(t){i.publish(r.RECEIVE_CODE_SNIPPET,{error:"Could not generate code snippet for "+JSON.stringify(e)+". Details: "+t,domElementId:s.domElementId})})};I.prototype.highlightControl=function(e){if(e.domElementId){f.highlight(e.domElementId)}else if(e.controlId){var t=p._findElements({id:e.controlId})[0];if(t){f.highlight(t.id)}}};I.prototype.setDialect=function(e){if(d.getActiveDialect()!==e){d.setActiveDialect(e);i.publish(r.DIALECT_CHANGED,{dialect:e});l.getRequests().forEach(this.getCodeSnippet.bind(this))}};I.prototype.updateSettings=function(e){Object.assign(m,e);var t=l.getRequests();if(D(e,"multipleSnippets")){this.clearSnippets();if(t.length){this.getCodeSnippet(t[t.length-1])}}if(D(e,["preferViewId"])){l.clear()}if(D(e,["formatAsPOMethod","preferViewId"])){if(m.multipleSnippets){t.forEach(this.getCodeSnippet.bind(this))}else if(t.length){this.getCodeSnippet(t[t.length-1])}}};I.prototype.clearSnippets=function(){l.clear();i.publish(r.RECEIVE_CODE_SNIPPET,{codeSnippet:""})};I.prototype.stop=function(){this._appObserver.stop();this._selectedElementObserver.stop()};function D(e,t){var i=Array.isArray(t)?t:[t];return i.filter(function(t){return e[t]!==null&&e[t]!==undefined}).length}S=new I;return S},true);
//# sourceMappingURL=ControlInspector.js.map