/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/Popover","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/LocaleData","sap/ui/unified/calendar/CalendarUtils","./calendar/Header","./calendar/TimesRow","./calendar/DatesRow","./calendar/MonthPicker","./calendar/YearPicker","sap/ui/core/date/UniversalDate","./library","sap/ui/core/format/DateFormat","sap/ui/Device","sap/ui/core/Locale","./CalendarTimeIntervalRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/base/Log","sap/ui/unified/DateRange","sap/ui/core/date/UI5Date","sap/ui/unified/Calendar"],function(e,t,a,i,s,r,o,n,h,g,l,c,u,D,_,d,f,p,T,v,C,M){"use strict";var m=a.extend("sap.ui.unified.CalendarTimeInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},items:{type:"int",group:"Appearance",defaultValue:12},intervalMinutes:{type:"int",group:"Appearance",defaultValue:60},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},_currentPicker:{type:"string",group:"Appearance",defaultValue:"timesRow",visibility:"hidden"}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},timesRow:{type:"sap.ui.unified.calendar.TimesRow",multiple:false,visibility:"hidden"},datesRow:{type:"sap.ui.unified.calendar.Month",multiple:false,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}},renderer:d});var U={TIMES_ROW:"timesRow",DATES_ROW:"datesRow",MONTH_PICKER:"monthPicker",YEAR_PICKER:"yearPicker"};m.prototype.init=function(){this._iMode=0;this._oYearFormat=u.getDateInstance({format:"y"});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=new l(C.getInstance(Date.UTC(1,0,1)));this._oMinDate.getJSDate().setUTCFullYear(1);this._oMaxDate=new l(C.getInstance(Date.UTC(9999,11,31,23,59,59)));this._initializeHeader();this._initializeTimesRow();this._initializeMonthPicker();this._initializeYearPicker();this.setPickerPopup(false);this._iItemsHead=15};m.prototype._initializeHeader=function(){var e=new r(this.getId()+"--Head"),a=t.getLibraryResourceBundle("sap.m");e.attachEvent("pressPrevious",this._handlePrevious,this);e.attachEvent("pressNext",this._handleNext,this);this.setAggregation("header",e);if(e){e.setAriaLabelButton0(a.getText("DATETIMEPICKER_DATE"));e.setAriaLabelButton1(a.getText("MOBISCROLL_MONTH"));e.setAriaLabelButton2(a.getText("MOBISCROLL_YEAR"))}};m.prototype._initializeTimesRow=function(){var e=new o(this.getId()+"--TimesRow");e.attachEvent("focus",V,this);e.attachEvent("select",N,this);e._bNoThemeChange=true;this.setAggregation("timesRow",e)};m.prototype._initializeMonthPicker=function(){var e=this._createMonthPicker();this.setAggregation("monthPicker",e);e._setSelectedDatesControlOrigin(this)};m.prototype._initializeYearPicker=function(){var e=this._createYearPicker();this.setAggregation("yearPicker",e);e._setSelectedDatesControlOrigin(this)};m.prototype._createDatesRow=function(){var e=new n(this.getId()+"--DatesRow",{days:18,selectedDates:[new v(this.getId()+"--Range")]});e.attachEvent("focus",W,this);e.attachEvent("select",z,this);e._bNoThemeChange=true;e.getIntervalSelection=function(){return this.getProperty("intervalSelection")};e.getSingleSelection=function(){return this.getProperty("singleSelection")};e.getSelectedDates=function(){return this.getAggregation("selectedDates",[])};e.getSpecialDates=function(){return this.getAggregation("specialDates",[])};e.getAriaLabelledBy=function(){return this.getAssociation("ariaLabelledBy",[])};return e};m.prototype._createMonthPicker=function(){var e=new h(this.getId()+"--MP",{columns:0,months:6});e.attachEvent("select",j,this);e._bNoThemeChange=true;e.attachEvent("pageChange",Q,this);return e};m.prototype._createYearPicker=function(){var e=new g(this.getId()+"--YP",{columns:0,years:6});e.attachEvent("select",K,this);e.attachEvent("pageChange",Z,this);e._oMinDate.setYear(this._oMinDate.getUTCFullYear());e._oMaxDate.setYear(this._oMaxDate.getUTCFullYear());return e};m.prototype.exit=function(){if(this._oPopup){this._oPopup.destroy();this._oPopup=null}if(this._oCalendar){this._oCalendar.removeDelegate(this._oFocusCalendarDelegate);this._oCalendar.destroy();this._oCalendar=null}if(this._sInvalidateContent){clearTimeout(this._sInvalidateContent)}};m.prototype.onBeforeRendering=function(){var e=this.getAggregation("timesRow");var t=this._getFocusedDate();x.call(this);e.displayDate(s._createLocalDate(t,true))};m.prototype._setAriaRole=function(e){var t=this.getAggregation("timesRow");t._setAriaRole(e);t.invalidate();return this};m.prototype._getCalendar=function(){var e;if(!this._oCalendar){e=new M(this.getId()+"--Cal",{});e.attachEvent("select",H,this);e.attachEvent("cancel",function(e){this._oPopup.close();var t=this.getAggregation("header").getDomRef("B1");if(t){t.focus()}},this);this._oFocusCalendarDelegate={onAfterRendering:function(){this.focus()}};e.addDelegate(this._oFocusCalendarDelegate,e);this._oCalendar=e}return this._oCalendar};m.prototype._getMonthPicker=function(){return this.getAggregation("monthPicker")};m.prototype._getYearPicker=function(){return this.getAggregation("yearPicker")};m.prototype.setStartDate=function(e){s._checkJSDateObject(e);if(p(this.getStartDate(),e)){return this}var t=e.getFullYear();s._checkYearInValidRange(t);var a=this.getMinDate();if(a&&e.getTime()<a.getTime()){T.warning("startDate < minDate -> minDate as startDate set",this);e=C.getInstance(a)}var i=this.getMaxDate();if(i&&e.getTime()>i.getTime()){T.warning("startDate > maxDate -> maxDate as startDate set",this);e=C.getInstance(i)}this.setProperty("startDate",e);var r=this.getAggregation("timesRow");r.setStartDate(e);this._oUTCStartDate=new l(r._getStartDate().getTime());x.call(this);var o=s._createLocalDate(this._getFocusedDate(),true);if(!r.checkDateFocusable(o)){this._setFocusedDate(this._oUTCStartDate);r.displayDate(e)}return this};m.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var e=this.removeAllAggregation("selectedDates");return e};m.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var e=this.destroyAggregation("selectedDates");return e};m.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var e=this.removeAllAggregation("specialDates");return e};m.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var e=this.destroyAggregation("specialDates");return e};m.prototype.setIntervalMinutes=function(e){if(e>=720){throw new Error("Only intervals < 720 minutes are allowed; "+this)}if(1440%e>0){throw new Error("A day must be divisible by the interval size; "+this)}this.setProperty("intervalMinutes",e);var t=this.getAggregation("timesRow");var a=s._createLocalDate(this._getFocusedDate(),true);if(!t.checkDateFocusable(a)){var i=y.call(this);this._setFocusedDate(i);t.setDate(s._createLocalDate(i,true))}return this};m.prototype.setLocale=function(e){if(this._sLocale!=e){this._sLocale=e;this._oLocaleData=undefined;this.invalidate()}return this};m.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=t.getConfiguration().getFormatSettings().getFormatLocale().toString()}return this._sLocale};m.prototype._getFocusedDate=function(){if(!this._oFocusedDate){k.call(this)}return this._oFocusedDate};m.prototype._setFocusedDate=function(e){if(!(e instanceof l)){throw new Error("Date must be a UniversalDate object "+this)}this._oFocusedDate=new l(e.getTime())};m.prototype.focusDate=function(e){var t=false;var a=this.getAggregation("timesRow");if(!a.checkDateFocusable(e)){var i=s._createUniversalUTCDate(e,undefined,true);$.call(this,i);t=true}L.call(this,e,false);if(t){this.fireStartDateChange()}return this};m.prototype.displayDate=function(e){L.call(this,e,true);return this};m.prototype.setItems=function(e){this.setProperty("items",e);e=this._getItems();var t=this.getAggregation("timesRow");t.setItems(e);var a=s._createLocalDate(this._getFocusedDate(),true);if(!t.checkDateFocusable(a)){var i=y.call(this);this._setFocusedDate(i);t.setDate(s._createLocalDate(i,true))}if(!this.getPickerPopup()){var r=this.getAggregation("datesRow");var o=Math.floor(e*1.5);if(o>31){o=31}r.setDays(o);var n=this._getMonthPicker();var h=Math.floor(e/2);if(h>12){h=12}n.setMonths(h);var g=this._getYearPicker();var l=Math.floor(e/2);if(l>20){l=20}g.setYears(l)}x.call(this);return this};m.prototype._getItems=function(){var e=this.getItems();if(D.system.phone&&e>6){return 6}else{return e}};m.prototype._getLocaleData=function(){if(!this._oLocaleData){var e=this.getLocale();var t=new _(e);this._oLocaleData=i.getInstance(t)}return this._oLocaleData};m.prototype.setPickerPopup=function(e){var t=this.getAggregation("header"),a,i,s;this.setProperty("pickerPopup",e);if(a){a.destroy()}if(e){t.setVisibleButton0(false);t.setVisibleButton1(true);t.setVisibleButton2(false);t.detachEvent("pressButton1",J,this);t.attachEvent("pressButton1",J,this);if(this.getAggregation("datesRow")){this.getAggregation("datesRow").destroy()}if(this._getMonthPicker()){this._getMonthPicker().destroy()}if(this._getYearPicker()){this._getYearPicker().destroy()}}else{t.setVisibleButton0(true);t.setVisibleButton1(true);t.setVisibleButton2(true);t.detachEvent("pressButton0",O,this);t.attachEvent("pressButton0",O,this);t.detachEvent("pressButton1",J,this);t.attachEvent("pressButton1",J,this);t.detachEvent("pressButton2",B,this);t.attachEvent("pressButton2",B,this);if(!this.getAggregation("datesRow")){this.setAggregation("datesRow",this._createDatesRow())}if(!this._getYearPicker()){this.setAggregation("yearPicker",this._createYearPicker())}if(!this._getMonthPicker()){this.setAggregation("monthPicker",this._createMonthPicker())}i=this._getMonthPicker();s=this._getYearPicker();i.setColumns(0);i.setMonths(6);s.setColumns(0);s.setYears(6)}return this};m.prototype.setMinDate=function(e){var t,a,i,r;if(p(e,this.getMinDate())){return this}if(!e){s._updateUTCDate(this._oMinDate.getJSDate(),1,0,1,0,0,0,0)}else{s._checkJSDateObject(e);this._oMinDate=s._createUniversalUTCDate(e,undefined,true);t=this.getAggregation("timesRow");this._oMinDate=t._getIntervalStart(this._oMinDate);a=this._oMinDate.getUTCFullYear();s._checkYearInValidRange(a);if(this._oMaxDate.getTime()<this._oMinDate.getTime()){T.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=s._createUniversalUTCDate(e,undefined,true);s._updateUTCDate(this._oMaxDate,null,this._oMaxDate.getUTCMonth()+1,0,23,59,59,0);this.setProperty("maxDate",s._createLocalDate(this._oMaxDate,true))}if(this._oFocusedDate){if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){T.warning("focused date < minDate -> minDate focused",this);this.focusDate(e)}}if(this._oUTCStartDate&&this._oUTCStartDate.getTime()<this._oMinDate.getTime()){T.warning("start date < minDate -> minDate set as start date",this);P.call(this,new l(this._oMinDate.getTime()),true,true)}}this.setProperty("minDate",e);if(this.getPickerPopup()){r=this._getCalendar();r.setMinDate(e)}else{i=this._getYearPicker();i._oMinDate.setYear(this._oMinDate.getUTCFullYear())}return this};m.prototype.setMaxDate=function(e){var t,a,i,r,o,n;if(p(e,this.getMaxDate())){return this}if(!e){s._updateUTCDate(this._oMaxDate.getJSDate(),9999,11,31,23,59,59,0)}else{s._checkJSDateObject(e);this._oMaxDate=s._createUniversalUTCDate(e,undefined,true);t=this.getAggregation("timesRow");this._oMaxDate=t._getIntervalStart(this._oMaxDate);this._oMaxDate.setUTCMinutes(this._oMaxDate.getUTCMinutes()+this.getIntervalMinutes());this._oMaxDate.setUTCMilliseconds(-1);a=this._oMaxDate.getUTCFullYear();s._checkYearInValidRange(a);if(this._oMinDate.getTime()>this._oMaxDate.getTime()){T.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=s._createUniversalUTCDate(e,undefined,true);s._updateUTCDate(this._oMinDate,null,null,1,0,0,0,0);this.setProperty("minDate",s._createLocalDate(this._oMinDate,true))}if(this._oFocusedDate){if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){T.warning("focused date > maxDate -> maxDate focused",this);this.focusDate(e)}}if(this._oUTCStartDate){i=new l(this._oUTCStartDate.getTime());i.setUTCMinutes(i.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1));if(i.getTime()>this._oMaxDate.getTime()){r=new l(this._oMaxDate.getTime());r.setUTCMinutes(r.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1));if(r.getTime()>=this._oMinDate.getTime()){T.warning("end date > maxDate -> maxDate set as end date",this);P.call(this,r,true,true)}}}}this.setProperty("maxDate",e);if(this.getPickerPopup()){n=this._getCalendar();n.setMaxDate(e)}else{o=this._getYearPicker();o._oMaxDate.setYear(this._oMaxDate.getUTCFullYear())}return this};m.prototype.onclick=function(e){if(e.isMarked("delayedMouseEvent")){return}if(e.target.id==this.getId()+"-cancel"){this.onsapescape(e)}};m.prototype.onmousedown=function(e){e.preventDefault();e.setMark("cancelAutoClose")};m.prototype.onsapescape=function(e){if(this.getPickerPopup()){S.call(this);this.fireCancel()}else{switch(this._iMode){case 0:this.fireCancel();break;case 1:case 2:case 3:this.setProperty("_currentPicker",U.TIMES_ROW);break}}};m.prototype.setProperty=function(){var e=arguments[0],t=arguments[1];a.prototype.setProperty.apply(this,arguments);if(e==="_currentPicker"){switch(t){case"timesRow":this._iMode=0;break;case"datesRow":this._iMode=1;break;case"monthPicker":this._iMode=2;break;case"yearPicker":this._iMode=3;break;default:return}}return this};m.prototype._handlePrevious=function(e){var t=this._getFocusedDate(),a,i,r,o,n,h,g,c;switch(this._iMode){case 0:a=this._getItems();i=new l(y.call(this).getTime());r=this.getIntervalMinutes();i.setUTCMinutes(i.getUTCMinutes()-a*r);t.setUTCMinutes(t.getUTCMinutes()-a*r);this._setFocusedDate(t);P.call(this,i,true);break;case 1:if(!this.getPickerPopup()){o=this.getAggregation("datesRow");n=s._createUniversalUTCDate(o.getDate());h=o.getDays();if(n.getUTCDate()<=h){n.setUTCDate(1)}else{n.setUTCDate(n.getUTCDate()-h)}q.call(this,n)}break;case 2:if(!this.getPickerPopup()){g=this._getMonthPicker();if(g.getMonths()<12){g.previousPage();A.call(this)}else{t.setUTCFullYear(t.getUTCFullYear()-1);$.call(this,t);this._setFocusedDate(t);x.call(this);G.call(this,t.getUTCFullYear(),g);this.fireStartDateChange()}}break;case 3:if(!this.getPickerPopup()){c=this._getYearPicker();c.previousPage();I.call(this)}break}};m.prototype._handleNext=function(e){var t=this._getFocusedDate();switch(this._iMode){case 0:var a=this._getItems();var i=new l(y.call(this).getTime());var r=this.getIntervalMinutes();i.setUTCMinutes(i.getUTCMinutes()+a*r);t.setUTCMinutes(t.getUTCMinutes()+a*r);this._setFocusedDate(t);P.call(this,i,true);break;case 1:if(!this.getPickerPopup()){var o=this.getAggregation("datesRow");var n=s._createUniversalUTCDate(o.getDate());var h=new l(n.getTime());h.setUTCDate(1);h.setUTCMonth(h.getUTCMonth()+1);h.setUTCDate(0);var g=o.getDays();if(n.getUTCDate()+g>h.getUTCDate()){n.setUTCDate(h.getUTCDate())}else{n.setUTCDate(n.getUTCDate()+g)}q.call(this,n)}break;case 2:if(!this.getPickerPopup()){var c=this._getMonthPicker();if(c.getMonths()<12){c.nextPage();A.call(this)}else{t.setUTCFullYear(t.getUTCFullYear()+1);$.call(this,t);this._setFocusedDate(t);x.call(this);G.call(this,t.getUTCFullYear(),c);this.fireStartDateChange()}}break;case 3:if(!this.getPickerPopup()){var u=this._getYearPicker();u.nextPage();I.call(this)}break}};m.prototype._getShowItemHeader=function(){var e=this.getItems();if(e>this._iItemsHead){return true}else{return false}};function P(e,t,a){var i=new l(this._oMaxDate.getTime());i.setUTCMinutes(i.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1));if(i.getTime()<this._oMinDate.getTime()){i=new l(this._oMinDate.getTime());i.setUTCMinutes(i.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1))}if(e.getTime()<this._oMinDate.getTime()){e=new l(this._oMinDate.getTime())}else if(e.getTime()>i.getTime()){e=i}var r=this.getAggregation("timesRow");var o=s._createLocalDate(e,true);r.setStartDate(o);this._oUTCStartDate=new l(r._getStartDate().getTime());o=s._createLocalDate(this._oUTCStartDate,true);this.setProperty("startDate",o);x.call(this);if(t){var n=s._createLocalDate(this._getFocusedDate(),true);if(!r.checkDateFocusable(n)){this._setFocusedDate(e);r.setDate(o)}else{r.setDate(n)}}if(!a){this.fireStartDateChange()}}function y(){if(!this._oUTCStartDate){var e=this.getAggregation("timesRow");e.setStartDate(s._createLocalDate(this._getFocusedDate(),true));this._oUTCStartDate=new l(e._getStartDate().getTime());this._setFocusedDate(this._oUTCStartDate)}return this._oUTCStartDate}function w(e){var t=this._getFocusedDate();var a=this.getAggregation("timesRow");if(!e){a.setDate(s._createLocalDate(t,true))}else{a.displayDate(s._createLocalDate(t,true))}x.call(this)}function k(){var e=this.getSelectedDates();if(e&&e[0]&&e[0].getStartDate()){this._oFocusedDate=s._createUniversalUTCDate(e[0].getStartDate(),undefined,true)}else{var t=C.getInstance();this._oFocusedDate=s._createUniversalUTCDate(t,undefined,true)}if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){this._oFocusedDate=new l(this._oMinDate.getTime())}else if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){this._oFocusedDate=new l(this._oMaxDate.getTime())}}m.prototype._showCalendarPicker=function(){var e=s._createLocalDate(this._getFocusedDate(),true);var t=this._getCalendar();var a=new v({startDate:e});t.displayDate(e,false);t.removeAllSelectedDates();t.addSelectedDate(a);t.setMinDate(this.getMinDate());t.setMaxDate(this.getMaxDate());X.call(this,t);this._showOverlay()};m.prototype._showOverlay=function(){this.$("contentOver").css("display","")};m.prototype._hideOverlay=function(){this.$("contentOver").css("display","none")};function S(e){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close()}this._hideOverlay();if(!e){w.call(this)}this._getCalendar()._closePickers()}function F(){var e=this._getFocusedDate();var t=this._getItems();var a=this.getAggregation("datesRow");var i=a.getSelectedDates()[0];i.setStartDate(s._createLocalDate(e,true));var r=new l(e.getTime());r.setUTCDate(1);r.setUTCMonth(r.getUTCMonth()+1);r.setUTCDate(0);var o=r.getUTCDate();var n=Math.floor(t*1.5);if(n>o){n=o}a.setDays(n);this.setProperty("_currentPicker",U.DATES_ROW);this._showOverlay();q.call(this,e);this._iMode=1}function b(){var e=this._getFocusedDate();var t=this._getMonthPicker();this.setProperty("_currentPicker",U.MONTH_PICKER);this._showOverlay();t.setMonth(e.getUTCMonth());G.call(this,e.getUTCFullYear(),t);this._iMode=2;A.call(this)}function R(){var e=this._getFocusedDate();var t=this._getYearPicker();this.setProperty("_currentPicker",U.YEAR_PICKER);this._showOverlay();t.setDate(e.getJSDate());I.call(this);this._iMode=3}function x(){Y.call(this);A.call(this)}function A(e){var t=new l(y.call(this).getTime());var a=this._getItems();var i=t.getJSDate().getUTCFullYear();var s=this._oMaxDate.getJSDate().getUTCFullYear();var r=this._oMinDate.getJSDate().getUTCFullYear();var o=t.getJSDate().getUTCMonth();var n=this._oMaxDate.getJSDate().getUTCMonth();var h=this._oMinDate.getJSDate().getUTCMonth();var g=t.getJSDate().getUTCDate();var c=this._oMaxDate.getJSDate().getUTCDate();var u=this._oMinDate.getJSDate().getUTCDate();var D=t.getJSDate().getUTCHours();var _=this._oMaxDate.getJSDate().getUTCHours();var d=this._oMinDate.getJSDate().getUTCHours();var f=t.getJSDate().getUTCMinutes();var p=this._oMaxDate.getJSDate().getUTCMinutes();var T=this._oMinDate.getJSDate().getUTCMinutes();var v=this.getAggregation("header");if(this._iMode==2&&!e){var C=this._getMonthPicker();var M=C.getMonths();var m=C.getStartMonth();var U=m+M-1;if(m==0||i==r&&m<=h){v.setEnabledPrevious(false)}else{v.setEnabledPrevious(true)}if(U>10||i==s&&U>=n){v.setEnabledNext(false)}else{v.setEnabledNext(true)}return}if(i<r||i==r&&(e||(o<h||o==h&&(g<u||g==u&&(D<d||D==d&&f<=T))))||(this._iMode==1||this._iMode==2)&&this.getPickerPopup()){v.setEnabledPrevious(false)}else{v.setEnabledPrevious(true)}t.setUTCMinutes(t.getUTCMinutes()+a*this.getIntervalMinutes()-1);i=t.getJSDate().getUTCFullYear();o=t.getJSDate().getUTCMonth();g=t.getJSDate().getUTCDate();D=t.getJSDate().getUTCHours();f=t.getJSDate().getUTCMinutes();if(i>s||i==s&&(!e||(o>n||o==n&&(g>c||g==c&&(D>_||D==_&&f>=p))))||(this._iMode==1||this._iMode==2)&&this.getPickerPopup()){v.setEnabledNext(false)}else{v.setEnabledNext(true)}if(this._iMode===1){var P=new l(t.getTime());P.setUTCDate(1);P.setUTCMonth(P.getUTCMonth()+1);P.setUTCDate(0);var w=this.getAggregation("datesRow").getDays();t.setUTCDate(1+(Math.ceil(t.getUTCDate()/w)-1)*w);if(P.getUTCDate()-t.getUTCDate()<w){t.setUTCDate(P.getUTCDate()-w+1)}g=t.getUTCDate();if(g<=1||i==r&&o==h&&g<=u){v.setEnabledPrevious(false)}else{v.setEnabledPrevious(true)}if(g+w>=P.getUTCDate()||i==s&&o==n&&g>=c){v.setEnabledNext(false)}else{v.setEnabledNext(true)}}}function I(){var e=this._getYearPicker();var t=e.getYears();var a=s._createUniversalUTCDate(e.getProperty("_middleDate").toLocalJSDate());a.setUTCFullYear(a.getUTCFullYear()+Math.floor(t/2));var i=this.getAggregation("header");var r=new l(this._oMaxDate);r.setUTCFullYear(r.getUTCFullYear()-Math.ceil(t/2));r.setUTCMonth(11,31);var o=new l(this._oMinDate);o.setUTCFullYear(o.getUTCFullYear()+Math.floor(t/2)+1);o.setUTCMonth(0,1);if(a.getTime()>r.getTime()){i.setEnabledNext(false)}else{i.setEnabledNext(true)}if(a.getTime()<o.getTime()){i.setEnabledPrevious(false)}else{i.setEnabledPrevious(true)}}function Y(){var e=this.getAggregation("header");var t;var a=y.call(this);var i;var r=this._getLocaleData();var o=[];var n=[];var h;var g=false;var l;var c=false;if(r.oLocale.sLanguage.toLowerCase()==="ja"||r.oLocale.sLanguage.toLowerCase()==="zh"){l=u.getDateInstance({format:"d"}).format(a,true)}else{l=a.getUTCDate().toString()}if(this._bLongMonth||!this._bNamesLengthChecked){o=r.getMonthsStandAlone("wide")}else{g=true;o=r.getMonthsStandAlone("abbreviated");n=r.getMonthsStandAlone("wide")}var D=a.getUTCMonth();t=o[D];if(g){h=n[o[D]]}if(!this.getPickerPopup()){e.setTextButton0(l);e.setTextButton1(t);e.setTextButton2(this._oYearFormat.format(a,true))}else{i=u.getInstance({style:"long",strictParsing:true,relative:c},r.oLocale);h=l=i.format(s._createLocalDate(a,true));e.setTextButton1(l)}if(g){e.setAriaLabelButton1(h)}}function E(e,t){var a;var i=false;if(e.getTime()<this._oMinDate.getTime()){a=this._oMinDate;i=true}else if(e.getTime()>this._oMaxDate.getTime()){a=this._oMaxDate;i=true}else{a=e}this._setFocusedDate(a);if(i||t){$.call(this,a);w.call(this,false);this.fireStartDateChange()}}function L(e,t){if(e&&(!this._oFocusedDate||this._oFocusedDate.getTime()!=e.getTime())){s._checkJSDateObject(e);e=s._createUniversalUTCDate(e,undefined,true);var a=e.getUTCFullYear();s._checkYearInValidRange(a);if(e.getTime()<this._oMinDate.getTime()||e.getTime()>this._oMaxDate.getTime()){throw new Error("Date must not be in valid range (minDate and maxDate); "+this)}this._setFocusedDate(e);if(this.getDomRef()&&this._iMode==0){w.call(this,t)}}}function O(e){if(this._iMode!=1){F.call(this)}else{this.setProperty("_currentPicker",U.TIMES_ROW)}}function J(e){var t;if(this.getPickerPopup()){this._showCalendarPicker()}else{if(this._iMode!=2){t=function(){var e=this._getMonthPicker();e._oItemNavigation.focusItem(e.getProperty("_focusedMonth"));e.removeDelegate(t)};b.call(this);this._getMonthPicker().addDelegate({onAfterRendering:t},this)}else{this.setProperty("_currentPicker",U.TIMES_ROW)}}}function B(e){var t;if(this._iMode!=3){t=function(){var e=this._getYearPicker();e.focus();e.removeDelegate(t)};R.call(this);this._getYearPicker().addDelegate({onAfterRendering:t},this)}else{this.setProperty("_currentPicker",U.TIMES_ROW)}}function N(e){this.fireSelect()}function V(e){var t=s._createUniversalUTCDate(e.getParameter("date"),undefined,true);var a=e.getParameter("notVisible");E.call(this,t,a)}function H(e){var t=e.getSource(),a=t.getSelectedDates()[0].getStartDate();var i=new l(this._getFocusedDate().getTime());var r=s._createUniversalUTCDate(a);i.setUTCFullYear(r.getUTCFullYear());i.setUTCMonth(r.getUTCMonth(),r.getUTCDate());E.call(this,i,true);S.call(this)}function z(e){var t=new l(this._getFocusedDate().getTime());var a=e.oSource;var i=a.getSelectedDates()[0];var r=s._createUniversalUTCDate(i.getStartDate());if(!this.getPickerPopup()||r.getUTCMonth()==t.getUTCMonth()){t.setUTCDate(r.getUTCDate());t.setUTCMonth(r.getUTCMonth());t.setUTCFullYear(r.getUTCFullYear());E.call(this,t,true);this.setProperty("_currentPicker",U.TIMES_ROW)}this._addTimesRowFocusDelegate()}function W(e){var t=new l(this._getFocusedDate().getTime());var a=s._createUniversalUTCDate(e.getParameter("date"),undefined,true);var i=e.getParameter("otherMonth");if(i&&a.getUTCMonth()==t.getUTCMonth()&&a.getUTCFullYear()==t.getUTCFullYear()){q.call(this,a)}}function j(e){var t=new l(this._getFocusedDate().getTime());var a=this._getMonthPicker();var i=a.getMonth();t.setUTCMonth(i);if(i!=t.getUTCMonth()){t.setUTCDate(0)}E.call(this,t,true);this.setProperty("_currentPicker",U.TIMES_ROW);this._addTimesRowFocusDelegate()}function K(e){var t=new l(this._getFocusedDate().getTime());var a=this._getYearPicker();var i=s._createUniversalUTCDate(a.getDate());var r=t.getUTCMonth();i.setUTCMonth(t.getUTCMonth(),t.getUTCDate());i.setUTCHours(t.getUTCHours());i.setUTCMinutes(t.getUTCMinutes());t=i;if(r!=t.getUTCMonth()){t.setUTCDate(0)}E.call(this,t,true);this.setProperty("_currentPicker",U.TIMES_ROW);this._addTimesRowFocusDelegate()}m.prototype._addTimesRowFocusDelegate=function(){var e={onAfterRendering:function(){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());this.removeDelegate(e)}},t=this.getAggregation("timesRow");t.addDelegate(e,t)};function $(e){var t=this.getAggregation("timesRow");var a=y.call(this);var i=t._oItemNavigation.getFocusedIndex();a=new l(e.getTime());a.setUTCMinutes(a.getUTCMinutes()-i*this.getIntervalMinutes());P.call(this,a,false,true)}function q(e){var t=this.getAggregation("datesRow");var a=this.getAggregation("header");if(!this.getPickerPopup()){var i=new l(e.getTime());i.setUTCDate(1);i.setUTCMonth(i.getUTCMonth()+1);i.setUTCDate(0);var r=t.getDays();var o=new l(e.getTime());o.setUTCDate(1+(Math.ceil(e.getUTCDate()/r)-1)*r);if(i.getUTCDate()-o.getUTCDate()<r){o.setUTCDate(i.getUTCDate()-r+1)}t.setStartDate(s._createLocalDate(o,true));var n=o.getJSDate().getUTCFullYear();var h=this._oMaxDate.getJSDate().getUTCFullYear();var g=this._oMinDate.getJSDate().getUTCFullYear();var c=o.getJSDate().getUTCMonth();var u=this._oMaxDate.getJSDate().getUTCMonth();var D=this._oMinDate.getJSDate().getUTCMonth();var _=o.getJSDate().getUTCDate();var d=this._oMaxDate.getJSDate().getUTCDate();var f=this._oMinDate.getJSDate().getUTCDate();if(_<=1||n==g&&c==D&&_<=f){a.setEnabledPrevious(false)}else{a.setEnabledPrevious(true)}if(_+r>=i.getUTCDate()||n==h&&c==u&&_>=d){a.setEnabledNext(false)}else{a.setEnabledNext(true)}if(!this._oFocusDatesRowDelegate){this._oFocusDatesRowDelegate={onAfterRendering:function(){this.focus()}};t.addDelegate(this._oFocusDatesRowDelegate,t)}}else{a.setEnabledPrevious(false);a.setEnabledNext(false)}t.setDate(s._createLocalDate(e,true))}function X(a){if(!this._oPopup){var i=new e({placement:"VerticalPreferredBottom",showHeader:false,showArrow:false,verticalScrolling:false});i.oPopup.setDurations(0,0);i.addEventDelegate({onsapescape:this._oCalendar.onsapescape},this._oCalendar);this._oPopup=i}this._oPopup.addContent(a);this._oPopup.attachAfterClose(function(){this._hideOverlay();this._addTimesRowFocusDelegate()},this);this._oPopup.attachAfterOpen(function(){var e=s.$("B1");var a=this._oPopup.$();var i=Math.floor((a.width()-e.width())/2);this._oPopup.setOffsetX(t.getConfiguration().getRTL()?i:-i);var r=e.height();this._oPopup.setOffsetY(this._oPopup._getCalculatedPlacement()==="Top"?r:-r)},this);var s=this.getAggregation("header");this._oPopup.openBy(s.getDomRef("B1"))}function G(e,t){var a=0;var i=11;if(e==this._oMinDate.getUTCFullYear()){a=this._oMinDate.getUTCMonth()}if(e==this._oMaxDate.getUTCFullYear()){i=this._oMaxDate.getUTCMonth()}t.setMinMax(a,i)}function Q(e){A.call(this)}function Z(e){I.call(this)}return m});
//# sourceMappingURL=CalendarTimeInterval.js.map