/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/Device","sap/m/Button","sap/m/ResponsivePopover","./ColorPicker","./library","sap/m/library","sap/ui/thirdparty/jquery"],function(e,t,o,r,i,n,p,jQuery){"use strict";var a=p.PlacementType;var s=n.ColorPickerMode,l=n.ColorPickerDisplayMode;var u=p.ButtonType;var y=e.extend("sap.ui.unified.ColorPickerPopover",{metadata:{library:"sap.ui.unified",publicMethods:["openBy","close"],properties:{colorString:{type:"string",group:"Misc",defaultValue:null},mode:{type:"sap.ui.unified.ColorPickerMode",group:"Appearance",defaultValue:s.HSV},displayMode:{type:"sap.ui.unified.ColorPickerDisplayMode",group:"Appearance",defaultValue:l.Default}},events:{change:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}},liveChange:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}}}},renderer:{apiVersion:2}});var P=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var h={COLOR_PICKER_PROPS:{colorString:"setColorString",mode:"setMode",displayMode:"setDisplayMode"},POPOVER_METHODS:{getDomRef:"",close:""}};y.prototype.init=function(){this._oPopover=null;this._bPopoverDestroying=null};y.prototype.exit=function(){this._bPopoverDestroying=true;if(this._oPopover){this._oPopover.removeDelegate(this._oPopover._onAfterRenderingDelegate);this._oPopover.destroy();this._oPopover=null}};y.prototype.openBy=function(e){return r.prototype.openBy.apply(this._ensurePopover(),arguments)};y.prototype._getColorPicker=function(){return this._ensurePopover().getContent()[0]};y.prototype._ensurePopover=function(){if(!this._oPopover){this._oPopover=this._createPopover()}return this._oPopover};y.prototype._createPopover=function(){var e,i=this._createColorPicker(),n,p=this;e=new r(this.getId()+"-colorPickerPopover",{showHeader:t.system.phone,placement:a.VerticalPreferredBottom,showArrow:false,showCloseButton:false,beginButton:new o({text:P.getText("COLOR_PICKER_SUBMIT"),type:u.Emphasized,press:function(){p.fireChange(p._oLastChangeCPParams);e.close()}}),endButton:new o({text:P.getText("COLOR_PICKER_CANCEL"),press:function(){e.close()}}),title:P.getText("COLOR_PICKER_TITLE"),content:i});i.attachChange(function(e){this._handleChange(e)}.bind(this));i.attachLiveChange(function(e){this.fireLiveChange(e.getParameters())}.bind(this));n={onAfterRendering:function(){var e=this.$();e.attr("aria-modal","true");e.attr("aria-label",this.getTitle())}};e.addEventDelegate(n,e);e._onAfterRenderingDelegate=n;return e};y.prototype._handleChange=function(e){var t={};this._oLastChangeCPParams=jQuery.extend(t,e.getParameters());delete this._oLastChangeCPParams.id;return this};y.prototype._createColorPicker=function(){var e=new i(this.getId()+"-color_picker");return e};y.prototype.setProperty=function(t,o,r){var n;if(h.COLOR_PICKER_PROPS[t]!==undefined){n=h.COLOR_PICKER_PROPS[t]||t;i.prototype[n].call(this._getColorPicker(),o)}return e.prototype.setProperty.apply(this,arguments)};Object.keys(h.POPOVER_METHODS).forEach(function(e){var t=h.POPOVER_METHODS[e]||e;y.prototype[e]=function(){if(this._bPopoverDestroying){return null}var e=this._ensurePopover();return e[t].apply(e,arguments)}});return y});
//# sourceMappingURL=ColorPickerPopover.js.map