/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/Device","sap/ui/core/LocaleData","sap/ui/core/delegate/ItemNavigation","sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/DateRange","sap/ui/unified/DateTypeRange","sap/ui/unified/library","sap/ui/core/format/DateFormat","sap/ui/core/library","sap/ui/core/Locale","./MonthRenderer","sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/core/InvisibleMessage","sap/ui/core/Configuration","sap/ui/core/date/CalendarWeekNumbering","sap/ui/core/date/CalendarUtils","sap/ui/core/date/UI5Date","sap/base/Log"],function(e,t,a,i,s,r,o,n,l,h,g,d,u,c,p,jQuery,f,y,D,_,m,v){"use strict";var S=g.InvisibleMessageMode;var C=g.CalendarType;var b=l.CalendarDayType;var M=e.extend("sap.ui.unified.calendar.Month",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true},_focusedDate:{type:"object",group:"Data",visibility:"hidden",defaultValue:null},calendarWeekNumbering:{type:"sap.ui.core.date.CalendarWeekNumbering",group:"Appearance",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},otherMonth:{type:"boolean"},restoreOldDate:{type:"boolean"}}},weekNumberSelect:{allowPreventDefault:true,parameters:{weekNumber:{type:"int"},weekDays:{type:"sap.ui.unified.DateRange"}}}}},renderer:u});M.prototype.init=function(){this._mouseMoveProxy=this._handleMouseMove.bind(this);this._iColumns=7;this._oMinDate=s._minDate(this._getPrimaryCalendarType());this._oMaxDate=s._maxDate(this._getPrimaryCalendarType());this._aVisibleDays=[];this._bAlwaysShowSpecialDates=false;this._oUnifiedRB=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified")};M.prototype._getAriaRole=function(){return"gridcell"};M.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation}if(this._sInvalidateMonth){clearTimeout(this._sInvalidateMonth)}this._aVisibleDays=null;this._bAlwaysShowSpecialDates=null};M.prototype.getFocusDomRef=function(){return this.getDomRef()&&this._oItemNavigation.getItemDomRefs()[this._oItemNavigation.getFocusedIndex()]};M.prototype.onBeforeRendering=function(){this._oFormatYyyymmdd=h.getInstance({pattern:"yyyyMMdd",calendarType:C.Gregorian});this._oFormatLong=h.getInstance({style:"long",calendarType:this._getPrimaryCalendarType()});if(this.getFirstDayOfWeek()!==-1&&this.getCalendarWeekNumbering()!=="Default"){v.warning("Both properties firstDayOfWeek and calendarWeekNumbering should not be used at the same time!")}this._aSpecialDates=this._getSpecialDates()};M.prototype.onAfterRendering=function(){this.bSpaceButtonPressed=false;T.call(this);P.call(this);this._oInvisibleMessage=f.getInstance()};M.prototype.onmouseover=function(e){var t=jQuery(e.target),a=this.getSelectedDates()[0],i,s;if(!this._isMarkingUnfinishedRangeAllowed()){return}if(!t.hasClass("sapUiCalItemText")&&!t.hasClass("sapUiCalItem")){return}if(t.hasClass("sapUiCalItemText")){t=t.parent()}i=parseInt(this._oFormatYyyymmdd.format(a.getStartDate()));s=t.data("sapDay");if(this.hasListeners("datehovered")){this.fireEvent("datehovered",{date1:i,date2:s})}else{this._markDatesBetweenStartAndHoveredDate(i,s)}};M.prototype._markDatesBetweenStartAndHoveredDate=function(e,t){var a,i,s,r;a=this.$().find(".sapUiCalItem");if(e>t){e=e+t;t=e-t;e=e-t}for(r=0;r<a.length;r++){i=jQuery(a[r]);s=i.data("sapDay");if(s>e&&s<t&&this._isInAllowedRange(s)){i.addClass("sapUiCalItemSelBetween")}else{i.removeClass("sapUiCalItemSelBetween");if(s!=e&&s!=t){i.removeClass("sapUiCalItemSel")}}}};M.prototype._isInAllowedRange=function(e){return this._oFormatYyyymmdd.parse(e).getTime()>this._oMinDate.toLocalJSDate().getTime()&&this._oFormatYyyymmdd.parse(e).getTime()<this._oMaxDate.toLocalJSDate().getTime()};M.prototype.onsapfocusleave=function(e){if(!e.relatedControlId||!c(this.getDomRef(),sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())){if(this._bMouseMove){this._unbindMousemove(true);var t=this._selectDay(this._getDate());if(!t&&this._oMoveSelectedDate){this._selectDay(this._oMoveSelectedDate)}this._bMoveChange=false;this._bMousedownChange=false;this._oMoveSelectedDate=undefined;w.call(this)}if(this._bMousedownChange){this._bMousedownChange=false;w.call(this)}}};M.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var e=this.removeAllAggregation("selectedDates");return e};M.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var e=this.destroyAggregation("selectedDates");return e};M.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var e=this.removeAllAggregation("specialDates");return e};M.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var e=this.destroyAggregation("specialDates");return e};M.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var e=this.removeAllAggregation("disabledDates");return e};M.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var e=this.destroyAggregation("disabledDates");return e};M.prototype.setDate=function(e){if(e){var t=r.fromLocalJSDate(e,this._getPrimaryCalendarType());I.call(this,t)}return this.setProperty("date",e)};M.prototype._getDate=function(){if(!this._oDate){this._oDate=r.fromLocalJSDate(m.getInstance(),this._getPrimaryCalendarType())}return this._oDate};M.prototype.displayDate=function(e){var t=r.fromLocalJSDate(e,this._getPrimaryCalendarType());I.call(this,t);return this};M.prototype.setPrimaryCalendarType=function(e){this.setProperty("primaryCalendarType",e);this._oFormatLong=h.getInstance({style:"long",calendarType:e});if(this._oDate){this._oDate=new r(this._oDate,e)}return this};M.prototype.setSecondaryCalendarType=function(e){this.setProperty("secondaryCalendarType",e);this._oFormatSecondaryLong=h.getInstance({style:"long",calendarType:e});return this};M.prototype._getSecondaryCalendarType=function(){var e=this.getSecondaryCalendarType();if(e===this._getPrimaryCalendarType()){return undefined}return e};M.prototype._getLocale=function(){var e=this.getParent();if(e&&e.getLocale){return e.getLocale()}else if(!this._sLocale){this._sLocale=y.getFormatSettings().getFormatLocale().toString()}return this._sLocale};M.prototype._getLocaleData=function(){var e=this.getParent();if(e&&e._getLocaleData){return e._getLocaleData()}else if(!this._oLocaleData){var t=this._getLocale();var i=new d(t);this._oLocaleData=a.getInstance(i)}return this._oLocaleData};M.prototype._getFormatLong=function(){var e=this._getLocale();if(this._oFormatLong.oLocale.toString()!==e){var t=new d(e);this._oFormatLong=h.getInstance({style:"long",calendarType:this._getPrimaryCalendarType()},t);if(this._oFormatSecondaryLong){this._oFormatSecondaryLong=h.getInstance({style:"long",calendarType:this._getSecondaryCalendarType()},t)}}return this._oFormatLong};M.prototype.getIntervalSelection=function(){var e=this.getParent();if(e&&e.getIntervalSelection){return e.getIntervalSelection()}else{return this.getProperty("intervalSelection")}};M.prototype.getSingleSelection=function(){var e=this.getParent();if(e&&e.getSingleSelection){return e.getSingleSelection()}else{return this.getProperty("singleSelection")}};M.prototype.getSelectedDates=function(){var e=this.getParent();if(e&&e.getSelectedDates){return e.getSelectedDates()}else{return this.getAggregation("selectedDates",[])}};M.prototype.getSpecialDates=function(){var e=this.getParent();if(e&&e.getSpecialDates){return e.getSpecialDates()}else{return this.getAggregation("specialDates",[])}};M.prototype.getDisabledDates=function(){var e=this.getParent();if(e&&e.getDisabledDates){return e.getDisabledDates()}else{return this.getAggregation("disabledDates",[])}};M.prototype.getPrimaryCalendarType=function(){var e=this.getParent();if(e&&e.getPrimaryCalendarType){return e.getPrimaryCalendarType()}return this.getProperty("primaryCalendarType")};M.prototype._getPrimaryCalendarType=function(){var e=this.getParent();if(e&&e._getPrimaryCalendarType){return e._getPrimaryCalendarType()}return this.getProperty("primaryCalendarType")||y.getCalendarType()};M.prototype._getShowHeader=function(){var e=this.getParent();if(e&&e._getShowMonthHeader){return e._getShowMonthHeader()}else{return this.getProperty("showHeader")}};M.prototype.getAriaLabelledBy=function(){var e=this.getParent();if(e&&e.getAriaLabelledBy){return e.getAriaLabelledBy()}else{return this.getAssociation("ariaLabelledBy",[])}};M.prototype.getLegend=function(){var e=this.getParent();if(e&&e.getLegend){return e.getLegend()}else{return this.getAssociation("legend",[])}};M.prototype._getFirstDayOfWeek=function(){var e=this.getParent();var t=0;if(e&&e.getFirstDayOfWeek){t=e.getFirstDayOfWeek()}else{t=this.getProperty("firstDayOfWeek")}if(t<0||t>6){var a=_.getWeekConfigurationValues(this.getCalendarWeekNumbering(),new d(this._getLocale()));if(a){t=a.firstDayOfWeek}else{var i=this._getLocaleData();t=i.getFirstDayOfWeek()}}return t};M.prototype._getNonWorkingDays=function(){var e=this.getParent();var t;if(e&&e.getNonWorkingDays){t=e.getNonWorkingDays()}else{t=this.getProperty("nonWorkingDays")}if(t&&!Array.isArray(t)){t=[]}return t};M.prototype._isSpecialDateMarkerEnabled=function(e){var t;if(this.getStartDate){t=this.getStartDate()}else if(this.getDate()){t=this.getDate()}else{t=m.getInstance()}return this._bAlwaysShowSpecialDates||s._isSameMonthAndYear(e,r.fromLocalJSDate(t))};M.prototype._checkDateSelected=function(e){s._checkCalendarDate(e);var t=0,a=this.getSelectedDates(),i=this._getPrimaryCalendarType(),o=0,n=this.getProperty("_focusedDate"),l=false,h=this.getParent(),g=this._bCalendar&&h.getMonths(),d,u;for(o=0;o<a.length;o++){var c=a[o],p=c.getStartDate()?r.fromLocalJSDate(c.getStartDate(),i):undefined,f=c.getEndDate()?r.fromLocalJSDate(c.getEndDate(),i):undefined;if(p&&f){u=this._arrangeStartAndEndDates(p,f);p=u.startDate;f=u.endDate}d=n&&p&&g===1&&n.getMonth()!==p.getMonth();l=this._isMarkingUnfinishedRangeAllowed()&&n&&!d&&(s._isBetween(e,p,n,true)||s._isBetween(e,n,p,true));if(p&&!f&&e.isSame(p)){t=1;break}else if(f&&e.isSame(p)){t=2;if(e.isSame(f)){t=5}break}else if(f&&e.isSame(f)){t=3;break}else if(f&&e.isAfter(p)&&e.isBefore(f)||l){t=4;break}if(this.getSingleSelection()){break}}return t};M.prototype._getDateTypes=function(e){s._checkCalendarDate(e);var t,a,i,r=[];var o=this._aSpecialDates||this._getSpecialDates();var n=e.toUTCJSDate().getTime();var l=m.getInstance(Date.UTC(0,0,1));for(var h=0;h<o.length;h++){var g=o[h];var d=g.getStartDate();var u=s.MAX_MILLISECONDS;if(d){l.setUTCFullYear(d.getFullYear(),d.getMonth(),d.getDate());u=l.getTime()}var c=g.getEndDate();var p=-s.MAX_MILLISECONDS;if(c){l.setUTCFullYear(c.getFullYear(),c.getMonth(),c.getDate());p=l.getTime()}i=g.getType()===b.NonWorking;if(n===u&&!c||n>=u&&n<=p){if(!i&&!t){t={type:g.getType(),tooltip:g.getTooltip_AsString(),color:g.getColor()};r.push(t)}else if(i&&!a){a={type:g.getType(),tooltip:g.getTooltip_AsString()};r.push(a)}if(t&&a){break}}}return r};M.prototype._checkDateEnabled=function(e){s._checkCalendarDate(e);var t=true;var a=this.getDisabledDates();var i=e.toUTCJSDate().getTime();var o=this._getPrimaryCalendarType();var n=this.getParent();if(n&&n._oMinDate&&n._oMaxDate){if(i<n._oMinDate.valueOf()||i>n._oMaxDate.valueOf()){return false}}for(var l=0;l<a.length;l++){var h=a[l];var g=h.getStartDate();var d=0;if(g){g=r.fromLocalJSDate(g,o);d=g.toUTCJSDate().getTime()}var u=h.getEndDate();var c=0;if(u){u=r.fromLocalJSDate(u,o);c=u.toUTCJSDate().getTime()}if(u){if(i>d&&i<c){t=false;break}}else if(i===d){t=false;break}}return t};M.prototype._handleMouseMove=function(e){if(!this.$().is(":visible")){this._unbindMousemove(true)}var t=jQuery(e.target);if(t.hasClass("sapUiCalItemText")){t=t.parent()}if(this._sLastTargetId&&this._sLastTargetId===t.attr("id")){return}this._sLastTargetId=t.attr("id");if(t.hasClass("sapUiCalItem")){var a=this._getDate();if(c(this.getDomRef(),e.target)){var i=r.fromLocalJSDate(this._oFormatYyyymmdd.parse(t.attr("data-sap-day")),this._getPrimaryCalendarType());if(!i.isSame(a)){this._oDate=i;var s=this._selectDay(i,true);if(s){this._oMoveSelectedDate=new r(i,this._getPrimaryCalendarType())}this._bMoveChange=true}}}};M.prototype.onmousedown=function(e){this._oMousedownPosition={clientX:e.clientX,clientY:e.clientY};if(e.button||t.support.touch||!this._isWeekSelectionAllowed()||!e.target.classList.contains("sapUiCalWeekNum")){return}var a=e.target,i=a.nextElementSibling,s=i.getAttribute("data-sap-day"),o=!i.classList.contains("sapUiCalItemOtherMonth"),n=this._oFormatYyyymmdd.parse(s),l=r.fromLocalJSDate(n,this._getPrimaryCalendarType());this._handleWeekSelection(l,o)};M.prototype.onmouseup=function(e){var a=e.button!==2;if(this._bMouseMove){this._unbindMousemove(true);var i=this._getDate();var s=this._oItemNavigation.getItemDomRefs();for(var r=0;r<s.length;r++){var o=jQuery(s[r]);if(!o.hasClass("sapUiCalItemOtherMonth")){if(o.attr("data-sap-day")===this._oFormatYyyymmdd.format(i.toUTCJSDate(),true)){o.trigger("focus");break}}}if(this._bMoveChange){var n=this._selectDay(i);if(!n&&this._oMoveSelectedDate){this._selectDay(this._oMoveSelectedDate)}this._bMoveChange=false;this._bMousedownChange=false;this._oMoveSelectedDate=undefined;w.call(this)}}if(this._bMousedownChange){this._bMousedownChange=false;w.call(this)}else if(t.support.touch&&a&&this._areMouseEventCoordinatesInThreshold(e.clientX,e.clientY,10)){var l=e.target.classList,h=l.contains("sapUiCalItemText")||l.contains("sapUiCalDayName"),g=l.contains("sapUiCalWeekNum"),d=this._getSelectedDateFromEvent(e);if(g&&this._isWeekSelectionAllowed()){this._handleWeekSelection(d,true)}else if(h&&e.shiftKey&&this._isConsecutiveDaysSelectionAllowed()){this._handleConsecutiveDaysSelection(d)}else if(h){this._selectDay(d,false,false);w.call(this)}}};M.prototype.onsapselect=function(e){var t=this.getParent();if(this.bSpaceButtonPressed){return}if(t&&t._isMultiDatesSelectionHeaderAllowed&&!t._isMultiDatesSelectionHeaderAllowed()){return}var a=this._selectDay(this._getSelectedDateFromEvent(e));if(a){w.call(this)}e.stopPropagation();e.preventDefault()};M.prototype.onkeydown=function(e){if(e.which===p.SPACE){this.bSpaceButtonPressed=true}};M.prototype.onkeyup=function(e){if(e.which===p.SPACE){this.bSpaceButtonPressed=false}};M.prototype.onsapselectmodifiers=function(e){var t=this._getSelectedDateFromEvent(e),a,i=this.getParent();if(this._isWeekSelectionAllowed()&&e.shiftKey&&e.keyCode===p.SPACE){if(i&&i._isMultiDatesSelectionHeaderAllowed&&!i._isMultiDatesSelectionHeaderAllowed()){return}a=s._getFirstDateOfWeek(t);this._handleWeekSelection(a,false)}else if(this._isConsecutiveDaysSelectionAllowed()&&e.shiftKey&&e.keyCode===p.ENTER){this._handleConsecutiveDaysSelection(t)}e.preventDefault()};M.prototype.onsappageupmodifiers=function(e){var t=new r(this._getDate(),this._getPrimaryCalendarType());var a=t.getYear();if(e.metaKey||e.ctrlKey){t.setYear(a-10)}else{t.setYear(a-1)}this.fireFocus({date:t.toLocalJSDate(),otherMonth:true});e.preventDefault()};M.prototype.onsappagedownmodifiers=function(e){var t=new r(this._getDate(),this._getPrimaryCalendarType());var a=t.getYear();if(e.metaKey||e.ctrlKey){t.setYear(a+10)}else{t.setYear(a+1)}this.fireFocus({date:t.toLocalJSDate(),otherMonth:true});e.preventDefault()};M.prototype._isValueInThreshold=function(e,t,a){var i=e-a,s=e+a;return t>=i&&t<=s};M.prototype._areMouseEventCoordinatesInThreshold=function(e,t,a){return this._oMousedownPosition&&this._isValueInThreshold(this._oMousedownPosition.clientX,e,a)&&this._isValueInThreshold(this._oMousedownPosition.clientY,t,a)?true:false};M.prototype._bindMousemove=function(e){jQuery(window.document).on("mousemove",this._mouseMoveProxy);this._bMouseMove=true;if(e){this.fireEvent("_bindMousemove")}};M.prototype._unbindMousemove=function(e){jQuery(window.document).off("mousemove",this._mouseMoveProxy);this._bMouseMove=undefined;this._sLastTargetId=undefined;if(e){this.fireEvent("_unbindMousemove")}};M.prototype.onThemeChanged=function(){if(this._bNoThemeChange||!this.getDomRef()){return}var e=this.getDomRef().querySelectorAll(".sapUiCalWH:not(.sapUiCalDummy)"),t=this._getLocaleData(),a=this._getFirstWeekDay(),i=t.getDaysStandAlone("abbreviated",this._getPrimaryCalendarType()),s,r;this._bNamesLengthChecked=undefined;this._bLongWeekDays=undefined;for(r=0;r<e.length;r++){s=e[r];s.textContent=i[(r+a)%7]}P.call(this)};M.prototype._handleBorderReached=function(e){var t=e.getParameter("event");var a=0;var i=this._getDate();var s=new r(i,this._getPrimaryCalendarType());if(t.type){switch(t.type){case"sapnext":case"sapnextmodifiers":if(t.keyCode===p.ARROW_DOWN){s.setDate(s.getDate()+7)}else{s.setDate(s.getDate()+1)}break;case"sapprevious":case"sappreviousmodifiers":if(t.keyCode===p.ARROW_UP){s.setDate(s.getDate()-7)}else{s.setDate(s.getDate()-1)}break;case"sappagedown":a=s.getMonth()+1;s.setMonth(a);if(a%12!==s.getMonth()){while(a!==s.getMonth()){s.setDate(s.getDate()-1)}}break;case"sappageup":a=s.getMonth()-1;s.setMonth(a);if(a<0){a=11}if(a!==s.getMonth()){while(a!==s.getMonth()){s.setDate(s.getDate()-1)}}break;default:break}this.fireFocus({date:s.toLocalJSDate(),otherMonth:true})}};M.prototype.checkDateFocusable=function(e){s._checkJSDateObject(e);var t=this._getDate();var a=r.fromLocalJSDate(e,this._getPrimaryCalendarType());return s._isSameMonthAndYear(a,t)};M.prototype.applyFocusInfo=function(e){return this};M.prototype._getFirstWeekDay=function(){return this._getFirstDayOfWeek()};M.prototype._isMonthNameLong=function(e){var t;var a;for(t=0;t<e.length;t++){a=e[t];if(Math.abs(a.clientWidth-a.scrollWidth)>1){return true}}return false};M.prototype._getVisibleDays=function(e,t){var a,i,s,o,n,l,h;if(!e){return this._aVisibleDays}this._aVisibleDays=[];l=this._getFirstDayOfWeek();n=new r(e,this._getPrimaryCalendarType());n.setDate(1);o=n.getDay()-l;if(o<0){o=7+o}if(o>0){n.setDate(1-o)}i=new r(n);a=(e.getMonth()+1)%12;do{h=i.getYear();s=new r(i,this._getPrimaryCalendarType());if(t&&h<1){s._bBeforeFirstYear=true;this._aVisibleDays.push(s)}else if(h>0&&h<1e4){this._aVisibleDays.push(s)}i.setDate(i.getDate()+1)}while(i.getMonth()!==a||i.getDay()!==l);return this._aVisibleDays};M.prototype._handleMousedown=function(e,a){var i=e.target.classList.contains("sapUiCalWeekNum"),s=!e.button,o=this._getSelectedDateFromEvent(e);if(!s||t.support.touch){return this}if(i){this._isWeekSelectionAllowed()&&this._handleWeekSelection(o,true);return this}else if(e.shiftKey&&this._isConsecutiveDaysSelectionAllowed()){this._handleConsecutiveDaysSelection(o);return this}var n=this._selectDay(a);if(n){this._bMousedownChange=true}if(this._bMouseMove){this._unbindMousemove(true);this._bMoveChange=false;this._oMoveSelectedDate=undefined}else if(n&&this.getIntervalSelection()&&this.$().is(":visible")){this._bindMousemove(true);this._oMoveSelectedDate=new r(a,this._getPrimaryCalendarType())}e.preventDefault();e.setMark("cancelAutoClose")};M.prototype._getSelectedDateFromEvent=function(e){var t=e.target,a,i;if(t.classList.contains("sapUiCalWeekNum")){a=t.nextSibling.getAttribute("data-sap-day")}else{a=t.getAttribute("data-sap-day")||t.parentNode.getAttribute("data-sap-day")}i=this._oFormatYyyymmdd.parse(a);return i?r.fromLocalJSDate(i,this._getPrimaryCalendarType()):null};M.prototype._handleWeekSelection=function(e,t){var a=this._calculateWeekNumber(e),i=this._getLastWeekDate(e),s=this.getSingleSelection(),o=this.getIntervalSelection(),n=this._checkDateEnabled(e)?e:null,l=this._checkDateEnabled(i)?i:null;if(e.isAfter(this._oMaxDate)||i.isBefore(this._oMinDate)){return this}if(!n){n=new r(this._oMinDate)}if(!l){l=new r(this._oMaxDate)}if(!s&&!o){this._handleWeekSelectionByMultipleDays(a,n,l)}else if(s&&o){this._handleWeekSelectionBySingleInterval(a,n,l)}t&&this._focusDate(n);return this};M.prototype._handleConsecutiveDaysSelection=function(e){var t=this.getSelectedDates(),a=t.length&&t[t.length-1].getStartDate(),i=a?r.fromLocalJSDate(a):e,s;s=this._areAllDaysBetweenSelected(i,e);this._toggleDaysBetween(i,e,!s);return this};M.prototype._calculateWeekNumber=function(e){var t=new d(this._getLocale());var a=this._getLastWeekDate(e);var i=this._getLocaleData();var s;var r;s=h.getInstance({pattern:"w",calendarType:this._getPrimaryCalendarType(),calendarWeekNumbering:this.getCalendarWeekNumbering()},t);var o=i.firstDayStartsFirstWeek();if(a.getMonth()===0&&this._oDate.getMonth()===0&&o){r=s.format(a.toLocalJSDate())}else{r=s.format(e.toLocalJSDate())}return r};M.prototype._isWeekSelectionAllowed=function(){var e=this.getSingleSelection(),t=this.getIntervalSelection(),a=this._getPrimaryCalendarType(),i=this.getFirstDayOfWeek()!==-1,s=!e&&!t,r=e&&t,o=r||s;return a===C.Gregorian&&!i&&o};M.prototype._isConsecutiveDaysSelectionAllowed=function(){var e=this.getSingleSelection(),t=this.getIntervalSelection();return!e&&!t};M.prototype._isMarkingUnfinishedRangeAllowed=function(){var e=this.getSelectedDates()[0],t=!!(e&&e.getStartDate()&&!e.getEndDate());return this.getIntervalSelection()&&t};M.prototype._handleWeekSelectionByMultipleDays=function(e,t,a){var i,s,r;i=this._areAllDaysBetweenSelected(t,a)?new o({startDate:t.toLocalJSDate()}):new o({startDate:t.toLocalJSDate(),endDate:a.toLocalJSDate()});s=this.fireWeekNumberSelect({weekNumber:e,weekDays:i});r=i.getEndDate()?true:false;if(s){this._toggleDaysBetween(t,a,r)}return this};M.prototype._handleWeekSelectionBySingleInterval=function(e,t,a){var i=new o({startDate:t.toLocalJSDate(),endDate:a.toLocalJSDate()}),s=this.getParent(),r=this,n;if(s&&s.getSelectedDates){r=s}if(this._isIntervalSelected(i)){i=null}n=this.fireWeekNumberSelect({weekNumber:e,weekDays:i});if(n){r.removeAllSelectedDates();r.addSelectedDate(i)}return this};M.prototype._isIntervalSelected=function(e){var t=this.getSelectedDates(),a=t.length&&t[0],i=a&&a.getEndDate();return a&&a.getStartDate()&&a.getStartDate().getTime()===e.getStartDate().getTime()&&i&&a.getEndDate()&&a.getEndDate().getTime()===e.getEndDate().getTime()};M.prototype._getLastWeekDate=function(e){return new r(e).setDate(e.getDate()+6)};M.prototype._toggleDaysBetween=function(e,t,a){var i=this._arrangeStartAndEndDates(e,t),s=new r(i.startDate),o;do{o=this._checkDateSelected(s);if(!o&&a||o&&!a){this._selectDay(s);w.call(this)}s.setDate(s.getDate()+1)}while(s.isSameOrBefore(i.endDate));return this};M.prototype._areAllDaysBetweenSelected=function(e,t){var a=this._arrangeStartAndEndDates(e,t),i=new r(a.startDate),s=true;do{if(!this._checkDateSelected(i)){s=false;break}i.setDate(i.getDate()+1)}while(i.isSameOrBefore(a.endDate));return s};M.prototype._arrangeStartAndEndDates=function(e,t){var a=e.isSameOrBefore(t);return{startDate:a?e:t,endDate:a?t:e}};M.prototype._selectDay=function(e,t){if(!this._checkDateEnabled(e)){return false}var a=this.getSelectedDates();var i;var s=this._oItemNavigation.getItemDomRefs();var n;var l;var h=0;var g=this.getParent();var d=this;var u;var c=this._getPrimaryCalendarType();if(g&&g.isA("sap.ui.unified.Calendar")){d=g}if(this.getSingleSelection()){if(a.length>0){i=a[0];u=i.getStartDate();if(u){u=r.fromLocalJSDate(u,c)}}else{i=new o;d.addAggregation("selectedDates",i,true)}if(this.getIntervalSelection()&&(!i.getEndDate()||t)&&u){var p;if(e.isBefore(u)){p=u;u=e;if(!t){i.setProperty("startDate",u.toLocalJSDate());i.setProperty("endDate",p.toLocalJSDate())}}else if(e.isSameOrAfter(u)){p=e;if(!t){i.setProperty("endDate",p.toLocalJSDate())}}}else{i.setProperty("startDate",e.toLocalJSDate());i.setProperty("endDate",undefined)}this._oInvisibleMessage.announce(this._oUnifiedRB.getText("APPOINTMENT_SELECTED"),S.Assertive)}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection")}else{var f=this._checkDateSelected(e);if(f>0){for(h=0;h<a.length;h++){u=a[h].getStartDate();if(u&&e.isSame(r.fromLocalJSDate(u,c))){d.removeAggregation("selectedDates",h);break}}}else{this._oInvisibleMessage.announce(this._oUnifiedRB.getText("APPOINTMENT_SELECTED"),S.Assertive);i=new o({startDate:e.toLocalJSDate()});d.addAggregation("selectedDates",i)}l=this._oFormatYyyymmdd.format(e.toUTCJSDate(),true);for(h=0;h<s.length;h++){n=jQuery(s[h]);if(n.attr("data-sap-day")===l){if(f>0){n.removeClass("sapUiCalItemSel");n.attr("aria-selected","false")}else{n.addClass("sapUiCalItemSel");n.attr("aria-selected","true")}}}}}return true};M.prototype._getSpecialDates=function(){var e=this.getSpecialDates();for(var t=0;t<e.length;t++){var a=e[t].getSecondaryType()===l.CalendarDayType.NonWorking&&e[t].getType()!==l.CalendarDayType.NonWorking;if(a){var i=new n;i.setType(l.CalendarDayType.NonWorking);i.setStartDate(e[t].getStartDate());if(e[t].getEndDate()){i.setEndDate(e[t].getEndDate())}e.push(i)}}return e};function T(){var e=this._oFormatYyyymmdd.format(this._getDate().toUTCJSDate(),true),t=0,a=this.getDomRef(),s=a.querySelectorAll(".sapUiCalItem");for(var r=0;r<s.length;r++){if(s[r].getAttribute("data-sap-day")===e){t=r;break}}if(!this._oItemNavigation){this._oItemNavigation=new i;this._oItemNavigation.attachEvent(i.Events.AfterFocus,k,this);this._oItemNavigation.attachEvent(i.Events.FocusAgain,L,this);this._oItemNavigation.attachEvent(i.Events.BorderReached,this._handleBorderReached,this);this.addDelegate(this._oItemNavigation);if(this._iColumns>1){this._oItemNavigation.setHomeEndColumnMode(true,true)}this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(this._iColumns,true)}this._oItemNavigation.setRootDomRef(a);this._oItemNavigation.setItemDomRefs(s);this._oItemNavigation.setFocusedIndex(t);this._oItemNavigation.setPageSize(s.length)}function k(e){var t=e.getParameter("index"),a=e.getParameter("event"),i=this._getDate(),s=new r(i,this._getPrimaryCalendarType()),o=false,n=true,l=this._oItemNavigation.getItemDomRefs(),h=l[t],g=h.getAttribute("data-sap-day"),d;if(!a){return}if(h.classList.contains("sapUiCalItemOtherMonth")||h.classList.contains("sapUiCalItemDsbl")){if(a.type==="saphomemodifiers"&&(a.metaKey||a.ctrlKey)){for(var u=0;u<l.length;++u){d=l[u];if(!(d.classList.contains("sapUiCalItemOtherMonth")||d.classList.contains("sapUiCalItemDsbl"))){s=r.fromLocalJSDate(this._oFormatYyyymmdd.parse(d.getAttribute("data-sap-day")),this._getPrimaryCalendarType());break}}this._focusDate(s)}else if(a.type==="sapendmodifiers"&&(a.metaKey||a.ctrlKey)){for(var u=l.length-1;u>0;--u){d=l[u];if(!(d.classList.contains("sapUiCalItemOtherMonth")||d.classList.contains("sapUiCalItemDsbl"))){s=r.fromLocalJSDate(this._oFormatYyyymmdd.parse(d.getAttribute("data-sap-day")),this._getPrimaryCalendarType());break}}this._focusDate(s)}else{o=true;s=r.fromLocalJSDate(this._oFormatYyyymmdd.parse(g),this._getPrimaryCalendarType());if(!s){s=new r(i)}this._focusDate(i);if(a.type==="mousedown"||this._sTouchstartYyyyMMdd&&a.type==="focusin"&&this._sTouchstartYyyyMMdd===g||h.classList.contains("sapUiCalItemDsbl")){n=false;this.fireFocus({date:i.toLocalJSDate(),otherMonth:false,restoreOldDate:true})}this._sTouchstartYyyyMMdd=a.originalEvent&&a.originalEvent.type==="touchstart"?g:undefined}}else{if(a.target.classList.contains("sapUiCalWeekNum")){this._focusDate(s)}else{s=r.fromLocalJSDate(this._oFormatYyyymmdd.parse(g),this._getPrimaryCalendarType());this._oDate=s}this._sTouchstartYyyyMMdd=undefined}if(a.type==="mousedown"&&this.getIntervalSelection()){this._sLastTargetId=h.id}if(n){this.fireFocus({date:s.toLocalJSDate(),otherMonth:o})}if(a.type==="mousedown"){this._handleMousedown(a,s,t)}}function L(e){var t=e.getParameter("index");var a=e.getParameter("event");if(!a){return}if(a.type==="mousedown"){var i=this._getDate();if(this.getIntervalSelection()){var s=this._oItemNavigation.getItemDomRefs();this._sLastTargetId=s[t].id}this._handleMousedown(a,i,t)}}function I(e){s._checkCalendarDate(e);var t=e.getYear();s._checkYearInValidRange(t);if(!this.getDate()||!e.isSame(r.fromLocalJSDate(this.getDate(),e.getCalendarType()))){var a=new r(e);this.setProperty("date",e.toLocalJSDate());this._oDate=a}else{this.invalidate()}}M.prototype._focusDate=function(e,a,i){if(!a){this.setDate(e.toLocalJSDate())}var s=this._oFormatYyyymmdd.format(e.toUTCJSDate(),true),r=this._oItemNavigation.getItemDomRefs(),o;for(var n=0;n<r.length;n++){o=r[n];if(o.getAttribute("data-sap-day")===s){if(document.activeElement!==r[n]){if(i||t.system.phone){this._oItemNavigation.setFocusedIndex(n)}else{this._oItemNavigation.focusItem(n)}}break}}};function w(){if(this._bMouseMove){this._unbindMousemove(true)}this.fireSelect()}function P(){if(!this._bNamesLengthChecked){var e,t=this.getDomRef().querySelectorAll(".sapUiCalWH:not(.sapUiCalDummy)"),a=this._isMonthNameLong(t),i,s,r,o;if(a){this._bLongWeekDays=false;i=this._getLocaleData();s=this._getFirstWeekDay();r=i.getDaysStandAlone("narrow",this._getPrimaryCalendarType());for(o=0;o<t.length;o++){e=t[o];e.textContent=r[(o+s)%7]}}else{this._bLongWeekDays=true}this._bNamesLengthChecked=true}}return M});
//# sourceMappingURL=Month.js.map