/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/CalendarLegendRenderer","sap/ui/unified/library","sap/base/Log","sap/ui/core/date/UI5Date"],function(e,t,a,n,r,o){"use strict";var s=n.CalendarDayType;var l={apiVersion:2};l.render=function(e,t){var a=t._getStartDate();var n=t.getTooltip_AsString();var r=t.getId();var o={value:r+"-Descr",append:true};e.openStart("div",t);e.class("sapUiCalMonthsRow");e.class("sapUiCalRow");if(n){e.attr("title",n)}e.accessibilityState(t,{role:"grid",readonly:"true",multiselectable:!t.getSingleSelection()||t.getIntervalSelection(),labelledby:o});e.openEnd();e.openStart("span",r+"-Descr");e.style("display","none");e.openEnd();e.text(t._rb.getText("CALENDAR_DIALOG"));e.close("span");if(t.getIntervalSelection()){e.openStart("span",r+"-Start");e.style("display","none");e.openEnd();e.text(t._rb.getText("CALENDAR_START_MONTH"));e.close("span");e.openStart("span",r+"-End");e.style("display","none");e.openEnd();e.text(t._rb.getText("CALENDAR_END_MONTH"));e.close("span")}this.renderRow(e,t,a);e.close("div")};l.renderRow=function(e,t,a){var n=t.getId();this.renderHeader(e,t,a);e.openStart("div",n+"-months");e.class("sapUiCalItems");e.attr("role","row");e.openEnd();this.renderMonths(e,t,a);e.close("div")};l.renderHeader=function(t,a,n){e._checkCalendarDate(n);if(a._getShowHeader()){var r=a._getLocaleData();var o=a.getId();t.openStart("div",o+"-Head");t.openEnd();this.renderHeaderLine(t,a,r,n);t.close("div")}};l.renderHeaderLine=function(a,n,r,o){e._checkCalendarDate(o);var s=n.getId();var l=n.getMonths();var d=new t(o);var i="";var c=0;var p=[];var g=0;for(g=0;g<l;g++){c=d.getYear();if(p.length>0&&p[p.length-1].iYear==c){p[p.length-1].iMonths++}else{p.push({iYear:c,iMonths:1})}d.setMonth(d.getMonth()+1)}for(g=0;g<p.length;g++){var h=p[g];i=100/l*h.iMonths+"%";a.openStart("div",s+"-Head"+g);a.class("sapUiCalHeadText");a.style("width",i);a.openEnd();a.text(h.iYear);a.close("div")}};l.renderMonths=function(e,a,n){var r=this.getHelper(a,n);var o=a.getMonths();var s=100/o+"%";var l=new t(n);l.setDate(1);for(var d=0;d<o;d++){this.renderMonth(e,a,l,r,s);l.setMonth(l.getMonth()+1)}};l.getHelper=function(a,n){e._checkCalendarDate(n);var s={};var l=a.getProperty("primaryCalendarType");s.sLocale=a._getLocale();s.oLocaleData=a._getLocaleData();s.oToday=t.fromLocalJSDate(o.getInstance(),l);s.sCurrentMonth=a._rb.getText("CALENDAR_CURRENT_MONTH");s.sId=a.getId();s.oFormatLong=a._getFormatLong();if(a._bLongMonth||!a._bNamesLengthChecked){s.aMonthNames=s.oLocaleData.getMonthsStandAlone("wide",l)}else{s.aMonthNames=s.oLocaleData.getMonthsStandAlone("abbreviated",l);s.aMonthNamesWide=s.oLocaleData.getMonthsStandAlone("wide",l)}var d=a.getLegend();if(d){var i=sap.ui.getCore().byId(d);if(i){if(!(i instanceof sap.ui.unified.CalendarLegend)){throw new Error(i+" is not an sap.ui.unified.CalendarLegend. "+a)}s.oLegend=i}else{r.warning("CalendarLegend "+d+" does not exist!",a)}}s.convertTextInfoToSecondaryType=function(e){var t=a._getSecondaryCalendarType(),n=s.oLocaleData.getMonthsStandAlone("abbreviated",t),r=a._oFormatYearInSecType,o=a._getDisplayedSecondaryDates(e.getMonth(),e.getYear()),l,d,i;if(o.start.getMonth()===o.end.getMonth()){l=n[o.start.getMonth()]}else{i=a._getLocaleData().getIntervalPattern();l=i.replace(/\{0\}/,n[o.start.getMonth()]).replace(/\{1\}/,n[o.end.getMonth()])}if(o.start.getYear()===o.end.getYear()){d=r.format(o.start.toUTCJSDate(),true)}else{d=i.replace(/\{0\}/,r.format(o.start.toUTCJSDate(),true)).replace(/\{1\}/,r.format(o.end.toUTCJSDate(),true))}return{sMonthInfo:l,sYearInfo:d}};return s};l.renderMonth=function(t,n,r,o,l){e._checkCalendarDate(r);var d=!!n._getSecondaryCalendarType(),i;if(d){i=o.convertTextInfoToSecondaryType(r)}var c={role:n._getAriaRole(),selected:false,label:"",describedby:""};var p=n._oFormatYyyymm.format(r.toUTCJSDate(),true);var g=n._checkDateSelected(r);var h=n._getDateType(r);var f=n._checkMonthEnabled(r);t.openStart("div",o.sId+"-"+p);t.class("sapUiCalItem");if(l){t.style("width",l)}if(e._isSameMonthAndYear(r,o.oToday)){t.class("sapUiCalItemNow");c["label"]=o.sCurrentMonth+" "}if(g>0){t.class("sapUiCalItemSel");c["selected"]=true}if(g==2){t.class("sapUiCalItemSelStart");c["describedby"]=c["describedby"]+" "+o.sId+"-Start"}else if(g==3){t.class("sapUiCalItemSelEnd");c["describedby"]=c["describedby"]+" "+o.sId+"-End"}else if(g==4){t.class("sapUiCalItemSelBetween")}else if(g==5){t.class("sapUiCalItemSelStart");t.class("sapUiCalItemSelEnd");c["describedby"]=c["describedby"]+" "+o.sId+"-Start";c["describedby"]=c["describedby"]+" "+o.sId+"-End"}if(h&&h.type!=s.None){t.class("sapUiCalItem"+h.type);if(h.tooltip){t.attr("title",h.tooltip)}}if(!f){t.class("sapUiCalItemDsbl");c["disabled"]=true}t.attr("tabindex","-1");t.attr("data-sap-month",p);c["label"]=c["label"]+o.oFormatLong.format(r.toUTCJSDate(),true);if(d){c["label"]=c["label"]+", "+i.sMonthInfo+" "+i.sYearInfo}if(h&&h.type!=s.None){a.addCalendarTypeAccInfo(c,h.type,o.oLegend)}t.accessibilityState(null,c);if(d){t.class("sapUiCalItemWithSecondaryType")}t.openEnd();t.openStart("span");t.class("sapUiCalItemText");t.openEnd();t.text(o.aMonthNames[r.getMonth()]);t.close("span");if(d){t.openStart("span");t.class("sapUiCalItemAddText");t.openEnd();t.text(i.sMonthInfo);t.close("span")}t.close("div")};return l},true);
//# sourceMappingURL=MonthsRowRenderer.js.map