/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/commons/ListBox","sap/ui/core/Control","./library","./FacetFilterListRenderer","sap/ui/core/ListItem"],function(t,e,s,i,o){"use strict";var l=e.extend("sap.ui.ux3.FacetFilterList",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{title:{type:"string",group:"Misc",defaultValue:null},multiSelect:{type:"boolean",group:"Behavior",defaultValue:true},displaySecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},selectedKeys:{type:"string[]",group:"Misc",defaultValue:null},showCounter:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{items:{type:"sap.ui.core.ListItem",multiple:true,singularName:"item"},controls:{type:"sap.ui.commons.ListBox",multiple:true,singularName:"control",visibility:"hidden"}},events:{select:{parameters:{id:{type:"string"},selectedIndices:{type:"int[]"},selectedItems:{type:"sap.ui.core.ListItem[]"},all:{type:"boolean"}}}}}});l.prototype.init=function(){this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._oListBox=new t(this.getId()+"-lb");this._oListBox.setScrollTop(0);this._oListBox.setValueTextAlign("Begin");this._oListBox.setDisplaySecondaryValues(this.getDisplaySecondaryValues());this._oListBox.setDisplayIcons(false);this._oListBox.setEditable(true);this._oListBox.setEnabled(true);this._oListBox.setVisible(true);this._oListBox.setAllowMultiSelect(this.getMultiSelect());this._oListBox.addAriaLabelledBy(this.getId()+"-head-txt");var e=this;this._oListBox.attachSelect(function(t){e.onSelect(e,t)});this.addAggregation("controls",this._oListBox);this._oItemAll=new o({text:this._oResBundle.getText("FACETFILTER_ALL",[0]),key:"sapUiFacetFilter_ALL"});this._oListBox.addItem(this._oItemAll)};l.prototype.setMultiSelect=function(t){this._oListBox.setAllowMultiSelect(t);this.setProperty("multiSelect",t,true);return this};l.prototype.setDisplaySecondaryValues=function(t){this._oListBox.setDisplaySecondaryValues(t);this.setProperty("displaySecondaryValues",t,true);return this};l.prototype.addItem=function(t){this._oListBox.addItem(t);if(!t.getKey()||t.getKey().trim()==""){t.setKey("generatedkey"+this.indexOfItem(t))}this.updateText4All();return this};l.prototype.insertItem=function(t,e){this._oListBox.insertItem(t,e+1);if(!t.getKey()||t.getKey().trim()==""){t.setKey("generatedkey"+this.indexOfItem(t))}this.updateText4All();return this};l.prototype.removeItem=function(t){var e=this._oListBox.removeItem(t);this.updateText4All();return e};l.prototype.removeAllItems=function(){this._oListBox.removeAllItems();this._oListBox.addItem(this._oItemAll);this.updateText4All()};l.prototype.destroyItems=function(){this._oListBox.removeItem(this._oItemAll);this._oListBox.destroyItems();this._oListBox.addItem(this._oItemAll);this.updateText4All();return this};l.prototype.indexOfItem=function(t){var e=this._oListBox.indexOfItem(t);if(e>-1){e=e-1}return e};l.prototype.getItems=function(){var t=this._oListBox.getItems();var e=[];for(var s=1;s<t.length;s++){e.push(t[s])}return e};l.prototype.setSelectedKeys=function(t){this.setProperty("selectedKeys",t);this.invalidate();return this};l.prototype.setShowCounter=function(t){this.setProperty("showCounter",t);this.updateText4All();return this};l.prototype.updateText4All=function(){if(this.getShowCounter()){this._oItemAll.setText(this._oResBundle.getText("FACETFILTER_ALL",[this._oListBox.getItems().length-1]))}else{this._oItemAll.setText(this._oResBundle.getText("FACETFILTER_NO_COUNT"))}};l.prototype.onBeforeRendering=function(){if(!this.bFullHeight){this._oListBox.setVisibleItems(5)}var t=this.getSelectedKeys();if(t&&t.length>0){this._oListBox.setSelectedKeys(t);this._bAllOnly=false}else{this._oListBox.setSelectedKeys(["sapUiFacetFilter_ALL"]);this._bAllOnly=true}};l.prototype.updateItems=function(){this.updateAggregation("items");var t=this._oListBox.getSelectedKeys();if(t.length==0){t=["sapUiFacetFilter_ALL"];this._bAllOnly=true;this._oListBox.setSelectedKeys(t)}};l.prototype.onSelect=function(t,e){var s=this._oListBox.getSelectedKeys();if(s.length==0){s=["sapUiFacetFilter_ALL"];this._bAllOnly=true;this._oListBox.setSelectedKeys(s)}var i=s.indexOf("sapUiFacetFilter_ALL");if(i>-1){if(s.length==1){this._bAllOnly=true}else{if(this._bAllOnly){s.splice(i,1);this._bAllOnly=false}else{s=["sapUiFacetFilter_ALL"];this._bAllOnly=true}this._oListBox.setSelectedKeys(s)}}else{this._bAllOnly=false}this.setProperty("selectedKeys",s,true);var o=[];var l=[];var r=this._oListBox.getSelectedItems();if(!this._bAllOnly){for(var n=0;n<r.length;n++){if(r[n]!=this._oItemAll){o.push(this.indexOfItem(r[n]));l.push(r[n])}}}this.fireSelect({id:t.getId(),all:this._bAllOnly,selectedIndices:o,selectedItems:l})};return l});
//# sourceMappingURL=FacetFilterList.js.map