/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/commons/MenuButton","sap/ui/core/Control","sap/ui/core/theming/Parameters","./Feeder","./library","./FeedChunkRenderer","sap/ui/commons/Menu","sap/ui/commons/MenuItem"],function(jQuery,e,t,o,n,i,s,r,a){"use strict";var u=i.FeederType;var l=t.extend("sap.ui.ux3.FeedChunk",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{thumbnailSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},text:{type:"string",group:"Data",defaultValue:null},sender:{type:"string",group:"Data",defaultValue:null},timestamp:{type:"string",group:"Data",defaultValue:null},deletionAllowed:{type:"boolean",group:"Behavior",defaultValue:false},commentChunk:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},feederThumbnailSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},feederSender:{type:"string",group:"Data",defaultValue:null},flagged:{type:"boolean",group:"Data",defaultValue:false},favorite:{type:"boolean",group:"Data",defaultValue:null},shared:{type:"boolean",group:"Data",defaultValue:false},enableFlag:{type:"boolean",group:"Appearance",defaultValue:true},enableShare:{type:"boolean",group:"Appearance",defaultValue:true},enableComment:{type:"boolean",group:"Appearance",defaultValue:true},enableInspect:{type:"boolean",group:"Appearance",defaultValue:true},enableFavorite:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{comments:{type:"sap.ui.ux3.FeedChunk",multiple:true,singularName:"comment",bindable:"bindable"},actionMenuItems:{type:"sap.ui.commons.MenuItem",multiple:true,singularName:"actionMenuItem",bindable:"bindable"}},events:{deleted:{},commentAdded:{parameters:{comment:{type:"sap.ui.ux3.FeedChunk"}}},toggleFlagged:{parameters:{flagged:{type:"boolean"}}},senderClicked:{},referenceClicked:{parameters:{text:{type:"string"}}},toggleFavorite:{parameters:{favorite:{type:"boolean"}}},inspect:{},toggleShared:{parameters:{shareed:{type:"boolean"}}},actionItemSelected:{parameters:{itemId:{type:"string"},item:{type:"sap.ui.unified.MenuItemBase"}}}}}});l.prototype.init=function(){this.maxComments=2;this.allComments=false;this.rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this.expanded=false};l.prototype.initCommentFeeder=function(){if(!this.oCommentFeeder){this.oCommentFeeder=new n(this.getId()+"-CommentFeeder",{type:u.Comment}).setParent(this);this.oCommentFeeder.attachEvent("submit",this.handleCommentFeederSubmit,this);this.showCommentFeeder=true}};l.prototype.initToolsButton=function(){if(!this.oToolsButton){this.oToolsButton=new e(this.getId()+"-toolsButton",{tooltip:this.rb.getText("FEED_TOOLS"),lite:true,menu:new r(this.getId()+"-toolsMenu")}).setParent(this);this.oToolsButton.attachEvent("itemSelected",this.handleToolsButtonSelected,this);var t=o._getThemeImage("_sap_ui_ux3_Feed_ToolsIconUrl");var n=o._getThemeImage("_sap_ui_ux3_Feed_ToolsIconHoverUrl");if(t){this.oToolsButton.setProperty("icon",t,true)}if(n){this.oToolsButton.setProperty("iconHovered",n,true)}}};l.prototype.exit=function(){if(this.oCommentFeeder){this.oCommentFeeder.destroy();delete this.oCommentFeeder}if(this.oToolsButton){this.oToolsButton.destroy();delete this.oToolsButton}this.rb=undefined;this.showCommentFeeder=undefined;this.expanded=undefined;this.oText=undefined;if(this.oHCMMenuButton){this.oHCMMenuButton.destroy();delete this.oHCMMenuButton}};l.prototype.onAfterRendering=function(){this.oText=this.$().children(".sapUiFeedChunkText").get(0);if(this.oText.clientHeight<this.oText.scrollHeight){var e=this.$().children(".sapUiFeedChunkByline").get(0);jQuery(e).append(s.renderExpander(this));if(this.expanded){jQuery(this.oText).css("height","auto")}}};l.prototype.onclick=function(e){var t=e.target.getAttribute("ID");if(t){switch(t){case this.getId()+"-delete":this.fireDeleted();break;case this.getId()+"-sender":this.fireSenderClicked();break;case this.getId()+"-thumb":this.fireSenderClicked();break;case this.getId()+"-exp":var o="";if(this.expanded){jQuery(this.oText).css("height","");o=this.rb.getText("FEED_EXPAND");this.expanded=false}else{jQuery(this.oText).css("height","auto");o=this.rb.getText("FEED_COLLAPSE");this.expanded=true}jQuery(document.getElementById(t)).attr("title",o).toggleClass("sapUiFeedChunkExpand sapUiFeedChunkCollapse");break;case this.getId()+"-all":this.showAllComments();break;case this.getId()+"-ActComment":if(!this.showCommentFeeder){this.initCommentFeeder();this.rerender()}break;case this.getId()+"-ActFlag":this.setFlagged(!this.getFlagged());this.fireToggleFlagged({flagged:this.getFlagged()});break;case this.getId()+"-ActFavorite":this.setFavorite(!this.getFavorite());this.fireToggleFavorite({favorite:this.getFavorite()});break;case this.getId()+"-ActInspect":this.fireInspect();break;case this.getId()+"-ActShare":this.setShared(!this.getShared());this.fireToggleShared({shared:this.getShared()});break;default:if(t.search(this.getId()+"-Ref")!=-1){this.fireReferenceClicked({text:jQuery(e.target).text()})}break}}e.preventDefault();e.stopPropagation()};l.prototype.showAllComments=function(){this.allComments=!this.allComments;var e=this.$().children("section");if(e.length>0){var t=sap.ui.getCore().createRenderManager();this.getRenderer().renderComments(t,this);t.flush(e[0]);t.destroy()}};l.prototype.handleCommentFeederSubmit=function(e){var t=new Date;var o=String(t);var n=new l(this.getId()+"-new-"+this.getComments().length,{text:e.getParameter("text"),commentChunk:true,deletionAllowed:true,timestamp:o,sender:this.getFeederSender(),thumbnailSrc:this.getFeederThumbnailSrc()});this.addComment(n);this.fireCommentAdded({comment:n})};l.prototype.handleToolsButtonSelected=function(e){if(e.getParameter("itemId")==this.getId()+"-actDelete"){this.fireDeleted()}else{this.fireActionItemSelected(e.mParameters)}};l.prototype.insertComment=function(e,t){this.insertAggregation("comments",e,t);this.initCommentFeeder();return this};l.prototype.addComment=function(e){this.addAggregation("comments",e);this.initCommentFeeder();return this};l.prototype.setDeletionAllowed=function(e){if(e==this.getDeletionAllowed()){return this}this.setProperty("deletionAllowed",e);if(e){this.initToolsButton();this.oToolsButton.getMenu().insertItem(new a(this.getId()+"-actDelete",{text:this.rb.getText("FEED_DELETE")}),0)}else{if(this.oToolsButton){this.oToolsButton.getMenu().removeItem(this.getId()+"-actDelete")}}return this};l.prototype.getActionMenuItems=function(){if(this.oToolsButton){var e=this.oToolsButton.getMenu().getItems();if(e.length>0&&e[0].getId()==this.getId()+"-actDelete"){e.shift()}return e}};l.prototype.insertActionMenuItem=function(e,t){this.initToolsButton();var o=this.oToolsButton.getMenu().getItems();if(o.length>0&&o[0].getId()==this.getId()+"-actDelete"){t++}this.oToolsButton.getMenu().insertItem(e,t);return this};l.prototype.addActionMenuItem=function(e){this.initToolsButton();this.oToolsButton.getMenu().addItem(e);return this};l.prototype.removeActionMenuItem=function(e){if(this.oToolsButton){return this.oToolsButton.getMenu().removeItem(e)}};l.prototype.removeAllActionMenuItems=function(){if(this.oToolsButton){var e=this.oToolsButton.getMenu().getItems();if(e.length>0&&e[0].getId()==this.getId()+"-actDelete"){e.shift();for(var t=0;t<e.length;t++){this.oToolsButton.getMenu().removeItem(e[t])}return e}else{return this.oToolsButton.getMenu().removeAllItems()}}};l.prototype.indexOfActionMenuItem=function(e){if(this.oToolsButton){var t=this.oToolsButton.getMenu().indexOfItem(e);var o=this.oToolsButton.getMenu().getItems();if(o.length>0&&o[0].getId()==this.getId()+"-actDelete"){t--}return t}};l.prototype.destroyActionMenuItems=function(){if(this.oToolsButton){var e=this.oToolsButton.getMenu().getItems();if(e.length>0&&e[0].getId()==this.getId()+"-actDelete"){this.removeAllActionMenuItems()}else{this.oToolsButton.getMenu().destroyItems()}}return this};l.prototype.bindActionMenuItems=function(e,t,o,n){this.initToolsButton();this.oToolsButton.getMenu().bindItems(e,t,o,n);return this};l.prototype.unbindActionMenuItems=function(){if(this.oToolsButton){this.oToolsButton.getMenu().unbindItems()}return this};l.prototype.getFeederThumbnailSrc=function(){var e=this.getProperty("feederThumbnailSrc");if(!e||e==""){var t=this.getParent();if(t&&(t instanceof sap.ui.ux3.Feed||t instanceof l)){e=t.getFeederThumbnailSrc()}}return e};l.prototype.getFeederSender=function(){var e=this.getProperty("feederSender");if(!e||e==""){var t=this.getParent();if(t&&(t instanceof sap.ui.ux3.Feed||t instanceof l)){e=t.getFeederSender()}}return e};l.prototype.initHCMMenuButton=function(){if(!this.oHCMMenuButton){this.oHCMMenuButton=new e(this.getId()+"-HCMMenu",{lite:true}).setParent(this);this.oHCMMenuButton.attachEvent("itemSelected",this.handleHCMMenuButtonSelected,this)}};l.prototype.setHCMMenu=function(e){this.initHCMMenuButton();this.oHCMMenuButton.setMenu(e);return this};l.prototype.handleHCMMenuButtonSelected=function(e){this.fireEvent("HCMMenuItemSelected",e.mParameters)};return l});
//# sourceMappingURL=FeedChunk.js.map