/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/core/Control","./ThingViewerRenderer","./library","./NavigationBar","sap/ui/core/ResizeHandler"],function(jQuery,e,t,r,i,n){"use strict";var a=r.ThingViewerHeaderType;var s=e.extend("sap.ui.ux3.ThingViewer",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{title:{type:"string",group:"Misc",defaultValue:null},type:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},subtitle:{type:"string",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"100%"},headerType:{type:"sap.ui.ux3.ThingViewerHeaderType",group:"Misc",defaultValue:a.Standard}},aggregations:{headerContent:{type:"sap.ui.ux3.ThingGroup",multiple:true,singularName:"headerContent"},facets:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"facet"},facetContent:{type:"sap.ui.ux3.ThingGroup",multiple:true,singularName:"facetContent"},actionBar:{type:"sap.ui.ux3.ActionBar",multiple:false},navBar:{type:"sap.ui.ux3.NavigationBar",multiple:false,visibility:"hidden"}},associations:{selectedFacet:{type:"sap.ui.ux3.NavigationItem",multiple:false}},events:{facetSelected:{allowPreventDefault:true,parameters:{id:{type:"string"},item:{type:"sap.ui.ux3.NavigationItem"},key:{type:"string"}}}}}});s.prototype.init=function(){var e=this;this._oNavBar=new i;this.setAggregation("navBar",this._oNavBar);this._oNavBar.attachSelect(function(t){var r=t.getParameters().item;if(e.fireFacetSelected({id:r.getId(),key:r.getKey(),item:r})){e.setSelectedFacet(r)}else{t.preventDefault()}})};s.prototype.onAfterRendering=function(){this._resize=false;if(this.getActionBar()){this._adjustStyles()}if(this.$().find(".sapUiUx3TVFacetContent").length<=0){return}this._resizeListenerId=n.register(this.$().find(".sapUiUx3TVFacetContent")[0],jQuery.proxy(this._onresize,this));this._setTriggerValue();this._setHeaderPosition();this._onresize()};s.prototype.onBeforeRendering=function(){if(this._resizeListenerId){n.deregister(this._resizeListenerId);this._resizeListenerId=null}};s.prototype._setHeaderPosition=function(){if(this.getHeaderType()===a.Standard){var e=this.$().find(".sapUiUx3TVHeaderContainerIdentifier"),t=this.$().find(".sapUiUx3TVHeaderGroupScrollContainer");t.css("top",e.outerHeight())}};s.prototype._onresize=function(e){var t;if(e){t=jQuery(e.target).width()}if(!t){t=jQuery(this.$().find(".sapUiUx3TVFacetContent")[0]).width()}if(t<this._triggerValue&&this._resize==false){var r=this.$().find(".sapUiUx3TVFacetThingGroup");for(var i=0;i<r.length;i++){jQuery(r[i]).animate({width:"100%"},"fast")}this._resize=true}else if(t>this._triggerValue&&this._resize==true){var r=this.$().find(".sapUiUx3TVFacetThingGroup");for(var i=0;i<r.length;i++){jQuery(r[i]).animate({width:"50%"},"fast")}this._resize=false}if(this.getActionBar()){var n=this.getActionBar().getActionBarMinWidth(),a=n;if(this._bShell){n+=36;a=n+60}this.$().find(".sapUiUx3TV").css("min-width",a+"px");this.$().find(".sapUiUx3TVContent").css("min-width",n+"px")}};s.prototype.exit=function(){this._oNavBar.destroy();if(this._resizeListenerId){n.deregister(this._resizeListenerId);this._resizeListenerId=null}};s.prototype._getNavBar=function(){return this._oNavBar};s.prototype._selectDefault=function(){var e=this._oNavBar.getItems();if(e.length&&!this._oNavBar.getSelectedItem()){if(!this.getSelectedFacet()){this.setSelectedFacet(e[0])}var t=this._oNavBar.getSelectedItem(),r=sap.ui.getCore().byId(t);this.fireFacetSelected({id:r.getId(),key:r.getKey(),item:r})}};s.prototype._equalColumns=function(){var e=this.$().find(".sapUiUx3TVHeader"),t=this.$().find(".sapUiUx3TVFacets"),r=this.$().find(".sapUiUx3TVContentScrollContainer"),i=r.get(0).scrollHeight;t.height(i);e.height(i)};s.prototype._rerenderHeader=function(){var e=this.$("header");if(e.length>0){var r=sap.ui.getCore().createRenderManager();t.renderHeader(r,this);r.flush(e[0]);r.destroy()}};s.prototype._rerenderHeaderContent=function(){var e=this.$("headerContent");if(e.length>0){var r=sap.ui.getCore().createRenderManager();t.renderHeaderContent(r,this);r.flush(e[0]);r.destroy()}};s.prototype._rerenderToolbar=function(){var e=this.$("toolbar");if(e.length>0){var r=sap.ui.getCore().createRenderManager();t.renderToolbar(r,this);r.flush(e[0]);r.destroy()}};s.prototype._rerenderFacetContent=function(){var e=this.$("facetContent");if(e.length>0){var r=sap.ui.getCore().createRenderManager();t.renderFacetContent(r,this);r.flush(e[0]);r.destroy();this._resize=false;this._setTriggerValue();this._onresize()}};s.prototype._setTriggerValue=function(){var e,t,r=this.$("facetContent");if(r.length>0){e=this.$().find(".sapUiUx3TVFacetThingGroup");t=jQuery(e[0]).css("min-width");if(t){this._triggerValue=parseInt(t)*2}}};s.prototype.getFacets=function(){return this._oNavBar.getItems()};s.prototype.insertFacet=function(e,t){this._oNavBar.insertItem(e,t);return this};s.prototype.addFacet=function(e){this._oNavBar.addItem(e);return this};s.prototype.removeFacet=function(e){return this._oNavBar.removeItem(e)};s.prototype.removeAllFacets=function(){return this._oNavBar.removeAllItems()};s.prototype.destroyFacets=function(){this._oNavBar.destroyItems();return this};s.prototype.setIcon=function(e){this.setProperty("icon",e);if(this.getActionBar()){this.getActionBar().setThingIconURI(e)}this._rerenderHeader();return this};s.prototype.insertFacetContent=function(e,t){this.insertAggregation("facetContent",e,t,true);this._rerenderFacetContent();return this};s.prototype.addFacetContent=function(e){this.addAggregation("facetContent",e,true);this._rerenderFacetContent();return this};s.prototype.removeFacetContent=function(e){var t=this.removeAggregation("facetContent",e,true);this._rerenderFacetContent();return t};s.prototype.removeAllFacetContent=function(){var e=this.removeAllAggregation("facetContent",true);this._rerenderFacetContent();return e};s.prototype.destroyFacetContent=function(){this.destroyAggregation("facetContent",true);this._rerenderFacetContent();return this};s.prototype.insertHeaderContent=function(e,t){this.insertAggregation("headerContent",e,t,true);this._rerenderHeaderContent();return this};s.prototype.addHeaderContent=function(e){this.addAggregation("headerContent",e,true);this._rerenderHeaderContent();return this};s.prototype.removeHeaderContent=function(e){var t=this.removeAggregation("headerContent",e,true);this._rerenderHeaderContent();return t};s.prototype.removeAllHeaderContent=function(){var e=this.removeAllAggregation("headerContent",true);this._rerenderHeaderContent();return e};s.prototype.destroyHeaderContent=function(){this.destroyAggregation("headerContent",true);this._rerenderHeaderContent();return this};s.prototype.setSelectedFacet=function(e){var t=this.getSelectedFacet();this.setAssociation("selectedFacet",e,true);var r=this.getSelectedFacet();if(t!=r){this._oNavBar.setSelectedItem(r)}return this};s.prototype.setTitle=function(e){this.setProperty("title",e,true);this._rerenderHeader();return this};s.prototype.setSubtitle=function(e){this.setProperty("subtitle",e,true);this._rerenderHeader();return this};s.prototype.setActionBar=function(e){this.setAggregation("actionBar",e,true);if(this.getIcon()&&this.getActionBar()){this.getActionBar().setThingIconURI(this.getIcon())}this._rerenderToolbar();this._adjustStyles();return this};s.prototype._adjustStyles=function(){var e=this.$().find(".sapUiUx3TVHeader"),t=this.$().find(".sapUiUx3TVFacets");if(e.length>0){e.addClass("sapUiUx3TVActionBar");e.removeClass("sapUiUx3TVNoActionBar")}if(t.length>0){t.addClass("sapUiUx3TVActionBar");t.removeClass("sapUiUx3TVNoActionBar")}};return s});
//# sourceMappingURL=ThingViewer.js.map