//@ui5-bundle sap/ui/ux3/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/ActionBar", ["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/delegate/ItemNavigation","./library","./ActionBarRenderer","sap/ui/core/ResizeHandler","sap/ui/ux3/ThingAction","sap/ui/ux3/ToolPopup","sap/ui/ux3/Feeder","sap/ui/core/Popup","sap/ui/commons/MenuItem","sap/ui/commons/Menu","sap/ui/commons/MenuButton","sap/ui/commons/Button","sap/ui/Device","sap/base/Log","sap/ui/core/Configuration"],function(jQuery,t,e,o,i,n,s,r,a,u,l,c,h,p,d,_,g){"use strict";var f=u.Dock;var A=o.FeederType;var m=o.ActionBarSocialActions;var M=o.FollowActionState;var y=t.extend("sap.ui.ux3.ActionBar",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{followState:{type:"sap.ui.ux3.FollowActionState",group:"Misc",defaultValue:M.Default},flagState:{type:"boolean",group:"Misc",defaultValue:null},favoriteState:{type:"boolean",group:"Misc",defaultValue:null},updateState:{type:"boolean",group:"Misc",defaultValue:null},thingIconURI:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},alwaysShowMoreMenu:{type:"boolean",group:"Misc",defaultValue:true},showUpdate:{type:"boolean",group:"Misc",defaultValue:true},showFollow:{type:"boolean",group:"Misc",defaultValue:true},showFlag:{type:"boolean",group:"Misc",defaultValue:true},showFavorite:{type:"boolean",group:"Misc",defaultValue:true},showOpen:{type:"boolean",group:"Misc",defaultValue:true},dividerWidth:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null}},aggregations:{businessActions:{type:"sap.ui.ux3.ThingAction",multiple:true,singularName:"businessAction"},_businessActionButtons:{type:"sap.ui.commons.Button",multiple:true,singularName:"_businessActionButton",visibility:"hidden"},_socialActions:{type:"sap.ui.ux3.ThingAction",multiple:true,singularName:"_socialAction",visibility:"hidden"}},events:{actionSelected:{parameters:{id:{type:"string"},action:{type:"sap.ui.ux3.ThingAction"},newState:{type:"string"}}},feedSubmit:{parameters:{text:{type:"string"}}}}},renderer:i});y.prototype.init=function(){this.mActionMap={};this.mActionKeys=m;this.oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Update),true);this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Follow),true);this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Flag),true);this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Favorite),true);this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Open),true);if(!this._oItemNavigation){this._oItemNavigation=new e;this.addDelegate(this._oItemNavigation)}};y.prototype.exit=function(){this.closePopups();if(this._oUpdatePopup){this._oUpdatePopup.destroy();this._oUpdatePopup=null}if(this._oMoreMenuButton){this._oMoreMenuButton.destroy();this._oMoreMenuButton=null}if(this._oMoreMenu){this._oMoreMenu.destroy();this._oMoreMenu=null}if(this._oMenu){this._oMenu.destroy();this._oMenu=null}if(this._oHoldItem){this._oHoldItem.destroy()}if(this._oUnFollowItem){this._oUnFollowItem.destroy()}if(this._oUnHoldItem){this._oUnHoldItem.destroy()}if(this._sResizeListenerId){n.deregister(this._sResizeListenerId);this._sResizeListenerId=null}this.mActionKeys=null;this.oRb=null;this.destroyAggregation("_socialActions");this.destroyAggregation("_businessActionButtons");if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation}};y.prototype.isActive=function(){var t=this.getDomRef()!=null;return t};y.prototype._getLocalizedText=function(t,e){var o;if(this.oRb){o=this.oRb.getText(t)}if(o&&e){for(var i=0;i<e.length;i++){o=o.replace("{"+i+"}",e[i])}}return o?o:t};y.prototype._getSocialAction=function(t){var e=this.mActionMap[t];if(!e){e=new s({id:this.getId()+"-"+t});switch(t){case this.mActionKeys.Update:e.name=this.mActionKeys.Update;e.tooltipKey="ACTIONBAR_UPDATE_ACTION_TOOLTIP";e.cssClass="sapUiUx3ActionBarUpdateAction";e.fnInit=function(t){t._oUpdatePopup=new r({id:t.getId()+"-UpdateActionPopup"}).addStyleClass("sapUiUx3ActionBarUpdatePopup");t._oUpdatePopup._ensurePopup().setAutoClose(true);t._feeder=new a({id:t.getId()+"-Feeder",type:A.Comment,thumbnailSrc:t.getThingIconURI(),text:"",submit:jQuery.proxy(function(t){var e=t.getParameter("text");this.fireFeedSubmit({text:e});this._oUpdatePopup.close()},t)});t._feeder.addStyleClass("sapUiUx3ActionBarFeeder");t._oUpdatePopup.addContent(t._feeder)};e.fnActionSelected=function(t,o){o._setUpdateState(!o.getUpdateState());if(o._oUpdatePopup.isOpen()){o._oUpdatePopup.close()}else{var i,n,s;o._oUpdatePopup.setPosition(f.BeginBottom,f.BeginTop,t.getSource().getDomRef(),"-8 -13","none");o._oUpdatePopup.open();i=jQuery(o._oUpdatePopup.getDomRef());n=jQuery(window).height();s=jQuery(o.getDomRef()).offset().top;i.css("top","auto").css("bottom",n-s+7+"px");setTimeout(function(){if(o._feeder.getFocusDomRef()){o._feeder.getFocusDomRef().focus()}},1e3)}o._updateSocialActionDomRef(e)};e.fnExit=function(t){if(t._oUpdatePopup){t._oUpdatePopup.destroy();t._oUpdatePopup=null}};e.fnCalculateState=function(t){var e=null;if(t.getUpdateState()){e="Selected"}return e};break;case this.mActionKeys.Follow:var o=e;e.name=this.mActionKeys.Follow;e.tooltipKey="ACTIONBAR_FOLLOW_ACTION_TOOLTIP_FOLLOW";e.cssClass="sapUiUx3ActionBarFollowAction";e.isMenu=function(t){return t.getFollowState()!=M.Default};e.fnActionSelected=function(t,e){if(e.getFollowState()==M.Default){e._setFollowState(M.Follow);e.fireActionSelected({id:o.name,state:"followState",action:o});this._fnPrepareFollowMenu(t,e)}else{e._oMenu.open(false,o.getFocusDomRef(),f.BeginBottom,f.BeginTop,o.getDomRef())}};e.fnCalculateState=function(t){return t.getFollowState()};e._fnPrepareFollowMenu=function(t,o){var i=sap.ui.resource("sap.ui.ux3","themes/"+g.getTheme());if(o.mActionMap[o.mActionKeys.Follow]){if(!o._oUnFollowItem){o._oUnFollowItem=new l({id:o.getId()+"-unfollowState",text:o._getLocalizedText("TI_FOLLOW_ACTION_MENU_TXT_UNFOLLOW"),icon:i+"/img/menu_unlisten.png"})}if(!o._oHoldItem){o._oHoldItem=new l({id:o.getId()+"-holdState",text:o._getLocalizedText("TI_FOLLOW_ACTION_MENU_TXT_HOLD"),icon:i+"/img/menu_hold.png"})}if(!o._oUnHoldItem){o._oUnHoldItem=new l({id:o.getId()+"-unholdState",text:o._getLocalizedText("TI_FOLLOW_ACTION_MENU_TXT_UNHOLD"),icon:i+"/img/menu_follow.png"})}if(!o._oMenu){o._oMenu=new c({id:o.getId()+"-followActionMenu"});o._oMenu.attachItemSelect(jQuery.proxy(function(t){this._fnFollowMenuSelected(t,o)},this));o._oMenu.addItem(o._oHoldItem);o._oMenu.addItem(o._oUnHoldItem);o._oMenu.addItem(o._oUnFollowItem)}if(o.getFollowState()==M.Default){o.mActionMap[o.mActionKeys.Follow].setTooltip(o._getLocalizedText("TI_FOLLOW_ACTION_TOOLTIP_FOLLOW"));o._oHoldItem.setVisible(false);o._oUnFollowItem.setVisible(false);o._oUnHoldItem.setVisible(false)}else if(o.getFollowState()==M.Follow){o.mActionMap[o.mActionKeys.Follow].setTooltip(o._getLocalizedText("TI_FOLLOW_ACTION_TOOLTIP_STOPPAUSE_FOLLOW"));o._oHoldItem.setVisible(true);o._oUnFollowItem.setVisible(true);o._oUnHoldItem.setVisible(false)}else if(o.getFollowState()==M.Hold){o.mActionMap[o.mActionKeys.Follow].setTooltip(o._getLocalizedText("TI_FOLLOW_ACTION_TOOLTIP_STOPCONTINUE_FOLLOW"));o._oHoldItem.setVisible(false);o._oUnFollowItem.setVisible(true);o._oUnHoldItem.setVisible(true)}o._updateSocialActionDomRef(e)}};e._fnFollowMenuSelected=function(t,e){if(e.mActionMap[e.mActionKeys.Follow]){var i=t.getParameters().item.getId();if(i==e.getId()+"-followState"){e._setFollowState(M.Follow)}else if(i==e.getId()+"-unfollowState"){e._setFollowState(M.Default)}else if(i==e.getId()+"-holdState"){e._setFollowState(M.Hold)}else if(i+"-unholdState"){e._setFollowState(M.Follow)}e.fireActionSelected({id:o.name,state:i,action:o});this._fnPrepareFollowMenu(t,e)}};break;case this.mActionKeys.Favorite:var i=e;e.name=this.mActionKeys.Favorite;e.tooltipKey="ACTIONBAR_FAVORITE_ACTION_TOOLTIP";e.cssClass="sapUiUx3ActionBarFavoriteAction";e.fnActionSelected=function(t,o){if(o.getFavoriteState()==true){o._setFavoriteState(false)}else{o._setFavoriteState(true)}o.fireActionSelected({id:i.name,state:o.getFavoriteState(),action:i});o._updateSocialActionDomRef(e)};e.fnCalculateState=function(t){var e=null;if(t.getFavoriteState()){e="Selected"}return e};break;case this.mActionKeys.Flag:var n=e;e.name=this.mActionKeys.Flag;e.tooltipKey="ACTIONBAR_FLAG_ACTION_TOOLTIP";e.cssClass="sapUiUx3ActionBarFlagAction";e.fnActionSelected=function(t,o){o._setFlagState(!o.getFlagState());o.fireActionSelected({id:n.name,state:o.getFlagState(),action:n});o._updateSocialActionDomRef(e)};e.fnCalculateState=function(t){var e=null;if(t.getFlagState()){e="Selected"}return e};break;case this.mActionKeys.Open:e.name=this.mActionKeys.Open;e.tooltipKey="ACTIONBAR_OPEN_THING_ACTION_TOOLTIP";e.cssClass="sapUiUx3ActionBarOpenThingAction";break;default:_.warning('Function "sap.ui.ux3.ActionBar.prototype._getSocialAction" was called with unknown action key "'+t+'".\n\tNo action will not be rendered.');return undefined}}return e};y.prototype._updateSocialActionDomRef=function(t){var e=t.$();if(e){e.attr("class",t.cssClass);if(t.fnCalculateState){e.addClass("sapUiUx3ActionBarAction");e.addClass(t.fnCalculateState(this))}if(t.name==this.mActionKeys.Update||t.name==this.mActionKeys.Flag||t.name==this.mActionKeys.Favorite){e.attr("aria-pressed",t.fnCalculateState(this)=="Selected"?"true":"false")}if(t.isMenu){e.attr("aria-haspopup",t.isMenu(this)?"true":"false")}}};y.prototype._rerenderSocialActions=function(){var t=this.$("socialActions");if(t.length>0){var e=sap.ui.getCore().createRenderManager();i.renderSocialActions(e,this);e.flush(t[0]);e.destroy()}};y.prototype._rerenderBusinessAction=function(t){var e=t.$();if(e.length>0){var o=sap.ui.getCore().createRenderManager();o.renderControl(t);o.flush(e[0].parentNode);o.destroy()}};y.prototype._rerenderBusinessActions=function(){if(!this.getAlwaysShowMoreMenu()){var t=this.$("businessActions");if(t&&t.length>0){var e=sap.ui.getCore().createRenderManager();i.renderBusinessActionButtons(e,this);e.flush(t[0]);e.destroy()}}this._onresize()};y.prototype.setFollowState=function(t){this.setProperty("followState",t);if(!this._oMenu){var e=this._getSocialAction(this.mActionKeys.Follow);e._fnPrepareFollowMenu(null,this)}return this};y.prototype.setShowUpdate=function(t){this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Update),t);this.setProperty("showUpdate",t,true);return this};y.prototype.setShowFollow=function(t){this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Follow),t);this.setProperty("showFollow",t,true);return this};y.prototype.setShowFlag=function(t){this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Flag),t);this.setProperty("showFlag",t,true);return this};y.prototype.setShowFavorite=function(t){this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Favorite),t);this.setProperty("showFavorite",t,true);return this};y.prototype.setShowOpen=function(t){this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Open),t);this.setProperty("showOpen",t,true);return this};y.prototype._setFollowState=function(t){this.setProperty("followState",t,true);return this};y.prototype._setFlagState=function(t){this.setProperty("flagState",t,true);return this};y.prototype._setUpdateState=function(t){this.setProperty("updateState",t,true);return this};y.prototype._setFavoriteState=function(t){this.setProperty("favoriteState",t,true);return this};y.prototype.setThingIconURI=function(t){this.setProperty("thingIconURI",t,true);var e=this.mActionMap[this.mActionKeys.Update];if(e&&this._feeder){this._feeder.setThumbnailSrc(t)}else{_.warning('Function "sap.ui.ux3.ActionBar.setThingIconURI": failed to set new icon "'+t+'".\n\tReason: either updateAction '+e+" or feeder "+this._feeder+" is not defined.")}return this};y.prototype.setDividerWidth=function(t){this._iSocActListWidth=null;this.setProperty("dividerWidth",t);return this};y.prototype.setAlwaysShowMoreMenu=function(t){var e=this.getProperty("alwaysShowMoreMenu");var o=this.getAggregation("businessActions",[]);this.setProperty("alwaysShowMoreMenu",t,true);if(e!=t&&o){if(!t){for(var i=0;i<o.length;i++){var n=o[i];this._createButtonForAction(n,this._oMoreMenu._getMenuItemForAction(n))}}else{var s=this._getBusinessActionButtons();for(var r=0;r<s.length;r++){if(s[r].oMenuItem){s[r].oMenuItem.setVisible(true);s[r].oMenuItem=null}}this.destroyAggregation("_businessActionButtons")}this._styleMoreMenuButton()}this._bCallOnresize=true;this._rerenderBusinessActions();return this};y.prototype.closePopups=function(){if(this._oUpdatePopup){this._oUpdatePopup.close()}if(this._oMoreMenu){this._oMoreMenu.close()}if(this._oMenu){this._oMenu.close()}};y.prototype._removeSocialAction=function(t){var e=null;if(t.name&&this.mActionMap[t.name]){if(this.mActionMap[t.name].fnExit){this.mActionMap[t.name].fnExit(this)}e=this.removeAggregation("_socialActions",this.mActionMap[t.name],true);this.mActionMap[t.name].destroy();delete this.mActionMap[t.name];this._rerenderSocialActions();this._iSocActListWidth=null}return e};y.prototype._removeAllSocialActions=function(){for(var t in this.mActionMap){if(this.mActionMap[t]&&this.mActionMap[t].fnExit){this.mActionMap[t].fnExit(this)}}this.mActionMap={};var e=this.removeAllAggregation("_socialActions",true);this._iSocActListWidth=null;this._rerenderSocialActions();return e};y.prototype._addSocialAction=function(t,e){var o=null;if(!this.mActionMap[t.name]){o=this._prepareSocialAction(t,e);if(t.fnInit){t.fnInit(this)}this._iSocActListWidth=null}if(o){this._rerenderSocialActions()}return o};y.prototype._prepareSocialAction=function(t,e){t.attachSelect(jQuery.proxy(function(e){if(t.fnActionSelected){t.fnActionSelected(e,this)}else{this.fireActionSelected({id:t.name,action:t})}},this));t.setTooltip(this._getLocalizedText(t.tooltipKey));this.mActionMap[t.name]=t;if(e){this.insertAggregation("_socialActions",t,e,true)}else{this.addAggregation("_socialActions",t,true)}return t};y.prototype._setShowSocialAction=function(t,e){return e?this._addSocialAction(t):this._removeSocialAction(t)};y.prototype.addBusinessAction=function(t){return this._addBusinessAction(t)};y.prototype.insertBusinessAction=function(t,e){return this._addBusinessAction(t,e)};y.prototype.removeBusinessAction=function(t){return this._removeBusinessAction(t,true)};y.prototype._removeBusinessAction=function(t,e){if(typeof t==="string"){var o;var i=t;for(var n=0;n<this.getBusinessActions().length;n++){var s=this.getBusinessActions()[n];if(s.getId()===i){o=s;break}}t=o}if(this._oMoreMenu){var r=this._oMoreMenu._getMenuItemForAction(t);if(r){this._oMoreMenu.removeItem(r);r.destroy()}if(this._oMoreMenu.getItems().length==0){this._oMoreMenuButton.destroy();this._oMoreMenuButton=null;this._oMoreMenu.destroy();this._oMoreMenu=null}}if(!this.getAlwaysShowMoreMenu()){var a=this._getButtonForAction(t);if(a){this.removeAggregation("_businessActionButtons",a,true);a.destroy()}}var u=this.removeAggregation("businessActions",t,true);if(e){this._rerenderBusinessActions()}return u};y.prototype.removeAllBusinessActions=function(){var t=this.getAggregation("businessActions",[]);if(t){for(var e=0;e<t.length;e++){this._removeBusinessAction(t[e],false)}}this._rerenderBusinessActions();var o=this.removeAllAggregation("businessActions",true);return o};y.prototype.destroyBusinessActions=function(){var t=this.getAggregation("businessActions",[]);if(t){for(var e=0;e<t.length;e++){var o=this._removeBusinessAction(t[e],false);if(o instanceof sap.ui.core.Element){o.destroy(true)}}}this._rerenderBusinessActions();var i=this.destroyAggregation("businessActions",true);return i};y.prototype._getBusinessActionButtons=function(){return this.getAggregation("_businessActionButtons",[])};y.prototype._addBusinessAction=function(t,e){var o;if(!e&&e!=0){o=this.addAggregation("businessActions",t,true)}else{o=this.insertAggregation("businessActions",t,e,true)}if(!this._oMoreMenuButton){this._oMoreMenuButton=new h(this.getId()+"-MoreMenuButton");this._oMoreMenuButton.setText(this._getLocalizedText("ACTIONBAR_BUTTON_MORE_TEXT"));this._oMoreMenuButton.setTooltip(this._getLocalizedText("ACTIONBAR_BUTTON_MORE_TOOLTIP"));this._oMoreMenuButton.setDockButton(f.EndTop);this._oMoreMenuButton.setDockMenu(f.EndBottom);this._styleMoreMenuButton();this._oMoreMenu=new c(this.getId()+"-MoreMenu",{ariaDescription:this._getLocalizedText("ACTIONBAR_BUTTON_MORE_TOOLTIP")});this._oMoreMenu._getMenuItemForAction=function(t){for(var e=0;e<this.getItems().length;e++){var o=this.getItems()[e];if(o.action==t){return o}}return null};this._oMoreMenuButton.setMenu(this._oMoreMenu)}var i=this._oMoreMenu.getId()+"-MenuItem-"+t.getId();var n=new l(i,{text:t.getText(),enabled:t.getEnabled()});n.action=t;n.attachSelect(jQuery.proxy(function(e){this.fireActionSelected({id:t.getId(),action:t})},this));if(e){this._oMoreMenu.insertItem(n,e)}else{this._oMoreMenu.addItem(n)}this._createButtonForAction(t,n,e);this._rerenderBusinessActions();return o};y.prototype._getMoreMenuButton=function(){return this._oMoreMenuButton};y.prototype._onresize=function(t){var e=this.$();if(e){var o=this.getActionBarMinWidth()+"px";if(e.css("minWidth")!=o){e.css("minWidth",o)}}if(!this.getAlwaysShowMoreMenu()&&this._oMoreMenuButton){var i=false;if(this._getBusinessActionButtons().length>1){var n=this._oMoreMenuButton.$().outerWidth();var s=e.outerWidth()-this._getSocialActionListMinWidth()-n;var r=this._getBusinessActionButtons();var a=0;for(var u=0;u<r.length;u++){var l=r[u].$().parent();a+=l.outerWidth();if(u==r.length-1){a-=n}if(a>=s){if(l.length>0){l.css("display","none");if(r[u].oMenuItem){r[u].oMenuItem.setVisible(true)}i=true}}else{if(l.length>0){l.css("display","");if(d.browser.msie){this._rerenderBusinessAction(r[u])}if(r[u].oMenuItem){r[u].oMenuItem.setVisible(false)}}}}i|=this.getAggregation("businessActions").length>r.length}var c=this._oMoreMenuButton.$().parent();if(c.length>0){i?c.css("display",""):c.css("display","none")}if(!i&&this._oMoreMenu){this._oMoreMenu.close()}}this._setItemNavigation()};y.prototype.onBeforeRendering=function(){n.deregister(this._sResizeListenerId);this._sResizeListenerId=null};y.prototype.onAfterRendering=function(){this._sResizeListenerId=n.register(this.getDomRef(),jQuery.proxy(this._onresize,this));if(this._bCallOnresize){this._onresize()}this._setItemNavigation()};y.prototype._getSocialActionListMinWidth=function(){if(!this._iSocActListWidth){if(this.getDividerWidth()){this._iSocActListWidth=parseInt(this.getDividerWidth())}else{var t=this.getAggregation("_socialActions",[]);var e=t.length;this._iSocActListWidth=24*e+12}}return this._iSocActListWidth};y.prototype.getActionBarMinWidth=function(){var t=this._getSocialActionListMinWidth();var e=this._oMoreMenuButton;if(!this.getAlwaysShowMoreMenu()&&this._getBusinessActionButtons().length==1){e=this._getBusinessActionButtons()[0]}if(e){var o=e.$().parent();if(o){t+=o.outerWidth()-3}}return t};y.prototype._getButtonForAction=function(t){for(var e=0;e<this._getBusinessActionButtons().length;e++){var o=this._getBusinessActionButtons()[e];if(o.action==t){return o}}return null};y.prototype._createButtonForAction=function(t,e,o){if(!this.getAlwaysShowMoreMenu()&&!t.showInMoreMenu){var i=new p({id:this.getId()+"-"+t.getId()+"Button",text:t.getText(),tooltip:t.getTooltip(),enabled:t.getEnabled()});i.attachPress(jQuery.proxy(function(e){this.fireActionSelected({id:t.getId(),action:t})},this));i.oMenuItem=e;i.action=t;if(o){this.insertAggregation("_businessActionButtons",i,o,true)}else{this.addAggregation("_businessActionButtons",i,true)}return i}return null};y.prototype._styleMoreMenuButton=function(){if(this._oMoreMenuButton){if(this.getAlwaysShowMoreMenu()){this._oMoreMenuButton.setLite(true);this._oMoreMenuButton.addStyleClass("sapUiUx3ActionBarLiteMoreButton")}else{this._oMoreMenuButton.setLite(false);this._oMoreMenuButton.removeStyleClass("sapUiUx3ActionBarLiteMoreButton")}}};y.prototype._setItemNavigation=function(){if(this.getDomRef()){this._oItemNavigation.setRootDomRef(jQuery(this.getDomRef()).get(0));var t=[];var e=this.getAggregation("_socialActions",[]);for(var o=0;o<e.length;o++){t.push(e[o].getDomRef())}e=this.getAggregation("_businessActionButtons",[]);for(var o=0;o<e.length;o++){t.push(e[o].getDomRef())}if(this._oMoreMenuButton&&this._oMoreMenuButton.getDomRef()){t.push(this._oMoreMenuButton.getDomRef())}this._oItemNavigation.setItemDomRefs(t)}};y.prototype.invalidate=function(e){if(e instanceof s){var o=sap.ui.getCore().byId(this.getId()+"-"+e.getId()+"Button");var i=this._oMoreMenu&&this._oMoreMenu._getMenuItemForAction(e);if(o){o.setTooltip(e.getTooltip());o.setText(e.getText());o.setEnabled(e.getEnabled())}if(i){i.setTooltip(e.getTooltip());i.setText(e.getText());i.setEnabled(e.getEnabled())}if(!o&&!i){t.prototype.invalidate.apply(this,arguments)}}t.prototype.invalidate.apply(this,arguments)};return y});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/ActionBarRenderer", ["./library","sap/ui/core/Configuration"],function(t,e){"use strict";var i=t.ActionBarSocialActions;var n={apiVersion:2};n.render=function(t,i){t.openStart("div",i);t.class("sapUiUx3ActionBar");if(e.getAccessibility()){t.attr("role","toolbar")}t.openEnd();t.openStart("ul",i.getId()+"-socialActions");t.class("sapUiUx3ActionBarSocialActions");t.style("min-width",i._getSocialActionListMinWidth()+"px");t.openEnd();this.renderSocialActions(t,i);t.close("ul");t.openStart("ul",i.getId()+"-businessActions");t.class("sapUiUx3ActionBarBusinessActions");t.openEnd();this.renderBusinessActionButtons(t,i);t.close("ul");t.close("div")};n.renderBusinessActionButtons=function(t,e){var i=e._getBusinessActionButtons();var n=e._getMoreMenuButton();if(i&&i.length>0){for(var o=0;o<i.length;o++){var a=i[o];t.openStart("li");t.class("sapUiUx3ActionBarItemRight");t.openEnd();t.renderControl(a);t.close("li")}this._renderMoreMenuButton(t,n)}else if(n){this._renderMoreMenuButton(t,n)}};n._renderMoreMenuButton=function(t,e){if(e){t.openStart("li");t.class("sapUiUx3ActionBarItemRight");t.class("sapUiUx3ActionBarMoreButton");t.openEnd();t.renderControl(e);t.close("li")}};n.renderSocialActions=function(t,e){var n=e.mActionMap;var o=e.mActionKeys;if(n[o.Update]){this._renderSocialActionListItem(t,e,n[o.Update])}if(n[o.Follow]){this._renderSocialActionListItem(t,e,n[o.Follow])}if(n[o.Flag]){this._renderSocialActionListItem(t,e,n[o.Flag])}if(n[o.Favorite]){this._renderSocialActionListItem(t,e,n[o.Favorite])}if(n[o.Open]){this._renderSocialActionListItem(t,e,n[o.Open])}for(var a in n){if(!(a in i)){this._renderSocialActionListItem(t,e,n[a])}}};n._renderSocialActionListItem=function(t,e,i){if(i&&!i.hide){t.openStart("li");t.class("sapUiUx3ActionBarItem");t.openEnd();this._renderSocialAction(t,e,i);t.close("li")}};n._renderSocialAction=function(t,e,i){t.openStart("a",i);t.attr("role","button");t.attr("aria-disabled","false");t.attr("aria-haspopup",i.isMenu&&i.isMenu(e)?"true":"false");if(i.name===e.mActionKeys.Flag||i.name===e.mActionKeys.Favorite){t.attr("aria-pressed",i.fnCalculateState(e)==="Selected"?"true":"false")}t.attr("tabindex","0");t.class(i.cssClass);if(i.fnCalculateState){t.class(i.fnCalculateState(e))}t.class("sapUiUx3ActionBarAction");if(i.getTooltip()){t.attr("title",i.getTooltip())}if(i.text){t.attr("text",e.getLocalizedText(i.getText()))}t.openEnd();t.close("a")};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/Collection", ["sap/ui/core/Element","sap/ui/model/SelectionModel","./library"],function(e,t,i){"use strict";var o=e.extend("sap.ui.ux3.Collection",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{title:{type:"string",group:"Appearance",defaultValue:null},editable:{type:"boolean",group:"Appearance",defaultValue:false},multiSelection:{type:"boolean",group:"Accessibility",defaultValue:false}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item"}},associations:{selectedItems:{type:"sap.ui.core.Item",multiple:true,singularName:"selectedItem"}},events:{selectionChanged:{},propertyChanged:{}}}});o.prototype.init=function(){this.oCollectionSelection=new t(t.SINGLE_SELECTION)};o.prototype.setMultiSelection=function(e){if(e){this.oCollectionSelection.setSelectionMode(t.MULTI_SELECTION)}else{this.oCollectionSelection.setSelectionMode(t.SINGLE_SELECTION);this.removeAllSelectedItems()}return this.setProperty("multiSelection",e)};o.prototype.setEditable=function(e){this.setProperty("editable",e,true);this.firePropertyChanged();return this};o.prototype.setTitle=function(e){this.setProperty("title",e);this.fireEvent("_titleChanged",{newTitle:this.getProperty("title")});return this};o.prototype.addSelectedItem=function(e){var i;if(typeof e=="object"){i=e}else{i=sap.ui.getCore().byId(e)}if(this.getSelectedItems().indexOf(i.getId())>=0){return this}var o=this.indexOfItem(i);if(o>-1){if(this.oCollectionSelection.getSelectionMode()==t.SINGLE_SELECTION){this.removeAllAssociation("selectedItems",true);this.oCollectionSelection.clearSelection()}this.oCollectionSelection.addSelectionInterval(o,o)}this.addAssociation("selectedItems",e,true);this.fireSelectionChanged();return this};o.prototype.removeSelectedItem=function(e){if(this.getSelectedItems().length<=1){return}var t=this.removeAssociation("selectedItems",e,true);var i;if(typeof e=="object"){i=this.indexOfItem(e)}else{i=this.indexOfItem(sap.ui.getCore().byId(e))}if(i>-1){this.oCollectionSelection.removeSelectionInterval(i,i)}this.fireSelectionChanged();return t};o.prototype.removeAllSelectedItems=function(){var e=this.removeAllAssociation("selectedItems",true);this.oCollectionSelection.clearSelection();if(this.getItems().length>0){this.addSelectedItem(this.getItems()[0])}else{this.fireSelectionChanged()}return e};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/CollectionInspector", ["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/delegate/ItemNavigation","./library","./CollectionInspectorRenderer","sap/ui/commons/ToggleButton","sap/ui/commons/SegmentedButton","sap/ui/commons/Button"],function(jQuery,t,e,o,i,n,s,r){"use strict";var l=t.extend("sap.ui.ux3.CollectionInspector",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{sidebarVisible:{type:"boolean",group:"Appearance",defaultValue:true},fitParent:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{collections:{type:"sap.ui.ux3.Collection",multiple:true,singularName:"collection"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},associations:{selectedCollection:{type:"sap.ui.ux3.Collection",multiple:false}},events:{collectionSelected:{},itemSelectionChanged:{},editCollection:{}}}});l.prototype.init=function(){var t=this;if(!this._oItemNavigation){this._oItemNavigation=new e;this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation)}var o=new n(this.getId()+"-toggleButton");o.setParent(this);o.setTooltip("This button opens and closes the sidebar");o.attachPress(function(){if(o.getPressed()){t.openSidebar()}else{t.closeSidebar()}});this._oToggleButton=o;var i=new s(this.getId()+"-selector");i.attachSelect(function(e){var o=this.indexOfButton(sap.ui.getCore().byId(this.getSelectedButton()));var i=t.getCollections()[o];t.setSelectedCollection(i);t.fireCollectionSelected({collection:i});t.openSidebar()});this._oCollectionSelector=i;var l=new r;l.addStyleClass("sapUiUx3EditCollectionButton");l.setText("Collection");l.setTooltip("This button opens an edit dialog for the current collection");l.attachPress(function(){t.fireEditCollection()});this._oEditButton=l};l.prototype.exit=function(){this._oToggleButton.destroy();this._oToggleButton=null;this._oEditButton.destroy();this._oEditButton=null;this._oCollectionSelector.destroy();this._oCollectionSelector=null;if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation}};l.prototype.onBeforeRendering=function(){this._oToggleButton.setPressed(this.getSidebarVisible())};l.prototype.onAfterRendering=function(){if(!this.getSelectedCollection()){if(this.getCollections().length>0){this.setSelectedCollection(this.getCollections()[0])}}else{var t=sap.ui.getCore().byId(this.getSelectedCollection());if(t.getSelectedItems().length==0&&t.getItems().length>0){t.addSelectedItem(t.getItems()[0])}}this.setElementsHeight();this.updateItemNavigation();this.refreshSelectionHighlighting()};l.prototype.onclick=function(t){var e=t.target;if(jQuery(e).hasClass("sapUiUx3CICollectionListItem")){var o=sap.ui.getCore().byId(this.getSelectedCollection());if(o.getSelectedItems().indexOf(e.id)>=0){o.removeSelectedItem(e.id)}else{o.addSelectedItem(e.id)}this.refreshSelectionHighlighting();this.fireItemSelectionChanged({selectedItems:o.getSelectedItems()})}};l.prototype.getToggleButton=function(){return this._oToggleButton};l.prototype.getCollectionSelector=function(){return this._oCollectionSelector};l.prototype.rerenderSidebar=function(){var t=sap.ui.getCore().byId(this.getSelectedCollection());if(t&&t.getEditable()){this._oEditButton.setVisible(true)}else{this._oEditButton.setVisible(false)}var e=this.$("sidebar");if(e.length>0){var o=sap.ui.getCore().createRenderManager();this.getRenderer().renderSidebar(o,this);o.flush(e[0]);o.destroy()}if(t&&t.getEditable()){this.$("sidebar").addClass("sapUiUx3CIWithEditButton")}else{this.$("sidebar").removeClass("sapUiUx3CIWithEditButton")}this.updateItemNavigation();this.refreshSelectionHighlighting()};l.prototype.updateItemNavigation=function(){var t=[];var e=this.$("sidebar").find("li");jQuery.each(e,function(e,o){t.push(o)});this._oItemNavigation.setItemDomRefs(t);this._oItemNavigation.setRootDomRef(this.$("sidebar ul")[0])};l.prototype.rerenderContent=function(){var t=this.$("content");if(t.length>0){var e=sap.ui.getCore().createRenderManager();this.getRenderer().renderContent(e,this);e.flush(t[0]);e.destroy()}this.setElementsHeight()};l.prototype.setElementsHeight=function(){if(this.getFitParent()){return}var t=this.$("sidebar");var e=this.$("content");var o=e.outerHeight(true);var i=e.outerHeight(true)-e.height();var n=t.outerHeight(true)-t.height();t.height(Math.max(200,o)-n);e.height(Math.max(200,o)-i)};l.prototype.openSidebar=function(){var t=this.$();var e=this.$("sidebar");var o=this.$("content");e.stop(true,true).animate({width:150},300,function(){e.css("width","")});o.stop(true,true).animate({left:150},300,function(){o.css("left","")});t.removeClass("sapUiUx3CISidebarClosed");t.addClass("sapUiUx3CISidebarOpened");this._oToggleButton.setPressed(true)};l.prototype.closeSidebar=function(){var t=this.$();var e=this.$("sidebar");var o=this.$("content");e.stop(true,true).animate({width:0},300,function(){e.css("width","")});o.stop(true,true).animate({left:0},300,function(){o.css("left","")});t.removeClass("sapUiUx3CISidebarOpened");t.addClass("sapUiUx3CISidebarClosed");this._oToggleButton.setPressed(false)};l.prototype.insertCollection=function(t,e){var o=new r;o.setText(t.getTitle());t.attachEvent("_titleChanged",function(t){o.setText(t.getParameter("newTitle"))});var i=this;t.attachSelectionChanged(function(){i.refreshSelectionHighlighting()});t.attachPropertyChanged(function(){i.rerenderSidebar()});this._oCollectionSelector.insertButton(o,e);return this.insertAggregation("collections",t,e)};l.prototype.addCollection=function(t){var e=new r;e.setText(t.getTitle());t.attachEvent("_titleChanged",function(t){e.setText(t.getParameter("newTitle"))});var o=this;t.attachSelectionChanged(function(){o.refreshSelectionHighlighting()});t.attachPropertyChanged(function(){o.rerenderSidebar()});this._oCollectionSelector.addButton(e);return this.addAggregation("collections",t)};l.prototype.removeCollection=function(t){var e;if(typeof t=="object"){e=this.indexOfCollection(t)}else{e=this.indexOfCollection(sap.ui.getCore().byId(t))}var o=this._oCollectionSelector.getButtons()[e];this._oCollectionSelector.removeButton(o);var i=this.removeAggregation("collections",t);if(i&&this.getSelectedCollection()==i.getId()){this.setSelectedCollection(null)}return i};l.prototype.removeAllCollections=function(){this._oCollectionSelector.removeAllButtons();this.setSelectedCollection(null);return this.removeAllAggregation("collections")};l.prototype.destroyCollections=function(){this._oCollectionSelector.destroyButtons();this.setSelectedCollection(null);return this.destroyAggregation("collections")};l.prototype.setSelectedCollection=function(t){this.setAssociation("selectedCollection",t,true);if(!t){this._oEditButton.setVisible(false)}else{this._oCollectionSelector.setSelectedButton(this._oCollectionSelector.getButtons()[this.indexOfCollection(t)]);var e=sap.ui.getCore().byId(this.getSelectedCollection());if(e.getSelectedItems().length==0&&e.getItems().length>0){e.addSelectedItem(e.getItems()[0])}}this.rerenderSidebar();this.refreshSelectionHighlighting();return this};l.prototype.insertContent=function(t,e){this.insertAggregation("content",t,e,true);this.rerenderContent();return this};l.prototype.addContent=function(t){this.addAggregation("content",t,true);this.rerenderContent();return this};l.prototype.removeContent=function(t){var e=this.removeAggregation("content",t,true);this.rerenderContent();return e};l.prototype.removeAllContent=function(){var t=this.removeAllAggregation("content",true);this.rerenderContent();return t};l.prototype.destroyContent=function(){this.destroyAggregation("content",true);this.rerenderContent();return this};l.prototype.onfocusout=function(t){var e=jQuery(t.target);if(e.hasClass("sapUiUx3CICollectionListItem")){e.removeClass("sapUiUx3CISidebarFoc")}};l.prototype.onfocusin=function(t){var e=jQuery(t.target);if(e.hasClass("sapUiUx3CICollectionListItem")){e.addClass("sapUiUx3CISidebarFoc")}};l.prototype.onsapenter=function(t){var e=jQuery(t.target);if(e.hasClass("sapUiUx3CISidebarFoc")){this.onclick(t)}t.stopPropagation()};l.prototype.onsapspace=function(t){var e=jQuery(t.target);if(e.hasClass("sapUiUx3CISidebarFoc")){this.onclick(t)}t.stopPropagation()};l.prototype.refreshSelectionHighlighting=function(){var t=this.$("sidebar").find(".sapUiUx3CICollectionListItem");var e;if(this.getSelectedCollection()){e=sap.ui.getCore().byId(this.getSelectedCollection()).getSelectedItems()}else{e=[]}t.each(function(t,o){if(e.indexOf(o.id)>=0){jQuery(o).addClass("sapUiUx3CICollectionListItemSelected");jQuery(o).attr("aria-selected",true)}else{jQuery(o).removeClass("sapUiUx3CICollectionListItemSelected");jQuery(o).attr("aria-selected",false)}})};l.prototype.getEditButton=function(){return this._oEditButton};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/CollectionInspectorRenderer", [],function(){"use strict";var e={};e.render=function(e,t){e.write("<div");e.addClass("sapUiUx3CI");if(t.getSidebarVisible()){e.addClass("sapUiUx3CISidebarOpened")}else{e.addClass("sapUiUx3CISidebarClosed")}if(t.getFitParent()){e.addClass("sapUiUx3CIFitParent")}e.writeClasses();e.writeControlData(t);e.write(">");e.write("<div");e.addClass("sapUiUx3CIToolBar");e.writeClasses();e.write(">");this.renderToggleButton(e,t);this.renderCollectionSelector(e,t);e.write("</div>");e.write("<div");e.addClass("sapUiUx3CISidebar");e.writeClasses();e.writeAttribute("id",t.getId()+"-sidebar");e.write(">");this.renderSidebar(e,t);e.write("</div>");e.write("<div");e.addClass("sapUiUx3CIContent");e.writeAttribute("id",t.getId()+"-content");e.writeClasses();e.write(">");this.renderContent(e,t);e.write("</div>");e.write("<div");e.addClass("sapUiUx3CIClear");e.writeClasses();e.write(">");e.write("</div>");e.write("</div>")};e.renderToggleButton=function(e,t){if(t.getToggleButton()){e.write("<div");e.writeAttribute("id",t.getId()+"-togglebutton");e.addClass("sapUiUx3CIToggleButton");e.writeClasses();e.write(">");e.renderControl(t.getToggleButton());e.write("</div>")}};e.renderCollectionSelector=function(e,t){if(t.getCollectionSelector()){e.write("<div");e.addClass("sapUiUx3CICollectionSelector");e.writeClasses();e.write(">");e.renderControl(t.getCollectionSelector());e.write("</div>")}};e.renderSidebar=function(e,t){e.write("<div");e.addClass("sapUiUx3CICollectionListContainer");e.writeClasses();e.write(">");e.write('<ul tabindex="-1"');e.addClass("sapUiUx3CICollectionList");e.writeClasses();var i=sap.ui.getCore().byId(t.getSelectedCollection());if(t.getSelectedCollection()){e.writeAccessibilityState(i,{role:"listbox",multiselectable:i.getMultiSelection()})}e.write(">");if(t.getSelectedCollection()){var r=i.getItems().length;i.getItems().forEach(function(t,s){e.write('<li tabindex="-1"');e.writeElementData(t);e.writeAttributeEscaped("title",t.getText());e.addClass("sapUiUx3CICollectionListItem");e.writeClasses();e.writeAccessibilityState(t,{role:"option",selected:i.getSelectedItems().indexOf(t.getId())>=0,setsize:r,posinset:s});e.write(">");e.writeEscaped(t.getText());e.write("</li>")})}e.write("</ul></div>");e.renderControl(t.getEditButton())};e.renderContent=function(e,t){t.getContent().forEach(function(t){e.renderControl(t)})};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/DataSet", ["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/ResizeHandler","./library","./DataSetRenderer","sap/ui/model/SelectionModel","sap/ui/commons/SegmentedButton","sap/ui/commons/SearchField","sap/ui/commons/Toolbar","sap/ui/commons/Button","sap/base/Log"],function(jQuery,e,t,i,r,o,s,n,l,a,h){"use strict";var d=e.extend("sap.ui.ux3.DataSet",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{showToolbar:{type:"boolean",group:"Misc",defaultValue:true},showFilter:{type:"boolean",group:"Misc",defaultValue:true},showSearchField:{type:"boolean",group:"Misc",defaultValue:true},multiSelect:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{items:{type:"sap.ui.ux3.DataSetItem",multiple:true,singularName:"item",bindable:"bindable"},views:{type:"sap.ui.ux3.DataSetView",multiple:true,singularName:"view"},filter:{type:"sap.ui.core.Control",multiple:true,singularName:"filter"},_viewSwitches:{type:"sap.ui.core.Control",multiple:true,singularName:"_viewSwitch",visibility:"hidden"},_toolbar:{type:"sap.ui.commons.Toolbar",multiple:false,visibility:"hidden"}},associations:{selectedView:{type:"sap.ui.ux3.DataSetView",multiple:false}},events:{selectionChanged:{parameters:{oldLeadSelectedIndex:{type:"int"},newLeadSelectedIndex:{type:"int"}}},search:{parameters:{query:{type:"string"}}}}}});d.prototype.init=function(){var e=this,t;this.selectionModel=new o(o.SINGLE_SELECTION);this._oSegBut=new s;this._oSegBut.attachSelect(function(t){e.press(t)},e);this._oSegBut.show=false;this._oSearchField=new n(this.getId()+"-searchValue");this._oSearchField.setShowListExpander(false);this._oSearchField.setEnableListSuggest(false);this._oSearchField.setEnableFilterMode(true);this._oSearchField.setEnableClear(true);this._oSearchField.show=false;e=this;this._oSearchField.attachSearch(function(t){e.fireSearch(t.getParameters())});this.selectionModel.attachSelectionChanged(function(t){var i,r;var o=t.getParameters();if(o){r=o.leadIndex;i=o.oldIndex}e.fireSelectionChanged({oldLeadSelectedIndex:i,newLeadSelectedIndex:r});h.debug("Selection Change fired")});t=new l;this._setToolbar(t);this._iShiftStart=null};d.prototype.exit=function(){this._oSegBut.destroy();this._oSearchField.destroy();this.destroyAggregation("_toolbar")};d.prototype._prepareToolbar=function(){var e=this.getViews().length,t=this._getToolbar();if(e>1&&this._oSegBut.show==false){t.insertItem(this._oSegBut,0);this._oSegBut.show=true}else if(e<=1&&this._oSegBut.show){t.removeItem(this._oSegBut);this._oSegBut.show=false}if(this.getShowSearchField()&&this._oSearchField.show==false){t.insertRightItem(this._oSearchField,t.getRightItems().length);this._oSearchField.show=true}else if(!this.getShowSearchField()&&this._oSearchField.show==true){t.removeRightItem(this._oSearchField);this._oSearchField.show=false}};d.prototype.press=function(e,t){var i=e.getParameters().selectedButtonId,r=i.substring(i.lastIndexOf("-")+1),o=sap.ui.getCore().byId(this.getSelectedView());o.exitView(this.getItems());this.setSelectedView(r)};d.prototype.filter=function(){this.fireFilter({filterValue:this.getFilterValue()})};d.prototype.sort=function(){this.fireSort()};d.prototype.addSelectionInterval=function(e,t){this.selectionModel.addSelectionInterval(e,t);return this};d.prototype.setSelectionInterval=function(e,t){this.selectionModel.setSelectionInterval(e,t);return this};d.prototype.removeSelectionInterval=function(e,t){this.selectionModel.removeSelectionInterval(e,t);return this};d.prototype.getSelectedIndex=function(){return this.selectionModel.getLeadSelectedIndex()};d.prototype.getSelectedIndices=function(){return this.selectionModel.getSelectedIndices()||[]};d.prototype.clearSelection=function(){this.selectionModel.clearSelection();return this};d.prototype.selectItem=function(e){var t=e.getParameters(),i=e.getParameters().itemId,r=sap.ui.getCore().byId(i),o=this.getItems(),s=o.indexOf(r),n=this.getLeadSelection();if(!this.getMultiSelect()){if(n==s&&!t.shift){this.setLeadSelection(-1)}else{this.setLeadSelection(s)}this._iShiftStart=null}else{if(t.ctrl){if(!this.isSelectedIndex(s)){this.addSelectionInterval(s,s)}else{this.removeSelectionInterval(s,s)}if(this._iShiftStart>=0){this._iShiftStart=s}}if(t.shift){if(!this._iShiftStart&&this._iShiftStart!==0){this._iShiftStart=n}if(this._iShiftStart>=0&&t.ctrl){this.addSelectionInterval(this._iShiftStart,s)}else if(this._iShiftStart>=0&!t.ctrl){this.setSelectionInterval(this._iShiftStart,s)}else{this.setLeadSelection(s);this._iShiftStart=s}}if(!t.shift&&!t.ctrl){if(n==s&&s!=this._iShiftStart){this.setLeadSelection(-1)}else{this.setLeadSelection(s)}this._iShiftStart=null}}};d.prototype.prepareRendering=function(){var e,t=this.getViews().length;if(t==0){return}this._prepareToolbar();if(this._bDirty){e=sap.ui.getCore().byId(this.getSelectedView());if(e.exitView){e.exitView(this.getItems())}if(e.initView){e.initView(this.getItems())}this._bDirty=false}};d.prototype.getLeadSelection=function(){return this.selectionModel.getLeadSelectedIndex()};d.prototype.setLeadSelection=function(e){this.selectionModel.setLeadSelectedIndex(e)};d.prototype.isSelectedIndex=function(e){return this.selectionModel.isSelectedIndex(e)};d.prototype.getSelectedItemId=function(e){return this.getItems()[e].getId()};d.prototype.createViewSwitch=function(e,t){var i;if(e.getIcon()){i=new a({id:this.getId()+"-view-"+e.getId(),lite:true,icon:e.getIcon(),iconHovered:e.getIconHovered(),iconSelected:e.getIconSelected()})}else if(e.getName()){i=new a({id:this.getId()+"-view-"+e.getId(),text:e.getName(),lite:true})}else{i=new a({id:this.getId()+"-view-"+e.getId(),text:e.getId(),lite:true})}i._viewIndex=t;return i};d.prototype._rerenderToolbar=function(){var e=this.$("toolbar");this._prepareToolbar();if(e.length>0){var t=sap.ui.getCore().createRenderManager();r.renderToolbar(t,this);t.flush(e[0]);t.destroy()}};d.prototype._rerenderFilter=function(){var e=this.$("filter");if(e.length>0){var t=sap.ui.getCore().createRenderManager();r.renderFilterArea(t,this);t.flush(e[0]);if(this.getShowFilter()){e.removeClass("noPadding")}else{e.addClass("noPadding")}t.destroy()}};d.prototype.setMultiSelect=function(e){this.clearSelection();if(!e){this.setProperty("multiSelect",false);if(this.selectionModel){this.selectionModel.setSelectionMode(o.SINGLE_SELECTION)}}else{this.setProperty("multiSelect",true);if(this.selectionModel){this.selectionModel.setSelectionMode(o.MULTI_SELECTION)}}return this};d.prototype.removeItem=function(e){var t=this.removeAggregation("items",e,true);if(t){t.detachSelected(this.selectItem,this);t.destroyAggregation("_template",true);this._bDirty=true}return t};d.prototype.removeAllItems=function(){var e=this.getItems(),t;jQuery.each(e,function(e,t){t.destroyAggregation("_template",true);t.detachSelected(this.selectItem,this)});t=this.removeAllAggregation("items");this._bDirty=true;return t};d.prototype.destroyItems=function(){var e=this.destroyAggregation("items");this._bDirty=true;this.invalidate();return e};d.prototype.addItem=function(e){this.addAggregation("items",e,true);e.attachSelected(this.selectItem,this);this._bDirty=true;return this};d.prototype.insertItem=function(e,t){this.insertAggregation("items",e,t,true);e.attachSelected(this.selectItem,this);this._bDirty=true;return this};d.prototype.setFilterValue=function(e){this.setProperty("filterValue",e,true);return this};d.prototype.getFilterValue=function(){return this.getProperty("filterValue")};d.prototype.insertView=function(e,t){var i=this.createViewSwitch(e,t,true);if(!this.getSelectedView()){this.setSelectedView(e)}this.insertAggregation("views",e,t);this._oSegBut.insertButton(i,t);this._rerenderToolbar();return this};d.prototype.addView=function(e){var t=this.getViews().length,i=this.createViewSwitch(e,t);if(!this.getSelectedView()){this.setSelectedView(e)}this.addAggregation("views",e,true);this._oSegBut.addButton(i);this._rerenderToolbar();return this};d.prototype.removeView=function(e){var t=this.removeAggregation("views",e,true);if(t){if(this.getSelectedView()==t.getId()){this.setSelectedView(this.getViews()[0]);this._bDirty=true;t.invalidate()}else{this._rerenderToolbar()}this._oSegBut.removeButton(this.getId()+"-view-"+t.getId()).destroy()}return t};d.prototype.destroyViews=function(){this._oSegBut.destroyButtons();this.destroyAggregation("views");return this};d.prototype.removeAllViews=function(){var e=this.removeAllAggregation("views");this._oSegBut.destroyButtons();return e};d.prototype.setEnableSorting=function(e){this.setProperty("enableSorting",e,true);this._rerenderToolbar();return this};d.prototype.setEnableFiltering=function(e){this.setProperty("enableFiltering",e,true);this._rerenderToolbar();return this};d.prototype.setSelectedView=function(e){var t=this.getSelectedView();this.setAssociation("selectedView",e);if(t!=this.getSelectedView()){this._bDirty=true}if(this.getId()+"-view-"+this.getSelectedView()!==this._oSegBut.getSelectedButton()){this._oSegBut.setSelectedButton(this.getId()+"-view-"+this.getSelectedView())}return this};d.prototype.addToolbarItem=function(e){this._getToolbar().addItem(e);this._rerenderToolbar()};d.prototype.removeToolbarItem=function(e){this._getToolbar().removeItem(e);this._rerenderToolbar()};d.prototype.setShowToolbar=function(e){this.setProperty("showToolbar",e,true);this._rerenderToolbar();return this};d.prototype.setShowFilter=function(e){this.setProperty("showFilter",e,true);this._rerenderFilter();return this};d.prototype.setShowSearchField=function(e){this.setProperty("showSearchField",e,true);this._rerenderToolbar();return this};d.prototype._setToolbar=function(e){this.setAggregation("_toolbar",e,true);this._rerenderToolbar()};d.prototype._getToolbar=function(){return this.getAggregation("_toolbar")};d.prototype.refreshItems=function(){var e=this.getBinding("items"),t=sap.ui.getCore().byId(this.getSelectedView());e.bUseExtendedChangeDetection=true;if(t&&t.getItemCount&&t.getItemCount()){var i=Math.max(t.getItemCount(),this.getItems().length);if(i){e.getContexts(0,i)}else{e.getContexts()}}else{e.getContexts()}};d.prototype.updateItems=function(e){var t=this.mBindingInfos["items"],i=this.getMetadata().getAggregation("items"),r=sap.ui.getCore().byId(this.getSelectedView()),o=t.binding,s=t.factory,n,l,a,h,d=this,u=[];o.bUseExtendedChangeDetection=true;if(r&&r.getItemCount&&r.getItemCount()){var c=Math.max(r.getItemCount(),this.getItems().length);if(c){u=o.getContexts(0,c)}else{u=o.getContexts()}}else{u=o.getContexts()}if(u.diff&&e){var g=u.diff;for(var p=0;p<g.length;p++){l=this.getItems();h=g[p].index;if(g[p].type==="delete"){a=l[h];g[p].item=a;this.removeItem(a)}else if(u.diff[p].type==="insert"){a=s("",u[h]);a.setBindingContext(u[h],t.model);g[p].item=a;this.insertItem(a,h)}}if(r&&r.updateView){r.updateView(g)}}else{this[i._sDestructor]();jQuery.each(u,function(e,r){var o=d.getId()+"-"+e;n=s(o,r);n.setBindingContext(r,t.model);d[i._sMutator](n)})}l=this.getItems();for(var p=0,S=u.length;p<S;p++){l[p].setBindingContext(u[p],t.model)}};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/DataSetItem", ["sap/ui/core/Element","./library"],function(e,t){"use strict";var i=e.extend("sap.ui.ux3.DataSetItem",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{iconSrc:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},title:{type:"string",group:"Misc",defaultValue:"Title"},checkable:{type:"boolean",group:"Misc",defaultValue:true},subtitle:{type:"string",group:"Misc",defaultValue:"Subtitle"}},aggregations:{_template:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{selected:{parameters:{itemId:{type:"string"}}}}}});i.prototype.onclick=function(e){e.stopPropagation();var t=e.shiftKey;var i=!!(e.metaKey||e.ctrlKey);this.fireSelected({itemId:this.getId(),shift:t,ctrl:i})};i.prototype.ondblclick=function(e){this.onclick(e)};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/DataSetRenderer", ["sap/ui/thirdparty/jquery"],function(jQuery){"use strict";var e={};e.render=function(e,r){var i=null;r.prepareRendering();e.write("<div");e.writeControlData(r);e.addClass("sapUiUx3DS");e.writeClasses();e.writeStyles();e.write(">");e.write("<div id='"+r.getId()+"-toolbar'");e.addClass("sapUiUx3DSToolbar");if(!r.getShowToolbar()){e.addClass("noPadding")}e.writeClasses();e.write(">");this.renderToolbar(e,r);e.write("</div>");e.write("<div id='"+r.getId()+"-filter'");e.addClass("sapUiUx3DSFilterArea");if(!r.getShowFilter()){e.addClass("noPadding")}e.writeClasses();e.write(">");this.renderFilterArea(e,r);e.write("</div>");e.write("<div");e.writeAttribute("id",r.getId()+"-items");e.addClass("sapUiUx3DSItems");e.writeClasses();e.write(">");i=sap.ui.getCore().byId(r.getSelectedView());e.renderControl(i);e.write("</div>");e.write("</div>")};e.renderToolbar=function(e,r){if(r.getShowToolbar()){e.renderControl(r._getToolbar())}};e.renderFilterArea=function(e,r){var i=r.getFilter();if(r.getShowFilter()){jQuery.each(i,function(r,i){e.renderControl(i)})}};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/DataSetSimpleView", ["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/ResizeHandler","./library","./DataSetSimpleViewRenderer","sap/base/Log","sap/ui/model/ChangeReason"],function(jQuery,e,t,i,s,n,r){"use strict";var o=e.extend("sap.ui.ux3.DataSetSimpleView",{metadata:{deprecated:true,interfaces:["sap.ui.ux3.DataSetView"],library:"sap.ui.ux3",properties:{floating:{type:"boolean",group:"Misc",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:"Name of this View"},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconHovered:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconSelected:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},responsive:{type:"boolean",group:"Misc",defaultValue:false},itemMinWidth:{type:"int",group:"Misc",defaultValue:0},initialItemCount:{type:"int",group:"Appearance",defaultValue:0},reloadItemCount:{type:"int",group:"Appearance",defaultValue:0},scrollArea:{type:"any",group:"Appearance",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}},aggregations:{template:{type:"sap.ui.core.Control",multiple:false}}}});o.prototype.init=function(){this._oDataSet=this.getParent();this.items=[];this._bRendered=false;if(this.getInitialItemCount()>0&&this.getReloadItemCount()<=0){this.setReloadItemCount(this.getInitialItemCount())}this._bUsePagination=false};o.prototype.exit=function(){if(this.sResizeListenerId){t.deregister(this.sResizeListenerId);this.sResizeListenerId=null}};o.prototype.handleSelection=function(e){var t=this.getParent();var i=t.getItems(),s=t.getSelectedIndices();if(s.length>1){this._clearTextSelection()}jQuery.each(i,function(e,i){if(t.isSelectedIndex(e)){i.$().addClass("sapUiUx3DSSVSelected")}else{i.$().removeClass("sapUiUx3DSSVSelected")}})};o.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty()}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges()}}else if(document.selection&&document.selection.empty){try{document.selection.empty()}catch(e){}}};o.prototype.isItemSelected=function(e){var t=this.items.indexOf(e);if(t==-1){return false}return this.getParent().isSelectedIndex(t)};o.prototype.initView=function(e){this.getParent().attachSelectionChanged(this.handleSelection,this);this.items=this.items.concat(e);for(var t=0;t<e.length;t++){var i=this.getTemplate().clone();e[t].setAggregation("_template",i,true)}};o.prototype.updateView=function(e){var t;if(!this.getDomRef()){for(t=0;t<e.length;t++){if(e[t].type==="delete"){e[t].item.destroy()}}return}var i=sap.ui.getCore().createRenderManager(),s=this.items.length;for(t=0;t<e.length;t++){var n=e[t].item;var o=e[t].index;if(e[t].type==="insert"){var a=this.getTemplate().clone();n.setAggregation("_template",a,true);if(t==e.length-1&&s==0){var l={onAfterRendering:function(){this.calculateItemCounts();this.getParent().updateItems(r.Change);a.removeDelegate(l)}};a.addDelegate(l,false,this)}this.getRenderer().renderItem(i,this,n);i.flush(this.$()[0],false,o);this.items.splice(o,0,n)}else{this.items.splice(o,1);n.$().remove();n.destroy()}}if(e.length>0&&this.getFloating()&&this.getResponsive()){this._computeWidths(true)}i.destroy()};o.prototype.exitView=function(e){this.getParent().detachSelectionChanged(this.handleSelection,this);for(var t=0;t<e.length;t++){e[t].destroyAggregation("_template",true)}this.items=[]};o.prototype.initScrollArea=function(){var e=this.getScrollArea(),t=this;var i=function(e){t.getParent().updateItems(r.Change)};if(typeof e==="string"){e=jQuery(document.getElementById(e))}if(!e){e=this.$()}else if(e.is("html")){e=jQuery(document)}if(!this._bUsePagination){e.off("scroll",i)}else{e.on("scroll",i)}};o.prototype.checkScrollItems=function(){if(!this._bRendered){return}var e=this.getParent().mBindingInfos["items"],t=this.getScrollArea(),i=e.binding,s=this.getParent(),n=0,r,o,a,l;if(s.getItems().length===i.getLength()){return n}if(typeof t==="string"){t=jQuery(document.getElementById(t))}if(!t){t=this.$()}if(!t||t.length==0){return n}o=t[0];a=o.clientHeight;l=o.scrollHeight;if(t.is("html")){t=jQuery(document)}if(a==l){r=a+this._iScrollTrigger}else{r=a+this._iScrollTrigger+t.scrollTop()}if(r>0){var h=Math.floor(r/this._iRowHeight)*this._iItemsPerRow;var u=s.getItems().length;h=Math.ceil(h/this._iItemsPerRow)*this._iItemsPerRow;n=h-u}return n};o.prototype.getItemCount=function(){if(this._bUsePagination){var e=this.getParent().getItems().length,t=this.checkScrollItems();if(e==0){e+=this.getInitialItemCount()}else{e+=t}return e}else{return null}};o.prototype.setInitialItemCount=function(e){this.setProperty("initialItemCount",e);this._bUsePagination=e!=0;return this};o.prototype.onBeforeRendering=function(){if(this.sResizeListenerId){t.deregister(this.sResizeListenerId);this.sResizeListenerId=null}};o.prototype.onAfterRendering=function(){this._bRendered=true;this.initScrollArea();if(this.getFloating()&&this.getResponsive()||this._bUsePagination){this._height=-1;this._itemsPerRow=-1;this.onresize();this.sResizeListenerId=t.register(this.getDomRef(),jQuery.proxy(this.onresize,this))}};o.prototype.onThemeChanged=function(){if(this._bRendered){this.calculateItemCounts();this.getParent().updateItems(r.Change)}};o.prototype.onresize=function(){if(!this.getDomRef()){if(this.sResizeListenerId){t.deregister(this.sResizeListenerId);this.sResizeListenerId=null}return}if(this.getFloating()&&this.getResponsive()){this._computeWidths()}if(this._bUsePagination&&this.items.length>0){this.calculateItemCounts();this.getParent().updateItems(r.Change)}};o.prototype.setTemplate=function(e){this.setAggregation("template",e,true);if(this.getParent()){this.getParent().updateItems()}return this};o.prototype.calculateItemCounts=function(){if(this.getDomRef()&&sap.ui.getCore().isThemeApplied()){var e=this.$(),t=e.children().first();this._iItemsPerRow=Math.floor(e.outerWidth(true)/t.outerWidth(true));this._iNewRows=Math.ceil(this.getReloadItemCount()/this._iItemsPerRow);this._iNewItems=this._iItemsPerRow*this._iNewRows;this._iRowHeight=t.outerHeight(true);this._iScrollTrigger=this._iNewRows*this._iRowHeight}};o.prototype._computeWidths=function(e){var t=this.$();var i=Math.floor(t.width()/this.getItemMinWidth());var s=Math.floor(100/i);if(t.width()*s/100<this.getItemMinWidth()){i--;s=Math.floor(100/i)}if(e||this._height!=t.height()||this._itemsPerRow!=i){var n=-1;var r=this.getParent().getItems();var o,a;for(var l=0;l<r.length;l++){if(n==-1||n+1>i){n=0;o=100-i*s}var a=s;if(o>0){a++;o--}r[l].$().css("width",a+"%");n++}this._height=t.height();this._itemsPerRow=i}};o.prototype.setScrollArea=function(e,t){if(typeof e!=="string"&&!(e instanceof jQuery)){n.error("You can only pass a string (ID of scroll area DOM) or a jQuery object as scrollarea")}this.setProperty("scrollArea",e,t);return this};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/DataSetSimpleViewRenderer", [],function(){"use strict";var e={};e.render=function(e,t){e.write("<div");e.writeControlData(t);e.addClass("sapUiUx3DSSV");if(t.getFloating()){if(t.getResponsive()){e.addClass("sapUiUx3DSSVResponsive")}else{e.addClass("sapUiUx3DSSVFloating")}}else{e.addClass("sapUiUx3DSSVSingleRow")}if(t.getHeight()){e.addStyle("height",t.getHeight());e.addClass("sapUiUx3DSSVSA")}e.writeClasses();e.writeStyles();e.write(">");if(t.items){for(var i=0;i<t.items.length;i++){this.renderItem(e,t,t.items[i])}}e.write("</div>")};e.renderItem=function(e,t,i){e.write("<div");e.addClass("sapUiUx3DSSVItem");if(t.getFloating()){e.addClass("sapUiUx3DSSVFlow");if(t.getItemMinWidth()>0){e.writeAttribute("style","min-width:"+t.getItemMinWidth()+"px")}}if(t.isItemSelected(i)){e.addClass("sapUiUx3DSSVSelected")}e.writeClasses();e.writeElementData(i);e.write(">");e.renderControl(i.getAggregation("_template"));e.write("</div>")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/Exact", ["sap/ui/commons/Button","sap/ui/commons/Menu","sap/ui/commons/SearchField","sap/ui/commons/TextView","sap/ui/core/Control","./ExactArea","./ExactAttribute","./ExactBrowser","./library","./ExactRenderer","sap/ui/commons/library"],function(t,e,r,s,a,i,u,n,o,l,c){"use strict";var h=c.TextViewDesign;var g=a.extend("sap.ui.ux3.Exact",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{resultText:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"attributes",aggregations:{settingsMenu:{type:"sap.ui.commons.Menu",multiple:false,forwarding:{idSuffix:"-browser",aggregation:"optionsMenu"}},attributes:{type:"sap.ui.ux3.ExactAttribute",multiple:true,singularName:"attribute",forwarding:{idSuffix:"-browser",aggregation:"attributes"}},controls:{type:"sap.ui.core.Control",multiple:true,singularName:"control",visibility:"hidden"}},events:{search:{parameters:{query:{type:"string"}}},refineSearch:{parameters:{query:{type:"string"},changedAttribute:{type:"sap.ui.ux3.ExactAttribute"},allSelectedAttributes:{type:"object"}}}}}});g.prototype.init=function(){var t=this;this._searchArea=new i(this.getId()+"-searchArea",{toolbarVisible:false});this._searchArea.addStyleClass("sapUiUx3ExactSearchArea");this.addAggregation("controls",this._searchArea);this._search_input=new r(this.getId()+"-searchTF",{enableListSuggest:false});this._search_input.attachSearch(function(e){p(t,e)});this._search_input.addStyleClass("sapUiUx3ExactSearchText");this._searchArea.addContent(this._search_input);this._browser=new n(this.getId()+"-browser",{title:"Attributes"});this._browser.addStyleClass("sapUiUx3ExactBrowseArea");this.addAggregation("controls",this._browser);this._browser.attachAttributeSelected(function(e){d(t,e)});this._resultArea=new i(this.getId()+"-resultArea");this.addAggregation("controls",this._resultArea);this._resultText=new s(this.getId()+"-resultAreaTitle",{design:h.Bold});this._resultText.addStyleClass("sapUiUx3ExactViewTitle");this.addAggregation("controls",this._resultText);this._bDetailsVisible=false};g.prototype.getResultText=function(){return this._resultText.getText()};g.prototype.setResultText=function(t){this._resultText.setText(t);return this};g.prototype.getResultArea=function(){return this._resultArea};g.prototype.getSearchField=function(){return this._search_input};var p=function(t,e){t._sSearchQuery=e.getParameter("query");t.fireSearch({query:t._sSearchQuery});t._bDetailsVisible=true;t.invalidate()};var d=function(t,e){t.fireRefineSearch({query:t._sSearchQuery,changedAttribute:e.getParameter("attribute"),allSelectedAttributes:e.getParameter("allAttributes")})};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/ExactArea", ["sap/ui/commons/Toolbar","sap/ui/core/Control","./library","./ExactAreaRenderer","sap/ui/core/Element"],function(e,t,a,r,o){"use strict";var u=t.extend("sap.ui.ux3.ExactArea",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{toolbarVisible:{type:"boolean",group:"Appearance",defaultValue:true}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},toolbarItems:{type:"sap.ui.commons.ToolbarItem",multiple:true,singularName:"toolbarItem"}}}});o.extend("sap.ui.ux3.ExactAreaToolbarTitle",{metadata:{interfaces:["sap.ui.commons.ToolbarItem"],properties:{text:{type:"string",group:"Appearance",defaultValue:""}}}});return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/ExactAreaRenderer", ["sap/ui/commons/ToolbarRenderer","sap/base/security/encodeXML"],function(e,a){"use strict";var r={};r.render=function(r,i){r.write("<div");r.writeControlData(i);r.addClass("sapUiUx3ExactArea");r.writeClasses();r.write(">");if(i.getToolbarVisible()){r.write('<div id="'+i.getId()+'-tb" class="sapUiTb sapUiTbDesignFlat sapUiTbStandalone" role="toolbar">');r.write('<div class="sapUiTbCont"><div class="sapUiTbInner">');var t=i.getToolbarItems();for(var s=0;s<t.length;s++){var o=t[s];if(o instanceof sap.ui.commons.ToolbarSeparator){e.renderSeparator(r,o)}else if(o instanceof sap.ui.ux3.ExactAreaToolbarTitle){r.write('<div class="sapUiUx3ExactAreaTbTitle">'+a(o.getText())+"</div>")}else{r.renderControl(o)}}r.write("</div></div></div>")}r.write('<div id="'+i.getId()+'-ct" class="sapUiUx3ExactAreaCont">');var n=i.getContent();for(var s=0;s<n.length;s++){r.renderControl(n[s])}r.write("</div>");r.write("</div>")};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/ExactAttribute", ["sap/ui/core/Element","./library"],function(t,e){"use strict";var i=e.ExactOrder;var r=t.extend("sap.ui.ux3.ExactAttribute",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{text:{type:"string",group:"Misc",defaultValue:null},selected:{type:"boolean",group:"Misc",defaultValue:null},width:{type:"int",group:"Misc",defaultValue:168},listOrder:{type:"sap.ui.ux3.ExactOrder",defaultValue:i.Select},showSubAttributesIndicator:{type:"boolean",group:"Misc",defaultValue:true},additionalData:{type:"object",group:"Misc",defaultValue:null},supplyActive:{type:"boolean",group:"Misc",defaultValue:true},autoActivateSupply:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"attributes",aggregations:{attributes:{type:"sap.ui.ux3.ExactAttribute",multiple:true,singularName:"attribute"}},events:{supplyAttributes:{parameters:{attribute:{type:"sap.ui.ux3.ExactAttribute"}}}}}});r._MINWIDTH=70;r._MAXWIDTH=500;r.prototype.init=function(){this._getAttributesCallCount=0};r.prototype.scrollTo=function(t){if(!(t instanceof r)){this._scrollToAttributeId=undefined;return}var e=this.getChangeListener();if(e){e=sap.ui.getCore().byId(e.id);if(e&&e._lb){var i=this.indexOfAttribute(t);if(i>=0){e._lb.scrollToIndex(i,true)}this._scrollToAttributeId=undefined;return}}this._scrollToAttributeId=t.getId()};r.prototype.setText=function(t){this.setProperty("text",t,true);this._handleChange(this,"text");return this};r.prototype.setWidth=function(t){this._setWidth(t);this._handleChange(this,"width");return this};r.prototype.setTooltip=function(e){t.prototype.setTooltip.apply(this,arguments);this._handleChange(this,"tooltip",true);return this};r.prototype.setSelected=function(t){this.setProperty("selected",t,true);if(!this.getSelected()){this._clearSelection()}this._handleChange(this,"selected");return this};r.prototype.setSupplyActive=function(t){this.setProperty("supplyActive",t,true);return this};r.prototype.setAutoActivateSupply=function(t){this.setProperty("autoActivateSupply",t,true);return this};r.prototype.setAdditionalData=function(t){this.setProperty("additionalData",t,true);return this};r.prototype.setListOrder=function(t){this.setProperty("listOrder",t,true);this._handleChange(this,"order");return this};r.prototype.getAttributes=function(){this._getAttributesCallCount++;if(this._getAttributesCallCount>1){this.setSupplyActive(false)}if(this.hasListeners("supplyAttributes")&&this.getSupplyActive()){this._bSuppressChange=true;this._bChangedHappenedDuringSuppress=false;this.fireSupplyAttributes({attribute:this});this.setSupplyActive(false);this._bSuppressChange=undefined;if(this._bChangedHappenedDuringSuppress){this._handleChange(this,"attributes")}this._bChangedHappenedDuringSuppress=undefined}this._getAttributesCallCount--;return this.getAttributesInternal()};r.prototype.insertAttribute=function(t,e){this.insertAggregation("attributes",t,e,true);this._handleChange(this,"attributes");this.setSupplyActive(false);return this};r.prototype.addAttribute=function(t){this.addAggregation("attributes",t,true);this._handleChange(this,"attributes");this.setSupplyActive(false);return this};r.prototype.removeAttribute=function(t){var e=this.removeAggregation("attributes",t,true);if(e){e.setChangeListener(null);this._handleChange(this,"attributes")}return e};r.prototype.removeAllAttributes=function(){var t=this.getAttributesInternal();for(var e=0;e<t.length;e++){t[e].setChangeListener(null)}var i=this.removeAllAggregation("attributes",true);if(t.length>0){this._handleChange(this,"attributes")}return i};r.prototype.destroyAttributes=function(){var t=this.getAttributesInternal();for(var e=0;e<t.length;e++){t[e].setChangeListener(null)}this.destroyAggregation("attributes",true);if(t.length>0){this._handleChange(this,"attributes")}return this};r.prototype.getShowSubAttributesIndicator_Computed=function(){return this.hasListeners("supplyAttributes")&&this.getSupplyActive()?this.getShowSubAttributesIndicator():this.getAttributesInternal().length>0};r.prototype.attachSupplyAttributes=function(t,e,i){this.attachEvent("supplyAttributes",t,e,i);if(this.getSelected()){this.getAttributesInternal(true)}return this};r.prototype.setProperty=function(e,i,r){t.prototype.setProperty.call(this,e,i,r);if(e=="selected"){if(i){this.getAttributesInternal(true)}else{if(this.getAutoActivateSupply()){this.setSupplyActive(true)}}}return this};r.prototype.setChangeListener=function(t){this._oChangeListener=t};r.prototype.getChangeListener=function(t){return this._oChangeListener};r.prototype.getAttributesInternal=function(t){return t?this.getAttributes():this.getAggregation("attributes",[])};r.prototype._handleChange=function(t,e){if(this._bSuppressChange){this._bChangedHappenedDuringSuppress=true;return}if(this.getChangeListener()){this.getChangeListener()._notifyOnChange(e,t)}else if(this.getParent()&&this.getParent()._handleChange){this.getParent()._handleChange(t,e)}};r.prototype._clearSelection=function(){this.setProperty("selected",false,true);var t=this.getAttributesInternal();for(var e=0;e<t.length;e++){t[e]._clearSelection()}};r.prototype._setWidth=function(t){t=Math.round(r._checkWidth(t));this.setProperty("width",t,true)};r._checkWidth=function(t){t=Math.max(t,r._MINWIDTH);t=Math.min(t,r._MAXWIDTH);return t};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/ExactBrowser", ["sap/ui/commons/Button","sap/ui/commons/Menu","sap/ui/core/Control","./ExactAttribute","./ExactList","./library","./ExactBrowserRenderer","sap/ui/core/Popup"],function(t,e,i,o,r,s,a,u){"use strict";var n=u.Dock;var l=s.ExactOrder;var p=i.extend("sap.ui.ux3.ExactBrowser",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{title:{type:"string",group:"Misc",defaultValue:null},headerTitle:{type:"string",group:"Misc",defaultValue:null},topListOrder:{type:"sap.ui.ux3.ExactOrder",defaultValue:l.Select},enableListClose:{type:"boolean",group:"Misc",defaultValue:false},listHeight:{type:"int",group:"Appearance",defaultValue:290},showHeader:{type:"boolean",group:"Misc",defaultValue:false},showTopList:{type:"boolean",group:"Misc",defaultValue:true},enableReset:{type:"boolean",group:"Misc",defaultValue:true},enableSave:{type:"boolean",group:"Misc",defaultValue:false},topListWidth:{type:"int",group:"Misc",defaultValue:168}},defaultAggregation:"attributes",aggregations:{attributes:{type:"sap.ui.ux3.ExactAttribute",multiple:true,singularName:"attribute",forwarding:{idSuffix:"-rootAttribute",aggregation:"attributes"}},optionsMenu:{type:"sap.ui.commons.Menu",multiple:false},controls:{type:"sap.ui.core.Control",multiple:true,singularName:"control",visibility:"hidden"},rootAttribute:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},associations:{followUpControl:{type:"sap.ui.core.Control",multiple:false}},events:{attributeSelected:{parameters:{attribute:{type:"sap.ui.ux3.ExactAttribute"},allAttributes:{type:"object"}}},save:{}}}});p.prototype.init=function(){var e=this;this.data("sap-ui-fastnavgroup","true",true);this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._attributeRoot=new o(this.getId()+"-rootAttribute");this.setAggregation("rootAttribute",this._attributeRoot);this._rootList=new r(this.getId()+"-rootlist");this._rootList.setData(this._attributeRoot);this.addAggregation("controls",this._rootList);this._resetButton=new t(this.getId()+"-RstBtn",{text:this._rb.getText("EXACT_BRWSR_RESET"),lite:true});this._resetButton.addStyleClass("sapUiUx3ExactBrwsrReset");this.addAggregation("controls",this._resetButton);this._resetButton.attachPress(function(){e.reset()});this._saveButton=new t(this.getId()+"-SvBtn",{text:this._rb.getText("EXACT_BRWSR_SAVE"),lite:true});this._saveButton.addStyleClass("sapUiUx3ExactBrwsrSave");this.addAggregation("controls",this._saveButton);this._saveButton.attachPress(function(){e.fireSave()});this._rootList.attachAttributeSelected(function(t){e.fireAttributeSelected({attribute:t.getParameter("attribute"),allAttributes:t.getParameter("allAttributes")})});this._rootList.attachEvent("_headerPress",function(t){var i=e.getOptionsMenu();if(i){var o=t.getParameter("domRef");i.open(t.getParameter("keyboard"),o,n.BeginTop,n.BeginBottom,o)}})};p.prototype.exit=function(){this._rootList.destroy();this._attributeRoot.destroy();this._rootList=null;this._attributeRoot=null;this._resetButton=null;this._saveButton=null;this._saveDialog=null;this._saveTextField=null;this._rb=null};p.prototype.onThemeChanged=function(t){if(this.getDomRef()){this.invalidate()}};p.prototype.getTitle=function(){return this._rootList.getTopTitle()};p.prototype.setTitle=function(t){this._rootList.setTopTitle(t);return this};p.prototype.setTopListOrder=function(t){this.setProperty("topListOrder",t,true);this._attributeRoot.setListOrder(t);return this};p.prototype.getTopListWidth=function(){return this._attributeRoot.getWidth()};p.prototype.setTopListWidth=function(t){this._attributeRoot.setWidth(t);return this};p.prototype.getHeaderTitle=function(){var t=this.getProperty("headerTitle");return t?t:this._rb.getText("EXACT_BRWSR_TITLE")};p.prototype.getEnableListClose=function(){return this._rootList.getShowClose()};p.prototype.setEnableListClose=function(t){this._rootList.setShowClose(t);return this};p.prototype.getListHeight=function(){return this._rootList.getTopHeight()};p.prototype.setListHeight=function(t){this._rootList.setTopHeight(t);return this};p.prototype.reset=function(){this._rootList._closeAll()};p.prototype.hasOptionsMenu=function(){return!!this.getOptionsMenu()};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/ExactBrowserRenderer", ["sap/base/security/encodeXML"],function(t){"use strict";var e={};e.render=function(e,r){e.write("<div");e.writeControlData(r);e.addClass("sapUiUx3ExactBrwsr");e.writeClasses();e.writeAttribute("role","region");if(r.getShowHeader()){e.writeAttribute("aria-labelledby",r.getId()+"-hdtitle")}if(r.getFollowUpControl()){e.writeAttribute("aria-controls",r.getFollowUpControl())}var i=r.getTooltip_AsString();if(i){e.writeAttributeEscaped("title",i)}e.write(">");if(r.getShowHeader()){e.write('<div class="sapUiUx3ExactBrwsrHd"><h2 id="'+r.getId()+'-hdtitle">');e.write(t(r.getHeaderTitle()));e.write('</h2><div class="sapUiUx3ExactBrwsrHdTool" role="toolbar">');if(r.getEnableSave()){e.renderControl(r._saveButton)}if(r.getEnableReset()){e.renderControl(r._resetButton)}e.write("</div></div>")}e.renderControl(r._rootList);e.write("</div>")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/ExactList", ["sap/ui/thirdparty/jquery","sap/ui/commons/ListBox","sap/ui/core/Control","sap/ui/core/Popup","sap/ui/core/theming/Parameters","./library","./ExactListRenderer","sap/ui/core/delegate/ItemNavigation","sap/ui/ux3/ExactAttribute","sap/ui/core/ListItem","sap/ui/dom/getScrollbarSize","sap/ui/events/KeyCodes","sap/ui/dom/containsOrEquals","sap/ui/events/ControlEvents","sap/ui/Device","sap/base/security/encodeXML","sap/ui/core/Configuration"],function(jQuery,t,e,i,s,r,a,o,n,l,u,h,p,f,d,c,g){"use strict";var _=r.ExactOrder;var v=e.extend("sap.ui.ux3.ExactList",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{showClose:{type:"boolean",group:"Misc",defaultValue:false},topTitle:{type:"string",group:"Misc",defaultValue:null},topHeight:{type:"int",group:"Appearance",defaultValue:290}},aggregations:{subLists:{type:"sap.ui.ux3.ExactList",multiple:true,singularName:"subList"},controls:{type:"sap.ui.commons.ListBox",multiple:true,singularName:"control",visibility:"hidden"}},associations:{data:{type:"sap.ui.ux3.ExactAttribute",multiple:false}},events:{attributeSelected:{parameters:{attribute:{type:"sap.ui.ux3.ExactAttribute"},allAttributes:{type:"object"}}}}}});t.extend("sap.ui.ux3.ExactList.LB",{metadata:{library:"sap.ui.ux3"},init:function(){t.prototype.init.apply(this,arguments);this.setAllowMultiSelect(true);this.setDisplayIcons(true);this.addStyleClass("sapUiUx3ExactLstLb")},invalidate:function(){t.prototype.invalidate.apply(this,arguments);if(!this.bInvalidated&&this.getParent()){this.getParent().invalidate()}this.bInvalidated=true},_handleUserActivation:function(e){e.metaKey=true;t.prototype._handleUserActivation.apply(this,[e])},onclick:function(e){t.prototype.onclick.apply(this,arguments);this.getParent().onclick(e)},onAfterRendering:function(){t.prototype.onAfterRendering.apply(this,arguments);this.bInvalidated=false;var e=this.getParent();var i=this.getItems();var s=e._isTop();var r=false;for(var a=0;a<i.length;a++){var n=i[a];var l=sap.ui.getCore().byId(n.getKey());var p=n.$();r=false;if(s||(!l||!l.getShowSubAttributesIndicator_Computed())){p.addClass("sapUiUx3ExactLstNoIco");r=s}else{r=true}if(r&&!s){p.attr("aria-label",e._rb.getText(p.hasClass("sapUiLbxISel")?"EXACT_LST_LIST_ITEM_SEL_ARIA_LABEL":"EXACT_LST_LIST_ITEM_ARIA_LABEL",[n.getText()]))}}var f=e._bRTL?"left":"right";jQuery(".sapUiLbxITxt",this.getDomRef()).css("margin-"+f,20+u().width+"px");jQuery(".sapUiLbxIIco",this.getDomRef()).css(f,5+u().width+"px");jQuery(this.getDomRef()).attr("tabindex","-1");var d;if(s){d=e.getTopTitle()}else{d=e._rb.getText("EXACT_LST_LIST_ARIA_LABEL",[e._iLevel,e._getAtt().getText()])}jQuery(this.getFocusDomRef()).attr("aria-label",d).attr("aria-expanded","true");this.oItemNavigation.iActiveTabIndex=-1;this.oItemNavigation.setSelectedIndex(-1);this.oItemNavigation.onsapnext=function(t){if(t.keyCode!=h.ARROW_DOWN){return}o.prototype.onsapnext.apply(this,arguments)};this.oItemNavigation.onsapprevious=function(t){if(t.keyCode!=h.ARROW_UP){return}o.prototype.onsapprevious.apply(this,arguments)}},renderer:"sap.ui.commons.ListBoxRenderer"});v.prototype.init=function(){var t=this;this._iLevel=0;this._bCollapsed=false;this._bIsFirstRendering=true;this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._lb=new v.LB(this.getId()+"-lb",{select:function(e){U(t);var i=e.getParameter("selectedItem").getKey();var s=sap.ui.getCore().byId(i);var r=e.getParameter("selectedIndex");if(t._lb.isIndexSelected(r)){s.setProperty("selected",true,true);var a=F(t,s);if(a){var o=C(t,s);if(o<0){t.addSubList(a)}else{t.insertSubList(a,o)}}}else{O(t,s,r)}B(t)._selectionChanged(s)}});this.addAggregation("controls",this._lb);this._closeHandle=jQuery.proxy(this.onForceVerticalClose,this)};v.prototype.exit=function(){if(this.bIsDestroyed){return}H(this);this._lb.removeAllItems();this._lb=null;this._closeHandle=null;this._scrollCheckHandle=null;this._rb={getText:function(){return""}};this._oTopList=null;if(this._dirtyListsCleanupTimer){clearTimeout(this._dirtyListsCleanupTimer);this._dirtyListsCleanupTimer=null;this._dirtyLists=null}};v.prototype.getFocusDomRef=function(){if(this._isTop()&&this.$().hasClass("sapUiUx3ExactLstTopHidden")){return this.getDomRef("foc")}return this._bCollapsed?this.getDomRef("head"):this._lb.getFocusDomRef()};v.prototype.onBeforeRendering=function(){this._oTopList=null;if(!this._bIsFirstRendering){return}this._bRTL=g.getRTL();if(!this._isTop()){this._bCollapsed=true;this._oCollapseStyles={cntnt:"margin-"+(this._bRTL?"right":"left")+":"+s.get("sapUiUx3ExactLstCollapseWidth")+";border-top-width:0px;",lst:"width:0px;"}}else{this._bIsFirstRendering=false}};v.prototype.onAfterRendering=function(){var t=this;var e=this._isTop();if(!this._iCurrentWidth){this._iCurrentWidth=this._getAtt().getWidth()}if(e){this._iScrollWidthDiff=-1;this.onCheckScrollbar();this.$("lst").css("bottom",u().height+"px");this.$("cntnt").on("scroll",function(e){if(e.target.id===t.getId()+"-cntnt"&&e.target.scrollTop!=0){e.target.scrollTop=0}})}if(!this._bCollapsed){R(this,this._iCurrentWidth)}U(this);if(this._bIsFirstRendering){this._bIsFirstRendering=false;$(this,false,null,true)}else{T(this);w(this)}if(this._bRefreshList){this._bRefreshList=false;setTimeout(function(){t._lb.invalidate()},0)}};v.prototype.onfocusin=function(t){if(t.target===this.getDomRef()){this.getFocusDomRef().focus()}var e=this.$("head");if(this._isTop()){e.attr("tabindex","-1");this.$("foc").attr("tabindex","-1");if(!y(this)&&t.target===e[0]){this.getFocusDomRef().focus()}if(this.$().hasClass("sapUiUx3ExactLstTopHidden")&&t.target===this.getDomRef("foc")){var i=this.getSubLists();if(i.length>0){i[0].getFocusDomRef().focus()}}}if(!t.__exactHandled){e.addClass("sapUiUx3ExactLstHeadFocus");t.__exactHandled=true}};v.prototype.onfocusout=function(t){var e=this.$("head");if(this._isTop()){e.attr("tabindex","0");this.$("foc").attr("tabindex","0")}e.removeClass("sapUiUx3ExactLstHeadFocus")};v.prototype.onclick=function(t){var e=this._lb.getScrollTop();if(jQuery(t.target).attr("id")==this.getId()+"-exp"){W(this);this.focus();t.stopPropagation()}else if(jQuery(t.target).attr("id")==this.getId()+"-close"){k(this)}else if(jQuery(t.target).attr("id")==this.getId()+"-hide"){$(this,!this._bCollapsed,t)}else if(this._isTop()&&y(this)&&p(this.$("head")[0],t.target)){L(this,t,false);return}else if(!p(this.$("cntnt")[0],t.target)){this.focus()}this._lb.setScrollTop(e)};v.prototype.onkeydown=function(t){function e(t,e){if(jQuery(e).hasClass("sapUiUx3ExactLstFoc")){return}if(e){e.focus()}t.preventDefault();t.stopPropagation()}switch(t.keyCode){case h.ENTER:case h.SPACE:if(this._isTop()&&y(this)&&p(this.$("head")[0],t.target)){L(this,t,true)}break;case h.DELETE:if(!this._isTop()&&this.getShowClose()){k(this);e(t,this.getParent().getFocusDomRef())}break;case h.NUMPAD_MINUS:if(t.shiftKey){if(!this._bCollapsed){R(this,this._iCurrentWidth-10);e(t)}}else if(!this._bCollapsed){$(this,true,t)}break;case h.NUMPAD_PLUS:if(t.shiftKey){if(!this._bCollapsed){R(this,this._iCurrentWidth+10);e(t)}}else if(this._bCollapsed){$(this,false,t)}break;case h.TAB:if(this._iLevel==0){var i=y(this);if(!t.shiftKey&&i&&p(this.$("head")[0],t.target)){e(t,this.getFocusDomRef())}else if(p(this.getFocusDomRef(),t.target)){if(t.shiftKey&&i){e(t,this.$("head")[0])}else if(!t.shiftKey){var s=b(this);if(s){e(t,s.getFocusDomRef())}}}return}if(this._iLevel==1){var s=null;if(t.shiftKey){if(p(this.$("cntnt")[0],t.target)){s=this}else{s=x(this)}}else{s=b(this)}if(s){e(t,s.getFocusDomRef())}t.stopPropagation()}break;case h.ARROW_LEFT:case h.ARROW_RIGHT:var s=null;if(this._iLevel>=1){if(this._bRTL&&t.keyCode===h.ARROW_LEFT||!this._bRTL&&t.keyCode===h.ARROW_RIGHT){s=b(this,true)}else{s=x(this,true)}if(s){e(t,s.getFocusDomRef())}t.stopPropagation()}break}};v.prototype.onmousedown=function(t){if(t.target.id===this.getId()+"-rsz"){jQuery(document.body).append('<div id="'+this.getId()+'-ghost" class="sapUiUx3ExactLstRSzGhost" style =" z-index:'+i.getNextZIndex()+'" ></div>');jQuery(document.body).on("selectstart."+this.getId(),S);var e=d.browser.msie?jQuery(document.body):this.$("ghost");e.on("mouseup."+this.getId(),jQuery.proxy(E,this)).on("mousemove."+this.getId(),jQuery.proxy(A,this));this._iStartDragX=t.pageX;this._iStartWidth=this.$("lst").width();this.$("rsz").addClass("sapUiUx3ExactLstRSzDrag")}};v.prototype.onForceVerticalClose=function(t){if(t.type=="mousedown"||t.type=="click"||t.type=="dblclick"||t.type=="focusin"||t.type=="focusout"||t.type=="keydown"||t.type=="keypress"||t.type=="keyup"||t.type=="mousedown"||t.type=="mouseup"){var e=this.$("lst");if(!p(e[0],t.target)||t.target.tagName=="BODY"){if(e.hasClass("sapUiUx3ExactLstExpanded")){this._oPopup.close(true)}}}};v.prototype.onCheckScrollbar=function(t){this._scrollCheckTimer=null;var e=this.$("cntnt");var i=e[0];if(i){var s=i.scrollWidth-i.clientWidth;if(this._iScrollWidthDiff!=s){this._iScrollWidthDiff=s;if(s<=0){e.css({"overflow-x":"hidden",bottom:u().height+"px"})}else{e.css({"overflow-x":"scroll",bottom:"0px"})}}this._scrollCheckTimer=setTimeout(this.onCheckScrollbar.bind(this),300)}};v.prototype.insertSubList=function(t,e){this.insertAggregation("subLists",t,e);if(t){D(t,this._iLevel+1)}return this};v.prototype.addSubList=function(t){this.addAggregation("subLists",t);if(t){D(t,this._iLevel+1)}return this};v.prototype.setData=function(t){if(t!=null&&typeof t!="string"){t=t.getId()}if(t){this.setAssociation("data",t);t=this._getAtt();this._lb.removeAllItems();if(!t){return this}var e=t.getAttributesInternal(true);var i=[];var s=[];for(var r=0;r<e.length;r++){var a=N(e[r]);this._lb.addItem(a);if(e[r].getSelected()){var o=F(this,e[r]);if(o){s.push(o)}i.push(a.getKey())}}this._lb.setSelectedKeys(i);var n=this.getSubLists();for(var r=0;r<n.length;r++){var l=s.indexOf(n[r]);if(l>=0){if(t.getListOrder()!=_.Fixed){s.splice(l,1)}}else{n[r]._lb.removeAllItems();n[r].destroy()}}if(t.getListOrder()===_.Fixed){this.removeAllSubLists()}for(var r=0;r<s.length;r++){this.addSubList(s[r])}var u=this;t.setChangeListener({id:u.getId(),_notifyOnChange:function(t,e){if(t==="width"){if(u._getAtt()===e&&u.getDomRef()){R(u,e.getWidth())}return}var i=B(u);if(!i._dirtyLists){i._dirtyLists={}}if(!i._dirtyLists[u.getId()]){i._dirtyLists[u.getId()]=u}if(!i._dirtyListsCleanupTimer){i._dirtyListsCleanupTimer=setTimeout(function(){this._dirtyListsCleanupTimer=null;jQuery.each(this._dirtyLists,function(t,e){if(e._lb&&e.getParent()){if(!e._isTop()){e.getParent().setData(e.getParent().getData())}else{e.setData(e.getData())}}});this._dirtyLists=null}.bind(i),0)}}})}return this};v.prototype.setShowClose=function(t){if(this._isTop()){this.setProperty("showClose",t)}return this};v.prototype.getShowClose=function(){return B(this).getProperty("showClose")};v.prototype.getTopTitle=function(){var t=this.getProperty("topTitle");return t?t:this._rb.getText("EXACT_BRWSR_LST_TITLE")};v.prototype._getAtt=function(){return sap.ui.getCore().byId(this.getData())};v.prototype._isTop=function(){return!(this.getParent()instanceof v)};v.prototype._selectionChanged=function(t){if(!this._isTop()){return}t=sap.ui.getCore().byId(t.getId());var e=function(t,i){if(!t.getSelected()){return}i.push(t);var s=t.getAttributesInternal();for(var r=0;r<s.length;r++){e(s[r],i)}};var i=[];var s=this._getAtt().getAttributesInternal();for(var r=0;r<s.length;r++){e(s[r],i)}this.fireAttributeSelected({attribute:t,allAttributes:i})};v.prototype._closeAll=function(){if(!this._isTop()){return}var t=this;var e=function(){t._getAtt()._clearSelection();t._lb.clearSelection();t.fireAttributeSelected({attribute:undefined,allAttributes:[]})};var i=this.getSubLists();if(i.length>0){for(var s=0;s<i.length;s++){k(i[s],true,s==i.length-1?e:null)}}else{e()}};var x=function(t,e){function i(t){var e=t.getParent();var i=e.getSubLists();var s=e.indexOfSubList(t)-1;if(s>=0){return i[s]}return null}function s(t){var e=t.getSubLists();if(e.length>0){return s(e[e.length-1])}return t}if(t._iLevel==0){return null}else if(t._iLevel==1){if(e){return null}var r=i(t);if(r){return r}return t.getParent()}else if(t._iLevel>1){var r=i(t);if(r){return s(r)}var a=t.getParent();if(a._iLevel>=1){return a}}return null};var b=function(t,e){function i(t){var e=t.getParent();var i=e.getSubLists();var s=e.indexOfSubList(t)+1;if(s<i.length){return i[s]}return null}function s(t){var e=t.getSubLists();if(e.length>0){return e[0]}return null}function r(t){var s=i(t);if(s){return s}var a=t.getParent();if(a._iLevel>(e?1:0)){return r(a)}else{return null}}if(t._iLevel==0){return s(t)}else if(t._iLevel==1){return e?s(t):i(t)}else if(t._iLevel>1){var a=s(t);if(a){return a}return r(t)}return null};var L=function(t,e,i){t.fireEvent("_headerPress",{kexboard:i,domRef:t.$("head")});e.stopPropagation()};var y=function(t){return!m(t)&&t.$().hasClass("sapUiUx3ExactLstTopActive")};var m=function(t){return t.$().hasClass("sapUiUx3ExactLstTopHidden")};var C=function(t,e){if(t._getAtt().getListOrder()!=_.Fixed){return-1}var i=t._getAtt().getAttributes();var s=0;for(var r=0;r<i.length;r++){if(i[r]===e){break}if(i[r].getChangeListener()){s++}}return s};var T=function(t){if(P(t)){t.$("lst").addClass("sapUiUx3ExactLstLstExp");if(!t._oPopup){var e=function(e){t._handleEvent(e)};t._oPopup=new i;if(!d.browser.firefox){t._oPopup._fixPositioning=function(t,e){i.prototype._fixPositioning.apply(this,arguments);if(e){var s=this._$();var r=jQuery(t.of);var a=0;if(t.offset){a=parseInt(t.offset.split(" ")[0])}s.css("right",jQuery(window).width()-r.outerWidth()-r.offset().left+a+"px")}}}t._oPopup.open=function(){var r=t.$("lst");I(r,false,-1,function(e){r.addClass("sapUiUx3ExactLstExpanded");t.$("exp").html(a.getExpanderSymbol(true,false));t.__sOldHeight=r.css("height");r.css("height",t.__sOldHeight);var o=t.$("head");var n=jQuery(t._lb.getDomRef());var l=n[0].scrollHeight+t.$("exp").height()+n.outerHeight()-n.height()+1;var u=jQuery(window).height()-parseInt(n.offset().top)+jQuery(window).scrollTop()-o.outerHeight();var h=Math.min(l,u);t._oPopup.setContent(r[0]);var p=s.get()["sapUiUx3ExactLst"+(t._isTop()?"Root":"")+"ExpandOffset"]||"0 0";i.prototype.open.apply(t._oPopup,[0,i.Dock.BeginTop,i.Dock.BeginBottom,o[0],p,"none none"]);t._bPopupOpened=true;return h},function(i){r.addClass("sapUiUx3ExactLstExpandedBL");P(t);t.getFocusDomRef().focus();f.bindAnyEvent(t._closeHandle);i.on(f.events.join(" "),e)})};t._oPopup.close=function(s){var r=t.$("lst");r.removeClass("sapUiUx3ExactLstExpandedBL");I(r,false,t.__sOldHeight,function(i){f.unbindAnyEvent(t._closeHandle);i.off(f.events.join(" "),e);r.removeClass("sapUiUx3ExactLstExpanded");t.$("exp").html(a.getExpanderSymbol(false,false))},function(e){e.detach();r.removeClass("sapUiShd");e.attr("style","width:"+t._iCurrentWidth+"px;");jQuery(t.getDomRef()).prepend(e);t._oPopup.setContent(null);t._bPopupOpened=undefined;t.__sOldHeight=null;if(t._isTop()){e.css("bottom",u().height+"px")}P(t);i.prototype.close.apply(t._oPopup,[0]);if(!s){t.getFocusDomRef().focus()}})}}}};var I=function(t,e,i,s,r){if(s){var a=s(t);if(a!=undefined){i=a}}var o=r?function(){r(t)}:function(){};if(jQuery.fx.off){if(e){t.width(i)}else{t.height(i)}o()}else{var n=e?{width:i}:{height:i};t.stop(true,true).animate(n,200,"linear",o)}};var S=function(t){t.preventDefault();t.stopPropagation();return false};var A=function(t){var e=t.pageX;var i=this._bRTL?this._iStartDragX-e:e-this._iStartDragX;R(this,this._iStartWidth+i)};var E=function(t){jQuery(document.body).off("selectstart."+this.getId()).off("mouseup."+this.getId()).off("mousemove."+this.getId());this.$("ghost").remove();this.$("rsz").removeClass("sapUiUx3ExactLstRSzDrag");this._iStartWidth=undefined;this._iStartDragX=undefined;this.focus()};var R=function(t,e){e=n._checkWidth(e);var i=t._bRTL?"right":"left";t._iCurrentWidth=e;t._getAtt()._setWidth(t._iCurrentWidth);t.$("lst").css("width",e+"px");t.$("rsz").css(i,e-4+"px");if(t._isTop()){if(!m(t)){t.$("head").css("width",e+"px");t.$("cntnt").css(i,e+8+"px");t.$("scroll").css(i,e+8+"px")}}else{if(!t.$().hasClass("sapUiUx3ExactLstCollapsed")){t.$("cntnt").css("margin-"+i,e+"px")}}};var U=function(t){var e=t._getAtt();if(e&&!t._isTop()){t.$("head-txt").html(c(e.getText())+'<span class="sapUiUx3ExactLstHeadInfo">&nbsp;('+t._lb.getSelectedIndices().length+"/"+t._lb.getItems().length+")</span>")}};var D=function(t,e){t._iLevel=e;var i=t.getSubLists();for(var s=0;s<i.length;s++){D(i[s],e+1)}};var P=function(t){if(t._lb){var e=jQuery(t._lb.getDomRef());t.$("lst").removeClass("sapUiUx3ExactLstScroll");if(e.length>0&&e.outerHeight()<e[0].scrollHeight){t.$("lst").addClass("sapUiUx3ExactLstScroll");return true}}return false};var $=function(t,e,i,r){if(i){i.preventDefault();i.stopPropagation()}if(t._isTop()){return}if(t._bCollapsed!=e){var o=!!i;var n={};n["margin-"+(t._bRTL?"right":"left")]=t._bCollapsed?t._iCurrentWidth+"px":s.get("sapUiUx3ExactLstCollapseWidth");n["border-top-width"]=t._bCollapsed?s.get("sapUiUx3ExactLstContentTop"):"0px";var l=t.$("cntnt");if(jQuery.fx.off){for(var u in n){l.css(u,n[u])}}else{l.stop(true,true).animate(n,200,"linear")}if(t._bCollapsed){I(t.$("lst"),true,t._iCurrentWidth+"px",function(){jQuery(t.getDomRef()).removeClass("sapUiUx3ExactLstCollapsed");t.$("head").css("overflow","hidden")},function(e){t.$("hide").html(a.getExpanderSymbol(true,true)).attr("title",t._rb.getText("EXACT_LST_LIST_COLLAPSE"));if(o){t.focus()}var i=t.$("head");t.$("head-txt").removeAttr("style");i.removeAttr("style");e.removeAttr("style");T(t);R(t,t._iCurrentWidth);w(t);i.removeAttr("role");i.removeAttr("aria-label");i.removeAttr("aria-expanded");var s=t._getAtt();if(s&&s._scrollToAttributeId){s.scrollTo(sap.ui.getCore().byId(s._scrollToAttributeId))}});t._oCollapseStyles=undefined}else{t._oCollapseStyles={};I(t.$("lst"),true,0,null,function(){jQuery(t.getDomRef()).addClass("sapUiUx3ExactLstCollapsed");t.$("hide").html(a.getExpanderSymbol(false,true)).attr("title",t._rb.getText("EXACT_LST_LIST_EXPAND"));if(o){t.focus()}w(t);var e=t.$("head");e.attr("role","region");e.attr("aria-label",t._rb.getText("EXACT_LST_LIST_COLL_ARIA_LABEL",[t._iLevel,t._getAtt().getText()]));e.attr("aria-expanded","false")});var h=[];for(var u in n){h.push(u,":",n[u],";")}t._oCollapseStyles["cntnt"]=h.join("");t._oCollapseStyles["lst"]="width:0px;"}t._bCollapsed=!t._bCollapsed}if(r){return}var p=t.getParent();if(!t._isTop()&&p&&p._isTop&&!p._isTop()){$(p,e)}};var w=function(t){if(t._bCollapsed){var e=t.$("cntnt").height()-50;var i=t.$("head-txt");i.css("width",e+"px")}var s=t.getSubLists();for(var r=0;r<s.length;r++){w(s[r])}};var W=function(t){var e=t.$("lst");if(e.hasClass("sapUiUx3ExactLstExpanded")){t._oPopup.close()}else{t._oPopup.open()}};var k=function(t,e,i){var s=function(s){if(!e){var r=t._getAtt();var a=r.getParent().indexOfAttribute(r);O(t.getParent(),r,a,true);U(t.getParent());B(t)._selectionChanged(r)}t.destroy();if(i){i()}};var r=t.getDomRef();if(r){I(jQuery(r),true,0,function(t){t.css("overflow","hidden")},s)}else{s()}};var F=function(t,e){if(e.getSelected()){var i=e.getAttributesInternal(true);if(i.length>0){var s;if(e.getChangeListener()){s=sap.ui.getCore().byId(e.getChangeListener().id)}else{s=new v}s.setData(e);return s}}return null};var O=function(t,e,i,s){t._lb.removeSelectedIndex(i);e._clearSelection();if(!s){var r=t.getSubLists();for(var a=0;a<r.length;a++){if(r[a].getData()===e.getId()){k(r[a],true)}}}};var H=function(t){var e=t._getAtt();if(e&&e.getChangeListener()&&e.getChangeListener().id===t.getId()){e.setChangeListener(null)}};var B=function(t){if(t._isTop()){return t}if(!t._oTopList){t._oTopList=B(t.getParent())}return t._oTopList};var N=function(t){var e;if(t.__oItem){e=t.__oItem;if(e.getText()!=t.getText()){e.setText(t.getText())}if(e.getKey()!=t.getId()){e.setKey(t.getId())}}else{e=new l({text:t.getText(),key:t.getId()});t.exit=function(){if(n.prototype.exit){n.prototype.exit.apply(t,[])}this.__oItem.destroy();this.__oItem=null};t.__oItem=e}return e};return v});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/ExactListRenderer", ["sap/ui/core/Configuration"],function(t){"use strict";var e={};e.render=function(t,e){var i=e.getSubLists();var s=e._getAtt();if(!s){return}var a=e._isTop();t.write("<div");t.writeControlData(e);t.addClass("sapUiUx3ExactLst");var r=false;var l=false;if(a){var d=e.getParent();if(d){if(d.hasOptionsMenu){r=d.hasOptionsMenu();if(r){t.addClass("sapUiUx3ExactLstTopActive")}}if(d.getShowTopList&&!d.getShowTopList()){t.addClass("sapUiUx3ExactLstTopHidden");l=true}}t.addClass("sapUiUx3ExactLstTop");t.addStyle("height",e.getTopHeight()+"px")}if(e._bCollapsed){t.addClass("sapUiUx3ExactLstCollapsed")}t.addClass("sapUiUx3ExactLstLvl_"+e._iLevel);t.writeClasses();t.writeStyles();t.write(">");if(l){t.write('<div id="'+e.getId()+'-foc" class="sapUiUx3ExactLstFoc" tabindex="0"></div>')}if(!e._bPopupOpened){t.write('<div id="'+e.getId()+'-lst" class="sapUiUx3ExactLstLst"');if(e._bCollapsed&&e._oCollapseStyles&&e._oCollapseStyles["lst"]){t.write(' style="'+e._oCollapseStyles["lst"]+'"')}t.write(">");t.renderControl(e._lb);t.write('<a id="'+e.getId()+'-exp" class="sapUiUx3ExactLstExp">'+this.getExpanderSymbol(false,false)+"</a>");t.write("</div>")}else{e._bRefreshList=true}t.write('<div id="'+e.getId()+'-cntnt" ');t.write('class="sapUiUx3ExactLstCntnt');if(i.length==0){t.write(" sapUiUx3ExactLstCntntEmpty")}t.write('"');if(e._bCollapsed&&e._oCollapseStyles&&e._oCollapseStyles["cntnt"]){t.write(' style="'+e._oCollapseStyles["cntnt"]+'"')}t.write(">");for(var p=0;p<i.length;p++){t.renderControl(i[p])}t.write("</div>");t.write('<header id="'+e.getId()+'-head" class="sapUiUx3ExactLstHead"');if(a&&r){t.write(' role="button" aria-haspopup="true"')}if(!a&&e._bCollapsed&&s){t.writeAttribute("role","region");t.writeAttribute("aria-expanded","false");t.writeAttributeEscaped("aria-label",e._rb.getText("EXACT_LST_LIST_COLL_ARIA_LABEL",[e._iLevel,s.getText()]))}t.write(' tabindex="'+(a?"0":"-1")+'">');if(a){t.write('<h3 id="'+e.getId()+'-head-txt" class="sapUiUx3ExactLstHeadTopTxt"><span class="sapUiUx3ExactLstHeadTopTxtTxt">');if(e.getTopTitle()){t.writeEscaped(e.getTopTitle())}t.write("</span>");if(r){t.write('<span class="sapUiUx3ExactLstHeadTopIco"></span>')}t.write("</h3>")}else{t.write('<h3 id="'+e.getId()+'-head-txt" class="sapUiUx3ExactLstHeadTxt"');if(s&&s.getTooltip_AsString()){t.writeAttributeEscaped("title",s.getTooltip_AsString())}else if(s&&s.getText()){t.writeAttributeEscaped("title",s.getText())}if(e._bCollapsed&&e._oCollapseStyles&&e._oCollapseStyles["head-txt"]){t.write(' style="'+e._oCollapseStyles["head-txt"]+'"')}t.write(">");if(s){t.writeEscaped(s.getText())}t.write("</h3>");t.write('<div id="'+e.getId()+'-head-action" class="sapUiUx3ExactLstHeadAct'+(e.getShowClose()?"":" sapUiUx3ExactLstHeadActNoClose")+'">');t.write('<a id="'+e.getId()+'-hide" class="sapUiUx3ExactLstHide" role="presentation"');t.writeAttributeEscaped("title",e._rb.getText(e._bCollapsed?"EXACT_LST_LIST_EXPAND":"EXACT_LST_LIST_COLLAPSE"));t.write(">",this.getExpanderSymbol(!e._bCollapsed,true),"</a>");t.write('<a id="'+e.getId()+'-close" role="presentation" class="sapUiUx3ExactLstClose"');t.writeAttributeEscaped("title",e._rb.getText("EXACT_LST_LIST_CLOSE"));t.write(">X</a>");t.write("</div>")}t.write("</header>");t.write('<div id="'+e.getId()+'-rsz" class="sapUiUx3ExactLstRSz"></div>');t.write("</div>")};e.getExpanderSymbol=function(e,i){if(i){if(t.getRTL()){return e?"&#9654;":"&#9664;"}else{return e?"&#9664;":"&#9654;"}}else{return e?"&#9650;":"&#9660;"}};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/ExactRenderer", [],function(){"use strict";var r={};r.render=function(r,e){r.write("<div");r.writeControlData(e);r.addClass("sapUiUx3Exact");r.writeClasses();var t=e.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t)}r.write(">");r.renderControl(e._searchArea);if(e._bDetailsVisible){r.renderControl(e._browser);r.renderControl(e._resultText);r.renderControl(e._resultArea)}r.write("</div>")};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/FacetFilter", ["sap/ui/core/Control","./library","./FacetFilterRenderer"],function(e,t,i){"use strict";var a=t.VisibleItemCountMode;var r=e.extend("sap.ui.ux3.FacetFilter",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{visibleItemCountMode:{type:"sap.ui.ux3.VisibleItemCountMode",group:"Appearance",defaultValue:a.Fixed}},aggregations:{lists:{type:"sap.ui.ux3.FacetFilterList",multiple:true,singularName:"list"}}}});r.prototype.init=function(){this.data("sap-ui-fastnavgroup","true",true)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/FacetFilterList", ["sap/ui/commons/ListBox","sap/ui/core/Control","./library","./FacetFilterListRenderer","sap/ui/core/ListItem"],function(t,e,s,i,o){"use strict";var l=e.extend("sap.ui.ux3.FacetFilterList",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{title:{type:"string",group:"Misc",defaultValue:null},multiSelect:{type:"boolean",group:"Behavior",defaultValue:true},displaySecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},selectedKeys:{type:"string[]",group:"Misc",defaultValue:null},showCounter:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{items:{type:"sap.ui.core.ListItem",multiple:true,singularName:"item"},controls:{type:"sap.ui.commons.ListBox",multiple:true,singularName:"control",visibility:"hidden"}},events:{select:{parameters:{id:{type:"string"},selectedIndices:{type:"int[]"},selectedItems:{type:"sap.ui.core.ListItem[]"},all:{type:"boolean"}}}}}});l.prototype.init=function(){this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._oListBox=new t(this.getId()+"-lb");this._oListBox.setScrollTop(0);this._oListBox.setValueTextAlign("Begin");this._oListBox.setDisplaySecondaryValues(this.getDisplaySecondaryValues());this._oListBox.setDisplayIcons(false);this._oListBox.setEditable(true);this._oListBox.setEnabled(true);this._oListBox.setVisible(true);this._oListBox.setAllowMultiSelect(this.getMultiSelect());this._oListBox.addAriaLabelledBy(this.getId()+"-head-txt");var e=this;this._oListBox.attachSelect(function(t){e.onSelect(e,t)});this.addAggregation("controls",this._oListBox);this._oItemAll=new o({text:this._oResBundle.getText("FACETFILTER_ALL",[0]),key:"sapUiFacetFilter_ALL"});this._oListBox.addItem(this._oItemAll)};l.prototype.setMultiSelect=function(t){this._oListBox.setAllowMultiSelect(t);this.setProperty("multiSelect",t,true);return this};l.prototype.setDisplaySecondaryValues=function(t){this._oListBox.setDisplaySecondaryValues(t);this.setProperty("displaySecondaryValues",t,true);return this};l.prototype.addItem=function(t){this._oListBox.addItem(t);if(!t.getKey()||t.getKey().trim()==""){t.setKey("generatedkey"+this.indexOfItem(t))}this.updateText4All();return this};l.prototype.insertItem=function(t,e){this._oListBox.insertItem(t,e+1);if(!t.getKey()||t.getKey().trim()==""){t.setKey("generatedkey"+this.indexOfItem(t))}this.updateText4All();return this};l.prototype.removeItem=function(t){var e=this._oListBox.removeItem(t);this.updateText4All();return e};l.prototype.removeAllItems=function(){this._oListBox.removeAllItems();this._oListBox.addItem(this._oItemAll);this.updateText4All()};l.prototype.destroyItems=function(){this._oListBox.removeItem(this._oItemAll);this._oListBox.destroyItems();this._oListBox.addItem(this._oItemAll);this.updateText4All();return this};l.prototype.indexOfItem=function(t){var e=this._oListBox.indexOfItem(t);if(e>-1){e=e-1}return e};l.prototype.getItems=function(){var t=this._oListBox.getItems();var e=[];for(var s=1;s<t.length;s++){e.push(t[s])}return e};l.prototype.setSelectedKeys=function(t){this.setProperty("selectedKeys",t);this.invalidate();return this};l.prototype.setShowCounter=function(t){this.setProperty("showCounter",t);this.updateText4All();return this};l.prototype.updateText4All=function(){if(this.getShowCounter()){this._oItemAll.setText(this._oResBundle.getText("FACETFILTER_ALL",[this._oListBox.getItems().length-1]))}else{this._oItemAll.setText(this._oResBundle.getText("FACETFILTER_NO_COUNT"))}};l.prototype.onBeforeRendering=function(){if(!this.bFullHeight){this._oListBox.setVisibleItems(5)}var t=this.getSelectedKeys();if(t&&t.length>0){this._oListBox.setSelectedKeys(t);this._bAllOnly=false}else{this._oListBox.setSelectedKeys(["sapUiFacetFilter_ALL"]);this._bAllOnly=true}};l.prototype.updateItems=function(){this.updateAggregation("items");var t=this._oListBox.getSelectedKeys();if(t.length==0){t=["sapUiFacetFilter_ALL"];this._bAllOnly=true;this._oListBox.setSelectedKeys(t)}};l.prototype.onSelect=function(t,e){var s=this._oListBox.getSelectedKeys();if(s.length==0){s=["sapUiFacetFilter_ALL"];this._bAllOnly=true;this._oListBox.setSelectedKeys(s)}var i=s.indexOf("sapUiFacetFilter_ALL");if(i>-1){if(s.length==1){this._bAllOnly=true}else{if(this._bAllOnly){s.splice(i,1);this._bAllOnly=false}else{s=["sapUiFacetFilter_ALL"];this._bAllOnly=true}this._oListBox.setSelectedKeys(s)}}else{this._bAllOnly=false}this.setProperty("selectedKeys",s,true);var o=[];var l=[];var r=this._oListBox.getSelectedItems();if(!this._bAllOnly){for(var n=0;n<r.length;n++){if(r[n]!=this._oItemAll){o.push(this.indexOfItem(r[n]));l.push(r[n])}}}this.fireSelect({id:t.getId(),all:this._bAllOnly,selectedIndices:o,selectedItems:l})};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/FacetFilterListRenderer", [],function(){"use strict";var t={};t.render=function(t,e){t.write("<div ");t.writeControlData(e);t.addClass("sapUiUx3FFLst");t.writeClasses();t.writeAttribute("style","width:"+e.sWidth);t.write(">");t.write('<header id="'+e.getId()+'-head"  class="sapUiUx3FFLstHead"');if(e.getTooltip_AsString()){t.writeAttributeEscaped("title",e.getTooltip_AsString())}t.write(">");t.write('<h3 id="'+e.getId()+'-head-txt"  class="sapUiUx3FFLstHeadTxt">');if(e.getTitle()){t.writeEscaped(e.getTitle())}t.write("</h3>");t.write("</header>");t.renderControl(e._oListBox);t.write("</div>")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/FacetFilterRenderer", ["./library"],function(t){"use strict";var e=t.VisibleItemCountMode;var i={};i.render=function(t,i){var r=i.getVisibleItemCountMode()===e.Auto;t.write("<div");t.writeControlData(i);t.addClass("sapUiUx3FacetFilter");t.writeClasses();if(r){t.writeAttribute("style","height:100%")}t.write(">");var s=i.getLists();if(s){for(var a=0;a<s.length;a++){s[a].sWidth=100/s.length+"%";s[a].bFullHeight=r;t.renderControl(s[a])}}t.write("</div>")};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/Feed", ["sap/ui/commons/DropdownBox","sap/ui/commons/MenuButton","sap/ui/commons/SearchField","sap/ui/commons/ToggleButton","sap/ui/core/Control","./Feeder","./library","./FeedRenderer","sap/ui/commons/Menu","sap/ui/core/theming/Parameters","./FeedChunk"],function(t,e,o,i,s,r,n,u,l,h,a){"use strict";var d=n.FeederType;var p=s.extend("sap.ui.ux3.Feed",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{feederThumbnailSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},feederSender:{type:"string",group:"Data",defaultValue:null},live:{type:"boolean",group:"Behavior",defaultValue:true},title:{type:"string",group:"Data",defaultValue:null}},aggregations:{filterItems:{type:"sap.ui.core.ListItem",multiple:true,singularName:"filterItem",bindable:"bindable"},chunks:{type:"sap.ui.ux3.FeedChunk",multiple:true,singularName:"chunk",bindable:"bindable"},toolsMenuItems:{type:"sap.ui.commons.MenuItem",multiple:true,singularName:"toolsMenuItem",bindable:"bindable"}},events:{filterChange:{parameters:{newValue:{type:"string"}}},search:{parameters:{query:{type:"string"}}},chunkAdded:{parameters:{chunk:{type:"sap.ui.ux3.FeedChunk"}}},toolsItemSelected:{parameters:{itemId:{type:"string"},item:{type:"sap.ui.unified.MenuItemBase"}}},toggleLive:{parameters:{live:{type:"boolean"}}}}}});p.prototype.init=function(){this.rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this.data("sap-ui-fastnavgroup","true",true);this.oFeeder=new r(this.getId()+"-Feeder",{type:d.Medium}).setParent(this);this.oFeeder.attachEvent("submit",this.handleFeederSubmit,this);this.oLiveButton=new i(this.getId()+"-liveButton",{text:this.rb.getText("FEED_LIVE"),pressed:this.getLive(),lite:true}).setParent(this);this.oLiveButton.attachEvent("press",this.handleLiveButtonPress,this);this.oFilter=new t(this.getId()+"-filter").setParent(this);this.oFilter.attachEvent("change",this.handleFilterChange,this);this.oSearchField=new o(this.getId()+"-search",{enableListSuggest:false}).setParent(this);this.oSearchField.attachEvent("search",this.handleSearchFieldSearch,this)};p.prototype.initToolsButton=function(){if(!this.oToolsButton){this.oToolsButton=new e(this.getId()+"-toolsButton",{tooltip:this.rb.getText("FEED_TOOLS"),lite:true,menu:new l(this.getId()+"-toolsMenu")}).setParent(this);this.oToolsButton.attachEvent("itemSelected",this.handleLtoolsButtonSelected,this);var t=h._getThemeImage("_sap_ui_ux3_Feed_ToolsIconUrl");var o=h._getThemeImage("_sap_ui_ux3_Feed_ToolsIconHoverUrl");if(t){this.oToolsButton.setProperty("icon",t,true)}if(o){this.oToolsButton.setProperty("iconHovered",o,true)}}};p.prototype.exit=function(){if(this.oFeeder){this.oFeeder.destroy();delete this.oFeeder}if(this.oLiveButton){this.oLiveButton.destroy();delete this.oLiveButton}if(this.oToolsButton){this.oToolsButton.destroy();delete this.oToolsButton}if(this.oFilter){this.oFilter.destroy();delete this.oFilter}if(this.oSearchField){this.oSearchField.destroy();delete this.oSearchField}this.rb=undefined};p.prototype.handleFeederSubmit=function(t){var e=new Date;var o=String(e);var i=new a(this.getId()+"-new-"+this.getChunks().length,{text:t.getParameter("text"),commentChunk:false,deletionAllowed:true,timestamp:o,sender:this.getFeederSender(),thumbnailSrc:this.getFeederThumbnailSrc()});this.insertChunk(i,0);this.fireChunkAdded({chunk:i})};p.prototype.handleLiveButtonPress=function(t){var e=t.getParameter("pressed");this.setProperty("live",e,true);this.fireToggleLive({live:e})};p.prototype.handleLtoolsButtonSelected=function(t){this.fireToolsItemSelected(t.mParameters)};p.prototype.handleFilterChange=function(t){this.fireFilterChange(t.mParameters)};p.prototype.handleSearchFieldSearch=function(t){this.fireSearch(t.mParameters)};p.prototype.setFeederThumbnailSrc=function(t){this.setProperty("feederThumbnailSrc",t,true);this.oFeeder.setThumbnailSrc(t);return this};p.prototype.setLive=function(t){this.setProperty("live",t,true);this.oLiveButton.setPressed(t);return this};p.prototype.getToolsMenuItems=function(){if(this.oToolsButton){return this.oToolsButton.getMenu().getItems()}};p.prototype.insertToolsMenuItem=function(t,e){this.initToolsButton();this.oToolsButton.getMenu().insertItem(t,e);return this};p.prototype.addToolsMenuItem=function(t){this.initToolsButton();this.oToolsButton.getMenu().addItem(t);return this};p.prototype.removeToolsMenuItem=function(t){if(this.oToolsButton){return this.oToolsButton.getMenu().removeItem(t)}};p.prototype.removeAllToolsMenuItems=function(){if(this.oToolsButton){return this.oToolsButton.getMenu().removeAllItems()}};p.prototype.indexOfToolsMenuItem=function(t){if(this.oToolsButton){return this.oToolsButton.getMenu().indexOfItem(t)}};p.prototype.destroyToolsMenuItems=function(){if(this.oToolsButton){this.oToolsButton.getMenu().destroyItems()}return this};p.prototype.bindToolsMenuItems=function(t,e,o,i){this.initToolsButton();this.oToolsButton.getMenu().bindItems(t,e,o,i);return this};p.prototype.unbindToolsMenuItems=function(){if(this.oToolsButton){this.oToolsButton.getMenu().unbindItems()}return this};p.prototype.getFilterItems=function(){return this.oFilter.getItems()};p.prototype.insertFilterItem=function(t,e){this.oFilter.insertItem(t,e);return this};p.prototype.addFilterItem=function(t){this.oFilter.addItem(t);return this};p.prototype.removeFilterItem=function(t){return this.oFilter.removeItem(t)};p.prototype.removeAllFilterItems=function(){return this.oFilter.removeAllItems()};p.prototype.indexOfFilterItem=function(t){return this.oFilter.indexOfItem(t)};p.prototype.destroyFilterItems=function(){this.oFilter.destroyItems();return this};p.prototype.bindFilterItems=function(t,e,o,i){this.oFilter.bindItems(t,e,o,i);return this};p.prototype.unbindFilterItems=function(){this.oFilter.unbindItems();return this};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/FeedChunk", ["sap/ui/thirdparty/jquery","sap/ui/commons/MenuButton","sap/ui/core/Control","sap/ui/core/theming/Parameters","./Feeder","./library","./FeedChunkRenderer","sap/ui/commons/Menu","sap/ui/commons/MenuItem"],function(jQuery,e,t,o,n,i,s,r,a){"use strict";var u=i.FeederType;var l=t.extend("sap.ui.ux3.FeedChunk",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{thumbnailSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},text:{type:"string",group:"Data",defaultValue:null},sender:{type:"string",group:"Data",defaultValue:null},timestamp:{type:"string",group:"Data",defaultValue:null},deletionAllowed:{type:"boolean",group:"Behavior",defaultValue:false},commentChunk:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},feederThumbnailSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},feederSender:{type:"string",group:"Data",defaultValue:null},flagged:{type:"boolean",group:"Data",defaultValue:false},favorite:{type:"boolean",group:"Data",defaultValue:null},shared:{type:"boolean",group:"Data",defaultValue:false},enableFlag:{type:"boolean",group:"Appearance",defaultValue:true},enableShare:{type:"boolean",group:"Appearance",defaultValue:true},enableComment:{type:"boolean",group:"Appearance",defaultValue:true},enableInspect:{type:"boolean",group:"Appearance",defaultValue:true},enableFavorite:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{comments:{type:"sap.ui.ux3.FeedChunk",multiple:true,singularName:"comment",bindable:"bindable"},actionMenuItems:{type:"sap.ui.commons.MenuItem",multiple:true,singularName:"actionMenuItem",bindable:"bindable"}},events:{deleted:{},commentAdded:{parameters:{comment:{type:"sap.ui.ux3.FeedChunk"}}},toggleFlagged:{parameters:{flagged:{type:"boolean"}}},senderClicked:{},referenceClicked:{parameters:{text:{type:"string"}}},toggleFavorite:{parameters:{favorite:{type:"boolean"}}},inspect:{},toggleShared:{parameters:{shareed:{type:"boolean"}}},actionItemSelected:{parameters:{itemId:{type:"string"},item:{type:"sap.ui.unified.MenuItemBase"}}}}}});l.prototype.init=function(){this.maxComments=2;this.allComments=false;this.rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this.expanded=false};l.prototype.initCommentFeeder=function(){if(!this.oCommentFeeder){this.oCommentFeeder=new n(this.getId()+"-CommentFeeder",{type:u.Comment}).setParent(this);this.oCommentFeeder.attachEvent("submit",this.handleCommentFeederSubmit,this);this.showCommentFeeder=true}};l.prototype.initToolsButton=function(){if(!this.oToolsButton){this.oToolsButton=new e(this.getId()+"-toolsButton",{tooltip:this.rb.getText("FEED_TOOLS"),lite:true,menu:new r(this.getId()+"-toolsMenu")}).setParent(this);this.oToolsButton.attachEvent("itemSelected",this.handleToolsButtonSelected,this);var t=o._getThemeImage("_sap_ui_ux3_Feed_ToolsIconUrl");var n=o._getThemeImage("_sap_ui_ux3_Feed_ToolsIconHoverUrl");if(t){this.oToolsButton.setProperty("icon",t,true)}if(n){this.oToolsButton.setProperty("iconHovered",n,true)}}};l.prototype.exit=function(){if(this.oCommentFeeder){this.oCommentFeeder.destroy();delete this.oCommentFeeder}if(this.oToolsButton){this.oToolsButton.destroy();delete this.oToolsButton}this.rb=undefined;this.showCommentFeeder=undefined;this.expanded=undefined;this.oText=undefined;if(this.oHCMMenuButton){this.oHCMMenuButton.destroy();delete this.oHCMMenuButton}};l.prototype.onAfterRendering=function(){this.oText=this.$().children(".sapUiFeedChunkText").get(0);if(this.oText.clientHeight<this.oText.scrollHeight){var e=this.$().children(".sapUiFeedChunkByline").get(0);jQuery(e).append(s.renderExpander(this));if(this.expanded){jQuery(this.oText).css("height","auto")}}};l.prototype.onclick=function(e){var t=e.target.getAttribute("ID");if(t){switch(t){case this.getId()+"-delete":this.fireDeleted();break;case this.getId()+"-sender":this.fireSenderClicked();break;case this.getId()+"-thumb":this.fireSenderClicked();break;case this.getId()+"-exp":var o="";if(this.expanded){jQuery(this.oText).css("height","");o=this.rb.getText("FEED_EXPAND");this.expanded=false}else{jQuery(this.oText).css("height","auto");o=this.rb.getText("FEED_COLLAPSE");this.expanded=true}jQuery(document.getElementById(t)).attr("title",o).toggleClass("sapUiFeedChunkExpand sapUiFeedChunkCollapse");break;case this.getId()+"-all":this.showAllComments();break;case this.getId()+"-ActComment":if(!this.showCommentFeeder){this.initCommentFeeder();this.rerender()}break;case this.getId()+"-ActFlag":this.setFlagged(!this.getFlagged());this.fireToggleFlagged({flagged:this.getFlagged()});break;case this.getId()+"-ActFavorite":this.setFavorite(!this.getFavorite());this.fireToggleFavorite({favorite:this.getFavorite()});break;case this.getId()+"-ActInspect":this.fireInspect();break;case this.getId()+"-ActShare":this.setShared(!this.getShared());this.fireToggleShared({shared:this.getShared()});break;default:if(t.search(this.getId()+"-Ref")!=-1){this.fireReferenceClicked({text:jQuery(e.target).text()})}break}}e.preventDefault();e.stopPropagation()};l.prototype.showAllComments=function(){this.allComments=!this.allComments;var e=this.$().children("section");if(e.length>0){var t=sap.ui.getCore().createRenderManager();this.getRenderer().renderComments(t,this);t.flush(e[0]);t.destroy()}};l.prototype.handleCommentFeederSubmit=function(e){var t=new Date;var o=String(t);var n=new l(this.getId()+"-new-"+this.getComments().length,{text:e.getParameter("text"),commentChunk:true,deletionAllowed:true,timestamp:o,sender:this.getFeederSender(),thumbnailSrc:this.getFeederThumbnailSrc()});this.addComment(n);this.fireCommentAdded({comment:n})};l.prototype.handleToolsButtonSelected=function(e){if(e.getParameter("itemId")==this.getId()+"-actDelete"){this.fireDeleted()}else{this.fireActionItemSelected(e.mParameters)}};l.prototype.insertComment=function(e,t){this.insertAggregation("comments",e,t);this.initCommentFeeder();return this};l.prototype.addComment=function(e){this.addAggregation("comments",e);this.initCommentFeeder();return this};l.prototype.setDeletionAllowed=function(e){if(e==this.getDeletionAllowed()){return this}this.setProperty("deletionAllowed",e);if(e){this.initToolsButton();this.oToolsButton.getMenu().insertItem(new a(this.getId()+"-actDelete",{text:this.rb.getText("FEED_DELETE")}),0)}else{if(this.oToolsButton){this.oToolsButton.getMenu().removeItem(this.getId()+"-actDelete")}}return this};l.prototype.getActionMenuItems=function(){if(this.oToolsButton){var e=this.oToolsButton.getMenu().getItems();if(e.length>0&&e[0].getId()==this.getId()+"-actDelete"){e.shift()}return e}};l.prototype.insertActionMenuItem=function(e,t){this.initToolsButton();var o=this.oToolsButton.getMenu().getItems();if(o.length>0&&o[0].getId()==this.getId()+"-actDelete"){t++}this.oToolsButton.getMenu().insertItem(e,t);return this};l.prototype.addActionMenuItem=function(e){this.initToolsButton();this.oToolsButton.getMenu().addItem(e);return this};l.prototype.removeActionMenuItem=function(e){if(this.oToolsButton){return this.oToolsButton.getMenu().removeItem(e)}};l.prototype.removeAllActionMenuItems=function(){if(this.oToolsButton){var e=this.oToolsButton.getMenu().getItems();if(e.length>0&&e[0].getId()==this.getId()+"-actDelete"){e.shift();for(var t=0;t<e.length;t++){this.oToolsButton.getMenu().removeItem(e[t])}return e}else{return this.oToolsButton.getMenu().removeAllItems()}}};l.prototype.indexOfActionMenuItem=function(e){if(this.oToolsButton){var t=this.oToolsButton.getMenu().indexOfItem(e);var o=this.oToolsButton.getMenu().getItems();if(o.length>0&&o[0].getId()==this.getId()+"-actDelete"){t--}return t}};l.prototype.destroyActionMenuItems=function(){if(this.oToolsButton){var e=this.oToolsButton.getMenu().getItems();if(e.length>0&&e[0].getId()==this.getId()+"-actDelete"){this.removeAllActionMenuItems()}else{this.oToolsButton.getMenu().destroyItems()}}return this};l.prototype.bindActionMenuItems=function(e,t,o,n){this.initToolsButton();this.oToolsButton.getMenu().bindItems(e,t,o,n);return this};l.prototype.unbindActionMenuItems=function(){if(this.oToolsButton){this.oToolsButton.getMenu().unbindItems()}return this};l.prototype.getFeederThumbnailSrc=function(){var e=this.getProperty("feederThumbnailSrc");if(!e||e==""){var t=this.getParent();if(t&&(t instanceof sap.ui.ux3.Feed||t instanceof l)){e=t.getFeederThumbnailSrc()}}return e};l.prototype.getFeederSender=function(){var e=this.getProperty("feederSender");if(!e||e==""){var t=this.getParent();if(t&&(t instanceof sap.ui.ux3.Feed||t instanceof l)){e=t.getFeederSender()}}return e};l.prototype.initHCMMenuButton=function(){if(!this.oHCMMenuButton){this.oHCMMenuButton=new e(this.getId()+"-HCMMenu",{lite:true}).setParent(this);this.oHCMMenuButton.attachEvent("itemSelected",this.handleHCMMenuButtonSelected,this)}};l.prototype.setHCMMenu=function(e){this.initHCMMenuButton();this.oHCMMenuButton.setMenu(e);return this};l.prototype.handleHCMMenuButtonSelected=function(e){this.fireEvent("HCMMenuItemSelected",e.mParameters)};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/FeedChunkRenderer", ["sap/ui/core/theming/Parameters","sap/base/security/encodeXML","sap/base/security/URLListValidator"],function(e,t,i){"use strict";var r={};r.render=function(t,i){if(i.getParent()instanceof sap.ui.ux3.FeedChunk){i.bComment=true}else{i.bComment=false}var r=i.getId();t.write("<article");t.writeControlData(i);t.addClass("sapUiFeedChunk");if(i.bComment){t.addClass("sapUiFeedChunkComment")}t.writeClasses();t.write(">");t.write("<img id="+r+"-thumb");var a=i.getThumbnailSrc();if(!a){a=e._getThemeImage("_sap_ui_ux3_FeedChunk_PersonPlaceholder")}t.writeAttributeEscaped("src",a);t.writeAttributeEscaped("alt",i.getSender());t.writeClasses();t.write(">");t.write('<div class= "sapUiFeedChunkText" >');t.write("<a id="+r+"-sender ");t.writeAttribute("href","#");t.write(">");t.writeEscaped(i.getSender());t.write("</a> ");if(i.oHCMMenuButton){t.renderControl(i.oHCMMenuButton)}this.renderText(t,i);t.write("</div>");if(!i.bComment){t.write('<ul class= "sapUiFeedChunkStatusIcons" >');if(i.getFlagged()){t.write('<li class= "sapUiFeedChunkFlagged" title="'+i.rb.getText("FEED_FLAGGED")+'" >&#9873</li>')}if(i.getFavorite()){t.write('<li class= "sapUiFeedChunkFavorite" title="'+i.rb.getText("FEED_FAVORITE")+'" >&#9733</li>')}if(i.getShared()){t.write('<li class= "sapUiFeedChunkShared" title="'+i.rb.getText("FEED_SHARED")+'" >&#8635</li>')}t.write("</ul>")}t.write('<span class= "sapUiFeedChunkByline" >');t.writeEscaped(i.getTimestamp());t.write("</span>");if(!i.bComment){if(i.oToolsButton){t.renderControl(i.oToolsButton)}if(i.getEnableShare()){t.write('<button type = "button" id='+r+'-ActShare class= "sapUiFeedChunkAct sapUiFeedChunkActShare" title="'+i.rb.getText("FEED_ACT_SHARE")+'" >&#8635</BUTTON>')}if(i.getEnableInspect()){t.write('<button type = "button" id='+r+'-ActInspect class= "sapUiFeedChunkAct sapUiFeedChunkActInspect" title="'+i.rb.getText("FEED_ACT_INSPECT")+'" >i</BUTTON>')}if(i.getEnableFavorite()){t.write('<button type = "button" id='+r+'-ActFavorite class= "sapUiFeedChunkAct sapUiFeedChunkActFavorite" title="'+i.rb.getText("FEED_ACT_FAVORITE")+'" >&#9733</BUTTON>')}if(i.getEnableFlag()){t.write('<button type = "button" id='+r+'-ActFlag class= "sapUiFeedChunkAct sapUiFeedChunkActFlag" title="'+i.rb.getText("FEED_ACT_FLAG")+'" >&#9873</BUTTON>')}if(i.getEnableComment()){t.write('<button type = "button" id='+r+'-ActComment class= "sapUiFeedChunkAct sapUiFeedChunkActComment" title="'+i.rb.getText("FEED_ACT_COMMENT")+'" >C</BUTTON>')}}if(i.getDeletionAllowed()&&i.bComment){t.write('<button type = "button" id='+r+'-delete class= "sapUiFeedChunkDel" title="'+i.rb.getText("FEED_DELETE")+'" >X</BUTTON>')}if(i.getComments().length>0||i.showCommentFeeder){t.write("<section>");this.renderComments(t,i);t.write("</section>")}t.write("</article>")};r.renderText=function(e,r){var a=r.getText();var s=0;var n=0;do{n=a.search(/\s/);var l="",d="";if(n<0){d=a}else{d=a.slice(0,n);l=a.slice(n,n+1);a=a.slice(n+1)}if(/^@/.test(d)){e.write("<a id="+r.getId()+"-Ref"+s);e.writeAttribute("href","#");e.write(">");e.writeEscaped(d,true);e.write("</a>",l);s++}else if(/^(https?|ftp):\/\//i.test(d)&&i.validate(d)){e.write("<a");e.writeAttribute("href",t(d));e.write(">");e.writeEscaped(d,true);e.write("</a>",l)}else if(/^(www\.)/i.test(d)&&i.validate("http://"+d)){e.write("<a");e.writeAttribute("href",t("http://"+d));e.write(">");e.writeEscaped(d,true);e.write("</a>",l)}else if(/^[\w\.=-]+@[\w\.-]+\.[\w]{2,5}$/.test(d)){e.write("<a");e.writeAttribute("href","mailto:"+t(d));e.write(">");e.writeEscaped(d,true);e.write("</a>",l)}else{e.writeEscaped(d+l,true)}}while(n>=0)};r.renderComments=function(e,t){var i=t.getComments();var r=i.length;e.write('<header class= "sapUiFeedChunkComments" >');if(t.rb){e.write(t.rb.getText("FEED_NO_COMMENTS",[r]));if(r>t.maxComments){e.write("<a id="+t.getId()+"-all ");e.writeAttribute("href","#");e.write(">");if(!t.allComments){e.write(t.rb.getText("FEED_ALL_COMMENTS"))}else{e.write(t.rb.getText("FEED_MAX_COMMENTS"))}e.write("</a>")}}e.write("</header>");var a=r;if(!t.allComments&&t.maxComments<a){a=t.maxComments}for(var s=0;s<a;s++){e.renderControl(i[r-a+s])}if(t.oCommentFeeder){e.renderControl(t.oCommentFeeder)}};r.renderExpander=function(e){if(e.expanded){return"<button id= '"+e.getId()+"-exp' class='sapUiFeedChunkCollapse' title='"+e.rb.getText("FEED_COLLAPS")+"'>&#9660</button>"}else{return"<button id= '"+e.getId()+"-exp' class='sapUiFeedChunkExpand' title='"+e.rb.getText("FEED_EXPAND")+"'>&#9660</button>"}};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/FeedRenderer", [],function(){"use strict";var e={};e.render=function(e,r){e.write("<div");e.writeControlData(r);e.addClass("sapUiFeed");e.writeClasses();e.write(">");e.renderControl(r.oFeeder);e.write("<header class=sapUiFeedTitle ><h4>");var t=r.getTitle();if(!t||t==""){t=r.rb.getText("FEED_TITLE")}e.writeEscaped(t);if(r.oToolsButton){e.renderControl(r.oToolsButton)}e.renderControl(r.oLiveButton);e.write("</h4>");e.write('<div class="sapUiFeedToolbar" >');e.renderControl(r.oFilter);e.renderControl(r.oSearchField);e.write("</div>");e.write("</header>");e.write("<section>");for(var i=0;i<r.getChunks().length;i++){var o=r.getChunks()[i];e.renderControl(o)}e.write("</section>");e.write("</div>")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/Feeder", ["sap/ui/thirdparty/jquery","sap/ui/commons/Button","sap/ui/core/Control","sap/ui/core/theming/Parameters","./library","./FeederRenderer","sap/ui/commons/library","sap/ui/Device"],function(jQuery,e,t,n,o,r,i,s){"use strict";var u=i.ButtonStyle;var a=o.FeederType;var p=t.extend("sap.ui.ux3.Feeder",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{thumbnailSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},text:{type:"string",group:"Data",defaultValue:null},type:{type:"sap.ui.ux3.FeederType",group:"Appearance",defaultValue:a.Large},placeholderText:{type:"string",group:"Appearance",defaultValue:null}},events:{submit:{parameters:{text:{type:"string"}}}}}});p.prototype.init=function(){this.rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this.oSendButton=new e(this.getId()+"-send",{style:u.Emph,icon:"sap-icon://feeder-arrow"}).setParent(this);this.oSendButton.attachEvent("press",this.handleSendButtonPress,this)};p.prototype.initSendButton=function(){if(this.getText()==""){this.oSendButton.setProperty("enabled",false,true)}};p.prototype.exit=function(){this.rb=undefined;this.oInput=undefined;if(this.oSendButton){this.oSendButton.destroy();delete this.oSendButton}};p.prototype.onAfterRendering=function(){this.oInput=this.$("input")};p.prototype.onclick=function(e){var t=e.target.getAttribute("ID");switch(t){case this.getId()+"-send":break;case this.getId()+"-input":break;default:break}};p.prototype.onfocusin=function(e){this.oInput.find(".sapUiFeederEmptyText").remove()};p.prototype.onfocusout=function(e){var t=this.oInput.text();if(t==""){this.oInput.empty();this.oInput.append(r.getEmptyTextInfo(this))}this.setProperty("text",t,true)};p.prototype.getFocusDomRef=function(){return this.getDomRef("input")};p.prototype.onkeyup=function(e){if(this.oInput.text()==""){this.oSendButton.setEnabled(false)}else{this.oSendButton.setEnabled(true)}};p.prototype.handleSendButtonPress=function(e){var t=this.getMultilineText(this.oInput);this.setProperty("text",t,true);this.fireSubmit({text:t});this.setText("")};p.prototype.getMultilineText=function(e){function t(e){var n;var o="";for(var r=0;r<e.length;r++){n=e[r];if(n.nodeType===3||n.nodeType===4){if(!((s.browser.msie||s.browser.edge)&&n.nodeValue===" ")){o+=n.nodeValue.replace(/\n/g,"")}}if(n.nodeName==="DIV"||n.nodeName==="P"||n.nodeName==="BR"&&!s.browser.webkit){if(n.nodeName==="BR"&&s.browser.firefox&&r===e.length-1&&jQuery(n).attr("type")==="_moz"){continue}if(!((s.browser.msie||s.browser.edge)&&o==="")&&!((s.browser.firefox||s.browser.webkit)&&o===""&&n.nodeName==="P")&&!(s.browser.webkit&&n.nodeName==="P"&&n.textContent.match(/^(\n)*$/))){o+="\n"}}if(n.nodeType!==8){o+=t(n.childNodes)}}return o}return t(e.get(0).childNodes)};p.prototype.getThumbnailSrc=function(){var e=this.getProperty("thumbnailSrc");if(!e||e==""){var t=this.getParent();if(t&&(t instanceof sap.ui.ux3.Feed||t instanceof sap.ui.ux3.FeedChunk)){e=t.getFeederThumbnailSrc()}}return e};p.prototype.onpaste=function(e){if(s.browser.firefox){setTimeout(this.onAfterPaste.bind(this),10)}};p.prototype.onAfterPaste=function(){var e=this.oInput.get(0).childNodes;for(var t=0;t<e.length;t++){var n=e[t];if(n.nodeName=="PRE"){jQuery(n).css("overflow","hidden")}}};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/FeederRenderer", ["./library","sap/ui/core/theming/Parameters","sap/base/security/encodeXML"],function(e,t,r){"use strict";var i=e.FeederType;var a={};a.render=function(e,r){e.write("<div");e.writeControlData(r);e.addClass("sapUiFeeder");switch(r.getType()){case i.Medium:e.addClass("sapUiFeederMedium");break;case i.Comment:e.addClass("sapUiFeederComment");break;default:e.addClass("sapUiFeederLarge");break}e.writeClasses();e.write(">");e.write("<img id="+r.getId()+"-thumb");var a=r.getThumbnailSrc();if(!a){a=t._getThemeImage("_sap_ui_ux3_Feeder_PersonPlaceholder")}e.writeAttributeEscaped("src",a);e.writeClasses();e.write(">");e.write("<div id="+r.getId()+'-input contenteditable="true" class="sapUiFeederInput" >');if(r.getText()==""){e.write(this.getEmptyTextInfo(r))}else{e.writeEscaped(r.getText(),true)}e.write("</div>");r.initSendButton();e.renderControl(r.oSendButton);e.write("</div>")};a.getEmptyTextInfo=function(e){return"<span class='sapUiFeederEmptyText'>"+r(e.getPlaceholderText()||e.rb.getText("FEED_EMPTY_FEEDER"))+"</span>"};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/NavigationBar", ["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/delegate/ItemNavigation","./library","./NavigationBarRenderer","sap/ui/commons/Menu","sap/ui/commons/MenuItem","sap/ui/core/Popup","sap/ui/events/jquery/EventSimulation","sap/ui/dom/denormalizeScrollLeftRTL","sap/ui/util/ActivityDetection","sap/ui/Device","sap/base/assert","sap/ui/core/Configuration","sap/ui/dom/jquery/scrollRightRTL","sap/ui/dom/jquery/scrollLeftRTL"],function(jQuery,t,e,i,r,o,a,s,n,l,u,c,f,h){"use strict";var v=s.Dock;var d=t.extend("sap.ui.ux3.NavigationBar",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{toplevelVariant:{type:"boolean",group:"Misc",defaultValue:false},overflowItemsToUpperCase:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"item"},overflowMenu:{type:"sap.ui.commons.Menu",multiple:false,visibility:"hidden"}},associations:{selectedItem:{type:"sap.ui.ux3.NavigationItem",multiple:false},associatedItems:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"associatedItem"}},events:{select:{allowPreventDefault:true,parameters:{itemId:{type:"string"},item:{type:"sap.ui.ux3.NavigationItem"}}}}}});d.SCROLL_STEP=250;d.prototype.init=function(){this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._iLastArrowPos=-100;this._bRtl=h.getRTL();this.allowTextSelection(false);this.startScrollX=0;this.startTouchX=0;var t=this;this._oItemNavigation=(new e).setCycling(false);this.addDelegate(this._oItemNavigation);this.data("sap-ui-fastnavgroup","true",true);if(n.touchEventMode==="ON"){var i=function(e){e.preventDefault();if(t._iInertiaIntervalId){window.clearInterval(t._iInertiaIntervalId)}t.startScrollX=t.getDomRef("list").scrollLeft;t.startTouchX=e.touches[0].pageX;t._bTouchNotMoved=true;t._lastMoveTime=(new Date).getTime()};var r=function(e){var i=e.touches[0].pageX-t.startTouchX;var r=t.getDomRef("list");var o=r.scrollLeft;var a=t.startScrollX-i;r.scrollLeft=a;t._bTouchNotMoved=false;var s=(new Date).getTime()-t._lastMoveTime;t._lastMoveTime=(new Date).getTime();if(s>0){t._velocity=(a-o)/s}e.preventDefault()};var o=function(e){if(t._bTouchNotMoved===false){e.preventDefault();var i=t.getDomRef("list");var r=50;var o=Math.abs(t._velocity/10);t._iInertiaIntervalId=setInterval(function(){t._velocity=t._velocity*.8;var e=t._velocity*r;i.scrollLeft=i.scrollLeft+e;if(Math.abs(t._velocity)<o){window.clearInterval(t._iInertiaIntervalId);t._iInertiaIntervalId=undefined}},r)}else if(t._bTouchNotMoved===true){t.onclick(e);e.preventDefault()}t._bTouchNotMoved=undefined;t._lastMoveTime=undefined};this.ontouchstart=i;this.ontouchend=o;this.ontouchmove=r}};d.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation}if(this._checkOverflowIntervalId){clearInterval(this._checkOverflowIntervalId);this._checkOverflowIntervalId=null}};d.prototype.onBeforeRendering=function(){if(this._checkOverflowIntervalId){clearInterval(this._checkOverflowIntervalId);this._checkOverflowIntervalId=null}this._iSoredScrollPosition=this.$("list").scrollLeft();if(c.browser.firefox){this.$().off("DOMMouseScroll",this._handleScroll)}else{this.$().off("mousewheel",this._handleScroll)}var t=this.getDomRef("arrow");this._iLastArrowPos=t?parseInt(this._bRtl?t.style.right:t.style.left):-100};d.prototype.invalidate=function(e){if(e instanceof sap.ui.ux3.NavigationItem){this._menuInvalid=true}t.prototype.invalidate.apply(this,arguments)};d.prototype._calculatePositions=function(){var t=this.getDomRef();this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._checkOverflow(t.firstChild,this.getDomRef("ofb"),this.getDomRef("off"))};d.prototype.onThemeChanged=function(){if(this.getDomRef()){this._calculatePositions()}};d.prototype.onAfterRendering=function(){var t=this.getDomRef();var e=t.firstChild;var i=this.getDomRef("ofb");var r=this.getDomRef("off");this._checkOverflowIntervalId=setInterval(this._checkOverflow.bind(this,e,i,r),350);if(c.browser.firefox){jQuery(t).on("DOMMouseScroll",jQuery.proxy(this._handleScroll,this))}else{jQuery(t).on("mousewheel",jQuery.proxy(this._handleScroll,this))}this._calculatePositions();this._updateItemNavigation();var o=this.$();o.on("scroll",function(){o.children().scrollTop(0);o.scrollTop(0)});if(this._iSoredScrollPosition){this.$("list").scrollLeft(this._iSoredScrollPosition)}};d.prototype._updateItemNavigation=function(){var t=this.getDomRef();if(t){var e=-1;var i=this.getSelectedItem();var r=jQuery(t).children().children("li").children().not(".sapUiUx3NavBarDummyItem");r.each(function(t,r){if(r.id==i){e=t}});this._oItemNavigation.setRootDomRef(t);this._oItemNavigation.setItemDomRefs(r.toArray());this._oItemNavigation.setSelectedIndex(e)}};d.prototype.onsapspace=function(t){this._handleActivation(t)};d.prototype.onclick=function(t){this._handleActivation(t)};d.prototype.setOverflowItemsToUpperCase=function(t){this._getOverflowMenu().toggleStyleClass("sapUiUx3NavBarUpperCaseText",t);return this.setProperty("overflowItemsToUpperCase",t)};d.prototype._handleActivation=function(t){var e=t.target.id;if(e){var i=this.getId();t.preventDefault();if(e==i+"-ofb"){this._scroll(-d.SCROLL_STEP,500)}else if(e==i+"-off"){this._scroll(d.SCROLL_STEP,500)}else if(e==i+"-oflt"||e==i+"-ofl"){this._showOverflowMenu()}else{var r=sap.ui.getCore().byId(e);if(r&&e!=this.getSelectedItem()&&sap.ui.getCore().byId(e)instanceof sap.ui.ux3.NavigationItem){if(this.fireSelect({item:r,itemId:e})){this.setAssociation("selectedItem",r,true);this._updateSelection(e)}}}}};d.prototype._getOverflowMenu=function(){var t=this.getAggregation("overflowMenu");if(!t||this._menuInvalid){if(t){t.destroyAggregation("items",true)}else{t=new o}var e=this._getCurrentItems();var i=this;var r=this.getSelectedItem();for(var s=0;s<e.length;++s){var n=e[s];var l=new a(n.getId()+"-overflowItem",{text:n.getText(),visible:n.getVisible(),icon:r==n.getId()?"sap-icon://accept":null,select:function(t){return function(e){i._handleActivation({target:{id:t.getId()},preventDefault:function(){}})}}(n)});t.addAggregation("items",l,true)}this.setAggregation("overflowMenu",t,true);this._menuInvalid=false}return t};d.prototype._getCurrentItems=function(){var t=this.getItems();if(t.length<1){t=this.getAssociatedItems();var e=sap.ui.getCore();for(var i=0;i<t.length;++i){t[i]=e.byId(t[i])}}return t};d.prototype._showOverflowMenu=function(){var t=this._getOverflowMenu();var e=this.$("ofl").get(0);t.open(true,e,v.EndTop,v.CenterCenter,e)};d.prototype._updateSelection=function(t){this._menuInvalid=true;var e=jQuery(document.getElementById(t));e.attr("tabindex","0").attr("aria-checked","true");e.parent().addClass("sapUiUx3NavBarItemSel");e.parent().parent().children().each(function(){var e=this.firstChild;if(e&&e.id!=t&&e.className.indexOf("Dummy")==-1){jQuery(e).attr("tabindex","-1");jQuery(e).parent().removeClass("sapUiUx3NavBarItemSel");jQuery(e).attr("aria-checked","false")}});var i=e.parent().index();if(i>0){i--}this._oItemNavigation.setSelectedIndex(i);var r=this.$("arrow");var o=r.outerWidth();var a=d._getArrowTargetPos(t,o,this._bRtl);r.stop();var s=this._bRtl?{right:a+"px"}:{left:a+"px"};r.animate(s,500,"linear");var n=this;window.setTimeout(function(){a=d._getArrowTargetPos(t,o,n._bRtl);r.stop();var e=n._bRtl?{right:a+"px"}:{left:a+"px"};r.animate(e,200,"linear",function(){var e=t?window.document.getElementById(t):null;n._scrollItemIntoView(e)})},300)};d.prototype._scrollItemIntoView=function(t){if(!t){return}var e=jQuery(t.parentNode);var i=e.parent();var r;var o=h.getRTL();var a=e.index()-1;if(a==0){r=o?i[0].scrollWidth-i.innerWidth()+20:0}else if(a==e.siblings().length-2){r=o?0:i[0].scrollWidth-i.innerWidth()+20}else{var s=e.position().left;var n=o?i.scrollLeftRTL():i.scrollLeft();if(s<0){r=n+s}else{var u=i.innerWidth()-(s+e.outerWidth(true));if(u<0){r=n-u;r=Math.min(r,n+s)}}}if(r!==undefined){if(o){r=l(r,i.get(0))}i.stop(true,true).animate({scrollLeft:r})}};d._getArrowTargetPos=function(t,e,i){var r=jQuery(document.getElementById(t));if(r.length>0){var o=r.outerWidth();var a=Math.round(r[0].offsetLeft+o/2-e/2);if(!i){return a}else{return r.parent().parent().innerWidth()-a-e}}else{return-100}};d.prototype._handleScroll=function(t){if(t.type=="DOMMouseScroll"){var e=t.originalEvent.detail*40;this._scroll(e,50)}else{var e=-t.originalEvent.wheelDelta;this._scroll(e,50)}t.preventDefault()};d.prototype._scroll=function(t,e){var i=this.$()[0].firstChild;var r=i.scrollLeft;if(!c.browser.msie&&this._bRtl){t=-t}var o=r+t;jQuery(i).stop(true,true).animate({scrollLeft:o},e)};d.prototype._checkOverflow=function(t,e,i){function r(){return c.os.macintosh&&c.browser.chrome}if(t&&this.getDomRef()&&u.isActive()){var o=t.scrollLeft;var a=false;var s=false;var n=t.scrollWidth;var l=t.clientWidth;var f=r()?5:0;if(Math.abs(n-l)==1){n=l}if(!this._bRtl){if(o>f){a=true}if(n>l&&n-(o+l)>f){s=true}}else{var h=jQuery(t);if(h.scrollLeftRTL()>f){s=true}if(h.scrollRightRTL()>f){a=true}}if(s!=this._bPreviousScrollForward||a!=this._bPreviousScrollBack){this._bPreviousScrollForward=s;this._bPreviousScrollBack=a;this.$().toggleClass("sapUiUx3NavBarScrollBack",a).toggleClass("sapUiUx3NavBarScrollForward",s);if(!d._bMenuLoaded&&(a||s)){d._bMenuLoaded=true}}var v=sap.ui.getCore().byId(this.getSelectedItem());if(v){var p=this.$("arrow");var m=p.outerWidth();var g=d._getArrowTargetPos(v.getId(),m,this._bRtl)+"px";if(!this._bRtl){if(p[0].style.left!=g){p[0].style.left=g}}else{if(p[0].style.right!=g){p[0].style.right=g}}}}};d.prototype.setSelectedItem=function(t){this.setAssociation("selectedItem",t,true);if(this.getDomRef()){var e=!t||typeof t=="string"?t:t.getId();this._updateSelection(e)}return this};d.prototype.addItem=function(t){this._menuInvalid=true;return this.addAggregation("items",t)};d.prototype.destroyItems=function(){this._menuInvalid=true;return this.destroyAggregation("items")};d.prototype.insertItem=function(t,e){this._menuInvalid=true;return this.insertAggregation("items",t,e)};d.prototype.removeItem=function(t){this._menuInvalid=true;return this.removeAggregation("items",t)};d.prototype.removeAllItems=function(){this._menuInvalid=true;return this.removeAllAggregation("items")};d.prototype.addAssociatedItem=function(t){this._menuInvalid=true;return this.addAssociation("associatedItems",t)};d.prototype.removeAssociatedItem=function(t){this._menuInvalid=true;return this.removeAssociation("associatedItems",t)};d.prototype.removeAllAssociatedItems=function(){this._menuInvalid=true;return this.removeAllAssociation("associatedItems")};d.prototype.setAssociatedItems=function(t){f(Array.isArray(t),"aItems must be an array");var e=this.getDomRef("list");this.removeAllAssociation("associatedItems",true);for(var i=0;i<t.length;i++){this.addAssociation("associatedItems",t[i],true)}if(e){var o=jQuery(e).find(":focus");var a=o.length>0?o.attr("id"):null;if(arguments.length>1&&typeof arguments[1]==="boolean"){this._iLastArrowPos=-100}else{var s=this.getDomRef("arrow");this._iLastArrowPos=parseInt(this._bRtl?s.style.right:s.style.left)}e.innerHTML="";var n=sap.ui.getCore().createRenderManager();r.renderItems(n,this);n.flush(e,true);n.destroy();var l=a?document.getElementById(a):null;if(l){l.focus()}this._updateSelection(this.getSelectedItem());this._updateItemNavigation()}return this};d.prototype.isSelectedItemValid=function(){var t=this.getSelectedItem();if(!t){return false}var e=this.getItems();if(!e||e.length==0){e=this.getAssociatedItems();for(var i=0;i<e.length;i++){if(e[i]==t){return true}}}else{for(var i=0;i<e.length;i++){if(e[i].getId()==t){return true}}}return false};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/NavigationBarRenderer", ["sap/base/security/encodeXML"],function(e){"use strict";var a={};a.render=function(e,t){var r=t.getId();e.addClass("sapUiUx3NavBar").addClass("sapUiUx3NavBarUpperCaseText");if(t.getToplevelVariant()){e.addClass("sapUiUx3NavBarToplevel")}e.write("<nav");e.writeControlData(t);e.writeClasses();e.write("role='navigation'>");e.write("<ul id='"+r+"-list' role='menubar' class='sapUiUx3NavBarList'");e.addStyle("white-space","nowrap");e.writeStyles();e.write(">");a.renderItems(e,t);e.write("</ul>");e.write("<a id='"+r+"-ofb' role='presentation' class='sapUiUx3NavBarBack' href='#'></a>");e.write("<a id='"+r+"-off' role='presentation' class='sapUiUx3NavBarForward' href='#'></a>");e.write("<a id='"+r+"-ofl' role='presentation' class='sapUiUx3NavBarOverflowBtn' href='#'>");e.writeIcon("sap-icon://overflow",[],{id:r+"-oflt"});e.write("</a>");e.write("</nav>")};a.renderItems=function(a,t){var r=t.getItems();var i=false;if(!r||r.length==0){r=t.getAssociatedItems();i=true}var s=r.length;a.write("<li");a.addStyle("display","inline-block");a.writeStyles();a.write(">");a.write("<a id='"+t.getId()+"-dummyItem' class='sapUiUx3NavBarDummyItem sapUiUx3NavBarItem'>&nbsp;</a></li>");var l=t.getSelectedItem();for(var o=0;o<s;o++){var n=i?sap.ui.getCore().byId(r[o]):r[o];if(n.getVisible()){var w=n.getId();var d=w==l;a.write("<li");a.addStyle("display","inline-block");a.writeStyles();if(d){a.write(" class='sapUiUx3NavBarItemSel'")}a.write("><a ");a.writeElementData(n);a.writeAttributeEscaped("href",n.getHref()||"#");a.write(" aria-setsize='"+s+"' aria-posinset='"+(o+1)+"' role='menuitemradio' class='sapUiUx3NavBarItem'");if(d){a.write(" tabindex='0'")}a.write(" aria-checked='"+(d?"true":"false")+"'");var p=n.getTooltip_AsString();if(p){a.write(" title='"+e(p)+"'")}a.write(">");a.write(e(n.getText()));a.write("</a></li>")}}var v;if(t._bRtl){v="right:"+t._iLastArrowPos}else{v="left:"+t._iLastArrowPos}a.write("<span id='"+t.getId()+"-arrow' style='"+v+"px;");a.write("' class='sapUiUx3NavBarArrow'></span>")};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/NavigationItem", ["sap/ui/core/Item","./library"],function(e,a){"use strict";var t=e.extend("sap.ui.ux3.NavigationItem",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{visible:{type:"boolean",group:"Appearance",defaultValue:true},href:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null}},defaultAggregation:"subItems",aggregations:{subItems:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"subItem"}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/NotificationBar", ["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/delegate/ItemNavigation","sap/ui/core/theming/Parameters","./library","./NotificationBarRenderer","sap/ui/core/Message","sap/ui/core/library","sap/ui/Device","sap/base/Log"],function(jQuery,e,t,i,s,a,r,o,n,g){"use strict";var l=o.MessageType;var f=s.NotificationBarStatus;var h=e.extend("sap.ui.ux3.NotificationBar",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{visibleStatus:{type:"sap.ui.ux3.NotificationBarStatus",group:"Misc",defaultValue:f.Default},resizeEnabled:{type:"boolean",group:"Misc",defaultValue:true},alwaysShowToggler:{type:"boolean",defaultValue:false}},aggregations:{messageNotifier:{type:"sap.ui.core.Element",multiple:false},notifiers:{type:"sap.ui.core.Element",multiple:true,singularName:"notifier"}},events:{display:{parameters:{show:{type:"boolean"}}},resize:{parameters:{status:{type:"sap.ui.ux3.NotificationBarStatus"}}}}}});e.extend("sap.ui.ux3.NotificationBar.NotifierView",{renderMessages:function(e){e.write("<div");e.writeAttribute("id",this.getId()+"-content");e.addClass("sapUiNotifierContent");e.writeClasses();e.write(">");var t=this.getMessages();var i=t.length-1;var s=true;for(;i>=0;i--){if(!s||i==0&&t.length>1){e.write("<div");e.addClass("sapUiNotificationBarCltSep");e.writeClasses();e.write(">");e.write("</div>")}else{s=false}var a=t[i];if(a._message&&a._message.getReadOnly()){a.addStyleClass("sapUiNotifierMessageReadOnly")}e.renderControl(a)}e.write("</div>")},metadata:{library:"sap.ui.ux3",properties:{title:"string",visibleItems:"int",renderMode:{type:"string",defaultValue:"callout"}},aggregations:{messages:"sap.ui.ux3.NotificationBar.MessageView"}},init:function(){this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3")},exit:function(){if(this._renderedControl){delete this._renderedControl}delete this._oResBundle},getTitle:function(){var e=this.getProperty("title");var t=this.getMessages().length;if(t>0){var i="NOTIBAR_NOTIFIER_VIEW_TITLE";e=this._oResBundle.getText(i,[e,t])}return e},renderer:function(e,t){e.write("<div");e.addClass("sapUiNotifierContainer");e.writeControlData(t);e.writeClasses();e.write(">");e.write("<div");e.writeAttribute("id",t.getId()+"-title");e.addClass("sapUiNotifierTitle");e.writeClasses();e.write(">");e.writeEscaped(t.getTitle());e.write("</div>");if(t.getMessages().length>0){t.renderMessages(e)}e.write("</div>")},onAfterRendering:function(){var e=this.$("content"),t=e.children(".sapUiNotifierMessage"),i=t.length,s=this.getVisibleItems();if(i>s){setTimeout(this._fnAfterRenderingCallback.bind(this,t,e,s),0)}},_fnAfterRenderingCallback:function(e,t,i){var s=i-1,a=0;e.each(function(){if(a===i){t.css("max-height",s);return}s+=jQuery(this).outerHeight();a++})}});e.extend("sap.ui.ux3.NotificationBar.MessageView",{metadata:{library:"sap.ui.ux3",properties:{text:"string",timestamp:"string",icon:"sap.ui.core.URI"}},renderer:function(e,t){var i=t.getId();e.write("<div");e.writeControlData(t);e.addClass("sapUiNotifierMessage");e.writeClasses();e.writeAttribute("tabindex","0");e.write(">");if(t.getIcon()){e.write("<div");e.writeAttribute("id",i+"-icon");e.addClass("sapUiNotifierMessageIcon");e.writeClasses();e.write(">");e.write("<img");e.writeAttributeEscaped("src",t.getIcon());e.write(">");e.write("</div>")}e.write("<div");e.writeAttribute("id",i+"-text");e.addClass("sapUiNotifierMessageText");e.writeClasses();e.write(">");e.writeEscaped(t.getText());e.write("</div>");e.write("<div");e.writeAttribute("id",i+"-timestamp");e.addClass("sapUiNotifierMessageTimestamp");e.writeClasses();e.write(">");e.writeEscaped(t.getTimestamp());e.write("</div>");e.write("</div>")},onclick:function(e){if(!this._message.getReadOnly()){var t=this._message.getParent();t.fireMessageSelected({message:this._message,notifier:t})}},onsapselect:function(e){this.onclick(e)},exit:function(e){if(this._message){delete this._message}}});var u=function(e){var t=e.hasItems();var i=e.getVisibleStatus();if(t&&i==="None"){return true}else if(!t&&i!=="None"){return true}else if(!t&&i!=="Min"){return true}else{return false}};var d=function(e,t){var i=t.getMessages().concat([]);if(i.length>0){i.sort(r.compareByType);var s=i.length-1;e._sSeverestMessageLevel=i[s].getLevel()}};var c=function(e){var t=e.getParameter("callout");switch(e.getParameter("type")){case"added":case"removed":var i=e.getParameter("notifier");if(this.getMessageNotifier()&&this.getMessageNotifier().getId()===i.getId()){d(this,this.getMessageNotifier())}if(u(this)){var s=this.hasItems();this.fireDisplay({show:s})}else{this.invalidate();if(e.getParameter("type")==="removed"){if(t.getContent().length>0){var a=t.getContent()[0];var r=e.getParameter("message");var o=a.getMessages();var n;for(var g=0;g<o.length;g++){n=o[g];if(r.getId()===n._message.getId()){n.destroy();t.rerender();t.adjustPosition();break}}}}}break;case"openCallout":t.destroyContent();var i=e.getParameter("notifier");i.destroyAggregation("views",true);var l=i.getId();var f=this.getMessageNotifier();if(f&&l===f.getId()){l+="-messageNotifierView"}else{l+="-messageView"}var c=new h.NotifierView(l,{title:i.getTitle(),visibleItems:this._visibleItems});if(i._bEnableMessageSelect){c.addStyleClass("sapUiNotifierSelectable")}var p=i.getMessages();for(var g=0;g<p.length;g++){var m=v(p[g],i,this);c.addMessage(m)}i.addAggregation("views",c,true);t.addContent(c);break}};h.HOVER_ITEM_HEIGHT=16;h.prototype.init=function(){this._oItemNavigation=new t;this._oItemNavigation.setCycling(true);this.addDelegate(this._oItemNavigation);this._iCalloutWidth=parseInt(250);this._iCalloutHeight=parseInt(200);this._visibleItems=5;this._eventListener=jQuery.proxy(c,this);this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._togglerPosition="50%";this._gapMessageArea="5";this._sSeverestMessageLevel=l.None;jQuery(window).on("resize",jQuery.proxy(C,this));this._proxyEnableMessageSelect=jQuery.proxy(M,this);this.data("sap-ui-fastnavgroup","true",true);this.setAlwaysShowToggler(false)};h.prototype.exit=function(){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;delete this._iCalloutWidth;delete this._iCalloutHeight;delete this._visibleItems;delete this._eventListener;if(this.getMessageNotifier()){var e=this.getMessageNotifier();e._oMessageArea.destroy();delete e._oMessageArea}delete this._resizeFrom;delete this._resizeTo;delete this._oResBundle;delete this._formerVisibleStatus;delete this._togglerPosition;delete this._gapMessageArea;delete this._isHovered;delete this._togglerClicked;delete this._sSeverestMessageLevel;jQuery(window).off("resize",C);delete this._proxyEnableMessageSelect};var v=function(e,t,i){var s=new h.MessageView(t.getId()+"-messageView-"+e.getId(),{text:e.getText(),timestamp:e.getTimestamp()});s._message=e;if(t.sParentAggregationName=="messageNotifier"){if(i.getVisibleStatus()==f.Max){s.setIcon(e.getIcon()||e.getDefaultIcon("32x32"))}else{s.setIcon(e.getIcon()||e.getDefaultIcon())}}else{s.setIcon(e.getIcon())}return s};var p=function(e,t){t.attachEvent("_childControlCalling",e._eventListener,e)};var m=function(e,t){t.detachEvent("_childControlCalling",e._eventListener,e)};h.prototype.addNotifier=function(e){if(e){var t=this.getVisibleStatus()==f.None?true:false;this.addAggregation("notifiers",e,t);p(this,e)}return this};h.prototype.insertNotifier=function(e,t){if(e){this.insertAggregation("notifiers",e,t);p(this,e)}return this};h.prototype.removeNotifier=function(e){var t=this.removeAggregation("notifiers",e);m(this,t);return t};h.prototype.removeAllNotifiers=function(){var e=this.removeAllAggregation("notifiers");for(var t=0;t<e.length;t++){var i=e[t];m(this,i)}return e};h.prototype.destroyNotifiers=function(){var e=this.getNotifiers();for(var t=0;t<e.length;t++){var i=e[t];m(this,i)}this.destroyAggregation("notifiers");return this};var M=function(e){var t=this.getMessageNotifier();if(t&&t.getId()===e.getParameter("notifier").getId()){t.invalidate()}};h.prototype.setMessageNotifier=function(e){var t=this.getMessageNotifier();if(t){t._oMessageArea.destroy();delete t._oMessageArea;t.detachEvent("_enableMessageSelect",this._proxyEnableMessageSelect);m(this,t)}this.setAggregation("messageNotifier",e);if(e){e._oMessageArea=new h.MessageView(this.getId()+"-inplaceMessage");e._oMessageArea.setParent(e);e.attachEvent("_enableMessageSelect",this._proxyEnableMessageSelect);p(this,e)}return this};h.prototype.destroyMessageNotifier=function(e){var t=this.getMessageNotifier();if(t){t._oMessageArea.destroy();delete t._oMessageArea;t.detachEvent("_enableMessageSelect",this._proxyEnableMessageSelect);m(this,t)}this.destroyAggregation("messageNotifier");return this};var N=function(e,t){var i=e.$();switch(t){case f.Min:i.addClass("sapUiNotificationBarMinimized");break;case f.Max:var s=e.getHeightOfStatus(e.getVisibleStatus());i.addClass("sapUiNotificationBarMaximized");i.css("height",s);var a=e.$("containers");a.css("max-height",s);break;case f.None:if(!e._resizeTo){i.css("display","none")}break;case f.Default:default:i.removeClass("sapUiNotificationBarMaximized");i.removeClass("sapUiNotificationBarMinimized");break}};var _=function(e){if(S(e)){var t=e.getHeightOfStatus(e._resizeFrom);var i=e.$();i.css("height",t);var s=e.getHeightOfStatus(e._resizeTo);i.stop(true,true).animate({height:s},"fast",function(){var t=e.getVisibleStatus();if(t==="None"){i.css("display","none");if(e.hasItems()){if(e.getMessageNotifier()){var s=e.getMessageNotifier();s.$().css("display","none")}if(e.getNotifiers().length>0){var a=e.getNotifiers();for(var r=0;r<a.length;r++){a[r].$().css("display","none")}}}}N(e,t);x(e,t)})}else{var a=e.getVisibleStatus();N(e,a)}delete e._resizeFrom;delete e._resizeTo};var w=function(e){if(e.getMessageNotifier()&&e.getMessageNotifier().hasItems()){var t;var i=e.getId()+"-notifiers";var s=jQuery(document.getElementById(i));if(s.length>0){var a=parseInt(s.width());var r=s.children();for(var o=0;o<r.length;o++){var n=jQuery(r[o]);if(n.hasClass("sapUiNotifier")){a-=n.width()}else if(n.hasClass("sapUiNotifierSeparator")){a-=n.width()}else if(n.hasClass("sapUiInPlaceMessage")){t=n}}if(t){a-=e._gapMessageArea+2;t.css("width",a+"px")}}}};h.prototype.onAfterRendering=function(){this._oItemNavigation.setRootDomRef(this.getDomRef());var e=[];var t=this.getVisibleStatus()===f.Max;if(t){var i=this.getMessageNotifier();if(i!=null){var s=i.getMessages();var a=i.getId()+"-messageNotifierView-messageView-";for(var r=s.length-1;r>=0;r--){var o=document.getElementById(a+s[r].getId());if(o){e.push(o)}}}var g=this.getNotifiers();for(var r=0;r<g.length;r++){var s=g[r].getMessages();var a=g[r].getId()+"-notifierView-messageView-";for(var l=s.length-1;l>=0;l--){var o=document.getElementById(a+s[l].getId());if(o){e.push(o)}}}}else{var g=this.getNotifiers();for(var r=0;r<g.length;r++){var o=g[r].getDomRef();if(o){e.push(o)}}var i=this.getMessageNotifier();if(i!=null){var o=i.getDomRef();if(o){e.push(o)}o=this.getDomRef("inplaceMessage");if(o&&jQuery(o).hasClass("sapUiInPlaceMessageSelectable")){e.push(o)}}}this._oItemNavigation.setItemDomRefs(e);_(this);w(this);b(this,this.getMessageNotifier());y(this);if(n.browser.mobile){var h=this.$("toggler");if(this.getVisibleStatus()!==f.None){h.css("display","block")}else{h.css("display","none")}}};var b=function(e,t){if(t&&t.hasItems()){var i=t.$("counter");i.removeClass("sapUiMessageInformation");i.removeClass("sapUiMessageSuccess");i.removeClass("sapUiMessageWarning");i.removeClass("sapUiMessageError");d(e,t);var s=e._sSeverestMessageLevel;i.addClass("sapUiMessage"+s);var a=t.getMessages().length;var r="NOTIBAR_MESSAGE_NOTIFIER_DESC_LEVEL_"+s.toUpperCase()+(a===1?"_SING":"_PL");I(e,t,r,a)}};var y=function(e){var t=e.getNotifiers();for(var i=0;i<t.length;i++){var s=t[i].getMessages().length;var a="NOTIBAR_NOTIFIER_COUNT_TEXT_"+(s===1?"SING":"PL");I(e,t[i],a,s)}};var I=function(e,t,i,s){var a=t.$("description");var r=e._oResBundle.getText(i,[s]);a.html(r)};var C=function(e){w(this)};var S=function(e){if(e._resizeFrom&&e._resizeTo){if(e._resizeFrom!=e._resizeTo){return true}}return false};h.prototype.hasItems=function(){var e=this.getNotifiers();if(e.length>0){for(var t=0;t<e.length;t++){var i=e[t];if(i.hasItems()){return true}}}if(this.getMessageNotifier()){if(this.getMessageNotifier().hasItems()){return true}}return false};var x=function(e,t){var i="none";var s=e.$();switch(t){case f.Max:case f.None:break;case f.Min:s.stop().animate({height:e.getHeightOfStatus(t)},{duration:"fast",queue:true});s.addClass("sapUiNotificationBarMinimized");e.$("notifiers").css("display","none");i="block";break;case f.Default:default:s.stop().animate({height:e.getHeightOfStatus(t)},{duration:"fast",queue:true});s.removeClass("sapUiNotificationBarMaximized");s.removeClass("sapUiNotificationBarMinimized");break}var a=e.$("hoverItem");a.css("display",i)};h.prototype.onfocusin=function(e){if(this._togglerClicked){delete this._togglerClicked;e.stopImmediatePropagation(true)}};h.prototype.onclick=function(e){this._togglerClicked=true;this.$().trigger("blur");var t=jQuery(document.activeElement);V(this);var i=e.target.id;var s=i.split("-");if(s){var a=this.getVisibleStatus();var r=s.length-1;switch(s[r]){case"ArrowUp":if(a==="Min"){this.setVisibleStatus("Default")}else{this.setVisibleStatus("Max")}break;case"ArrowDown":if(a==="Max"){this.setVisibleStatus("Default")}else{this.setVisibleStatus("Min")}e.preventDefault();break;case"BarUp":if(this._formerVisibleStatus){this.setVisibleStatus(this._formerVisibleStatus)}else{this.setVisibleStatus("Default")}break;case"BarDown":this._formerVisibleStatus=a;this.setVisibleStatus("Min");t.trigger("blur");break;default:if(t.hasClass("sapUiNotifier")){t.trigger("focus")}else{if(this.hasItems()){var o=this.getNotifiers();if(o.length>0){var n=jQuery(o[0]);n.trigger("focus")}else{var g=this.getMessageNotifier();if(g){jQuery(g).trigger("focus")}}}}break}}};h.prototype.onThemeChanged=function(e){if(this.getDomRef()){this.invalidate()}};var V=function(e){var t=e.getNotifiers();for(var i=0;i<t.length;i++){var s=t[i];s._oCallout.close()}if(e.getMessageNotifier()){e.getMessageNotifier()._oCallout.close()}};h.prototype.getHeightOfStatus=function(e){if(e==f.None){return"0px"}var t=Object.assign({sapUiNotificationBarHeightMinimized:"0px",sapUiNotificationBarHeight:"40px",sapUiNotificationBarHeightMaximized:"40%"},i.get({name:["sapUiNotificationBarHeightMinimized","sapUiNotificationBarHeight","sapUiNotificationBarHeightMaximized"],callback:this.invalidate.bind(this)}));switch(e){case f.Min:return t["sapUiNotificationBarHeightMinimized"];case f.Max:return this.calculateStatusHeightMax(t["sapUiNotificationBarHeightMaximized"]);case f.Default:default:return t["sapUiNotificationBarHeight"]}};h.prototype.calculateStatusHeightMax=function(e){var t=e.indexOf("%");if(t!==-1){var i=parseInt(e),s=jQuery(window).height();s=parseInt(s/100*i);var a=parseInt(this.getHeightOfStatus(f.Default));if(s<a){s=a+1}}else{g.warning("No valid percantage value given for maximized size. 400px is used");s=400}return s+"px"};h.prototype.setVisibleStatus=function(e){this._resizeFrom=this.getVisibleStatus();this._resizeTo=e;if(this._resizeFrom!==this._resizeTo){if(e===f.None){V(this);if(this.getDomRef()){x(this,e)}else{this.$().css({height:"0px",display:"none"})}}this.setProperty("visibleStatus",e);this.fireResize({status:e})}return this};h.prototype.setAlwaysShowToggler=function(e){if(n.browser.mobile){e=true}this.setProperty("alwaysShowToggler",e,true);var t=this.$("toggler");if(e){t.css("display","block")}else{t.css("display","none")}return this};return h});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/NotificationBarRenderer", ["sap/ui/thirdparty/jquery","sap/ui/core/Icon","sap/ui/ux3/library"],function(jQuery,e,i){"use strict";var t=i.NotificationBarStatus;var a;var s={};s.render=function(e,i){a=a||sap.ui.require("sap/ui/ux3/NotificationBar");r(e,i);o(e,i);f(e,i)};var r=function(e,i){e.write("<div");e.writeControlData(i);if(i.getVisibleStatus()===t.None){if(i.$().length>0){if(i._resizeFrom){i.$().stop().animate({height:0},"fast",function(){i.$().css("display","none");e.addStyle("display","none");e.writeAttribute("aria-hidden","true")})}else{e.addStyle("display","none");e.writeAttribute("aria-hidden","true")}}else{e.addStyle("display","none");e.writeAttribute("aria-hidden","true")}}else{e.writeAttribute("aria-hidden","false");e.addStyle("display","block")}e.writeStyles();e.addClass("sapUiNotificationBar");if(i._resizeTo){if(i._resizeFrom==t.Max){if(i._resizeTo==t.Default){e.addClass("sapUiNotificationBarMaximized")}}}e.writeClasses();e.write(">");n(e,i)};var d=function(e,i){var t=i.getVisibleStatus();if(t!=="None"){var a=i.getId()+"-toggler";e.write("<div");e.writeAttribute("id",a);e.addClass("sapUiBarToggle");if(t!=="Min"){e.addClass("sapUiBarToggleWide")}e.writeClasses();if(i.getAlwaysShowToggler()){e.addStyle("display","block");e.writeStyles()}e.write(">");l(e,i,"ArrowUp");l(e,i,"ArrowDown");l(e,i,"BarUp");l(e,i,"BarDown");e.write("</div>")}else{e.addStyle("display","none");e.writeStyles()}};var l=function(e,i,t){e.write("<div");var a=i.getId()+"-"+t;e.writeAttribute("id",a);var s=i.getVisibleStatus();var r=true;var d="";switch(t){case"ArrowUp":if(s==="Default"){r=false}d=i._oResBundle.getText("NOTIBAR_TITLE_ENLARGE");break;case"ArrowDown":if(s==="Max"){r=false}d=i._oResBundle.getText("NOTIBAR_TITLE_MINIMIZE");break;case"BarUp":if(s==="Min"){r=false}d=i._oResBundle.getText("NOTIBAR_TITLE_BAR_UP");break;case"BarDown":if(s==="Max"||s==="Default"){r=false}d=i._oResBundle.getText("NOTIBAR_TITLE_BAR_DOWN");break}e.writeAttributeEscaped("title",d);if(r){e.addClass("sapUiBarToggleHide")}e.addClass("sapUiBarToggle"+t);e.addClass("sapUiBarToggleItem");e.writeClasses();e.write(">");e.write("</div>")};var n=function(e,i){e.write("<div");var t=i.getId()+"-hoverItem";e.writeAttribute("id",""+t);var s=i.getVisibleStatus();if(s==="Min"){e.addStyle("top","-"+a.HOVER_ITEM_HEIGHT+"px");e.addStyle("display","block")}else{e.addStyle("display","none")}if(i.getDomRef()){var r=jQuery(i.getDomRef());var d=r.width()+"px";e.addStyle("width",d)}e.writeStyles();e.addClass("sapUiNotiHover");e.writeClasses();e.write(">");e.write("</div>")};var o=function(e,i){if(i.getResizeEnabled()){d(e,i)}if(i.hasItems()){if(i.getVisibleStatus()==t.Max){g(e,i)}else{w(e,i)}}};var g=function(e,i){var t=i.getNotifiers();var a=i.getMessageNotifier();var s="";e.write("<div");e.writeAttribute("id",i.getId()+"-containers");e.addClass("sapUiNotifierContainers");e.writeClasses();e.write(">");if(a&&a.hasItems()){a.destroyAggregation("views",true);s=a.getId()+"-messageNotifierView";var r=v(s,a);a.addAggregation("views",r,true);e.renderControl(r)}if(t.length>0){for(var d=0;d<t.length;d++){if(t[d].hasItems()){t[d].destroyAggregation("views",true);s=t[d].getId()+"-notifierView";var l=v(s,t[d]);t[d].addAggregation("views",l,true);e.renderControl(l)}}}e.write("</div")};var w=function(e,i){var t=i.getNotifiers();var a=i.getMessageNotifier();e.write("<ul");e.writeAttribute("id",i.getId()+"-notifiers");e.addClass("sapUiNotifiers");e.writeClasses();e.write(">");var s=false;for(var r=0;r<t.length;r++){if(t[r].hasItems()){s=true;break}}var d=a&&a.hasItems()?true:false;if(s){p(e,t)}if(s&&d){e.write("<li");e.addClass("sapUiNotifierSeparator");e.writeClasses();e.write(">");e.write("&nbsp;");e.write("</li>")}if(d){I(e,a,i)}e.write("</ul>")};var f=function(e,i){e.write("</div>")};var u=function(e,i,t){var a=i.getId();e.write("<li");e.writeElementData(i);e.addClass("sapUiNotifier");e.writeClasses();e.writeAttribute("tabindex","-1");e.writeAttribute("aria-describedby",a+"-description>");e.write(">");c(e,i.getIcon(),t);e.write('<div id="'+a+'-description"');e.addStyle("display","none");e.writeStyles();e.write(">");e.write("</div>");var s=i.getMessages().length;if(s>0){e.write('<div id="'+a+'-counter" role="tooltip"');e.addClass("sapUiNotifierMessageCount");if(t){e.addClass("sapUiMessage")}e.writeClasses();e.write(">");if(s>99){s=">99"}e.write(s);e.write("</div>")}e.write("</li>")};var v=function(e,i){var t=new a.NotifierView(e,{title:i.getTitle(),renderMode:"maximized"});if(i._bEnableMessageSelect){t.addStyleClass("sapUiNotifierSelectable")}var s=i.getMessages();for(var r=0;r<s.length;r++){var d=s[r];var l=new a.MessageView(e+"-messageView-"+d.getId(),{text:d.getText(),timestamp:d.getTimestamp()});l._message=d;l.setIcon(d.getIcon()||d.getDefaultIcon("32x32"));t.addMessage(l)}return t};var p=function(e,i){for(var t=0;t<i.length;t++){u(e,i[t],false)}};var c=function(i,t,a){if(t==null||t==""){var s=new e({useIconTooltip:false});s.addStyleClass("sapUiNotifierIcon");if(a){s.setSrc("sap-icon://alert")}else{s.setSrc("sap-icon://notification-2")}i.renderControl(s);return}i.write('<img alt=""');i.addClass("sapUiNotifierIcon");i.writeClasses();i.writeAttributeEscaped("src",t);i.write(">")};var I=function(e,i,t){u(e,i,true);C(e,i,t)};var C=function(e,i,t){if(i.hasItems()){var a=i.getMessages();var s=a[a.length-1];var r=i._oMessageArea;r._message=s;var d=t.getId()+"-inplaceMessage-"+r._message.getId();e.write("<li");e.writeAttribute("id",d);e.addClass("sapUiInPlaceMessage");e.writeClasses();if(t._gapMessageArea){var l=t._gapMessageArea+"px";e.addStyle("margin-left",l);e.writeStyles()}e.write(">");if(s.getText()!=""){e.write("<div");e.writeControlData(r);e.writeAttribute("tabindex","-1");e.addClass("sapUiNotifierMessageText");e.addClass("sapUiInPlaceMessage");if(i._bEnableMessageSelect&&!r._message.getReadOnly()){e.addClass("sapUiInPlaceMessageSelectable")}e.writeClasses();e.write(">");e.writeEscaped(s.getText());e.write("</div>")}if(s.getTimestamp()!=""){e.write("<div");e.addClass("sapUiNotifierMessageTimestamp");e.addClass("sapUiInPlaceMessage");e.writeClasses();e.write(">");e.writeEscaped(s.getTimestamp());e.write("</div>")}e.write("</li>")}};return s},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/Notifier", ["sap/ui/thirdparty/jquery","sap/ui/commons/Callout","sap/ui/core/Element","./library","sap/ui/core/library","sap/ui/Device","sap/base/Log","sap/ui/base/EventProvider","sap/ui/core/Configuration"],function(jQuery,e,t,s,i,o,a,r,n){"use strict";var l=i.MessageType;var u=t.extend("sap.ui.ux3.Notifier",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},title:{type:"string",group:"Misc",defaultValue:null}},aggregations:{messages:{type:"sap.ui.core.Message",multiple:true,singularName:"message"},views:{type:"sap.ui.core.Control",multiple:true,singularName:"view",visibility:"hidden"}},events:{messageSelected:{parameters:{message:{type:"sap.ui.core.Message"},notifier:{type:"sap.ui.ux3.Notifier"}}}}}});var p=function(){this.fireEvent("_childControlCalling",{type:"openCallout",callout:this._oCallout,notifier:this})};var g=function(e){if(e.getSource()){e.getSource().destroyContent()}if(this._oCallout){this._oCallout.$().css("display","none")}};u.prototype.hasItems=function(){if(this.getMessages().length>0){return true}return false};u.prototype.init=function(){this._oCallout=new e(this.getId()+"-callout",{beforeOpen:jQuery.proxy(p,this),open:function(e){this.$().css({position:"fixed",display:"block"})},close:jQuery.proxy(g,this),collision:"none"});this._oCallout.addStyleClass("sapUiNotifierCallout");if(o.browser.mobile){this._oCallout.setOpenDelay(0)}this._oCallout.setMyPosition("begin bottom");this._oCallout.setAtPosition("begin top");this._oCallout.setTip=function(){e.prototype.setTip.apply(this,arguments);var t=this.$("arrow");t.css("bottom","-24px");var s=n.getRTL();if(!s){t.css("left","6px")}};this.setTooltip(this._oCallout);this.setTooltip=function(){a.warning("Setting toolstips for notifiers deactivated");return this};this._proxyEnableMessageSelect=jQuery.proxy(h,this);this.attachEvent(r.M_EVENTS.EventHandlerChange,this._proxyEnableMessageSelect)};var h=function(e){var t=e.getParameter("EventId");if(t==="messageSelected"){if(e.getParameter("type")==="listenerAttached"){this._bEnableMessageSelect=true}else if(e.getParameter("type")==="listenerDetached"){this._bEnableMessageSelect=false}this.fireEvent("_enableMessageSelect",{enabled:this._bEnableMessageSelect,notifier:this})}};u.prototype.exit=function(e){this._oCallout=undefined;if(this._oMessageView){this._oMessageView.destroy();delete this._oMessageView}this.detachEvent(r.M_EVENTS.EventHandlerChange,this._proxyEnableMessageSelect);delete this._proxyEnableMessageSelect};u.prototype.onclick=function(e){e.preventDefault();this.$().trigger("mouseover")};var c=function(e,t,s){var i=t?t.getLevel():l.None;s.fireEvent("_childControlCalling",{type:e,notifier:s,level:i,message:t,callout:s._oCallout})};u.prototype.addMessage=function(e){this.addAggregation("messages",e);c("added",e,this);return this};u.prototype.insertMessage=function(e,t){this.insertAggregation("messages",e,t);c("added",e,this);return this};u.prototype.removeMessage=function(e){var t=this.removeAggregation("messages",e);if(t){c("removed",t,this)}return t};u.prototype.removeAllMessages=function(){var e=this.removeAllAggregation("messages");if(e.length>0){c("removed",null,this)}return e};u.prototype.destroyMessages=function(){var e=this.getMessages().length;this.destroyAggregation("messages");if(e>0){c("removed",null,this)}return this};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/Overlay", ["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/Popup","./library","./OverlayRenderer","sap/ui/core/library","sap/ui/dom/jquery/control","sap/ui/dom/jquery/Focusable"],function(jQuery,t,e,o,i,s){"use strict";var n=s.OpenState;var r=t.extend("sap.ui.ux3.Overlay",{metadata:{deprecated:true,interfaces:["sap.ui.core.PopupInterface"],library:"sap.ui.ux3",properties:{openButtonVisible:{type:"boolean",group:"Misc",defaultValue:true},closeButtonVisible:{type:"boolean",group:"Misc",defaultValue:true}},events:{close:{allowPreventDefault:true,parameters:{id:{type:"string"}}},closed:{allowPreventDefault:true,parameters:{id:{type:"string"}}},openNew:{parameters:{id:{type:"string"}}},open:{parameters:{id:{type:"string"}}}}}});r.prototype.init=function(){var t=this;this._oPopup=new e(this,false,true);this._oPopup.attachOpened(function(e){var o=jQuery(document.getElementById(t._initialFocusId))[0];if(!o&&t._getShell()&&t.getOpenButtonVisible()){o=document.getElementById(t._getOpenButtonId())}else if(!o&&t._getShell()&&t.getCloseButtonVisible()){o=document.getElementById(t._getCloseButtonId())}else if(!o){o=t.$("content").firstFocusableDomRef()}if(!o){o=t.$().firstFocusableDomRef()}if(o){o.focus()}});this._oPopup.attachClosed(function(e){t.fireClosed({id:t.getId()})});this._overridePopupEventing()};r.prototype._overridePopupEventing=function(){this._oPopup.onmousedown=function(t){return}};r.prototype._getShell=function(){var t=jQuery(".sapUiUx3Shell").control();if(t.length>0&&!this._oShell){this._oShell=t.length?t[0]:null}return this._oShell};r.prototype._getCloseButtonId=function(){return this.getId()+"-close"};r.prototype._getOpenButtonId=function(){return this.getId()+"-openNew"};r.prototype._initDom=function(t,e,o){var i=jQuery(".sapUiUx3Shell").control();this._oShell=i.length?i[0]:null;i=this._oShell;this.$().css("position","fixed");if(i){this._bFocusEventsRegistered=true;i.syncWithCanvasSize(this.getId(),true,t,e,o);this.$("firstFocusDummyPaneFw").attr("tabindex","0").on("focusin",jQuery.proxy(i.focusFirstHdr,i));this.$("firstFocusDummyPaneBw").attr("tabindex","0").on("focusin",jQuery.proxy(i.focusLastTool,i));this.$("LastFocusDummyPane").attr("tabindex","0").on("focusin",jQuery.proxy(i.focusPaneStart,i))}else{this.$().css("bottom","0").css("top","0").css("left","0").css("right","0")}};r.prototype._cleanupDom=function(){if(this._oShell){this._oShell.syncWithCanvasSize(this.getId(),false)}if(this._bFocusEventsRegistered){this._bFocusEventsRegistered=false;this.$("firstFocusDummyPaneFw").removeAttr("tabindex").off("focusin");this.$("firstFocusDummyPaneBw").removeAttr("tabindex").off("focusin");this.$("LastFocusDummyPane").removeAttr("tabindex").off("focusin")}};r.prototype.onAfterRendering=function(){var t=this._oPopup.getOpenState();if(t===n.OPEN||t===n.OPENING){this._initDom(jQuery.proxy(this._setFocusFirst,this),jQuery.proxy(this._setFocusLast,this),jQuery.proxy(this._applyChanges,this))}};r.prototype.onBeforeRendering=function(){};r.prototype.exit=function(){this.close();this._oPopup.destroy();this._oPopup=null;this._oShell=null};r.prototype.open=function(t){this._initialFocusId=t;if(this._oPopup.isOpen()){return}if(t){this._oPopup.setInitialFocusId(t)}this._oPreviousFocus=e.getCurrentFocusInfo();this._oPopup.open(400);this._initDom(jQuery.proxy(this._setFocusFirst,this),jQuery.proxy(this._setFocusLast,this),jQuery.proxy(this._applyChanges,this));this.fireOpen({id:this.getId()})};r.prototype.close=function(){if(!this._oPopup.isOpen()){return}this._oPopup.close(400);setTimeout(this.restorePreviousFocus.bind(this),400);this._cleanupDom()};r.prototype.onclick=function(t){this._handleButtonEvent(t)};r.prototype.onsapselect=function(t){this._handleButtonEvent(t)};r.prototype._handleButtonEvent=function(t){var e=t.target.id;if(e===this._getCloseButtonId()){if(this.fireClose({id:this.getId()})){this.close()}}else if(e===this._getOpenButtonId()){this.fireOpenNew({id:this.getId()})}};r.prototype._getText=function(t,e){var o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");var i;if(o){i=o.getText(t)}if(i&&e){for(var s=0;s<e.length;s++){i=i.replace("{"+s+"}",e[s])}}return i?i:t};r.prototype._setFocusFirst=function(){var t=document.getElementById(this._getOpenButtonId());if(t){t.focus()}};r.prototype._setFocusLast=function(){var t=document.getElementById(this._getCloseButtonId());if(t){t.focus()}};r.prototype._applyChanges=function(t){return this};r.prototype.isOpen=function(){return this._oPopup.isOpen()};r.prototype.restorePreviousFocus=function(){e.applyFocusInfo(this._oPreviousFocus)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/OverlayContainer", ["./Overlay","./library","./OverlayContainerRenderer","sap/ui/dom/jquery/Focusable"],function(e,t,o){"use strict";var s=e.extend("sap.ui.ux3.OverlayContainer",{metadata:{deprecated:true,library:"sap.ui.ux3",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});s.prototype._setFocusLast=function(){var e=this.$("content").lastFocusableDomRef();if(!e&&this.getCloseButtonVisible()){e=this.getDomRef("close")}else if(!e&&this.getOpenButtonVisible()){e=this.getDomRef("openNew")}if(e){e.focus()}};s.prototype._setFocusFirst=function(){if(this.getOpenButtonVisible()){if(this.getDomRef("openNew")){this.getDomRef("openNew").focus()}}else if(this.getCloseButtonVisible()){if(this.getDomRef("close")){this.getDomRef("close").focus()}}else{if(this.$("content").firstFocusableDomRef()){this.$("content").firstFocusableDomRef().focus()}}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/OverlayContainerRenderer", ["sap/ui/core/Renderer","./OverlayRenderer"],function(e,n){"use strict";var r=e.extend(n);r.renderContent=function(e,n){e.write("<div role='Main' class='sapUiUx3OCContent' id='"+n.getId()+"-content'>");var r=n.getContent();for(var t=0;t<r.length;t++){var a=r[t];e.renderControl(a)}e.write("</div>")};r.addRootClasses=function(e,n){e.addClass("sapUiUx3OC")};r.addOverlayClasses=function(e,n){e.addClass("sapUiUx3OCOverlay")};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/OverlayDialog", ["sap/ui/core/IntervalTrigger","./Overlay","./library","./OverlayDialogRenderer","sap/base/Log","sap/ui/dom/jquery/Focusable"],function(t,e,i,s,o){"use strict";var n=e.extend("sap.ui.ux3.OverlayDialog",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});n.prototype.init=function(){e.prototype.init.apply(this);this.setProperty("openButtonVisible",false);n.Trigger=new t(300)};n.prototype._setFocusLast=function(){var t=this.$("content").lastFocusableDomRef();if(!t&&this.getCloseButtonVisible()){t=this.getDomRef("close")}if(t){t.focus()}};n.prototype._setFocusFirst=function(){var t;if(this.getCloseButtonVisible()){t=this.getDomRef("close")}else{t=this.$("content").firstFocusableDomRef()}if(t){t.focus()}};n.prototype.setOpenButtonVisible=function(t){o.warning("OverlayDialog does not support an openButton.");return this};n.prototype.setWidth=function(t){if(t=="auto"||t=="inherit"){t="auto"}return this.setProperty("width",t)};n.prototype.setHeight=function(t){if(t=="auto"||t=="inherit"){t="auto"}return this.setProperty("height",t)};n.prototype.onBeforeRendering=function(){e.prototype.onBeforeRendering.apply(this,arguments);this._cleanup()};n.prototype.onAfterRendering=function(){e.prototype.onAfterRendering.apply(this,arguments);n.Trigger.addListener(this._checkChange,this)};n.prototype._cleanup=function(){n.Trigger.removeListener(this._checkChange,this);this.contentWidth=null;this.contentHeight=null;this.overlayWidth=null;this.overlayHeight=null};n.prototype.exit=function(){this._cleanup();e.prototype.exit.apply(this,arguments)};n.prototype._checkChange=function(){if(!this.getDomRef()){return}var t=this.$("content"),e=this.$(),i=this.getWidth()==="auto",s=this.getHeight()==="auto";var o=i?Math.round(e.width()/2):t.width(),n=s?Math.round(e.height()/2):t.height(),h=e.width(),r=e.height();if(o!=this.contentWidth||n!=this.contentHeight||h!=this.overlayWidth||r!=this.overlayHeight){t.css("left","0").css("right","auto").css("top","0").css("bottom","auto").css("width",this.getWidth()).css("height",this.getHeight());this.contentWidth=o;this.contentHeight=n;this.overlayWidth=h;this.overlayHeight=r;var a=this.$("close");if(this.contentWidth<this.overlayWidth){t.css("left","50%");t.css("right","auto");t.css("margin-left",Math.round(-1*this.contentWidth/2)+"px");t.css("width",s?this.contentWidth:this.getWidth());a.css("right","50%");a.css("margin-right",Math.round(-1*this.contentWidth/2-10)+"px")}else{t.css("left","0");t.css("right","10px");t.css("margin-left","0");t.css("width","auto");a.css("right","0");a.css("margin-right","0")}if(this.contentHeight<this.overlayHeight-30){t.css("top","50%");t.css("bottom","auto");t.css("margin-top",Math.round(-1*this.contentHeight/2)+"px");t.css("height",s?this.contentHeight:this.getHeight());a.css("top","50%");a.css("margin-top",Math.round(-1*this.contentHeight/2-10)+"px")}else{t.css("top","10px");t.css("bottom","30px");t.css("margin-top","0");t.css("height","auto");a.css("top","0");a.css("margin-top","0")}}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/OverlayDialogRenderer", ["sap/ui/core/Renderer","./OverlayRenderer"],function(e,n){"use strict";var r=e.extend(n);r.renderContent=function(e,n){e.write("<div role='Main' class='sapUiUx3ODContent' id='"+n.getId()+"-content'>");var r=n.getContent();for(var t=0;t<r.length;t++){var a=r[t];e.renderControl(a)}e.write("</div>")};r.addRootClasses=function(e,n){e.addClass("sapUiUx3OD")};r.addOverlayClasses=function(e,n){e.addClass("sapUiUx3ODOverlay")};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/OverlayRenderer", [],function(){"use strict";var e={};e.render=function(e,s){e.write("<div");e.writeControlData(s);e.addClass("sapUiUx3Overlay");if(this.addRootClasses){this.addRootClasses(e,s)}e.writeClasses();e.write(">");e.write("<div role='presentation'");e.addClass("sapUiUx3OverlayOverlay");if(this.addOverlayClasses){this.addOverlayClasses(e,s)}e.writeClasses();e.write(">");e.write("</div>");e.write("<span class='sapUiUx3OverlayFocusDummyPane' id='"+s.getId()+"-firstFocusDummyPaneFw'></span>");e.write("<span class='sapUiUx3OverlayFocusDummyPane' id='"+s.getId()+"-firstFocusDummyPaneBw'></span>");if(s.getOpenButtonVisible()){e.write('<a role="button" aria-disabled="false" class=\'sapUiUx3OverlayOpenButton\' id=\''+s.getId()+'-openNew\' tabindex="0" title="'+s._getText("OVERLAY_OPEN_BUTTON_TOOLTIP")+'">'+s._getText("OVERLAY_OPEN_BUTTON_TEXT")+"</a>")}if(s.getCloseButtonVisible()){e.write('<a role="button" aria-disabled="false" class=\'sapUiUx3OverlayCloseButton\' id=\''+s.getId()+"-close' tabindex=\"0\" aria-label='"+s._getText("OVERLAY_CLOSE_BUTTON_TOOLTIP")+"'></a>")}if(this.renderContent){this.renderContent(e,s)}e.write("<span class='sapUiUx3OverlayFocusDummyPane' id='"+s.getId()+"-LastFocusDummyPane'></span>");e.write("</div>")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/QuickView", ["sap/ui/thirdparty/jquery","sap/ui/commons/CalloutBase","sap/ui/core/delegate/ItemNavigation","./ActionBar","./library","./QuickViewRenderer","sap/ui/core/TooltipBase"],function(jQuery,t,e,i,o,n,a){"use strict";var r=o.FollowActionState;var s=t.extend("sap.ui.ux3.QuickView",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{type:{type:"string",group:"Misc",defaultValue:null},firstTitle:{type:"string",group:"Misc",defaultValue:null},firstTitleHref:{type:"string",group:"Misc",defaultValue:null},secondTitle:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showActionBar:{type:"boolean",group:"Misc",defaultValue:true},followState:{type:"sap.ui.ux3.FollowActionState",group:"Misc",defaultValue:r.Default},flagState:{type:"boolean",group:"Misc",defaultValue:false},favoriteState:{type:"boolean",group:"Misc",defaultValue:false},favoriteActionEnabled:{type:"boolean",group:"Misc",defaultValue:true},updateActionEnabled:{type:"boolean",group:"Misc",defaultValue:true},followActionEnabled:{type:"boolean",group:"Misc",defaultValue:true},flagActionEnabled:{type:"boolean",group:"Misc",defaultValue:true},openActionEnabled:{type:"boolean",group:"Misc",defaultValue:true}},aggregations:{content:{type:"sap.ui.core.Element",multiple:true,singularName:"content"},actions:{type:"sap.ui.ux3.ThingAction",multiple:true,singularName:"action"},actionBar:{type:"sap.ui.ux3.ActionBar",multiple:false}},events:{actionSelected:{parameters:{id:{type:"string"},action:{type:"sap.ui.ux3.ThingAction"},newState:{type:"string"}}},feedSubmit:{parameters:{text:{type:"string"}}},navigate:{allowPreventDefault:true,parameters:{href:{type:"string"}}}}}});s.prototype.init=function(){var e;function o(t){var e=t.getParameters();this.fireActionSelected(e)}function n(t){var e=t.getParameters();this.fireFeedSubmit(e)}t.prototype.init.call(this);if(!this.getActionBar()){e=new i;e.attachActionSelected(jQuery.proxy(o,this));e.attachFeedSubmit(jQuery.proxy(n,this));this.setAggregation("actionBar",e,true)}};s.prototype.onmouseover=function(t){var e=this._getPopup();if(e.isOpen()&&e.getContent()==this){if(this.sCloseNowTimeout){clearTimeout(this.sCloseNowTimeout);this.sCloseNowTimeout=null}return}a.prototype.onmouseover.call(this,t)};s.prototype.onAfterRendering=function(){var t=this.getDomRef(),i=[];var o=this.$("title");i.push(o);o=this.$("link");if(!o.length){o=this.$("name")}if(!o.length){return}i.push(o);o=this.$("descr");if(o.length){i.push(o)}if(!this.oItemNavigation){this.oItemNavigation=new e(null,null,false);this.addDelegate(this.oItemNavigation)}this.oItemNavigation.setRootDomRef(t);this.oItemNavigation.setItemDomRefs(i);this.oItemNavigation.setCycling(false);this.oItemNavigation.setSelectedIndex(1);this.oItemNavigation.setPageSize(i.length)};s.prototype.onclick=function(t){var e=t.target;if(!e||!e.hasAttribute("href")){return}if(!this.fireEvent("navigate",{href:e.href},true,false)){t.preventDefault()}};s.prototype.exit=function(){if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();delete this.oItemNavigation}};s.prototype.insertAction=function(t,e){if(this.getActionBar()){this.getActionBar().insertBusinessAction(t,e)}return this};s.prototype.addAction=function(t){if(this.getActionBar()){this.getActionBar().addBusinessAction(t)}return this};s.prototype.removeAction=function(t){if(this.getActionBar()){this.getActionBar().removeBusinessAction(t)}return this};s.prototype.removeAllActions=function(){if(this.getActionBar()){this.getActionBar().removeAllBusinessActions()}return this};s.prototype.getActions=function(){if(this.getActionBar()){this.getActionBar().getBusinessActions()}return this};s.prototype.destroyActions=function(){if(this.getActionBar()){this.getActionBar().destroyBusinessActions()}return this};s.prototype.setFollowState=function(t){if(this.getActionBar()){this.getActionBar().setFollowState(t)}return this};s.prototype.getFollowState=function(){var t=null;if(this.getActionBar()){t=this.getActionBar().getFollowState()}return t};s.prototype.setFlagState=function(t){if(this.getActionBar()){this.getActionBar().setFlagState(t)}return this};s.prototype.getFlagState=function(){var t=null;if(this.getActionBar()){t=this.getActionBar().getFlagState()}return t};s.prototype.setFavoriteState=function(t){if(this.getActionBar()){this.getActionBar().setFavoriteState(t)}return this};s.prototype.getFavoriteState=function(){var t=null;if(this.getActionBar()){t=this.getActionBar().getFavoriteState()}return t};s.prototype.setFavoriteActionEnabled=function(t){if(this.getActionBar()){this.getActionBar().setShowFavorite(t)}return this};s.prototype.getFavoriteActionEnabled=function(){var t;if(this.getActionBar()){t=this.getActionBar().getShowFavorite()}return t};s.prototype.setFlagActionEnabled=function(t){if(this.getActionBar()){this.getActionBar().setShowFlag(t)}return this};s.prototype.getFlagActionEnabled=function(){var t;if(this.getActionBar()){t=this.getActionBar().getShowFlag()}return t};s.prototype.setUpdateActionEnabled=function(t){if(this.getActionBar()){this.getActionBar().setShowUpdate(t)}return this};s.prototype.getUpdateActionEnabled=function(){var t;if(this.getActionBar()){t=this.getActionBar().getShowUpdate()}return t};s.prototype.setFollowActionEnabled=function(t){if(this.getActionBar()){this.getActionBar().setShowFollow(t)}return this};s.prototype.getFollowActionEnabled=function(){var t;if(this.getActionBar()){t=this.getActionBar().getShowFollow()}return t};s.prototype.setOpenActionEnabled=function(t){if(this.getActionBar()){this.getActionBar().setShowOpen(t)}return this};s.prototype.getOpenActionEnabled=function(){var t;if(this.getActionBar()){t=this.getActionBar().getShowOpen()}return t};s.prototype.setIcon=function(t){this.setProperty("icon",t);if(this.getActionBar()){this.getActionBar().setThingIconURI(t)}return this};s.prototype.setActionBar=function(t){this.setAggregation("actionBar",t,true);if(this.getIcon()&&this.getActionBar()){this.getActionBar().setThingIconURI(this.getIcon())}return this};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/QuickViewRenderer", ["sap/ui/commons/CalloutBaseRenderer","sap/ui/core/Renderer","sap/ui/core/IconPool","sap/ui/core/Configuration"],function(t,e,i,r){"use strict";var a=e.extend(t);a.renderContent=function(t,e){var a=r.getAccessibility();var s=e.getType(),n=e.getFirstTitle(),d=e.getFirstTitleHref(),o=e.getIcon(),w=e.getSecondTitle(),l=e.getWidth(),c=e.getId(),u=e.getTooltip_AsString(),f;t.write("<div");if(u){t.writeAttributeEscaped("title",u)}if(a){t.writeAttribute("role","dialog");t.writeAttribute("aria-labelledby",c+"-title")}t.addClass("sapUiUx3QV");t.writeClasses();if(l){t.addStyle("width",l);t.writeStyles()}t.write(">");t.write("<div");t.writeAttribute("id",c+"-title");t.writeAttribute("tabindex","-1");t.addClass("sapUiUx3QVHeader");t.writeClasses();t.write(">");t.writeEscaped(s);t.write("</div>");if(o||n||w){t.write("<div");if(a){t.writeAttribute("role","heading")}t.addClass("sapUiUx3QVHeading");t.writeClasses();t.write(">");if(o){if(i.isIconURI(o)){f={title:n,tabindex:"-1"}}t.writeIcon(o,"sapUiUx3QVIcon",f)}t.write("<span");t.writeAttribute("id",c+"-name");if(a&&w){t.writeAttribute("aria-describedby",c+"-descr")}t.addClass("sapUiUx3QVTitle1");t.writeClasses();t.write(">");if(d){t.write("<a");t.writeAttribute("id",c+"-link");t.writeAttributeEscaped("href",d);t.writeAttribute("tabindex","-1");t.write(">")}t.writeEscaped(n||"");if(d){t.write("</a>")}t.write("</span>");if(w){t.write("<br><span");t.writeAttribute("id",c+"-descr");t.writeAttribute("tabindex","-1");t.addClass("sapUiUx3QVTitle2");t.writeClasses();t.write(">");t.writeEscaped(w);t.write("</span>")}t.write("</div>")}t.write('<div id="'+c+'-content">');this.renderBody(t,e);t.write("</div>");t.write("</div>");if(e.getShowActionBar()&&e.getActionBar()){t.renderControl(e.getActionBar())}};a.renderBody=function(t,e){var i=e.getContent();for(var r=0;r<i.length;r++){t.write('<div class="sapUiUx3QVBody">');if(i[r]instanceof sap.ui.core.Control){t.renderControl(i[r])}else if(i[r].getContent&&typeof i[r].getContent=="function"){var a=i[r].getContent();for(var s=0;s<a.length;s++){if(a[s]instanceof sap.ui.core.Control){t.renderControl(a[s])}}}t.write("</div>")}};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/Shell", ["sap/ui/thirdparty/jquery","sap/ui/commons/Menu","sap/ui/core/Control","sap/ui/core/theming/Parameters","./library","./ShellRenderer","./ShellPersonalization","./NavigationBar","sap/ui/core/delegate/ItemNavigation","sap/ui/core/RenderManager","sap/ui/core/Popup","./ToolPopup","sap/ui/commons/SearchField","sap/ui/commons/Label","./Feeder","sap/ui/commons/library","sap/ui/commons/Button","sap/ui/commons/MenuItem","./NotificationBar","sap/ui/base/Object","sap/ui/Device","sap/base/Log","sap/base/assert","sap/ui/core/Configuration","sap/ui/dom/jquery/Focusable"],function(jQuery,e,t,s,i,o,a,r,n,l,h,p,d,c,u,f,g,_,y,m,v,I,S,T){"use strict";var P=i.NotificationBarStatus;var B=i.FeederType;var x=h.Dock;var R=i.ShellDesignType;var O=i.ShellHeaderType;var H=t.extend("sap.ui.ux3.Shell",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{appTitle:{type:"string",group:"Misc",defaultValue:null},appIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},appIconTooltip:{type:"string",group:"Misc",defaultValue:null},showLogoutButton:{type:"boolean",group:"Misc",defaultValue:true},logoutButtonTooltip:{type:"string",group:"Accessibility",defaultValue:null},showSearchTool:{type:"boolean",group:"Misc",defaultValue:true},showInspectorTool:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},showFeederTool:{type:"boolean",group:"Misc",defaultValue:true},showTools:{type:"boolean",group:"Misc",defaultValue:true},showPane:{type:"boolean",group:"Misc",defaultValue:true},headerType:{type:"sap.ui.ux3.ShellHeaderType",group:"Misc",defaultValue:O.Standard},designType:{type:"sap.ui.ux3.ShellDesignType",group:"Misc",defaultValue:R.Standard},paneWidth:{type:"int",group:"Misc",defaultValue:250},applyContentPadding:{type:"boolean",group:"Appearance",defaultValue:true},fullHeightContent:{type:"boolean",group:"Appearance",defaultValue:false},allowOverlayHeaderAccess:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"content",aggregations:{worksetItems:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"worksetItem"},paneBarItems:{type:"sap.ui.core.Item",multiple:true,singularName:"paneBarItem"},paneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"paneContent"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},toolPopups:{type:"sap.ui.ux3.ToolPopup",multiple:true,singularName:"toolPopup"},headerItems:{type:"sap.ui.core.Control",multiple:true,singularName:"headerItem"},notificationBar:{type:"sap.ui.ux3.NotificationBar",multiple:false},_paneOverflowMenu:{type:"sap.ui.commons.Menu",multiple:false,visibility:"hidden"}},associations:{selectedWorksetItem:{type:"sap.ui.ux3.NavigationItem",multiple:false}},events:{worksetItemSelected:{allowPreventDefault:true,parameters:{id:{type:"string"},item:{type:"sap.ui.ux3.NavigationItem"},key:{type:"string"}}},paneBarItemSelected:{parameters:{id:{type:"string"},item:{type:"sap.ui.core.Item"},key:{type:"string"}}},logout:{},search:{},feedSubmit:{},paneClosed:{parameters:{id:{type:"string"}}}}}});H.WSI_MENU_DELAY=200;H.WSI_OVERFLOW_SCROLL_STEP=250;H.TOOL_PREFIX="-tool-";H.FIRST_RENDERING=true;H.SIDE_BAR_BASE_WIDTH=null;H.PANE_OVERFLOW_BUTTON_HEIGHT=null;H.prototype.init=function(){this._iOpenPaneIndex=-1;this._sOpenWsiId=null;this._bPreviousScrollRight=false;this._bPreviousScrollLeft=false;this._sSelectedWorksetId=null;this._sSelectedFacetId=null;this._aSyncRefStack=[];this._mSyncRefs={};this._oWorksetBar=new r(this.getId()+"-wsBar",{toplevelVariant:true,select:[this._handleWorksetBarSelect,this]}).setParent(this);this._oFacetBar=new r(this.getId()+"-facetBar",{select:[this._handleFacetBarSelect,this]}).setParent(this);this.setAggregation("_paneOverflowMenu",new e);var t=this;this._checkResizeClosure=function(){t._checkResize()};this.currentToolPaletteWidth=0;this._updateThemeVariables()};H.prototype.exit=function(){if(this._oWorksetBar){this._oWorksetBar.destroy();delete this._oWorksetBar}if(this._oFacetBar){this._oFacetBar.destroy();delete this._oFacetBar}this._oSearchField=null;jQuery(window).off("resize",this._checkResizeClosure);clearTimeout(this._checkPaneBarOverflowDelayId);this._checkPaneBarOverflowDelayId=null};H.prototype.onBeforeRendering=function(){this._beforeRenderingToolPalette();this.$("focusDummyPane").off("focusin");if(window.FileReader){var e=this.$("hdr");e.off("dragover",this._handleDragover).off("dragend",this._handleDragend).off("drop",this._handleDrop);var t=this.$("bgImg");t.off("dragover",jQuery.proxy(this._handleDragover)).off("dragend",this._handleDragend).off("drop",this._handleDrop)}};H.prototype.onAfterRendering=function(){this._afterRenderingToolPalette();if(this._topSyncRefId&&this._mSyncRefs[this._topSyncRefId].focusLast){this.$("focusDummyPane").on("focusin",this._mSyncRefs[this._topSyncRefId].focusLast)}if(window.FileReader){var e=this.$("hdr");e.on("dragover",jQuery.proxy(this._handleDragover,this)).on("dragend",jQuery.proxy(this._handleDragend,this)).on("drop",jQuery.proxy(this._handleDrop,this));var t=this.$("bgImg");t.on("dragover",jQuery.proxy(this._handleDragover,this)).on("dragend",jQuery.proxy(this._handleDragend,this)).on("drop",jQuery.proxy(this._handleDrop,this))}var s=this._oFacetBar.getAssociatedItems().length>0;var i=this.$("facetBar");i.css("display",s?"block":"none");this._adaptContentHeight();this._bRtl=T.getRTL();if(this._getPersonalization().hasChanges()){this._getPersonalization().applySettings(this._getPersonalization().oSettings)}if(!this._oPaneItemNavigation){this._oPaneItemNavigation=(new n).setCycling(false);this.addDelegate(this._oPaneItemNavigation)}var o=this.$("paneBarEntries");this._updatePaneBarItemNavigation(o);this._setNotifyVisibility();if(H.FIRST_RENDERING){jQuery(window).on("resize",this._checkResizeClosure)}this._checkResize();H.FIRST_RENDERING=false;if(v.browser.firefox&&v.browser.version==17){setTimeout(this._checkResize.bind(this),500)}};H.prototype._updateThemeVariables=function(){var e=Object.assign({sapUiUx3ShellSideBarBaseWidth:"40px",sapUiUx3ShellPaneOverflowButtonHeight:"40px"},s.get({name:["sapUiUx3ShellSideBarBaseWidth","sapUiUx3ShellPaneOverflowButtonHeight"],callback:function(e){H.SIDE_BAR_BASE_WIDTH=parseInt(e["sapUiUx3ShellSideBarBaseWidth"]);H.PANE_OVERFLOW_BUTTON_HEIGHT=parseInt(e["sapUiUx3ShellPaneOverflowButtonHeight"])}}));H.SIDE_BAR_BASE_WIDTH=parseInt(e["sapUiUx3ShellSideBarBaseWidth"]);H.PANE_OVERFLOW_BUTTON_HEIGHT=parseInt(e["sapUiUx3ShellPaneOverflowButtonHeight"]);H.PANE_OVERFLOW_BUTTON_MAX_HEIGHT=H.PANE_OVERFLOW_BUTTON_HEIGHT};H.prototype._checkResize=function(){if(!this.getDomRef()){return}clearTimeout(this._checkResizeDelayId);this._checkResizeDelayId=setTimeout(function(){this._rerenderPaneBarItems();this._checkToolPaletteSize()}.bind(this),100)};H.prototype._checkToolPaletteSize=function(e){if(!this.getDomRef()){return}if(e===undefined){e=!this.getShowTools()}var t=this.$("tp");var s=1;var i=9999999;var o=0;var a=true;if(e){s=0;a=false}do{var r=s*H.SIDE_BAR_BASE_WIDTH;var n=Math.floor(r/2);var h=Math.floor(r/4);var p=this._bRtl?"right":"left";this.$("canvas").css(p,r+"px");this.$("canvasBackground").css(p,r+"px");this.$("wBar").css("margin-"+p,r+"px");var d={};d[p]=r+"px";this.$("notify").css(d);t.css("width",r+"px");var d={};d["width"]=n+"px";d["margin-"+p]=h+"px";this.$("tp-separator").css(d);if(!a){break}l.forceRepaint(t[0]);o=t.children().last()[0].offsetTop;if(o>=i){s--;a=false;continue}i=o;s++;if(s>10){I.error("The ToolPalette is growing too much, this must be a bug.");break}}while(o>t.height());this.currentToolPaletteWidth=this.getShowTools()?r:0;this._updateOverlaysOnToolPaletteChange()};H.prototype._updateOverlaysOnToolPaletteChange=function(){var e=this._getSyncRefs();if(this._bRtl){e.css("right",this.currentToolPaletteWidth+"px")}else{e.css("left",this.currentToolPaletteWidth+"px")}};H.prototype._updatePaneBarItemNavigation=function(e){this._oPaneItemNavigation.setRootDomRef(e[0]);var t=e.children().toArray();this._oPaneItemNavigation.setItemDomRefs(t);if(this._oPaneItemNavigation.getFocusedIndex()>t.length){this._oPaneItemNavigation.setFocusedIndex(-1)}this._checkPaneBarOverflow(e)};H.prototype._checkPaneBarOverflow=function(e){clearTimeout(this._checkPaneBarOverflowDelayId);this._checkPaneBarOverflowDelayId=setTimeout(function(){this._delayedCheckPaneBarOverflow(e)}.bind(this),200)};H.prototype._delayedCheckPaneBarOverflow=function(e){if(!e){e=this.$("paneBarEntries")}if(e.length==0){this._checkPaneBarOverflow();return}var t=e.parent().height()-(this._bRtl?e.innerHeight():0);var s=0;var i=e.children();i.css("display","inline-block");var o=false;var a=i.length;for(var r=a-1;r>=0;--r){var n=i[r];if(this._bRtl){s=0-n.offsetLeft}else{s=n.offsetLeft+n.offsetWidth}var h=s<t;jQuery(n).css("display",h?"inline-block":"none");var p=sap.ui.getCore().byId(n.id+"-overflow");p&&p.setVisible(!h);if(h){continue}else{o=true}}var d=this.$("paneBarOverflowButton");if(o){d.css("display","block")}else{d.css("display","none");if(v.browser.firefox&&v.browser.version==17){l.forceRepaint(document.getElementsByTagName("body")[0])}}var c=this._changeOverflowButton();if(c){this._checkPaneBarOverflow()}};H.prototype._adaptOverflowButtonHeight=function(){var e=this.$("paneBarOverflowButton");var t=this.$("paneBarOverflowWrapper");var s=this.$("paneBarOverflowText");var i=this.$("paneBarRight");s.css("width","");var o=H.PANE_OVERFLOW_BUTTON_HEIGHT;var a=s[0].scrollWidth+5;if(a>H.PANE_OVERFLOW_BUTTON_MAX_HEIGHT){H.PANE_OVERFLOW_BUTTON_HEIGHT=H.PANE_OVERFLOW_BUTTON_MAX_HEIGHT}else{H.PANE_OVERFLOW_BUTTON_HEIGHT=a}e.css("height",H.PANE_OVERFLOW_BUTTON_HEIGHT);t.css("width",H.PANE_OVERFLOW_BUTTON_HEIGHT);s.css("width","100%");i.css("padding-bottom",H.PANE_OVERFLOW_BUTTON_HEIGHT+"px");return o!=H.PANE_OVERFLOW_BUTTON_HEIGHT};H.prototype._changeOverflowButton=function(){var e=null;if(this._sOpenPaneId){e=sap.ui.getCore().byId(this._sOpenPaneId+"-overflow")}var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3").getText("SHELL_MORE_BUTTON");var s=false;if(e&&e.getVisible()){t=e.getText();s=true}t=t.toUpperCase();var i=this.$("paneBarOverflowText");i.text(t);i.attr("title",t);i.toggleClass("sapUiUx3ShellPaneEntrySelected",s);return this._adaptOverflowButtonHeight()};H.prototype._getPaneOverflowMenu=function(){return this.getAggregation("_paneOverflowMenu")};H.prototype.getFocusInfo=function(){try{var e=document.activeElement;return e?{sFocusId:e.id,oFocusedElement:e}:{}}catch(e){return{}}};H.prototype.applyFocusInfo=function(e){var t=(e.sFocusId?window.document.getElementById(e.sFocusId):null)||e.oFocusedElement;if(t){t.focus()}};H._updateToolIcon=function(e){if(e&&e.firstChild){var t=jQuery(e);var s=e.id.substr(e.id.indexOf(H.TOOL_PREFIX)+6);var i=sap.ui.getCore().byId(s);var o;if(t.is(".sapUiUx3ShellToolSelected")){o=i.getIconSelected()}else if(t.is(".sapUiUx3ShellToolHover")){o=i.getIconHover()}else{o=i.getIcon()}e.firstChild.src=o}};H.prototype.onclick=function(e){this.onUserActivation(e)};H.prototype.onsapspace=function(e){this.onUserActivation(e)};H.prototype.onsapenter=function(e){this.onUserActivation(e)};H.prototype.onUserActivation=function(e){var t=e.target.id;var s=e.target.parentNode;var i=this.getId();if(e.target.className&&e.target.className.indexOf&&e.target.className.indexOf("sapUiUx3ShellHeader-logout")>-1){this.fireLogout()}else if(s&&s.parentNode&&s.parentNode.className&&s.parentNode.className.indexOf&&s.parentNode.className.indexOf("sapUiUx3ShellToolPaletteArea")>-1){this._handleToolItemClick(t)}else if(s&&s.parentNode&&s.parentNode.parentNode&&s.parentNode.parentNode.className&&s.parentNode.parentNode.className.indexOf&&s.parentNode.parentNode.className.indexOf("sapUiUx3ShellToolPaletteArea")>-1){this._handleToolItemClick(s.id)}else if(t===i+"-paneBarOverflowText"){var o=this.$("paneBarOverflowButton")[0];this._getPaneOverflowMenu().open(true,o,(this._bRtl?"left":"right")+" bottom","center center",o)}else if(t){if(s&&s.className&&s.className.indexOf&&s.className.indexOf("sapUiUx3ShellPaneEntries")>-1){this._handlePaneBarItemClick(t)}}};H.prototype._handleWorksetBarSelect=function(e){var t=this._handleWorksetItemClick(e.getParameter("item"));if(!t){e.preventDefault()}};H.prototype._handleFacetBarSelect=function(e){var t=this._handleWorksetItemClick(e.getParameter("item"));if(!t){e.preventDefault()}};H.prototype._handleWorksetItemClick=function(e){var t=e.getParent(),s=e.getId(),i=s,o=true;if(t instanceof H){if(s!=this._sSelectedWorksetId){var a=e.getSubItems();if(a.length>0){i=a[0].getId()}o=this._fireWorksetItemSelected(i);if(o){this._sSelectedWorksetId=s;if(a.length>0){this._sSelectedFacetId=a[0].getId();s=this._sSelectedFacetId}else{this._sSelectedFacetId=null}var a=e.getSubItems();this._oFacetBar.setAssociatedItems(a,true);var r=this.$("facetBar");var n=this._calcFacetBarHeight(r);if(a.length>0){if(!this._oFacetBar.isSelectedItemValid()){this._oFacetBar.setSelectedItem(a[0]);this._sSelectedFacetId=a[0].getId()}r.slideDown();this._adaptContentHeight(null,true,n)}else{this._oFacetBar.setSelectedItem(null);r.slideUp();this._adaptContentHeight(null,true,n)}}}}else{if(s!=this._sSelectedFacetId){o=this._fireWorksetItemSelected(i);if(o){this._sSelectedFacetId=s}}}return o};H.prototype._fireWorksetItemSelected=function(e){var t=sap.ui.getCore().byId(e);var s=t?t.getKey():null;var i=this.fireWorksetItemSelected({id:e,item:t,key:s});if(i){this.setAssociation("selectedWorksetItem",e,true)}return i};H.prototype._closeCurrentToolPopup=function(){var e;if(this._oOpenToolPopup){e=this._oOpenToolPopup.getId();jQuery(document.getElementById(this.getId()+H.TOOL_PREFIX+this._oOpenToolPopup.getId())).removeClass("sapUiUx3ShellToolSelected").attr("aria-pressed","false");if(e===this.getId()+"-feederTool"){var t=sap.ui.getCore().byId(this.getId()+"-feeder");t.setText("");t.rerender()}this._oOpenToolPopup.close();this._oOpenToolPopup=null}return e};H.prototype._handleToolItemClick=function(e){var t=this._closeCurrentToolPopup();var s;var i=e.substr(e.indexOf(H.TOOL_PREFIX)+6);if(i==this.getId()+"-searchTool"){s=this._getSearchTool()}else if(i==this.getId()+"-feederTool"){s=this._getFeederTool()}else{s=sap.ui.getCore().byId(i)}if(s&&s.getId()!=t){this._oOpenToolPopup=s;s.setPosition(x.BeginTop,x.EndTop,document.getElementById(e),"13 -6","fit");s.open();jQuery(document.getElementById(e)).addClass("sapUiUx3ShellToolSelected").attr("aria-pressed","true");H._updateToolIcon(document.getElementById(e));var o=this;var a=function(t){s.detachClosed(a);if(o._oOpenToolPopup&&o._oOpenToolPopup.getId()===t.getParameter("id")){o._closeCurrentToolPopup()}jQuery(document.getElementById(e)).removeClass("sapUiUx3ShellToolSelected");H._updateToolIcon(document.getElementById(e))};s.attachClosed(a)}else if(s.getId()==t){H._updateToolIcon(document.getElementById(e))}};H.prototype._hasDarkDesign=function(){return this.getDesignType()!==R.Light&&this.getDesignType()!==R.Crystal};H.prototype._getSearchTool=function(){if(!this._oSearchPopup){var e=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._oSearchPopup=new p(this.getId()+"-searchTool",{tooltip:e.getText("SHELL_SEARCH")}).addStyleClass("sapUiUx3TP-search");var t=this._hasDarkDesign();this._oSearchPopup.setInverted(t);var s=this;var i=new d(this.getId()+"-searchField",{enableListSuggest:false,search:function(e){s.fireSearch({text:e.getParameter("query")})}});var o=new c({text:e.getText("SHELL_SEARCH_LABEL")+":"}).setLabelFor(i);this._oSearchPopup.addContent(o).addContent(i);this._oSearchPopup.attachOpen(function(){window.setTimeout(function(){i.focus()},100)});this._oSearchField=i}return this._oSearchPopup};H.prototype.getSearchField=function(){if(!this._oSearchField){this._getSearchTool()}return this._oSearchField};H.prototype._getFeederTool=function(){if(!this._oFeederPopup){var e=this;var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._oFeederPopup=new p(this.getId()+"-feederTool",{tooltip:t.getText("SHELL_FEEDER")}).addStyleClass("sapUiUx3TP-feeder");var s=this._hasDarkDesign();this._oFeederPopup.setInverted(s);var i=new u(this.getId()+"-feeder",{type:B.Medium,submit:function(t){e.fireFeedSubmit({text:t.getParameter("text")});i.setText("");i.rerender();e._oFeederPopup.close()}});this._oFeederPopup.setInitialFocus(this.getId()+"-feeder");this._oFeederPopup.attachClose(function(){i.setText("")});this._oFeederPopup.addContent(i)}return this._oFeederPopup};H.prototype.openPane=function(e){var t=this;S(typeof e==="string","sPaneId must be given as string");var s=sap.ui.getCore().byId(e);if(s&&e!=this._sOpenPaneId&&this.getShowPane()){var i;if(s){if(s.getKey()==""){i=null}else{i=s.getKey()}}else{i=null}this.firePaneBarItemSelected({id:e,item:s,key:i});var o=jQuery(document.getElementById(e));o.siblings().removeClass("sapUiUx3ShellPaneEntrySelected");o.addClass("sapUiUx3ShellPaneEntrySelected");if(!this._sOpenPaneId){this._openPane(function(){t.focusPaneStart()})}else{jQuery(document.getElementById(this.getId()+"-pb_"+this._sOpenPaneId)).removeClass("sapUiUx3ShellPaneEntrySelected")}this._sOpenPaneId=e}return this};H.prototype.closePane=function(){this._closePane();return this};H.prototype.isPaneOpen=function(){return this._sOpenPaneId!=null};H.prototype._handlePaneBarItemClick=function(e){if(e===this._sOpenPaneId){this.closePane()}else{this.openPane(e)}this._checkPaneBarOverflow()};H._SHELL_OFFSET_RIGHT=0;H.prototype._closePane=function(e){if(!this._sOpenPaneId){if(e){e()}return}var t=this._sOpenPaneId;var s=this;var i=this.getShowPane()?this.$("paneBarRight").outerWidth()+H._SHELL_OFFSET_RIGHT:H._SHELL_OFFSET_RIGHT;var o={};o[this._bRtl?"left":"right"]=i+"px";var a={};a[this._bRtl?"marginLeft":"marginRight"]=i-H._SHELL_OFFSET_RIGHT+"px";this.$("content").css("overflow-x","hidden");this.$("canvas").stop().animate(o);this.$("notify").stop().animate(o);this._getSyncRefs().stop(false,true).animate(o);this.$("wBar").stop().animate(a);this.$("paneBar").removeClass("sapUiUx3ShellPaneBarOpened").addClass("sapUiUx3ShellPaneBarClose");this.$("canvasBackground").removeClass("sapUiUx3ShellCanvasBackgroundOpen").addClass("sapUiUx3ShellCanvasBackgroundClosed").stop().animate(o,function(){s.$("paneBar").removeClass("sapUiUx3ShellPaneBarOpen");s.$("content").css("overflow-x","");if(e){e()}s.firePaneClosed({id:t})});jQuery(document.getElementById(this._sOpenPaneId)).removeClass("sapUiUx3ShellPaneEntrySelected");this._sOpenPaneId=null};H.prototype._openPane=function(e){var t=this;var s=this.getPaneWidth();var i=this.$("paneBarRight").outerWidth();this.$("content").css("overflow-x","hidden");if(this._bRtl){this.$("paneBar").removeClass("sapUiUx3ShellPaneBarClose").addClass("sapUiUx3ShellPaneBarOpen");this.$("wBar").stop().animate({marginLeft:s+i+"px"});this.$("canvas").stop().animate({left:s+i+H._SHELL_OFFSET_RIGHT+"px"});this.$("notify").stop().animate({left:s+i+H._SHELL_OFFSET_RIGHT+"px"});this._getSyncRefs().stop(false,true).animate({left:s+i+H._SHELL_OFFSET_RIGHT+"px"});this.$("canvasBackground").stop().animate({left:s+i+H._SHELL_OFFSET_RIGHT+"px"},function(){t.$("content").css("overflow-x","");t.$("canvasBackground").removeClass("sapUiUx3ShellCanvasBackgroundClosed").addClass("sapUiUx3ShellCanvasBackgroundOpen");t.$("paneBar").addClass("sapUiUx3ShellPaneBarOpened");if(e){e()}})}else{this.$("paneBar").removeClass("sapUiUx3ShellPaneBarClose").addClass("sapUiUx3ShellPaneBarOpen");this.$("wBar").stop().animate({marginRight:s+i+"px"});this.$("canvas").stop().animate({right:s+i+H._SHELL_OFFSET_RIGHT+"px"});this.$("notify").stop().animate({right:s+i+H._SHELL_OFFSET_RIGHT+"px"});this._getSyncRefs().stop(false,true).animate({right:s+i+H._SHELL_OFFSET_RIGHT+"px"});this.$("canvasBackground").stop().animate({right:s+i+H._SHELL_OFFSET_RIGHT+"px"},function(){t.$("content").css("overflow-x","");t.$("canvasBackground").removeClass("sapUiUx3ShellCanvasBackgroundClosed").addClass("sapUiUx3ShellCanvasBackgroundOpen");t.$("paneBar").addClass("sapUiUx3ShellPaneBarOpened");if(e){e()}})}};H.prototype.setPaneWidth=function(e){if(typeof e=="number"&&e>0){e=Math.max(e,50);if(this.getDomRef()){this.$("paneContent").css("width",e+"px");this.$("paneBar").css("width",e+H.SIDE_BAR_BASE_WIDTH+"px");if(this._sOpenPaneId){if(this._bRtl){this.$("wBar").css("marginLeft",e+H.SIDE_BAR_BASE_WIDTH+"px");this.$("canvas").css("left",e+H.SIDE_BAR_BASE_WIDTH+H._SHELL_OFFSET_RIGHT+"px");this.$("notify").css("left",e+H.SIDE_BAR_BASE_WIDTH+H._SHELL_OFFSET_RIGHT+"px");this._getSyncRefs().css("left",e+H.SIDE_BAR_BASE_WIDTH+H._SHELL_OFFSET_RIGHT+"px");this.$("canvasBackground").css("left",e+H.SIDE_BAR_BASE_WIDTH+H._SHELL_OFFSET_RIGHT+"px")}else{this.$("wBar").css("marginRight",e+H.SIDE_BAR_BASE_WIDTH+"px");this.$("canvas").css("right",e+H.SIDE_BAR_BASE_WIDTH+H._SHELL_OFFSET_RIGHT+"px");this.$("notify").css("right",e+H.SIDE_BAR_BASE_WIDTH+H._SHELL_OFFSET_RIGHT+"px");this._getSyncRefs().css("right",e+H.SIDE_BAR_BASE_WIDTH+H._SHELL_OFFSET_RIGHT+"px");this.$("canvasBackground").css("right",e+H.SIDE_BAR_BASE_WIDTH+H._SHELL_OFFSET_RIGHT+"px")}}}this.setProperty("paneWidth",e,true)}return this};H.prototype.setOffsetRight=function(e,t,s){if(e<0){e=0}if(e>600){e=600}H._SHELL_OFFSET_RIGHT=e;var i=e+"px";var o=this._bRtl?{left:i}:{right:i};this.$("hdr").stop().animate(o);this.$("hdrImg").stop().animate(o);this.$("bg").stop().animate(o,function(){if(t){t()}});this.$("bgImg").stop().animate(o);this.$("wBar").stop().animate(o);this.$("paneBar").stop().animate(o);jQuery(document.getElementById(s)).stop().animate({width:i});if(!this.$().hasClass("sapUiUx3ShellNoPane")){i=e+(this._sOpenPaneId?this.getPaneWidth():0)+H.SIDE_BAR_BASE_WIDTH+"px"}o=this._bRtl?{left:i}:{right:i};this.$("notify").stop().animate(o);this._getSyncRefs().stop(false,true).animate(o);this.$("canvas").stop().animate(o);this.$("canvasBackground").stop().animate(o)};H.prototype._refreshCanvasOffsetRight=function(e){var t=this._bRtl?"left":"right";var s=H._SHELL_OFFSET_RIGHT;if(e){var i=this.$("paneBarRight").outerWidth();s=s+(this._sOpenPaneId?this.getPaneWidth():0)+i}s=s+"px";this.$("notify").css(t,s);this.$("canvas").css(t,s);this.$("canvasBackground").css(t,s);this._getSyncRefs().css(t,s)};H.prototype._setNotifyVisibility=function(e){var t=this.getNotificationBar();if(!t){return}if(!e){e=t.getVisibleStatus()}var s=this.$("notify");var i=this._topSyncRefId?jQuery(document.getElementById(this._topSyncRefId)):jQuery(null);var o=i.hasClass("sapUiUx3TI");var a=0;var r=0;if(e===P.Min){a=10}else if(e===P.Max||e===P.Default){if(this.getHeaderType()===O.BrandOnly&&o){a=parseInt(t.getHeightOfStatus(P.Default))}else{a=10}r=a}s.removeClass("sapUiUx3ShellNotifyTI").removeClass("sapUiUx3ShellNotifyOverlay");if(this._topSyncRefId){this._getSyncRefs().animate({bottom:r+"px"},"fast");if(r>0){s.addClass(o?"sapUiUx3ShellNotifyTI":"sapUiUx3ShellNotifyOverlay")}}if(e===P.Min){s.css("height",a+"px").css("z-index",1)}else{s.css("height",a+"px").css("z-index",1e5)}if(a>0&&!this.$().hasClass("sapUiUx3ShellNotifyVisible")){this.$().addClass("sapUiUx3ShellNotifyVisible")}else if(a==0&&this.$().hasClass("sapUiUx3ShellNotifyVisible")){this.$().removeClass("sapUiUx3ShellNotifyVisible")}this._adaptContentHeight(e)};H.prototype.syncWithCanvasSize=function(e,t,s,i,o){var a=this._aSyncRefStack.indexOf(e);if(t){var r={id:e,focusFirst:s,focusLast:i,applyChanges:o};if(a<0){this._aSyncRefStack.push(e)}this._mSyncRefs[e]=r;r.applyChanges({showOverlay:this.getHeaderType()!==O.BrandOnly})}else{if(a>=0){delete this._mSyncRefs[e];this._aSyncRefStack.splice(a,1)}}this.$("canvas").removeAttr("aria-hidden");this.$("focusDummyTPStart").removeAttr("tabindex").off("focusin");this.$("focusDummyTPEnd").removeAttr("tabindex").off("focusin");this.$("focusDummyHdrStart").removeAttr("tabindex").off("focusin");this.$("focusDummyHdrEnd").removeAttr("tabindex").off("focusin");this.$("focusDummyPane").removeAttr("tabindex").off("focusin");this.$().toggleClass("sapUiUx3ShellBlockHeaderAccess",false);delete this._topSyncRefId;if(this._aSyncRefStack.length>0){var r=this._mSyncRefs[this._aSyncRefStack[this._aSyncRefStack.length-1]];var n=this._getSyncRefs();var l=this.getDomRef("canvas");n.css(this._bRtl?"right":"left",(this.getShowTools()?this.currentToolPaletteWidth:0)+"px");var h=H._SHELL_OFFSET_RIGHT;if(this.getShowPane()){h+=H.SIDE_BAR_BASE_WIDTH;if(this._sOpenPaneId){h+=this.getPaneWidth()}}n.css(this._bRtl?"left":"right",h+"px");n.css("top",this.getDomRef(this.getAllowOverlayHeaderAccess()?"hdr":"hdrLine").offsetHeight+"px");n.css("bottom","0");jQuery(l).attr("aria-hidden","true");this.$("focusDummyTPEnd").attr("tabindex","0").on("focusin",r.focusFirst);this.$("focusDummyHdrStart").attr("tabindex","0").on("focusin",jQuery.proxy(this.focusPaneEnd,this));this.$("focusDummyHdrEnd").attr("tabindex","0").on("focusin",jQuery.proxy(this.focusFirstTool,this));this.$("focusDummyTPStart").attr("tabindex","0").on("focusin",jQuery.proxy(this.focusLastHdr,this));this.$("focusDummyPane").attr("tabindex","0").on("focusin",r.focusLast);this.$().toggleClass("sapUiUx3ShellBlockHeaderAccess",!this.getAllowOverlayHeaderAccess());this._topSyncRefId=r.id}if(this._sUpdateNotificationZIndex){clearTimeout(this._sUpdateNotificationZIndex);delete this._sUpdateNotificationZIndex}this._sUpdateNotificationZIndex=setTimeout(function(){delete this._sUpdateNotificationZIndex;this._setNotifyVisibility();if(this._oOpenToolPopup&&this._topSyncRefId){var e=jQuery(document.getElementById(this._topSyncRefId));this._oOpenToolPopup.$().css("z-index",parseInt(e.css("z-index"))+1)}}.bind(this),0)};H.prototype._getSyncRefs=function(){var e=[];var t;for(var s=0;s<this._aSyncRefStack.length;s++){t=this._aSyncRefStack[s]?window.document.getElementById(this._aSyncRefStack[s]):null;if(t){e.push(t)}}return jQuery(e)};H.prototype.focusFirstHdr=function(){var e=this.$("hdr-items").firstFocusableDomRef();if(e&&this.getAllowOverlayHeaderAccess()&&this.getHeaderType()!=O.BrandOnly){if(e){e.focus()}}else{this.focusFirstTool()}};H.prototype.focusLastHdr=function(){var e=this.$("hdr-items").lastFocusableDomRef();if(e&&this.getAllowOverlayHeaderAccess()&&this.getHeaderType()!=O.BrandOnly){if(e){e.focus()}}else{this.focusPaneEnd()}};H.prototype.focusFirstTool=function(){var e=this.$("tp").find(".sapUiUx3ShellTool").first();if(e.length&&this.getShowTools()){e[0].focus()}else{this._mSyncRefs[this._topSyncRefId].focusFirst()}};H.prototype.focusLastTool=function(){var e=this.$("tp").find(".sapUiUx3ShellTool").last();if(e.length&&this.getShowTools()){e[0].focus()}else{this.focusPaneEnd()}};H.prototype.focusPaneStart=function(){var e=this.$("paneBar").firstFocusableDomRef();if(e){e.focus()}else{this.focusFirstTool()}};H.prototype.focusPaneEnd=function(){var e=this.$("paneBar").lastFocusableDomRef();if(e){e.focus()}else{this._mSyncRefs[this._topSyncRefId].focusLast()}};H.prototype.setAppTitle=function(e){this.setProperty("appTitle",e,true);this._rerenderHeader();return this};H.prototype.setAppIcon=function(e){this.setProperty("appIcon",e,true);this._rerenderHeader();return this};H.prototype.setShowLogoutButton=function(e){this.setProperty("showLogoutButton",e,true);this._rerenderHeader();return this};H.prototype.setLogoutButtonTooltip=function(e){this.setProperty("logoutButtonTooltip",e,true);this._rerenderHeader();return this};H.prototype.insertHeaderItem=function(e,t){if(m.isA(e,"sap.ui.commons.Button")){e.setStyled(false)}this.insertAggregation("headerItems",e,t,true);this._rerenderHeader();return this};H.prototype.addHeaderItem=function(e){if(m.isA(e,"sap.ui.commons.Button")){e.setStyled(false)}this.addAggregation("headerItems",e,true);this._rerenderHeader();return this};H.prototype.removeHeaderItem=function(e){var t=this.removeAggregation("headerItems",e,true);this._rerenderHeader();return t};H.prototype.removeAllHeaderItems=function(){var e=this.removeAllAggregation("headerItems",true);this._rerenderHeader();return e};H.prototype.destroyHeaderItems=function(){this.destroyAggregation("headerItems",true);this._rerenderHeader();return this};H.prototype.setShowSearchTool=function(e){this.setProperty("showSearchTool",e,true);this._rerenderToolPalette();return this};H.prototype.setShowFeederTool=function(e){this.setProperty("showFeederTool",e,true);this._rerenderToolPalette();return this};H.prototype.setHeaderType=function(e){var t=this.getHeaderType();this.setProperty("headerType",e,true);this.$().removeClass("sapUiUx3ShellHead"+t).addClass("sapUiUx3ShellHead"+this.getHeaderType());var s=this._getSyncRefs();if(s.length){s.css("top",this.getDomRef(this.getAllowOverlayHeaderAccess()?"hdr":"hdrLine").offsetHeight+"px")}var i={showOverlay:e!==O.BrandOnly};jQuery.each(this._mSyncRefs,function(e,t){t.applyChanges(i)});return this};H.prototype.setAllowOverlayHeaderAccess=function(e){this.setProperty("allowOverlayHeaderAccess",e,true);var t=this._getSyncRefs();if(t.length){this.$().toggleClass("sapUiUx3ShellBlockHeaderAccess",!this.getAllowOverlayHeaderAccess());t.css("top",this.getDomRef(this.getAllowOverlayHeaderAccess()?"hdr":"hdrLine").offsetHeight+"px")}return this};H.prototype.setDesignType=function(e){var t=this.getDesignType();this.setProperty("designType",e,true);var s=this._hasDarkDesign();if(this._oSearchPopup){this._oSearchPopup.setInverted(s)}if(this._oFeederPopup){this._oFeederPopup.setInverted(s)}var i=this.getToolPopups();for(var o=0;o<i.length;++o){i[o].setInverted(s)}this.$().removeClass("sapUiUx3ShellDesign"+t).addClass("sapUiUx3ShellDesign"+e).toggleClass("sapUiUx3ShellDesignLight",!s);return this};H.prototype.setShowTools=function(e){this.setProperty("showTools",e,true);if(e){this.$().removeClass("sapUiUx3ShellNoTools");this._checkResize()}else{this.$().addClass("sapUiUx3ShellNoTools");this._closeCurrentToolPopup();this.$("tp").attr("style","")}this._checkToolPaletteSize(true);return this};H.prototype.setShowPane=function(e){this.setProperty("showPane",e,true);if(e){this.$().removeClass("sapUiUx3ShellNoPane");this._refreshCanvasOffsetRight(true);this._checkPaneBarOverflow()}else{var t=this;this._closePane(function(){t._refreshCanvasOffsetRight(false);t.$().addClass("sapUiUx3ShellNoPane")})}return this};H.prototype.insertToolPopup=function(e,t){this.insertAggregation("toolPopups",e,t,true);e.attachIconChanged(this._rerenderToolPalette,this);this._rerenderToolPalette();return this};H.prototype.addToolPopup=function(e){var t=this._hasDarkDesign();e.setInverted(t);this.addAggregation("toolPopups",e,true);e.attachIconChanged(this._rerenderToolPalette,this);this._rerenderToolPalette();return this};H.prototype.removeToolPopup=function(e){var t=this.removeAggregation("toolPopups",e,true);if(t===this._oOpenToolPopup){this._closeCurrentToolPopup()}this._rerenderToolPalette();return t};H.prototype.removeAllToolPopups=function(){var e=this.removeAllAggregation("toolPopups",true);this._rerenderToolPalette();return e};H.prototype.destroyToolPopups=function(){this.destroyAggregation("toolPopups",true);this._rerenderToolPalette();return this};H.prototype.insertContent=function(e,t){this.insertAggregation("content",e,t,true);this._rerenderContent();return this};H.prototype.addContent=function(e){this.addAggregation("content",e,true);this._rerenderContent();return this};H.prototype.removeContent=function(e){var t=this.removeAggregation("content",e,true);this._rerenderContent();return t};H.prototype.removeAllContent=function(){var e=this.removeAllAggregation("content",true);this._rerenderContent();return e};H.prototype.destroyContent=function(){this.destroyAggregation("content",true);this._rerenderContent();return this};H.prototype.addPaneBarItem=function(e){this.addAggregation("paneBarItems",e,true);this._rerenderPaneBarItems();return this};H.prototype.insertPaneBarItem=function(e,t){this.insertAggregation("paneBarItems",e,t,true);this._rerenderPaneBarItems();return this};H.prototype.removePaneBarItem=function(e){var t=this.removeAggregation("paneBarItems",e,true);if(t){var s=sap.ui.getCore().byId(t.getId()+"-overflow");if(s){s.destroy()}}this._rerenderPaneBarItems();return t};H.prototype.removeAllPaneBarItems=function(){var e=this.removeAllAggregation("paneBarItems",true);this._getPaneOverflowMenu().destroyItems();this._rerenderPaneBarItems();return e};H.prototype.destroyPaneBarItems=function(){this.destroyAggregation("paneBarItems",true);this._getPaneOverflowMenu().destroyItems();this._rerenderPaneBarItems();return this};H.prototype.addWorksetItem=function(e){this.addAggregation("worksetItems",e,true);this._rerenderWorksetItems();return this};H.prototype.insertWorksetItem=function(e,t){this.insertAggregation("worksetItems",e,t,true);this._rerenderWorksetItems();return this};H.prototype.removeWorksetItem=function(e){var t=this.removeAggregation("worksetItems",e,true);this._rerenderWorksetItems();return t};H.prototype.removeAllWorksetItems=function(){var e=this.removeAllAggregation("worksetItems",true);this._rerenderWorksetItems();return e};H.prototype.destroyWorksetItems=function(){this.destroyAggregation("worksetItems",true);this._rerenderWorksetItems();return this};function E(e){var t=e.getNotificationBar();if(t){e._setNotifyVisibility(P.None);t.setVisibleStatus=t.__orig_setVisibleStatus;t.detachDisplay(t.__fHandleNotifyDisplay);delete t.__orig_setVisibleStatus;delete t.__fHandleNotifyDisplay}}H.prototype.setNotificationBar=function(e){E(this);if(e){var t=this;e.__orig_setVisibleStatus=e.setVisibleStatus;e.setVisibleStatus=function(e){this.__orig_setVisibleStatus.apply(this,arguments);t._setNotifyVisibility()}}this.setAggregation("notificationBar",e,true);this._rerenderNotificationArea();if(e){e.__fHandleNotifyDisplay=function(t){var s=t?t.getParameter("show"):e.hasItems();e.setVisibleStatus(s?P.Default:P.None)};e.attachDisplay(e.__fHandleNotifyDisplay);e.__fHandleNotifyDisplay()}return this};H.prototype.destroyNotificationBar=function(){E(this);this.destroyAggregation("notificationBar",true);this._rerenderNotificationArea();return this};H.prototype._rerenderNotificationArea=function(){var e=this.$("notify");if(e.length>0){var t=sap.ui.getCore().createRenderManager();o.renderNotificationArea(t,this);t.flush(e[0],true);t.destroy()}};H.prototype._rerenderHeader=function(){var e=this.$("hdr");if(e.length>0){var t=sap.ui.getCore().createRenderManager();o.renderHeader(t,this);t.flush(e[0],true);t.destroy()}};H.prototype._rerenderToolPalette=function(){var e=this.$("tp");if(e.length>0){var t=sap.ui.getCore().createRenderManager();this._beforeRenderingToolPalette();o.renderToolPalette(t,this);t.flush(e[0],true);this._afterRenderingToolPalette();t.destroy();this._checkResize()}};H.prototype._beforeRenderingToolPalette=function(){this.$("tp").find(".sapUiUx3ShellTool").off("mouseenter mouseleave");this.$("focusDummyTPEnd").off("focusin");this.$("focusDummyTPStart").off("focusin")};H.prototype._afterRenderingToolPalette=function(){var e=this.getId()+H.TOOL_PREFIX;var t=this.getToolPopups();var s=false;if(this._oOpenToolPopup&&this._oOpenToolPopup.isOpen()&&(this.indexOfToolPopup(this._oOpenToolPopup)>=0||this._oOpenToolPopup===this._oSearchPopup||this._oOpenToolPopup===this._oFeederPopup)){this._oOpenToolPopup.setPosition(x.BeginTop,x.EndTop,e+this._oOpenToolPopup.getId()?window.document.getElementById(e+this._oOpenToolPopup.getId()):null,"13 -6","fit");var i=document.getElementById(e+this._oOpenToolPopup.getId());jQuery(i).toggleClass("sapUiUx3ShellToolSelected",true);H._updateToolIcon(i);s=true}if(!s&&this._oOpenToolPopup){this._closeCurrentToolPopup()}for(var o=0;o<t.length;o++){var a=t[o];if(a instanceof p){jQuery(document.getElementById(e+a.getId())).hover(function(e){jQuery(this).toggleClass("sapUiUx3ShellToolHover",e.type==="mouseenter");H._updateToolIcon(this)})}}if(this._topSyncRefId&&this._mSyncRefs[this._topSyncRefId].focusFirst){this.$("focusDummyTPEnd").attr("tabindex","0").on("focusin",this._mSyncRefs[this._topSyncRefId].focusFirst)}if(this._aSyncRefStack.length>0){this.$("focusDummyTPStart").attr("tabindex","0").on("focusin",jQuery.proxy(this.focusLastHdr,this))}};H.prototype._rerenderContent=function(e){var t=this.$("content");if(t.length>0){var s=this.getContent(),i=sap.ui.getCore().createRenderManager();for(var o=0;o<s.length;o++){i.renderControl(s[o])}i.flush(t[0],e);i.destroy()}};H.prototype._rerenderPane=function(e){var t=this.$("paneContent");if(t.length>0){var s=this.getPaneContent(),i=sap.ui.getCore().createRenderManager();for(var o=0;o<s.length;o++){i.renderControl(s[o])}i.flush(t[0],e);i.destroy()}};H.prototype._rerenderPaneBarItems=function(){var e=this.$("paneBar").find(".sapUiUx3ShellPaneEntries");if(e.length>0){var t=sap.ui.getCore().createRenderManager();o.renderPaneBarItems(t,this);t.flush(e[0]);t.destroy();this._updatePaneBarItemNavigation(e)}var s=this;var i=this._getPaneOverflowMenu();var a=this.getPaneBarItems();var r=function(e){var t={overflowItem:e.getParameter("item"),target:{id:e.getParameter("id").replace(/-overflow$/,""),parentNode:{className:"sapUiUx3ShellPaneEntries"}}};s.onUserActivation(t)};for(var n=0;n<a.length;++n){var l=a[n].getId()+"-overflow";var h=sap.ui.getCore().byId(l);if(!h){var p=new _(l,{text:a[n].getText(),visible:false,select:r});i.addItem(p)}}this._checkPaneBarOverflow(e)};H.prototype._rerenderWorksetItems=function(){if(this.$("wBar").length>0){o.renderWorksetItems(null,this);o.renderFacetBar(null,this);var e=this._oFacetBar.getAssociatedItems();this._oFacetBar.$().css("display",e&&e.length>0?"block":"none");this._adaptContentHeight()}};H.prototype.forceInvalidation=t.prototype.invalidate;H.prototype.invalidate=function(e){if(!e){this.forceInvalidation()}else if(e instanceof sap.ui.ux3.NavigationItem){if(this._oWorksetBar&&this._oFacetBar){this._oWorksetBar.setAssociatedItems(this.getWorksetItems());var t=this.getSelectedWorksetItem();if(t){var s;var i=sap.ui.getCore().byId(t);if(i&&i.getParent()instanceof sap.ui.ux3.NavigationItem){this._oFacetBar.setAssociatedItems(i.getParent().getSubItems())}else if(i&&(s=i.getSubItems())){if(s&&s.length>0){this._oFacetBar.setAssociatedItems(s)}}s=this._oFacetBar.getAssociatedItems();this._oFacetBar.$().css("display",s&&s.length>0?"block":"none");this._adaptContentHeight()}}}else if(e instanceof sap.ui.core.Item&&e.getParent()==this){this.forceInvalidation()}else if(e instanceof p){this._rerenderToolPalette()}else if(this.indexOfHeaderItem(e)>=0){this._rerenderHeader()}};H.prototype._setParent=t.prototype.setParent;H.prototype.setParent=function(e,t,s){this._setParent(e,t,s);this.forceInvalidation()};H.prototype.setContent=function(e,s){S(e===null||e instanceof t||Array.isArray(e)&&(e.length>0?e[0]instanceof t:true),"vContent must be a control or array of controls or null");S(s===undefined||s===true||s===false,"bDestruct must be true, false, or undefined");var i=[];var o=this.$("content");var a=false;if(!s){i=this.removeAllAggregation("content",true);if(o.length>0){l.preserveContent(o[0]);a=true;o.empty()}}else{this.destroyAggregation("content",true)}if(e instanceof t){this.addAggregation("content",e,true)}else if(e&&typeof e=="object"&&e.length){for(var r=0;r<e.length;r++){this.addAggregation("content",e[r],true)}}this._rerenderContent(a);return i};H.prototype.setPaneContent=function(e,s){S(e instanceof t||Array.isArray(e)&&(e.length>0?e[0]instanceof t:true),"vContent must be a control or array of controls");S(s===undefined||s===true||s===false,"bDestruct must be true, false, or undefined");var i=[];var o=this.$("paneContent");var a=false;if(!s){i=this.removeAllAggregation("paneContent",true);if(o.length>0){l.preserveContent(o[0]);a=true;o.empty()}}else{this.destroyAggregation("paneContent",true)}if(e instanceof t){this.addAggregation("paneContent",e,true)}else if(e&&typeof e=="object"&&e.length){for(var r=0;r<e.length;r++){this.addAggregation("paneContent",e[r],true)}}this._rerenderPane(a);return i};H.prototype.getSelectedWorksetItem=function(){return this.getAssociation("selectedWorksetItem")};H.prototype.setSelectedWorksetItem=function(e){var t=this.getSelectedWorksetItem();this.setAssociation("selectedWorksetItem",e,true);var s=this.getSelectedWorksetItem();if(t!=s){var i=sap.ui.getCore().byId(s);if(i){this._sSelectedWorksetId=s;this._sSelectedFacetId=null;var o=i.getSubItems();if(o.length>0){i=o[0]}if(i&&i.getParent()instanceof sap.ui.ux3.NavigationItem){var a=i.getParent();this._sSelectedWorksetId=a.getId();this._sSelectedFacetId=i.getId();this._oWorksetBar.setSelectedItem(a);this._oFacetBar.setAssociatedItems(a.getSubItems());this._oFacetBar.setSelectedItem(i);if(this.getDomRef()){var r=this.$("facetBar");var n=this._calcFacetBarHeight(r);r.slideDown();this._adaptContentHeight(null,true,n)}}else if(i){this._oWorksetBar.setSelectedItem(i);this._oFacetBar.setAssociatedItems([]);this._oFacetBar.setSelectedItem(null);if(this.getDomRef()){var r=this.$("facetBar");var n=this._calcFacetBarHeight(r);r.slideUp();this._adaptContentHeight(null,true,n)}}}else{throw new Error("WorksetItem with ID "+s+" cannot be found.")}}return this};H.prototype.setApplyContentPadding=function(e){this.setProperty("applyContentPadding",e,true);this.$().toggleClass("sapUiUx3ShellNoContentPadding",!e);this._adaptContentHeight();return this};H.prototype.setFullHeightContent=function(e){this.setProperty("fullHeightContent",e,true);this.$().toggleClass("sapUiUx3ShellFullHeightContent",e);this._adaptContentHeight();return this};H.prototype._calcFacetBarHeight=function(e){if(this._iFacetBarHeight===undefined){this._iFacetBarHeight=0}if(!e){e=this.$("facetBar")}if(e.length>0){var t=this.$("facetBar").outerHeight(true);this._iFacetBarHeight=Math.max(this._iFacetBarHeight,t)}return this._iFacetBarHeight};H.prototype._adaptContentHeight=function(e,t,s){if(!this.getDomRef()){return}var i=this.$("content");var o=this.$("canvas");if(this.getFullHeightContent()){var a=this.getApplyContentPadding();var r=!a?0:parseInt(o.css("paddingTop"));var n=!a?0:parseInt(o.css("paddingLeft"));var h=!a?0:parseInt(o.css("paddingRight"));var p=s?s:this._calcFacetBarHeight();var d=r+(this._oFacetBar.getAssociatedItems().length>0?p:0)+"px";if(t){i.stop().animate({top:d})}else{i.stop().css("top",d)}var c=this.getNotificationBar();if(c&&!e){e=c.getVisibleStatus()}if(e===P.Default||e===P.Max){i.css("bottom",c.getHeightOfStatus(P.Default))}else{var u=!a?0:parseInt(o.css("paddingBottom"));if(c&&e===P.Min){u+=y.HOVER_ITEM_HEIGHT}i.css("bottom",u+"px")}i.css(this._bRtl?"right":"left",n+"px");i.css(this._bRtl?"left":"right",h+"px")}else{i.removeAttr("style")}if(v.browser.webkit){l.forceRepaint(this.getId()+"-canvas")}};H.prototype._handleDragover=function(e){var t=e.target.id;if(!this._dragOverBlinking){var s=jQuery(document.getElementById(t));s.css("opacity","0.5");this._dragOverBlinking=true;var i=this;window.setTimeout(function(){s.css("opacity","1");window.setTimeout(function(){i._dragOverBlinking=null},300)},300)}return false};H.prototype._handleDragend=function(e){return false};H.prototype._handleDrop=function(e){var t=e.target.id;e.preventDefault();var s=e.originalEvent;var i=s.dataTransfer.files[0];if(i){var o=new window.FileReader;o.onload=jQuery.proxy(function(e){var s=e.target.result;if(t==this.getId()+"-bgImg"){this._getPersonalization()._handleBackgroundImageChange(s,true)}else if(t==this.getId()+"-hdr"){this._getPersonalization()._handleHeaderImageChange(s,true)}else if(t==this.getId()+"-logoImg"){this._getPersonalization()._handleLogoImageChange(s,true)}o=null},this);o.readAsDataURL(i)}};H.prototype._getPersonalization=function(){if(!this.oPersonalization){this.oPersonalization=new a(this)}return this.oPersonalization};H.prototype.openPersonalizationDialog=function(){this._getPersonalization().openDialog()};H.prototype.initializePersonalization=function(e){this._getPersonalization().initializeSettings(e)};H.prototype.onThemeChanged=function(e){this._iFacetBarHeight=undefined;if(!this.getDomRef()){return}var t="";if(!this.getAppIcon()){t=s._getThemeImage("sapUiUx3ShellApplicationImageURL",true);this.$("logoImg").attr("src",t)}t=s._getThemeImage("sapUiUx3ShellHeaderImageURL",true);this.$("hdrImg").attr("src",t);t=s._getThemeImage("sapUiUx3ShellBackgroundImageURL",true);this.$("bgImg").attr("src",t);this.$("facetBar").stop(true,true);this._adaptContentHeight();this._updateThemeVariables();this._checkResize()};return H});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/ShellColorPicker", ["sap/ui/thirdparty/jquery","sap/ui/base/EventProvider","sap/ui/commons/Button","sap/ui/core/Popup","sap/ui/commons/Slider","sap/ui/Device"],function(jQuery,e,t,o,i,r){"use strict";var s=e.extend("sap.ui.ux3.ShellColorPicker",{constructor:function(t){e.apply(this);this.id=t}});s.M_EVENTS={liveChange:"liveChange"};s.prototype.attachLiveChange=function(e,t){this.attachEvent(s.M_EVENTS.liveChange,e,t)};s.prototype.detachLiveChange=function(e,t){this.detachEvent(s.M_EVENTS.liveChange,e,t)};s.prototype.fireLiveChange=function(e){var t={cssColor:s.hslToCss(e)};this.fireEvent(s.M_EVENTS.liveChange,t)};s.prototype.isOpen=function(){return this.oPopup&&this.oPopup.isOpen()};s.prototype.open=function(e,r,s,n,a,h,l){if(this.oPopup&&this.oPopup.isOpen()){return}this.oSlider=new i({width:"225px",liveChange:[this.handleSlider,this]});this.oOkBtn=new t({text:"OK",press:[this.handleOk,this]});this.oCancelBtn=new t({text:"Cancel",press:[this.handleCancel,this]});this.oInitialColor=e;this.oCurrentColor=Object.assign({},this.oInitialColor);this.oSlider.setValue(this.oCurrentColor.l);var u=sap.ui.getCore().createRenderManager();var d=document.createElement("div");var p=sap.ui.getCore().getStaticAreaRef();p.appendChild(d);this.renderHtml(u);u.flush(d);u.destroy;this.oPopup=new o(d.firstChild,false,true,true).attachClosed(this.handleClose,this);this.oPopup.setAutoCloseAreas([d.firstChild]);this.oPopup.open(r,s,n,a,h,l);p.removeChild(d);d=null;jQuery(document.getElementById(this.id)).on("mousedown",jQuery.proxy(this.handleGeneralMouseDown,this));jQuery(document.getElementById(this.id+"-img")).on("mousedown",jQuery.proxy(this.handleMouseDown,this));jQuery(document.getElementById(this.id+"-marker")).on("mousedown",jQuery.proxy(this.handleMouseDown,this));this._imgOffset=jQuery(document.getElementById(this.id+"-img")).offset();this.adaptSliderBar(this.oCurrentColor);this.markColorOnImage(this.oCurrentColor);this.adaptPreview(this.oCurrentColor)};s.parseCssRgbString=function(e){e=e.replace(/rgb\(/,"").replace(/\)/,"").trim();var t=e.split(",");var o={r:parseInt(t[0]),g:parseInt(t[1]),b:parseInt(t[2])};return s.rgbToHsl(o)};s.prototype.renderHtml=function(e){e.write("<div id='"+this.id+"' class='sapUiUx3ShellColorPicker'>");e.write("<img id='"+this.id+"-img' src='"+sap.ui.resource("sap.ui.ux3","img/colors-h.png")+"'>");e.renderControl(this.oSlider);e.write("<div id='"+this.id+"-grad' class='sapUiUx3ShellColorPickerGradient'></div>");e.write("<div id='"+this.id+"-marker' class='sapUiUx3ShellColorPickerMarker'></div>");e.write("<div id='"+this.id+"-preview' class='sapUiUx3ShellColorPickerPreview'></div>");e.renderControl(this.oOkBtn);e.renderControl(this.oCancelBtn);e.write("</div>")};s.prototype.markColorOnImage=function(e){var t=e.h*225;var o=(1-e.s)*75;jQuery(document.getElementById(this.id+"-marker")).css("left",t+10).css("top",o+10)};s.prototype.markColorOnSlider=function(e){this.oSlider.setValue(e.l)};s.prototype.adaptSliderBar=function(e){var t="";var o=Object.assign({},e);o.l=50;var i=s.hslToCss(o);if(r.browser.firefox){t="-moz-linear-gradient(left, black, "+i+", white)"}else if(r.browser.webkit){t="-webkit-gradient(linear, left center, right center, from(#000), color-stop(0.5, "+i+"), to(#FFF))"}jQuery(document.getElementById(this.id+"-grad")).css("background-image",t)};s.prototype.adaptPreview=function(e){jQuery(document.getElementById(this.id+"-preview")).css("background-color",s.hslToCss(e))};s.prototype.handleSlider=function(e){var t=e.getParameter("value");this.oCurrentColor.l=t;this.adaptPreview(this.oCurrentColor);this.fireLiveChange(this.oCurrentColor)};s.prototype.handleGeneralMouseDown=function(e){e.preventDefault()};s.prototype.handleMouseDown=function(e){this.handleMousePos(e);e.preventDefault();jQuery(document).on("mousemove",jQuery.proxy(this.handleMousePos,this)).on("mouseup",jQuery.proxy(this.handleMouseUp,this))};s.prototype.handleMouseUp=function(e){this.handleMousePos(e);jQuery(document).off("mousemove",this.handleMousePos).off("mouseup",this.handleMouseUp)};s.prototype.handleMousePos=function(e){var t=e.pageX-this._imgOffset.left;var o=e.pageY-this._imgOffset.top;t=Math.min(Math.max(t,0),225);o=Math.min(Math.max(o,0),75);var i=t/225;var r=1-o/75;this.oCurrentColor.h=i;this.oCurrentColor.s=r;this.adaptSliderBar(this.oCurrentColor);this.markColorOnImage(this.oCurrentColor);this.adaptPreview(this.oCurrentColor);this.fireLiveChange(this.oCurrentColor)};s.prototype.handleOk=function(){this.fireLiveChange(this.oCurrentColor);this.oPopup.close()};s.prototype.handleCancel=function(){this.fireLiveChange(this.oInitialColor);this.oPopup.close()};s.prototype.handleClose=function(){jQuery(document.getElementById(this.id+"-img")).off("mousedown",this.handleMouseDown);jQuery(document.getElementById(this.id+"-marker")).off("mousedown",this.handleMouseDown);jQuery(document).off("mousemove",this.handleMousePos).off("mouseup",this.handleMouseUp);jQuery(document.getElementById(this.id)).off("mousedown",this.handleGeneralMouseDown);this.oSlider.destroy();this.oSlider=null;this.oOkBtn.destroy();this.oOkBtn=null;this.oCancelBtn.destroy();this.oCancelBtn=null;var e=document.getElementById(this.id);e.parentNode.removeChild(e);this.oPopup.destroy();this.oPopup=null};s.rgbToHsl=function(e){var t=e.r/255,o=e.g/255,i=e.b/255;var r=Math.max(t,o,i);var s=Math.min(t,o,i);var n,a,h=(r+s)/2;if(r==s){n=a=0}else{var l=r-s;a=h>.5?l/(2-r-s):l/(r+s);switch(r){case t:n=(o-i)/l+(o<i?6:0);break;case o:n=(i-t)/l+2;break;case i:n=(t-o)/l+4;break}n/=6}return{h:n,s:a,l:h*100}};s.hslToRgb=function(e){var t,o,i;var r=e.l/100;if(e.s==0){t=o=i=r}else{var n=r<.5?r*(1+e.s):r+e.s-r*e.s;var a=2*r-n;t=s.hueToRgb(a,n,e.h+1/3);o=s.hueToRgb(a,n,e.h);i=s.hueToRgb(a,n,e.h-1/3)}return[t*255,o*255,i*255]};s.hueToRgb=function(e,t,o){if(o<0){o+=1}if(o>1){o-=1}if(o<1/6){return e+(t-e)*6*o}if(o<1/2){return t}if(o<2/3){return e+(t-e)*(2/3-o)*6}return e};s.hslToCss=function(e){var t=s.hslToRgb(e);return"rgb("+Math.round(t[0])+","+Math.round(t[1])+","+Math.round(t[2])+")"};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/ShellPersonalization", ["sap/ui/thirdparty/jquery","sap/ui/base/EventProvider","sap/ui/commons/Button","sap/ui/commons/Dialog","sap/ui/core/theming/Parameters","./ShellColorPicker","sap/ui/commons/library","sap/ui/core/HTML","sap/ui/core/Popup","sap/ui/commons/Tab","sap/ui/core/Item","sap/ui/Device","sap/base/security/encodeXML","sap/ui/core/Configuration"],function(jQuery,e,t,i,o,s,n,a,r,g,l,h,d,p){"use strict";var c=r.Dock;var m=e.extend("sap.ui.ux3.ShellPersonalization",{constructor:function(t){e.apply(this);this.shell=t;this.oSettings={}}});m.prototype.initializeSettings=function(e){this.oSettings=Object.assign({},e);if(this.shell.getDomRef()){this.applySettings(e)}};m.M_EVENTS={personalizationChange:"personalizationChange"};m.prototype.attachPersonalizationChange=function(e,t){this.attachEvent(m.M_EVENTS.personalizationChange,e,t)};m.prototype.detachPersonalizationChange=function(e,t){this.detachEvent(m.M_EVENTS.personalizationChange,e,t)};m.prototype.firePersonalizationChange=function(e){this.fireEvent(m.M_EVENTS.personalizationChange,e)};m.ORIGINAL_SETTINGS={bByDStyle:false,sBgColor:"rgb(17,17,17)",sBgCssImg:null,sBgImgSrc:null,sBgImgPos:"tile",fBgImgOpacity:1,fSidebarOpacity:1,sLineColor:"rgb(239,170,0)",sLogoImageSrc:null,sLogoAlign:"left",bUseLogoSize:false};m.TRANSPARENT_1x1=sap.ui.resource("sap.ui.core","themes/base/img/1x1.gif");m.IMAGE_FOLDER_PATH=sap.ui.require.toUrl("sap/ui/ux3/themes/"+p.getTheme()+"/img/shell/");m.getOriginalSettings=function(){if(!m._bOriginalSettingsInitialized){m._bOriginalSettingsInitialized=true;var e,t,i=Object.assign({sapUiUx3ShellGradientTop:"#000000",sapUiUx3ShellGradientBottom:"#000000"},o.get({name:["sapUiUx3ShellGradientTop","sapUiUx3ShellGradientBottom"],callback:function(e){this._calcGradient(e["sapUiUx3ShellGradientTop"],e["sapUiUx3ShellGradientBottom"]);this.invalidate()}.bind(this)}));e=i["sapUiUx3ShellGradientTop"];t=i["sapUiUx3ShellGradientBottom"];this._calcGradient(e,t)}return m.ORIGINAL_SETTINGS};m.prototype._calcGradient=function(e,t){if(h.browser.firefox){m.ORIGINAL_SETTINGS.sBgCssImg="-moz-linear-gradient(top, "+e+" 0, "+t+" 108px, "+t+")"}else if(h.browser.webkit){m.ORIGINAL_SETTINGS.sBgCssImg="-webkit-linear-gradient(top, "+e+" 0, "+t+" 108px, "+t+")"}};m.prototype.hasChanges=function(){var e=0;for(var t in this.oSettings){e++}return e>0};m.prototype.applySettings=function(e){var t=Object.assign({},m.getOriginalSettings(),e);this.applyByDStyle(t.bByDStyle);this.applyBgColor(t.sBgColor);this.applyBgImage(t.sBgCssImg,t.sBgImgSrc);this.applyBgImageOpacity(t.fBgImgOpacity);if(t.sHeaderImageSrc){this.applyHeaderImage(t.sHeaderImageSrc)}else{this.shell.getDomRef("hdr").style.backgroundImage=""}this.applySidebarOpacity(t.fSidebarOpacity);this.applyBgColor(t.sBgColor);this.applyLineColor(t.sLineColor);this.applyLogoImage(t.sLogoImageSrc);this.applyLogoAlign(t.sLogoAlign);this.applyUseLogoSize(t.bUseLogoSize)};m.prototype.openDialog=function(){if(this.oDialog&&this._getDialog().isOpen()){return}this.oTransientSettings=Object.assign({},this.oSettings);this._getDialog().open();this._bindDragAndDrop("bg");this._bindDragAndDrop("hdr");this._bindDragAndDrop("logo")};m.prototype.getTransientSettingsWithDefaults=function(){return Object.assign({},m.getOriginalSettings(),this.oTransientSettings)};m.prototype._bindDragAndDrop=function(e){if(window.FileReader){var t=this.shell.getId()+"-p13n_";jQuery(document.getElementById(t+e+"ImageImg")).on("dragover",jQuery.proxy(this._handleDragover,this)).on("dragend",jQuery.proxy(this._handleDragend,this)).on("drop",jQuery.proxy(this._handleDrop,this));jQuery(document.getElementById(t+e+"ImageHolder")).on("dragover",jQuery.proxy(this._handleDragover,this)).on("dragend",jQuery.proxy(this._handleDragend,this)).on("drop",jQuery.proxy(this._handleDrop,this))}};m.prototype._unbindDragAndDrop=function(e){if(window.FileReader){var t=this.shell.getId()+"-p13n_";jQuery(document.getElementById(t+"hdrImageImg")).off("dragover",this._handleDragover).off("dragend",this._handleDragend).off("drop",this._handleDrop);jQuery(document.getElementById(t+"hdrImageHolder")).off("dragover",this._handleDragover).off("dragend",this._handleDragend).off("drop",this._handleDrop)}};m.prototype._getDialog=function(){if(!this.oDialog){var e=this.shell.getId()+"-p13n_";var t=Object.assign({},m.getOriginalSettings(),this.oSettings);var i=sap.ui.commons;var o=this;var n=new i.Dialog({title:"Shell Personalization",width:"544px",height:"560px",showCloseButton:false,resizable:false,closed:[function(){this._unbindDragAndDrop("bg");this._unbindDragAndDrop("hdr");this._unbindDragAndDrop("logo");this.oTransientSettings=null},this]}).addStyleClass("sapUiUx3ShellP13n");var r=new i.TabStrip({width:"100%",height:"100%",select:jQuery.proxy(function(e){var t=sap.ui.getCore().byId(e.getParameter("id"));if(t){var i=e.getParameter("index");t.setSelectedIndex(i);var o=this;if(i==0){window.setTimeout(function(){o.shell.$("bgColor").css("background-color",o.getTransientSettingsWithDefaults().sBgColor)},1);window.setTimeout(jQuery.proxy(function(){this._bindDragAndDrop("bg")},this),0)}else if(i==1){window.setTimeout(function(){o.shell.$("lineColor").css("background-color",o.getTransientSettingsWithDefaults().sLineColor)},1);window.setTimeout(jQuery.proxy(function(){this._bindDragAndDrop("hdr")},this),0)}else if(i==2){window.setTimeout(jQuery.proxy(function(){this._bindDragAndDrop("logo")},this),0)}}},this)});this.oBgImgHtml=new a(e+"bgImageHolder",{preferDOM:true,content:"<div id='"+e+"bgImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='"+e+"bgImageImg' src='"+(this.oTransientSettings.sBackgroundImageSrc?d(this.oTransientSettings.sBackgroundImageSrc):sap.ui.resource("sap.ui.core","themes/base/img/1x1.gif"))+"'></div>"});this.oBgImgOpacitySlider=new i.Slider({value:this.oTransientSettings.fBgImgOpacity!==undefined?100-this.oTransientSettings.fBgImgOpacity*100:100-m.getOriginalSettings().fBgImgOpacity*100,liveChange:jQuery.proxy(this._handleBgImageOpacitySliderChange,this)});this.oSidebarOpacitySlider=new i.Slider({value:this.oTransientSettings.fSidebarOpacity!==undefined?100-this.oTransientSettings.fSidebarOpacity*100:100-m.getOriginalSettings().fSidebarOpacity*100,liveChange:jQuery.proxy(this._handleSidebarOpacitySliderChange,this)});this.oBgColorPicker=new s(e+"bgColorPicker");this.oBgColorPicker.attachLiveChange(function(e){o._handleBgColorChange(e)});var h=new i.Button({text:"Change..."});var o=this;h.attachPress(function(){if(!o.oBgColorPicker.isOpen()){o.oBgColorPicker.open(s.parseCssRgbString(o.getTransientSettingsWithDefaults().sBgColor),c.BeginTop,c.BeginBottom,o.shell.getDomRef("bgColor"))}});this.oBgPreviewHtml=new a({preferDom:true,content:"<div id='"+this.shell.getId()+"-bgColor' style='background-color:"+d(t.sBgColor)+"' class='sapUiUx3ShellColorPickerPreview'></div>"});var p=(new g).setText("Background").addContent(new i.layout.MatrixLayout({layoutFixed:false}).createRow(new i.Label({text:"Background Image:"}),this.oBgImgHtml).createRow(new i.Label({text:"Image Transparency:"}),this.oBgImgOpacitySlider).createRow(new i.Label({text:"Background Color:"}),(new i.layout.MatrixLayoutCell).addContent(this.oBgPreviewHtml).addContent(h)).createRow(null).createRow(new i.Label({text:"Sidebar Transparency:"}),this.oSidebarOpacitySlider));r.addTab(p);this.oByDStyleCb=new i.CheckBox({text:"ByDesign-style Header Bar",checked:this.oTransientSettings.bByDStyle,change:jQuery.proxy(this._handleByDStyleChange,this)});this.oHdrImgHtml=new a(e+"hdrImageHolder",{preferDOM:true,content:"<div id='"+e+"hdrImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='"+e+"hdrImageImg' src='"+(this.oTransientSettings.sHeaderImageSrc?d(this.oTransientSettings.sHeaderImageSrc):sap.ui.resource("sap.ui.core","themes/base/img/1x1.gif"))+"'></div>"});this.oLineColorPicker=new s(e+"lineColorPicker");this.oLineColorPicker.attachLiveChange(function(e){o._handleLineColorChange(e)});var u=new i.Button({text:"Change..."});var o=this;u.attachPress(function(){if(!o.oLineColorPicker.isOpen()){o.oLineColorPicker.open(s.parseCssRgbString(o.getTransientSettingsWithDefaults().sLineColor),c.BeginTop,c.BeginBottom,o.shell.getDomRef("lineColor"))}});this.oLinePreviewHtml=new a({preferDom:true,content:"<div id='"+this.shell.getId()+"-lineColor' style='background-color:"+d(t.sLineColor)+"' class='sapUiUx3ShellColorPickerPreview'></div>"});var S=(new g).setText("Header Bar").addContent(new i.layout.MatrixLayout({layoutFixed:false}).createRow(new i.Label({text:"Line Color (ByD-style only):"}),(new i.layout.MatrixLayoutCell).addContent(this.oLinePreviewHtml).addContent(u)).createRow(null).createRow(new i.Label({text:"Header Image:"}),this.oHdrImgHtml));r.addTab(S);this.oLogoImgHtml=new a(e+"logoImageHolder",{preferDOM:true,content:"<div id='"+e+"logoImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='"+e+"logoImageImg' src='"+(this.oTransientSettings.sLogoImageSrc?d(this.oTransientSettings.sLogoImageSrc):sap.ui.resource("sap.ui.core","themes/base/img/1x1.gif"))+"'></div>"});this.oLogoRbg=(new i.RadioButtonGroup).addItem(new l({text:"Left",key:"left"})).addItem(new l({text:"Center",key:"center"})).attachSelect(this._handleLogoAlignChange,this);this.oUseLogoSizeCb=new i.CheckBox({text:"Use original image size",checked:this.oTransientSettings.bUseLogoSize,change:jQuery.proxy(this._handleUseLogoSizeChange,this)});var y=(new g).setText("Logo").addContent(new i.layout.MatrixLayout({layoutFixed:false}).createRow(new i.Label({text:"Logo Image:"}),this.oLogoImgHtml).createRow(new i.Label({text:"Position:"}),this.oLogoRbg).createRow(this.oUseLogoSizeCb));r.addTab(y);n.addContent(r);var o=this;n.addButton(new i.Button({text:"Reset All",press:function(){o.applySettings(Object.assign({},m.getOriginalSettings()));o.oSettings={};o.oTransientSettings={};o.updateDialog();o._bindDragAndDrop("bg");o._bindDragAndDrop("hdr");o._bindDragAndDrop("logo");o.firePersonalizationChange({settings:{}})}}));n.addButton(new i.Button({text:"OK",press:function(){o.oSettings=Object.assign({},o.oTransientSettings);o.firePersonalizationChange({settings:o.oSettings});n.close()}}));n.addButton(new i.Button({text:"Cancel",press:function(){n.close()}}));this.oDialog=n}return this.oDialog};m.prototype.updateDialog=function(){var e=Object.assign({},m.getOriginalSettings(),this.oSettings);var t=this.shell.getId()+"-p13n_";this.oBgImgHtml.setContent("<div id='"+t+"bgImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='"+t+"bgImageImg' src='"+(e.sBackgroundImageSrc?d(e.sBackgroundImageSrc):sap.ui.resource("sap.ui.core","themes/base/img/1x1.gif"))+"'></div>");this.oBgImgOpacitySlider.setValue(100-e.fBgImgOpacity*100);this.oSidebarOpacitySlider.setValue(100-e.fSidebarOpacity*100);this.oByDStyleCb.setChecked(e.bByDStyle);this.oHdrImgHtml.setContent("<div id='"+t+"hdrImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='"+t+"hdrImageImg' src='"+(e.sHeaderImageSrc?d(e.sHeaderImageSrc):sap.ui.resource("sap.ui.core","themes/base/img/1x1.gif"))+"'></div>");this.oLogoRbg.setSelectedIndex(e.sLogoAlign=="center"?1:0);this.oUseLogoSizeCb.setChecked(e.bUseLogoSize);this.oLogoImgHtml.setContent("<div id='"+t+"logoImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='"+t+"logoImageImg' src='"+(e.sLogoImageSrc?d(e.sLogoImageSrc):sap.ui.resource("sap.ui.core","themes/base/img/1x1.gif"))+"'></div>")};m.prototype._handleByDStyleChange=function(e){var t=e.getParameter("checked");this.oTransientSettings.bByDStyle=t;this.applyByDStyle(t)};m.prototype.applyByDStyle=function(e){this.shell.$().toggleClass("sapUiUx3ShellByD",e)};m.prototype._handleBgColorChange=function(e){var t=e.getParameter("cssColor");this.oTransientSettings.sBgColor=t;this.applyBgColor(t)};m.prototype.applyBgColor=function(e){this.shell.$("bg").css("background-color",e);this.shell.$("bgColor").css("background-color",e)};m.prototype._handleBackgroundImageChange=function(e,t){var i=true;if(t){if(i){this.oSettings.sBgCssImg="url("+e+")";this.oSettings.sBgImgSrc=null}else{this.oSettings.sBgCssImg=null;this.oSettings.sBgImgSrc=e}this.applyBgImage(this.oSettings.sBgCssImg,this.oSettings.sBgImgSrc);this.firePersonalizationChange({settings:this.oSettings})}else{if(i){this.oTransientSettings.sBgCssImg="url("+e+")";this.oTransientSettings.sBgImgSrc=null}else{this.oTransientSettings.sBgCssImg=null;this.oTransientSettings.sBgImgSrc=e}this.applyBgImage(this.oTransientSettings.sBgCssImg,this.oTransientSettings.sBgImgSrc)}};m.prototype.applyBgImage=function(e,t){e=e?e:"";t=t?t:m.TRANSPARENT_1x1;var i=this.shell.getDomRef("bgImg");i.style.backgroundImage=e;i.src=t};m.prototype._handleHeaderImageChange=function(e,t){if(t){this.oSettings.sHeaderImageSrc=e;this.firePersonalizationChange({settings:this.oSettings})}else{this.oTransientSettings.sHeaderImageSrc=e}this.applyHeaderImage(e)};m.prototype.applyHeaderImage=function(e){this.shell.$("hdr").css("background-image","url("+e+")");if(this.oDialog&&this.oDialog.isOpen()){this.shell.$("p13n_hdrImageImg").attr("src",e)}};m.prototype._handleLineColorChange=function(e){var t=e.getParameter("cssColor");this.oTransientSettings.sLineColor=t;this.applyLineColor(t)};m.prototype.applyLineColor=function(e){this.shell.$("hdr").find("hr").css("background-color",e);this.shell.$("lineColor").css("background-color",e)};m.prototype._handleBgImageOpacitySliderChange=function(e){var t=(100-e.getParameter("value"))/100;this.oTransientSettings.fBgImgOpacity=t;this.applyBgImageOpacity(t)};m.prototype.applyBgImageOpacity=function(e){this.shell.$("bgImg").css("opacity",e)};m.prototype._handleSidebarOpacitySliderChange=function(e){var t=(100-e.getParameter("value"))/100;this.oTransientSettings.fSidebarOpacity=t;this.applySidebarOpacity(t)};m.prototype.applySidebarOpacity=function(e){this.shell.$("tp").css("opacity",e);this.shell.$("paneBar").children(":nth-child(2)").css("opacity",e)};m.prototype._handleLogoImageChange=function(e,t){if(t){this.oSettings.sLogoImageSrc=e;this.firePersonalizationChange({settings:this.oSettings})}else{this.oTransientSettings.sLogoImageSrc=e}this.applyLogoImage(e)};m.prototype.applyLogoImage=function(e){if(!e){e=this.shell.getAppIcon();if(!e){e=m.TRANSPARENT_1x1}}this.shell.$("logoImg").attr("src",e);this.shell.$("p13n_logoImageImg").attr("src",e)};m.prototype._handleLogoAlignChange=function(e){var t=e.getParameter("selectedIndex");var i=["left","center"][t];this.oTransientSettings.sLogoAlign=i;this.applyLogoAlign(i)};m.prototype.applyLogoAlign=function(e){var t=e;if(p.getRTL()&&t=="right"){t="left"}this.shell.$("hdr").css("text-align",t)};m.prototype._handleUseLogoSizeChange=function(e){var t=e.getParameter("checked");this.oTransientSettings.bUseLogoSize=t;this.applyUseLogoSize(t)};m.prototype.applyUseLogoSize=function(e){this.shell.$("hdr").toggleClass("sapUiUx3ShellHeaderFlex",e);this.shell.$("hdrImg").toggleClass("sapUiUx3ShellHeaderImgFlex",e)};m.prototype._handleDragover=function(e){var t=e.target.id;if(!this._dragOverBlinking){var i=jQuery(document.getElementById(t));i.css("opacity","0.5");this._dragOverBlinking=true;var o=this;window.setTimeout(function(){i.css("opacity","1");window.setTimeout(function(){o._dragOverBlinking=null},250)},250)}return false};m.prototype._handleDragend=function(e){return false};m.prototype._handleDrop=function(e){var t=e.target.id;e.preventDefault();var i=e.originalEvent;var o=i.dataTransfer.files[0];if(o){var s=new window.FileReader;s.onload=jQuery.proxy(function(e){var i=e.target.result;if(t==this.shell.getId()+"-p13n_bgImageImg"||t==this.shell.getId()+"-p13n_bgImageHolder"){this._handleBackgroundImageChange(i)}else if(t==this.shell.getId()+"-p13n_hdrImageImg"||t==this.shell.getId()+"-p13n_hdrImageHolder"){this._handleHeaderImageChange(i)}else if(t==this.shell.getId()+"-p13n_logoImageImg"||t==this.shell.getId()+"-p13n_logoImageHolder"){this._handleLogoImageChange(i)}s=null},this);s.readAsDataURL(o)}};return m});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/ShellRenderer", ["sap/ui/core/IconPool","sap/ui/core/theming/Parameters","sap/base/security/encodeXML","sap/ui/core/Configuration"],function(e,t,a,i){"use strict";var r;var s={};s.render=function(e,a){r=r||sap.ui.require("sap/ui/ux3/Shell");var l=a.isPaneOpen();var o=a.getPaneWidth()+r.SIDE_BAR_BASE_WIDTH;var n=i.getRTL();var d=a.getId();if(r.FIRST_RENDERING){document.body.style.margin="0"}e.write("<div");e.writeControlData(a);e.addClass("sapUiUx3Shell");e.addClass("sapUiUx3ShellHead"+a.getHeaderType());e.addClass("sapUiUx3ShellDesign"+a.getDesignType());if(!a._hasDarkDesign()){e.addClass("sapUiUx3ShellDesignLight")}if(a.getFullHeightContent()){e.addClass("sapUiUx3ShellFullHeightContent")}if(!a.getApplyContentPadding()){e.addClass("sapUiUx3ShellNoContentPadding")}if(!a.getShowTools()){e.addClass("sapUiUx3ShellNoTools")}if(!a.getShowPane()){e.addClass("sapUiUx3ShellNoPane")}if(a._topSyncRefId&&!a.getAllowOverlayHeaderAccess()){e.addClass("sapUiUx3ShellBlockHeaderAccess")}e.writeClasses();e.write(">");e.write("<img id='"+d+"-hdrImg' class='sapUiUx3ShellHeaderImg' src='");var p=t._getThemeImage("sapUiUx3ShellHeaderImageURL",true);e.writeEscaped(p);e.write("'>");e.write("<header id='"+d+"-hdr' class='sapUiUx3ShellHeader' role='banner'>");var c=a._topSyncRefId?" tabindex='0'":"";e.write("<span class='sapUiUx3ShellFocusDummy' id='"+d+"-focusDummyHdrStart'"+c+"></span>");s.renderHeader(e,a);e.write("<span class='sapUiUx3ShellFocusDummy' id='"+d+"-focusDummyHdrEnd'"+c+"></span>");e.write("</header>");e.write("<div id='",d,"-bg' class='sapUiUx3ShellBg'></div>");e.write("<img id='",d,"-bgImg' class='sapUiUx3ShellBgImg' src='");p=t._getThemeImage("sapUiUx3ShellBackgroundImageURL",true);e.writeEscaped(p);e.write("'>");var g=l?" style='margin-"+(n?"left":"right")+":"+(o+22)+"px'":"";e.write("<div id='",d,"-wBar'"+g+" class='sapUiUx3ShellWorksetBar'>");s.renderWorksetItems(e,a);e.write("</div>");e.write("<section id='"+d+"-tp' class='sapUiUx3ShellToolPaletteArea' role='complementary' data-sap-ui-fastnavgroup='true'>");s.renderToolPalette(e,a);e.write("</section>");var U=l?" style='"+(n?"left":"right")+":"+o+"px'":"";e.write("<div class='sapUiUx3ShellCanvas'"+U+" id='"+d+"-canvas'>");s.renderFacetBar(e,a);e.write("<article class='sapUiUx3ShellContent' id='"+d+"-content' role='main' data-sap-ui-fastnavgroup='true'>");var u=a.getContent();for(var w=0;w<u.length;w++){e.renderControl(u[w])}e.write("</article><div class='sapUiUx3ShellNotifySpace'></div></div>");var c=a._topSyncRefId?" tabindex='0'":"";e.write("<span class='sapUiUx3ShellFocusDummy' id='"+d+"-focusDummyPane'"+c+"></span>");e.write("<aside id='"+d+"-paneBar' class='sapUiUx3ShellPaneBar "+(l?" sapUiUx3ShellPaneBarOpen sapUiUx3ShellPaneBarOpened":" sapUiUx3ShellPaneBarClose")+"' role='complementary' style='width:"+o+"px;'>");e.write("<section id='"+d+"-paneContent' style='width:"+a.getPaneWidth()+"px;' class='sapUiUx3ShellPaneBarContent' role='tabpanel'>");var h=a.getPaneContent();for(var w=0;w<h.length;w++){e.renderControl(h[w])}e.write("</section>");e.write("<div id='"+d+"-paneBarRight' class='sapUiUx3ShellPaneBarRight' data-sap-ui-fastnavgroup='true'>");e.write("<ul id='"+d+"-paneBarEntries' class='sapUiUx3ShellPaneEntries' role='tablist'>");s.renderPaneBarItems(e,a);e.write("</ul>");e.write("<div id='"+d+"-paneBarOverflowButton' class='sapUiUx3ShellPaneOverflowButton'");e.addStyle("display","none;");e.writeStyles();e.write(">");e.write("<div id='"+d+"-paneBarOverflowWrapper' class='sapUiUx3ShellPaneOverflowWrapper'>");e.write("<span id='"+d+"-paneBarOverflowText' class='sapUiUx3ShellPaneOverflowText sapUiUx3ShellPaneEntry'>");e.write(sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3").getText("SHELL_MORE_BUTTON"));e.write("</span>");e.write("</div>");e.write("</div>");e.write("</div>");e.write("</aside>");e.write("<div class='sapUiUx3ShellCanvasBackground "+(l?"sapUiUx3ShellCanvasBackgroundOpen":"sapUiUx3ShellCanvasBackgroundClosed")+"' id='"+d+"-canvasBackground'"+U+">");e.write("<div class='sapUiUx3ShellCanvasBackgroundRight'></div>");e.write("</div>");e.write("<div id='"+d+"-notify' class='sapUiUx3ShellNotify'>");s.renderNotificationArea(e,a);e.write("</div>");e.write("</div>")};s.renderHeader=function(e,i){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");var s=i.getAppIcon();e.write("<hr id='"+i.getId()+"-hdrLine'>");e.write("<span id='"+i.getId()+"-hdr-items' class='sapUiUx3ShellHeaderTitleRight'>");var l=i.getHeaderItems();for(var o=0;o<l.length;o++){if(l[o]instanceof sap.ui.commons.MenuButton){if(l[o].getMenu()){l[o].getMenu().addStyleClass("sapUiMnuTop",true)}}e.renderControl(l[o]);if(o<l.length-1||i.getShowLogoutButton()){e.write("<span class='sapUiUx3ShellHeaderSep'></span>")}}if(i.getShowLogoutButton()){e.write("<a id='"+i.getId()+"-logout' title='");e.write(i.getLogoutButtonTooltip()?a(i.getLogoutButtonTooltip()):r.getText("SHELL_LOGOUT"));e.write("' tabindex='0' role='button' class='sapUiUx3ShellHeaderButton sapUiUx3ShellHeader-logout'></a>")}e.write("</span>");e.write("<span class='sapUiUx3ShellHeaderTitleLeft' ");e.writeAttributeEscaped("title",i.getAppTitle());e.write(">");e.write("<img id='"+i.getId()+"-logoImg' src='");if(s){e.writeEscaped(i.getAppIcon())}else{var n=t._getThemeImage("sapUiUx3ShellApplicationImageURL",true);e.writeEscaped(n)}e.write("'");var d=i.getAppIconTooltip()||r.getText("SHELL_LOGO");e.writeAttributeEscaped("alt",d);e.writeAttributeEscaped("title",d);e.write(">");e.write("<span>");e.writeEscaped(i.getAppTitle());e.write("</span>");e.write("</span>")};s.renderToolPalette=function(t,a){var i=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");var s=a.getId();var l=a._topSyncRefId?" tabindex='0'":"";t.write("<span class='sapUiUx3ShellFocusDummy' id='"+a.getId()+"-focusDummyTPStart'"+l+"></span>");var o=i.getText("SHELL_TOOLPANE_GENERIC"),n=false,d=true,p="";if(a.getShowSearchTool()){n=true;p+="<a id='"+s+r.TOOL_PREFIX+s+"-searchTool' title='"+i.getText("SHELL_SEARCH")+"' class='sapUiUx3ShellTool sapUiUx3ShellTool-search' tabindex='0' role='button' aria-pressed='false'></a>";if(d){d=false}else{o+=","}o+=" "+i.getText("SHELL_SEARCH")}if(a.getShowFeederTool()){n=true;p+="<a id='"+s+r.TOOL_PREFIX+s+"-feederTool' title='"+i.getText("SHELL_FEEDER")+"' class='sapUiUx3ShellTool sapUiUx3ShellTool-feeder' tabindex='0' role='button' aria-pressed='false'></a>";if(d){d=false}else{o+=","}o+=" "+i.getText("SHELL_FEEDER")}if(n){t.write("<div role='toolbar'aria-describedby='"+s+"-genericToolsDescr'>");t.write("<span id='"+s+"-genericToolsDescr' style='display:none;'>"+o+"</span>");t.write(p+"</div>")}var c=a.getToolPopups();if(n&&c.length>0){t.write("<hr id='"+s+"-tp-separator' class='sapUiUx3ShellToolSep'>")}if(c.length>0){t.write("<div role='toolbar' aria-describedby='"+s+"-appToolsDescr'>");t.write("<span id='"+s+"-appToolsDescr' style='display:none;'>"+i.getText("SHELL_TOOLPANE_APP")+"</span>");for(var g=0;g<c.length;g++){var U=c[g];if(U instanceof sap.ui.core.SeparatorItem){t.write("<hr class='sapUiUx3ShellToolSep'>")}else{t.write("<a id='"+s+"-tool-"+U.getId()+"' class='sapUiUx3ShellTool'");var u=U.getTooltip_AsString();if(!u){u=U.getTitle()}if(u){t.write(" title='");t.writeEscaped(u);t.write("' ")}t.write(" tabindex='0' role='button' aria-pressed='false'>");var w=U.getIcon();if(e.isIconURI(w)){t.writeIcon(w,["sapUiUx3ShellToolFontIcon"],{title:null,"aria-label":null})}else{t.write("<img src='");t.writeEscaped(w);t.write("' alt='' role='presentation'>")}t.write("</a>")}}t.write("</div>")}t.write("<span class='sapUiUx3ShellFocusDummy' id='"+a.getId()+"-focusDummyTPEnd'"+l+"></span>")};s.renderPaneBarItems=function(e,t){var a=t.getId();var i=t.getPaneBarItems();var r=i.length;for(var s=0;s<r;s++){var l=i[s];var o=l.getId();e.write("<li");e.writeElementData(l);e.write(" role='tab' aria-controls='"+a+"-paneContent' aria-setsize='"+r+"' aria-posinset='"+(s+1)+"' tabindex='-1' class='sapUiUx3ShellPaneEntry");if(t._sOpenPaneId===o){e.write(" sapUiUx3ShellPaneEntrySelected")}e.write("'");if(l.getTooltip_AsString()){e.writeAttributeEscaped("title",l.getTooltip_AsString())}e.write(">");e.writeEscaped(l.getText().toUpperCase());e.write("</li>")}};s.renderNotificationArea=function(e,t){e.write("<div class='sapUiUx3ShellNotifyBG'></div>");if(t.getNotificationBar()){e.renderControl(t.getNotificationBar())}};s.renderWorksetItems=function(e,t){var a=t.getWorksetItems();t._oWorksetBar.setAssociatedItems(a);if(!t._oWorksetBar.isSelectedItemValid()&&a.length>0){t.setAssociation("selectedWorksetItem",a[0],true);t._oWorksetBar.setSelectedItem(a[0])}if(e){e.renderControl(t._oWorksetBar)}};s.renderFacetBar=function(e,t){var a=sap.ui.getCore().byId(t.getSelectedWorksetItem());if(a){var i=a.getParent();if(i&&i instanceof sap.ui.ux3.NavigationItem){a=i}var r=a.getSubItems();t._oFacetBar.setAssociatedItems(r);if(!t._oFacetBar.isSelectedItemValid()&&r.length>0){t._oFacetBar.setSelectedItem(r[0])}}if(e){e.renderControl(t._oFacetBar)}};return s},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/ThingAction", ["sap/ui/core/Element","./library"],function(e){"use strict";var t=e.extend("sap.ui.ux3.ThingAction",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{text:{type:"string",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Misc",defaultValue:true}},events:{select:{parameters:{id:{type:"string"},action:{type:"sap.ui.ux3.ThingAction"}}}}}});t.prototype.onclick=function(e){this.fireSelect({id:this.getId(),action:this})};t.prototype.onsapselect=function(e){this.fireSelect({id:this.getId(),action:this})};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/ThingGroup", ["sap/ui/core/Element","./library"],function(e){"use strict";var t=e.extend("sap.ui.ux3.ThingGroup",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{title:{type:"string",group:"Misc",defaultValue:null},colspan:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},actions:{type:"sap.ui.ux3.ThingGroup",multiple:true,singularName:"action"}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/ThingInspector", ["./ActionBar","./Overlay","./ThingViewer","./ThingInspectorRenderer","./library","./ThingAction","sap/ui/dom/jquery/Selectors","sap/ui/dom/jquery/Focusable"],function(t,e,i,o,n,r){"use strict";var s=n.ActionBarSocialActions;var a=n.ThingViewerHeaderType;var c=n.FollowActionState;var u=e.extend("sap.ui.ux3.ThingInspector",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{firstTitle:{type:"string",group:"Misc",defaultValue:null},type:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},secondTitle:{type:"string",group:"Misc",defaultValue:null},followState:{type:"sap.ui.ux3.FollowActionState",group:"Misc",defaultValue:c.Default},flagState:{type:"boolean",group:"Misc",defaultValue:false},favoriteState:{type:"boolean",group:"Misc",defaultValue:false},favoriteActionEnabled:{type:"boolean",group:"Misc",defaultValue:true},updateActionEnabled:{type:"boolean",group:"Misc",defaultValue:true},followActionEnabled:{type:"boolean",group:"Misc",defaultValue:true},flagActionEnabled:{type:"boolean",group:"Misc",defaultValue:true},headerType:{type:"sap.ui.ux3.ThingViewerHeaderType",group:"Misc",defaultValue:a.Standard}},aggregations:{actions:{type:"sap.ui.ux3.ThingAction",multiple:true,singularName:"action"},headerContent:{type:"sap.ui.ux3.ThingGroup",multiple:true,singularName:"headerContent"},facets:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"facet"},facetContent:{type:"sap.ui.ux3.ThingGroup",multiple:true,singularName:"facetContent"},actionBar:{type:"sap.ui.ux3.ActionBar",multiple:false},thingViewer:{type:"sap.ui.ux3.ThingViewer",multiple:false,visibility:"hidden"}},associations:{selectedFacet:{type:"sap.ui.ux3.NavigationItem",multiple:false}},events:{actionSelected:{parameters:{id:{type:"string"},action:{type:"sap.ui.ux3.ThingAction"}}},facetSelected:{allowPreventDefault:true,parameters:{id:{type:"string"},item:{type:"sap.ui.ux3.NavigationItem"},key:{type:"string"}}},feedSubmit:{parameters:{text:{type:"string"}}}}}});u.prototype.init=function(){var o,n=this;e.prototype.init.apply(this);this._oThingViewer=new i(this.getId()+"-thingViewer");this.setAggregation("thingViewer",this._oThingViewer);this._oThingViewer.attachFacetSelected(function(t){var e=t.getParameters().item;if(n.fireFacetSelected({id:e.getId(),key:e.getKey(),item:e})){n.setSelectedFacet(e)}else{t.preventDefault()}});this._oSocialActions={};if(this.getActionBar()==null){o=new t(this.getId()+"-actionBar");o.setShowOpen(false);o.setAlwaysShowMoreMenu(false);o.setDividerWidth("252px");o.attachActionSelected(function(t){var e=t.getParameters().id,i=t.getParameters().action,o;if(e.indexOf(s.Favorite)!==-1||e.indexOf(s.Follow)!==-1||e.indexOf(s.Flag)!==-1){if(n._oSocialActions[e]){o=n._oSocialActions[e]}else{o=new r({id:n.getId()+"-"+e.toLowerCase(),text:i.text,enabled:i.enabled});n._oSocialActions[e]=o}n.fireActionSelected({id:e.toLowerCase(),action:o})}else{n.fireActionSelected({id:t.getParameters().id,action:t.getParameters().action})}});o.attachFeedSubmit(function(t){n.fireFeedSubmit({text:t.getParameters().text})});this.setActionBar(o)}};u.prototype.onAfterRendering=function(){e.prototype.onAfterRendering.apply(this,arguments);var t=this._getShell();this._bShell=!!t;if(!t){this._applyChanges({showOverlay:false})}};u.prototype.onBeforeRendering=function(){e.prototype.onBeforeRendering.apply(this,arguments)};u.prototype.exit=function(){this._oThingViewer.exit(arguments);this._oThingViewer.destroy();this._oThingViewer=null;e.prototype.exit.apply(this,arguments)};u.prototype.open=function(t){if(this.getDomRef()){this.rerender()}e.prototype.open.apply(this,arguments);this._selectDefault()};u.prototype._getNavBar=function(){return this._oThingViewer._oNavBar};u.prototype._selectDefault=function(){this._oThingViewer._selectDefault()};u.prototype._equalColumns=function(){this._oThingViewer._equalColumns()};u.prototype._setTriggerValue=function(){this._oThingViewer._setTriggerValue()};u.prototype._setFocusLast=function(){var t=this.$("thingViewer-toolbar").lastFocusableDomRef();if(!t&&this.getCloseButtonVisible()&&this.$("close").is(":sapFocusable")){t=this.getDomRef("close")}else if(!t&&this.getOpenButtonVisible()&&this.$("openNew").is(":sapFocusable")){t=this.getDomRef("openNew")}if(t){t.focus()}};u.prototype._setFocusFirst=function(){if(this.getOpenButtonVisible()&&this.$("openNew").is(":sapFocusable")){if(this.getDomRef("openNew")){this.getDomRef("openNew").focus()}}else if(this.getCloseButtonVisible()&&this.$("close").is(":sapFocusable")){if(this.getDomRef("close")){this.getDomRef("close").focus()}}else{if(this.$("thingViewer-content").firstFocusableDomRef()){this.$("thingViewer-content").firstFocusableDomRef().focus()}}};u.prototype.insertAction=function(t,e){if(this.getActionBar()){this.getActionBar().insertBusinessAction(t,e)}return this};u.prototype.addAction=function(t){if(this.getActionBar()){this.getActionBar().addBusinessAction(t)}return this};u.prototype.removeAction=function(t){var e;if(this.getActionBar()){e=this.getActionBar().removeBusinessAction(t)}return e};u.prototype.removeAllActions=function(){var t;if(this.getActionBar()){t=this.getActionBar().removeAllBusinessActions()}return t};u.prototype.getActions=function(){var t;if(this.getActionBar()){t=this.getActionBar().getBusinessActions()}return t};u.prototype.destroyActions=function(){if(this.getActionBar()){this.getActionBar().destroyBusinessActions()}return this};u.prototype.indexOfAction=function(t){var e=-1;if(this.getActionBar()){e=this.getActionBar().indexOfBusinessAction(t)}return e};u.prototype.getFacets=function(){return this._oThingViewer.getFacets()};u.prototype.insertFacet=function(t,e){this._oThingViewer.insertFacet(t,e);return this};u.prototype.addFacet=function(t){this._oThingViewer.addFacet(t);return this};u.prototype.removeFacet=function(t){return this._oThingViewer.removeFacet(t)};u.prototype.removeAllFacets=function(){return this._oThingViewer.removeAllFacets()};u.prototype.destroyFacets=function(){this._oThingViewer.destroyFacets();return this};u.prototype.indexOfFacet=function(t){return this._oThingViewer.indexOfFacet(t)};u.prototype.setFollowState=function(t){if(this.getActionBar()){this.getActionBar().setFollowState(t)}return this};u.prototype.getFollowState=function(){var t=null;if(this.getActionBar()){t=this.getActionBar().getFollowState()}return t};u.prototype.setFlagState=function(t){if(this.getActionBar()){this.getActionBar().setFlagState(t)}return this};u.prototype.getFlagState=function(){var t=null;if(this.getActionBar()){t=this.getActionBar().getFlagState()}return t};u.prototype.setFavoriteState=function(t){if(this.getActionBar()){this.getActionBar().setFavoriteState(t)}return this};u.prototype.getFavoriteState=function(){var t=null;if(this.getActionBar()){t=this.getActionBar().getFavoriteState()}return t};u.prototype.setIcon=function(t){this._oThingViewer.setIcon(t);if(this.getActionBar()){this.getActionBar().setThingIconURI(t)}return this};u.prototype.getIcon=function(){return this._oThingViewer.getIcon()};u.prototype.setType=function(t){this._oThingViewer.setType(t);return this};u.prototype.getType=function(){return this._oThingViewer.getType()};u.prototype.insertFacetContent=function(t,e){this._oThingViewer.insertFacetContent(t,e);return this};u.prototype.addFacetContent=function(t){this._oThingViewer.addFacetContent(t);return this};u.prototype.removeFacetContent=function(t){var e=this._oThingViewer.removeFacetContent(t);return e};u.prototype.removeAllFacetContent=function(){var t=this._oThingViewer.removeAllFacetContent();return t};u.prototype.destroyFacetContent=function(){this._oThingViewer.destroyFacetContent();return this};u.prototype.getFacetContent=function(){return this._oThingViewer.getFacetContent()};u.prototype.indexOfFacetContent=function(t){return this._oThingViewer.indexOfFacetContent(t)};u.prototype.setActionBar=function(t){this._oThingViewer.setActionBar(t);return this};u.prototype.getActionBar=function(){return this._oThingViewer.getActionBar()};u.prototype.destroyActionBar=function(){this._oThingViewer.destroyActionBar();return this};u.prototype.insertHeaderContent=function(t,e){this._oThingViewer.insertHeaderContent(t,e);return this};u.prototype.addHeaderContent=function(t){this._oThingViewer.addHeaderContent(t);return this};u.prototype.getHeaderContent=function(){return this._oThingViewer.getHeaderContent()};u.prototype.removeHeaderContent=function(t){var e=this._oThingViewer.removeHeaderContent(t);return e};u.prototype.removeAllHeaderContent=function(){var t=this._oThingViewer.removeAllHeaderContent();return t};u.prototype.destroyHeaderContent=function(){this._oThingViewer.destroyHeaderContent();return this};u.prototype.indexOfHeaderContent=function(t){return this._oThingViewer.indexOfHeaderContent(t)};u.prototype.setSelectedFacet=function(t){this._oThingViewer.setSelectedFacet(t);return this};u.prototype.getSelectedFacet=function(t){return this._oThingViewer.getSelectedFacet()};u.prototype.setFavoriteActionEnabled=function(t){if(this.getActionBar()){this.getActionBar().setShowFavorite(t)}return this};u.prototype.getFavoriteActionEnabled=function(){var t;if(this.getActionBar()){t=this.getActionBar().getShowFavorite()}return t};u.prototype.setFlagActionEnabled=function(t){if(this.getActionBar()){this.getActionBar().setShowFlag(t)}return this};u.prototype.getFlagActionEnabled=function(){var t;if(this.getActionBar()){t=this.getActionBar().getShowFlag()}return t};u.prototype.setUpdateActionEnabled=function(t){if(this.getActionBar()){this.getActionBar().setShowUpdate(t)}return this};u.prototype.getUpdateActionEnabled=function(){var t;if(this.getActionBar()){t=this.getActionBar().getShowUpdate()}return t};u.prototype.setFollowActionEnabled=function(t){if(this.getActionBar()){this.getActionBar().setShowFollow(t)}return this};u.prototype.getFollowActionEnabled=function(){var t;if(this.getActionBar()){t=this.getActionBar().getShowFollow()}return t};u.prototype.setFirstTitle=function(t){this._oThingViewer.setTitle(t);return this};u.prototype.getFirstTitle=function(){return this._oThingViewer.getTitle()};u.prototype.setSecondTitle=function(t){this._oThingViewer.setSubtitle(t);return this};u.prototype.getSecondTitle=function(){return this._oThingViewer.getSubtitle()};u.prototype.setHeaderType=function(t){this._oThingViewer.setHeaderType(t);return this};u.prototype.getHeaderType=function(){var t=this._oThingViewer.getHeaderType();return t};u.prototype._applyChanges=function(t){this.oChanges=t;if(t.showOverlay){this.$().removeClass("sapUiUx3TINoFrame")}else{this.$().addClass("sapUiUx3TINoFrame")}return this};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/ThingInspectorRenderer", ["sap/ui/core/Renderer","./OverlayRenderer"],function(e,n){"use strict";var r=e.extend(n);r.renderContent=function(e,n){e.write("<div role='Main' class='sapUiUx3TIContent' id='"+n.getId()+"-content'>");e.renderControl(n._oThingViewer);e.write("</div>")};r.addRootClasses=function(e,n){e.addClass("sapUiUx3TI")};r.addOverlayClasses=function(e,n){e.addClass("sapUiUx3TIOverlay")};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/ThingViewer", ["sap/ui/thirdparty/jquery","sap/ui/core/Control","./ThingViewerRenderer","./library","./NavigationBar","sap/ui/core/ResizeHandler"],function(jQuery,e,t,r,i,n){"use strict";var a=r.ThingViewerHeaderType;var s=e.extend("sap.ui.ux3.ThingViewer",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{title:{type:"string",group:"Misc",defaultValue:null},type:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},subtitle:{type:"string",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"100%"},headerType:{type:"sap.ui.ux3.ThingViewerHeaderType",group:"Misc",defaultValue:a.Standard}},aggregations:{headerContent:{type:"sap.ui.ux3.ThingGroup",multiple:true,singularName:"headerContent"},facets:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"facet"},facetContent:{type:"sap.ui.ux3.ThingGroup",multiple:true,singularName:"facetContent"},actionBar:{type:"sap.ui.ux3.ActionBar",multiple:false},navBar:{type:"sap.ui.ux3.NavigationBar",multiple:false,visibility:"hidden"}},associations:{selectedFacet:{type:"sap.ui.ux3.NavigationItem",multiple:false}},events:{facetSelected:{allowPreventDefault:true,parameters:{id:{type:"string"},item:{type:"sap.ui.ux3.NavigationItem"},key:{type:"string"}}}}}});s.prototype.init=function(){var e=this;this._oNavBar=new i;this.setAggregation("navBar",this._oNavBar);this._oNavBar.attachSelect(function(t){var r=t.getParameters().item;if(e.fireFacetSelected({id:r.getId(),key:r.getKey(),item:r})){e.setSelectedFacet(r)}else{t.preventDefault()}})};s.prototype.onAfterRendering=function(){this._resize=false;if(this.getActionBar()){this._adjustStyles()}if(this.$().find(".sapUiUx3TVFacetContent").length<=0){return}this._resizeListenerId=n.register(this.$().find(".sapUiUx3TVFacetContent")[0],jQuery.proxy(this._onresize,this));this._setTriggerValue();this._setHeaderPosition();this._onresize()};s.prototype.onBeforeRendering=function(){if(this._resizeListenerId){n.deregister(this._resizeListenerId);this._resizeListenerId=null}};s.prototype._setHeaderPosition=function(){if(this.getHeaderType()===a.Standard){var e=this.$().find(".sapUiUx3TVHeaderContainerIdentifier"),t=this.$().find(".sapUiUx3TVHeaderGroupScrollContainer");t.css("top",e.outerHeight())}};s.prototype._onresize=function(e){var t;if(e){t=jQuery(e.target).width()}if(!t){t=jQuery(this.$().find(".sapUiUx3TVFacetContent")[0]).width()}if(t<this._triggerValue&&this._resize==false){var r=this.$().find(".sapUiUx3TVFacetThingGroup");for(var i=0;i<r.length;i++){jQuery(r[i]).animate({width:"100%"},"fast")}this._resize=true}else if(t>this._triggerValue&&this._resize==true){var r=this.$().find(".sapUiUx3TVFacetThingGroup");for(var i=0;i<r.length;i++){jQuery(r[i]).animate({width:"50%"},"fast")}this._resize=false}if(this.getActionBar()){var n=this.getActionBar().getActionBarMinWidth(),a=n;if(this._bShell){n+=36;a=n+60}this.$().find(".sapUiUx3TV").css("min-width",a+"px");this.$().find(".sapUiUx3TVContent").css("min-width",n+"px")}};s.prototype.exit=function(){this._oNavBar.destroy();if(this._resizeListenerId){n.deregister(this._resizeListenerId);this._resizeListenerId=null}};s.prototype._getNavBar=function(){return this._oNavBar};s.prototype._selectDefault=function(){var e=this._oNavBar.getItems();if(e.length&&!this._oNavBar.getSelectedItem()){if(!this.getSelectedFacet()){this.setSelectedFacet(e[0])}var t=this._oNavBar.getSelectedItem(),r=sap.ui.getCore().byId(t);this.fireFacetSelected({id:r.getId(),key:r.getKey(),item:r})}};s.prototype._equalColumns=function(){var e=this.$().find(".sapUiUx3TVHeader"),t=this.$().find(".sapUiUx3TVFacets"),r=this.$().find(".sapUiUx3TVContentScrollContainer"),i=r.get(0).scrollHeight;t.height(i);e.height(i)};s.prototype._rerenderHeader=function(){var e=this.$("header");if(e.length>0){var r=sap.ui.getCore().createRenderManager();t.renderHeader(r,this);r.flush(e[0]);r.destroy()}};s.prototype._rerenderHeaderContent=function(){var e=this.$("headerContent");if(e.length>0){var r=sap.ui.getCore().createRenderManager();t.renderHeaderContent(r,this);r.flush(e[0]);r.destroy()}};s.prototype._rerenderToolbar=function(){var e=this.$("toolbar");if(e.length>0){var r=sap.ui.getCore().createRenderManager();t.renderToolbar(r,this);r.flush(e[0]);r.destroy()}};s.prototype._rerenderFacetContent=function(){var e=this.$("facetContent");if(e.length>0){var r=sap.ui.getCore().createRenderManager();t.renderFacetContent(r,this);r.flush(e[0]);r.destroy();this._resize=false;this._setTriggerValue();this._onresize()}};s.prototype._setTriggerValue=function(){var e,t,r=this.$("facetContent");if(r.length>0){e=this.$().find(".sapUiUx3TVFacetThingGroup");t=jQuery(e[0]).css("min-width");if(t){this._triggerValue=parseInt(t)*2}}};s.prototype.getFacets=function(){return this._oNavBar.getItems()};s.prototype.insertFacet=function(e,t){this._oNavBar.insertItem(e,t);return this};s.prototype.addFacet=function(e){this._oNavBar.addItem(e);return this};s.prototype.removeFacet=function(e){return this._oNavBar.removeItem(e)};s.prototype.removeAllFacets=function(){return this._oNavBar.removeAllItems()};s.prototype.destroyFacets=function(){this._oNavBar.destroyItems();return this};s.prototype.setIcon=function(e){this.setProperty("icon",e);if(this.getActionBar()){this.getActionBar().setThingIconURI(e)}this._rerenderHeader();return this};s.prototype.insertFacetContent=function(e,t){this.insertAggregation("facetContent",e,t,true);this._rerenderFacetContent();return this};s.prototype.addFacetContent=function(e){this.addAggregation("facetContent",e,true);this._rerenderFacetContent();return this};s.prototype.removeFacetContent=function(e){var t=this.removeAggregation("facetContent",e,true);this._rerenderFacetContent();return t};s.prototype.removeAllFacetContent=function(){var e=this.removeAllAggregation("facetContent",true);this._rerenderFacetContent();return e};s.prototype.destroyFacetContent=function(){this.destroyAggregation("facetContent",true);this._rerenderFacetContent();return this};s.prototype.insertHeaderContent=function(e,t){this.insertAggregation("headerContent",e,t,true);this._rerenderHeaderContent();return this};s.prototype.addHeaderContent=function(e){this.addAggregation("headerContent",e,true);this._rerenderHeaderContent();return this};s.prototype.removeHeaderContent=function(e){var t=this.removeAggregation("headerContent",e,true);this._rerenderHeaderContent();return t};s.prototype.removeAllHeaderContent=function(){var e=this.removeAllAggregation("headerContent",true);this._rerenderHeaderContent();return e};s.prototype.destroyHeaderContent=function(){this.destroyAggregation("headerContent",true);this._rerenderHeaderContent();return this};s.prototype.setSelectedFacet=function(e){var t=this.getSelectedFacet();this.setAssociation("selectedFacet",e,true);var r=this.getSelectedFacet();if(t!=r){this._oNavBar.setSelectedItem(r)}return this};s.prototype.setTitle=function(e){this.setProperty("title",e,true);this._rerenderHeader();return this};s.prototype.setSubtitle=function(e){this.setProperty("subtitle",e,true);this._rerenderHeader();return this};s.prototype.setActionBar=function(e){this.setAggregation("actionBar",e,true);if(this.getIcon()&&this.getActionBar()){this.getActionBar().setThingIconURI(this.getIcon())}this._rerenderToolbar();this._adjustStyles();return this};s.prototype._adjustStyles=function(){var e=this.$().find(".sapUiUx3TVHeader"),t=this.$().find(".sapUiUx3TVFacets");if(e.length>0){e.addClass("sapUiUx3TVActionBar");e.removeClass("sapUiUx3TVNoActionBar")}if(t.length>0){t.addClass("sapUiUx3TVActionBar");t.removeClass("sapUiUx3TVNoActionBar")}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/ThingViewerRenderer", ["./library"],function(e){"use strict";var t=e.ThingViewerHeaderType;var i={};i.render=function(e,t){e.write("<div");e.writeControlData(t);e.writeAttributeEscaped("style","width:"+t.getWidth()+"; height:"+t.getHeight());e.addClass("sapUiUx3TV");e.writeClasses();e.write(">");this.renderContent(e,t);e.write("</div>")};i.renderContent=function(e,i){var r=i.getHeaderType();e.write("<div role='Main' class='sapUiUx3TVContent' id='"+i.getId()+"-content'>");e.write("<div class='sapUiUx3TVHeader sapUiUx3TVNoActionBar");if(i.getHeaderType()===t.Standard){e.write("'>")}else{e.write(" sapUiUx3TVhorizontal'>")}e.write("<div class='sapUiUx3TVHeaderContainerIdentifier'>");e.write("<span role='heading' aria-level='1' class='sapUiUx3TVIdentifier'");e.writeAttributeEscaped("title",i.getType());e.write(">");e.writeEscaped(i.getType());e.write("</span>");e.write("</div>");if(r===t.Standard){e.write("<div class='sapUiUx3TVHeaderGroupScrollContainer'>");e.write("<div id='"+i.getId()+"-header' class='sapUiUx3TVHeaderContainer'>");this.renderHeader(e,i);e.write("</div>")}else{e.write("<div id='"+i.getId()+"-header' class='sapUiUx3TVHeaderContainer'>");this.renderHeader(e,i);e.write("</div>");e.write("<div class='sapUiUx3TVHeaderGroupScrollContainer sapUiUx3TVhorizontal'>")}e.write("<div id='"+i.getId()+"-headerContent'");if(r===t.Standard){e.write(">")}else{e.write("style='height:100%; white-space:nowrap'>")}this.renderHeaderContent(e,i);e.write("</div>");e.write("</div>");e.write("</div>");e.write("<div class='sapUiUx3TVFacets sapUiUx3TVNoActionBar");if(r===t.Standard){e.write("'>")}else{e.write(" sapUiUx3TVhorizontal'>")}e.write("<div role='Navigation' class='sapUiUx3TVFacetBar'>");e.renderControl(i._getNavBar());e.write("</div>");e.write("<div id='"+i.getId()+"-facetContent' class='sapUiUx3TVFacetContent sapUiBodyBackground'>");this.renderFacetContent(e,i);e.write("</div>");e.write("</div>");this.renderToolbar(e,i);e.write("</div>")};i.addRootClasses=function(e,t){e.addClass("sapUiUx3TV")};i.addOverlayClasses=function(e,t){e.addClass("sapUiUx3TVOverlay")};i.renderHeader=function(e,t){e.write("<div class='sapUiUx3TVIconBar'>");e.writeIcon(t.getIcon(),["sapUiUx3TVIcon"],{role:"presentation",id:t.getId()+"-swatch",title:null});e.write("<div class='sapUiUx3TVTitle'>");e.write("<span role='heading' aria-level='2' class='sapUiUx3TVTitleFirst'");e.writeAttributeEscaped("title",t.getTitle());e.write(">");e.writeEscaped(t.getTitle());e.write("</span><br>");e.write("</div><div class='sapUiUx3TVTitle'>");e.write("<span role='heading' aria-level='3' class='sapUiUx3TVTitleSecond'");e.writeAttributeEscaped("title",t.getSubtitle());e.write(">");e.writeEscaped(t.getSubtitle());e.write("</span>");e.write("</div>");e.write("</div>")};i.renderToolbar=function(e,t){if(t.getActionBar()){e.write("<div id='"+t.getId()+"-toolbar' class='sapUiUx3TVToolbar'>");e.renderControl(t.getActionBar());e.write("</div>")}};i.renderHeaderContent=function(e,i){var r=i.getHeaderContent(),a=i.getHeaderType();for(var s=0;s<r.length;s++){var n=r[s];if(a===t.Standard){e.write("<hr class='sapUiUx3TVHRWhite'>")}e.write("<div class='sapUiUx3TVHeaderContainer");if(a===t.Standard){e.write("' role='form'>")}else{e.write(" sapUiUx3TVhorizontal' role='form'>")}if(n.getTitle()){e.write("<div class='sapUiUx3TVHeaderGroupTitle'");e.writeAttributeEscaped("title",n.getTooltip_AsString()?n.getTooltip_AsString():n.getTitle());e.write("><span role='heading' aria-level='4'>");e.writeEscaped(n.getTitle());e.write("</span>");e.write("</div>")}e.write("<div class='sapUiUx3TVHeaderGroupContent'>");var d=n.getContent();for(var o=0;o<d.length;o++){var l=d[o];e.renderControl(l)}e.write("</div>");e.write("</div>")}};i.renderFacetContent=function(e,t){var i=t.getFacetContent();var r=true;if(i.length==1){r=false}for(var a=0;a<i.length;a++){var s=i[a];if(s.getColspan()){e.write("<div class='sapUiUx3TVFacetThingGroupSpan' role='form'>")}else{e.write("<div class='sapUiUx3TVFacetThingGroup' role='form'>")}if(r){e.write("<div class='sapUiUx3TVFacetThingGroupContentTitle'");e.writeAttributeEscaped("title",s.getTooltip_AsString()?s.getTooltip_AsString():s.getTitle());e.write("><span role='heading'>");e.writeEscaped(s.getTitle());e.write("</span></div>")}e.write("<div class='sapUiUx3TVFacetThingGroupContent'>");var n=s.getContent();for(var d=0;d<n.length;d++){e.renderControl(n[d])}e.write("</div></div>")}};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/ToolPopup", ["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/Popup","sap/ui/core/theming/Parameters","sap/ui/core/RenderManager","./library","./ToolPopupRenderer","sap/ui/core/ResizeHandler","sap/ui/core/library","sap/base/assert","sap/base/Log","sap/ui/core/Configuration","sap/ui/dom/jquery/rect","sap/ui/dom/jquery/control","sap/ui/dom/jquery/Selectors"],function(jQuery,t,e,o,i,r,s,n,a,p,u,h,l){"use strict";var c=p.OpenState;var d=t.extend("sap.ui.ux3.ToolPopup",{metadata:{deprecated:true,interfaces:["sap.ui.core.PopupInterface"],library:"sap.ui.ux3",properties:{title:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconHover:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconSelected:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},modal:{type:"boolean",group:"Behavior",defaultValue:false},inverted:{type:"boolean",group:"Misc",defaultValue:true},autoClose:{type:"boolean",group:"Misc",defaultValue:false},maxHeight:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},maxWidth:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},openDuration:{type:"int",group:"Misc",defaultValue:400},closeDuration:{type:"int",group:"Misc",defaultValue:400}},defaultAggregation:"content",aggregations:{buttons:{type:"sap.ui.core.Control",multiple:true,singularName:"button"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},associations:{initialFocus:{type:"sap.ui.core.Control",multiple:false},opener:{type:"sap.ui.core.Control",multiple:false},defaultButton:{type:"sap.ui.core.Control",multiple:false}},events:{open:{},close:{allowPreventDefault:true},enter:{parameters:{originalEvent:{type:"object"},originalSrcControl:{type:"sap.ui.core.Control"}}},iconChanged:{},closed:{},opened:{}}}});d.ARROW_LEFT=new RegExp(/my:(left|begin)([-+]\d*\%?)?\|[a-z]+([-+]\d*\%?)? at:(right|end)\|[a-z]+/);d.ARROW_RIGHT=new RegExp(/my:(right|end)([-+]\d*\%?)?\|[a-z]+([-+]\d*\%?)? at:(left|begin)\|[a-z]+/);d.ARROW_UP=new RegExp(/my:[a-z]+([-+]\d*\%?)?\|top([-+]\d*\%?)? at:[a-z]+\|bottom/);d.ARROW_DOWN=new RegExp(/my:[a-z]+([-+]\d*\%?)?\|bottom([-+]\d*\%?)? at:[a-z]+\|top/);(function(){d.prototype.init=function(){this.oPopup=null;this._bPositionSet=false;this._mParameters={};this._mParameters.that=this;this._mParameters.firstFocusable=this.getId()+"-firstFocusable";this._mParameters.lastFocusable=this.getId()+"-lastFocusable";this._bFocusSet=false;this._proxyOpened=jQuery.proxy(p,this);this._proxyClosed=jQuery.proxy(y,this);this._proxyFixSize=jQuery.proxy(n,this);this._proxyOnResize=jQuery.proxy(_,this);g(this)};d.prototype.exit=function(){if(this.oPopup){this.oPopup.detachOpened(this._proxyOpened);this.oPopup.detachClosed(this._proxyClosed);this.oPopup.destroy();delete this.oPopup}delete this._bPositionSet;delete this._mParameters;delete this._bFocusSet;delete this._bPreventRestoreFocus;delete this._proxyOpened;delete this._proxyClosed;delete this._bRTL;delete this._sArrowDir;delete this._oArrowIcon;delete this._bThemeInverted;delete this._sInitialFocusId};var t=function(t){var o=t;u(!!o,"No ToolPopup instance given for _fnGetInitialFocus");if(!o._bFocusSet){e(o)}else{o._sInitialFocusId=o.oPopup._sInitialFocusId}return o._sInitialFocusId};var e=function(t){var e;var o;var i=t;var r=[i._mParameters.firstFocusable,i._mParameters.lastFocusable];var s=jQuery(":sapTabbable",i.$()).get();for(var n=0;n<s.length;n++){if(r.indexOf(s[n].id)===-1){e=s[n];break}}o=jQuery(e).control();if(o[0]){var a=o[0].getFocusDomRef();e=a||e}else{e=r[0]?window.document.getElementById(r[0]):null}if(e){if(e){e.focus()}i._sInitialFocusId=e.id}};function s(t,e){var o,i;if(!e){return null}o=sap.ui.getCore().byId(e);while(!o&&o!==t){if(!e||!document.getElementById(e)){return null}i=document.getElementById(e).parentNode;e=i.id;o=sap.ui.getCore().byId(e)}return o}d.prototype.getFocusDomRef=function(){var e;var o=s(this,this._sInitialFocusId);if(!o){this._bFocusSet=false;e=t(this);o=s(this,e)}return o?o.getDomRef():this.getDomRef()};d.prototype.onfocusin=function(t){this._mParameters.event=t;this._mParameters.$FocusablesContent=jQuery(":sapTabbable",this.$("content"));this._mParameters.$FocusablesFooter=jQuery(":sapTabbable",this.$("buttons"));this.oPopup.focusTabChain(this._mParameters)};var n=function(){var t=this.$();var e=0;var o=this.getMaxHeight();var i=o?parseInt(o):0;var r=this.getMaxWidth();if(r){var s=parseInt(r);var n=t.css("border-left-width");var a=parseInt(n);var p=t.css("border-right-width");var u=parseInt(p);var l=t.css("padding-left");var c=parseInt(l);var d=t.css("padding-right");var f=parseInt(d);s-=a+c+f+u;t.css("max-width",s+"px")}else{t.css("max-width","")}var g=t.css("padding-top");var P=parseInt(g);var y=t.css("padding-bottom");var _=parseInt(y);var m=t.css("border-top-width");var w=parseInt(m);var I=t.css("border-bottom-width");var b=parseInt(I);var x=P+_+w+b;var A=jQuery(document).scrollTop();var R=t.rect();var C=R.top-A+t.outerHeight(true);var T=jQuery(window).height();var U=C>T&&i===0;var O=0;if(U){var F=jQuery(document.getElementById(this.getOpener()));var D=F.rect();var H=D.top-A+F.outerHeight(true);var S=this.oPopup._getPositionOffset();if(C>H&&S.length>0){O=Math.abs(parseInt(S[1]));if(C-O<T){U=false;var W="Offset of "+O+" pushes ToolPopup out of the window";h.warning(W,"","sap.ui.ux3.ToolPopup")}}i=i?i:T-R.top}t.toggleClass("sapUiUx3TPLargeContent",U);if(i||U){t.css("max-height",i+"px");var M=this.$("title");var z=this.$("title-separator");var B=this.$("buttons");var E=this.$("buttons-separator");e=i>0?i:T-R.top-_-O;e-=x;e-=M.outerHeight(true);e-=z.outerHeight(true);e-=E.outerHeight(true);e-=B.length>0?B.outerHeight(true):0;e=parseInt(e);var L=this.$("content");L.css("max-height",e+"px");L.toggleClass("sapUiUx3TPLargeContent",true)}v(this)};var p=function(){this._proxyFixSize();if(!this._sInitialFocusId){var e=t(this);if(e!==sap.ui.getCore().getCurrentFocusedControlId()){var o=jQuery(document.getElementById(e));o.trigger("focus")}}if(!this._sResizeID){this._sResizeID=a.register(this.$("content")[0],this._proxyOnResize)}this.fireOpened()};d.prototype.isOpen=function(){return this.oPopup&&(this.oPopup.getOpenState()=="OPENING"||this.oPopup.getOpenState()=="OPEN")};d.prototype.willBeClosed=function(){var t=this.oPopup&&this.oPopup.getOpenState();return t!==c.OPENING&&t!==c.OPEN};d.prototype.open=function(t,e){this._my=t;this._at=e;this._sArrowDir=P(this);var i=null;this.sOffset="";b(this);if(!this._bPositionSet){var r=0;var s=0;if(!this._my){this._my=o.Dock.BeginTop}if(!this._at){this._at=o.Dock.EndTop}i=this.getOpener()?window.document.getElementById(this.getOpener()):null;if(i){switch(this._sArrowDir){case"Up":r=0;s=this.iArrowWidth;break;case"Down":r=0;s=-this.iArrowWidth;break;case"Right":r=-this.iArrowWidth;break;case"Left":default:r=this.iArrowWidth;break}r=parseInt(r);s=parseInt(s);this.sOffset=""+r+" "+s;this.setPosition(this._my,this._at,i,this.sOffset,"none")}else{this.setPosition(o.Dock.BeginTop,o.Dock.BeginTop,window,"0 0","fit");h.warning("No opener set. Using a default position for Popup","","sap.ui.ux3.ToolPopup")}this._bPositionSet=false}this._ensurePopup();var n=this.getAutoClose();var a=this.getModal();if(n&&a){h.warning("A modal & autoclose ToolPopup will not work properly. Therefore 'autoclose' will be deactived!");n=false}this.oPopup.setAutoClose(n);this.oPopup.setModal(a);this._oPreviousFocus=o.getCurrentFocusInfo();this.fireOpen();f(this);this.oPopup.open(this.getOpenDuration(),this._my,this._at,i,this.sOffset,"",true);v(this);return this};var f=function(t){if(!t.getOpener()){var e="";if(t.oPopup){if(t.oPopup._oPosition.of instanceof sap.ui.core.Element){e=t.oPopup._oPosition.of.getId()}else{if(t.oPopup._oPosition.of.length>0){e=t.oPopup._oPosition.of[0].id}else{e=t.oPopup._oPosition.of.id}}}if(e!==""){t.setAssociation("opener",e,true)}else{h.error("Neither an opener was set properly nor a corresponding one can be distinguished","","sap.ui.ux3.ToolPopup")}}};var g=function(t){var e=Object.assign({sapUiUx3ToolPopupArrowWidth:"13px",sapUiUx3ToolPopupArrowHeight:"24px",sapUiUx3ToolPopupArrowRightMarginCorrection:"-2px",sapUiUx3ToolPopupArrowRightMarginCorrectionInverted:"-7px"},i.get({name:["sapUiUx3ToolPopupArrowWidth","sapUiUx3ToolPopupArrowHeight","sapUiUx3ToolPopupArrowRightMarginCorrection","sapUiUx3ToolPopupArrowRightMarginCorrectionInverted"],callback:function(){t.invalidate()}}));var o="sapUiUx3ToolPopupArrowWidth";t.sArrowWidth=e[o];t.iArrowWidth=parseInt(t.sArrowWidth);o="sapUiUx3ToolPopupArrowHeight";t.sArrowHeight=e[o];t.iArrowHeight=parseInt(t.sArrowHeight);o="sapUiUx3ToolPopupArrowRightMarginCorrection";t.sArrowPadding=e[o];t.iArrowPadding=parseInt(t.sArrowPadding);o="sapUiUx3ToolPopupArrowRightMarginCorrectionInverted";t.sArrowPaddingInverted=e[o];t.iArrowPaddingInverted=parseInt(t.sArrowPaddingInverted)};var P=function(t){var e="Left";var o=t._my;var i=t._at;if(!o&&t.oPopup){o=t.oPopup._oPosition.my}if(!i&&t.oPopup){i=t.oPopup._oPosition.at}t._bHorizontalArrow=false;if(o&&i){var r=o.split(" ");var s=i.split(" ");var n="my:"+r[0]+"|"+r[1];n+=" at:"+s[0]+"|"+s[1];if(d.ARROW_LEFT.exec(n)){t._bHorizontalArrow=true;e="Left"}else if(d.ARROW_RIGHT.exec(n)){t._bHorizontalArrow=true;e="Right"}else if(d.ARROW_UP.exec(n)){e="Up"}else if(d.ARROW_DOWN.exec(n)){e="Down"}if(t.getDomRef()&&t.isOpen()){var a=t.$();var p=a.rect();var u=jQuery(document.getElementById(t.getOpener()));var h=u.rect();if(h){if(t._bHorizontalArrow){var l=p.left+a.outerWidth(true)+t.iArrowWidth;var c=h.left+u.outerWidth(true);if(l<=c){e="Right"}else{e="Left"}}else{var f=p.top+a.outerHeight(true)+t.iArrowWidth;var g=h.top+u.outerHeight(true);if(f<=g){e="Down"}else{e="Up"}}}}}return e};var v=function(t){var e="",o=0,i=0,r=t.iArrowHeight/2,s=l.getRTL(),n,a=t.$().rect(),p=jQuery(document.getElementById(t.getOpener())),u=p.rect(),c=0,d=t.$("arrow");if(!t.getDomRef()){return}t._sArrowDir=P(t);n=t._sArrowDir;if(s){if(t._sArrowDir==="Right"){n="Left"}else if(t._sArrowDir==="Left"){n="Right"}}if(!u){h.warning("Opener wasn't set properly. Therefore arrow will be at a default position","","sap.ui.ux3.ToolPopup")}if(!t._my&&t.oPopup){t._my=t.oPopup._oPosition.my}if(t._bHorizontalArrow){e="top";if(u){c=parseInt(t.$().css("border-top-width"))||0;i=parseInt(u.top-c-a.top);o=Math.round(i+u.height/2-r);o=o+r>a.height?o-t.iArrowHeight:o}}else{e="left";if(u){if(s){e="right";c=parseInt(t.$().css("border-right-width"))||0;i=parseInt(a.left+a.width-u.left-u.width-c)}else{c=parseInt(t.$().css("border-left-width"))||0;i=parseInt(u.left-a.left-c)}o=Math.round(i+u.width/2-r);o=o+r>a.width?o-t.iArrowHeight:o}}if(!u){o=t.iArrowHeight}var f="";if(d.hasClass("sapUiUx3TPNewArrow")){f="sapUiUx3TPNewArrow sapUiUx3TPNewArrow"}else{f=t.isInverted()?"sapUiUx3TPArrow sapUiTPInverted sapUiUx3TPArrow":"sapUiUx3TPArrow sapUiUx3TPArrow"}d.attr("class",f+n);if(n==="Right"){var g=a.width;if(t.isInverted()){g+=t.iArrowPaddingInverted}else{g+=t.iArrowPadding}if(s){d.css("right",g+"px")}else{d.css("left",g+"px")}}else{d.css({left:"",right:""})}o=parseInt(o);o=o<-c?-c:o;d.css(e,o+"px")};d.prototype.onsapescape=function(){if(this.fireClose()){this.close()}};var y=function(t){if(!this._bPreventRestoreFocus){o.applyFocusInfo(this._oPreviousFocus)}if(this.getDomRef()){r.preserveContent(this.getDomRef());this.$().remove()}this.fireClosed()};d.prototype.close=function(t){if(this.oPopup&&this.oPopup.isOpen()){if(this._sResizeID){a.deregister(this._sResizeID);delete this._sResizeID}this.oPopup.close(this.getCloseDuration());this._bPreventRestoreFocus=t}return this};d.prototype.getEnabled=function(){var t=this.oPopup?this.oPopup.getOpenState():c.CLOSED;return t===c.OPENING||t===c.OPEN};d.prototype.onsapenter=function(t){var e=this.getDefaultButton();var o=sap.ui.getCore().byId(e);if(e&&o&&jQuery.contains(this.getDomRef(),o.getDomRef())){if(o instanceof sap.ui.commons.Button){var i=o.$();i.trigger("click");i.trigger("focus")}}t.preventDefault();t.stopPropagation()};d.prototype.onBeforeRendering=function(){g(this);var t=this.getInitialFocus()||this._sInitialFocusId;var e=this.getDefaultButton();this._bFocusSet=true;if(t){this.oPopup.setInitialFocusId(t)}else if(e){this.oPopup.setInitialFocusId(e)}else{this._bFocusSet=false}this._bRTL=l.getRTL()};d.prototype._ensurePopup=function(){if(!this.oPopup){this.oPopup=new o(this,false,true,false);this.oPopup.attachOpened(this._proxyOpened);this.oPopup.attachClosed(this._proxyClosed);var t=this;this.oPopup._applyPosition=function(){o.prototype._applyPosition.apply(t.oPopup,arguments);var e=t.oPopup._oLastPosition.of;if(!e){t.oPopup.close()}else{var i=jQuery(document.getElementById(e.id));if(t._bPositionSet){if(!i.hasClass("sapUiUx3ShellTool")){t._my=t.oPopup._oLastPosition.my;t._at=t.oPopup._oLastPosition.at}}v(t)}}}return this.oPopup};var _=function(){if(this.getContent().length){this._proxyFixSize();this.oPopup._applyPosition(this.oPopup._oLastPosition)}};d.prototype.setPosition=function(){this._ensurePopup();this.oPopup.setPosition.apply(this.oPopup,arguments);this._bPositionSet=true;f(this);return this};var m=function(t,e){var o=t;if(e==="content"){w(o)}else if(e==="buttons"){I(o)}o._proxyFixSize();o.oPopup._applyPosition(o.oPopup._oLastPosition)};var w=function(t){var e=t.getDomRef("content");e.innerHTML="";var o=t.getContent();var i=sap.ui.getCore().createRenderManager();for(var r=0;r<o.length;r++){i.renderControl(o[r])}i.flush(e,true);i.destroy()};var I=function(t){var e=t.getDomRef("buttons");var o=t.getDomRef("buttons-separator");var i=t.getButtons();if(i.length===0){jQuery(e).addClass("sapUiUx3TPButtonRowHidden");jQuery(o).addClass("sapUiUx3TPButtonRowHidden")}else{jQuery(e).removeClass("sapUiUx3TPButtonRowHidden");jQuery(o).removeClass("sapUiUx3TPButtonRowHidden");e.innerHTML="";var r=sap.ui.getCore().createRenderManager();for(var s=0;s<i.length;s++){r.renderControl(i[s])}r.flush(e,true);r.destroy()}};d.prototype.addContent=function(t){this.addAggregation("content",t,true);if(this.isOpen()){m(this,"content")}return this};d.prototype.insertContent=function(t,e){this.insertAggregation("content",t,e,true);if(this.isOpen()){m(this,"content")}return this};d.prototype.removeContent=function(t){this.removeAggregation("content",t,true);if(this.isOpen()){m(this,"content")}return this};d.prototype.addButton=function(t){this.addAggregation("buttons",t,true);if(this.isOpen()){m(this,"buttons")}return this};d.prototype.insertButton=function(t,e){this.insertAggregation("buttons",t,e,true);if(this.isOpen()){m(this,"buttons")}return this};d.prototype.removeButton=function(t){this.removeAggregation("button",t,true);if(this.isOpen()){m(this,"buttons")}return this};var b=function(t){var e="sapUiUx3ToolPopupInverted";e=i.get({name:e,callback:function(o){t._bThemeInverted=e==="true";t.invalidate()}})||"true";t._bThemeInverted=e==="true"};d.prototype.onThemeChanged=function(){b(this)};d.prototype.isInverted=function(){b(this);return this.getInverted()&&this._bThemeInverted};d.prototype.setAutoCloseAreas=function(t){this._ensurePopup();return this.oPopup.setAutoCloseAreas(t)};d.prototype.addFocusableArea=function(t){this._ensurePopup();if(typeof t==="string"){this.oPopup._addFocusableArea("channelId","eventId",{id:t});return this}else{h.error("Wrong type of focusable area ID - string expected","","sap.ui.ux3.ToolPopup")}};d.prototype.removeFocusableArea=function(t){this._ensurePopup();if(typeof t==="string"){this.oPopup._removeFocusableArea("channelId","eventId",{id:t});return this}else{h.error("Wrong type of focusable area ID - string expected","","sap.ui.ux3.ToolPopup")}}})();d.prototype.setIcon=function(t){this.setProperty("icon",t,true);this.fireIconChanged();return this};d.prototype.setIconHover=function(t){this.setProperty("iconHover",t,true);this.fireIconChanged();return this};d.prototype.setIconSelected=function(t){this.setProperty("iconSelected",t,true);this.fireIconChanged();return this};d.prototype.getIconSelected=function(){return this.getProperty("iconSelected")||this.getProperty("iconHover")};d.prototype.setMaxWidth=function(t){var e=/[0-9]+px/;if(e.test(t)){this.setProperty("maxWidth",t)}else{h.error("Only values in pixels are possible","","sap.ui.ux3.ToolPopup")}return this};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/ToolPopupRenderer", [],function(){"use strict";var i={};i.render=function(i,t){var e=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");var s=t.getId();var a=t.getContent();var r=t.getButtons();var d=t.getTitle();var n=sap.ui.resource("sap.ui.core","themes/base/img/1x1.gif");i.write("<div");i.writeControlData(t);i.addClass("sapUiUx3TP");if(d===""){i.addClass("sapUiUx3TPNoTitle")}if(r.length===0){i.addClass("sapUiUx3TPNoButtons")}if(t.isInverted()){i.addClass("sapUiTPInverted");i.addClass("sapUiInverted-CTX")}i.writeClasses();i.write(" aria-labelledby='",s,"-title ",s,"-acc' role='dialog'");i.writeAttribute("tabindex","-1");i.write(">");i.write("<div id='"+s+"-arrow' class='sapUiUx3TPArrow sapUiUx3TPArrowLeft'><div class='sapUiUx3TPArrowBorder'></div></div>");i.write("<span style='display:none;' id='",s,"-acc'>");i.writeEscaped(e.getText("DIALOG_CLOSE_HELP"));i.write("</span>");i.write('<span id="'+s+"-firstFocusable"+'" tabindex="0" class="sapUiUxTPFocus">');i.write('<img src="'+n+'">');i.write("</span>");if(d&&d.length!==""){i.write('<div class="sapUiUx3TPTitle" id="'+s+'-title">');i.write('<span class="sapUiUx3TPTitleText">');i.writeEscaped(d);i.write("</span>");i.write("</div>");i.write('<div class="sapUiUx3TPTitleSep" id="'+s+'-title-separator"></div>')}else{var l=t.getTooltip_AsString();if(l){i.write("<h1 id='"+s+"-title' style='display:none;'>");i.writeEscaped(l);i.write("</h1>")}}i.write('<div id="'+s+'-content"');i.addClass("sapUiUx3TPContent");i.writeClasses();i.write(">");for(var o=0;o<a.length;o++){i.renderControl(a[o])}i.write("</div>");if(r.length>0){i.write('<div class="sapUiUx3TPButtonsSep" id="'+s+'-buttons-separator"></div>');i.write('<div class="sapUiUx3TPBtnRow" id="'+s+'-buttons">');for(var o=0;o<r.length;o++){i.renderControl(r[o].addStyleClass("sapUiUx3TPBtn"))}}else{i.write('<div class="sapUiUx3TPButtonsSep sapUiUx3TPButtonRowHidden" id="'+s+'-buttons-separator"></div>');i.write('<div class="sapUiUx3TPBtnRow sapUiUx3TPButtonRowHidden" id="'+s+'-buttons">')}i.write("</div>");i.write('<span id="'+s+"-lastFocusable"+'" tabindex="0" class="sapUiUxTPFocus">');i.write('<img src="'+n+'">');i.write("</span>");i.write("</div>")};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/ux3/library", ["sap/ui/core/library","sap/ui/commons/library"],function(){"use strict";var a=sap.ui.getCore().initLibrary({name:"sap.ui.ux3",version:"1.120.31",dependencies:["sap.ui.core","sap.ui.commons"],types:["sap.ui.ux3.ActionBarSocialActions","sap.ui.ux3.ExactOrder","sap.ui.ux3.FeederType","sap.ui.ux3.FollowActionState","sap.ui.ux3.NotificationBarStatus","sap.ui.ux3.ShellDesignType","sap.ui.ux3.ShellHeaderType","sap.ui.ux3.ThingViewerHeaderType","sap.ui.ux3.VisibleItemCountMode"],interfaces:["sap.ui.ux3.DataSetView"],controls:["sap.ui.ux3.ActionBar","sap.ui.ux3.CollectionInspector","sap.ui.ux3.DataSet","sap.ui.ux3.DataSetSimpleView","sap.ui.ux3.Exact","sap.ui.ux3.ExactArea","sap.ui.ux3.ExactBrowser","sap.ui.ux3.ExactList","sap.ui.ux3.FacetFilter","sap.ui.ux3.FacetFilterList","sap.ui.ux3.Feed","sap.ui.ux3.FeedChunk","sap.ui.ux3.Feeder","sap.ui.ux3.NavigationBar","sap.ui.ux3.NotificationBar","sap.ui.ux3.Overlay","sap.ui.ux3.OverlayContainer","sap.ui.ux3.OverlayDialog","sap.ui.ux3.QuickView","sap.ui.ux3.Shell","sap.ui.ux3.ThingInspector","sap.ui.ux3.ThingViewer","sap.ui.ux3.ToolPopup"],elements:["sap.ui.ux3.Collection","sap.ui.ux3.DataSetItem","sap.ui.ux3.ExactAttribute","sap.ui.ux3.NavigationItem","sap.ui.ux3.Notifier","sap.ui.ux3.ThingAction","sap.ui.ux3.ThingGroup"]});a.ActionBarSocialActions={Update:"Update",Follow:"Follow",Flag:"Flag",Favorite:"Favorite",Open:"Open"};a.ExactOrder={Select:"Select",Fixed:"Fixed"};a.FeederType={Large:"Large",Medium:"Medium",Comment:"Comment"};a.FollowActionState={Follow:"Follow",Hold:"Hold",Default:"Default"};a.NotificationBarStatus={Default:"Default",Min:"Min",Max:"Max",None:"None"};a.ShellDesignType={Standard:"Standard",Light:"Light",Crystal:"Crystal"};a.ShellHeaderType={Standard:"Standard",BrandOnly:"BrandOnly",NoNavigation:"NoNavigation",SlimNavigation:"SlimNavigation"};a.ThingViewerHeaderType={Standard:"Standard",Horizontal:"Horizontal"};a.VisibleItemCountMode={Fixed:"Fixed",Auto:"Auto"};return a});
sap.ui.require.preload({
	"sap/ui/ux3/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.ux3","type":"library","embeds":[],"applicationVersion":{"version":"1.120.31"},"title":"Controls that implement the SAP User Experience (UX) Guidelines 3.0","description":"Controls that implement the SAP User Experience (UX) Guidelines 3.0","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.120","libs":{"sap.ui.core":{"minVersion":"1.120.31"},"sap.ui.commons":{"minVersion":"1.120.31"},"sap.ui.unified":{"minVersion":"1.120.31","lazy":true}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cnr","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","mk","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sr","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.ui.ux3.ActionBar","sap.ui.ux3.CollectionInspector","sap.ui.ux3.DataSet","sap.ui.ux3.DataSetSimpleView","sap.ui.ux3.Exact","sap.ui.ux3.ExactArea","sap.ui.ux3.ExactBrowser","sap.ui.ux3.ExactList","sap.ui.ux3.FacetFilter","sap.ui.ux3.FacetFilterList","sap.ui.ux3.Feed","sap.ui.ux3.FeedChunk","sap.ui.ux3.Feeder","sap.ui.ux3.NavigationBar","sap.ui.ux3.NotificationBar","sap.ui.ux3.Overlay","sap.ui.ux3.OverlayContainer","sap.ui.ux3.OverlayDialog","sap.ui.ux3.QuickView","sap.ui.ux3.Shell","sap.ui.ux3.ThingInspector","sap.ui.ux3.ThingViewer","sap.ui.ux3.ToolPopup"],"elements":["sap.ui.ux3.Collection","sap.ui.ux3.DataSetItem","sap.ui.ux3.ExactAttribute","sap.ui.ux3.NavigationItem","sap.ui.ux3.Notifier","sap.ui.ux3.ThingAction","sap.ui.ux3.ThingGroup"],"types":["sap.ui.ux3.ActionBarSocialActions","sap.ui.ux3.ExactOrder","sap.ui.ux3.FeederType","sap.ui.ux3.FollowActionState","sap.ui.ux3.NotificationBarStatus","sap.ui.ux3.ShellDesignType","sap.ui.ux3.ShellHeaderType","sap.ui.ux3.ThingViewerHeaderType","sap.ui.ux3.VisibleItemCountMode"],"interfaces":["sap.ui.ux3.DataSetView"]}}}}'
});
//# sourceMappingURL=library-preload.js.map
