sap.ui.define(["exports","sap/ui/webc/common/thirdparty/base/decorators/customElement","sap/ui/webc/common/thirdparty/base/decorators/property","sap/ui/webc/common/thirdparty/base/types/Float","sap/ui/webc/common/thirdparty/base/i18nBundle","sap/ui/webc/common/thirdparty/base/Keys","./SliderBase","./Icon","./generated/templates/RangeSliderTemplate.lit","./generated/i18n/i18n-defaults","./generated/themes/RangeSlider.css"],function(e,t,s,i,a,n,r,l,d,u,o){"use strict";Object.defineProperty(e,"__esModule",{value:true});e.default=void 0;t=h(t);s=h(s);i=h(i);r=h(r);l=h(l);d=h(d);o=h(o);function h(e){return e&&e.__esModule?e:{default:e}}var c=void 0&&(void 0).__decorate||function(e,t,s,i){var a=arguments.length,n=a<3?t:i===null?i=Object.getOwnPropertyDescriptor(t,s):i,r;if(typeof Reflect==="object"&&typeof Reflect.decorate==="function")n=Reflect.decorate(e,t,s,i);else for(var l=e.length-1;l>=0;l--)if(r=e[l])n=(a<3?r(n):a>3?r(t,s,n):r(t,s))||n;return a>3&&n&&Object.defineProperty(t,s,n),n};var f;let _=f=class e extends r.default{constructor(){super();this._isPressInCurrentRange=false;this._handeIsPressed=false;this._reversedValues=false;this._stateStorage.startValue=undefined;this._stateStorage.endValue=undefined}get tooltipStartValue(){const e=this.constructor;const t=e._getDecimalPrecisionOfNumber(this._effectiveStep);return this.startValue.toFixed(t)}get tooltipEndValue(){const e=this.constructor;const t=e._getDecimalPrecisionOfNumber(this._effectiveStep);return this.endValue.toFixed(t)}get _ariaDisabled(){return this.disabled||undefined}get _ariaLabelledByText(){return f.i18nBundle.getText(u.RANGE_SLIDER_ARIA_DESCRIPTION)}get _ariaHandlesText(){const e=this.effectiveDir==="rtl";const t=this._areValuesReversed();const s={};if(e&&!t||!e&&t){s.startHandleText=f.i18nBundle.getText(u.RANGE_SLIDER_END_HANDLE_DESCRIPTION);s.endHandleText=f.i18nBundle.getText(u.RANGE_SLIDER_START_HANDLE_DESCRIPTION)}else{s.startHandleText=f.i18nBundle.getText(u.RANGE_SLIDER_START_HANDLE_DESCRIPTION);s.endHandleText=f.i18nBundle.getText(u.RANGE_SLIDER_END_HANDLE_DESCRIPTION)}return s}get _ariaValueNow(){return Math.abs(this.endValue-this.startValue)}onBeforeRendering(){if(this.startValue>this.endValue){const e=this._valueAffected==="startValue"?"endValue":"startValue";this._swapValues();this._setAffectedValue(e);this.update(e,this.startValue,this.endValue)}if(!this.isCurrentStateOutdated()){return}this.notResized=true;this.syncUIAndState();this._updateHandlesAndRange(0)}syncUIAndState(){if(this.isPropertyUpdated("step")){this._validateStep(this.step);this.storePropertyState("step")}if(this.isPropertyUpdated("min","max","startValue","endValue")){this.storePropertyState("min","max");const e=r.default.clipValue(this.startValue,this._effectiveMin,this._effectiveMax);this.startValue=e;this.updateStateStorageAndFireInputEvent("startValue");this.storePropertyState("startValue");const t=r.default.clipValue(this.endValue,this._effectiveMin,this._effectiveMax);this.endValue=t;this.updateStateStorageAndFireInputEvent("endValue");this.storePropertyState("endValue")}if(this.labelInterval&&this.showTickmarks){this._createLabels()}if(this.isPropertyUpdated("labelInterval")){this.storePropertyState("labelInterval")}}_onfocusin(){if(!this._endValueInitial){this._startValueInitial=this.startValue;this._endValueInitial=this.endValue}if(this.showTooltip){this._tooltipVisibility=r.default.TOOLTIP_VISIBILITY.VISIBLE}}_onfocusout(){if(this._isFocusing()){this._preventFocusOut();return}this._setAffectedValue(undefined);this._startValueInitial=undefined;this._endValueInitial=undefined;if(this.showTooltip){this._tooltipVisibility=r.default.TOOLTIP_VISIBILITY.HIDDEN}}_onkeyup(){super._onkeyup();this._setAffectedValue(undefined);if(this.startValue!==this._startValueAtBeginningOfAction||this.endValue!==this._endValueAtBeginningOfAction){this.fireEvent("change")}this._startValueAtBeginningOfAction=undefined;this._endValueAtBeginningOfAction=undefined}_handleActionKeyPress(e){this._startValueAtBeginningOfAction=this.startValue;this._endValueAtBeginningOfAction=this.endValue;if((0,n.isEscape)(e)){this.update(undefined,this._startValueInitial,this._endValueInitial);return}this._setAffectedValueByFocusedElement();const t=this._effectiveMin;const s=this._effectiveMax;const i=this._valueAffected;if(((0,n.isEnd)(e)||(0,n.isHome)(e))&&!i){this._homeEndForSelectedRange(e,(0,n.isHome)(e)?"startValue":"endValue",t,s);return}const a=this._handleActionKeyPressBase(e,i);if(!a){return}const r=this.constructor;if(i&&!this._isPressInCurrentRange){const e=this[i];const n=r.clipValue(a+e,t,s);this.update(i,n,undefined)}else if(a<0&&this.startValue>t||a>0&&this.endValue<s){const e=r.clipValue(a+this.startValue,t,s);const n=r.clipValue(a+this.endValue,t,s);this.update(i,e,n)}}_setAffectedValueByFocusedElement(){if(this.shadowRoot.activeElement===this._startHandle){this._setAffectedValue("startValue")}if(this.shadowRoot.activeElement===this._endHandle){this._setAffectedValue("endValue")}if(this.shadowRoot.activeElement===this._progressBar){this._setAffectedValue(undefined)}this._setIsPressInCurrentRange(!this._valueAffected)}_homeEndForSelectedRange(e,t,s,i){const a=this._handleActionKeyPressBase(e,t);const n=this.constructor;const r=n.clipValue(a+this.startValue,s,i);const l=n.clipValue(a+this.endValue,s,i);this.update(undefined,r,l)}update(e,t,s){if(!e){this.startValue=t;this.updateStateStorageAndFireInputEvent("startValue");this.endValue=s;this.updateStateStorageAndFireInputEvent("endValue");this._updateHandlesAndRange(0)}else{const i=s&&e==="endValue"?s:t;this._updateHandlesAndRange(i||0);if(e==="startValue"){this.startValue=i;this.updateStateStorageAndFireInputEvent("startValue")}if(e==="endValue"){this.endValue=i;this.updateStateStorageAndFireInputEvent("endValue")}}}_onmousedown(e){if(this.disabled||this._effectiveStep===0){return}const t=this.handleDownBase(e);this._saveInteractionStartData(e,t);this.rangePressed=this._isPressInCurrentRange;if(this._isPressInCurrentRange||this._handeIsPressed){this._handeIsPressed=false;return}this.update(this._valueAffected,t,undefined)}_saveInteractionStartData(e,t){const s=this.shadowRoot.querySelector(".ui5-slider-progress").getBoundingClientRect();this._startValueAtBeginningOfAction=this.startValue;this._endValueAtBeginningOfAction=this.endValue;const i=this.constructor;this._initialPageXPosition=i.getPageXValueFromEvent(e);this._pressTargetAndAffectedValue(this._initialPageXPosition,t);this._initialStartHandlePageX=this.directionStart==="left"?s.left:s.right}_handleMove(e){e.preventDefault();if(this.disabled||this._effectiveStep===0){return}if(!this._isPressInCurrentRange){this._updateValueOnHandleDrag(e);return}this._updateValueOnRangeDrag(e)}_updateValueOnHandleDrag(e){const t=this.constructor;const s=t.getValueFromInteraction(e,this._effectiveStep,this._effectiveMin,this._effectiveMax,this.getBoundingClientRect(),this.directionStart);this.update(this._valueAffected,s,undefined)}_updateValueOnRangeDrag(e){const t=this.constructor;const s=t.getPageXValueFromEvent(e);const i=this._calculateRangeOffset(s,this._initialStartHandlePageX);this._setAffectedValue(undefined);this.update(undefined,i[0],i[1])}_handleUp(){this._setAffectedValueByFocusedElement();this._setAffectedValue(undefined);if(this.startValue!==this._startValueAtBeginningOfAction||this.endValue!==this._endValueAtBeginningOfAction){this.fireEvent("change")}this._setIsPressInCurrentRange(false);this.handleUpBase();this.rangePressed=false;this._startValueAtBeginningOfAction=undefined;this._endValueAtBeginningOfAction=undefined}_pressTargetAndAffectedValue(e,t){const s=this.shadowRoot.querySelector(".ui5-slider-handle--start");const i=this.shadowRoot.querySelector(".ui5-slider-handle--end");const a=s.getBoundingClientRect();const n=i.getBoundingClientRect();const r=e>=a.left&&e<=a.right;const l=e>=n.left&&e<=n.right;if(l||r){this._handeIsPressed=true}if(l||t>this.endValue){this._setAffectedValue("endValue")}if(r||t<this.startValue){this._setAffectedValue("startValue")}const d=this._startValueAtBeginningOfAction!==undefined&&this._endValueAtBeginningOfAction!==undefined&&t>=this._startValueAtBeginningOfAction&&t<=this._endValueAtBeginningOfAction;this._setIsPressInCurrentRange(!(this._valueAffected||this._handeIsPressed)?d:false)}_setAffectedValue(e){this._valueAffected=e;if(this._areValuesReversed()){this._setValuesAreReversed()}}_setIsPressInCurrentRange(e){this._isPressInCurrentRange=e}focusInnerElement(){const e=this._areValuesReversed();const t=this._valueAffected;if(this._isPressInCurrentRange||!t){this._progressBar.focus()}if(t==="startValue"&&!e||t==="endValue"&&e){this._startHandle.focus()}if(t==="endValue"&&!e||t==="startValue"&&e){this._endHandle.focus()}}_calculateRangeOffset(e,t){if(this._initialPageXPosition===e){return[this.startValue,this.endValue]}const s=this._effectiveMin;const i=this._effectiveMax;const a=this.endValue-this.startValue;let n=this._calculateStartValueByOffset(e,t);const r=this.constructor;n=r.clipValue(n,s,i-a);return[n,n+a]}_calculateStartValueByOffset(e,t){const s=this._effectiveMin;const i=this._effectiveMax;const a=this._effectiveStep;const n=this.getBoundingClientRect();let r;let l;let d;const u=this.constructor;if(e>this._initialPageXPosition){d=e-this._initialPageXPosition;l=t+d;r=u.computedValueFromPageX(l,s,i,n,this.directionStart);r=u.getSteppedValue(r,a,s)}else{d=this._initialPageXPosition-e;l=t-d;r=u.computedValueFromPageX(l,s,i,n,this.directionStart);r=u.getSteppedValue(r,a,s)}return r}_updateHandlesAndRange(e){const t=this._effectiveMax;const s=this._effectiveMin;const i=this.getStoredPropertyState("startValue")||0;const a=this.getStoredPropertyState("endValue")||0;const n=this._valueAffected;if(n==="startValue"){this._selectedRange=(a-e)/(t-s);this._firstHandlePositionFromStart=(e-s)/(t-s)*100}else if(n==="endValue"){this._selectedRange=(e-i)/(t-s);this._secondHandlePositionFromStart=(e-s)/(t-s)*100}else{this._selectedRange=(this.endValue-this.startValue)/(t-s);this._firstHandlePositionFromStart=(this.startValue-s)/(t-s)*100;this._secondHandlePositionFromStart=(this.endValue-s)/(t-s)*100}}_swapValues(){const e=this._valueAffected;if(!e){return}if(e==="startValue"&&this.startValue>this.endValue){const e=this.endValue;this.endValue=this.startValue;this.startValue=e}if(e==="endValue"&&this.endValue<this.startValue){const e=this.startValue;this.startValue=this.endValue;this.endValue=e}this._setValuesAreReversed();this._updateHandlesAndRange(this[e]);this.focusInnerElement();this.syncUIAndState()}_setValuesAreReversed(){this._reversedValues=!this._reversedValues}_areValuesReversed(){return this._reversedValues}get tickmarksObject(){const e=this._tickmarksCount;const t=[];if(this._hiddenTickmarks){return[false,false]}for(let s=0;s<=e;s++){const e=this._effectiveMin+s*this.step>=this.startValue;const i=this._effectiveMin+s*this.step<=this.endValue;t.push(e&&i)}return t}get _startHandle(){return this.shadowRoot.querySelector(".ui5-slider-handle--start")}get _endHandle(){return this.shadowRoot.querySelector(".ui5-slider-handle--end")}get _progressBar(){return this.shadowRoot.querySelector(".ui5-slider-progress")}get _ariaLabelledByStartHandleRefs(){return[`${this._id}-accName`,`${this._id}-startHandleDesc`].join(" ").trim()}get _ariaLabelledByEndHandleRefs(){return[`${this._id}-accName`,`${this._id}-endHandleDesc`].join(" ").trim()}get _ariaLabelledByProgressBarRefs(){return[`${this._id}-accName`,`${this._id}-sliderDesc`].join(" ").trim()}get styles(){return{progress:{width:`${this._selectedRange*100}%`,"transform-origin":`${this.directionStart} top`,[this.directionStart]:`${this._firstHandlePositionFromStart}%`},startHandle:{[this.directionStart]:`${this._firstHandlePositionFromStart}%`},endHandle:{[this.directionStart]:`${this._secondHandlePositionFromStart}%`},label:{width:`${this._labelWidth}%`},labelContainer:{width:`100%`,[this.directionStart]:`-${this._labelWidth/2}%`},tooltip:{visibility:`${this._tooltipVisibility}`}}}static async onDefine(){f.i18nBundle=await(0,a.getI18nBundle)("@ui5/webcomponents")}};c([(0,s.default)({validator:i.default,defaultValue:0})],_.prototype,"startValue",void 0);c([(0,s.default)({validator:i.default,defaultValue:100})],_.prototype,"endValue",void 0);c([(0,s.default)({type:Boolean})],_.prototype,"rangePressed",void 0);_=f=c([(0,t.default)({tag:"ui5-range-slider",languageAware:true,template:d.default,dependencies:[l.default],styles:[r.default.styles,o.default]})],_);_.define();var V=_;e.default=V});
//# sourceMappingURL=RangeSlider.js.map