/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/InvisibleText","sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/library","./library","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/core/Configuration","sap/ui/layout/Grid","sap/ui/layout/GridData","sap/ui/dom/jquery/Focusable"],function(t,jQuery,e,i,n,o,r,a,s,l){"use strict";var u=i.TitleLevel;var p=e.extend("sap.uxap.ObjectPageSectionBase",{metadata:{abstract:true,library:"sap.uxap",properties:{title:{type:"string",group:"Appearance",defaultValue:null},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:u.Auto},titleVisible:{type:"boolean",group:"Appearance",defaultValue:true},visible:{type:"boolean",group:"Appearance",defaultValue:true},importance:{type:"sap.uxap.Importance",group:"Behavior",defaultValue:n.Importance.High}},aggregations:{ariaLabelledBy:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"},customAnchorBarButton:{type:"sap.m.Button",multiple:false},_grid:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}},renderer:null});p.prototype.init=function(){this._bInternalVisible=true;this._bInternalTitleVisible=true;this._sInternalTitle="";this._sInternalTitleLevel=u.Auto;this._isHidden=false;this._oGridContentObserver=null;this._bRtl=a.getRTL()};p.prototype.onAfterRendering=function(){if(this._getObjectPageLayout()){this._getObjectPageLayout()._requestAdjustLayout().catch(function(){o.debug("ObjectPageSectionBase :: cannot adjustLayout",this)});this._getObjectPageLayout()._setSectionsFocusValues()}};p.prototype.onBeforeRendering=function(){var t="ariaLabelledBy";if(!this.getAggregation(t)){this.setAggregation(t,this._getAriaLabelledBy(),true)}else{this.updateInvisibleTextLabelValue()}};p.prototype.exit=function(){if(this._oInvisibleText){this._oInvisibleText.destroy();this._oInvisibleText=null}};p.prototype.setShowTitle=function(t){this.setProperty("showTitle",t);this.setTitleVisible();return this};p.prototype.setTitleVisible=function(t){return this.setProperty("titleVisible",this._isTitleVisible(),true)};p.prototype._getGrid=function(){if(!this.getAggregation("_grid")&&!this._bIsBeingDestroyed){this.setAggregation("_grid",new s({id:this.getId()+"-innerGrid",defaultSpan:"XL12 L12 M12 S12",hSpacing:1,vSpacing:1,width:"100%",containerQuery:true}),true);if(this._oGridContentObserver){this._oGridContentObserver.observe(this.getAggregation("_grid"),{aggregations:["content","subSections"]})}}return this.getAggregation("_grid")};p.prototype._resetLayoutData=function(t){t.forEach(function(t){if(t.getLayoutData()){t.destroyLayoutData()}},this)};p.prototype._assignLayoutData=function(t,e){var i=12,n=[],o=[],r,a,s,u;r={iRemaining:e.M,iColumnConfig:e.M};a={iRemaining:e.L,iColumnConfig:e.L};s={iRemaining:e.XL,iColumnConfig:e.XL};u=[s,a,r];t.forEach(function(t){if(t.getVisible&&t.getVisible()){n.push(t)}else{o.push(t)}});n.forEach(function(t,e){u.forEach(function(i){i.iCalculatedSize=this._getEffectiveColspanForGridItem(t,i.iRemaining,n,e,i.iColumnConfig)},this);t.setLayoutData(new l({spanS:i,spanM:r.iCalculatedSize*(i/r.iColumnConfig),spanL:a.iCalculatedSize*(i/a.iColumnConfig),spanXL:s.iCalculatedSize*(i/s.iColumnConfig),linebreakM:e>0&&r.iRemaining===r.iColumnConfig,linebreakL:e>0&&a.iRemaining===a.iColumnConfig,linebreakXL:e>0&&s.iRemaining===s.iColumnConfig}));if(t.isA("sap.uxap.ObjectPageSubSection")){t._oLayoutConfig={M:r.iCalculatedSize,L:a.iCalculatedSize,XL:s.iCalculatedSize}}u.forEach(function(t){t.iRemaining-=t.iCalculatedSize;if(t.iRemaining<1){t.iRemaining=t.iColumnConfig}})},this);o.forEach(function(t){t.setLayoutData(new l({visibleS:false,visibleM:false,visibleL:false,visibleXL:false}))});return n};p.prototype._getEffectiveColspanForGridItem=function(t,e,i,n,o){var r,a=o,s,l=this._getMinRequiredColspanForChild(t);if(!this._allowAutoextendColspanForChild(t)){return Math.min(o,l)}for(s=1;s<=a;s++){r=this._getMinRequiredColspanForChild(i[n+s]);if(r<=e-l){e-=r}else{break}}return e};p.prototype._getMinRequiredColspanForChild=function(t){};p.prototype._allowAutoextendColspanForChild=function(t){};p.prototype.setCustomAnchorBarButton=function(t){var e=this.setAggregation("customAnchorBarButton",t,true);if(this._getObjectPageLayout()){this._getObjectPageLayout()._updateNavigation()}return e};p.prototype.getSectionText=function(){return""};p.prototype.updateInvisibleTextLabelValue=function(){var t=this.getAggregation("ariaLabelledBy"),e=this._getAriaLabelledByText();if(t){sap.ui.getCore().byId(t.getId()).setText(e)}return this};p.prototype._getAriaLabelledBy=function(){var t=this._getAriaLabelledByText();return this._getInvisibleText().setText(t)};p.prototype._getAriaLabelledByText=function(){return this._getTitle()};p.prototype._getInvisibleText=function(){if(!this._oInvisibleText){this._oInvisibleText=new t;this._oInvisibleText.toStatic()}return this._oInvisibleText};p.prototype._getShouldLabelTitle=function(){return this.getShowTitle?this.getShowTitle():true};p.prototype._setInternalVisible=function(t,e){if(t!=this._bInternalVisible){this._bInternalVisible=t;if(e){this.invalidate()}}};p.prototype._getInternalVisible=function(){return this._bInternalVisible};p.prototype._setInternalTitleVisible=function(t,e){if(t!=this._bInternalTitleVisible){this._bInternalTitleVisible=t;this.setTitleVisible();if(e){this.invalidate()}}};p.prototype._getInternalTitleVisible=function(){return this._bInternalTitleVisible};p.prototype._setInternalTitle=function(t,e){if(t!=this._sInternalTitle){this._sInternalTitle=t;if(e){this.invalidate()}}};p.prototype._getTitle=function(){return this._getInternalTitle()||this.getTitle()};p.prototype._getInternalTitle=function(){return this._sInternalTitle};p.prototype._getARIALevel=function(){var t=this._getTitleLevel();if(t===u.Auto){t=u.H2}return t.slice(-1)};p.prototype._getTitleLevel=function(){var t=this.getTitleLevel();return t===u.Auto?this._getInternalTitleLevel():t};p.prototype._setInternalTitleLevel=function(t,e){if(t!==this._sInternalTitleLevel){this._sInternalTitleLevel=t;if(e){this.invalidate()}}};p.prototype._getInternalTitleLevel=function(){return this._sInternalTitleLevel};p.prototype._getObjectPageLayout=function(){return n.Utilities.getClosestOPL(this)};p.prototype._notifyObjectPageLayout=function(){if(this._getObjectPageLayout()&&this._getObjectPageLayout().$().length){this._getObjectPageLayout()._requestAdjustLayoutAndUxRules()}};["addAggregation","insertAggregation","removeAllAggregation","removeAggregation","destroyAggregation"].forEach(function(t){p.prototype[t]=function(i,n,o,r){if(["addAggregation","removeAggregation"].indexOf(t)>-1){r=o}if(["removeAllAggregation","destroyAggregation"].indexOf(t)>-1){r=n}var a=e.prototype[t].apply(this,arguments);if(r!==true){this._notifyObjectPageLayout()}return a}});p.prototype.setVisible=function(t,e){if(this.getVisible()===t){return this}if(!this._getObjectPageLayout()){return this.setProperty("visible",t,e)}this.setProperty("visible",t,true);this._notifyObjectPageLayout();this.invalidate();return this};p.prototype.setTitle=function(t,e){this.setProperty("title",t,e);this._notifyObjectPageLayout();this.updateInvisibleTextLabelValue();return this};p.prototype._shouldBeHidden=function(){return p._importanceMap[this.getImportance()]>p._importanceMap[this._sCurrentLowestImportanceLevelToShow]};p._importanceMap={Low:3,Medium:2,High:1};p.prototype._updateShowHideState=function(t){var e=this._getObjectPageLayout();this._isHidden=t;this.setTitleVisible();this.$().children(this._sContainerSelector).toggle(!t);if(e){e._requestAdjustLayout()}return this};p.prototype._getIsHidden=function(){return this._isHidden};p.prototype._expandSection=function(){return this._updateShowHideState(false)};p.prototype._showHideContent=function(){return this._updateShowHideState(!this._getIsHidden())};p.prototype._applyImportanceRules=function(t){this._sCurrentLowestImportanceLevelToShow=t;this.setTitleVisible();if(this.getDomRef()){this._updateShowHideState(this._shouldBeHidden())}else{this._isHidden=this._shouldBeHidden();this.setTitleVisible()}};p.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;p.prototype.onkeydown=function(t){if(t.keyCode===r.SPACE&&t.srcControl.isA("sap.uxap.ObjectPageSection")){t.preventDefault()}if(t.keyCode===r.F7){var e=this.getSubSections(),i=e[0],n;if(e.length===1){n=i._oLastFocusedControlF7;if(n){n.$().trigger("focus")}else{i.$().firstFocusableDomRef().focus()}}else{if(i.getActions().length){i.getActions()[0].$().trigger("focus")}}}};p.prototype.onsapdown=function(t){var e=t.currentTarget,i=e.nextSibling;if(e.classList.contains("sapUxAPObjectPageSubSection")){var n=e.parentElement;if(n.nextElementSibling){i=n.nextElementSibling.querySelector(".sapUxAPObjectPageSubSection")}}this._handleFocusing(t,i)};p.prototype._handleFocusing=function(t,e){var i;if(this._targetIsCorrect(t)&&e){i=jQuery(t.currentTarget).parent().children();t.preventDefault();e.focus();if(i.length>1){this._scrollParent(jQuery(e).attr("id"))}}};p.prototype._targetIsCorrect=function(t){return t.srcControl===this};p.prototype.onsapright=function(t){var e=this._bRtl?"onsapup":"onsapdown";this[e](t)};p.prototype.onsapup=function(t){var e=t.currentTarget,i=e.previousSibling;if(e.classList.contains("sapUxAPObjectPageSubSection")){var n=e.parentElement;if(n.previousElementSibling){i=n.previousElementSibling.querySelector(".sapUxAPObjectPageSubSection")}}this._handleFocusing(t,i)};p.prototype.onsapleft=function(t){var e=this._bRtl?"onsapdown":"onsapup";this[e](t)};p.prototype.onsaphome=function(t){var e=t.currentTarget,i=e.parentElement.firstChild;if(e.classList.contains("sapUxAPObjectPageSubSection")){i=e.closest(".sapUxAPObjectPageSection").querySelector(".sapUxAPObjectPageSubSection")}this._handleFocusing(t,i)};p.prototype.onsapend=function(t){var e=t.currentTarget,i=e.parentElement.lastChild,n;if(e.classList.contains("sapUxAPObjectPageSubSection")){n=e.closest(".sapUxAPObjectPageSection").querySelectorAll(".sapUxAPObjectPageSubSection");i=n[n.length-1]}this._handleFocusing(t,i)};p.prototype.onsappageup=function(t){if(!this._targetIsCorrect(t)){return}t.preventDefault();var e,i=t.currentTarget;var n=jQuery(i).parent().children();var o;if(i.classList.contains("sapUxAPObjectPageSubSection")){n=jQuery(i.closest(".sapUxAPObjectPageSection")).find(".sapUxAPObjectPageSubSection")}n.each(function(i,n){if(jQuery(n).attr("id")===t.currentTarget.id){e=i-(p.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1);return}});if(e&&n[e]){n[e].focus();o=jQuery(n[e]).attr("id")}else if(n[0]){n[0].focus();o=jQuery(n[0]).attr("id")}if(n.length>1){this._scrollParent(o)}};p.prototype.onsappagedown=function(t){if(!this._targetIsCorrect(t)){return}t.preventDefault();var e,i=t.currentTarget;var n=jQuery(i).parent().children();var o;if(i.classList.contains("sapUxAPObjectPageSubSection")){n=jQuery(i.closest(".sapUxAPObjectPageSection")).find(".sapUxAPObjectPageSubSection")}n.each(function(i,n){if(jQuery(n).attr("id")===t.currentTarget.id){e=i+p.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1;return}});if(e&&n[e]){n[e].focus();o=jQuery(n[e]).attr("id")}else if(n[n.length-1]){n[n.length-1].focus();o=jQuery(n[n.length-1]).attr("id")}if(n.length>1){this._scrollParent(o)}};p.prototype._scrollParent=function(t){if(this._getObjectPageLayout()){this._getObjectPageLayout().scrollToSection(t,0,10)}};return p});
//# sourceMappingURL=ObjectPageSectionBase.js.map