//@ui5-bundle Calendar-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/future", ["sap/base/assert","sap/base/config","sap/base/Log"],(e,s,r)=>{"use strict";const f=s.get({name:"sapUiXxFuture",type:s.Type.Boolean,external:true});let i=f;function a(e,s,f,...a){if(i){throw new Error(s,{cause:f?.cause})}if(f){if(f.suffix){s+=" "+f.suffix}if(f.cause){a.unshift(f.cause)}if(!f.cause&&!f.suffix){a.unshift(f)}}r[e]("[FUTURE FATAL] "+s,...a)}function t(e,s,f,a,t,...n){if(i){s(new Error(a,{cause:t?.cause}));return}if(t){if(t.suffix){a+=" "+t.suffix}if(t.cause){n.unshift(t.cause)}if(!t.cause&&!t.suffix){n.unshift(t)}}e();r[f]("[FUTURE FATAL] "+a,...n)}const n={get active(){return i},set active(e){i=!!(e??f)},fatalThrows(...e){a("fatal",...e)},errorThrows(...e){a("error",...e)},warningThrows(...e){a("warning",...e)},assertThrows(s,r){const f=typeof r==="function"?r():r;if(!s&&i){throw new Error(r)}e(s,"[FUTURE FATAL] "+f)},warningRejects(e,s,...r){t(e,s,"warning",...r)}};return n});
/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/base/i18n/Formatting", ["sap/base/assert","sap/base/config","sap/base/Eventing","sap/base/Log","sap/base/i18n/Localization","sap/base/i18n/LanguageTag","sap/base/i18n/date/CalendarType","sap/base/i18n/date/CalendarWeekNumbering","sap/base/util/deepEqual","sap/base/util/extend","sap/base/util/isEmptyObject"],(e,t,a,r,n,s,i,o,u,m,l)=>{"use strict";const d=new a;const g=t.getWritableInstance();const p={};let c;let y;let f=false;const b={"":{pattern:null},1:{pattern:"dd.MM.yyyy"},2:{pattern:"MM/dd/yyyy"},3:{pattern:"MM-dd-yyyy"},4:{pattern:"yyyy.MM.dd"},5:{pattern:"yyyy/MM/dd"},6:{pattern:"yyyy-MM-dd"},7:{pattern:"Gyy.MM.dd"},8:{pattern:"Gyy/MM/dd"},9:{pattern:"Gyy-MM-dd"},A:{pattern:"yyyy/MM/dd"},B:{pattern:"yyyy/MM/dd"},C:{pattern:"yyyy/MM/dd"}};const C={"":{short:null,medium:null,dayPeriods:null},0:{short:"HH:mm",medium:"HH:mm:ss",dayPeriods:null},1:{short:"hh:mm a",medium:"hh:mm:ss a",dayPeriods:["AM","PM"]},2:{short:"hh:mm a",medium:"hh:mm:ss a",dayPeriods:["am","pm"]},3:{short:"KK:mm a",medium:"KK:mm:ss a",dayPeriods:["AM","PM"]},4:{short:"KK:mm a",medium:"KK:mm:ss a",dayPeriods:["am","pm"]}};const A={"":{groupingSeparator:null,decimalSeparator:null}," ":{groupingSeparator:".",decimalSeparator:","},X:{groupingSeparator:",",decimalSeparator:"."},Y:{groupingSeparator:" ",decimalSeparator:","}};function P(e,t){if(!e){throw new TypeError(t)}}function h(e,a){t._.invalidate();const r=p[e];if(a!=null){p[e]=a}else{delete p[e]}if((r!=null||a!=null)&&!u(r,a)){const t=!c;c??={};c[e]=a;if(t){F()}}}function T(e){let t;if(e&&typeof e==="string"){try{t=new s(e)}catch(e){}}else if(e instanceof s){t=e}return t}const S={attachChange(e){d.attachEvent("change",e)},detachChange(e){d.detachEvent("change",e)},getLanguageTag(){function e(){let e=new s(n.getLanguage());if(!l(p)||S.getCalendarWeekNumbering()!==o.Default){let t=e.toString();if(t.indexOf("-x-")<0){t+="-x-sapufmt"}else if(t.indexOf("-sapufmt")<=t.indexOf("-x-")){t+="-sapufmt"}e=new s(t)}return e}return g.get({name:"sapUiFormatLocale",type:function(e){return new s(e)},defaultValue:e,external:true})},setLanguageTag(e){const t=T(e);P(e==null||t,"vLanguageTag must be a BCP47 language tag or Java Locale id or null");const a=S.getLanguageTag();g.set("sapUiFormatLocale",t?.toString());const r=S.getLanguageTag();if(a.toString()!==r.toString()){const e=!c;c??={};c.languageTag=r.toString();if(e){F()}}},_set:h,getCustomUnits(){return p["units"]?.["short"]},setCustomUnits(e){let t=null;if(e){t={short:e}}h("units",t)},addCustomUnits(e){const t=S.getCustomUnits();if(t){e=m({},t,e)}S.setCustomUnits(e)},setUnitMappings(e){h("unitMappings",e)},addUnitMappings(e){const t=S.getUnitMappings();if(t){e=m({},t,e)}S.setUnitMappings(e)},getUnitMappings(){return p["unitMappings"]},getDatePattern(t){e(t=="short"||t=="medium"||t=="long"||t=="full","sStyle must be short, medium, long or full");return p["dateFormats-"+t]},setDatePattern(e,t){P(e=="short"||e=="medium"||e=="long"||e=="full","sStyle must be short, medium, long or full");h("dateFormats-"+e,t)},getTimePattern(t){e(t=="short"||t=="medium"||t=="long"||t=="full","sStyle must be short, medium, long or full");return p["timeFormats-"+t]},setTimePattern(e,t){P(e=="short"||e=="medium"||e=="long"||e=="full","sStyle must be short, medium, long or full");h("timeFormats-"+e,t)},getNumberSymbol(t){e(["group","decimal","plusSign","minusSign"].includes(t),"sType must be decimal, group, plusSign or minusSign");return p["symbols-latn-"+t]},setNumberSymbol(e,t){P(["group","decimal","plusSign","minusSign"].includes(e),"sType must be decimal, group, plusSign or minusSign");h("symbols-latn-"+e,t)},getCustomCurrencies(){return p["currency"]},setCustomCurrencies(e){P(typeof e==="object"||e==null,"mCurrencyDigits must be an object");Object.keys(e||{}).forEach(function(t){P(typeof t==="string");P(typeof e[t]==="object")});h("currency",e)},addCustomCurrencies(e){const t=S.getCustomCurrencies();if(t){e=m({},t,e)}S.setCustomCurrencies(e)},_setDayPeriods(t,a){e(t=="narrow"||t=="abbreviated"||t=="wide","sWidth must be narrow, abbreviated or wide");h("dayPeriods-format-"+t,a)},getABAPDateFormat(){const e=g.get({name:"sapUiABAPDateFormat",type:t.Type.String,defaultValue:g.get({name:"sapUiLegacyDateFormat",type:t.Type.String,external:true}),external:true});return e?e.toUpperCase():undefined},setABAPDateFormat(e){e=e?String(e).toUpperCase():"";P(b.hasOwnProperty(e),"sFormatId must be one of ['1','2','3','4','5','6','7','8','9','A','B','C'] or empty");const t=!c;const a=S.getABAPDateFormat();if(a!==e||!f){c??={};g.set("sapUiABAPDateFormat",e);c.ABAPDateFormat=e;S.setDatePattern("short",b[e].pattern);S.setDatePattern("medium",b[e].pattern);if(t){F()}}},getABAPTimeFormat(){const e=g.get({name:"sapUiABAPTimeFormat",type:t.Type.String,defaultValue:g.get({name:"sapUiLegacyTimeFormat",type:t.Type.String,external:true}),external:true});return e?e.toUpperCase():undefined},setABAPTimeFormat(e){e=e||"";P(C.hasOwnProperty(e),"sFormatId must be one of ['0','1','2','3','4'] or empty");const t=!c;const a=S.getABAPTimeFormat();if(a!==e||!f){c??={};g.set("sapUiABAPTimeFormat",e);c.ABAPTimeFormat=e;S.setTimePattern("short",C[e]["short"]);S.setTimePattern("medium",C[e]["medium"]);S._setDayPeriods("abbreviated",C[e].dayPeriods);if(t){F()}}},getABAPNumberFormat(){const e=g.get({name:"sapUiABAPNumberFormat",type:t.Type.String,defaultValue:g.get({name:"sapUiLegacyNumberFormat",type:t.Type.String,external:true}),external:true});return e?e.toUpperCase():undefined},setABAPNumberFormat(e){e=e?e.toUpperCase():"";P(A.hasOwnProperty(e),"sFormatId must be one of [' ','X','Y'] or empty");const t=!c;const a=S.getABAPNumberFormat();if(a!==e||!f){c??={};g.set("sapUiABAPNumberFormat",e);c.ABAPNumberFormat=e;S.setNumberSymbol("group",A[e].groupingSeparator);S.setNumberSymbol("decimal",A[e].decimalSeparator);if(t){F()}}},setCustomIslamicCalendarData(e){P(Array.isArray(e),"aCustomCalendarData must be an Array");const t=!c;c??={};y=c.customIslamicCalendarData=e.slice();if(t){F()}},getCustomIslamicCalendarData(){return y?.slice()??undefined},setTrailingCurrencyCode(e){P(typeof e==="boolean","bTrailingCurrencyCode must be a boolean");g.set("sapUiTrailingCurrencyCode",e)},getTrailingCurrencyCode(){return g.get({name:"sapUiTrailingCurrencyCode",type:t.Type.Boolean,defaultValue:true,external:true})},getCustomLocaleData(){return p},getCalendarWeekNumbering(){let e=o.Default;try{e=g.get({name:"sapUiCalendarWeekNumbering",type:o,defaultValue:o.Default,external:true})}catch(e){}return e},setCalendarWeekNumbering(e){t._.checkEnum(o,e,"calendarWeekNumbering");const a=g.get({name:"sapUiCalendarWeekNumbering",type:o,defaultValue:o.Default,external:true});if(a!==e){const t=!c;c??={};g.set("sapUiCalendarWeekNumbering",e);c.calendarWeekNumbering=e;if(t){F()}}},getCalendarType(){let e,a=g.get({name:"sapUiCalendarType",type:t.Type.String,external:true});a??=null;if(a){for(e in i){if(e.toLowerCase()===a.toLowerCase()){return e}}r.warning("Parameter 'calendarType' is set to "+a+" which isn't a valid value and therefore ignored. The calendar type is determined from format setting and current locale")}const s=S.getABAPDateFormat();switch(s){case"1":case"2":case"3":case"4":case"5":case"6":return i.Gregorian;case"7":case"8":case"9":return i.Japanese;case"A":case"B":return i.Islamic;case"C":return i.Persian;default:return n.getPreferredCalendarType()}},setCalendarType(e){const t=S.getCalendarType();g.set("sapUiCalendarType",e);const a=S.getCalendarType();if(t!==a){const e=!c;c??={};c.calendarType=a;if(e){F()}}}};function F(){d.fireEvent("change",c);c=undefined}function M(){const e=S.getABAPDateFormat();if(e!==undefined){S.setABAPDateFormat(e)}const t=S.getABAPNumberFormat();if(t!==undefined){S.setABAPNumberFormat(t)}const a=S.getABAPTimeFormat();if(a!==undefined){S.setABAPTimeFormat(a)}f=true}M();return S});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/i18n/date/CalendarWeekNumbering", ["sap/base/i18n/date/_EnumHelper"],function(e){"use strict";var a={Default:"Default",ISO_8601:"ISO_8601",MiddleEastern:"MiddleEastern",WesternTraditional:"WesternTraditional"};e.register("sap.base.i18n.date.CalendarWeekNumbering",a);Object.defineProperty(a,"getWeekConfigurationValues",{value:function(e){switch(e){case a.ISO_8601:return{firstDayOfWeek:1,minimalDaysInFirstWeek:4};case a.MiddleEastern:return{firstDayOfWeek:6,minimalDaysInFirstWeek:1};case a.WesternTraditional:return{firstDayOfWeek:0,minimalDaysInFirstWeek:1};default:return undefined}}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/ObjectPath", [],function(){"use strict";var r={};var e=globalThis;function t(r){return Array.isArray(r)?r.slice():r.split(".")}r.create=function(r,n){var a=n||e;var o=t(r);for(var i=0;i<o.length;i++){var u=o[i];if(a[u]===null||a[u]!==undefined&&(typeof a[u]!=="object"&&typeof a[u]!=="function")){throw new Error("Could not set object-path for '"+o.join(".")+"', path segment '"+u+"' already exists.")}a[u]=a[u]||{};a=a[u]}return a};r.get=function(r,n){var a=n||e;var o=t(r);var i=o.pop();for(var u=0;u<o.length&&a;u++){a=a[o[u]]}return a?a[i]:undefined};r.set=function(n,a,o){o=o||e;var i=t(n);var u=i.pop();var f=r.create(i,o);f[u]=a};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/array/uniqueSort", ["sap/base/assert"],function(r){"use strict";var a=function(a){r(Array.isArray(a),"uniqueSort: input parameter must be an Array");var e=a.length;if(e>1){a.sort();var i=0;for(var t=1;t<e;t++){if(a.indexOf(a[t])===t){a[++i]=a[t]}}if(++i<e){a.splice(i,e-i)}}return a};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/deepEqual", ["sap/base/Log"],function(e){"use strict";var r=function(t,n,f,a,u){if(typeof f=="boolean"){a=f;f=undefined}if(!u){u=0}if(!f){f=10}if(u>f){e.warning("deepEqual comparison exceeded maximum recursion depth of "+f+". Treating values as unequal");return false}if(t===n||Number.isNaN(t)&&Number.isNaN(n)){return true}if(Array.isArray(t)&&Array.isArray(n)){if(!a&&t.length!==n.length){return false}if(t.length>n.length){return false}for(var i=0;i<t.length;i++){if(!r(t[i],n[i],f,a,u+1)){return false}}return true}if(typeof t=="object"&&typeof n=="object"){if(!t||!n){return false}if(t.constructor!==n.constructor){return false}if(!a&&Object.keys(t).length!==Object.keys(n).length){return false}if(t instanceof Node){return t.isEqualNode(n)}if(t instanceof Date){return t.valueOf()===n.valueOf()}for(var i in t){if(!r(t[i],n[i],f,a,u+1)){return false}}return true}return false};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/isEmptyObject", [],function(){"use strict";var r=function r(n){for(var e in n){return false}return true};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/resolveReference", ["sap/base/util/ObjectPath"],function(t){"use strict";var n=Object.create(null);function e(e,i,o){var r,f;if(i&&e[0]in i){f=e.length>1?t.get(e.slice(0,-1),i):i;r=f&&f[e[e.length-1]];if(typeof r==="function"&&o.bindContext){r=r.bind(o.rootContext||f)}return r}return n}var i=function(i,o,r){o=o||{};r=r||{};r.bindContext=r.bindContext!==false;r.bindDotContext=r.bindDotContext!==false;var f=i.split("."),u=f.shift()||".",d=u===".",b=n;f.unshift(u);if(r.preferDotContext&&!d){b=e(f,o["."],{bindContext:r.bindContext&&r.bindDotContext,rootContext:o["."]})}if(b===n){b=e(f,o,{bindContext:r.bindContext&&(d?r.bindDotContext:f.length>1),rootContext:d?o["."]:undefined})}if(!d){if(b===n&&r.useProbingRequire){b=sap.ui.require(i.replace(/\./g,"/"));if(b===undefined){b=n}}if(b===n){b=t.get(i)}}return b===n?undefined:b};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/DataType", ["sap/base/future","sap/base/util/ObjectPath","sap/base/assert","sap/base/Log","sap/base/util/isPlainObject","sap/base/util/resolveReference","sap/base/i18n/date/_EnumHelper"],function(e,t,n,r,a,i,u){"use strict";var o=function(){throw new Error};o.prototype.getName=function(){return undefined};o.prototype.getBaseType=function(){return undefined};o.prototype.getPrimitiveType=function(){var e=this;while(e.getBaseType()){e=e.getBaseType()}return e};o.prototype.getComponentType=function(){return undefined};o.prototype.getDefaultValue=function(){return undefined};o.prototype.isArrayType=function(){return false};o.prototype.isEnumType=function(){return false};o.prototype.getEnumValues=function(){return undefined};o.prototype.parseValue=function(e){return e};o.prototype.isValid=undefined;o.prototype.setNormalizer=function(e){n(typeof e==="function","DataType.setNormalizer: fnNormalizer must be a function");this._fnNormalizer=typeof e==="function"?e:undefined};o.prototype.normalize=function(e){return this._fnNormalizer?this._fnNormalizer(e):e};function s(e,t,n){t=t||{};var r=n||o.prototype;var a=Object.create(r);a.getName=function(){return e};if(t.hasOwnProperty("defaultValue")){var i=t.defaultValue;a.getDefaultValue=function(){return i}}if(t.isValid){var u=t.isValid;a.isValid=r.isValid?function(e){if(!r.isValid(e)){return false}return u(e)}:u}if(t.parseValue){a.parseValue=t.parseValue}a.getBaseType=function(){return n};return a}var f={any:s("any",{defaultValue:null,isValid:function(e){return true}}),boolean:s("boolean",{defaultValue:false,isValid:function(e){return typeof e==="boolean"},parseValue:function(e){return e=="true"}}),int:s("int",{defaultValue:0,isValid:function(e){return typeof e==="number"&&(isNaN(e)||Math.floor(e)==e)},parseValue:function(e){return parseInt(e)}}),float:s("float",{defaultValue:0,isValid:function(e){return typeof e==="number"},parseValue:function(e){return parseFloat(e)}}),string:s("string",{defaultValue:"",isValid:function(e){return typeof e==="string"||e instanceof String},parseValue:function(e){return e}}),object:s("object",{defaultValue:null,isValid:function(e){return typeof e==="object"||typeof e==="function"},parseValue:function(e){return e?JSON.parse(e):null}}),function:s("function",{defaultValue:null,isValid:function(e){return e==null||typeof e==="function"},parseValue:function(e,t){if(e===""){return undefined}if(!/^\.?[A-Z_\$][A-Z0-9_\$]*(\.[A-Z_\$][A-Z0-9_\$]*)*$/i.test(e)){throw new Error("Function references must consist of dot separated "+"simple identifiers (A-Z, 0-9, _ or $) only, but was '"+e+"'")}var n,r=t&&t.context,a=t&&t.locals;n=i(e,Object.assign({".":r},a));if(n&&this.isValid(n)){return n}throw new TypeError("The string '"+e+"' couldn't be resolved to a function")}})};var p=s("array",{defaultValue:[]});function l(e){n(e instanceof o,"DataType.<createArrayType>: componentType must be a DataType");var t=Object.create(o.prototype);t.getName=function(){return e.getName()+"[]"};t.getComponentType=function(){return e};t.isValid=function(t){if(t===null){return true}if(Array.isArray(t)){for(var n=0;n<t.length;n++){if(!e.isValid(t[n])){return false}}return true}return false};t.parseValue=function(t){var n=t.split(",");for(var r=0;r<n.length;r++){n[r]=e.parseValue(n[r])}return n};t.isArrayType=function(){return true};t.getBaseType=function(){return p};return t}const c=Object.create(null);function y(e,t){var n={},r;for(var a in t){var i=t[a];if(!r){r=i}if(typeof i!=="string"){throw new Error("Value "+i+" for enum type "+e+" is not a string")}if(!n.hasOwnProperty(i)||a==i){n[i]=a}}var u=Object.create(o.prototype);u.getName=function(){return e};u.isValid=function(e){return typeof e==="string"&&n.hasOwnProperty(e)};u.parseValue=function(e){return t[e]};u.getDefaultValue=function(){return r};u.getBaseType=function(){return f.string};u.isEnumType=function(){return true};u.getEnumValues=function(){return t};return u}o.getType=function(i){n(i&&typeof i==="string","sTypeName must be a non-empty string");var u=f[i];if(!(u instanceof o)){if(i.indexOf("[]",i.length-2)>0){var s=i.slice(0,-2),p=this.getType(s);u=p&&l(p);if(u){f[i]=u}}else if(i!=="array"){u=c[i];if(u==null){u=t.get(i);if(u!=null){r.error(`[DEPRECATED] The type '${i}' was accessed via globals. Defining types via globals is deprecated. `+`In case the referenced type is an enum: require the module 'sap/ui/base/DataType' and call the static 'DataType.registerEnum' API. `+`In case the referenced type is non-primitive, please note that only primitive types (and those derived from them) are supported for ManagedObject properties. `+`If the given type is an interface or a subclass of ManagedObject, you can define a "0..1" aggregation instead of a property`)}}if(u instanceof o){f[i]=u}else if(a(u)){u=f[i]=y(i,u);delete c[i]}else if(u){e.warningThrows("'"+i+"' is not a valid data type. Falling back to type 'any'.");u=f.any}else{e.errorThrows("data type '"+i+"' could not be found.");u=undefined}}}return u};o.createType=function(t,r,a){n(typeof t==="string"&&t,"DataType.createType: type name must be a non-empty string");n(a==null||a instanceof o||typeof a==="string"&&a,"DataType.createType: base type must be empty or a DataType or a non-empty string");if(/[\[\]]/.test(t)){e.errorThrows("DataType.createType: array types ('something[]') must not be created with createType, "+"they're created on-the-fly by DataType.getType")}if(typeof a==="string"){a=o.getType(a)}a=a||f.any;if(a.isArrayType()||a.isEnumType()){e.errorThrows("DataType.createType: base type must not be an array- or enum-type")}if(t==="array"||f[t]instanceof o){if(t==="array"||f[t].getBaseType()==null){throw new Error("DataType.createType: primitive or hidden type "+t+" can't be re-defined")}e.warningThrows("DataTypes.createType: type "+t+" is redefined. "+"This is an unsupported usage of DataType and might cause issues.")}var i=f[t]=s(t,r,a);return i};var d=new Set;o.registerInterfaceTypes=function(e){e.forEach(function(e){d.add(e);(()=>{t.set(e,e)})()})};o.registerEnum=function(e,t){c[e]=t};o._isEnumCandidate=function(e){return!Object.keys(e).some(t=>{const n=typeof e[t];return n==="object"||n==="function"})};o.isInterfaceType=function(e){return d.has(e)};o.createType("sap.ui.core.ID",{isValid:function(e){return/^([A-Za-z_][-A-Za-z0-9_.:]*)$/.test(e)}},o.getType("string"));u.inject(o.registerEnum);return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/Metadata", ["sap/base/util/ObjectPath","sap/base/assert","sap/base/Log","sap/base/util/array/uniqueSort"],function(t,e,a,s){"use strict";function r(t){return typeof t==="function"}var n=function(a,s){e(typeof a==="string"&&a,"Metadata: sClassName must be a non-empty string");e(typeof s==="object","Metadata: oClassInfo must be empty or an object");if(!s||typeof s.metadata!=="object"){s={metadata:s||{},constructor:t.get(a)};s.metadata.__version=1}s.metadata??={};s.metadata.__version=s.metadata.__version||2;if(!r(s.constructor)){throw Error("constructor for class "+a+" must have been declared before creating metadata for it")}this._sClassName=a;this._oClass=s.constructor;this.extend(s)};n.prototype.extend=function(t){this.applySettings(t);this.afterApplySettings()};n.prototype.applySettings=function(s){var o=this,i=s.metadata,p;if(i.baseType){var c,u=r(i.baseType);if(u){c=i.baseType;if(!r(c.getMetadata)){throw new TypeError("baseType must be a UI5 class with a static getMetadata function")}}if(!u){c=t.get(i.baseType);if(!r(c)){a.fatal("base class '"+i.baseType+"' does not exist")}}if(c.getMetadata){this._oParent=c.getMetadata();e(c===c.getMetadata().getClass(),"Metadata: oParentClass must match the class in the parent metadata")}else{this._oParent=new n(i.baseType,{})}}else{this._oParent=undefined}this._bAbstract=!!i["abstract"];this._bFinal=!!i["final"];this._sStereotype=i.stereotype||(this._oParent?this._oParent._sStereotype:"object");this._bDeprecated=!!i["deprecated"];this._aInterfaces=i.interfaces||[];this._aPublicMethods=i.publicMethods||[];this._bInterfacesUnique=false;p=this._oClass.prototype;for(var f in s){if(f!=="metadata"&&f!=="constructor"){p[f]=s[f];if(!f.match(/^_|^on|^init$|^exit$/)){o._aPublicMethods.push(f)}}}};n.prototype.afterApplySettings=function(){if(this._oParent){this._aAllPublicMethods=this._oParent._aAllPublicMethods.concat(this._aPublicMethods);this._bInterfacesUnique=false}else{this._aAllPublicMethods=this._aPublicMethods}};n.prototype.getStereotype=function(){return this._sStereotype};n.prototype.getName=function(){return this._sClassName};n.prototype.getClass=function(){return this._oClass};n.prototype.getParent=function(){return this._oParent};n.prototype._dedupInterfaces=function(){if(!this._bInterfacesUnique){s(this._aInterfaces);s(this._aPublicMethods);s(this._aAllPublicMethods);this._bInterfacesUnique=true}};n.prototype.getPublicMethods=function(){this._dedupInterfaces();return this._aPublicMethods};n.prototype.getAllPublicMethods=function(){this._dedupInterfaces();return this._aAllPublicMethods};n.prototype.getInterfaces=function(){this._dedupInterfaces();return this._aInterfaces};n.prototype.isInstanceOf=function(t){if(this._oParent){if(this._oParent.isInstanceOf(t)){return true}}var e=this._aInterfaces;for(var a=0,s=e.length;a<s;a++){if(e[a]===t){return true}}return false};Object.defineProperty(n.prototype,"_mImplementedTypes",{get:function(){if(this===n.prototype){throw new Error("sap.ui.base.Metadata: The '_mImplementedTypes' property must not be accessed on the prototype")}var t=Object.create(this._oParent?this._oParent._mImplementedTypes:null);t[this._sClassName]=true;var e=this._aInterfaces,a=e.length;while(a-- >0){if(!t[e[a]]){t[e[a]]=true}}Object.defineProperty(this,"_mImplementedTypes",{value:Object.freeze(t),writable:false,configurable:false});return t},configurable:true});n.prototype.isA=function(t){var e=this._mImplementedTypes;if(Array.isArray(t)){for(var a=0;a<t.length;a++){if(t[a]in e){return true}}return false}return t in e};n.prototype.isAbstract=function(){return this._bAbstract};n.prototype.isFinal=function(){return this._bFinal};n.prototype.isDeprecated=function(){return this._bDeprecated};n.prototype.addPublicMethods=function(t){var e=t instanceof Array?t:arguments;Array.prototype.push.apply(this._aPublicMethods,e);Array.prototype.push.apply(this._aAllPublicMethods,e);this._bInterfacesUnique=false};n.prototype.getStaticProperty=function(t){let e=this;while(e&&!(t in e.getClass())){e=e.getParent()}const a=e?.getClass();return a?.[t]};n.createClass=function(s,o,i,p){if(typeof s==="string"){p=i;i=o;o=s;s=null}e(!s||r(s));e(typeof o==="string"&&!!o);e(!i||typeof i==="object");e(!p||r(p));p=p||n;if(r(p.preprocessClassInfo)){i=p.preprocessClassInfo(i)}i=i||{};i.metadata=i.metadata||{};if(!i.hasOwnProperty("constructor")){i.constructor=undefined}var c=i.constructor;e(!c||r(c));if(s){if(!c){if(i.metadata.deprecated){c=function(){a.warning("Usage of deprecated class: "+o);s.apply(this,arguments)}}else{c=function(){s.apply(this,arguments)}}}c.prototype=Object.create(s.prototype);c.prototype.constructor=c;i.metadata.baseType=s}else{c=c||function(){};delete i.metadata.baseType}i.constructor=c;t.set(o,c);var u=new p(o,i);c.getMetadata=c.prototype.getMetadata=function(){return u};if(!c.getMetadata().isFinal()){c.extend=function(t,e,a){return n.createClass(c,t,e,a||p)}}return c};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/Object", ["./Metadata","sap/base/Log"],function(t,e){"use strict";var n=t.createClass("sap.ui.base.Object",{constructor:function(){if(!(this instanceof n)){throw Error('Cannot instantiate object: "new" is missing!')}}});n.prototype.destroy=function(){};n.prototype.getInterface=function(){var t=new n._Interface(this,this.getMetadata().getAllPublicMethods());this.getInterface=function(){return t};return t};n.defineClass=function(n,r,a){var i=new(a||t)(n,r);var s=i.getClass();s.getMetadata=s.prototype.getMetadata=function(){return i};if(!i.isFinal()){s.extend=function(e,n,r){return t.createClass(s,e,n,r||a)}}e.debug("defined class '"+n+"'"+(i.getParent()?" as subclass of "+i.getParent().getName():""));return i};n.prototype.isA=function(t){return this.getMetadata().isA(t)};n.isA=function(t,e){return t instanceof n&&t.isA(e)};n.isObjectA=function(t,e){return t instanceof n&&t.isA(e)};n._Interface=function(t,e,r){if(!t){return t}function a(t,e){return function(){var a=t[e].apply(t,arguments);if(r){return this}else{return a instanceof n?a.getInterface():a}}}if(!e){return{}}var i;for(var s=0,o=e.length;s<o;s++){i=e[s];if(!t[i]||typeof t[i]==="function"){this[i]=a(t,i)}}};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Locale", ["sap/base/assert","sap/ui/base/Object","sap/base/i18n/Localization","sap/base/i18n/LanguageTag"],function(t,n,e,a){"use strict";var i=Object.create(null);var s=n.extend("sap.ui.core.Locale",{constructor:function(t){n.apply(this);if(t instanceof a){this.oLanguageTag=t;this.sLocaleId=this.oLanguageTag.toString()}else{this.oLanguageTag=new a(t);this.sLocaleId=t}Object.assign(this,this.oLanguageTag);this.sLanguage=this.language},getLanguage:function(){return this.language},getScript:function(){return this.script},getRegion:function(){return this.region},getVariant:function(){return this.variant},getVariantSubtags:function(){return this.variantSubtags},getExtension:function(){return this.extension},getExtensionSubtags:function(){return this.extensionSubtags},getPrivateUse:function(){return this.privateUse},getPrivateUseSubtags:function(){return this.privateUseSubtags},hasPrivateUseSubtag:function(n){t(n&&n.match(/^[0-9A-Z]{1,8}$/i),"subtag must be a valid BCP47 private use tag");return this.privateUseSubtags.indexOf(n)>=0},toString:function(){return this.oLanguageTag.toString()},getSAPLogonLanguage:function(){return e._getSAPLogonLanguage(this)}});s._getCoreLocale=function(t){if(t instanceof a){t=i[t.toString()]||new s(t);i[t.toString()]=t}return t};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/LocaleData", ["./Locale","sap/base/assert","sap/base/i18n/Formatting","sap/base/i18n/LanguageTag","sap/base/i18n/Localization","sap/base/i18n/date/CalendarType","sap/base/i18n/date/CalendarWeekNumbering","sap/base/util/extend","sap/base/util/LoaderExtensions","sap/ui/base/Object","sap/ui/base/SyncPromise"],function(e,t,r,n,i,a,o,s,u,l,c){"use strict";var f=/c/i,g=/e/i,m=/^([+-]?)((\d+)(?:\.(\d+))?)[eE]([+-]?\d+)$/,h=/0+$/;const d=/(.*)?\{[0|1]}(.*)?\{[0|1]}(.*)?/;const p=/^0+$/;const _=["narrow","abbreviated","wide"];const y={"acceleration-meter-per-second-squared":"acceleration-meter-per-square-second","concentr-milligram-per-deciliter":"concentr-milligram-ofglucose-per-deciliter","concentr-part-per-million":"concentr-permillion","consumption-liter-per-100kilometers":"consumption-liter-per-100-kilometer","mass-metric-ton":"mass-tonne","pressure-millimeter-of-mercury":"pressure-millimeter-ofhg","pressure-pound-per-square-inch":"pressure-pound-force-per-square-inch","pressure-inch-hg":"pressure-inch-ofhg","torque-pound-foot":"torque-pound-force-foot"};let v={};var b=l.extend("sap.ui.core.LocaleData",{constructor:function(t,r){l.apply(this);this.oLocale=e._getCoreLocale(t);this.loaded=T(this.oLocale,r).then(e=>{this.mData=e.mData;this.sCLDRLocaleId=e.sCLDRLocaleId;return this});this.loaded.finally(()=>{delete this.loaded})},_get:function(){return this._getDeep(this.mData,arguments)},_getMerged:function(){return this._get.apply(this,arguments)},_getMonthsWithAlternatives:function(e,t){return this._get(k(t),"months","format",e)},_getMonthsStandAloneWithAlternatives:function(e,t){return this._get(k(t),"months","stand-alone",e)},_getDeep:function(e,t){var r=e;for(var n=0;n<t.length;n++){r=r[t[n]];if(r===undefined){break}}return r},getOrientation:function(){return this._get("orientation")},getCurrentLanguageName:function(){return this.getLanguageName(this.oLocale.toString())},getLanguageName:function(e){const t=new n(e);let r=i.getModernLanguage(t.language);let a=t.script;if(r==="sr"&&a==="Latn"){r="sh";a=null}const o=t.region;const s=this._get("languages");const u=s[r];if(!a&&!o||!u){return u}const l=s[r+"_"+o]||s[r+"_"+a];if(l){return l}if(a){const e=this._get("scripts")[a];if(e){return u+" ("+e+")"}}if(o){const e=this._get("territories")[o];if(e){return u+" ("+e+")"}}return u},getLanguages:function(){const e=this._get("languages");["ar_001","de_AT","de_CH","en_AU","en_CA","en_GB","en_US","es_419","es_ES","es_MX","fa_AF","fr_CA","fr_CH","nds_NL","nl_BE","pt_BR","pt_PT","ro_MD","sw_CD","zh_Hans","zh_Hant"].forEach(t=>{if(!e[t]){e[t]=this.getLanguageName(t)}});return e},getScripts:function(){return this._get("scripts")},getTerritories:function(){return this._get("territories")},getMonths:function(e,r){t(_.includes(e),"sWidth must be narrow, abbreviated or wide");return this._get(k(r),"months","format",e).map(e=>Array.isArray(e)?e[0]:e)},getMonthsStandAlone:function(e,r){t(_.includes(e),"sWidth must be narrow, abbreviated or wide");return this._get(k(r),"months","stand-alone",e).map(e=>Array.isArray(e)?e[0]:e)},getDays:function(e,r){t(e=="narrow"||e=="abbreviated"||e=="wide"||e=="short","sWidth must be narrow, abbreviate, wide or short");return this._get(k(r),"days","format",e)},getDaysStandAlone:function(e,r){t(e=="narrow"||e=="abbreviated"||e=="wide"||e=="short","sWidth must be narrow, abbreviated, wide or short");return this._get(k(r),"days","stand-alone",e)},getQuarters:function(e,r){t(e=="narrow"||e=="abbreviated"||e=="wide","sWidth must be narrow, abbreviated or wide");return this._get(k(r),"quarters","format",e)},getQuartersStandAlone:function(e,r){t(e=="narrow"||e=="abbreviated"||e=="wide","sWidth must be narrow, abbreviated or wide");return this._get(k(r),"quarters","stand-alone",e)},getDayPeriods:function(e,r){t(e=="narrow"||e=="abbreviated"||e=="wide","sWidth must be narrow, abbreviated or wide");return this._get(k(r),"dayPeriods","format",e)},getDayPeriodsStandAlone:function(e,r){t(e=="narrow"||e=="abbreviated"||e=="wide","sWidth must be narrow, abbreviated or wide");return this._get(k(r),"dayPeriods","stand-alone",e)},getDatePattern:function(e,r){t(e=="short"||e=="medium"||e=="long"||e=="full","sStyle must be short, medium, long or full");return this._get(k(r),"dateFormats",e)},getFlexibleDayPeriods:function(e,t){return this._get(k(t),"flexibleDayPeriods","format",e)},getFlexibleDayPeriodsStandAlone:function(e,t){return this._get(k(t),"flexibleDayPeriods","stand-alone",e)},getFlexibleDayPeriodOfTime:function(e,t){var r,n,i;r=(e*60+t)%1440;n=this._get("dayPeriodRules");function a(e){var t=e.split(":"),r=t[0],n=t[1];return parseInt(r)*60+parseInt(n)}i=Object.keys(n).find(function(e){var t=n[e];return t["_at"]&&a(t["_at"])===r});if(i){return i}return Object.keys(n).find(function(e){var t,i,o,s=n[e];if(s["_at"]){return false}o=a(s["_from"]);t=a(s["_before"]);if(o>t){i=[{start:o,end:1440},{start:0,end:t}]}else{i=[{start:o,end:t}]}return i.some(function(e){return e.start<=r&&e.end>r})})},getTimePattern:function(e,r){t(e=="short"||e=="medium"||e=="long"||e=="full","sStyle must be short, medium, long or full");return this._get(k(r),"timeFormats",e)},getDateTimePattern:function(e,r){t(e=="short"||e=="medium"||e=="long"||e=="full","sStyle must be short, medium, long or full");return this._get(k(r),"dateTimeFormats",e)},getCombinedDateTimePattern:function(e,r,n){t(e=="short"||e=="medium"||e=="long"||e=="full","sStyle must be short, medium, long or full");t(r=="short"||r=="medium"||r=="long"||r=="full","sStyle must be short, medium, long or full");var i=this.getDateTimePattern(e,n),a=this.getDatePattern(e,n),o=this.getTimePattern(r,n);return i.replace("{0}",o).replace("{1}",a)},getCombinedDateTimeWithTimezonePattern:function(e,t,r){return this.applyTimezonePattern(this.getCombinedDateTimePattern(e,t,r))},applyTimezonePattern:function(e){var t=[e];var r=[{group:"Timezone",length:2,field:"zone",symbol:"V"}];this._appendItems(t,r);return t[0]},getTimezoneTranslations:function(){var e=this.oLocale.toString();var t=b._mTimezoneTranslations[e];if(!t){b._mTimezoneTranslations[e]=t=P(this._get("timezoneNames"))}return Object.assign({},t)},getCustomDateTimePattern:function(e,t){var r=this._get(k(t),"dateTimeFormats","availableFormats");return this._getFormatPattern(e,r,t)},getIntervalPattern:function(e,t){var r=this._get(k(t),"dateTimeFormats","intervalFormats"),n,i,a,o,s;if(e){n=e.split("-");i=n[0];a=n[1];o=r[i];if(o){s=o[a];if(s){return s}}}return r.intervalFormatFallback},getCombinedIntervalPattern:function(e,t){const r=this._get(k(t),"dateTimeFormats","intervalFormats");const[,n,i,a]=d.exec(r.intervalFormatFallback);return b._escapeIfNeeded(n)+e+b._escapeIfNeeded(i)+e+b._escapeIfNeeded(a)},getCustomIntervalPattern:function(e,t,r){var n=this._get(k(r),"dateTimeFormats","intervalFormats");return this._getFormatPattern(e,n,r,t)},_getFormatPattern:function(e,t,r,n){var i,a,o;if(!n){i=t[e]}else if(typeof n==="string"){if(n=="j"||n=="J"){n=this.getPreferredHourSymbol()}o=t[e];i=o&&o[n]}if(i){if(typeof i==="object"){a=Object.keys(i).map(function(e){return i[e]})}else{return i}}if(!a){a=this._createFormatPattern(e,t,r,n)}if(a&&a.length===1){return a[0]}return a},_createFormatPattern:function(e,t,r,n){var i=this._parseSkeletonFormat(e),a,o=this._findBestMatch(i,e,t),s,u,l,c,f,g,m,h,d=/^([GyYqQMLwWEecdD]+)([hHkKjJmszZvVOXx]+)$/,p,_;if(n){if(typeof n==="string"){h=w[n]?w[n].group:"";if(h){p=C[h].index>i[i.length-1].index}m=n}else{p=true;if(i[0].symbol==="y"&&o&&o.pattern.G){l=w["G"];c=C[l.group];i.splice(0,0,{symbol:"G",group:l.group,match:l.match,index:c.index,field:c.field,length:1})}for(_=i.length-1;_>=0;_--){s=i[_];if(n[s.group]){p=false;break}}for(_=0;_<i.length;_++){s=i[_];if(n[s.group]){m=s.symbol;break}}if((m=="h"||m=="K")&&n.DayPeriod){m="a"}}if(p){return[this.getCustomDateTimePattern(e,r)]}if(o&&o.missingTokens.length===0){f=o.pattern[m];if(f&&o.distance>0){f=this._expandFields(f,o.patternTokens,i)}}if(!f){u=this._get(k(r),"dateTimeFormats","availableFormats");if(d.test(e)&&"ahHkKjJms".indexOf(m)>=0){f=this._getMixedFormatPattern(e,u,r,n)}else{g=this._getFormatPattern(e,u,r);f=this.getCombinedIntervalPattern(g,r)}}a=[f]}else if(!o){f=e;a=[f]}else{if(typeof o.pattern==="string"){a=[o.pattern]}else if(typeof o.pattern==="object"){a=[];for(var y in o.pattern){f=o.pattern[y];a.push(f)}}if(o.distance>0){if(o.missingTokens.length>0){if(d.test(e)){a=[this._getMixedFormatPattern(e,t,r)]}else{a=this._expandFields(a,o.patternTokens,i);a=this._appendItems(a,o.missingTokens,r)}}else{a=this._expandFields(a,o.patternTokens,i)}}}if(e.indexOf("J")>=0){a.forEach(function(e,t){a[t]=e.replace(/ ?[abB](?=([^']*'[^']*')*[^']*)$/g,"")})}return a},_parseSkeletonFormat:function(e){var t=[],r={index:-1},n,i,a;for(var o=0;o<e.length;o++){n=e.charAt(o);if(n=="j"||n=="J"){n=this.getPreferredHourSymbol()}if(n==r.symbol){r.length++;continue}i=w[n];a=C[i.group];if(i.group=="Other"||a.diffOnly){throw new Error("Symbol '"+n+"' is not allowed in skeleton format '"+e+"'")}if(a.index<=r.index){throw new Error("Symbol '"+n+"' at wrong position or duplicate in skeleton format '"+e+"'")}r={symbol:n,group:i.group,match:i.match,index:a.index,field:a.field,length:1};t.push(r)}return t},_findBestMatch:function(e,t,r){var n,i,a,o,s,u,l,c,f,g,m={distance:1e4,firstDiffPos:-1};for(var h in r){if(h==="intervalFormatFallback"||h.indexOf("B")>-1){continue}n=this._parseSkeletonFormat(h);u=0;i=[];l=true;if(e.length<n.length){continue}s=0;c=e.length;for(var d=0;d<e.length;d++){a=e[d];o=n[s];if(c===e.length){c=d}if(o){f=w[a.symbol];g=w[o.symbol];if(a.symbol===o.symbol){if(a.length===o.length){if(c===d){c=e.length}}else{if(a.length<f.numericCeiling?o.length<g.numericCeiling:o.length>=g.numericCeiling){u+=Math.abs(a.length-o.length)}else{u+=5}}s++;continue}else{if(a.match==o.match){u+=Math.abs(a.length-o.length)+10;s++;continue}}}i.push(a);u+=50-d}if(s<n.length){l=false}if(l&&(u<m.distance||u===m.distance&&c>m.firstDiffPos)){m.distance=u;m.firstDiffPos=c;m.missingTokens=i;m.pattern=r[h];m.patternTokens=n}}if(m.pattern){return m}},_expandFields:function(e,t,r){var n=typeof e==="string";var i;if(n){i=[e]}else{i=e}var a=i.map(function(e){var n={},i={},a="",o=false,s=0,u,l,c,f,g,m,h,d;r.forEach(function(e){n[e.group]=e});t.forEach(function(e){i[e.group]=e});while(s<e.length){d=e.charAt(s);if(o){a+=d;if(d=="'"){o=false}}else{h=w[d];if(h&&n[h.group]&&i[h.group]){g=n[h.group];m=i[h.group];u=g.length;c=m.length;l=1;while(e.charAt(s+1)==d){s++;l++}if(u===c||(u<h.numericCeiling?l>=h.numericCeiling:l<h.numericCeiling)){f=l}else{f=Math.max(l,u)}for(var p=0;p<f;p++){a+=d}}else{a+=d;if(d=="'"){o=true}}}s++}return a});return n?a[0]:a},_appendItems:function(e,t,r){var n=this._get(k(r),"dateTimeFormats","appendItems");e.forEach(function(r,i){var a,o,s;t.forEach(function(t){o=n[t.group];a="'"+this.getDisplayName(t.field)+"'";s="";for(var u=0;u<t.length;u++){s+=t.symbol}e[i]=o.replace(/\{0\}/,r).replace(/\{1\}/,s).replace(/\{2\}/,a)}.bind(this))}.bind(this));return e},_getMixedFormatPattern:function(e,t,r,n){var i=/^([GyYqQMLwWEecdD]+)([hHkKjJmszZvVOXx]+)$/,a=/MMMM|LLLL/,o=/MMM|LLL/,s=/E|e|c/,u,l,c,f,g,m,h,d;u=i.exec(e);l=u[1];c=u[2];g=this._getFormatPattern(l,t,r);if(n){m=this.getCustomIntervalPattern(c,n,r)}else{m=this._getFormatPattern(c,t,r)}if(a.test(l)){f=s.test(l)?"full":"long"}else if(o.test(l)){f="medium"}else{f="short"}h=this.getDateTimePattern(f,r);d=h.replace(/\{1\}/,g).replace(/\{0\}/,m);return d},getNumberSymbol:function(e){t(e=="decimal"||e=="group"||e=="plusSign"||e=="minusSign"||e=="percentSign","sType must be decimal, group, plusSign, minusSign or percentSign");return this._get("symbols-latn-"+e)},getLenientNumberSymbols:function(e){t(e=="plusSign"||e=="minusSign","sType must be plusSign or minusSign");return this._get("lenient-scope-number")[e]},getDecimalPattern:function(){return this._get("decimalFormat").standard},getCurrencyPattern:function(e,t){return this._get("currencyFormat")[t?e+"-"+t:e]},getPercentPattern:function(){return this._get("percentFormat").standard},getMiscPattern:function(e){t(e=="approximately"||e=="atLeast"||e=="atMost"||e=="range","sName must be approximately, atLeast, atMost or range");return this._get("miscPattern")[e]},getMinimalDaysInFirstWeek:function(){return this._get("weekData-minDays")},getFirstDayOfWeek:function(){return this._get("weekData-firstDay")},getWeekendStart:function(){return this._get("weekData-weekendStart")},getWeekendEnd:function(){return this._get("weekData-weekendEnd")},getCustomCurrencyCodes:function(){var e=this._get("currency")||{},t={};Object.keys(e).forEach(function(e){t[e]=e});return t},getCurrencyDigits:function(e){const t=this.getAllCurrencyDigits();return t[e]??t["DEFAULT"]},getAllCurrencyDigits(){const e={...this._get("currencyDigits")};const t=this._get("currency");if(t){for(const r in t){if(t[r].digits!==undefined){e[r]=t[r].digits}}}return e},getCurrencySymbol:function(e){var t=this.getCurrencySymbols();return t&&t[e]||e},getCurrencyCodeBySymbol:function(e){var t=this._get("currencySymbols"),r;for(r in t){if(t[r]===e){return r}}return e},getCurrencySymbols:function(){var e=this._get("currency"),t={},r;for(var n in e){r=e[n].isoCode;if(e[n].symbol){t[n]=e[n].symbol}else if(r){t[n]=this._get("currencySymbols")[r]}}return Object.assign({},this._get("currencySymbols"),t)},getUnitDisplayName:function(e){var t=this.getUnitFormat(e);return t&&t["displayName"]||""},getRelativePatterns:function(e,r){if(r===undefined){r="wide"}t(r==="wide"||r==="short"||r==="narrow","sStyle is only allowed to be set with 'wide', 'short' or 'narrow'");var n=[],i=this.getPluralCategories(),a,o,s,u;if(!e){e=["year","month","week","day","hour","minute","second"]}e.forEach(function(e){a=this._get("dateFields",e+"-"+r);for(var t in a){if(t.indexOf("relative-type-")===0){s=parseInt(t.substr(14));n.push({scale:e,value:s,pattern:a[t]})}else if(t.indexOf("relativeTime-type-")==0){o=a[t];u=t.substr(18)==="past"?-1:1;i.forEach(function(t){var r=o["relativeTimePattern-count-"+t];if(r){n.push({scale:e,sign:u,pattern:r})}})}}}.bind(this));return n},getRelativePattern:function(e,r,n,i){var a,o,s,u;if(typeof n==="string"){i=n;n=undefined}if(n===undefined){n=r>0}if(i===undefined){i="wide"}t(i==="wide"||i==="short"||i==="narrow","sStyle is only allowed to be set with 'wide', 'short' or 'narrow'");s=e+"-"+i;if(r===0||r===-2||r===2){a=this._get("dateFields",s,"relative-type-"+r)}if(!a){o=this._get("dateFields",s,"relativeTime-type-"+(n?"future":"past"));u=this.getPluralCategory(Math.abs(r).toString());a=o["relativeTimePattern-count-"+u]}return a},getRelativeSecond:function(e,t){return this.getRelativePattern("second",e,t)},getRelativeMinute:function(e,t){if(e==0){return null}return this.getRelativePattern("minute",e,t)},getRelativeHour:function(e,t){if(e==0){return null}return this.getRelativePattern("hour",e,t)},getRelativeDay:function(e,t){return this.getRelativePattern("day",e,t)},getRelativeWeek:function(e,t){return this.getRelativePattern("week",e,t)},getRelativeMonth:function(e,t){return this.getRelativePattern("month",e,t)},getDisplayName:function(e,r){t(e=="second"||e=="minute"||e=="hour"||e=="zone"||e=="day"||e=="weekday"||e=="week"||e=="month"||e=="quarter"||e=="year"||e=="era","sType must be second, minute, hour, zone, day, weekday, week, month, quarter, year, era");if(r===undefined){r="wide"}t(r==="wide"||r==="short"||r==="narrow","sStyle is only allowed to be set with 'wide', 'short' or 'narrow'");var n=["era","weekday","zone"],i=n.indexOf(e)===-1?e+"-"+r:e;return this._get("dateFields",i,"displayName")},getRelativeYear:function(e,t){return this.getRelativePattern("year",e,t)},getCompactDecimalPattern:function(e,t,r="other"){const n=this._get("decimalFormat-"+e);return n&&(n[t+"-"+r]||n[t+"-other"])},getCompactCurrencyPattern:function(e,t,r="other",n=undefined){const i=this._get("currencyFormat-"+e);const a=n?"-"+n:"";return i&&(i[t+"-"+r+a]||i[t+"-other"+a])},getListFormat:function(e,t){var r=this._get("listPattern-"+(e||"standard")+"-"+(t||"wide"));if(r){return r}return{}},getResolvedUnitFormat:function(e){e=this.getUnitFromMapping(e)||e;return this.getUnitFormat(e)},getUnitFormat:function(e){var t=this._get("units","short",e);if(!t&&y[e]){t=this._get("units","short",y[e])}return t},getUnitFormats:function(){return this._getMerged("units","short")},getUnitFromMapping:function(e){return this._get("unitMappings",e)},getEras:function(e,r){t(e=="wide"||e=="abbreviated"||e=="narrow","sWidth must be wide, abbreviate or narrow");var n=this._get(k(r),"era-"+e),i=[];for(var a in n){i[parseInt(a)]=n[a]}return i},getEraDates:function(e=r.getCalendarType()){var t=this._get("eras-"+e.toLowerCase()),n=[];for(var i in t){n[parseInt(i)]=t[i]}return n},getCalendarWeek:function(e,r){t(e=="wide"||e=="narrow","sStyle must be wide or narrow");const n=this._get("sap-calendarWeek")[e];return r?n.replace("{0}",r):n},firstDayStartsFirstWeek:function(){return this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="US"},getPreferredCalendarType:function(){var e,t,r,n=this._get("calendarPreference")||[];for(r=0;r<n.length;r++){e=n[r].split("-")[0];for(t in a){if(e===t.toLowerCase()){return t}}}return a.Gregorian},getPreferredHourSymbol:function(){return this._get("timeData","_preferred")},getPluralCategories:function(){var e=this._get("plurals"),t=Object.keys(e);t.push("other");return t},getPluralCategory:function(e){var t=typeof e==="number"?e.toString():e,r=this._get("plurals");if(!this._pluralTest){this._pluralTest={}}for(var n in r){var i=this._pluralTest[n];if(!i){i=this._parsePluralRule(r[n]);this._pluralTest[n]=i}if(i(t).bMatch){return n}}return"other"},_parsePluralRule:function(e){var t="or",r="and",n="%",i="=",a="!=",o="n",s="i",u="f",l="t",c="v",m="w",d="c",p="e",_="..",y=",";var v=0,C;C=e.split(" ");function w(e){if(C[v]===e){v++;return true}return false}function D(){var e=C[v];v++;return e}function P(){var e,r;e=k();if(w(t)){r=P();return function(t){return e(t)||r(t)}}return e}function k(){var e,t;e=T();if(w(r)){t=k();return function(r){return e(r)&&t(r)}}return e}function T(){var e,t,r;e=F();if(w(i)){r=true}else if(w(a)){r=false}else{throw new Error("Expected '=' or '!='")}t=L();if(r){return function(r){return t(r).indexOf(e(r))>=0}}else{return function(r){return t(r).indexOf(e(r))===-1}}}function F(){var e;e=S();if(w(n)){var t=parseInt(D());return function(r){return e(r)%t}}return e}function S(){if(w(o)){return function(e){return e.n}}else if(w(s)){return function(e){return e.i}}else if(w(u)){return function(e){return e.f}}else if(w(l)){return function(e){return e.t}}else if(w(c)){return function(e){return e.v}}else if(w(m)){return function(e){return e.w}}else if(w(d)){return function(e){return e.c}}else if(w(p)){return function(e){return e.c}}else{throw new Error("Unknown operand: "+D())}}function L(){var e=[],t=D(),r=t.split(y),n,i,a;r.forEach(function(t){n=t.split(_);if(n.length===1){e.push(parseInt(t))}else{i=parseInt(n[0]);a=parseInt(n[1]);for(var r=i;r<=a;r++){e.push(r)}}});return function(t){return e}}var x=P();if(v!=C.length){throw new Error("Not completely parsed")}return function(e){var t,r,n,i,a,o,s;e=e.replace(f,"e");n=e.search(g);r=n<0?0:parseInt(e.slice(n+1));e=b.convertToDecimal(e);t=e.indexOf(".");if(t===-1){o=e;i="";a=""}else{o=e.slice(0,t);i=e.slice(t+1);a=i.replace(h,"")}s={n:parseFloat(e),i:parseInt(o),v:i.length,w:a.length,f:i===""?0:parseInt(i),t:a===""?0:parseInt(a),c:r};return{bMatch:x(s),oOperands:s}}}});b.convertToDecimal=function(e){var t,r,n,i,a,o,s=String(e);if(!s.includes("e")&&!s.includes("E")){return s}o=s.match(m);i=o[1]==="-";s=o[2].replace(".","");if(p.test(s)){return"0"}t=o[3]?o[3].length:0;n=o[4]?o[4].length:0;r=parseInt(o[5]);a=t+r;if(r>0){s=r<n?s.slice(0,a)+"."+s.slice(a):s=s.padEnd(a,"0")}else{s=-r<t?s=s.slice(0,a)+"."+s.slice(a):s="0."+s.padStart(n-r,"0")}if(i){s="-"+s}return s};var C={Era:{field:"era",index:0},Year:{field:"year",index:1},Quarter:{field:"quarter",index:2},Month:{field:"month",index:3},Week:{field:"week",index:4},"Day-Of-Week":{field:"weekday",index:5},Day:{field:"day",index:6},DayPeriod:{field:"hour",index:7,diffOnly:true},Hour:{field:"hour",index:8},Minute:{field:"minute",index:9},Second:{field:"second",index:10},Timezone:{field:"zone",index:11}};var w={G:{group:"Era",match:"Era",numericCeiling:1},y:{group:"Year",match:"Year",numericCeiling:100},Y:{group:"Year",match:"Year",numericCeiling:100},Q:{group:"Quarter",match:"Quarter",numericCeiling:3},q:{group:"Quarter",match:"Quarter",numericCeiling:3},M:{group:"Month",match:"Month",numericCeiling:3},L:{group:"Month",match:"Month",numericCeiling:3},w:{group:"Week",match:"Week",numericCeiling:100},W:{group:"Week",match:"Week",numericCeiling:100},d:{group:"Day",match:"Day",numericCeiling:100},D:{group:"Day",match:"Day",numericCeiling:100},E:{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:1},e:{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:3},c:{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:2},h:{group:"Hour",match:"Hour12",numericCeiling:100},H:{group:"Hour",match:"Hour24",numericCeiling:100},k:{group:"Hour",match:"Hour24",numericCeiling:100},K:{group:"Hour",match:"Hour12",numericCeiling:100},m:{group:"Minute",match:"Minute",numericCeiling:100},s:{group:"Second",match:"Second",numericCeiling:100},z:{group:"Timezone",match:"Timezone",numericCeiling:1},Z:{group:"Timezone",match:"Timezone",numericCeiling:1},O:{group:"Timezone",match:"Timezone",numericCeiling:1},v:{group:"Timezone",match:"Timezone",numericCeiling:1},V:{group:"Timezone",match:"Timezone",numericCeiling:1},X:{group:"Timezone",match:"Timezone",numericCeiling:1},x:{group:"Timezone",match:"Timezone",numericCeiling:1},S:{group:"Other",numericCeiling:100},u:{group:"Other",numericCeiling:100},U:{group:"Other",numericCeiling:1},r:{group:"Other",numericCeiling:100},F:{group:"Other",numericCeiling:100},g:{group:"Other",numericCeiling:100},a:{group:"DayPeriod",numericCeiling:1},b:{group:"Other",numericCeiling:1},B:{group:"Other",numericCeiling:1},A:{group:"Other",numericCeiling:100}};const D=["ar","ar_EG","ar_SA","bg","ca","cnr","cs","cy","da","de","de_AT","de_CH","el","el_CY","en","en_AU","en_GB","en_HK","en_IE","en_IN","en_NZ","en_PG","en_SG","en_ZA","es","es_AR","es_BO","es_CL","es_CO","es_MX","es_PE","es_UY","es_VE","et","fa","fi","fr","fr_BE","fr_CA","fr_CH","fr_LU","he","hi","hr","hu","id","it","it_CH","ja","kk","ko","lt","lv","mk","ms","nb","nl","nl_BE","pl","pt","pt_PT","ro","ru","ru_UA","sk","sl","sr","sr_Latn","sv","th","tr","uk","vi","zh_CN","zh_HK","zh_SG","zh_TW"];function P(e,t,r,n){n=n?n.slice():[];r=r||{};t=t||"";Object.keys(e).forEach(function(i){var a=e[i];if(typeof a==="object"){var o=n.slice();var s=a["_parent"];if(s){o.push(s)}P(a,t+i+"/",r,o)}else if(typeof a==="string"&&i!=="_parent"){var u=n.length?n.join(", ")+", ":"";r[t+i]=u+a}});return r}function k(e){if(!e){e=r.getCalendarType()}return"ca-"+e.toLowerCase()}function T(e,t){var r=e.getLanguage()||"",n=e.getRegion()||"",a=e.getScript()||"";function o(e,t){var r,n,i;if(!t){return}for(r in t){if(t.hasOwnProperty(r)){n=e[r];i=t[r];if(n===undefined){e[r]=i}else if(n===null){delete e[r]}else if(typeof n==="object"&&typeof i==="object"&&!Array.isArray(n)){o(n,i)}}}}function s(e){if(!v[e]&&D.includes(e)||v[e]instanceof Promise&&!t){v[e]=c.resolve(u.loadResource(`sap/ui/core/cldr/${e}.json`,{async:t,dataType:"json",failOnError:false})).then(t=>{if(t){return s(t.__fallbackLocale).then(r=>{o(t,r);v[e]=t;delete t.__fallbackLocale;return t})}return t}).unwrap()}return c.resolve(v[e])}r=r&&i.getModernLanguage(r)||r;if(r==="no"){r="nb"}if(r==="zh"&&!n){if(a==="Hans"){n="CN"}else if(a==="Hant"){n="TW"}}if(r==="sh"||r==="sr"&&a==="Latn"){r="sr_Latn"}const l=r+"_"+n;let f=l;return s(l).then(e=>{if(!e){f=r;return s(r)}return e}).then(e=>{if(!e){f="en";return s("en")}return e}).then(e=>({mData:e,sCLDRLocaleId:f.replace(/_/g,"-")}))}var F=b.extend("sap.ui.core.CustomLocaleData",{constructor:function(e){b.apply(this,arguments);this.mCustomData=r.getCustomLocaleData()},_get:function(){var e=Array.prototype.slice.call(arguments),t,r;if(e[0].indexOf("ca-")==0){t=e[0];if(t==k()){e=e.slice(1)}}r=e.join("-");var n=this.mCustomData[r];if(n==null){n=this._getDeep(this.mCustomData,arguments);if(n==null){n=this._getDeep(this.mData,arguments)}}return n},_getMerged:function(){var e=this._getDeep(this.mData,arguments);var t=this._getDeep(this.mCustomData,arguments);return s({},e,t)},getFirstDayOfWeek:function(){var e=r.getCalendarWeekNumbering();if(e===o.Default){return b.prototype.getFirstDayOfWeek.call(this)}return o.getWeekConfigurationValues(e).firstDayOfWeek},getMinimalDaysInFirstWeek:function(){var e=r.getCalendarWeekNumbering();if(e===o.Default){return b.prototype.getMinimalDaysInFirstWeek.call(this)}return o.getWeekConfigurationValues(e).minimalDaysInFirstWeek}});b._resetLocaleDataCache=function(){v={}};b.getInstance=function(t){t=e._getCoreLocale(t);return t.hasPrivateUseSubtag("sapufmt")?new F(t):new b(t)};b.requestInstance=function(t){const r=e._getCoreLocale(t);const n=r.hasPrivateUseSubtag("sapufmt")?new F(r,true):new b(r,true);return Promise.resolve(n.loaded)};b._cldrLocales=D;b._mTimezoneTranslations={};const S=new RegExp("["+Object.keys(w).join("")+"]");const L=/^(\s)?(.*?)(\s)?$/;b._escapeIfNeeded=function(e){if(e===undefined){return""}if(S.test(e)){return e.replace(L,"$1'$2'$3")}return e};b.prototype.getCurrencyFormat=b.prototype.getCompactCurrencyPattern;b.prototype.getDecimalFormat=b.prototype.getCompactDecimalPattern;return b});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/Buddhist", ["./UniversalDate","./_Calendars","sap/base/i18n/date/CalendarType"],function(t,e,r){"use strict";var a=t.extend("sap.ui.core.date.Buddhist",{constructor:function(){var t=arguments;if(t.length>1){t=u(t)}this.oDate=this.createDate(Date,t);this.sCalendarType=r.Buddhist}});a.UTC=function(){var t=u(arguments);return Date.UTC.apply(Date,t)};a.now=function(){return Date.now()};function n(e){var a=t.getEraStartDate(r.Buddhist,0).year,n=e.year-a+1;if(e.year<1941&&e.month<3){n-=1}if(e.year===null){n=undefined}return{year:n,month:e.month,day:e.day}}function i(e){var a=t.getEraStartDate(r.Buddhist,0).year,n=e.year+a-1;if(n<1941&&e.month<3){n+=1}if(e.year===null){n=undefined}return{year:n,month:e.month,day:e.day}}function u(t){var e,r;e={year:t[0],month:t[1],day:t[2]!==undefined?t[2]:1};r=i(e);t[0]=r.year;return t}a.prototype._getBuddhist=function(){var t={year:this.oDate.getFullYear(),month:this.oDate.getMonth(),day:this.oDate.getDate()};return n(t)};a.prototype._setBuddhist=function(t){var e=i(t);return this.oDate.setFullYear(e.year,e.month,e.day)};a.prototype._getUTCBuddhist=function(){var t={year:this.oDate.getUTCFullYear(),month:this.oDate.getUTCMonth(),day:this.oDate.getUTCDate()};return n(t)};a.prototype._setUTCBuddhist=function(t){var e=i(t);return this.oDate.setUTCFullYear(e.year,e.month,e.day)};a.prototype.getYear=function(){return this._getBuddhist().year};a.prototype.getFullYear=function(){return this._getBuddhist().year};a.prototype.getUTCFullYear=function(){return this._getUTCBuddhist().year};a.prototype.setYear=function(t){var e=this._getBuddhist();e.year=t;return this._setBuddhist(e)};a.prototype.setFullYear=function(t,e,r){var a=this._getBuddhist();a.year=t;if(e!==undefined){a.month=e}if(r!==undefined){a.day=r}return this._setBuddhist(a)};a.prototype.setUTCFullYear=function(t,e,r){var a=this._getUTCBuddhist();a.year=t;if(e!==undefined){a.month=e}if(r!==undefined){a.day=r}return this._setUTCBuddhist(a)};e.set(r.Buddhist,a);return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/CalendarUtils", ["sap/base/i18n/Formatting","sap/base/i18n/date/CalendarWeekNumbering","sap/ui/core/Locale","sap/ui/core/LocaleData"],function(e,a,n,i){"use strict";var t={getWeekConfigurationValues:function(r,u){var s,g;if(!r){return t.getWeekConfigurationValues(e.getCalendarWeekNumbering(),u)}g=a.getWeekConfigurationValues(r);if(g){return g}if(r===a.Default){u=u||new n(e.getLanguageTag());s=i.getInstance(u);return{firstDayOfWeek:s.getFirstDayOfWeek(),minimalDaysInFirstWeek:s.getMinimalDaysInFirstWeek()}}return undefined}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/CalendarWeekNumbering", ["sap/ui/base/DataType","sap/base/i18n/date/CalendarWeekNumbering"],function(e,a){"use strict";e.registerEnum("sap.ui.core.date.CalendarWeekNumbering",a);return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/Gregorian", ["./UniversalDate","./_Calendars","sap/base/i18n/date/CalendarType"],function(e,a,t){"use strict";var n=e.extend("sap.ui.core.date.Gregorian",{constructor:function(){this.oDate=this.createDate(Date,arguments);this.sCalendarType=t.Gregorian}});n.UTC=function(){return Date.UTC.apply(Date,arguments)};n.now=function(){return Date.now()};a.set(t.Gregorian,n);return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/Islamic", ["./UniversalDate","sap/base/Log","sap/base/i18n/Formatting","sap/base/i18n/date/CalendarType","./_Calendars"],function(t,e,a,r,o){"use strict";var n=t.extend("sap.ui.core.date.Islamic",{constructor:function(){var t=arguments;if(t.length>1){t=p(t)}this.oDate=this.createDate(Date,t);this.sCalendarType=r.Islamic}});n.UTC=function(){var t=p(arguments);return Date.UTC.apply(Date,t)};n.now=function(){return Date.now()};var i=1400,s=1721425.5,h=1948439.5,l=-425215872e5,f=864e5;var u=null;var c=["A","B"];function y(t){var e=t.year,a=t.month,r=t.day,o,n,i,l,f,u,c;u=0;if(a+1>2){u=v(e)?-1:-2}c=s-1+365*(e-1)+Math.floor((e-1)/4)+-Math.floor((e-1)/100)+Math.floor((e-1)/400)+Math.floor((367*(a+1)-362)/12+u+r);c=Math.floor(c)+.5;f=c-h;l=Math.floor(f/29.530588853);if(l<0){o=Math.floor(l/12)+1;n=l%12;if(n<0){n+=12}i=f-I(o,n)+1}else{l++;while(M(l)>f){l--}o=Math.floor(l/12)+1;n=l%12;i=f-M(12*(o-1)+n)+1}return{day:i,month:n,year:o}}function m(t){var e=t.year,a=t.month,r=t.day,o=e<1?I(e,a):M(12*(e-1)+a),n=r+o+h-1,i=Math.floor(n-.5)+.5,l=i-s,f=Math.floor(l/146097),u=C(l,146097),c=Math.floor(u/36524),y=C(u,36524),m=Math.floor(y/1461),p=C(y,1461),d=Math.floor(p/365),g=f*400+c*100+m*4+d,T,D,_,U,F,Y,b,w;if(!(c==4||d==4)){g++}_=s+365*(g-1)+Math.floor((g-1)/4)-Math.floor((g-1)/100)+Math.floor((g-1)/400);U=i-_;F=s-1+365*(g-1)+Math.floor((g-1)/4)-Math.floor((g-1)/100)+Math.floor((g-1)/400)+Math.floor(739/12+(v(g)?-1:-2)+1);b=0;if(i<F){b=0}else{b=v(g)?1:2}T=Math.floor(((U+b)*12+373)/367);Y=s-1+365*(g-1)+Math.floor((g-1)/4)-Math.floor((g-1)/100)+Math.floor((g-1)/400);w=0;if(T>2){w=v(g)?-1:-2}Y+=Math.floor((367*T-362)/12+w+1);D=i-Y+1;return{day:D,month:T-1,year:g}}function p(t){var e=Array.prototype.slice.call(t),a,r;a={year:t[0],month:t[1],day:t[2]!==undefined?t[2]:1};r=m(a);e[0]=r.year;e[1]=r.month;e[2]=r.day;return e}function d(){var t,r;u={};t=a.getABAPDateFormat();t=T(t)?t:"A";r=a.getCustomIslamicCalendarData();r=r||[];if(!r.length){e.warning("No calendar customizations.");return}r.forEach(function(e){if(e.dateFormat===t){var a=g(e.gregDate);var r=new Date(Date.UTC(a.year,a.month-1,a.day));var o=r.getTime();var n=(o-l)/f;a=g(e.islamicMonthStart);var i=(a.year-1)*12+a.month-1;u[i]=n}});e.info("Working with date format: ["+t+"] and customization: "+JSON.stringify(r))}function g(t){return{year:parseInt(t.substr(0,4)),month:parseInt(t.substr(4,2)),day:parseInt(t.substr(6,2))}}function M(t){if(!u){d()}var e=u[t];if(!e){var a=Math.floor(t/12)+1;var r=t%12;e=I(a,r)}return e}function I(t,e){return Math.ceil(29.5*e)+(t-1)*354+Math.floor((3+11*t)/30)}function C(t,e){return t-e*Math.floor(t/e)}function v(t){return!(t%400)||!(t%4)&&!!(t%100)}function T(t){return c.indexOf(t)!==-1}n.prototype._getIslamic=function(){return y({day:this.oDate.getDate(),month:this.oDate.getMonth(),year:this.oDate.getFullYear()})};n.prototype._setIslamic=function(t){var e=m(t);return this.oDate.setFullYear(e.year,e.month,e.day)};n.prototype._getUTCIslamic=function(){return y({day:this.oDate.getUTCDate(),month:this.oDate.getUTCMonth(),year:this.oDate.getUTCFullYear()})};n.prototype._setUTCIslamic=function(t){var e=m(t);return this.oDate.setUTCFullYear(e.year,e.month,e.day)};n.prototype.getDate=function(t){return this._getIslamic().day};n.prototype.getMonth=function(){return this._getIslamic().month};n.prototype.getYear=function(){return this._getIslamic().year-i};n.prototype.getFullYear=function(){return this._getIslamic().year};n.prototype.setDate=function(t){var e=this._getIslamic();e.day=t;return this._setIslamic(e)};n.prototype.setMonth=function(t,e){var a=this._getIslamic();a.month=t;if(e!==undefined){a.day=e}return this._setIslamic(a)};n.prototype.setYear=function(t){var e=this._getIslamic();e.year=t+i;return this._setIslamic(e)};n.prototype.setFullYear=function(t,e,a){var r=this._getIslamic();r.year=t;if(e!==undefined){r.month=e}if(a!==undefined){r.day=a}return this._setIslamic(r)};n.prototype.getUTCDate=function(t){return this._getUTCIslamic().day};n.prototype.getUTCMonth=function(){return this._getUTCIslamic().month};n.prototype.getUTCFullYear=function(){return this._getUTCIslamic().year};n.prototype.setUTCDate=function(t){var e=this._getUTCIslamic();e.day=t;return this._setUTCIslamic(e)};n.prototype.setUTCMonth=function(t,e){var a=this._getUTCIslamic();a.month=t;if(e!==undefined){a.day=e}return this._setUTCIslamic(a)};n.prototype.setUTCFullYear=function(t,e,a){var r=this._getUTCIslamic();r.year=t;if(e!==undefined){r.month=e}if(a!==undefined){r.day=a}return this._setUTCIslamic(r)};o.set(r.Islamic,n);return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/Japanese", ["./UniversalDate","./_Calendars","sap/base/i18n/date/CalendarType"],function(e,t,a){"use strict";var n=e.extend("sap.ui.core.date.Japanese",{constructor:function(){var e=arguments;if(e.length>1){e=s(e)}this.oDate=this.createDate(Date,e);this.sCalendarType=a.Japanese}});n.UTC=function(){var e=s(arguments);return Date.UTC.apply(Date,e)};n.now=function(){return Date.now()};function r(t){var n=e.getEraByDate(a.Japanese,t.year,t.month,t.day),r=e.getEraStartDate(a.Japanese,n).year;return{era:n,year:t.year-r+1,month:t.month,day:t.day}}function o(t){var n=e.getEraStartDate(a.Japanese,t.era).year;return{year:n+t.year-1,month:t.month,day:t.day}}function s(t){var n,r,s,i=t[0];if(typeof i=="number"){if(i>=100){return t}else{s=e.getCurrentEra(a.Japanese);i=[s,i]}}else if(!Array.isArray(i)){i=[]}n={era:i[0],year:i[1],month:t[1],day:t[2]!==undefined?t[2]:1};r=o(n);t[0]=r.year;return t}n.prototype._getJapanese=function(){var e={year:this.oDate.getFullYear(),month:this.oDate.getMonth(),day:this.oDate.getDate()};return r(e)};n.prototype._setJapanese=function(e){var t=o(e);return this.oDate.setFullYear(t.year,t.month,t.day)};n.prototype._getUTCJapanese=function(){var e={year:this.oDate.getUTCFullYear(),month:this.oDate.getUTCMonth(),day:this.oDate.getUTCDate()};return r(e)};n.prototype._setUTCJapanese=function(e){var t=o(e);return this.oDate.setUTCFullYear(t.year,t.month,t.day)};n.prototype.getYear=function(){return this._getJapanese().year};n.prototype.getFullYear=function(){return this._getJapanese().year};n.prototype.getEra=function(){return this._getJapanese().era};n.prototype.getUTCFullYear=function(){return this._getUTCJapanese().year};n.prototype.getUTCEra=function(){return this._getUTCJapanese().era};n.prototype.setYear=function(e){var t=this._getJapanese();t.year=e;return this._setJapanese(t)};n.prototype.setFullYear=function(e,t,a){var n=this._getJapanese();n.year=e;if(t!==undefined){n.month=t}if(a!==undefined){n.day=a}return this._setJapanese(n)};n.prototype.setEra=function(t,n,o,s){var i=e.getEraStartDate(a.Japanese,t),u=r(i);if(n!==undefined){u.year=n}if(o!==undefined){u.month=o}if(s!==undefined){u.day=s}return this._setJapanese(u)};n.prototype.setUTCFullYear=function(e,t,a){var n=this._getUTCJapanese();n.year=e;if(t!==undefined){n.month=t}if(a!==undefined){n.day=a}return this._setUTCJapanese(n)};n.prototype.setUTCEra=function(t,n,o,s){var i=e.getEraStartDate(a.Japanese,t),u=r(i);if(n!==undefined){u.year=n}if(o!==undefined){u.month=o}if(s!==undefined){u.day=s}return this._setUTCJapanese(u)};n.prototype.getWeek=function(t,a){return e.getWeekByDate(this.sCalendarType,this.oDate.getFullYear(),this.getMonth(),this.getDate(),t,a)};n.prototype.getUTCWeek=function(t,a){return e.getWeekByDate(this.sCalendarType,this.oDate.getUTCFullYear(),this.getUTCMonth(),this.getUTCDate(),t,a)};t.set(a.Japanese,n);return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/Persian", ["./UniversalDate","./_Calendars","sap/base/i18n/date/CalendarType"],function(t,e,r){"use strict";var n=t.extend("sap.ui.core.date.Persian",{constructor:function(){var t=arguments;if(t.length>1){t=s(t)}this.oDate=this.createDate(Date,t);this.sCalendarType=r.Persian}});n.UTC=function(){var t=s(arguments);return Date.UTC.apply(Date,t)};n.now=function(){return Date.now()};var a=1300;function i(t){var e=f(t.year,t.month+1,t.day);return h(e)}function o(t){var e=y(t.year,t.month+1,t.day);return p(e)}function s(t){var e=Array.prototype.slice.call(t),r,n;if(typeof t[0]!=="number"||typeof t[1]!=="number"||t[2]!==undefined&&typeof t[2]!="number"){e[0]=NaN;e[1]=NaN;e[2]=NaN;return e}r={year:t[0],month:t[1],day:t[2]!==undefined?t[2]:1};n=o(r);e[0]=n.year;e[1]=n.month;e[2]=n.day;return e}function u(t){var e=[-61,9,38,199,426,686,756,818,1111,1181,1210,1635,2060,2097,2192,2262,2324,2394,2456,3178],r=e.length,n=t+621,a=-14,i=e[0],o,s,u,y,h,f,p;for(p=1;p<r;p+=1){o=e[p];s=o-i;if(t<o){break}a=a+c(s,33)*8+c(d(s,33),4);i=o}f=t-i;a=a+c(f,33)*8+c(d(f,33)+3,4);if(d(s,33)===4&&s-f===4){a+=1}y=c(n,4)-c((c(n,100)+1)*3,4)-150;h=20+a-y;if(s-f<6){f=f-s+c(s+4,33)*33}u=d(d(f+1,33)-1,4);if(u===-1){u=4}return{leap:u,gy:n,march:h}}function y(t,e,r){while(e<1){e+=12;t--}while(e>12){e-=12;t++}var n=u(t);return f(n.gy,3,n.march)+(e-1)*31-c(e,7)*(e-7)+r-1}function h(t){var e=p(t).year,r=e-621,n=u(r),a=f(e,3,n.march),i,o,s;s=t-a;if(s>=0){if(s<=185){o=1+c(s,31);i=d(s,31)+1;return{year:r,month:o-1,day:i}}else{s-=186}}else{r-=1;s+=179;if(n.leap===1){s+=1}}o=7+c(s,30);i=d(s,30)+1;return{year:r,month:o-1,day:i}}function f(t,e,r){var n=c((t+c(e-8,6)+100100)*1461,4)+c(153*d(e+9,12)+2,5)+r-34840408;n=n-c(c(t+100100+c(e-8,6),100)*3,4)+752;return n}function p(t){var e,r,n,a,i;e=4*t+139361631;e=e+c(c(4*t+183187720,146097)*3,4)*4-3908;r=c(d(e,1461),4)*5+308;n=c(d(r,153),5)+1;a=d(c(r,153),12)+1;i=c(e,1461)-100100+c(8-a,6);return{year:i,month:a-1,day:n}}function c(t,e){return~~(t/e)}function d(t,e){return t-~~(t/e)*e}n.prototype._getPersian=function(){return i({day:this.oDate.getDate(),month:this.oDate.getMonth(),year:this.oDate.getFullYear()})};n.prototype._setPersian=function(t){var e=o(t);return this.oDate.setFullYear(e.year,e.month,e.day)};n.prototype._getUTCPersian=function(){return i({day:this.oDate.getUTCDate(),month:this.oDate.getUTCMonth(),year:this.oDate.getUTCFullYear()})};n.prototype._setUTCPersian=function(t){var e=o(t);return this.oDate.setUTCFullYear(e.year,e.month,e.day)};n.prototype.getDate=function(t){return this._getPersian().day};n.prototype.getMonth=function(){return this._getPersian().month};n.prototype.getYear=function(){return this._getPersian().year-a};n.prototype.getFullYear=function(){return this._getPersian().year};n.prototype.setDate=function(t){var e=this._getPersian();e.day=t;return this._setPersian(e)};n.prototype.setMonth=function(t,e){var r=this._getPersian();r.month=t;if(e!==undefined){r.day=e}return this._setPersian(r)};n.prototype.setYear=function(t){var e=this._getPersian();e.year=t+a;return this._setPersian(e)};n.prototype.setFullYear=function(t,e,r){var n=this._getPersian();n.year=t;if(e!==undefined){n.month=e}if(r!==undefined){n.day=r}return this._setPersian(n)};n.prototype.getUTCDate=function(t){return this._getUTCPersian().day};n.prototype.getUTCMonth=function(){return this._getUTCPersian().month};n.prototype.getUTCFullYear=function(){return this._getUTCPersian().year};n.prototype.setUTCDate=function(t){var e=this._getUTCPersian();e.day=t;return this._setUTCPersian(e)};n.prototype.setUTCMonth=function(t,e){var r=this._getUTCPersian();r.month=t;if(e!==undefined){r.day=e}return this._setUTCPersian(r)};n.prototype.setUTCFullYear=function(t,e,r){var n=this._getUTCPersian();n.year=t;if(e!==undefined){n.month=e}if(r!==undefined){n.day=r}return this._setUTCPersian(n)};e.set(r.Persian,n);return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/UI5Date", ["sap/base/Log","sap/base/i18n/Localization","sap/base/i18n/date/TimezoneUtils"],function(t,e,n){"use strict";var o=["year","month","day","hour","minute","second","fractionalSecond"],r=/Z|GMT|:.*[\+|\-]|^([\+|\-]\d{2})?\d{4}(-\d{2}){0,2}$/,i=["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],a=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],s={Sun:0,Mon:1,Tue:2,Wed:3,Thu:4,Fri:5,Sat:6};const u=/^(\d{1,4})-(\d{1,2})-(\d{1,2})(?:[T ](\d{1,2})(?::(\d{1,2})(?::(\d{1,2})(?:\.(\d{1,3}))?)?)?)?$/;function c(t,e){return(t<0?"-":"")+Math.abs(t).toString().padStart(e,"0")}function h(e,n){var i=h._createDateInstance(e);Object.defineProperties(this,{sTimezoneID:{value:n},oDate:{value:i,writable:true},oDateParts:{value:undefined,writable:true}});if(isNaN(i)){return}if(e.length>1||e.length===1&&typeof e[0]==="string"&&!r.test(e[0])){const n=[i.getFullYear(),i.getMonth(),i.getDate(),i.getHours(),i.getMinutes(),i.getSeconds(),i.getMilliseconds()];const r=i.getTimezoneOffset();const a=new Date(i.getTime()-72e5).getTimezoneOffset();if(r<a){if(e.length>1){n[1]=e[1]||0;n[2]=e[2]!==undefined?e[2]:1;n[3]=e[3]!==undefined?e[3]:0;n[4]=e[4]!==undefined?e[4]:0}else{const o=u.exec(e[0]);if(o){n[1]=+o[2]-1;n[2]=o[3];n[3]=o[4]!==undefined?o[4]:0;n[4]=o[5]!==undefined?o[5]:0}else{t.warning("UI5Date for '"+e[0]+"' cannot be ensured to be correct as it is near"+" the change from standard time to daylight saving time in the current browser locale;"+" use the constructor with more than 1 arguments or use the ISO format instead",i,"sap.ui.core.date.UI5Date")}}}this._setParts(o,n)}}h.prototype=Object.create(Date.prototype,{constructor:{value:Date}});h.prototype[Symbol.toStringTag]="Date";h.prototype._getPart=function(t){var e;if(isNaN(this.oDate)){return NaN}this.oDateParts=this.oDateParts||n._getParts(this.oDate,this.sTimezoneID);if(t==="weekday"){return s[this.oDateParts.weekday]}e=parseInt(this.oDateParts[t]);if(t==="month"){e-=1}else if(t==="year"){if(this.oDateParts.era==="B"){e=1-e}}return e};h.prototype._setParts=function(t,e){var o,r,i,a,s,u,c={},h=Math.min(t.length,e.length);if(h===0){return this.setTime(NaN)}for(o=0;o<h;o+=1){u=parseInt(+e[o]);s=t[o];if(isNaN(u)){return this.setTime(NaN)}if(s==="month"){u+=1}else if(s==="year"){if(u<=0){u=1-u;c.era="B"}else{c.era="A"}}c[s]=u.toString()}if(this.oDateParts){r=this.oDateParts}else if(isNaN(this.oDate)){r={day:"1",fractionalSecond:"0",hour:"0",minute:"0",month:"1",second:"0"}}else{r=n._getParts(this.oDate,this.sTimezoneID)}c=Object.assign({},r,c);i=n._getDateFromParts(c);if(isNaN(i)){return this.setTime(NaN)}a=i.getTime()+n.calculateOffset(i,this.sTimezoneID)*1e3;return this.setTime(a)};h.prototype.clone=function(){return h.getInstance(this)};h.prototype.getDate=function(){return this._getPart("day")};h.prototype.getDay=function(){return this._getPart("weekday")};h.prototype.getFullYear=function(){return this._getPart("year")};h.prototype.getHours=function(){return this._getPart("hour")};h.prototype.getMilliseconds=function(){return this._getPart("fractionalSecond")};h.prototype.getMinutes=function(){return this._getPart("minute")};h.prototype.getMonth=function(){return this._getPart("month")};h.prototype.getSeconds=function(){return this._getPart("second")};h.prototype.getTimezoneOffset=function(){return n.calculateOffset(this.oDate,this.sTimezoneID)/60};h.prototype.getYear=function(){return this._getPart("year")-1900};h.prototype.setDate=function(t){return this._setParts(["day"],arguments)};h.prototype.setFullYear=function(t,e,n){return this._setParts(["year","month","day"],arguments)};h.prototype.setHours=function(t,e,n,o){return this._setParts(["hour","minute","second","fractionalSecond"],arguments)};h.prototype.setMilliseconds=function(t){return this._setParts(["fractionalSecond"],arguments)};h.prototype.setMinutes=function(t,e,n){return this._setParts(["minute","second","fractionalSecond"],arguments)};h.prototype.setMonth=function(t,e){return this._setParts(["month","day"],arguments)};h.prototype.setSeconds=function(t,e){return this._setParts(["second","fractionalSecond"],arguments)};h.prototype.setTime=function(t){this.oDateParts=undefined;return this.oDate.setTime(t)};h.prototype.setYear=function(t){var e=parseInt(t);e=e<0||e>99?e:e+1900;return this._setParts(["year"],[e])};h.prototype.toDateString=function(){if(isNaN(this.oDate)){return this.oDate.toDateString()}return i[this.getDay()]+" "+a[this.getMonth()]+" "+c(this.getDate(),2)+" "+c(this.getFullYear(),4)};h.prototype.toString=function(){if(isNaN(this.oDate)){return this.oDate.toString()}return this.toDateString()+" "+this.toTimeString()};h.prototype.toTimeString=function(){var t,e,n,o;if(isNaN(this.oDate)){return this.oDate.toTimeString()}o=this.getTimezoneOffset();n=o>0?"-":"+";t=Math.floor(Math.abs(o)/60);e=Math.abs(o)%60;return c(this.getHours(),2)+":"+c(this.getMinutes(),2)+":"+c(this.getSeconds(),2)+" GMT"+n+c(t,2)+c(e,2)};["getTime","getUTCDate","getUTCDay","getUTCFullYear","getUTCHours","getUTCMilliseconds","getUTCMinutes","getUTCMonth","getUTCSeconds","toGMTString","toISOString","toJSON","toUTCString","valueOf"].forEach(function(t){h.prototype[t]=function(){return this.oDate[t].apply(this.oDate,arguments)}});["toLocaleDateString","toLocaleString","toLocaleTimeString"].forEach(function(t){h.prototype[t]=function(n,o){return this.oDate[t](n||e.getLanguageTag().toString(),Object.assign({timeZone:this.sTimezoneID},o))}});["setUTCDate","setUTCFullYear","setUTCHours","setUTCMilliseconds","setUTCMinutes","setUTCMonth","setUTCSeconds"].forEach(function(t){h.prototype[t]=function(){this.oDateParts=undefined;return this.oDate[t].apply(this.oDate,arguments)}});h._createDateInstance=function(t){if(t[0]instanceof Date){t[0]=t[0].valueOf()}return new(Function.prototype.bind.apply(Date,[].concat.apply([null],t)))};h.getInstance=function(){var t=e.getTimezone();if(t!==n.getLocalTimezone()){return new h(arguments,t)}return h._createDateInstance(arguments)};h.checkDate=function(t){if(isNaN(t.getTime())){throw new Error("The given Date is not valid")}if(!(t instanceof h)&&e.getTimezone()!==n.getLocalTimezone()){throw new Error("Configured time zone requires the parameter 'oDate' to be an instance of"+" sap.ui.core.date.UI5Date")}};return h});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/UniversalDate", ["sap/base/i18n/Formatting","sap/base/i18n/date/CalendarWeekNumbering","sap/ui/base/Object","sap/ui/core/Locale","sap/ui/core/LocaleData","./_Calendars","./CalendarUtils","./UI5Date"],function(e,t,r,a,n,i,o,s){"use strict";var u=r.extend("sap.ui.core.date.UniversalDate",{constructor:function(){var e=u.getClass();return this.createDate(e,arguments)}});u.UTC=function(){var e=u.getClass();return e.UTC.apply(e,arguments)};u.now=function(){return Date.now()};u.prototype.createDate=function(e,t){if(e===Date){return s.getInstance.apply(null,t)}return new e(...t)};u.getInstance=function(t,r){var a,n;if(t instanceof u){t=t.getJSDate()}if(t&&isNaN(t.getTime())){throw new Error("The given date object is invalid")}if(!r){r=e.getCalendarType()}a=u.getClass(r);n=Object.create(a.prototype);n.oDate=t?s.getInstance(t):s.getInstance();n.sCalendarType=r;return n};u.getClass=function(t){if(!t){t=e.getCalendarType()}return i.get(t)};["getDate","getMonth","getFullYear","getYear","getDay","getHours","getMinutes","getSeconds","getMilliseconds","getUTCDate","getUTCMonth","getUTCFullYear","getUTCDay","getUTCHours","getUTCMinutes","getUTCSeconds","getUTCMilliseconds","getTime","valueOf","getTimezoneOffset","toString","toDateString","setDate","setFullYear","setYear","setMonth","setHours","setMinutes","setSeconds","setMilliseconds","setUTCDate","setUTCFullYear","setUTCMonth","setUTCHours","setUTCMinutes","setUTCSeconds","setUTCMilliseconds"].forEach(function(e){u.prototype[e]=function(){return this.oDate[e].apply(this.oDate,arguments)}});u.prototype.getJSDate=function(){return this.oDate};u.prototype.getCalendarType=function(){return this.sCalendarType};u.prototype.getEra=function(){return u.getEraByDate(this.sCalendarType,this.oDate.getFullYear(),this.oDate.getMonth(),this.oDate.getDate())};u.prototype.setEra=function(e){};u.prototype.getUTCEra=function(){return u.getEraByDate(this.sCalendarType,this.oDate.getUTCFullYear(),this.oDate.getUTCMonth(),this.oDate.getUTCDate())};u.prototype.setUTCEra=function(e){};u.prototype.getWeek=function(e,t){return u.getWeekByDate(this.sCalendarType,this.getFullYear(),this.getMonth(),this.getDate(),e,t)};u.prototype.setWeek=function(e,t,r){var a=u.getFirstDateOfWeek(this.sCalendarType,e.year||this.getFullYear(),e.week,t,r);this.setFullYear(a.year,a.month,a.day)};u.prototype.getUTCWeek=function(e,t){return u.getWeekByDate(this.sCalendarType,this.getUTCFullYear(),this.getUTCMonth(),this.getUTCDate(),e,t)};u.prototype.setUTCWeek=function(e,t,r){var a=u.getFirstDateOfWeek(this.sCalendarType,e.year||this.getFullYear(),e.week,t,r);this.setUTCFullYear(a.year,a.month,a.day)};u.prototype.getQuarter=function(){return Math.floor(this.getMonth()/3)};u.prototype.getUTCQuarter=function(){return Math.floor(this.getUTCMonth()/3)};u.prototype.getDayPeriod=function(){if(this.getHours()<12){return 0}else{return 1}};u.prototype.getUTCDayPeriod=function(){if(this.getUTCHours()<12){return 0}else{return 1}};u.prototype.getTimezoneShort=function(){if(this.oDate.getTimezoneShort){return this.oDate.getTimezoneShort()}};u.prototype.getTimezoneLong=function(){if(this.oDate.getTimezoneLong){return this.oDate.getTimezoneLong()}};var g=7*24*60*60*1e3;u.getWeekByDate=function(t,r,n,i,o,s){s=s||e.getCalendarWeekNumbering();l(s);o=o||new a(e.getLanguageTag());var u=this.getClass(t);var g=c(u,r,o,s);var p=new u(u.UTC(r,n,i));var T,h,C,D,d;var U=f(s,o);if(U){T=y(g,p)}else{h=r-1;C=r+1;D=c(u,h,o,s);d=c(u,C,o,s);if(p>=d){r=C;T=0}else if(p<g){r=h;T=y(D,p)}else{T=y(g,p)}}return{year:r,week:T}};u.getFirstDateOfWeek=function(t,r,n,i,o){o=o||e.getCalendarWeekNumbering();l(o);i=i||new a(e.getLanguageTag());var s=this.getClass(t);var u=c(s,r,i,o);var p=new s(u.valueOf()+n*g);var y=f(o,i);if(y&&n===0&&u.getUTCFullYear()<r){return{year:r,month:0,day:1}}return{year:p.getUTCFullYear(),month:p.getUTCMonth(),day:p.getUTCDate()}};function f(e,r){var a=n.getInstance(r);return(e===t.Default||e===t.WesternTraditional)&&a.firstDayStartsFirstWeek()}function l(e){if(typeof e==="object"){if(typeof e.firstDayOfWeek!=="number"||typeof e.minimalDaysInFirstWeek!=="number"){throw new TypeError("Week config requires firstDayOfWeek and minimalDaysInFirstWeek to be set")}}else if(!Object.values(t).includes(e)){throw new TypeError("Illegal format option calendarWeekNumbering: '"+e+"'")}}function p(e,t){if(typeof e==="object"&&typeof e.firstDayOfWeek==="number"&&typeof e.minimalDaysInFirstWeek==="number"){return e}return o.getWeekConfigurationValues(e,t)}function c(t,r,n,i){n=n||new a(e.getLanguageTag());var o=p(i,n);var s=o.minimalDaysInFirstWeek;var u=o.firstDayOfWeek;var g=new t(t.UTC(r,0,1));var f=7;if(isNaN(g.getTime())){throw new Error("Could not determine the first day of the week, because the date "+"object is invalid")}while(g.getUTCDay()!==u){g.setUTCDate(g.getUTCDate()-1);f--}if(f<s){g.setUTCDate(g.getUTCDate()+7)}return g}function y(e,t){return Math.floor((t.valueOf()-e.valueOf())/g)}var T={};u.getEraByDate=function(e,t,r,a){var n=h(e),i=new Date(0).setUTCFullYear(t,r,a),o;for(var s=n.length-1;s>=0;s--){o=n[s];if(!o){continue}if(o._start&&i>=o._startInfo.timestamp){return s}if(o._end&&i<o._endInfo.timestamp){return s}}};u.getCurrentEra=function(e){var t=s.getInstance();return this.getEraByDate(e,t.getFullYear(),t.getMonth(),t.getDate())};u.getEraStartDate=function(e,t){var r=h(e),a=r[t]||r[0];if(a._start){return a._startInfo}};function h(t){var r=new a(e.getLanguageTag()),i=n.getInstance(r),o=T[t];if(!o){var o=i.getEraDates(t);if(!o[0]){o[0]={_start:"1-1-1"}}for(var s=0;s<o.length;s++){var u=o[s];if(!u){continue}if(u._start){u._startInfo=C(u._start)}if(u._end){u._endInfo=C(u._end)}}T[t]=o}return o}function C(e){var t=e.split("-"),r,a,n;if(t[0]==""){r=-parseInt(t[1]);a=parseInt(t[2])-1;n=parseInt(t[3])}else{r=parseInt(t[0]);a=parseInt(t[1])-1;n=parseInt(t[2])}return{timestamp:new Date(0).setUTCFullYear(r,a,n),year:r,month:a,day:n}}return u});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/UniversalDateUtils", ["sap/base/i18n/Formatting","sap/ui/core/date/UniversalDate","sap/ui/core/Locale","sap/ui/core/LocaleData","sap/base/assert"],function(e,t,r,a,n){"use strict";function u(e){n(e instanceof t,"method accepts only instances of UniversalDate");return e.createDate(e.constructor,[e.getJSDate()])}var s={};s.getRange=function(e,t,r,a){if(a===undefined){a=true}if(isNaN(e)){throw new TypeError("duration is NaN, but is "+e)}e=Math.trunc(e);var n=s.resetStartTime(r==undefined?null:r),i;if(a){switch(t){case"MINUTE":case"HOUR":n=s.createNewUniversalDate();break;case"DAY":break;case"WEEK":n=s.getWeekStartDate(n);break;case"MONTH":n=s.getMonthStartDate(n);break;case"QUARTER":n=s.getQuarterStartDate(n);break;case"YEAR":n=s.getYearStartDate(n);break;default:throw new TypeError("invalid unit "+t)}}switch(t){case"MINUTE":i=u(n);i.setMinutes(n.getMinutes()+e);break;case"HOUR":i=u(n);i.setHours(n.getHours()+e);break;case"DAY":if(e>0){n.setDate(n.getDate()+1)}i=u(n);e=e==0?1:e;i.setDate(n.getDate()+e);break;case"WEEK":if(e>0){n.setDate(n.getDate()+7)}i=u(n);e=e==0?1:e;i.setDate(n.getDate()+e*7);break;case"MONTH":if(e>0){n.setMonth(n.getMonth()+1)}i=u(n);e=e==0?1:e;i.setMonth(n.getMonth()+e);break;case"QUARTER":if(e>0){n.setMonth(n.getMonth()+3)}i=u(n);e=e==0?1:e;i.setMonth(n.getMonth()+e*3);break;case"YEAR":if(e>0){n.setFullYear(n.getFullYear()+1)}i=u(n);e=e==0?1:e;i.setFullYear(n.getFullYear()+e);break;default:throw new TypeError("invalid unit "+t)}if(i.getTime()<n.getTime()){i=[n,n=i][0]}if(t==="HOUR"||t==="MINUTE"){return[n,i]}i.setDate(i.getDate()-1);return[s.resetStartTime(n),s.resetEndTime(i)]};s.getWeekStartDate=function(t,n){var i=n?new r(n):new r(e.getLanguageTag()),g=a.getInstance(i),o=g.getFirstDayOfWeek();t=t?u(t):u(s.createNewUniversalDate());t.setDate(t.getDate()-t.getDay()+o);return s.resetStartTime(t)};s.getWeekLastDate=function(e,t){var r=s.getWeekStartDate(e,t);r.setDate(r.getDate()+6);return s.resetStartTime(r)};s.getMonthStartDate=function(e){e=e?u(e):u(s.createNewUniversalDate());e.setDate(1);return s.resetStartTime(e)};s.getMonthEndDate=function(e){var t=s.getMonthStartDate(e);t.setMonth(t.getMonth()+1);t.setDate(0);return s.resetStartTime(t)};s.getQuarterStartDate=function(e){e=e?u(e):u(s.createNewUniversalDate());e.setMonth(3*Math.floor(e.getMonth()/3));e.setDate(1);return s.resetStartTime(e)};s.getQuarterEndDate=function(e){var t=s.getQuarterStartDate(e);t.setMonth(t.getMonth()+3);t.setDate(0);return s.resetStartTime(t)};s.getYearStartDate=function(e){e=e?u(e):u(s.createNewUniversalDate());e.setMonth(0);e.setDate(1);return s.resetStartTime(e)};s.getYearEndDate=function(e){e=e?u(e):u(s.createNewUniversalDate());e.setFullYear(e.getFullYear()+1);e.setMonth(0);e.setDate(0);return s.resetStartTime(e)};s.resetStartTime=function(e){e=e?u(e):u(s.createNewUniversalDate());e.setHours(0,0,0,0);return e};s.resetEndTime=function(e){e=e?u(e):u(s.createNewUniversalDate());e.setHours(23,59,59,999);return e};s.createNewUniversalDate=function(){return new t};s._getDateFromWeekStartByDayOffset=function(a,n){var u=e.getCalendarType(),i=r._getCoreLocale(e.getLanguageTag()),g=s.createNewUniversalDate(),o=g.getWeek(i,a),f=t.getFirstDateOfWeek(u,o.year,o.week,i,a);if(n===undefined){n=0}return new t(f.year,f.month,f.day+n,0,0,0)};s.ranges={lastDays:function(e){return s.getRange(-e,"DAY")},lastMinutes:function(e){return s.getRange(-e,"MINUTE")},lastHours:function(e){return s.getRange(-e,"HOUR")},yesterday:function(){return s.getRange(-1,"DAY")},today:function(){return s.getRange(0,"DAY")},tomorrow:function(){return s.getRange(1,"DAY")},nextMinutes:function(e){return s.getRange(e,"MINUTE")},nextHours:function(e){return s.getRange(e,"HOUR")},nextDays:function(e){return s.getRange(e,"DAY")},lastWeeks:function(e,t){var r;if(t){r=s._getDateFromWeekStartByDayOffset(t);return s.getRange(-e,"WEEK",r,false)}return s.getRange(-e,"WEEK")},lastWeek:function(e){var t;if(e){t=s._getDateFromWeekStartByDayOffset(e);return s.getRange(-1,"WEEK",t,false)}return s.getRange(-1,"WEEK")},currentWeek:function(e){var t;if(e){t=s._getDateFromWeekStartByDayOffset(e);return s.getRange(0,"WEEK",t,false)}return s.getRange(0,"WEEK")},firstDayOfWeek:function(e){var t;if(e){t=s._getDateFromWeekStartByDayOffset(e);return[s.resetStartTime(t),s.resetEndTime(t)]}var r=s.getWeekStartDate();return[r,s.resetEndTime(r)]},lastDayOfWeek:function(e){var t,r;if(e){r=6;t=s._getDateFromWeekStartByDayOffset(e,r);return[t,s.resetEndTime(t)]}var a=s.getWeekLastDate();return[a,s.resetEndTime(a)]},nextWeek:function(e){var t;if(e){t=s._getDateFromWeekStartByDayOffset(e);return s.getRange(1,"WEEK",t,false)}return s.getRange(1,"WEEK")},nextWeeks:function(e,t){var r;if(t){r=s._getDateFromWeekStartByDayOffset(t);return s.getRange(e,"WEEK",r,false)}return s.getRange(e,"WEEK")},lastMonths:function(e){return s.getRange(-e,"MONTH")},lastMonth:function(){return s.getRange(-1,"MONTH")},currentMonth:function(){return s.getRange(0,"MONTH")},firstDayOfMonth:function(){var e=s.getMonthStartDate();return[e,s.resetEndTime(e)]},lastDayOfMonth:function(){var e=s.getMonthEndDate();return[e,s.resetEndTime(e)]},nextMonth:function(){return s.getRange(1,"MONTH")},nextMonths:function(e){return s.getRange(e,"MONTH")},lastQuarters:function(e){return s.getRange(-e,"QUARTER")},lastQuarter:function(){return s.getRange(-1,"QUARTER")},firstDayOfQuarter:function(){var e=s.getQuarterStartDate();return[e,s.resetEndTime(e)]},lastDayOfQuarter:function(){var e=s.getQuarterEndDate();return[e,s.resetEndTime(e)]},currentQuarter:function(){return s.getRange(0,"QUARTER")},nextQuarter:function(){return s.getRange(1,"QUARTER")},nextQuarters:function(e){return s.getRange(e,"QUARTER")},quarter:function(e){if(e<=2){return s.getRange(e-1,"QUARTER",s.getYearStartDate())}else{var t=s.getRange(e-2,"QUARTER",s.getYearStartDate());var r=t[1];r.setMilliseconds(1e3);return s.getRange(0,"QUARTER",r)}},lastYears:function(e){return s.getRange(-e,"YEAR")},lastYear:function(){return s.getRange(-1,"YEAR")},firstDayOfYear:function(){var e=s.getYearStartDate();return[e,s.resetEndTime(e)]},lastDayOfYear:function(){var e=s.getYearEndDate();return[e,s.resetEndTime(e)]},currentYear:function(){return s.getRange(0,"YEAR")},nextYear:function(){return s.getRange(1,"YEAR")},nextYears:function(e){return s.getRange(e,"YEAR")},yearToDate:function(){var e=s.createNewUniversalDate();return[s.getYearStartDate(e),s.resetEndTime(e)]},dateToYear:function(){var e=s.createNewUniversalDate();return[s.resetStartTime(e),s.resetEndTime(s.getYearEndDate(e))]}};return s});
/*
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/date/_Calendars", [],function(){"use strict";var e=new Map;var r={get:function(r){if(!e.has(r)){sap.ui.requireSync("sap/ui/core/date/"+r)}if(e.has(r)){return e.get(r)}throw new TypeError("Load required calendar 'sap/ui/core/date/"+r+"' in advance")},set:function(r,a){e.set(r,a)}};return r});
//# sourceMappingURL=Calendar-preload.js.map
