//@ui5-bundle Eventing-preload-0.js
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/i18n/LanguageFallback", ["sap/base/Log"],function(e){"use strict";const n=/(?:^|-)(saptrc|sappsd|saprigi)(?:-|$)/i;const r=/^((?:[A-Z]{2,3}(?:-[A-Z]{3}){0,3})|[A-Z]{4}|[A-Z]{5,8})(?:-([A-Z]{4}))?(?:-([A-Z]{2}|[0-9]{3}))?((?:-[0-9A-Z]{5,8}|-[0-9][0-9A-Z]{3})*)((?:-[0-9A-WYZ](?:-[0-9A-Z]{2,8})+)*)(?:-(X(?:-[0-9A-Z]{1,8})+))?$/i;const i={he:"iw",yi:"ji",nb:"no"};const t={iw:"he",ji:"yi"};const a=function(e,t){var a;if(typeof e==="string"&&(a=r.exec(e.replace(/_/g,"-")))){var s=a[1].toLowerCase();if(!t){s=i[s]||s}var o=a[2]?a[2].toLowerCase():undefined;var l=a[3]?a[3].toUpperCase():undefined;var f=a[4]?a[4].slice(1):undefined;var c=a[6];if(c&&(a=n.exec(c))||f&&(a=n.exec(f))){return"en_US_"+a[1].toLowerCase()}if(s==="zh"&&!l){if(o==="hans"){l="CN"}else if(o==="hant"){l="TW"}}if(s==="sr"&&o==="latn"){if(t){s="sr_Latn"}else{s="sh"}}return s+(l?"_"+l+(f?"_"+f.replace("-","_"):""):"")}};const s=function(e,n){if(e===""){return e}var r=a(e,n);if(r===undefined){throw new TypeError("Locale '"+e+"' is not a valid BCP47 language tag")}return r};const o=function(e,n){var i;if(typeof e==="string"&&(i=r.exec(e.replace(/_/g,"-")))){var a=i[1].toLowerCase();var s=i[2]?i[2].toLowerCase():undefined;if(n&&a==="sh"&&!s){a="sr_Latn"}else if(!n&&a==="sr"&&s==="latn"){a="sh"}a=t[a]||a;return a+(i[3]?"-"+i[3].toUpperCase()+(i[4]?"-"+i[4].slice(1).replace("_","-"):""):"")}};const l=function(e,n){if(!n||n.length===0||n.includes(e)){return e}e=o(e,true);if(e){e=a(e,true)}if(n.includes(e)){return e}return undefined};const f=function(n,r,i,t,a){r=r&&r.map(function(e){return s(e,true)});if(!a){var o=i!==undefined;i=o?i:"en";i=s(i);if(i!==""&&!l(i,r)){var f="The fallback locale '"+i+"' is not contained in the list of supported locales ['"+r.join("', '")+"']"+t+" and will be ignored.";if(o){throw new Error(f)}e.error(f)}}var c=[],u;while(n!=null){u=l(n,r);if(u!==undefined&&c.indexOf(u)===-1){c.push(u)}if(!n){n=null}else if(n==="zh_HK"){n="zh_TW"}else if(n.lastIndexOf("_")>=0){n=n.slice(0,n.lastIndexOf("_"))}else if(a){n=null}else if(i){n=i;i=null}else{n=""}}return c};const c=function(e,n,r){return f(a(e),n,r,"")};return{convertLocaleToBCP47:o,calculate:f,getFallbackLocales:c,normalize:a}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/i18n/ResourceBundle", ["sap/base/assert","sap/base/future","sap/base/Log","sap/base/i18n/LanguageFallback","sap/base/i18n/Localization","sap/base/strings/formatMessage","sap/base/util/Properties","sap/base/util/merge"],function(e,r,t,n,a,s,o,i){"use strict";var l={en_US_saptrc:"1Q",en_US_sappsd:"2Q",en_US_saprigi:"3Q"};var u="en";const c={_oCache:new Map,_delete(e){this._oCache.delete(e)},_load(e){return o.create(e)},_set(e,r){this._oCache.set(e,r)},get(e,r,t){if(this._oCache.has(e)){const r=this._oCache.get(e);if(t){return Promise.resolve(r)}else if(!(r instanceof Promise)){return r}}const n=this._load(r);if(n instanceof Promise){n.then(r=>{if(r){this._set(e,r)}else{this._delete(e)}}).catch(r=>{this._delete(e);throw r})}if(n){this._set(e,n)}return n}};function f(e){var r;r=a.getLanguage();r=n.normalize(r);return r||e}var h=/^((?:[^?#]*\/)?[^\/?#]*)(\.[^.\/?#]+)((?:\?([^#]*))?(?:#(.*))?)$/;var p=[".properties",".hdbtextbundle"];function d(e){var r=h.exec(e);if(!r||p.indexOf(r[2])<0){throw new Error("resource URL '"+e+"' has unknown type (should be one of "+p.join(",")+")")}return{url:e,prefix:r[1],ext:r[2],query:r[4],hash:r[5]||"",suffix:r[2]+(r[3]||"")}}function g(e,t,s,o,i,l,c){this.sLocale=n.normalize(t)||f(l===undefined?u:l);this.oUrlInfo=d(e);this.bIncludeInfo=s;this.bAsync=o;this.aCustomBundles=[];this.aPropertyFiles=[];this.aPropertyOrigins=[];this.aLocales=[];this._aFallbackLocales=n.calculate(this.sLocale,i||a.getSupportedLanguages(),l," of the bundle '"+this.oUrlInfo.url+"'",c);if(o){return b(this).then(()=>this,e=>{r.errorThrows(e.message);return this})}m(this)}g.prototype._enhance=function(e){if(e instanceof g){this.aCustomBundles.push(e)}else{t.error("Custom resource bundle is either undefined or not an instanceof sap/base/i18n/ResourceBundle. Therefore this custom resource bundle will be ignored!")}};g.prototype.getText=function(r,t,n){var a=this._getTextFromProperties(r,t);if(a!=null){return a}a=this._getTextFromFallback(r,t);if(a!=null){return a}if(n){return undefined}else{e(false,"could not find any translatable text for key '"+r+"' in bundle file(s): '"+this.aPropertyOrigins.join("', '")+"'");return this._formatValue(r,r,t)}};g.prototype._formatValue=function(e,t,n){if(typeof e==="string"){if(n!==undefined&&!Array.isArray(n)){r.errorThrows("sap/base/i18n/ResourceBundle: value for parameter 'aArgs' is not of type array")}if(n){e=s(e,n)}if(this.bIncludeInfo){e=new String(e);e.originInfo={source:"Resource Bundle",url:this.oUrlInfo.url,locale:this.sLocale,key:t}}}return e};g.prototype._getTextFromFallback=function(e,r){var t,n;for(n=this.aCustomBundles.length-1;n>=0;n--){t=this.aCustomBundles[n]._getTextFromFallback(e,r);if(t!=null){return t}}while(typeof t!=="string"&&this._aFallbackLocales.length){var a=m(this);if(a){t=a.getProperty(e);if(typeof t==="string"){return this._formatValue(t,e,r)}}}return null};g.prototype._getTextFromProperties=function(e,r){var t=null,n;for(n=this.aCustomBundles.length-1;n>=0;n--){t=this.aCustomBundles[n]._getTextFromProperties(e,r);if(t!=null){return t}}for(n=0;n<this.aPropertyFiles.length;n++){t=this.aPropertyFiles[n].getProperty(e);if(typeof t==="string"){return this._formatValue(t,e,r)}}return null};g.prototype.hasText=function(e){return this.aPropertyFiles.length>0&&typeof this.aPropertyFiles[0].getProperty(e)==="string"};g.prototype._recreate=function(){if(!this._mCreateFactoryParams){var e=new Error("ResourceBundle instance can't be recreated as it has not been created by the ResourceBundle.create factory.");if(this.bAsync){return Promise.reject(e)}else{throw e}}else{return g.create(this._mCreateFactoryParams)}};function b(e){if(e._aFallbackLocales.length){return _(e,true).then(function(r){return r||b(e)})}return Promise.resolve(null)}function m(e){while(e._aFallbackLocales.length){var r=_(e,false);if(r){return r}}return null}function _(e,r){var t=e._aFallbackLocales.shift();if(t!=null){var a=e.oUrlInfo,s,o;if(a.ext===".hdbtextbundle"){if(l[t]){s=a.prefix+a.suffix+"?"+(a.query?a.query+"&":"")+"sap-language="+l[t]+(a.hash?"#"+a.hash:"")}else{s=a.url}o={"Accept-Language":n.convertLocaleToBCP47(t)||"*"}}else{s=a.prefix+(t?"_"+t:"")+a.suffix}var i=JSON.stringify({url:new URL(s,document.baseURI).href,headers:o});var u={url:s,headers:o,async:!!r,returnNullIfMissing:true};const h=c.get(i,u,u.async);var f=function(r){if(r){e.aPropertyFiles.push(r);e.aPropertyOrigins.push(s);e.aLocales.push(t)}return r};return r?h.then(f):f(h)}return r?Promise.resolve(null):null}g._getUrl=function(e,r){var t=e;if(r){r=r.replace(/\./g,"/");t=sap.ui.require.toUrl(r)+".properties"}return t};function y(e,r,t,n,a,s,o){if(!r){return[]}var i=[];r.forEach(function(r){if(r.fallbackLocale===undefined){r.fallbackLocale=s}if(r.supportedLocales===undefined){r.supportedLocales=o}var l=g._getUrl(r.bundleUrl,r.bundleName);var u=new g(l,t,n,a,r.supportedLocales,r.fallbackLocale);i.push(u);if(r.terminologies){i=i.concat(v(e,r.terminologies,t,n,a))}});return i}function v(e,r,t,n,a){if(!e){return[]}e=e.filter(function(e){return r.hasOwnProperty(e)});e.reverse();return e.map(function(e){var s=r[e];var o=g._getUrl(s.bundleUrl,s.bundleName);var i=s.supportedLocales;return new g(o,t,n,a,i,null,true)})}g.create=function(e){var r=i({},e);e=i({url:"",includeInfo:false},e);if(e.bundleUrl||e.bundleName){e.url=e.url||g._getUrl(e.bundleUrl,e.bundleName)}e=g._enrichBundleConfig(e);var t=new g(e.url,e.locale,e.includeInfo,!!e.async,e.supportedLocales,e.fallbackLocale);if(t instanceof Promise){t=t.then(function(e){e._mCreateFactoryParams=r;return e})}else{t._mCreateFactoryParams=r}var n=[];if(e.terminologies){n=n.concat(v(e.activeTerminologies,e.terminologies,e.locale,e.includeInfo,!!e.async))}if(e.enhanceWith){n=n.concat(y(e.activeTerminologies,e.enhanceWith,e.locale,e.includeInfo,!!e.async,e.fallbackLocale,e.supportedLocales))}if(n.length){if(t instanceof Promise){t=t.then(function(e){return Promise.all(n).then(function(r){r.forEach(e._enhance,e)}).then(function(){return e})})}else{n.forEach(t._enhance,t)}}return t};g._enrichBundleConfig=function(e){return e};g._getFallbackLocales=n.getFallbackLocales;g._getPropertiesCache=function(){return c._oCache};return g});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/security/encodeCSS", ["sap/base/strings/toHex"],function(r){"use strict";var e=/[\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\xff\u2028\u2029][0-9A-Fa-f]?/g;var t=function(e){var t=e.charCodeAt(0);if(e.length===1){return"\\"+r(t)}else{return"\\"+r(t)+" "+e.substr(1)}};var n=function(r){return r.replace(e,t)};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/security/encodeXML", ["sap/base/strings/toHex"],function(x){"use strict";var e=/[\x00-\x2b\x2f\x3a-\x40\x5b-\x5e\x60\x7b-\xff\u2028\u2029]/g,t=/[\x00-\x08\x0b\x0c\x0e-\x1f\x7f-\x9f]/,f={"<":"&lt;",">":"&gt;","&":"&amp;",'"':"&quot;"};var r=function(e){var r=f[e];if(!r){if(t.test(e)){r="&#xfffd;"}else{r="&#x"+x(e.charCodeAt(0))+";"}f[e]=r}return r};var a=function(x){return x.replace(e,r)};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/strings/camelize", [],function(){"use strict";var r=/-(.)/gi;var e=function(e){return e.replace(r,function(r,e){return e.toUpperCase()})};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/strings/capitalize", [],function(){"use strict";var r=function(r){return r.charAt(0).toUpperCase()+r.substring(1)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/strings/escapeRegExp", [],function(){"use strict";var r=/[[\]{}()*+?.\\^$|]/g;var e=function(e){return e.replace(r,"\\$&")};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/strings/formatMessage", ["sap/base/assert"],function(r){"use strict";var e=/('')|'([^']+(?:''[^']*)*)(?:'|$)|\{([0-9]+(?:\s*,[^{}]*)?)\}|[{}]/g;var t=function(t,n){r(typeof t==="string"||t instanceof String,"pattern must be string");if(arguments.length>2||n!=null&&!Array.isArray(n)){n=Array.prototype.slice.call(arguments,1)}n=n||[];return t.replace(e,function(r,e,t,s,a){if(e){return"'"}else if(t){return t.replace(/''/g,"'")}else if(s){return String(n[parseInt(s)])}throw new Error("formatMessage: pattern syntax error at pos. "+a)})};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/strings/toHex", [],function(){"use strict";var t=function(t,r){var n=t.toString(16);if(r){n=n.padStart(r,"0")}return n};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/JSTokenizer", [],function(){"use strict";
/*
	 * The following code has been taken from the component JSON in JavaScript
	 * from Douglas Crockford which is licensed under Public Domain
	 * (http://www.json.org/ > JavaScript > json-2). The code contains
	 * local modifications.
	 *
	 * Git URL: https://github.com/douglascrockford/JSON-js/blob/ff55d8d4513b149e2511aee01c3a61d372837d1f/json_parse.js
	 */var t=function(){this.at;this.ch;this.escapee={'"':'"',"'":"'","\\":"\\","/":"/",b:"\b",f:"\f",n:"\n",r:"\r",t:"\t"};this.text};t.prototype.error=function(t){const i=new SyntaxError(t);i.at=this.at;i.text=this.text;throw i};t.prototype.next=function(t){if(t&&t!==this.ch){this.error("Expected '"+t+"' instead of '"+this.ch+"'")}this.ch=this.text.charAt(this.at);this.at+=1;return this.ch};t.prototype.number=function(){var t,i="";if(this.ch==="-"){i="-";this.next("-")}while(this.ch>="0"&&this.ch<="9"){i+=this.ch;this.next()}if(this.ch==="."){i+=".";while(this.next()&&this.ch>="0"&&this.ch<="9"){i+=this.ch}}if(this.ch==="e"||this.ch==="E"){i+=this.ch;this.next();if(this.ch==="-"||this.ch==="+"){i+=this.ch;this.next()}while(this.ch>="0"&&this.ch<="9"){i+=this.ch;this.next()}}t=+i;if(!isFinite(t)){this.error("Bad number")}else{return t}};t.prototype.string=function(){var t,i,h="",e,s;if(this.ch==='"'||this.ch==="'"){e=this.ch;while(this.next()){if(this.ch===e){this.next();return h}if(this.ch==="\\"){this.next();if(this.ch==="u"){s=0;for(i=0;i<4;i+=1){t=parseInt(this.next(),16);if(!isFinite(t)){break}s=s*16+t}h+=String.fromCharCode(s)}else if(typeof this.escapee[this.ch]==="string"){h+=this.escapee[this.ch]}else{break}}else{h+=this.ch}}}this.error("Bad string")};function i(t){return t==="_"||t==="$"||t>="0"&&t<="9"||t>="a"&&t<="z"||t>="A"&&t<="Z"}t.prototype.name=function(){var t="";if(i(this.ch)){t+=this.ch}else{this.error("Bad name")}while(this.next()){if(this.ch<=" "){this.next();return t}if(this.ch===":"){return t}if(i(this.ch)){t+=this.ch}else{this.error("Bad name")}}this.error("Bad name")};t.prototype.white=function(){while(this.ch&&this.ch<=" "){this.next()}};t.prototype.word=function(){switch(this.ch){case"t":this.next("t");this.next("r");this.next("u");this.next("e");return true;case"f":this.next("f");this.next("a");this.next("l");this.next("s");this.next("e");return false;case"n":this.next("n");this.next("u");this.next("l");this.next("l");return null}this.error("Unexpected '"+this.ch+"'")};t.prototype.array=function(){var t=[];if(this.ch==="["){this.next("[");this.white();if(this.ch==="]"){this.next("]");return t}while(this.ch){t.push(this.value());this.white();if(this.ch==="]"){this.next("]");return t}this.next(",");this.white()}}this.error("Bad array")};var h=function(){var t,h={};if(this.ch==="{"){this.next("{");this.white();if(this.ch==="}"){this.next("}");return h}while(this.ch){if(this.ch>="0"&&this.ch<="9"){t=this.number()}else if(this.ch==='"'||this.ch==="'"){t=this.string()}else if(i(this.ch)){t=this.name()}else{const t=Math.max(0,this.at-10);const i=this.text.substring(t,this.at+10);const h=this.at-t;this.error(`Syntax error: Unexpected character '${this.ch}'.\n\n${i}\n${" ".repeat(h-1)}^`)}this.white();this.next(":");if(Object.hasOwn(h,t)){this.error('Duplicate key "'+t+'"')}h[t]=this.value();this.white();if(this.ch==="}"){this.next("}");return h}this.next(",");this.white()}}this.error("Bad object")};t.prototype.value=function(){this.white();switch(this.ch){case"{":return h.call(this);case"[":return this.array();case'"':case"'":return this.string();case"-":return this.number();default:return this.ch>="0"&&this.ch<="9"?this.number():this.word()}};t.prototype.getIndex=function(){return this.at-1};t.prototype.getCh=function(){return this.ch};t.prototype.init=function(t,i){this.text=t;this.at=i||0;this.ch=" "};t.prototype.setIndex=function(t){if(t<this.at-1){throw new Error("Must not set index "+t+" before previous index "+(this.at-1))}this.at=t;this.next()};t.parseJS=function(i,h){var e=new t;var s;e.init(i,h);s=e.value();if(isNaN(h)){e.white();if(e.getCh()){e.error("Syntax error")}return s}else{return{result:s,at:e.getIndex()}}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/Properties", ["sap/base/util/LoaderExtensions"],function(e){"use strict";var r=function(){this.mProperties={};this.aKeys=null};r.prototype.getProperty=function(e,r){var t=this.mProperties[e];if(typeof t=="string"){return t}else if(r){return r}return null};r.prototype.getKeys=function(){if(!this.aKeys){this.aKeys=Object.keys(this.mProperties)}return this.aKeys};r.prototype.setProperty=function(e,r){if(typeof r!="string"){return}if(typeof this.mProperties[e]!="string"&&this.aKeys){this.aKeys.push(String(e))}this.mProperties[e]=r};r.prototype.clone=function(){var e=new r;e.mProperties=Object.assign({},this.mProperties);return e};var t=typeof chrome==="object"||typeof v8==="object"?function(e,r){if(r>2&&40*r>e.length){Number(e)}return e}:function(e){return e};var n=/(?:\r\n|\r|\n|^)[ \t\f]*/;var i=/(\\u[0-9a-fA-F]{0,4})|(\\.)|(\\$)|([ \t\f]*[ \t\f:=][ \t\f]*)/g;var s=/(\\u[0-9a-fA-F]{0,4})|(\\.)|(\\$)/g;var o={"\\f":"\f","\\n":"\n","\\r":"\r","\\t":"\t"};function f(e,r){var f=e.split(n),u,l,a,c,p,h,y,g;function d(e){if(c){c=c+e;g++}else{c=e;g=0}}r.mProperties={};for(p=0;p<f.length;p++){u=f[p];if(u===""||u.charAt(0)==="#"||u.charAt(0)==="!"){continue}l=i;l.lastIndex=y=0;a=null;c="";while((h=l.exec(u))!==null){if(y<h.index){d(u.slice(y,h.index))}y=l.lastIndex;if(h[1]){if(h[1].length!==6){throw new Error("Incomplete Unicode Escape '"+h[1]+"'")}d(String.fromCharCode(parseInt(h[1].slice(2),16)))}else if(h[2]){d(o[h[2]]||h[2].slice(1))}else if(h[3]){u=f[++p];l.lastIndex=y=0}else if(h[4]){a=c;c="";l=s;l.lastIndex=y}}if(y<u.length){d(u.slice(y))}if(a==null){a=c;c=""}r.mProperties[a]=t(c,c?g:0)}}r.create=function(t){t=Object.assign({url:undefined,headers:{}},t);var n=!!t.async,i=new r,s;function o(e){if(typeof e==="string"){f(e,i);return i}return t.returnNullIfMissing?null:i}if(typeof t.url==="string"){s=e.loadResource({url:t.url,dataType:"text",headers:t.headers,failOnError:false,async:n})}if(n){if(!s){return Promise.resolve(o(null))}return s.then(function(e){return o(e)},function(e){throw e instanceof Error?e:new Error("Problem during loading of property file '"+t.url+"': "+e)})}return o(s)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/Version", [],function(){"use strict";var t=/^[0-9]+(?:\.([0-9]+)(?:\.([0-9]+))?)?(.*)$/;function n(r,i,e,o){if(r instanceof n){return r}if(!(this instanceof n)){return new n(r,i,e,o)}var u;if(typeof r==="string"){u=t.exec(r)}else if(Array.isArray(r)){u=r}else{u=arguments}u=u||[];function f(t){t=parseInt(t);return isNaN(t)?0:t}r=f(u[0]);i=f(u[1]);e=f(u[2]);o=String(u[3]||"");this.toString=function(){return r+"."+i+"."+e+o};this.getMajor=function(){return r};this.getMinor=function(){return i};this.getPatch=function(){return e};this.getSuffix=function(){return o};this.compareTo=function(t,u,f,s){var a=n.apply(window,arguments);return r-a.getMajor()||i-a.getMinor()||e-a.getPatch()||(o<a.getSuffix()?-1:o===a.getSuffix()?0:1)}}n.prototype.inRange=function(t,n){return this.compareTo(t)>=0&&this.compareTo(n)<0};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/deepClone", ["./isPlainObject"],function(e){"use strict";var r=function(e,r){if(!r){r=10}return n(e,0,r)};function n(e,r,n){if(r>n){throw new TypeError("The structure depth of the source exceeds the maximum depth ("+n+")")}if(e==null){return e}else if(e instanceof Date){if(e.clone){return e.clone()}return new Date(e.getTime())}else if(Array.isArray(e)){return t(e,r,n)}else if(typeof e==="object"){return i(e,r,n)}else{return e}}function t(e,r,t){var i=[];for(var o=0;o<e.length;o++){i.push(n(e[o],r+1,t))}return i}function i(r,t,i){if(!e(r)){throw new TypeError("Cloning is only supported for plain objects")}var o={};for(var u in r){if(u==="__proto__"){continue}o[u]=n(r[u],t+1,i)}return o}return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/deepExtend", ["./_merge"],function(r){"use strict";var u=function(){var u=[true,true];u.push.apply(u,arguments);return r.apply(null,u)};return u});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/merge", ["./_merge"],function(e){"use strict";var r=function(){var r=[true,false];r.push.apply(r,arguments);return e.apply(null,r)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/Global", ["sap/ui/VersionInfo","sap/base/Log","sap/base/assert","sap/base/util/ObjectPath"],function(e,a,r,t){"use strict";if(globalThis.OpenAjax&&globalThis.OpenAjax.hub){OpenAjax.hub.registerLibrary("sap","http://www.sap.com/","0.1",{})}var n;let s={version:"1.136.0",buildinfo:{lastchange:"",buildtime:"20250513-1245"}};s=Object.assign(sap.ui,s);var o=sap.ui.loader._.getSyncCallBehavior();sap.ui.getVersionInfo=function(r){if(r&&r.async){a.info("Do not use deprecated function 'sap.ui.getVersionInfo'. Use"+" 'sap/ui/VersionInfo' module's asynchronous .load function instead")}else{a.warning("Do not use deprecated function 'sap.ui.getVersionInfo' synchronously! Use"+" 'sap/ui/VersionInfo' module's asynchronous .load function instead","Deprecation",null,function(){return{type:"sap.ui.getVersionInfo",name:"Global"}})}return e._load(r)};sap.ui.namespace=function(e){r(false,"sap.ui.namespace is long time deprecated and shouldn't be used");return t.create(e)};sap.ui.lazyRequire=function(e,s,i){r(typeof e==="string"&&e,"lazyRequire: sClassName must be a non-empty string");r(!s||typeof s==="string","lazyRequire: sMethods must be empty or a string");if(o===2){a.error("[nosync] lazy stub creation ignored for '"+e+"'");return}var u=e.replace(/\//gi,"."),l=u.lastIndexOf("."),c=u.substr(0,l),p=u.substr(l+1),f=t.create(c),y=f[p],d=(s||"new").split(" "),b=d.indexOf("new");i=i||u;if(!y){if(b>=0){y=function(){if(o){if(o===1){a.error("[nosync] lazy stub for constructor '"+u+"' called")}}else{a.debug("lazy stub for constructor '"+u+"' called.")}sap.ui.requireSync(i.replace(/\./g,"/"));var t=f[p];r(typeof t==="function","lazyRequire: oRealClass must be a function after loading");if(t._sapUiLazyLoader){throw new Error("lazyRequire: stub '"+u+"'has not been replaced by module '"+i+"'")}var s=Object.create(t.prototype);if(!(this instanceof y)){n=n||sap.ui.require("sap/ui/base/Object");if(n&&s instanceof n){a.error("Constructor "+e+' has been called without "new" operator!',null,null,function(){try{throw new Error}catch(e){return e}})}}var l=t.apply(s,arguments);if(l&&(typeof l==="function"||typeof l==="object")){s=l}return s};y._sapUiLazyLoader=true;d.splice(b,1)}else{y={}}f[p]=y}d.forEach(function(e){if(!y[e]){y[e]=function(){if(o){if(o===1){a.error("[no-sync] lazy stub for method '"+u+"."+e+"' called")}}else{a.debug("lazy stub for method '"+u+"."+e+"' called.")}sap.ui.requireSync(i.replace(/\./g,"/"));var t=f[p];r(typeof t==="function"||typeof t==="object","lazyRequire: oRealClass must be a function or object after loading");r(typeof t[e]==="function","lazyRequire: method must be a function");if(t[e]._sapUiLazyLoader){throw new Error("lazyRequire: stub '"+u+"."+e+"' has not been replaced by loaded module '"+i+"'")}return t[e].apply(t,arguments)};y[e]._sapUiLazyLoader=true}})};sap.ui.lazyRequire._isStub=function(e){r(typeof e==="string"&&e,"lazyRequire._isStub: sClassName must be a non-empty string");var a=e.lastIndexOf("."),n=e.slice(0,a),s=e.slice(a+1),o=t.get(n||"");return!!(o&&typeof o[s]==="function"&&o[s]._sapUiLazyLoader)};sap.ui.resource=function(e,a){r(typeof e==="string","sLibraryName must be a string");r(typeof a==="string","sResourcePath must be a string");return sap.ui.require.toUrl((String(e).replace(/\./g,"/")+"/"+a).replace(/^\/*/,""))};sap.ui.localResources=function(e){r(e,"sNamespace must not be empty");var a={};a[e.replace(/\./g,"/")]="./"+e.replace(/\./g,"/");sap.ui.loader.config({paths:a})};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/VersionInfo", ["sap/base/util/LoaderExtensions"],function(n){"use strict";let e;var r={get _content(){return e}};r.load=function(n){n=n||{};n.async=true;return r._load(n)};var i=null;var t;var a;function s(n){e=n;t=null;a=null}Object.defineProperty(sap.ui,"versioninfo",{configurable:true,enumerable:true,get:function(){return e},set:function(n){s(n)}});r._load=function(t){if(typeof t!=="object"){t={library:t}}t.async=t.async===true;t.failOnError=t.failOnError!==false;if(!e){if(t.async&&i instanceof Promise){return i.then(function(){return r._load(t)})}var a=function(n){i=null;if(n===null){return undefined}s(n);return r._load(t)};var o=function(n){i=null;throw n};var f=n.loadResource("sap-ui-version.json",{async:t.async,failOnError:t.async||t.failOnError});if(f instanceof Promise){i=f;return f.then(a,o)}else{return a(f)}}else{var l;if(typeof t.library!=="undefined"){var u=e.libraries;if(u){for(var c=0,d=u.length;c<d;c++){if(u[c].name===t.library){l=u[c];break}}}}else{l=e}return t.async?Promise.resolve(l):l}};function o(){if(e){if(e.libraries&&!t){t={};e.libraries.forEach(function(n,e){t[n.name]={};var r=n.manifestHints&&n.manifestHints.dependencies&&n.manifestHints.dependencies.libs;for(var i in r){if(!r[i].lazy){t[n.name][i]=true}}})}if(e.components&&!a){a={};Object.keys(e.components).forEach(function(n){var r=e.components[n];a[n]={library:r.library,hasOwnPreload:r.hasOwnPreload||false,dependencies:[]};var i=r.manifestHints&&r.manifestHints.dependencies&&r.manifestHints.dependencies.libs;for(var t in i){if(!i[t].lazy){a[n].dependencies.push(t)}}})}}}r._getTransitiveDependencyForLibraries=function(n){o();const e=Object.create(null);function r(n,r){if(e[n]==null){e[n]={name:n,...r&&{lazy:r}}}else{if(e[n].lazy&&!r){delete e[n].lazy}}}for(const{name:e,lazy:i}of n){r(e,i);if(t?.[e]){for(const n in t[e]){r(n,i)}}}return Object.values(e)};r._getTransitiveDependencyForComponent=function(n){o();if(a){return a[n]}};r._reset=function(){s()};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/BindingInfo", ["sap/base/config","sap/ui/base/DesignTime","sap/ui/core/getCompatibilityVersion","sap/ui/base/BindingParser","sap/ui/model/BindingMode","sap/base/Log"],function(e,t,r,a,n){"use strict";const i=Symbol("ui5object");const o=Symbol("OriginalParent");const s=Symbol("ModelNameExtracted");function p(e){if(!e[s]){const t=e.path.indexOf(">");if(t>0){e.model=e.path.substr(0,t);e.path=e.path.substr(t+1);e[s]=true}}return e}var d={createProperty:function(e){if(!e.parts){e.parts=[];e.parts[0]={path:e.path,targetType:e.targetType,type:e.type,suspended:e.suspended,formatOptions:e.formatOptions,constraints:e.constraints,model:e.model,mode:e.mode,value:e.value};delete e.path;delete e.targetType;delete e.mode;delete e.model;delete e.value}for(var t=0;t<e.parts.length;t++){var r=e.parts[t];if(typeof r=="string"){r={path:r};e.parts[t]=r}if(r.path!==undefined){p(r)}if(e.formatter&&r.mode!=n.OneWay&&r.mode!=n.OneTime){r.mode=n.OneWay}}e.skipPropertyUpdate=0;e.skipModelUpdate=0;return e},createAggregation:function(e,t){if(!(e.template||e.factory)){if(t){e.factory=function(){throw new Error("dummy factory called unexpectedly ")}}}else if(e.template){e.factory=function(t){const r=e.template.clone(t);r[o]=e[o];return r}}p(e);return e},createObject:function(e){p(e);return e},extract:function(e,t,r){var a;if(e&&typeof e==="object"){if(e.Type){a=undefined}else if(e[i]){delete e[i]}else if(e.ui5object){delete e.ui5object}else if(e.path!=undefined||e.parts||r&&e.value!=undefined){a=e}}if(typeof e==="string"){a=d.parse(e,t,true)}return a},escape:function(){return d.parse.escape.apply(this,arguments)},isReady:function(e,t){const r=e.parts;if(r){return e.parts.every(e=>e.value!==undefined||t.getModel(e.model))}else{return!!t.getModel(e.model)}},UI5ObjectMarker:i,OriginalParent:o};function u(){var t=e.get({name:"sapUiBindingSyntax",type:e.Type.String,defaultValue:"default",freeze:true});if(t==="default"){t=r("sapCoreBindingSyntax").compareTo("1.26")<0?"simple":"complex"}return t}Object.defineProperty(d,"parse",{get:function(){if(!this.oParser){this.oParser=a.complexParser;this.oParser=u()==="simple"?a.simpleParser:a.complexParser;if(t.isDesignModeEnabled()==true){a._keepBindingStrings=true}}return this.oParser},set:function(e){this.oParser=e}});return d});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/BindingParser", ["./ExpressionParser","sap/ui/model/BindingMode","sap/ui/model/Filter","sap/ui/model/Sorter","sap/base/future","sap/base/util/JSTokenizer","sap/base/util/resolveReference"],function(e,t,r,n,i,o,s){"use strict";var a={_keepBindingStrings:false};var f=/^\{\s*('|"|)[a-zA-Z$_][a-zA-Z0-9$_]*\1\s*:/;var u=/(\\[\\\{\}])|(\{)/g;var l=/([\\\{\}])/g;function c(e,t){var r=e.some(function(e){return e.requiresIContext});function n(n){var i,o=e.length,s=arguments,a=new Array(o);for(i=0;i<o;i+=1){if(e[i].requiresIContext){s=arguments}else if(r){s=Array.prototype.slice.call(arguments,1)}a[i]=e[i].apply(this,s)}if(t){return t.apply(this,a)}return o>1?a.join(" "):a[0]}if(r){n.requiresIContext=true}n.textFragments=t&&t.textFragments||"sap.ui.base.BindingParser: composeFormatters";return n}function p(e){var t=function(){var t=[],r=e.length,n;for(n=0;n<r;n++){if(typeof e[n]==="number"){t.push(arguments[e[n]])}else{t.push(e[n])}}return t.join("")};t.textFragments=e;return t}function d(e,t){var r=e.indexOf(">"),n={path:e};if(r>0){n.model=e.slice(0,r);n.path=e.slice(r+1)}if(t?.mLocals&&n.path.includes("@@")){n.parameters={scope:t.mLocals}}return n}function h(e,t){try{a.mergeParts(e)}catch(e){i.errorThrows(`sap.ui.base.BindingParser: Cannot merge parts for binding "${t}"`,{cause:e})}}const m=/(^(?:[$_\p{ID_Start}][$_\p{ID_Continue}]*\.)*[\p{ID_Start}][$_\p{ID_Continue}]*)\.bind\(([$_\p{ID_Start}][$_\p{ID_Continue}]*)\)$/u;function y(e,t){var o=Object.assign({".":e.oContext},e.mLocals);function a(t,r){if(typeof t[r]==="string"){let n=t[r];let a=false;let f=[],u={};if(r=="formatter"&&n.includes(".bind(")){f=n.match(m);if(!f){throw new Error(`Error in formatter '${n}': Either syntax error in the usage of '.bind(...)' or wrong number of arguments given. Only one argument is allowed when using '.bind()'.`)}if(f[2].startsWith("$")&&!Object.hasOwn(e.mAdditionalBindableValues,f[2])){throw new Error(`Error in formatter '${n}': The argument '${f[2]}' used in the '.bind()' call starts with '$', which is only allowed for framework-reserved variables. Please rename the variable so that it doesn't start with '$'.`)}a=true;u=Object.assign(u,e.mLocals,e.mAdditionalBindableValues);n=f[1]}t[r]=s(n,o,{preferDotContext:e.bPreferContext,bindContext:!a,bindDotContext:!e.bStaticContext});if(typeof t[r]!=="function"){if(e.bTolerateFunctionsNotFound){e.aFunctionsNotFound=e.aFunctionsNotFound||[];e.aFunctionsNotFound.push(n)}else{i.errorThrows(r+" function "+n+" not found!")}}if(a){if(!Object.hasOwn(u,f[2])){throw new Error(`Error in formatter '${n}': Unknown argument '${f[2]}' passed to '.bind()' call.`)}t[r]=u[f[2]]!==null?t[r].bind(u[f[2]]):t[r]}}}function f(t){var r;var n=t.type;if(typeof n==="string"){r=s(n,o,{bindContext:false,useProbingRequire:!e.aTypePromises});var a=function(e){if(typeof e==="function"){t.type=new e(t.formatOptions,t.constraints)}else{t.type=e}if(!t.type){i.errorThrows("Failed to resolve type '"+n+"'. Maybe not loaded or a typo?")}delete t.formatOptions;delete t.constraints};if(e.aTypePromises){var f;if(typeof r==="function"&&!r._sapUiLazyLoader||r&&typeof r==="object"){f=Promise.resolve(a(r))}else{f=new Promise(function(e,t){sap.ui.require([n.replace(/\./g,"/")],e,t)}).catch(function(e){i.errorThrows(e)}).then(a)}e.aTypePromises.push(f)}else{a(r)}}}function u(e){if(e!=null&&typeof e==="object"){for(var t in e){a(e,t)}}}function l(e,t){var n=e[t];if(Array.isArray(n)){n.forEach(function(e,t){l(n,t)});return}if(n&&typeof n==="object"){a(n,"test");l(n,"filters");l(n,"condition");e[t]=new r(n)}}function c(e,t){var r=e[t];if(Array.isArray(r)){r.forEach(function(e,t){c(r,t)});return}if(r&&typeof r==="object"){a(r,"group");a(r,"comparator");e[t]=new n(r)}}if(typeof t==="object"){if(Array.isArray(t.parts)){t.parts.forEach(function(t){y(e,t)})}f(t);l(t,"filters");c(t,"sorter");u(t.events);a(t,"formatter");a(t,"factory");a(t,"groupHeaderFactory");if(e.mLocals&&t.path?.includes("@@")&&t.parameters?.scope===undefined){t.parameters??={};t.parameters.scope=e.mLocals}}return t}function g(e,t,r){var n=o.parseJS,i,s;if(f.test(t.slice(r))){i=n(t,r);y(e,i.result);return i}s=t.indexOf("}",r);if(s<r){throw new SyntaxError("no closing braces found in '"+t+"' after pos:"+r)}return{result:d(t.slice(r+1,s),e),at:s+1}}a.simpleParser=function(e){var t=arguments[7];var r;if(e.startsWith("{")&&e.endsWith("}")){r=d(e.slice(1,-1))}if(t){return{bindingInfo:r,resolved:Promise.resolve()}}return r};a.simpleParser.escape=function(e){return e};a.complexParser=function(r,n,i,o,s,f,l,c,d){var m=false,y={parts:[]},b=false,x={oContext:n,mLocals:l,aFunctionsNotFound:undefined,bPreferContext:f,bStaticContext:s,bTolerateFunctionsNotFound:o,aTypePromises:c?[]:undefined,mAdditionalBindableValues:d},v=[],w,F=0,P,A;function C(t,i,o){var a=e.parse(g.bind(null,x),r,i,null,l||(s?n:null));function f(e,t){if(e.parts){e.parts.forEach(function(t,r){if(typeof t==="string"){t=e.parts[r]={path:t}}f(t,r)});m=m||t!==undefined}else{e.mode=o}}if(t.charAt(a.at)!=="}"){throw new SyntaxError("Expected '}' and instead saw '"+t.charAt(a.at)+"' in expression binding "+t+" at position "+a.at)}a.at+=1;if(a.result){f(a.result)}else{v[v.length-1]=String(a.constant);w=true}return a}u.lastIndex=0;while((P=u.exec(r))!==null){if(F<P.index){v.push(r.slice(F,P.index))}if(P[1]){v.push(P[1].slice(1));w=true}else{v.push(y.parts.length);if(r.indexOf(":=",P.index)===P.index+1){A=C(r,P.index+3,t.OneTime)}else if(r.charAt(P.index+1)==="="){A=C(r,P.index+2,t.OneWay)}else{A=g(x,r,P.index)}if(A.result){y.parts.push(A.result);b=b||"parts"in A.result}u.lastIndex=A.at}F=u.lastIndex}if(F<r.length){v.push(r.slice(F))}if(y.parts.length>0){if(v.length===1){y=y.parts[0];b=m}else{y.formatter=p(v)}if(b){h(y,r)}if(a._keepBindingStrings){y.bindingString=r}if(x.aFunctionsNotFound){y.functionsNotFound=x.aFunctionsNotFound}if(c){return{bindingInfo:y,resolved:Promise.all(x.aTypePromises),wait:x.aTypePromises.length>0}}return y}else if(i&&w){var E=v.join("");if(c){return{bindingInfo:E,resolved:Promise.resolve()}}return E}};a.complexParser.escape=function(e){return e.replace(l,"\\$1")};a.mergeParts=function(e){var t=[],r=[];e.parts.forEach(function(e){var n,i=function(){return e},o,s=r.length;function a(){return arguments[s]}if(e&&typeof e==="object"){if(e.parts){for(o in e){if(o!=="formatter"&&o!=="parts"){throw new Error("Unsupported property: "+o)}}r=r.concat(e.parts);n=r.length;if(e.formatter){if(e.formatter.requiresIContext===true){i=function(t){var r=Array.prototype.slice.call(arguments,s+1,n+1);r.unshift(t._slice(s,n));return e.formatter.apply(this,r)};i.requiresIContext=true}else{i=function(){return e.formatter.apply(this,Array.prototype.slice.call(arguments,s,n))}}}else if(n-s>1){i=function(){return Array.prototype.slice.call(arguments,s,n).join(" ")}}else{i=a}}else if("path"in e){r.push(e);i=a}}t.push(i)});e.parts=r;e.formatter=c(t,e.formatter)};a.parseExpression=function(t,r,n,i){n=n||{};if(i){n.mLocals=i}return e.parse(g.bind(null,n),t,r,i)};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/DesignTime", ["sap/base/config"],e=>{"use strict";const t={isDesignModeEnabled(){return e.get({name:"sapUiXxDesignMode",type:e.Type.Boolean,external:true,freeze:true})},isControllerCodeDeactivationSuppressed(){return e.get({name:"sapUiXxSuppressDeactivationOfControllerCode",type:e.Type.Boolean,external:true,freeze:true})},isControllerCodeDeactivated(){return t.isDesignModeEnabled()&&!t.isControllerCodeDeactivationSuppressed()}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/Event", ["./Object","sap/base/assert"],function(t,e){"use strict";var r=t.extend("sap.ui.base.Event",{constructor:function(e,r,n){t.apply(this);if(arguments.length>0){this.init(e,r,n)}}});r.prototype.init=function(r,n,s){e(typeof r==="string","Event.init: sId must be a string");e(t.isObjectA(n,"sap.ui.base.EventProvider"),"Event.init: oSource must be an EventProvider");this.sId=r;this.oSource=n;this.mParameters=s||{};this.bCancelBubble=false;this.bPreventDefault=false};r.prototype.reset=function(){this.sId="";this.oSource=null;this.mParameters=null;this.bCancelBubble=false;this.bPreventDefault=false};r.prototype.getId=function(){return this.sId};r.prototype.getSource=function(){return this.oSource};r.prototype.getParameters=function(){return this.mParameters};r.prototype.getParameter=function(t){e(typeof t==="string"&&t,"Event.getParameter: sName must be a non-empty string");return this.mParameters[t]};r.prototype.cancelBubble=function(){this.bCancelBubble=true};r.prototype.preventDefault=function(){this.bPreventDefault=true};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/EventProvider", ["./Event","./Object","sap/base/assert","sap/base/Log"],function(t,e,n,i){"use strict";var r=e.extend("sap.ui.base.EventProvider",{constructor:function(){e.call(this);this.mEventRegistry={}}});var o="EventHandlerChange";r.M_EVENTS={EventHandlerChange:o};r.prototype.attachEvent=function(t,e,i,r){var a=this.mEventRegistry;n(typeof t==="string"&&t,"EventProvider.attachEvent: sEventId must be a non-empty string");if(typeof e==="function"){r=i;i=e;e=undefined}n(typeof i==="function","EventProvider.attachEvent: fnFunction must be a function");n(!r||typeof r==="object","EventProvider.attachEvent: oListener must be empty or an object");r=r===this?undefined:r;var s=a[t];if(!Array.isArray(s)){s=a[t]=[]}s.push({oListener:r,fFunction:i,oData:e});if(a[o]){this.fireEvent(o,{EventId:t,type:"listenerAttached",listener:r,func:i,data:e})}return this};r.prototype.attachEventOnce=function(t,e,i,r){if(typeof e==="function"){r=i;i=e;e=undefined}n(typeof i==="function","EventProvider.attachEventOnce: fnFunction must be a function");var o=function(){this.detachEvent(t,o);i.apply(r||this,arguments)};o.oOriginal={fFunction:i,oListener:r,oData:e};this.attachEvent(t,e,o,undefined);return this};r.prototype.detachEvent=function(t,e,i){var r=this.mEventRegistry;n(typeof t==="string"&&t,"EventProvider.detachEvent: sEventId must be a non-empty string");n(typeof e==="function","EventProvider.detachEvent: fnFunction must be a function");n(!i||typeof i==="object","EventProvider.detachEvent: oListener must be empty or an object");var a=r[t];if(!Array.isArray(a)){return this}var s,f;i=i===this?undefined:i;for(var v=0,u=a.length;v<u;v++){if(a[v].fFunction===e&&a[v].oListener===i){s=a[v];a.splice(v,1);break}}if(!s){for(var v=0,u=a.length;v<u;v++){f=a[v].fFunction.oOriginal;if(f&&f.fFunction===e&&f.oListener===i){s=f;a.splice(v,1);break}}}if(a.length==0){delete r[t]}if(s&&r[o]){this.fireEvent(o,{EventId:t,type:"listenerDetached",listener:s.oListener,func:s.fFunction,data:s.oData})}return this};r.prototype.fireEvent=function(e,n,r,o){if(typeof n==="boolean"){o=r;r=n}var a=this,s=false,f,v,u,c,h;do{f=a.mEventRegistry[e];if(Array.isArray(f)){f=f.slice();v=new t(e,this,n);for(u=0,c=f.length;u<c;u++){h=f[u];const t=h.fFunction.call(h.oListener||a,v,h.oData);if(typeof t?.then==="function"){t.catch?.(t=>{i.error(`EventProvider.fireEvent: Event Listener for event '${e}' failed during execution.`,t)})}}o=o&&!v.bCancelBubble}a=a.getEventingParent()}while(o&&a);if(v){s=v.bPreventDefault}return r?!s:this};r.prototype.hasListeners=function(t){return!!this.mEventRegistry[t]};r.getEventList=function(t){return t.mEventRegistry};r.hasListener=function(t,e,i,r){n(typeof e==="string"&&e,"EventProvider.hasListener: sEventId must be a non-empty string");n(typeof i==="function","EventProvider.hasListener: fnFunction must be a function");n(!r||typeof r==="object","EventProvider.hasListener: oListener must be empty or an object");var o=t&&t.mEventRegistry[e];if(o){for(var a=0,s=o.length;a<s;a++){if(o[a].fFunction===i&&o[a].oListener===r){return true}}}return false};r.prototype.getEventingParent=function(){return null};r.prototype.toString=function(){if(this.getMetadata){return"EventProvider "+this.getMetadata().getName()}else{return"EventProvider"}};r.prototype.destroy=function(){this.mEventRegistry={};e.prototype.destroy.apply(this,arguments)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/ExpressionParser", ["sap/base/Log","sap/base/strings/escapeRegExp","sap/base/util/deepEqual","sap/base/util/JSTokenizer","sap/ui/performance/Measurement","sap/ui/thirdparty/URI"],function(e,n,t,r,i,u){"use strict";
//License granted by Douglas Crockford to SAP, Apache License 2.0
//    (http://www.apache.org/licenses/LICENSE-2.0)
var a=I.bind(null,undefined),s={Array:Array,Boolean:Boolean,Date:Date,encodeURIComponent:encodeURIComponent,Infinity:Infinity,isFinite:isFinite,isNaN:isNaN,JSON:JSON,Math:Math,NaN:NaN,Number:Number,Object:Object,odata:{collection:function(e){return e.filter(function(e){return e!==undefined})},compare:function(){var e=sap.ui.require("sap/ui/model/odata/v4/ODataUtils");if(!e){e=sap.ui.requireSync("sap/ui/model/odata/v4/ODataUtils")}if(!e){throw new TypeError("Expression uses 'odata.compare' which requires to"+" import 'sap/ui/model/odata/v4/ODataUtils' in advance")}return e.compare.apply(e,arguments)},fillUriTemplate:function(e,n){if(!u.expand){sap.ui.requireSync("sap/ui/thirdparty/URITemplate")}if(!u.expand){throw new TypeError("Expression uses 'odata.fillUriTemplate' which requires"+" to import 'sap/ui/thirdparty/URITemplate' in advance")}return u.expand(e.trim(),n).toString()},uriEncode:function(){var e=sap.ui.require("sap/ui/model/odata/ODataUtils");if(!e){e=sap.ui.requireSync("sap/ui/model/odata/ODataUtils")}if(!e){throw new TypeError("Expression uses 'odata.uriEncode' which requires to"+" import 'sap/ui/model/odata/ODataUtils' in advance")}return e.formatValue.apply(e,arguments)}},parseFloat:parseFloat,parseInt:parseInt,RegExp:RegExp,String:String,undefined:undefined},o=/\d/,l="sap.ui.base.ExpressionParser",d=/[a-z_$][a-z0-9_$]*/i,c=/[a-z_$]/i,f=[l],p=l+"#parse",v={BINDING:{led:D,nud:function(e,n){return g.bind(null,e.value)}},ERROR:{lbp:Infinity,led:function(e,n,t){U(e.value.message,e.value.text,e.value.at)},nud:function(e,n){U(e.value.message,e.value.text,e.value.at)}},IDENTIFIER:{led:D,nud:function(n,t){if(!(n.value in t.globals)){e.warning("Unsupported global identifier '"+n.value+"' in expression parser input '"+t.input+"'",undefined,l)}return I.bind(null,t.globals[n.value])}},CONSTANT:{led:D,nud:function(e,n){return I.bind(null,e.value)}},".":{lbp:18,led:function(e,n,t){return E.bind(null,t,n.advance("IDENTIFIER").value)},nud:D},"(":{lbp:17,led:function(e,n,t){var r=[],i=true;while(n.current().id!==")"){if(i){i=false}else{n.advance(",")}r.push(n.expression(0))}n.advance(")");return y.bind(null,t,r)},nud:function(e,n){var t=n.expression(0);n.advance(")");return t}},"[":{lbp:18,led:function(e,n,t){var r=n.expression(0);n.advance("]");return T.bind(null,t,r)},nud:function(e,n){var t=[],r=true;while(n.current().id!=="]"){if(r){r=false}else{n.advance(",")}t.push(n.current().id===","?a:n.expression(0))}n.advance("]");return x.bind(null,t)}},"!":{lbp:15,led:D,nud:function(e,n){return R.bind(null,n.expression(this.lbp),function(e){return!e})}},typeof:{lbp:15,led:D,nud:function(e,n){return R.bind(null,n.expression(this.lbp),function(e){return typeof e})}},"?":{lbp:4,led:function(e,n,t){var r,i;i=n.expression(this.lbp-1);n.advance(":");r=n.expression(this.lbp-1);return m.bind(null,t,i,r)},nud:D},")":{led:D,nud:D},"]":{led:D,nud:D},"{":{led:D,nud:function(e,n){var t=true,r,i={},u;while(n.current().id!=="}"){if(t){t=false}else{n.advance(",")}if(n.current()&&n.current().id==="CONSTANT"&&typeof n.current().value==="string"){r=n.advance().value}else{r=n.advance("IDENTIFIER").value}n.advance(":");u=n.expression(0);i[r]=u}n.advance("}");return w.bind(null,i)}},"}":{lbp:-1,led:D,nud:D},",":{led:D,nud:D},":":{led:D,nud:D}},b=["===","!==","!","||","&&",".","(",")","{","}",":",",","?","*","/","%","+","-","<=","<",">=",">","[","]"],h;b.forEach(function(e,t){b[t]=n(e)});h=new RegExp(b.join("|"),"g");O("*",14,function(e,n){return e*n});O("/",14,function(e,n){return e/n});O("%",14,function(e,n){return e%n});O("+",13,function(e,n){return e+n}).nud=function(e,n){return R.bind(null,n.expression(this.lbp),function(e){return+e})};O("-",13,function(e,n){return e-n}).nud=function(e,n){return R.bind(null,n.expression(this.lbp),function(e){return-e})};O("<=",11,function(e,n){return e<=n});O("<",11,function(e,n){return e<n});O(">=",11,function(e,n){return e>=n});O(">",11,function(e,n){return e>n});O("in",11,function(e,n){return e in n});O("===",10,function(e,n){return e===n});O("!==",10,function(e,n){return e!==n});O("&&",7,function(e,n){return e&&n()},true);O("||",6,function(e,n){return e||n()},true);function x(e,n){return e.map(function(e){return e(n)})}function g(e,n){return S(n[e])}function m(e,n,t,r){return e(r)?n(r):t(r)}function I(e){return e}function E(e,n,t,r){var i=e(t),u=i[n];if(r){r.base=i}return S(u)}function y(e,n,t){var r={};return S(e(t,r).apply(r.base,n.map(function(e){return e(t)})))}function N(e,n,t,r,i){return t(e(i),r?n.bind(null,i):n(i))}function w(e,n){var t,r={};for(t in e){r[t]=e[t](n)}return r}function T(e,n,t,r){var i=e(t),u=n(t),a=i[u];if(r){r.base=i}return S(a)}function R(e,n,t){return n(e(t))}function O(e,n,t,r){v[e]={lbp:n,led:function(e,n,i){var u=r?this.lbp-1:this.lbp;return N.bind(null,i,n.expression(u),t,r)},nud:D};return v[e]}function S(e){return e===Function?undefined:e}function U(n,t,r){var i=new SyntaxError(n);i.at=r;i.text=t;if(r!==undefined){n+=" at position "+r}e.error(n,t,l);throw i}function D(e){U("Unexpected "+e.id,e.input,e.start+1)}function F(e,n,i){var u=[],a=[],s=[],l=new r;function f(e,i,s){var o=false,l,d,c;function f(e){if(s){if(e.parts){e.parts.forEach(f)}else{e.targetType=e.targetType||"any"}}}for(l in e){if(l==="parameters"){continue}switch(typeof e[l]){case"boolean":case"number":case"string":case"undefined":break;default:o=true}}f(e);if(o){d=r.parseJS(n,i).result;f(d)}else{d=e}for(c=0;c<u.length;c+=1){if(t(a[c],d)){return c}}a[c]=d;u[c]=e;return c}function p(){var t,r,i,u,a;l.white();t=l.getCh();i=l.getIndex();if((t==="$"||t==="%")&&n[i+1]==="{"){r=e(n,i+1);a={id:"BINDING",value:f(r.result,i+1,t==="%")};l.setIndex(r.at)}else if(c.test(t)){u=d.exec(n.slice(i));switch(u[0]){case"false":case"null":case"true":a={id:"CONSTANT",value:l.word()};break;case"in":case"typeof":a={id:u[0]};l.setIndex(i+u[0].length);break;default:a={id:"IDENTIFIER",value:u[0]};l.setIndex(i+u[0].length)}}else if(o.test(t)||t==="."&&o.test(n[i+1])){a={id:"CONSTANT",value:l.number()}}else if(t==="'"||t==='"'){a={id:"CONSTANT",value:l.string()}}else{h.lastIndex=i;u=h.exec(n);if(!u||u.index!==i){return false}a={id:u[0]};l.setIndex(i+u[0].length)}a.input=n;a.start=i;a.end=l.getIndex();s.push(a);return true}l.init(n,i);try{while(p()){}}catch(e){if(e.name==="SyntaxError"){s.push({id:"ERROR",value:e})}else{throw e}}return{at:l.getIndex(),parts:u,tokens:s}}function q(n,t){return function(){try{return n.apply(this,arguments)}catch(n){e.warning(String(n),t,l)}}}function C(e,n,t){var r,i=0,u={advance:s,current:o,expression:l,globals:t,input:n},a;function s(t){var r=e[i];if(t){if(!r){U("Expected "+t+" but instead saw end of input",n)}else if(r.id!==t){U("Expected "+t+" but instead saw "+n.slice(r.start,r.end),n,r.start+1)}}i+=1;return r}function o(){return e[i]}function l(t){var r;a=s();if(!a){U("Expected expression but instead saw end of input",n)}r=v[a.id].nud(a,u);while(i<e.length){a=o();if(t>=(v[a.id].lbp||0)){break}s();r=v[a.id].led(a,u,r)}return r}r=l(0);return{at:o()&&o().start,formatter:q(r,n)}}return{parse:function(e,n,t,r,u){var a,o;i.average(p,"",f);o=F(e,n,t);r=r||s;if(u){r=Object.assign({},r,u)}a=C(o.tokens,n,r);i.end(p);if(!o.parts.length){return{constant:a.formatter(),at:a.at||o.at}}function l(){return a.formatter(arguments)}l.textFragments=true;return{result:{formatter:l,parts:o.parts},at:a.at||o.at}}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/ManagedObject", ["./DataType","./EventProvider","./ManagedObjectMetadata","./Object","./BindingInfo","sap/ui/util/ActivityDetection","sap/ui/util/_enforceNoReturnValue","sap/base/future","sap/base/util/ObjectPath","sap/base/Log","sap/base/assert","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/uid","sap/base/util/extend","sap/base/util/isEmptyObject"],function(t,e,i,n,r,s,o,a,g,p,f,d,h,l,u,c){"use strict";const y=t.getType("sap.ui.core.ID");const b=Symbol("bindingInfoFactory");var m=e.extend("sap.ui.base.ManagedObject",{metadata:{abstract:true,publicMethods:["getId","getMetadata","getModel","setModel","hasModel","bindProperty","unbindProperty","bindAggregation","unbindAggregation","bindObject","unbindObject","getObjectBinding"],library:"sap.ui.core",properties:{},aggregations:{},associations:{},events:{validationSuccess:{enableEventBubbling:true,parameters:{element:{type:"sap.ui.base.ManagedObject"},property:{type:"string"},type:{type:"sap.ui.model.Type"},newValue:{type:"any"},oldValue:{type:"any"}}},validationError:{enableEventBubbling:true,parameters:{element:{type:"sap.ui.base.ManagedObject"},property:{type:"string"},type:{type:"sap.ui.model.Type"},newValue:{type:"any"},oldValue:{type:"any"},message:{type:"string"}}},parseError:{enableEventBubbling:true,parameters:{element:{type:"sap.ui.base.ManagedObject"},property:{type:"string"},type:{type:"sap.ui.model.Type"},newValue:{type:"any"},oldValue:{type:"any"},message:{type:"string"}}},formatError:{enableEventBubbling:true,parameters:{element:{type:"sap.ui.base.ManagedObject"},property:{type:"string"},type:{type:"sap.ui.model.Type"},newValue:{type:"any"},oldValue:{type:"any"}}},modelContextChange:{}},specialSettings:{id:"sap.ui.core.ID",models:"object",bindingContexts:"object",objectBindings:"object",metadataContexts:"object",Type:{type:"string",visibility:"hidden"}}},constructor:function(t,i,n){e.call(this);const r=this;if(typeof t!=="string"&&t!==undefined){n=i;i=t;t=i&&i.id}if(!t){t=this.getMetadata().uid()}else{t=_?_.call(this,t):t;if(!y.isValid(t)){throw new Error(`"${t}" is not a valid ID.`)}}this.sId=t;this.mProperties=this.getMetadata().createPropertyBag();this.mAggregations={};this.mAssociations={};this.oParent=null;this.aDelegates=[];this.aBeforeDelegates=[];this.iSuppressInvalidate=0;this.oPropagatedProperties=j;this.mSkipPropagation={};this._bIsOwnerActive=true;this.oModels={};this.aPropagationListeners=[];this.oBindingContexts={};this.mElementBindingContexts={};this.mBindingInfos={};this.mObjectBindingInfos={};this._oContextualSettings=S;this._sOwnerId=m._sOwnerId;(function(){var t=false;if(r.register){r.register()}try{if(r._initCompositeSupport){r._initCompositeSupport(i)}if(r.init){o(r.init(),{name:"init",component:r.getId()})}r.applySettings(i,n);t=true}finally{if(!t&&r.deregister){r.deregister()}}})()}},i);Object.defineProperty(m,"bindingParser",{set:function(t){r.parse=t},get:function(){return r.parse}});function v(t){f(t===undefined||typeof t==="string"&&!/^(undefined|null)?$/.test(t),"sModelName must be a string or omitted")}var P=false;function A(t){if(!P){var e=Object.values(t)[0];if(e&&e.mixinBindingSupport){e.mixinBindingSupport(m.prototype);P=true}}}function I(t,e,i){if(!t||t instanceof m||typeof t!=="object"||t instanceof String){return t}function n(t){if(typeof t==="function"){return t}if(typeof t==="string"){const e=g.get(t);if(e!=null){p.error(`Defining the object type ('${t}') via its string name is deprecated, since it leads to accesses to the global namespace. `+`The object type either stems from an explicitly given 'Type' value or was inferred from the default aggregation type. `+`Please require the respective object type module beforehand. `+`For control development, please also refer to the runtime metadata property 'defaultClass', which allows you to specify a default aggregation class type via constructor reference.`)}return e}}let r;r=n(t.Type);r??=e?.defaultClass;r??=n(e?.type);if(typeof r==="function"){return new r(t,i)}var s="Don't know how to create a ManagedObject from "+t+" ("+typeof t+")";p.fatal(s);throw new Error(s)}m.create=I;let _=null;let B=null;m.runWithPreprocessors=function(t,e,i){f(typeof t==="function","fn must be a function");f(!e||typeof e==="object","oPreprocessors must be an object");const n=[_,B];_=e?.id;B=e?.settings;try{return t.call(i)}finally{[_,B]=n}};m.runWithOwner=function(t,e,i){f(typeof t==="function","fn must be a function");var n=m._sOwnerId;try{m._sOwnerId=e;return t.call(i)}finally{m._sOwnerId=n}};m.prototype.applySettings=function(e,i){if(!e||c(e)){return this}var r=this,s=this.getMetadata(),o=s.getJSONKeys(),g,p,d;function h(t){for(var e=0,n=t.length;e<n;e++){var s=t[e];if(Array.isArray(s)){h(s)}else{r[d._sMutator](I(s,d,i))}}}function l(t){r[d._sMutator](t[0],t[1],t[2])}function u(e){var i=t.getType(e),n=i&&i.getPrimitiveType().getName();return n==="object"||n==="any"}B?.call(this,e);if(e.metadataContexts&&this._processMetadataContexts){this._processMetadataContexts(e.metadataContexts,e)}if(e.models){if(typeof e.models!=="object"){throw new Error("models must be a simple object")}if(n.isObjectA(e.models,"sap.ui.model.Model")){this.setModel(e.models)}else{for(g in e.models){this.setModel(e.models[g],g==="undefined"?undefined:g)}}}if(e.bindingContexts){if(typeof e.bindingContexts!=="object"){throw new Error("bindingContexts must be a simple object")}var y=e.bindingContexts;if(n.isObjectA(y,"sap.ui.model.Context")){this.setBindingContext(e.bindingContexts)}else{for(g in e.bindingContexts){this.setBindingContext(e.bindingContexts[g],g==="undefined"?undefined:g)}}}if(e.objectBindings){if(typeof e.objectBindings!=="string"&&typeof e.objectBindings!=="object"){throw new Error("binding must be a string or simple object")}if(typeof e.objectBindings==="string"||e.objectBindings.path){this.bindObject(e.objectBindings)}else{for(g in e.objectBindings){e.objectBindings[g].model=g==="undefined"?undefined:g;this.bindObject(e.objectBindings[g])}}}for(g in e){p=e[g];if((d=o[g])!==undefined){var b;switch(d._iKind){case 0:b=this.extractBindingInfo(p,i,!u(d.type));if(b&&typeof b==="object"){this.bindProperty(g,b)}else{this[d._sMutator](typeof b==="string"?b:p)}break;case 1:b=d.altTypes&&this.extractBindingInfo(p,i,!d.altTypes.some(u));if(b&&typeof b==="object"){this.bindProperty(g,b)}else{if(Array.isArray(p)){if(p.length>1){a.errorThrows("Tried to add an array of controls to a single aggregation")}p=p[0]}this[d._sMutator](I(typeof b==="string"?b:p,d,i))}break;case 2:b=this.extractBindingInfo(p,i);if(b&&typeof b==="object"){this.bindAggregation(g,b)}else{p=typeof b==="string"?b:p;if(p){if(Array.isArray(p)){h(p)}else{r[d._sMutator](I(p,d,i))}}}break;case 3:this[d._sMutator](p);break;case 4:if(p){if(Array.isArray(p)){for(var m=0,v=p.length;m<v;m++){this[d._sMutator](p[m])}}else{this[d._sMutator](p)}}break;case 5:if(typeof p=="function"){this[d._sMutator](p)}else if(Array.isArray(p[0])&&(p.length<=1||Array.isArray(p[1]))){p.forEach(l)}else{l(p)}break;case-1:break;default:break}}else{f(false,"ManagedObject.apply: encountered unknown setting '"+g+"' for class '"+s.getName()+"' (value:'"+p+"')")}}return this};m.escapeSettingsValue=function(t){return typeof t==="string"?r.escape(t):t};m.prototype.toString=function(){return"ManagedObject "+this.getMetadata().getName()+"#"+this.getId()};m.prototype.getId=function(){return this.sId};m.prototype.setProperty=function(t,i,n){var r=this.mProperties[t];i=this.validateProperty(t,i);if(h(r,i)){this.mProperties[t]=i;return this}if(n){s.refresh()}this.mProperties[t]=i;if(!n&&!this.isInvalidateSuppressed()){this.invalidate()}this.updateModelProperty(t,i,r);i=this.mProperties[t];if(this.mEventRegistry["_change"]){e.prototype.fireEvent.call(this,"_change",{id:this.getId(),name:t,oldValue:r,newValue:i})}if(this._observer){this._observer.propertyChange(this,t,r,i)}return this};m.prototype.getProperty=function(e){var i=this.mProperties[e],n=this.getMetadata().getManagedProperty(e),r;if(!n){throw new Error('Property "'+e+'" does not exist in '+this)}r=t.getType(n.type);if(r instanceof t&&r.isArrayType()&&Array.isArray(i)){i=i.slice(0)}if(i instanceof String){i=i.valueOf()}if(n.byValue){i=d(i)}return i};m.prototype.validateProperty=function(e,i){var n=this.getMetadata().getManagedProperty(e),r;if(!n){throw new Error('Property "'+e+'" does not exist in '+this)}r=t.getType(n.type);if(r instanceof t&&r.isArrayType()&&Array.isArray(i)){i=i.slice(0)}if(i==null){i=n.getDefaultValue()}else if(r instanceof t){if(r.getName()=="string"){if(!(typeof i=="string"||i instanceof String)){i=""+i}}else if(r.getName()=="string[]"){if(typeof i=="string"){i=[i]}if(!Array.isArray(i)){throw new Error('"'+i+'" is of type '+typeof i+", expected string[]"+' for property "'+e+'" of '+this)}for(var s=0;s<i.length;s++){if(typeof i[s]!=="string"){i[s]=""+i[s]}}}else if(!r.isValid(i)){throw new Error('"'+i+'" is of type '+typeof i+", expected "+r.getName()+' for property "'+e+'" of '+this)}}if(n.byValue){i=d(i)}if(r&&r.normalize&&typeof r.normalize==="function"){i=r.normalize(i)}return i};m.prototype.isPropertyInitial=function(t){return!Object.hasOwn(this.mProperties,t)&&!this.isBound(t)};m.prototype.resetProperty=function(t){if(this.mProperties.hasOwnProperty(t)){var e=this.getMetadata().getManagedProperty(t);e.set(this,null);if(this.mProperties[t]===e.getDefaultValue()){delete this.mProperties[t]}}return this};m.prototype.getOriginInfo=function(t){var e=this.mProperties[t];if(!(e instanceof String&&e.originInfo)){return null}return e.originInfo};m.prototype.setAssociation=function(t,e,i){if(e instanceof m){e=e.getId()}else if(e!=null&&typeof e!=="string"){f(false,"setAssociation(): sId must be a string, an instance of sap.ui.base.ManagedObject or null");return this}if(this.mAssociations[t]===e){return this}if(i){this.iSuppressInvalidate++}if(this._observer&&this.mAssociations[t]!=null){this._observer.associationChange(this,t,"remove",this.mAssociations[t])}this.mAssociations[t]=e;if(this._observer&&this.mAssociations[t]!=null){this._observer.associationChange(this,t,"insert",e)}if(!this.isInvalidateSuppressed()){this.invalidate()}if(i){this.iSuppressInvalidate--}return this};m.prototype.getAssociation=function(t,e){var i=this.mAssociations[t];if(!i){i=this.mAssociations[t]=e||null}else{if(typeof i.length==="number"&&!i.propertyIsEnumerable("length")){return i.slice()}return i}return i};m.prototype.addAssociation=function(t,e,i){if(e instanceof m){e=e.getId()}else if(typeof e!=="string"){f(false,"addAssociation(): sId must be a string or an instance of sap.ui.base.ManagedObject");return this}if(i){this.iSuppressInvalidate++}var n=this.mAssociations[t];if(!n){n=this.mAssociations[t]=[e]}else{n.push(e)}if(this._observer){this._observer.associationChange(this,t,"insert",e)}if(!this.isInvalidateSuppressed()){this.invalidate()}if(i){this.iSuppressInvalidate--}return this};m.prototype.removeAssociation=function(t,e,i){var n=this.mAssociations[t];var r=null;if(!n){return null}if(i){this.iSuppressInvalidate++}if(typeof e=="object"&&e.getId){e=e.getId()}if(typeof e=="string"){for(var s=0;s<n.length;s++){if(n[s]==e){e=s;break}}}if(typeof e=="number"){if(e>=0&&e<n.length){r=n[e];n.splice(e,1);if(this._observer){this._observer.associationChange(this,t,"remove",r)}if(!this.isInvalidateSuppressed()){this.invalidate()}}}if(i){this.iSuppressInvalidate--}return r};m.prototype.removeAllAssociation=function(t,e){var i=this.mAssociations[t];if(!i){return[]}delete this.mAssociations[t];if(!i.length){return i}if(e){this.iSuppressInvalidate++}if(this._observer){this._observer.associationChange(this,t,"remove",i)}if(!this.isInvalidateSuppressed()){this.invalidate()}if(e){this.iSuppressInvalidate--}return i};m.prototype.validateAggregation=function(e,i,r,s){var o=this.getMetadata(),a=o.getManagedAggregation(e),p,d,h,l;if(!a){throw new Error('Aggregation "'+e+'" does not exist in '+this)}if(a.multiple!==r){throw new Error("Aggregation '"+e+"' of "+this+" used with wrong cardinality (declared as "+(a.multiple?"0..n":"0..1")+")")}var u=o.getAggregationForwarder(e);if(u&&!s){u.getTarget(this).validateAggregation(u.targetAggregationName,i,r)}if(!a.multiple&&!i){return i}if(n.isObjectA(i,a.type)){return i}p=a.altTypes;if(p&&p.length){if(i==null){return i}for(h=0;h<p.length;h++){d=t.getType(p[h]);if(d instanceof t){if(d.isValid(i)){return i}}}}if((()=>{d=g.get(a.type);if(typeof d==="function"&&i instanceof d){return true}return false})()){return i}l='"'+i+'" is not valid for aggregation "'+e+'" of '+this;if(t.isInterfaceType(a.type)){f(false,l);return i}else{throw new Error(l)}};m.prototype.setAggregation=function(t,e,i){var n=this.getMetadata().getAggregationForwarder(t);if(n){e=this.validateAggregation(t,e,false,true);return n.set(this,e)}var r=this.mAggregations[t];if(r===e){return this}e=this.validateAggregation(t,e,false);if(i){this.iSuppressInvalidate++}this.mAggregations[t]=null;if(r instanceof m){r.setParent(null)}else{if(this._observer!=null&&r!=null){this._observer.aggregationChange(this,t,"remove",r)}}this.mAggregations[t]=e;if(e instanceof m){e.setParent(this,t,i)}else{if(!this.isInvalidateSuppressed()){this.invalidate()}if(this._observer!=null&&e!=null){this._observer.aggregationChange(this,t,"insert",e)}}if(i){this.iSuppressInvalidate--}return this};m.prototype.getAggregation=function(t,e){var i=this.getMetadata().getAggregationForwarder(t);if(i){return i.get(this)}var n=this.mAggregations[t];if(!n){n=this.mAggregations[t]=e||null}if(n){if(typeof n.length==="number"&&!n.propertyIsEnumerable("length")){return n.slice()}return n}else{return null}};m.prototype.indexOfAggregation=function(t,e){var i=this.getMetadata().getAggregationForwarder(t);if(i){return i.indexOf(this,e)}var n=this.mAggregations[t];if(n){if(n.length==undefined){return-2}for(var r=0;r<n.length;r++){if(n[r]==e){return r}}}return-1};m.prototype.insertAggregation=function(t,e,i,n){if(!e){return this}e=this.validateAggregation(t,e,true,true);var r=this.getMetadata().getAggregationForwarder(t);if(r){return r.insert(this,e,i)}var s=this.mAggregations[t]||(this.mAggregations[t]=[]);var o;if(i<0){o=0}else if(i>s.length){o=s.length}else{o=i}s.splice(o,0,e);e.setParent(this,t,n);return this};m.prototype.addAggregation=function(t,e,i){if(!e){return this}e=this.validateAggregation(t,e,true,true);var n=this.getMetadata().getAggregationForwarder(t);if(n){return n.add(this,e)}var r=this.mAggregations[t];if(!r){r=this.mAggregations[t]=[e]}else{r.push(e)}e.setParent(this,t,i);return this};m.prototype.removeAggregation=function(t,e,i){var n=this.getMetadata().getAggregationForwarder(t);if(n){return n.remove(this,e)}var r=this.mAggregations[t],s=null,o;if(!r){return null}if(i){this.iSuppressInvalidate++}if(typeof e=="string"){for(o=0;o<r.length;o++){if(r[o]&&r[o].getId()===e){e=o;break}}}if(typeof e=="object"){for(o=0;o<r.length;o++){if(r[o]==e){e=o;break}}}if(typeof e=="number"){if(e>=0&&e<r.length){s=r[e];r.splice(e,1);s.setParent(null);if(!this.isInvalidateSuppressed()){this.invalidate()}}}if(i){this.iSuppressInvalidate--}return s};m.prototype.removeAllAggregation=function(t,e){var i=this.getMetadata().getAggregationForwarder(t);if(i){return i.removeAll(this)}var n=this.mAggregations[t];if(!n){return[]}delete this.mAggregations[t];if(!n.length){return n}if(e){this.iSuppressInvalidate++}for(var r=0;r<n.length;r++){n[r].setParent(null)}if(!this.isInvalidateSuppressed()){this.invalidate()}if(e){this.iSuppressInvalidate--}return n};m.prototype.destroyAggregation=function(t,e){var i=this.getMetadata().getAggregationForwarder(t);if(i){return i.destroy(this)}var n=this.mAggregations[t],r,s;if(!n){return this}delete this.mAggregations[t];if(Array.isArray(n)&&!n.length){return this}if(e){this.iSuppressInvalidate++}if(n instanceof m){n.destroy(e);if(this._observer){this._observer.aggregationChange(this,t,"remove",n)}}else if(Array.isArray(n)){for(r=n.length-1;r>=0;r--){s=n[r];if(s){s.destroy(e);if(this._observer){this._observer.aggregationChange(this,t,"remove",s)}}}}if(!this.isInvalidateSuppressed()){this.invalidate()}if(e){this.iSuppressInvalidate--}return this};m.prototype.invalidate=function(){if(this.oParent&&this.oParent.isInvalidateSuppressed&&!this.oParent.isInvalidateSuppressed()){this.oParent.invalidate(this)}};m.prototype.isInvalidateSuppressed=function(){return this.iSuppressInvalidate>0};m.prototype._removeChild=function(t,e,i){if(!e){a.errorThrows(`${this}: Cannot remove aggregated child without aggregation name.`)}else{if(i){this.iSuppressInvalidate++}var n=this.indexOfAggregation(e,t);var r=this.getMetadata().getAggregation(e);if(n==-2){if(r&&this[r._sMutator]){this[r._sMutator](null)}else{this.setAggregation(e,null,i)}}else if(n>-1){if(r&&this[r._sRemoveMutator]){this[r._sRemoveMutator](n)}else{this.removeAggregation(e,n,i)}}if(i){this.iSuppressInvalidate--}}};function C(t,e){while(t&&t!==e){t=t.oParent}return!!t}m.prototype.setParent=function(t,e,i){f(t==null||t instanceof m,"oParent either must be null, undefined or a ManagedObject");var n;if(!t){if(this.oParent){n=this._observer||this.oParent._observer;if(n){n.parentChange(this,this.sParentAggregationName,"unset",this.oParent)}if(this.aAPIParentInfos&&this.aAPIParentInfos.forwardingCounter===0){delete this.aAPIParentInfos}}this.oParent=null;this.sParentAggregationName=null;var r=j;if(r!==this.oPropagatedProperties){this.oPropagatedProperties=r;if(!this._bIsBeingDestroyed){Promise.resolve().then(function(){if(!this.oParent){this.updateBindings(true,null);this.updateBindingContext(false,undefined,true);this.propagateProperties(true);this.fireModelContextChange()}}.bind(this))}}this._oContextualSettings=S;if(!this._bIsBeingDestroyed){Promise.resolve().then(function(){if(!this.oParent){this._propagateContextualSettings()}}.bind(this))}s.refresh();return}if(C(t,this)){throw new Error("Cycle detected: new parent '"+t+"' is already a descendant of (or equal to) '"+this+"'")}if(i){s.refresh();t.iSuppressInvalidate++}var o=this.getParent();if(o){o._removeChild(this,this.sParentAggregationName)}this.oParent=t;this.sParentAggregationName=e;if(!t.mSkipPropagation[e]){var r=this.aAPIParentInfos?this.aAPIParentInfos[0].parent._getPropertiesToPropagate():t._getPropertiesToPropagate();if(r!==this.oPropagatedProperties){this.oPropagatedProperties=r;if(this.hasModel()){this.updateBindings(true,null);this.updateBindingContext(false,undefined,true);this.propagateProperties(true)}this._callPropagationListener();this.fireModelContextChange()}}this._applyContextualSettings(t._oContextualSettings);if(t&&!t.isInvalidateSuppressed()){t.invalidate(this)}if(i){t.iSuppressInvalidate--}n=this._observer||this.oParent._observer;if(n){n.parentChange(this,e,"set",this.oParent)}return this};m.prototype._applyContextualSettings=function(t){t=t||S;if(this._oContextualSettings!==t){this._oContextualSettings=t;this._propagateContextualSettings();if(this._bIsOwnerActive){this._onContextualSettingsChanged()}}};m.prototype._onContextualSettingsChanged=function(){};m.prototype._propagateContextualSettings=function(){var t=this._oContextualSettings,e,i,n;for(e in this.mAggregations){i=this.mAggregations[e];if(i instanceof m){i._applyContextualSettings(t)}else if(i instanceof Array){for(n=0;n<i.length;n++){if(i[n]instanceof m){i[n]._applyContextualSettings(t)}}}}};m.prototype._getContextualSettings=function(){return this._oContextualSettings};m.prototype.getParent=function(){return this.oParent};m.prototype.destroy=function(t){var i,n;if(this.bIsDestroyed){return}var r=this;this._bIsBeingDestroyed=true;if(t){this.iSuppressInvalidate++}for(i in this.mBindingInfos){n=this.mBindingInfos[i];if(n.binding){if(n.factory){this._detachAggregationBindingHandlers(i)}else{this._detachPropertyBindingHandlers(i)}}}for(i in this.mObjectBindingInfos){n=this.mObjectBindingInfos[i];if(n.binding){this._detachObjectBindingHandlers(n)}}if(this.exit){o(this.exit(),{name:"exit",component:this.getId()})}if(this._exitCompositeSupport){this._exitCompositeSupport()}for(var s in this.mAggregations){this.destroyAggregation(s,t)}if(this.deregister){this.deregister()}if(this.oParent&&this.sParentAggregationName){this.oParent._removeChild(this,this.sParentAggregationName,t)}delete this.oParent;for(i in this.mBindingInfos){if(this.mBindingInfos[i].factory){this.unbindAggregation(i,true)}else{this.unbindProperty(i,true)}}for(i in this.mObjectBindingInfos){this.unbindObject(i,true)}if(t){this.iSuppressInvalidate--}if(this._observer){this._observer.objectDestroyed(this)}if(this.aAPIParentInfos){this.aAPIParentInfos=null}e.prototype.destroy.apply(this,arguments);this.setParent=function(){throw Error("The object with ID "+r.getId()+" was destroyed and cannot be used anymore.")};this.bIsDestroyed=true};m.prototype.isBinding=function(t,e){return typeof this.extractBindingInfo(t)==="object"};m.prototype.extractBindingInfo=function(t,e,i){var n=r.extract(t,e,i);if(typeof t==="object"&&n&&n.template){n.template=I(n.template)}return n};m.prototype.getBindingInfo=function(t){var e=this.getMetadata().getAggregationForwarder(t);if(e&&e.forwardBinding){return e.getTarget(this).getBindingInfo(e.targetAggregationName)}return this.mBindingInfos[t]};m.prototype._getObjectBindingInfo=function(t){return this.mObjectBindingInfos[t]};m.prototype.bindObject=function(t){var e;if(arguments[1]){a.fatalThrows(`${this}.bindObject: Providing 'parameters' as positional parameter is deprecated as of 1.135.0. Provide an sap.ui.base.ManagedObject.ObjectBindingInfo instead.`)}if(typeof t=="string"){t={path:t,parameters:arguments[1]}}t=r.createObject(t);e=t.model;if(this.getObjectBinding(e)){this.unbindObject(e,true)}this.mObjectBindingInfos[e]=t;if(r.isReady(t,this)){this._bindObject(t)}return this};function M(t){a.errorThrows("Unexpected call of '"+t+"'.")}m.prototype._bindObject=M.bind(null,"_bindObject");m.prototype._detachObjectBindingHandlers=M.bind(null,"_detachObjectBindingHandlers");m.prototype.unbindObject=function(t,e){var i=this.mObjectBindingInfos[t];if(i){delete this.mObjectBindingInfos[t];if(i.binding){this._unbindObject(i,t,e)}}return this};m.prototype._unbindObject=M.bind(null,"_unbindObject");m.prototype.bindContext=function(t){return this.bindObject(t)};m.prototype.unbindContext=function(t){return this.unbindObject(t)};m.prototype.bindProperty=function(t,e){var i=this.getMetadata().getPropertyLikeSetting(t);if(!i){throw new Error('Property "'+t+'" does not exist in '+this)}if(arguments[2]||arguments[3]){a.fatalThrows(`${this}.bindProperty: Providing a type, formatter, or bindingMode as a positional parameter is deprecated as of 1.135.0. Provide an sap.ui.base.ManagedObject.PropertyBindingInfo instead.`)}if(typeof e=="string"){e={parts:[{path:e,type:n.isObjectA(arguments[2],"sap.ui.model.Type")?arguments[2]:undefined,mode:arguments[3]}],formatter:typeof arguments[2]==="function"?arguments[2]:undefined}}if(this.isBound(t)){this.unbindProperty(t,true)}e=r.createProperty(e);this.mBindingInfos[t]=e;if(this._observer){this._observer.bindingChange(this,t,"prepare",e,"property")}if(r.isReady(e,this)){this._bindProperty(t,e)}return this};m.prototype._bindProperty=function(t,e){var i=true;for(var n=0;n<e.parts.length;n++){if(e.parts[n].value===undefined){i=false;break}}if(i){var r=[];e.parts.forEach(function(t){r.push(t.formatter?t.formatter(t.value):t.value)});var s=e.formatter?e.formatter(r):r.join(" ");var o=this.getMetadata().getPropertyLikeSetting(t);this[o._sMutator](s)}else{M.call(this,"_bindProperty")}};m.prototype._detachPropertyBindingHandlers=function(t){};m.prototype.unbindProperty=function(t,e){var i=this.mBindingInfos[t];if(i){if(i.binding){this._unbindProperty(i,t)}if(this._observer&&!this._bIsBeingDestroyed){this._observer.bindingChange(this,t,"remove",this.mBindingInfos[t],"property")}delete this.mBindingInfos[t];if(!e){this.resetProperty(t)}}return this};m.prototype._unbindProperty=M.bind(null,"_unbindProperty");m.prototype.isPropertyBeingUpdated=function(t){const e=this.getBindingInfo(t);return!!e?.skipModelUpdate};m.prototype.updateProperty=function(t){};m.prototype.updateModelProperty=function(t,e,i){};var w=1;m.prototype.bindAggregation=function(t,e,i){var n=this.getMetadata(),s=n.getAggregation(t);if(!s){throw new Error('Aggregation "'+t+'" does not exist in '+this)}if(!s.multiple){a.errorThrows('Binding of single aggregation "'+t+'" of '+this+" is not supported!")}if(arguments[3]||arguments[4]){a.fatalThrows(`${this}.bindAggregation: Providing sorters and/or filters as positional parameters is deprecated as of 1.135.0. Provide an sap.ui.base.ManagedObject.AggregationBindingInfo instead.`)}if(typeof e=="string"){e={path:e,sorter:arguments[3],filters:arguments[4]};if(i instanceof m){e.template=i}else if(typeof i==="function"){e.factory=i}}e[r.OriginalParent]??=this;var o=n.getAggregationForwarder(t);if(o&&o.forwardBinding){o.getTarget(this).bindAggregation(o.targetAggregationName,e);return this}if(this.isBound(t)){this.unbindAggregation(t)}if(e.template){if(e.template._sapui_candidateForDestroy){a.warningThrows("A binding template that is marked as 'candidate for destroy' is reused in a binding. "+"You can use 'templateShareable:true' to fix this issue for all bindings that are affected "+"(The template is used in aggregation '"+t+"' of object '"+this.getId()+"'). "+"For more information, see documentation under 'Aggregation Binding'.");delete e.template._sapui_candidateForDestroy}if(e.templateShareable===undefined){e.templateShareable=w}else if(typeof e.templateShareable==="string"){a.warningThrows(`Parameter 'templateShareable' is defined with type boolean but is set for binding template ${e.template.toString()} with string value "${e.templateShareable}". This can easily lead to errors. To avoid unintended behavior, always set the parameter to true or false`);if(e.templateShareable==="true"){e.templateShareable=true}else if(e.templateShareable==="false"){e.templateShareable=false}}}e=r.createAggregation(e,s._doesNotRequireFactory);this.mBindingInfos[t]=e;if(!(e.template||e.factory)){throw new Error("Missing template or factory function for aggregation "+t+" of "+this+" !")}if(e.factory){var g=e.factory[b]||e.factory;var p=this._sOwnerId;e.factory=function(t,e){return m.runWithOwner(g.bind(null,t,e),p)};e.factory[b]=g}if(this._observer){this._observer.bindingChange(this,t,"prepare",e,"aggregation")}if(r.isReady(e,this)){this._bindAggregation(t,e)}return this};m.prototype._bindAggregation=M.bind(null,"_bindAggregation");m.prototype._detachAggregationBindingHandlers=M.bind(null,"_detachAggregationBindingHandlers");m.prototype.unbindAggregation=function(t,e){var i=this.getMetadata().getAggregationForwarder(t);if(i&&i.forwardBinding){i.getTarget(this).unbindAggregation(i.targetAggregationName,e);return this}var n=this.mBindingInfos[t],r=this.getMetadata().getAggregation(t);if(n){if(n.binding){this._unbindAggregation(n,t)}if(n.template){if(!n.templateShareable&&n.template.destroy){n.template.destroy()}if(n.templateShareable===w){n.template._sapui_candidateForDestroy=true}}if(this._observer&&!this._bIsBeingDestroyed){this._observer.bindingChange(this,t,"remove",this.mBindingInfos[t],"aggregation")}delete this.mBindingInfos[t];if(!e){this[r._sDestructor]()}}return this};m.prototype._unbindAggregation=M.bind(null,"_unbindAggregation");m.prototype.updateAggregation=function(t,e,i){};m.prototype.refreshAggregation=function(t){};m.prototype.propagateMessages=function(t,e){a.warningThrows("Message for "+this+", Property "+t+" received. Control "+this.getMetadata().getName()+" does not support messaging without using data binding.")};m.prototype.isTreeBinding=function(t){return false};m.prototype.updateBindings=function(t,e){};m.prototype.isBound=function(t){return!!this.getBindingInfo(t)};m.prototype.getObjectBinding=function(t){v(t);var e=this._getObjectBindingInfo(t);return e&&e.binding};m.prototype.getEventingParent=function(){return this.oParent};m.prototype.getBinding=function(t){var e=this.getBindingInfo(t);return e&&e.binding};m.prototype.getBindingPath=function(t){var e=this.getBindingInfo(t);return e&&(e.path||e.parts&&e.parts[0]&&e.parts[0].path)};m.prototype.setBindingContext=function(t,e){v(e);var i=this.oBindingContexts[e];if(i!==t||t&&t.hasChanged()){if(t===undefined){delete this.oBindingContexts[e]}else{this.oBindingContexts[e]=t}this.updateBindingContext(false,e);this.propagateProperties(e);this.fireModelContextChange()}return this};m.prototype.setElementBindingContext=function(t,e){};m.prototype.updateBindingContext=function(t,e,i){};m.prototype.getBindingContext=function(t){var e=this.getModel(t),i=this.mElementBindingContexts[t];if(i&&!e){return i}else if(i&&e&&i.getModel()===e){return i}else if(i===null){return i}else{return this._getBindingContext(t)}};m.prototype._getBindingContext=function(t){var e=this.getModel(t),i=this.oBindingContexts[t],n=this.oPropagatedProperties.oBindingContexts[t];if(i&&!e){return this.oBindingContexts[t]}else if(i&&e&&i.getModel()===e){return this.oBindingContexts[t]}else if(i===null){return i}else if(n&&e&&n.getModel()!==e){return undefined}else{return n}};m.prototype.setModel=function(t,e){f(t==null||n.isObjectA(t,"sap.ui.model.Model"),"oModel must be an instance of sap.ui.model.Model, null or undefined");f(e===undefined||typeof e==="string"&&!/^(undefined|null)?$/.test(e),"sName must be a string or omitted");if(!t&&this.oModels[e]){delete this.oModels[e];this.propagateProperties(e);this.updateBindings(false,e);this.fireModelContextChange()}else if(t&&t!==this.oModels[e]){this.oModels[e]=t;this.propagateProperties(e);this.updateBindingContext(false,e);this.updateBindings(false,e);this.fireModelContextChange()}return this};m.prototype.addPropagationListener=function(t){f(typeof t==="function","listener must be a function");this.aPropagationListeners.push(t);this.propagateProperties(false);this._callPropagationListener(t);return this};m.prototype.removePropagationListener=function(t){f(typeof t==="function","listener must be a function");var e=this.aPropagationListeners;var i=e.indexOf(t);if(i>=0){e.splice(i,1);this.propagateProperties(false)}return this};m.prototype.getPropagationListeners=function(){return this.oPropagatedProperties.aPropagationListeners.concat(this.aPropagationListeners)};m.prototype._callPropagationListener=function(t){var e;if(t){t(this)}else{e=this.getPropagationListeners();for(var i=0;i<e.length;i++){t=e[i];t(this)}}return this};const j={oModels:{},oBindingContexts:{},aPropagationListeners:[]};function x(t,e){return!e.aAPIParentInfos||e.aAPIParentInfos[0].parent===t}m.prototype.propagateProperties=function(t){var e=this._getPropertiesToPropagate(),i=t===true,n=t===false,r=i?undefined:t,s,o,a,g=Object.assign({},this.mAggregations,this.mForwardedAggregations);A(e.oModels);for(s in g){if(this.mSkipPropagation[s]){continue}o=g[s];if(o instanceof m){if(x(this,o)){this._propagateProperties(t,o,e,i,r,n)}}else if(o instanceof Array){for(a=0;a<o.length;a++){if(o[a]instanceof m){if(x(this,o[a])){this._propagateProperties(t,o[a],e,i,r,n)}}}}}};m.prototype._propagateProperties=function(t,e,i,n,r,s){if(!i){i=this._getPropertiesToPropagate();n=t===true;s=t===false;r=n?undefined:t}A(i.oModels);if(e.oPropagatedProperties!==i){e.oPropagatedProperties=i;if(s!==true){e.updateBindings(n,r);e.updateBindingContext(false,r,n)}e.propagateProperties(t);if(s||n){e._callPropagationListener()}e.fireModelContextChange()}};m.prototype._getPropertiesToPropagate=function(){var t=c(this.oModels),e=c(this.oBindingContexts),i=this.aPropagationListeners.length===0,n=c(this.mElementBindingContexts);function r(t,e,i,n){return t?e:u({},e,i,n)}function s(t,e,i){return t?e:e.concat(i)}if(e&&t&&n&&i){return this.oPropagatedProperties}else{return{oModels:r(t,this.oPropagatedProperties.oModels,this.oModels),oBindingContexts:r(e&&n,this.oPropagatedProperties.oBindingContexts,this.oBindingContexts,this.mElementBindingContexts),aPropagationListeners:s(i,this.oPropagatedProperties.aPropagationListeners,this.aPropagationListeners)}}};m.prototype.getModel=function(t){v(t);return this.oModels[t]||this.oPropagatedProperties.oModels[t]};m.prototype.getOwnModels=function(){return this.oModels};m.prototype.hasModel=function(){return!(c(this.oModels)&&c(this.oPropagatedProperties.oModels))};m.prototype.clone=function(t,e,n){var s=true,o=true;if(n){s=!!n.cloneChildren;o=!!n.cloneBindings}if(!t){t=i.uid("clone")||l()}if(!e&&s){e=this.findAggregatedObjects(true,null,true).map(function(t){return t.getId()});e.push(this.getId())}var g=this.getMetadata(),p=g._oClass,f=this.getId()+"-"+t,h={},u,c=this.mProperties,y,b,v,P=r.escape,A,I;var _=Object.keys(c);var B;A=_.length;while(A>0){y=_[--A];u=g.getProperty(y);if(u&&!(this.isBound(y)&&o)){if(typeof c[y]==="string"){h[y]=P(c[y])}else{B=u.byValue?d(c[y]):c[y];if(B&&typeof B==="object"&&!Object.isFrozen(B)){B[r.UI5ObjectMarker]=true}h[y]=B}}}h["models"]=this.oModels;h["bindingContexts"]=this.oBindingContexts;if(s){var C=Object.assign({},this.mAggregations,this.mForwardedAggregations);for(b in C){var M=C[b];if(g.hasAggregation(b)&&!(this.isBound(b)&&o)){if(M instanceof m){h[b]=M.clone(t,e)}else if(Array.isArray(M)){h[b]=[];for(var A=0;A<M.length;A++){h[b].push(M[A].clone(t,e))}}else{h[b]=typeof M==="string"?P(M):M}}}for(b in this.mAssociations){if(!g.hasAssociation(b)){continue}var j=this.mAssociations[b];if(Array.isArray(j)){j=j.slice(0);for(var A=0;A<j.length;A++){if(e.indexOf(j[A])>=0){j[A]+="-"+t}}}else if(e.indexOf(j)>=0){j+="-"+t}h[b]=j}}v=new p(f,h);function x(i,n,r,s,o){var g=!r;var p=Object.assign({},i);if(!i.templateShareable&&i.template&&i.template.clone){p.template=i.template.clone(t,e);delete p.factory}else if(i.templateShareable===w){i.templateShareable=p.templateShareable=true;a.errorThrows("During a clone operation, a template was found that neither was marked with 'templateShareable:true' nor 'templateShareable:false'. "+"The framework won't destroy the template. This could cause errors (e.g. duplicate IDs) or memory leaks "+"(The template is used in aggregation '"+o+"' of object '"+s.getId()+"')."+"For more information, see documentation under 'Aggregation Binding'.")}delete p.binding;delete p.modelChangeHandler;delete p.dataStateChangeHandler;delete p.modelRefreshHandler;if(g){n.bindObject(p)}else if(i.factory){n.bindAggregation(r,p)}else{n.bindProperty(r,p)}}for(b in this.mEventRegistry){v.mEventRegistry[b]=this.mEventRegistry[b].slice()}if(o){for(b in this.mObjectBindingInfos){x(this.mObjectBindingInfos[b],v)}for(b in this.mBindingInfos){x(this.mBindingInfos[b],v,b,this,b)}}if(m._supportInfo){m._supportInfo.addSupportInfo(v.getId(),m._supportInfo.byId(this.getId()))}if(this._cloneMetadataContexts){this._cloneMetadataContexts(v)}if(this.mForwardedAggregations){for(b in this.mForwardedAggregations){var S=v.getMetadata().getAggregationForwarder(b);if(S){I=S.getTarget(v,true);if(S.forwardBinding&&this.isBound(b)){x(this.getBindingInfo(b),I,S.targetAggregationName,this,b)}}}}return v};m.prototype.findAggregatedObjects=function(t,e,i){var n=[];if(e&&typeof e!=="function"){e=null}function r(s){var o,a,g;if(i){for(g in s.mBindingInfos){o=s.mBindingInfos[g].template;if(o){if(!e||e(o)){n.push(o)}if(t){r(o)}}}}for(g in s.mAggregations){o=s.mAggregations[g];if(Array.isArray(o)){for(a=0;a<o.length;a++){if(!e||e(o[a])){n.push(o[a])}if(t){r(o[a])}}}else if(o instanceof m){if(!e||e(o)){n.push(o)}if(t){r(o)}}}}r(this);return n};m.prototype.onOwnerDeactivation=function(){this._bIsOwnerActive=false};m.prototype.onOwnerActivation=function(){this._bIsOwnerActive=true;this._onContextualSettingsChanged()};m.prototype.isDestroyStarted=function(){return!!this._bIsBeingDestroyed};m.prototype.isDestroyed=function(){return!!this.bIsDestroyed};m.prototype.updateFieldHelp=undefined;const S={};return m});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/ManagedObjectMetadata", ["./DataType","./Metadata","./Object","sap/base/Log","sap/base/assert","sap/base/config","sap/base/strings/capitalize","sap/base/strings/escapeRegExp","sap/base/util/merge","sap/base/util/isPlainObject"],function(t,e,i,r,n,s,o,a,g,u){"use strict";var l=function(t,i){e.apply(this,arguments)};var h;l.prototype=Object.create(e.prototype);l.prototype.constructor=l;var p=/(children|ies|ves|oes|ses|ches|shes|xes|s)$/i;var f={children:-3,ies:"y",ves:"f",oes:-2,ses:-2,ches:-2,shes:-2,xes:-2,s:-1};function c(t){return t.replace(p,function(t,e){var i=f[e.toLowerCase()];return typeof i==="string"?i:e.slice(0,i)})}function m(t,e){return function(){r.warning("Usage of deprecated feature: "+e);return t.apply(this,arguments)}}function d(t,e){var i=null;for(var r in e){if(Object.hasOwn(e,r)&&typeof t[r]==="undefined"){i=i||{};i[r]=e[r]}}return i}function y(t,e,r){const n=e.defaultClass;if(n){if(!i.isObjectA(n.prototype,t.type)){throw new TypeError(`The 'defaultClass' of the aggregation '${t.name}' in '${r.getName()}' is not of type '${t.type}'.`)}else if(t.altTypes?.includes("object")){throw new TypeError(`The aggregation '${t.name}' in '${r.getName()}' must not defined a 'defaultClass' together with the altType 'object'.`)}}else if(e.hasOwnProperty("defaultClass")){throw new TypeError(`The 'defaultClass' of the aggregation '${t.name}' in '${r.getName()}' is defined with a nullish value (${n}).`)}return n}var A={SPECIAL_SETTING:-1,PROPERTY:0,SINGLE_AGGREGATION:1,MULTIPLE_AGGREGATION:2,SINGLE_ASSOCIATION:3,MULTIPLE_ASSOCIATION:4,EVENT:5};l._guessSingularName=c;function _(t,e,i){i=typeof i!=="object"?{type:i}:i;this.name=e;this.type=i.type||"any";this.visibility=i.visibility||"public";this.defaultValue=i.defaultValue;this.appData=d(this,i);this._oParent=t;this._sUID="special:"+e;this._iKind=A.SPECIAL_SETTING}function v(t,e,i){i=typeof i!=="object"?{type:i}:i;this.name=e;this.type=i.type||"string";this.group=i.group||"Misc";this.defaultValue=i.defaultValue!==null?i.defaultValue:null;this.bindable=!!i.bindable;this.deprecated=!!i.deprecated||false;this.visibility=i.visibility||"public";this.byValue=i.byValue===true;this.selector=typeof i.selector==="string"?i.selector:null;this.appData=d(this,i);this._oParent=t;this._sUID=e;this._iKind=A.PROPERTY;var r=o(e);this._sMutator="set"+r;this._sGetter="get"+r;if(this.bindable){this._sBind="bind"+r;this._sUnbind="unbind"+r}else{this._sBind=this._sUnbind=undefined}this._oType=null}v.prototype.generate=function(t){var e=this,i=e.name;t(e._sGetter,function(){return this.getProperty(i)});t(e._sMutator,function(t){this.setProperty(i,t);return this},e);if(e.bindable){t(e._sBind,function(t,e,r){this.bindProperty(i,t,e,r);return this},e);t(e._sUnbind,function(t){this.unbindProperty(i,t);return this})}};v.prototype.getType=function(){if(!this._oType){this._oType=t.getType(this.type)}return this._oType};v.prototype.getDefaultValue=function(){var e=this.defaultValue,i;if(e===null){i=this.getType();if(i instanceof t){e=i.getDefaultValue()}}return e};v.prototype.get=function(t){if(this.visibility!=="public"){return t.getProperty(this.name)}return t[this._sGetter]()};v.prototype.set=function(t,e){if(this.visibility!=="public"){return t.setProperty(this.name,e)}return t[this._sMutator](e)};function P(t,e,i){i=typeof i!=="object"?{type:i}:i;this.name=e;this.type=i.type||"sap.ui.core.Control";this.altTypes=Array.isArray(i.altTypes)?i.altTypes:undefined;this.defaultClass=y(this,i,t)||null;this.multiple=typeof i.multiple==="boolean"?i.multiple:true;this.singularName=this.multiple?i.singularName||c(e):undefined;this.bindable=!!i.bindable;this.deprecated=i.deprecated||false;this.visibility=i.visibility||"public";this.selector=i.selector||null;this.forwarding=i.forwarding;this._doesNotRequireFactory=!!i._doesNotRequireFactory;this.appData=d(this,i);this._oParent=t;this._sUID="aggregation:"+e;this._iKind=this.multiple?A.MULTIPLE_AGGREGATION:A.SINGLE_AGGREGATION;this._oForwarder=this.forwarding?new b(this):undefined;var r=o(e);this._sGetter="get"+r;if(this.multiple){var n=o(this.singularName);this._sMutator="add"+n;this._sInsertMutator="insert"+n;this._sRemoveMutator="remove"+n;this._sRemoveAllMutator="removeAll"+r;this._sIndexGetter="indexOf"+n;this._sUpdater="update"+r;this._sRefresher="refresh"+r}else{this._sMutator="set"+r;this._sInsertMutator=this._sRemoveMutator=this._sRemoveAllMutator=this._sIndexGetter=this._sUpdater=this._sRefresher=undefined}this._sDestructor="destroy"+r;if(this.bindable){this._sBind="bind"+r;this._sUnbind="unbind"+r}else{this._sBind=this._sUnbind=undefined}}P.prototype.generate=function(t){var e=this,i=e.name;if(!e.multiple){t(e._sGetter,function(){return this.getAggregation(i)});t(e._sMutator,function(t){this.setAggregation(i,t);return this},e)}else{t(e._sGetter,function(){return this.getAggregation(i,[])});t(e._sMutator,function(t){this.addAggregation(i,t);return this},e);t(e._sInsertMutator,function(t,e){this.insertAggregation(i,t,e);return this},e);t(e._sRemoveMutator,function(t){return this.removeAggregation(i,t)});t(e._sRemoveAllMutator,function(){return this.removeAllAggregation(i)});t(e._sIndexGetter,function(t){return this.indexOfAggregation(i,t)})}t(e._sDestructor,function(){this.destroyAggregation(i);return this});if(e.bindable){t(e._sBind,function(t,e,r,n){this.bindAggregation(i,t,e,r,n);return this},e);t(e._sUnbind,function(t){this.unbindAggregation(i,t);return this})}};P.prototype.getType=function(){if(!this._oType){this._oType=t.getType(this.type)}return this._oType};P.prototype.get=function(t){if(this.visibility!=="public"){return t.getAggregation(this.name,this.multiple?[]:undefined)}return t[this._sGetter]()};P.prototype.set=function(t,e){if(this.visibility!=="public"){return t.setAggregation(this.name,e)}return t[this._sMutator](e)};P.prototype.add=function(t,e){if(this.visibility!=="public"){return t.addAggregation(this.name,e)}return t[this._sMutator](e)};P.prototype.insert=function(t,e,i){if(this.visibility!=="public"){return t.insertAggregation(this.name,e,i)}return t[this._sInsertMutator](e,i)};P.prototype.remove=function(t,e){if(this.visibility!=="public"){return t.removeAggregation(this.name,e)}return t[this._sRemoveMutator](e)};P.prototype.removeAll=function(t){if(this.visibility!=="public"){return t.removeAllAggregation(this.name)}return t[this._sRemoveAllMutator]()};P.prototype.indexOf=function(t,e){if(this.visibility!=="public"){return t.indexOfAggregation(this.name,e)}return t[this._sIndexGetter](e)};P.prototype.destroy=function(t){return t[this._sDestructor]()};P.prototype.update=function(t,e,i){if(t[this._sUpdater]){t[this._sUpdater](e,i)}else{t.updateAggregation(this.name,e,i)}};P.prototype.refresh=function(t,e){if(t[this._sRefresher]){t[this._sRefresher](e)}else{this.update(t,e)}};function b(t){var e=t.forwarding;this.aggregation=t;this.targetAggregationName=e.aggregation;this.forwardBinding=e.forwardBinding;this.targetAggregationInfo=null;if(e.getter){if(typeof e.getter==="function"){this._getTarget=e.getter}else{this._getTarget=function(t){return function(){return this[t]()}}(e.getter)}}else if(e.idSuffix){this._getTarget=function(t){return function(){h=h||sap.ui.require("sap/ui/core/Element");return h&&h.getElementById(this.getId()+t)}}(e.idSuffix)}else{throw new Error("Either getter or idSuffix must be given for forwarding the aggregation "+t.name+" to the aggregation "+e.aggregation+" in "+t._oParent.getName())}}b.prototype._getTargetAggregationInfo=function(t){var e=this.targetAggregationInfo;if(!e&&t){e=this.targetAggregationInfo=t.getMetadata().getAggregation(this.targetAggregationName);if(!e){throw new Error("Target aggregation "+this.targetAggregationName+" not found on "+t)}if(this.aggregation.multiple&&!e.multiple){throw new Error("Aggregation "+this.aggregation+" (multiple: "+this.aggregation.multiple+") cannot be forwarded to aggregation "+this.targetAggregationName+" (multiple: "+e.multiple+")")}if(!this.aggregation.multiple&&e.multiple&&this.aggregation.forwarding.forwardBinding){throw new Error("Aggregation "+this.aggregation+" (multiple: "+this.aggregation.multiple+") cannot be forwarded to aggregation "+this.targetAggregationName+" (multiple: "+e.multiple+") with 'forwardBinding' set to 'true'")}}return e};b.prototype.getTarget=function(t,e){var i=this._getTarget.call(t);this._getTargetAggregationInfo(i);if(i){t.mForwardedAggregations=t.mForwardedAggregations||{};if(t.mForwardedAggregations[this.aggregation.name]===undefined||e){var r=i.mAggregations[this.targetAggregationInfo.name];if(r&&!e&&!this.aggregation.forwarding.forwardBinding&&!(Array.isArray(r)&&r.length===0)){throw new Error("There is already content in aggregation "+this.targetAggregationInfo.name+" of "+i+" to which forwarding is being set up now.")}else{var n=i.mAggregations[this.targetAggregationInfo.name]||(this.targetAggregationInfo.multiple?[]:null);t.mForwardedAggregations[this.aggregation.name]=i.mAggregations[this.targetAggregationInfo.name]=n}}}return i};b.prototype.get=function(t){var e=this.getTarget(t);if(e){var i=this.targetAggregationInfo.get(e);if(!this.aggregation.multiple&&this.targetAggregationInfo.multiple){i=i[0]}return i}else{return this.aggregation.multiple?[]:null}};b.prototype.indexOf=function(t,e){var i=this.getTarget(t);return this.targetAggregationInfo.indexOf(i,e)};b.prototype.set=function(t,e){var i=this.getTarget(t);t.mForwardedAggregations[this.aggregation.name]=e;if(this.targetAggregationInfo.multiple){var r=this.targetAggregationInfo.get(i);if(r&&r[0]){if(r[0]===e){return t}this.targetAggregationInfo.removeAll(i)}l.addAPIParentInfoBegin(e,t,this.aggregation.name);this.targetAggregationInfo.add(i,e)}else{l.addAPIParentInfoBegin(e,t,this.aggregation.name);this.targetAggregationInfo.set(i,e)}l.addAPIParentInfoEnd(e);return t};b.prototype.add=function(t,e){var i=this.getTarget(t);l.addAPIParentInfoBegin(e,t,this.aggregation.name);this.targetAggregationInfo.add(i,e);l.addAPIParentInfoEnd(e);return t};b.prototype.insert=function(t,e,i){var r=this.getTarget(t);l.addAPIParentInfoBegin(e,t,this.aggregation.name);this.targetAggregationInfo.insert(r,e,i);l.addAPIParentInfoEnd(e);return t};l.addAPIParentInfoBegin=function(t,e,i){if(!t){return}var r={parent:e,aggregationName:i};if(t.aAPIParentInfos){if(t.aAPIParentInfos.forwardingCounter){t.aAPIParentInfos.forwardingCounter++}else{delete t.aAPIParentInfos}}if(!t.aAPIParentInfos){t.aAPIParentInfos=[r];t.aAPIParentInfos.forwardingCounter=1}else{t.aAPIParentInfos.push(r)}};l.addAPIParentInfoEnd=function(t){t&&t.aAPIParentInfos&&t.aAPIParentInfos.forwardingCounter--};b.prototype.remove=function(t,e){var i=this.getTarget(t);var r=this.targetAggregationInfo.remove(i,e);if(r){r.aAPIParentInfos&&r.aAPIParentInfos.pop()}return r};b.prototype.removeAll=function(t){var e=this.getTarget(t);delete t.mForwardedAggregations[this.aggregation.name];var i=this.targetAggregationInfo.removeAll(e);for(var r=0;r<i.length;r++){if(i[r].aAPIParentInfos){i[r].aAPIParentInfos.pop()}}return i};b.prototype.destroy=function(t){var e=this.getTarget(t);delete t.mForwardedAggregations[this.aggregation.name];if(e){this.targetAggregationInfo.destroy(e)}return t};function I(t,e,i){i=typeof i!=="object"?{type:i}:i;this.name=e;this.type=i.type||"sap.ui.core.Control";this.multiple=i.multiple||false;this.singularName=this.multiple?i.singularName||c(e):undefined;this.deprecated=i.deprecated||false;this.visibility=i.visibility||"public";this.appData=d(this,i);this._oParent=t;this._sUID="association:"+e;this._iKind=this.multiple?A.MULTIPLE_ASSOCIATION:A.SINGLE_ASSOCIATION;var r=o(e);this._sGetter="get"+r;if(this.multiple){var n=o(this.singularName);this._sMutator="add"+n;this._sRemoveMutator="remove"+n;this._sRemoveAllMutator="removeAll"+r}else{this._sMutator="set"+r;this._sRemoveMutator=this._sRemoveAllMutator=undefined}}I.prototype.generate=function(t){var e=this,i=e.name;if(!e.multiple){t(e._sGetter,function(){return this.getAssociation(i)});t(e._sMutator,function(t){this.setAssociation(i,t);return this},e)}else{t(e._sGetter,function(){return this.getAssociation(i,[])});t(e._sMutator,function(t){this.addAssociation(i,t);return this},e);t(e._sRemoveMutator,function(t){return this.removeAssociation(i,t)});t(e._sRemoveAllMutator,function(){return this.removeAllAssociation(i)});if(i!==e.singularName){t("removeAll"+o(e.singularName),function(){r.warning("Usage of deprecated method "+e._oParent.getName()+".prototype."+"removeAll"+o(e.singularName)+","+" use method "+e._sRemoveAllMutator+" (plural) instead.");return this[e._sRemoveAllMutator]()})}}};I.prototype.getType=function(){if(!this._oType){this._oType=t.getType(this.type)}return this._oType};I.prototype.get=function(t){if(this.visibility!=="public"){return t.getAssociation(this.name,this.multiple?[]:undefined)}return t[this._sGetter]()};I.prototype.set=function(t,e){if(this.visibility!=="public"){return t.setAssociation(this.name,e)}return t[this._sMutator](e)};I.prototype.add=function(t,e){if(this.visibility!=="public"){return t.addAssociation(this.name,e)}return t[this._sMutator](e)};I.prototype.remove=function(t,e){if(this.visibility!=="public"){return t.removeAssociation(this.name,e)}return t[this._sRemoveMutator](e)};I.prototype.removeAll=function(t){if(this.visibility!=="public"){return t.removeAllAssociation(this.name)}return t[this._sRemoveAllMutator]()};function T(t,e,i){this.name=e;this.allowPreventDefault=i.allowPreventDefault||false;this.deprecated=i.deprecated||false;this.visibility="public";this.allowPreventDefault=!!i.allowPreventDefault;this.enableEventBubbling=!!i.enableEventBubbling;this.appData=d(this,i);this._oParent=t;this._sUID="event:"+e;this._iKind=A.EVENT;var r=o(e);this._sMutator="attach"+r;this._sDetachMutator="detach"+r;this._sTrigger="fire"+r}T.prototype.generate=function(t){var e=this,i=e.name,r=e.allowPreventDefault,n=e.enableEventBubbling;t(e._sMutator,function(t,e,r){this.attachEvent(i,t,e,r);return this},e);t(e._sDetachMutator,function(t,e){this.detachEvent(i,t,e);return this});t(e._sTrigger,function(t){return this.fireEvent(i,t,r,n)})};T.prototype.attach=function(t,e,i,r){return t[this._sMutator](e,i,r)};T.prototype.detach=function(t,e,i){return t[this._sDetachMutator](e,i)};T.prototype.fire=function(t,e){return t[this._sTrigger](e,this.allowPreventDefault,this.enableEventBubbling)};l.prototype.metaFactorySpecialSetting=_;l.prototype.metaFactoryProperty=v;l.prototype.metaFactoryAggregation=P;l.prototype.metaFactoryAssociation=I;l.prototype.metaFactoryEvent=T;l.prototype.applySettings=function(t){var i=this,r=t.metadata;e.prototype.applySettings.call(this,t);function n(t,e){var r={},n;if(t){for(n in t){if(Object.hasOwn(t,n)){r[n]=new e(i,n,t[n])}}}return r}function s(t,e){var i={},r;for(r in t){if(e===(t[r].visibility==="public")){i[r]=t[r]}}return i}var o=/([a-z][^.]*(?:\.[a-z][^.]*)*)\./;function a(t){var e=o.exec(t);return e&&e[1]||""}this._sLibraryName=r.library||a(this.getName());this._mSpecialSettings=n(r.specialSettings,this.metaFactorySpecialSetting);var g=n(r.properties,this.metaFactoryProperty);this._mProperties=s(g,true);this._mPrivateProperties=s(g,false);var u=n(r.aggregations,this.metaFactoryAggregation);this._mAggregations=s(u,true);this._mPrivateAggregations=s(u,false);this._sDefaultAggregation=r.defaultAggregation||null;this._sDefaultProperty=r.defaultProperty||null;var l=n(r.associations,this.metaFactoryAssociation);this._mAssociations=s(l,true);this._mPrivateAssociations=s(l,false);this._mEvents=n(r.events,this.metaFactoryEvent);this._oDesignTime=t.metadata["designtime"]||t.metadata["designTime"];this._sProvider=t.metadata["provider"];if(t.metadata.__version>1){this.generateAccessors()}};l.prototype.afterApplySettings=function(){e.prototype.afterApplySettings.call(this);var t=this.getParent();if(t instanceof l){this._mAllEvents=Object.assign({},t._mAllEvents,this._mEvents);this._mAllPrivateProperties=Object.assign({},t._mAllPrivateProperties,this._mPrivateProperties);this._mAllProperties=Object.assign({},t._mAllProperties,this._mProperties);this._mAllPrivateAggregations=Object.assign({},t._mAllPrivateAggregations,this._mPrivateAggregations);this._mAllAggregations=Object.assign({},t._mAllAggregations,this._mAggregations);this._mAllPrivateAssociations=Object.assign({},t._mAllPrivateAssociations,this._mPrivateAssociations);this._mAllAssociations=Object.assign({},t._mAllAssociations,this._mAssociations);this._sDefaultAggregation=this._sDefaultAggregation||t._sDefaultAggregation;this._sDefaultProperty=this._sDefaultProperty||t._sDefaultProperty;this._mAllSpecialSettings=Object.assign({},t._mAllSpecialSettings,this._mSpecialSettings);this._sProvider=this._sProvider||t._sProvider}else{this._mAllEvents=this._mEvents;this._mAllPrivateProperties=this._mPrivateProperties;this._mAllProperties=this._mProperties;this._mAllPrivateAggregations=this._mPrivateAggregations;this._mAllAggregations=this._mAggregations;this._mAllPrivateAssociations=this._mPrivateAssociations;this._mAllAssociations=this._mAssociations;this._mAllSpecialSettings=this._mSpecialSettings}};l.Kind=A;l.prototype.getLibraryName=function(){return this._sLibraryName};l.prototype.addProperty=function(t,e){var i=this._mProperties[t]=new v(this,t,e);if(!this._mAllProperties[t]){this._mAllProperties[t]=i}if(this._fnPropertyBagFactory){this._fnPropertyBagFactory.prototype[t]=i.getDefaultValue()}};l.prototype.hasProperty=function(t){return!!this._mAllProperties[t]};l.prototype.getProperty=function(t){var e=this._mAllProperties[t];return typeof e==="object"?e:undefined};l.prototype.getProperties=function(){return this._mProperties};l.prototype.getAllProperties=function(){return this._mAllProperties};l.prototype.getAllPrivateProperties=function(){return this._mAllPrivateProperties};l.prototype.getManagedProperty=function(t){t=t||this._sDefaultProperty;var e=t?this._mAllProperties[t]||this._mAllPrivateProperties[t]:undefined;return typeof e==="object"?e:undefined};l.prototype.getDefaultPropertyName=function(){return this._sDefaultProperty};l.prototype.getDefaultProperty=function(){return this.getProperty(this.getDefaultPropertyName())};l.prototype.hasAggregation=function(t){return!!this._mAllAggregations[t]};l.prototype.getAggregation=function(t){t=t||this._sDefaultAggregation;var e=t?this._mAllAggregations[t]:undefined;return typeof e==="object"?e:undefined};l.prototype.getAggregations=function(){return this._mAggregations};l.prototype.getAllAggregations=function(){return this._mAllAggregations};l.prototype.getAllPrivateAggregations=function(){return this._mAllPrivateAggregations};l.prototype.getManagedAggregation=function(t){t=t||this._sDefaultAggregation;var e=t?this._mAllAggregations[t]||this._mAllPrivateAggregations[t]:undefined;return typeof e==="object"?e:undefined};l.prototype.getDefaultAggregationName=function(){return this._sDefaultAggregation};l.prototype.getDefaultAggregation=function(){return this.getAggregation()};l.prototype.forwardAggregation=function(t,e){var i=this.getAggregation(t);if(!i){throw new Error("aggregation "+t+" does not exist")}if(!e||!e.aggregation||!(e.idSuffix||e.getter)||e.idSuffix&&e.getter){throw new Error("an 'mOptions' object with 'aggregation' property and either 'idSuffix' or 'getter' property (but not both) must be given"+" but does not exist")}if(i._oParent===this){i.forwarding=e;i._oForwarder=new b(i)}else{i=new this.metaFactoryAggregation(this,t,{type:i.type,altTypes:i.altTypes,multiple:i.multiple,singularName:i.singularName,bindable:i.bindable,deprecated:i.deprecated,visibility:i.visibility,selector:i.selector,forwarding:e});this._mAggregations[t]=this._mAllAggregations[t]=i}};l.prototype.getAggregationForwarder=function(t){var e=this._mAllAggregations[t];return e?e._oForwarder:undefined};l.prototype.getDefaultPropertyName=function(){return this._sDefaultProperty};l.prototype.getDefaultProperty=function(){return this.getProperty(this.getDefaultPropertyName())};l.prototype.getPropertyLikeSetting=function(t){var e=this._mAllProperties[t];if(typeof e==="object"){return e}e=this._mAllAggregations[t];return typeof e==="object"&&e.altTypes&&e.altTypes.length>0?e:undefined};l.prototype.hasAssociation=function(t){return!!this._mAllAssociations[t]};l.prototype.getAssociation=function(t){var e=this._mAllAssociations[t];return typeof e==="object"?e:undefined};l.prototype.getAssociations=function(){return this._mAssociations};l.prototype.getAllAssociations=function(){return this._mAllAssociations};l.prototype.getAllPrivateAssociations=function(){return this._mAllPrivateAssociations};l.prototype.getManagedAssociation=function(t){var e=this._mAllAssociations[t]||this._mAllPrivateAssociations[t];return typeof e==="object"?e:undefined};l.prototype.hasEvent=function(t){return!!this._mAllEvents[t]};l.prototype.getEvent=function(t){var e=this._mAllEvents[t];return typeof e==="object"?e:undefined};l.prototype.getEvents=function(){return this._mEvents};l.prototype.getAllEvents=function(){return this._mAllEvents};l.prototype.addSpecialSetting=function(t,e){var i=new _(this,t,e);this._mSpecialSettings[t]=i;if(!this._mAllSpecialSettings[t]){this._mAllSpecialSettings[t]=i}};l.prototype.hasSpecialSetting=function(t){return!!this._mAllSpecialSettings[t]};l.prototype.getPropertyDefaults=function(){var t=this._mDefaults,e;if(t){return t}if(this.getParent()instanceof l){t=Object.assign({},this.getParent().getPropertyDefaults())}else{t={}}for(e in this._mProperties){t[e]=this._mProperties[e].getDefaultValue()}for(e in this._mPrivateProperties){t[e]=this._mPrivateProperties[e].getDefaultValue()}this._mDefaults=t;return t};l.prototype.createPropertyBag=function(){if(!this._fnPropertyBagFactory){this._fnPropertyBagFactory=function t(){};this._fnPropertyBagFactory.prototype=this.getPropertyDefaults()}return new this._fnPropertyBagFactory};l.prototype.getJSONKeys=function(){if(this._mJSONKeys){return this._mJSONKeys}var t={},e={};function i(i){var r,n,s;for(r in i){n=i[r];s=t[r];if(!s||n._iKind<s._iKind){t[r]=e[r]=n}e[n._sUID]=n}}i(this._mAllSpecialSettings);i(this.getAllProperties());i(this.getAllAggregations());i(this.getAllAssociations());i(this.getAllEvents());this._mJSONKeys=e;this._mAllSettings=t;return this._mJSONKeys};l.prototype.getAllSettings=function(){if(!this._mAllSettings){this.getJSONKeys()}return this._mAllSettings};l.prototype.removeUnknownSettings=function(t){n(t==null||typeof t==="object","mSettings must be null or undefined or an object");if(t==null){return t}var e=this.getJSONKeys(),i={},r;for(r in t){if(Object.hasOwn(e,r)){i[r]=t[r]}}return i};l.prototype.generateAccessors=function(){var t=this.getClass().prototype,e=this.getName()+".",i=this._aPublicMethods,r;function n(r,n,s){if(!t[r]){t[r]=s&&s.deprecated?m(n,e+s.name):n}i.push(r)}for(r in this._mProperties){this._mProperties[r].generate(n)}for(r in this._mAggregations){this._mAggregations[r].generate(n)}for(r in this._mAssociations){this._mAssociations[r].generate(n)}for(r in this._mEvents){this._mEvents[r].generate(n)}};function w(t){return new Promise(function(e,i){sap.ui.require(["sap/ui/core/Lib"],function(i){var r=t.getLibraryName(),n=i.getPreloadMode(),s=i.all()[r];if(s&&s.designtime){var o;if(n==="async"||n==="sync"){o=sap.ui.loader._.loadJSResourceAsync(s.designtime.replace(/\.designtime$/,"-preload.designtime.js"),true)}else{o=Promise.resolve()}e(new Promise(function(t,e){o.then(function(){sap.ui.require([s.designtime],function(e){t(e)},e)})}))}e(null)},i)})}function D(t){if(u(t._oDesignTime)||!t._oDesignTime){return Promise.resolve(t._oDesignTime||{})}return new Promise(function(e,i){var r;if(typeof t._oDesignTime==="string"){r=t._oDesignTime}else{r=t.getName().replace(/\./g,"/")+".designtime"}w(t).then(function(n){sap.ui.require([r],function(i){i.designtimeModule=r;t._oDesignTime=i;i._oLib=n;e(i)},i)})})}var S={};l.setDesignTimeDefaultMapping=function(t){S=t};function E(t){var e=i.isObjectA(t,"sap.ui.base.ManagedObject")&&typeof t.data==="function"&&t.data("sap-ui-custom-settings")&&t.data("sap-ui-custom-settings")["sap.ui.dt"]&&t.data("sap-ui-custom-settings")["sap.ui.dt"].designtime;if(typeof e==="string"){e=S[e]||e;return new Promise(function(i,r){sap.ui.require([e],function(e){if(typeof e==="function"){i(e(t))}else{i(e)}},r)})}else{return Promise.resolve({})}}function N(t,e){var i=t;if("default"in t){i=g({},t.default,e!=="default"&&t[e]||null)}return i}function M(t,e,i){return g({},N(e,i),{templates:{create:null}},N(t,i),{designtimeModule:t.designtimeModule||undefined,_oLib:t._oLib})}l.prototype.loadDesignTime=function(t,e){e=typeof e==="string"&&e||"default";var i=E(t);if(!this._oDesignTimePromise){var r;var n=this.getParent();if(n instanceof l){r=n.loadDesignTime(null,e)}else{r=Promise.resolve({})}this._oDesignTimePromise=D(this).then(function(t){return r.then(function(i){return M(t,i,e)})})}return Promise.all([i,this._oDesignTimePromise]).then(function(t){var i=t[0],r=t[1];return g({},r,N(i||{},e))})};var O={},j;function R(t){n(!/[0-9]+$/.exec(t),"AutoId Prefixes must not end with numbers");t=l.getUIDPrefix()+t;var e=O[t]||0;O[t]=e+1;return t+e}l.uid=R;l.getUIDPrefix=function(){if(j===undefined){j=s.get({name:"sapUiUidPrefix",type:s.Type.String,defaultValue:"__",freeze:true})}return j};l.prototype.uid=function(){var t=this._sUIDToken;if(typeof t!=="string"){t=this.getName();t=t.slice(t.lastIndexOf(".")+1);t=t.replace(/([a-z])([A-Z])/g,"$1 $2").split(" ").slice(-1)[0];t=this._sUIDToken=t.replace(/([^A-Za-z0-9-_.:])|([0-9]+$)/g,"").toLowerCase()}return R(t)};var G;l.isGeneratedId=function(t){G=G||new RegExp("(^|-{1,3})"+a(l.getUIDPrefix()));return G.test(t)};return l},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/ManagedObjectRegistry", ["sap/ui/base/ManagedObject","sap/base/Log","sap/base/assert"],function(e,t,n){"use strict";const i={create(i){const r=Object.create(null);let o=0;i??={};const a={init(n){if(typeof n!=="function"||!(n.prototype instanceof e)){throw new TypeError("ManagedObjectRegistry mixin can only be applied to subclasses of sap.ui.base.ManagedObject")}var s=i.onDuplicate||function(e,i,r){var o=n.getMetadata().getStereotype();t.error('adding object "'+o+"\" with duplicate id '"+e+"'");throw new Error('Error: adding object "'+o+"\" with duplicate id '"+e+"'")};var c=i.onDeregister||null;n.prototype.register=function e(){var t=this.getId(),n=r[t];if(n&&n!==this){s(t,n,this);o--}r[t]=this;o++};n.prototype.deregister=function e(){var t=this.getId();if(r[t]){if(c){c(t)}delete r[t];o--}};delete a.init;Object.freeze(a)},get size(){return o},all:function(){var e=Object.create(null);return Object.assign(e,r)},get:function(e){n(e==null||typeof e==="string","id must be a string when defined");return e==null?undefined:r[e]},forEach:function(e,t){if(typeof e!=="function"){throw new TypeError(e+" is not a function")}if(t!=null){e=e.bind(t)}for(var n in r){e(r[n],n)}},filter:function(e,t){if(typeof e!=="function"){throw new TypeError(e+" is not a function")}if(t!=null){e=e.bind(t)}var n=[],i;for(i in r){if(e(r[i],i)){n.push(r[i])}}return n}};return a},apply(e,t){const n=i.create(t);n.init(e);e.registry=n}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/AnimationMode", [],function(){"use strict";var i={full:"full",basic:"basic",minimal:"minimal",none:"none"};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Configuration", ["sap/base/assert","sap/base/config","sap/base/Event","sap/base/Log","sap/base/i18n/Formatting","sap/base/i18n/Localization","sap/base/util/Version","sap/ui/base/DesignTime","sap/ui/base/Object","sap/ui/core/AnimationMode","sap/ui/core/ControlBehavior","sap/ui/core/getCompatibilityVersion","sap/ui/core/Locale","sap/ui/core/Supportability","sap/ui/core/Theming","sap/ui/security/Security"],function(e,t,n,a,i,r,o,s,u,g,l,c,p,m,f,d){"use strict";var y=new o("1.136.0");var C;var b;var h;function A(){h=h||{__count:0};h.__count++;return h}function T(){if(h&&--h.__count===0){var e=h;delete h.__count;h=undefined;b?.fireLocalizationChanged(e)}}var S=u.extend("sap.ui.core.Configuration",{constructor:function(){u.call(this);a.error("Configuration is designed as a singleton and should not be created manually! "+"Please require 'sap/ui/core/Configuration' instead and use the module export directly without using 'new'.");return S}});Object.assign(S,{getVersion:function(){return y},getCompatibilityVersion:c,getTheme:f.getTheme,setTheme:function(e){f.setTheme(e);return this},getLanguage:r.getLanguage,setLanguage:function(){r.setLanguage.apply(r,arguments);return S},getLanguageTag:function(){return r.getLanguageTag().toString()},getSAPLogonLanguage:r.getSAPLogonLanguage,getTimezone:r.getTimezone,setTimezone:function(){r.setTimezone.apply(r,arguments);return S},getCalendarType:i.getCalendarType,getCalendarWeekNumbering:i.getCalendarWeekNumbering,getRTL:r.getRTL,setRTL:function(){r.setRTL.apply(r,arguments);return S},getLocale:function(){var e=r.getLanguageTag();return p._getCoreLocale(e)},setCalendarType:function(e){i.setCalendarType.apply(i,arguments);return this},setCalendarWeekNumbering:function(e){i.setCalendarWeekNumbering.apply(i,arguments);return this},getFormatLocale:function(){return i.getLanguageTag().toString()},setFormatLocale:function(e){i.setLanguageTag.apply(i,arguments);return this},getLanguagesDeliveredWithCore:r.getLanguagesDeliveredWithCore,getSupportedLanguages:r.getSupportedLanguages,getAccessibility:l.isAccessibilityEnabled,getAutoAriaBodyRole:function(){return t.get({name:"sapUiAutoAriaBodyRole",type:t.Type.Boolean})},getAnimation:function(){var e=S.getAnimationMode();return e!==S.AnimationMode.minimal&&e!==S.AnimationMode.none},getAnimationMode:l.getAnimationMode,setAnimationMode:l.setAnimationMode,getFiori2Adaptation:function(){var e=t.get({name:"sapUiXxFiori2Adaptation",type:t.Type.StringArray,external:true}),n;if(e.length===0||e.length===1&&e[0]==="false"){n=false}else if(e.length===1&&e[0]==="true"){n=true}return n===undefined?e:n},getDebug:m.isDebugModeEnabled,getInspect:m.isControlInspectorEnabled,getOriginInfo:m.collectOriginInfo,getNoDuplicateIds:function(){return t.get({name:"sapUiNoDuplicateIds",type:t.Type.Boolean,defaultValue:true,external:true})},getUIDPrefix:function(){var e=sap.ui.require("sap/ui/base/ManagedObjectMetadata");return e.getUIDPrefix()},getDesignMode:s.isDesignModeEnabled,getSuppressDeactivationOfControllerCode:s.isControllerCodeDeactivationSuppressed,getControllerCodeDeactivated:s.isControllerCodeDeactivated,getApplication:function(){return t.get({name:"sapUiApplication",type:t.Type.String,external:true})},getRootComponent:function(){return t.get({name:"sapUiRootComponent",type:t.Type.String})},getAppCacheBuster:function(){return t.get({name:"sapUiAppCacheBuster",type:t.Type.StringArray,external:true,freeze:true})},getAppCacheBusterMode:function(){return t.get({name:"sapUiXxAppCacheBusterMode",type:t.Type.String,defaultValue:"sync",external:true,freeze:true})},getDisableCustomizing:function(){return t.get({name:"sapUiXxDisableCustomizing",type:t.Type.Boolean})},getManifestFirst:function(){return t.get({name:"sapUiManifestFirst",type:t.Type.Boolean,external:true})},getFlexibilityServices:function(){var e=sap.ui.require("sap/ui/fl/initial/_internal/FlexConfiguration");var n;if(e){n=e.getFlexibilityServices()}else{const e=[{url:"/sap/bc/lrep",connector:"LrepConnector"}];n=t.get({name:"sapUiFlexibilityServices",type:t=>{if(t&&typeof t==="string"){if(t[0]==="/"){e[0].url=t;t=e}else{t=JSON.parse(t)}}return t||[]},defaultValue:e,external:true})}return n},getFormatSettings:function(){return C},getFrameOptions:d.getFrameOptions,getWhitelistService:d.getAllowlistService,getAllowlistService:d.getAllowlistService,getFileShareSupport:function(){return t.get({name:"sapUiFileShareSupport",type:t.Type.String,defaultValue:undefined})},getStatistics:S.getStatisticsEnabled,getStatisticsEnabled:m.isStatisticsEnabled,getNoNativeScroll:function(){return false},getActiveTerminologies:r.getActiveTerminologies,getSecurityTokenHandlers:d.getSecurityTokenHandlers,setSecurityTokenHandlers:d.setSecurityTokenHandlers,applySettings:function(t){function n(e,t){var i,r;for(i in t){r="set"+i.slice(0,1).toUpperCase()+i.slice(1);if(i==="formatSettings"&&C){n(C,t[i])}else if(typeof e[r]==="function"){e[r](t[i])}else{a.warning("Configuration.applySettings: unknown setting '"+i+"' ignored")}}}e(typeof t==="object","mSettings must be an object");A();n(S,t);T();return this},setCore:function(e){b=e}});S.AnimationMode=g;function L(e,t){if(!e){throw new Error(t)}}var D=u.extend("sap.ui.core.Configuration.FormatSettings",{constructor:function(){u.call(this);this.mSettings={}},getFormatLocale:function(){var e=i.getLanguageTag();return p._getCoreLocale(e)},_set:i._set,getCustomUnits:i.getCustomUnits,setCustomUnits:function(){i.setCustomUnits.apply(i,arguments);return this},addCustomUnits:function(){i.addCustomUnits.apply(i,arguments);return this},setUnitMappings:function(){i.setUnitMappings.apply(i,arguments);return this},addUnitMappings:function(){i.addUnitMappings.apply(i,arguments);return this},getUnitMappings:i.getUnitMappings,getDatePattern:i.getDatePattern,setDatePattern:function(){i.setDatePattern.apply(i,arguments);return this},getTimePattern:i.getTimePattern,setTimePattern:function(){i.setTimePattern.apply(i,arguments);return this},getNumberSymbol:i.getNumberSymbol,setNumberSymbol:function(){i.setNumberSymbol.apply(i,arguments);return this},getCustomCurrencies:i.getCustomCurrencies,setCustomCurrencies:function(){i.setCustomCurrencies.apply(i,arguments);return this},addCustomCurrencies:function(){i.addCustomCurrencies.apply(i,arguments);return this},setFirstDayOfWeek:function(e){L(typeof e=="number"&&e>=0&&e<=6,"iValue must be an integer value between 0 and 6");i._set("weekData-firstDay",e);return this},_setDayPeriods:i._setDayPeriods,getLegacyDateFormat:i.getABAPDateFormat,setLegacyDateFormat:function(){i.setABAPDateFormat.apply(i,arguments);return this},getLegacyTimeFormat:i.getABAPTimeFormat,setLegacyTimeFormat:function(){i.setABAPTimeFormat.apply(i,arguments);return this},getLegacyNumberFormat:i.getABAPNumberFormat,setLegacyNumberFormat:function(){i.setABAPNumberFormat.apply(i,arguments);return this},setLegacyDateCalendarCustomizing:function(){i.setCustomIslamicCalendarData.apply(i,arguments);return this},getLegacyDateCalendarCustomizing:i.getCustomIslamicCalendarData,setTrailingCurrencyCode:function(){i.setTrailingCurrencyCode.apply(i,arguments);return this},getTrailingCurrencyCode:i.getTrailingCurrencyCode,getCustomLocaleData:i.getCustomLocaleData});C=new D(this);r.attachChange(function(e){if(!h&&b){b.fireLocalizationChanged(n.getParameters(e))}else if(h){Object.assign(h,n.getParameters(e))}});i.attachChange(function(e){const t=n.getParameters(e);Object.keys(e).forEach(e=>{if(["ABAPDateFormat","ABAPTimeFormat","ABAPNumberFormat"].includes(e)){t[e.replace("ABAP","legacy")]=t[e];delete t[e]}else if(e==="customIslamicCalendarData"){t["legacyDateCalendarCustomizing"]=t[e];delete t[e]}});if(!h&&b){b.fireLocalizationChanged(t)}else if(h){Object.assign(h,t)}});return S});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/ControlBehavior", ["sap/base/config","sap/base/Eventing","sap/ui/core/AnimationMode"],(e,n,t)=>{"use strict";const a=e.getWritableInstance();const i=new n;const o={attachChange:e=>{i.attachEvent("change",e)},detachChange:e=>{i.detachEvent("change",e)},isAccessibilityEnabled:()=>a.get({name:"sapUiAccessibility",type:e.Type.Boolean,defaultValue:true,external:true}),getAnimationMode:()=>{const n=a.get({name:"sapUiAnimation",type:e.Type.Boolean,defaultValue:undefined,external:true})===false?t.minimal:undefined;return a.get({name:"sapUiAnimationMode",type:t,defaultValue:n??t.full,external:true})},setAnimationMode:n=>{e._.checkEnum(t,n,"animationMode");const i=a.get({name:"sapUiAnimationMode",type:t,defaultValue:undefined,external:true});a.set("sapUiAnimationMode",n);if(i!=n){s({animationMode:n})}}};function s(e){i.fireEvent("change",e)}return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Element", ["../base/DataType","../base/Object","../base/ManagedObject","./ElementHooks","./ElementMetadata","./FocusMode","../Device","sap/ui/dom/findTabbable","sap/ui/performance/trace/Interaction","sap/base/future","sap/base/assert","sap/ui/thirdparty/jquery","sap/ui/events/F6Navigation","sap/ui/util/_enforceNoReturnValue","./RenderManager","./Rendering","./EnabledPropagator","./ElementRegistry","./Theming","sap/ui/core/util/_LocalizationHelper"],function(e,t,i,r,n,o,a,s,l,u,p,jQuery,f,c,g,d,h,y,m,D){"use strict";var v=i.extend("sap.ui.core.Element",{metadata:{stereotype:"element",abstract:true,publicMethods:["getId","getMetadata","getTooltip_AsString","getTooltip_Text","getModel","setModel","hasModel","bindElement","unbindElement","getElementBinding","prop","getLayoutData","setLayoutData"],library:"sap.ui.core",aggregations:{tooltip:{type:"sap.ui.core.TooltipBase",altTypes:["string"],multiple:false},customData:{type:"sap.ui.core.CustomData",multiple:true,singularName:"customData"},layoutData:{type:"sap.ui.core.LayoutData",multiple:false,singularName:"layoutData"},dependents:{type:"sap.ui.core.Element",multiple:true},dragDropConfig:{type:"sap.ui.core.dnd.DragDropBase",multiple:true,singularName:"dragDropConfig"}},associations:{fieldHelpDisplay:{type:"sap.ui.core.Element",multiple:false}}},constructor:function(e,t){i.apply(this,arguments);this._iRenderingDelegateCount=0},renderer:null},n);y.init(v);v.defineClass=function(e,i,r){return t.defineClass(e,i,r||n)};v.prototype.getInterface=function(){return this};v.prototype._handleEvent=function(e){var t=this,i="on"+e.type;function r(r){var n,o,a;if(r&&(o=r.length)>0){r=o===1?r:r.slice();for(n=0;n<o;n++){if(e.isImmediateHandlerPropagationStopped()){return}a=r[n].oDelegate;if(a[i]){a[i].call(r[n].vThis===true?t:r[n].vThis||a,e)}}}}r(this.aBeforeDelegates);if(e.isImmediateHandlerPropagationStopped()){return}if(this[i]){if(e._bNoReturnValue){c(this[i](e),{name:i,component:this.getId()})}else{this[i](e)}}r(this.aDelegates)};v.prototype.init=function(){return undefined};v.prototype.exit=function(){return undefined};v.create=i.create;v.prototype.toString=function(){return"Element "+this.getMetadata().getName()+"#"+this.sId};v.prototype.getDomRef=function(e){return document.getElementById(e?this.getId()+"-"+e:this.getId())};v.prototype.$=function(e){return jQuery(this.getDomRef(e))};v.prototype.isActive=function(){return this.oParent&&this.oParent.isActive()};v.prototype.prop=function(e,t){var i=this.getMetadata().getAllSettings()[e];if(i){if(arguments.length==1){return this[i._sGetter]()}else{this[i._sMutator](t);return this}}};v.prototype.setProperty=function(e,t,r){if(e!="enabled"&&e!="visible"||r){return i.prototype.setProperty.apply(this,arguments)}if(e=="enabled"){var n=this.mProperties.enabled;i.prototype.setProperty.apply(this,arguments);if(n!=this.mProperties.enabled){h.updateDescendants(this)}}else if(e==="visible"){i.prototype.setProperty.apply(this,arguments);if(t===false&&this.getDomRef()?.contains(document.activeElement)){v.fireFocusFail.call(this,o.RENDERING_PENDING)}}return this};function b(e,t){if(e?.contains(document.activeElement)||!jQuery(document.activeElement).is(":sapFocusable")){t?.focus({preventScroll:true})}}v.prototype.onfocusfail=function(e){let t=e._skipArea||e.srcControl.getDomRef();const i=t;let r=this;let n=r.getDomRef();let a;let l;do{if(n?.contains(t)){a=s(t,{scope:n,forward:true,skipChild:true});if(a?.startOver){a=s(t,{scope:n,forward:false})}l=a?.element;if(l===n){break}t=n;r=r?.getParent();n=r?.getDomRef?.()}else{l=n&&jQuery(n).firstFocusableDomRef();break}}while((!a||a.startOver)&&t);if(l){switch(e.mode){case o.SYNC:b(i,l);break;case o.RENDERING_PENDING:d.addPrerenderingTask(()=>{b(i,l)});break;case o.DEFAULT:default:Promise.resolve().then(()=>{b(i,l)});break}}};v.prototype.insertDependent=function(e,t){this.insertAggregation("dependents",e,t,true);return this};v.prototype.addDependent=function(e){this.addAggregation("dependents",e,true);return this};v.prototype.removeDependent=function(e){return this.removeAggregation("dependents",e,true)};v.prototype.removeAllDependents=function(){return this.removeAllAggregation("dependents",true)};v.prototype.destroyDependents=function(){this.destroyAggregation("dependents",true);return this};function E(e){let t=null;for(let i=0;i<e.length;i++){const r=e[i];const n=r?.getDomRef?.();if(n){if(!t){t=n.parentElement}else{while(t&&!t.contains(n)){t=t.parentElement}}}}return t}function A(e,t){const i=e==="KeepDom";const r=this.getDomRef();return e===true||!i&&t||this.isA("sap.ui.core.PopupInterface")||g.isPreservedContent(r)}function _(e,t){let r=null;let n=null;if(Array.isArray(e)){for(let t=0;t<e.length;t++){const i=e[t];const n=i.getDomRef?.();if(n?.contains(document.activeElement)){r=i}}if(r){n=E(e)}}else if(e instanceof i){r=e}if(!r){return}const a=r.getDomRef?.();if(a?.contains?.(document.activeElement)&&!t){const e=A.call(r,t,!this);const i=e?o.SYNC:o.RENDERING_PENDING;if(!this._bIsBeingDestroyed){v.fireFocusFail.call(r,i,this,n)}}}v.prototype.setAggregation=function(e,t,r){const n=this.getAggregation(e);const o=i.prototype.setAggregation.call(this,e,t,r);if(n&&t==null){_.call(this,n,r)}return o};v.prototype.removeAggregation=function(e,t,r){const n=i.prototype.removeAggregation.call(this,e,t,r);_.call(this,n,r);return n};v.prototype.removeAllAggregation=function(e,t){const r=i.prototype.removeAllAggregation.call(this,e,t);_.call(this,r,t);return r};v.prototype.destroyAggregation=function(e,t){const r=this.getAggregation(e);_.call(this,r,t);return i.prototype.destroyAggregation.call(this,e,t)};v.prototype.rerender=function(){if(this.oParent){this.oParent.rerender()}};v.prototype.getUIArea=function(){return this.oParent?this.oParent.getUIArea():null};v.fireFocusFail=function(e,t,i){const r=jQuery.Event("focusfail");r.srcControl=this;r.mode=e||o.DEFAULT;r._skipArea=i;t??=this.getParent();if(t&&!t._bIsBeingDestroyed){t._handleEvent?.(r)}};v.prototype.destroy=function(e){if(this.bIsDestroyed){return}var t=!this.getParent();x(this);i.prototype.destroy.call(this,e);this.data=P;var r=this.getDomRef();if(!r){return}if(A.call(this,e,t)){jQuery(r).remove()}else{r.removeAttribute("data-sap-ui-preserve");if(e!=="KeepDom"){r.id="sap-ui-destroyed-"+this.getId();for(var n=0,o=r.querySelectorAll('[id^="'+this.getId()+'-"]');n<o.length;n++){o[n].id="sap-ui-destroyed-"+o[n].id}}}};v.prototype.fireEvent=function(e,t,n,o){if(this.hasListeners(e)){l.notifyStepStart(e,this)}if(typeof t==="boolean"){o=n;n=t;t=null}t=t||{};t.id=t.id||this.getId();r.interceptEvent?.(e,this,t);return i.prototype.fireEvent.call(this,e,t,n,o)};function T(e,t,i){if(t.canSkipRendering||!(t.onAfterRendering||t.onBeforeRendering)){return}e._iRenderingDelegateCount+=i||-1;if(e.bOutput===true&&e._iRenderingDelegateCount==i){g.canSkipRendering(e,1)}}v.prototype.hasRenderingDelegate=function(){return Boolean(this._iRenderingDelegateCount)};v.prototype.addDelegate=function(e,t,i,r){p(e,"oDelegate must be not null or undefined");if(!e){return this}this.removeDelegate(e);if(typeof t==="object"){r=i;i=t;t=false}if(typeof i==="boolean"){r=i;i=undefined}(t?this.aBeforeDelegates:this.aDelegates).push({oDelegate:e,bClone:!!r,vThis:i===this?true:i});T(this,e,1);return this};v.prototype.removeDelegate=function(e){var t;for(t=0;t<this.aDelegates.length;t++){if(this.aDelegates[t].oDelegate==e){this.aDelegates.splice(t,1);T(this,e,0);t--}}for(t=0;t<this.aBeforeDelegates.length;t++){if(this.aBeforeDelegates[t].oDelegate==e){this.aBeforeDelegates.splice(t,1);T(this,e,0);t--}}return this};v.prototype.addEventDelegate=function(e,t){return this.addDelegate(e,false,t,true)};v.prototype.removeEventDelegate=function(e){return this.removeDelegate(e)};v.prototype.getFocusDomRef=function(){return this.getDomRef()||null};function C(e,t){if(t[0]>e[1]||e[0]>t[1]){return null}else{return[Math.max(e[0],t[0]),Math.min(e[1],t[1])]}}v.prototype.isFocusable=function(){var e=this.getFocusDomRef();if(!e){return false}var t=e;var i=[[0,window.innerWidth],[0,window.innerHeight]];var r;var n;while(!r||!n){var o=t.getBoundingClientRect();r=C(i[0],[o.x,o.x+o.width]);n=C(i[1],[o.y,o.y+o.height]);if(t.assignedSlot){t=t.assignedSlot}if(t.parentElement){t=t.parentElement}else if(t.parentNode&&t.parentNode.nodeType===Node.DOCUMENT_FRAGMENT_NODE){t=t.parentNode.host}else{break}}var a=document.elementsFromPoint(Math.floor((r[0]+r[1])/2),Math.floor((n[0]+n[1])/2));var s=a.findIndex(function(t){return t.contains(e)});var l=a.findIndex(function(e){return e.classList.contains("sapUiBLy")||e.classList.contains("sapUiBlockLayer")});if(l!==-1&&s>l){return false}return jQuery(e).is(":sapFocusable")};function R(e){var t,i=[];t=e.parentNode;while(t){i.push({node:t,scrollLeft:t.scrollLeft,scrollTop:t.scrollTop});t=t.parentNode}return i}function I(e){e.forEach(function(e){var t=e.node;if(t.scrollLeft!==e.scrollLeft){t.scrollLeft=e.scrollLeft}if(t.scrollTop!==e.scrollTop){t.scrollTop=e.scrollTop}})}v.prototype.focus=function(e){var t=this.getFocusDomRef(),i=[];if(!t){return}if(jQuery(t).is(":sapFocusable")){e=e||{};if(a.browser.safari){if(e.preventScroll===true){i=R(t)}t.focus();if(i.length>0){setTimeout(I.bind(null,i),0)}}else{t.focus(e)}}else{const e=this.getDomRef();if(e&&!e.contains(document.activeElement)){v.fireFocusFail.call(this,o.DEFAULT)}}};v.prototype.getFocusInfo=function(){return{id:this.getId()}};v.prototype.applyFocusInfo=function(e){this.focus(e);return this};v.prototype._refreshTooltipBaseDelegate=function(e){var i=this.getTooltip();if(t.isObjectA(i,"sap.ui.core.TooltipBase")){this.removeDelegate(i)}if(t.isObjectA(e,"sap.ui.core.TooltipBase")){e._currentControl=this;this.addDelegate(e)}};v.prototype.setTooltip=function(e){this._refreshTooltipBaseDelegate(e);this.setAggregation("tooltip",e);return this};v.prototype.getTooltip=function(){return this.getAggregation("tooltip")};v.runWithPreprocessors=i.runWithPreprocessors;v.prototype.getTooltip_AsString=function(){var e=this.getTooltip();if(typeof e==="string"||e instanceof String){return e}return undefined};v.prototype.getTooltip_Text=function(){var e=this.getTooltip();if(e&&typeof e.getText==="function"){return e.getText()}return e};var S=v.extend("sap.ui.core.CustomData",{metadata:{library:"sap.ui.core",properties:{key:{type:"string",defaultValue:null},value:{type:"any",defaultValue:null},writeToDom:{type:"boolean",defaultValue:false}},designtime:"sap/ui/core/designtime/CustomData.designtime"}});S.prototype.setValue=function(e){this.setProperty("value",e,true);var t=this.getParent();if(t&&t.getDomRef()){var i=this._checkWriteToDom(t);if(i){t.$().attr(i.key,i.value)}}return this};S.prototype._checkWriteToDom=function(t){if(!this.getWriteToDom()){return null}var i=this.getKey();var r=this.getValue();function n(e){u.errorThrows("CustomData with key "+i+" should be written to HTML of "+t+" but "+e);return null}if(typeof r!="string"){return n("the value is not a string.")}var o=e.getType("sap.ui.core.ID");if(!o.isValid(i)||i.indexOf(":")!=-1){return n("the key is not valid (must be a valid sap.ui.core.ID without any colon).")}if(i==f.fastNavigationKey){r=/^\s*(x|true)\s*$/i.test(r)?"true":"false"}else if(i.indexOf("sap-ui")==0){return n("the key is not valid (may not start with 'sap-ui').")}return{key:"data-"+i,value:r}};function N(e,t){var i=e.getAggregation("customData");if(i){for(var r=0;r<i.length;r++){if(i[r].getKey()==t){return i[r]}}}return null}function w(e,t,i,r){var n=N(e,t);if(i===null){if(!n){return}var o=e.getAggregation("customData").length;if(o==1){e.destroyAggregation("customData",true)}else{e.removeAggregation("customData",n,true);n.destroy()}}else if(n){n.setValue(i);n.setWriteToDom(r)}else{e.addAggregation("customData",new S({key:t,value:i,writeToDom:r}),true)}}v.prototype.data=function(){var e=arguments.length;if(e==0){var t=this.getAggregation("customData"),i={};if(t){for(var r=0;r<t.length;r++){i[t[r].getKey()]=t[r].getValue()}}return i}else if(e==1){var n=arguments[0];if(n===null){this.destroyAggregation("customData",true);return this}else if(typeof n=="string"){var o=N(this,n);return o?o.getValue():null}else if(typeof n=="object"){for(var a in n){w(this,a,n[a])}return this}else{throw new TypeError("When data() is called with one argument, this argument must be a string, an object or null, but is "+typeof n+":"+n+" (on UI Element with ID '"+this.getId()+"')")}}else if(e==2){w(this,arguments[0],arguments[1]);return this}else if(e==3){w(this,arguments[0],arguments[1],arguments[2]);return this}else{throw new TypeError("data() may only be called with 0-3 arguments (on UI Element with ID '"+this.getId()+"')")}};v.getMetadata().getAggregation("customData").defaultClass=S;function P(){var e=arguments.length;if(e===1&&arguments[0]!==null&&typeof arguments[0]=="object"||e>1&&e<4&&arguments[1]!==null){u.errorThrows("Cannot create custom data on an already destroyed element '"+this+"'");return this}return v.prototype.data.apply(this,arguments)}v.prototype.clone=function(e,t){var r=i.prototype.clone.apply(this,arguments);for(var n=0;n<this.aDelegates.length;n++){if(this.aDelegates[n].bClone){r.aDelegates.push(this.aDelegates[n])}}for(var o=0;o<this.aBeforeDelegates.length;o++){if(this.aBeforeDelegates[o].bClone){r.aBeforeDelegates.push(this.aBeforeDelegates[o])}}if(this._sapui_declarativeSourceInfo){r._sapui_declarativeSourceInfo=Object.assign({},this._sapui_declarativeSourceInfo)}return r};v.prototype.findElements=i.prototype.findAggregatedObjects;function F(e){var t=e.getParent();if(t){var i=jQuery.Event("LayoutDataChange");i.srcControl=e;t._handleEvent(i)}}v.prototype.setLayoutData=function(e){this.setAggregation("layoutData",e,true);F(this);return this};v.prototype.destroyLayoutData=function(){this.destroyAggregation("layoutData",true);F(this);return this};v.prototype.bindElement=i.prototype.bindObject;v.prototype.unbindElement=i.prototype.unbindObject;v.prototype.getElementBinding=i.prototype.getObjectBinding;v.prototype._getFieldGroupIds=function(){var e;if(this.getMetadata().hasProperty("fieldGroupIds")){e=this.getFieldGroupIds()}if(!e||e.length==0){var t=this.getParent();if(t&&t._getFieldGroupIds){return t._getFieldGroupIds()}}return e||[]};v.prototype.getDomRefForSetting=function(e){var t=this.getMetadata().getAllSettings()[e];if(t&&t.selector){var i=this.getDomRef();if(i){i=i.parentNode;if(i&&i.querySelector){var r=t.selector.replace(/\{id\}/g,this.getId().replace(/(:|\.)/g,"\\$1"));return i.querySelector(r)}}}return null};v.prototype._getMediaContainerWidth=function(){if(typeof this._oContextualSettings==="undefined"){return undefined}return this._oContextualSettings.contextualWidth};v.prototype._getCurrentMediaContainerRange=function(e){var t=this._getMediaContainerWidth();e=e||a.media.RANGESETS.SAP_STANDARD;return a.media.getCurrentRange(e,t)};v.prototype._onContextualSettingsChanged=function(){var e=this._getMediaContainerWidth(),t=e!==undefined,i=t^!!this._bUsingContextualWidth,r=this._aContextualWidthListeners||[];if(i){if(t){r.forEach(function(e){a.media.detachHandler(e.callback,e.listener,e.name)})}else{r.forEach(function(e){a.media.attachHandler(e.callback,e.listener,e.name)})}this._bUsingContextualWidth=t}r.forEach(function(e){var t=this._getCurrentMediaContainerRange(e.name);if(t&&t.from!==e.media.from){e.media=t;e.callback.call(e.listener||window,t)}},this)};v.prototype._attachMediaContainerWidthChange=function(e,t,i){i=i||a.media.RANGESETS.SAP_STANDARD;this._aContextualWidthListeners=this._aContextualWidthListeners||[];this._aContextualWidthListeners.push({callback:e,listener:t,name:i,media:this._getCurrentMediaContainerRange(i)});if(!this._bUsingContextualWidth){a.media.attachHandler(e,t,i)}};v.prototype._detachMediaContainerWidthChange=function(e,t,i){var r;i=i||a.media.RANGESETS.SAP_STANDARD;if(!this._aContextualWidthListeners){return}for(var n=0,o=this._aContextualWidthListeners.length;n<o;n++){r=this._aContextualWidthListeners[n];if(r.callback===e&&r.listener===t&&r.name===i){if(!this._bUsingContextualWidth){a.media.detachHandler(e,t,i)}this._aContextualWidthListeners.splice(n,1);break}}};let M;function x(e){M??=sap.ui.require("sap/ui/core/FocusHandler");M?.updateControlFocusInfo(e)}v.closestTo=function(e,t){var i="[data-sap-ui]",r,n;if(e===undefined||e===null){return undefined}if(typeof e==="string"){r=document.querySelector(e)}else if(typeof e==="object"&&e.nodeType===Node.ELEMENT_NODE&&typeof e.nodeName==="string"){r=e}else if(e.jquery){r=e[0];u.errorThrows("Do not call Element.closestTo() with jQuery object as parameter. The function should be called with either a DOM Element or a CSS selector.")}else{throw new TypeError("Element.closestTo accepts either a DOM element or a CSS selector string as parameter, but not '"+e+"'")}if(t){i+=",[data-sap-ui-related]"}r=r&&r.closest(i);if(r){if(t){n=r.getAttribute("data-sap-ui-related")}n=n||r.getAttribute("id")}return v.getElementById(n)};v.getElementById=y.get;v.getActiveElement=()=>{try{var e=jQuery(document.activeElement);if(e.is(":focus")){return v.closestTo(e[0])}}catch(e){}};v.registry=y;m.attachApplied(function(e){var t=jQuery.Event("ThemeChanged");t.theme=e.theme;y.forEach(function(e){t._bNoReturnValue=true;e._handleEvent(t)})});D.registerForUpdate("Elements",y.all);return v});
/*
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/ElementHooks", [],function(){"use strict";const n={interceptEvent:null};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/ElementMetadata", ["sap/base/Log","sap/base/util/ObjectPath","sap/ui/base/ManagedObjectMetadata","sap/ui/core/Lib","sap/ui/core/Renderer"],function(e,t,r,n,i){"use strict";var o=function(e,t){r.apply(this,arguments)};o.prototype=Object.create(r.prototype);o.prototype.constructor=o;o.uid=r.uid;o.prototype.getElementName=function(){return this._sClassName};o.prototype.getRendererName=function(){return this._sRendererName};o.prototype.getRenderer=function(){if(this._oRenderer){return this._oRenderer}var r=this.getRendererName();if(!r){return undefined}this._oRenderer=sap.ui.require(r.replace(/\./g,"/"));(()=>{if(!this._oRenderer){this._oRenderer=t.get(r)}if(!this._oRenderer){e.warning("Synchronous loading of Renderer for control class '"+this.getName()+"', due to missing Renderer dependency.","SyncXHR",null,function(){return{type:"SyncXHR",name:r}});this._oRenderer=sap.ui.requireSync(r.replace(/\./g,"/"))||t.get(r)}})();return this._oRenderer};o.prototype.applySettings=function(e){var n=e.metadata;this._sVisibility=n.visibility||"public";var a=Object.hasOwn(e,"renderer")?e.renderer||"":undefined;delete e.renderer;r.prototype.applySettings.call(this,e);var d=this.getParent();this._sRendererName=this.getName()+"Renderer";this.dnd=Object.assign({draggable:false,droppable:false},d.dnd,typeof n.dnd=="boolean"?{draggable:n.dnd,droppable:n.dnd}:n.dnd);if(typeof a!=="undefined"){if(typeof a==="string"){this._sRendererName=a||undefined;return}if((typeof a==="object"||typeof a==="function")&&typeof a.render==="function"){var s=sap.ui.require(this.getRendererName().replace(/\./g,"/"));if(!s){s=t.get(this.getRendererName())}if(s===a){this._oRenderer=a;return}if(s===undefined&&typeof a.extend==="function"){t.set(this.getRendererName(),a);this._oRenderer=a;return}}if(typeof a==="function"){a={render:a}}var p;if(d instanceof o){p=d.getRenderer()}this._oRenderer=i.extend.call(p||i,this.getRendererName(),a)}};o.prototype.afterApplySettings=function(){r.prototype.afterApplySettings.apply(this,arguments);n._registerElement(this)};o.prototype.isHidden=function(){return this._sVisibility==="hidden"};var a=o.prototype.metaFactoryAggregation;function d(e,t,r){a.apply(this,arguments);this.dnd=Object.assign({draggable:false,droppable:false,layout:"Vertical"},typeof r.dnd=="boolean"?{draggable:r.dnd,droppable:r.dnd}:r.dnd)}d.prototype=Object.create(a.prototype);d.prototype.constructor=d;o.prototype.metaFactoryAggregation=d;o.prototype.getDragDropInfo=function(e){if(!e){return this.dnd}var t=this._mAllAggregations[e]||this._mAllPrivateAggregations[e];if(!t){return{}}return t.dnd};return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/ElementRegistry", ["sap/base/Log","sap/ui/base/ManagedObjectRegistry","sap/ui/core/Configuration"],(e,t,r)=>{"use strict";const i=function(t,i,a){if(i._sapui_candidateForDestroy){e.debug("destroying dangling template "+i+" when creating new object with same ID");i.destroy()}else{var n="adding element with duplicate id '"+t+"'";if(!r.getNoDuplicateIds()){e.warning(n);return}e.error(n);throw new Error("Error: "+n)}};const a=t.create({onDuplicate:i});return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/EnabledPropagator", ["./FocusMode"],function(e){"use strict";let t;var a=function(a,i){if(!this.isA||!this.isA("sap.ui.core.Control")){throw new Error("EnabledPropagator only supports subclasses of Control")}this._bUseEnabledPropagator=true;var s=this.getEnabled;if(s===undefined){this.getEnabled=function(){return this._bUseEnabledPropagator&&n(this)?false:this.getProperty("enabled")};a=a===undefined?true:Boolean(a);if(i){this.getMetadata().addProperty("Enabled",{type:"boolean",group:"Behavior",defaultValue:a})}this.getMetadata().addProperty("enabled",{type:"boolean",group:"Behavior",defaultValue:a});this.getMetadata().addPublicMethods("getEnabled")}else{this.getEnabled=function(){return this._bUseEnabledPropagator&&n(this)?false:s.apply(this,arguments)}}if(this.setEnabled===undefined){this.setEnabled=function(a){this.setProperty("enabled",a);if(!a&&this.getDomRef()?.contains(document.activeElement)){t??=sap.ui.require("sap/ui/core/Element");t?.fireFocusFail.call(this,e.RENDERING_PENDING)}return this};this.getMetadata().addPublicMethods("setEnabled")}else{var r=this.setEnabled;this.setEnabled=function(a){r.apply(this,arguments);if(!a&&this.getDomRef()?.contains(document.activeElement)){t??=sap.ui.require("sap/ui/core/Element");t?.fireFocusFail.call(this,e.RENDERING_PENDING)}return this}}this.useEnabledPropagator=function(e){this._bUseEnabledPropagator=e};this.getMetadata().addPublicMethods("useEnabledPropagator")};a.updateDescendants=function(e){e.isActive()&&e.findElements(true,function(e){if(e._bUseEnabledPropagator&&e.bOutput==true){e.invalidate()}})};function n(e){let t;for(t=e.getParent();t&&!t.getEnabled&&t.getParent;t=t.getParent()){}return t&&t.getEnabled&&!t.getEnabled()}return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/FocusHandler", ["../base/EventProvider","../base/Object","sap/base/Log","sap/ui/core/UIAreaRegistry","sap/ui/thirdparty/jquery","sap/ui/dom/_ready"],function(t,o,e,n,jQuery,r){"use strict";var s;var u;var i;var a=new t;var c="focusInfo";var l={};var f=o.extend("sap.ui.core.FocusHandler",{constructor:function(){o.apply(this);this.oCurrent=null;this.oLast=null;this.aEventQueue=[];this.oLastFocusedControlInfo=null;this.oPatchingControlFocusInfo=null;this.fnEventHandler=this.onEvent.bind(this);r().then(function(){var t=document.body;t.addEventListener("focus",this.fnEventHandler,true);t.addEventListener("blur",this.fnEventHandler,true);e.debug("FocusHandler setup on Root "+t.type+(t.id?": "+t.id:""),null,"sap.ui.core.FocusHandler")}.bind(this))}});f.prototype.getControlFocusInfo=function(t){var o;s??=sap.ui.require("sap/ui/core/Element");t=t||s?.getActiveElement()?.getId();if(!t){return null}o=p(t);if(o){return{id:t,control:o,info:o.getFocusInfo(),type:o.getMetadata().getName(),focusref:o.getFocusDomRef()}}return null};f.prototype.storePatchingControlFocusInfo=function(t){var o=document.activeElement;if(!o||!t.contains(o)){this.oPatchingControlFocusInfo=null}else{this.oPatchingControlFocusInfo=this.getControlFocusInfo();if(this.oPatchingControlFocusInfo){this.oPatchingControlFocusInfo.patching=true}}};f.prototype.getPatchingControlFocusInfo=function(){return this.oPatchingControlFocusInfo};f.prototype.updateControlFocusInfo=function(t){if(t&&this.oLastFocusedControlInfo&&this.oLastFocusedControlInfo.control===t){var o=t.getId();this.oLastFocusedControlInfo=this.getControlFocusInfo(o);e.debug("Update focus info of control "+o,null,"sap.ui.core.FocusHandler")}};f.prototype.addFocusInfoExtender=function(t,o){a.attachEvent(c,l,t,o);return this};f.prototype.removeFocusInfoExtender=function(t,o){a.detachEvent(c,t,o);return this};f.prototype.restoreFocus=function(t){var o=t||this.oLastFocusedControlInfo;if(!o){return}var n=p(o.id);var r=o.focusref;if(n&&o.info&&n.getMetadata().getName()==o.type&&(o.patching||n.getFocusDomRef()!=r&&(t||n!==o.control||o.preserved))){e.debug("Apply focus info of control "+o.id,null,"sap.ui.core.FocusHandler");o.control=n;this.oLastFocusedControlInfo=o;delete this.oLastFocusedControlInfo.patching;l.info=o.info;a.fireEvent(c,{domRef:n.getDomRef()});n.applyFocusInfo(l.info);Object.keys(l).forEach(function(t){delete l[t]})}else{e.debug("Apply focus info of control "+o.id+" not possible",null,"sap.ui.core.FocusHandler")}};f.prototype.destroy=function(t){var o=t.data.oRootRef;if(o){o.removeEventListener("focus",this.fnEventHandler,true);o.removeEventListener("blur",this.fnEventHandler,true)}};f.prototype.onEvent=function(t){var o=jQuery.event.fix(t);e.debug("Event "+o.type+" reached Focus Handler (target: "+o.target+(o.target?o.target.id:"")+")",null,"sap.ui.core.FocusHandler");var n=o.type=="focus"||o.type=="focusin"?"focus":"blur";this.aEventQueue.push({type:n,controlId:d(o.target)});if(this.aEventQueue.length==1){this.processEvent()}};f.prototype.processEvent=function(){var t=this.aEventQueue[0];if(!t){return}try{if(t.type=="focus"){this.onfocusEvent(t.controlId)}else if(t.type=="blur"){this.onblurEvent(t.controlId)}}finally{this.aEventQueue.shift();if(this.aEventQueue.length>0){this.processEvent()}}};f.prototype.onfocusEvent=function(t){var o=p(t);if(o){this.oLastFocusedControlInfo=this.getControlFocusInfo(t);e.debug("Store focus info of control "+t,null,"sap.ui.core.FocusHandler")}this.oCurrent=t;if(!this.oLast){return}if(this.oLast!=this.oCurrent){h(this.oLast,t)}this.oLast=null};f.prototype.onblurEvent=function(t){if(!this.oCurrent){return}this.oLast=t;this.oCurrent=null;setTimeout(this["checkForLostFocus"].bind(this),0)};f.prototype.checkForLostFocus=function(){if(this.oCurrent==null&&this.oLast!=null){h(this.oLast,null)}this.oLast=null};f.prototype.trackFocusForPreservedElement=function(t){if(t.contains(document.activeElement)&&this.oLastFocusedControlInfo&&document.activeElement===this.oLastFocusedControlInfo.focusref){this.oLastFocusedControlInfo.preserved=true}};var d=function(t){var o=jQuery(t).closest("[data-sap-ui]").attr("id");if(o){return o}return null};var h=function(t,o){var e=p(t);if(e){var n=jQuery.Event("sapfocusleave");n.target=e.getDomRef();var r=p(o);n.relatedControlId=r?r.getId():null;n.relatedControlFocusInfo=r?r.getFocusInfo():null;u=u||sap.ui.require("sap/ui/core/UIArea");if(u){var s=e.getUIArea();var a=null;if(s){a=s}else{i=i||sap.ui.require("sap/ui/core/StaticArea");if(i){var c=i.getDomRef();if(c.contains(n.target)){a=i.getUIArea()}}}if(a){a._handleEvent(n)}}}};function p(t){var o;if(!s){s=sap.ui.require("sap/ui/core/Element")}if(s){o=s.getElementById(t)}return o||null}return new f});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/FocusMode", [],function(){"use strict";const n={SYNC:"sync",RENDERING_PENDING:"rendering_pending",DEFAULT:"default"};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/InvisibleRenderer", [],function(){"use strict";var e={apiVersion:2};e.PlaceholderPrefix="sap-ui-invisible-";e.createInvisiblePlaceholderId=function(e){return this.PlaceholderPrefix+e.getId()};e.getDomRef=function(e){return document.getElementById(this.createInvisiblePlaceholderId(e))};e.render=function(e,i,r){var t=this.createInvisiblePlaceholderId(i);r=r||"span";e.openStart(r,t);e.attr("data-sap-ui",t);e.attr("aria-hidden","true");e.class("sapUiHiddenPlaceholder");e.openEnd(true);e.close(r)};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/LabelEnablement", ["../base/ManagedObject","sap/base/assert"],function(e,t){"use strict";var r={};const n={};var i;function a(e,t){if(!e){return null}i??=sap.ui.require("sap/ui/core/Element");var r=i.getElementById(e);if(r&&t&&(!r.isA("sap.ui.core.Control")||r.getDomRef())){r.invalidate()}return r}function l(e,t){const r=e.getLabelFor()||e._sAlternativeId||"";const n={controlId:r};i??=sap.ui.require("sap/ui/core/Element");const a=i.getElementById(r);if(a&&typeof a.getIdForLabel==="function"){const l=a.getIdForLabel();if(l!==a.getId()){const o=document.getElementById(l);if(!o){const r={onAfterRendering:function(e){this.removeEventDelegate(r);if(typeof t==="function"&&!e.bIsDestroyed){t(e)}}.bind(a,e)};a.addEventDelegate(r)}else{const e=i.closestTo(o);const t=e.getId();if(t!==r){n.innerControlId=t}}}}return n}function o(e,t,i){var s=e.getId();var u=e.__sLabeledControl;var d=t?null:l(e,e=>{if(!i){o(e,false,true)}});if(d&&u===d.controlId&&d.innerControlId===n[d.controlId]){return}if(!t){e.invalidate()}if(d?.controlId){e.__sLabeledControl=d.controlId}else{delete e.__sLabeledControl}var f;if(u){f=r[u];if(f){const e=n[u];f=f.filter(function(e){return e!=s});if(f.length){r[u]=f;if(e){r[e]=f}}else{delete r[u];if(e){delete r[e];delete n[u]}}}}if(d?.controlId){f=r[d.controlId]||[];f.push(s);r[d.controlId]=f;if(d.innerControlId){r[d.innerControlId]=f;n[d.controlId]=d.innerControlId}else{const e=n[d.controlId];if(e){delete r[e];delete n[d.controlId]}}}var c=a(u,true);var g=a(d?.controlId,true);if(c){e.detachRequiredChange(c)}if(g){e.attachRequiredChange(g)}}function s(e){if(!e){throw new Error("sap.ui.core.LabelEnablement cannot enrich null")}var t=e.getMetadata();if(!t.isInstanceOf("sap.ui.core.Label")){throw new Error("sap.ui.core.LabelEnablement only supports Controls with interface sap.ui.core.Label")}var r=t.getAssociation("labelFor");if(!r||r.multiple){throw new Error("sap.ui.core.LabelEnablement only supports Controls with a to-1 association 'labelFor'")}}function u(e){if(!e){return true}if(e.isA("sap.ui.core.ILabelable")){return e.hasLabelableHTMLElement()}return true}var d={};d.writeLabelForAttribute=function(e,t){if(!t){return}const r=l(t,e=>{e.invalidate()});if(!r.controlId){return}i??=sap.ui.require("sap/ui/core/Element");const n=i.getElementById(r.innerControlId||r.controlId);if(n&&typeof n.getIdForLabel==="function"&&u(n)){e.attr("for",n.getIdForLabel())}};d.getReferencingLabels=function(e){var t=e?e.getId():null;if(!t){return[]}return r[t]||[]};d._getLabelTexts=function(e){const t={};const r=e.getFieldHelpInfo?.();if(r?.label){t.label=r.label}let n=d.getReferencingLabels(e);if(n.length){t.labelledby=n}if(e.getMetadata().getAssociation("ariaLabelledBy")){n=e.getAriaLabelledBy();if(n.length){t.labelledby??=[];n.forEach(e=>{if(!t.labelledby.includes(e)){t.labelledby.push(e)}})}}if(t.labelledby?.length){t.labelledby=t.labelledby.join(" ")}e.getParent()?.enhanceAccessibilityState?.(e,t);const a=t.label?[t.label]:[];if(t.labelledby){t.labelledby.split(" ").forEach(e=>{const t=i.getElementById(e);if(t){const e=t.getText?.()||t.getDomRef()?.innerText;if(e){a.push(e)}}})}return a};d.isRequired=function(e){if(f(e)){return true}var t=d.getReferencingLabels(e),r;i??=sap.ui.require("sap/ui/core/Element");for(var n=0;n<t.length;n++){r=i.getElementById(t[n]);if(f(r)){return true}}return false};function f(e){return!!(e&&e.getRequired&&e.getRequired())}d.enrich=function(n){s(n);n.__orig_setLabelFor=n.setLabelFor;n.setLabelFor=function(e){var t=this.__orig_setLabelFor.apply(this,arguments);o(this);return t};n.__orig_exit=n.exit;n.exit=function(){this._sAlternativeId=null;o(this,true);if(n.__orig_exit){n.__orig_exit.apply(this,arguments)}};n.setAlternativeLabelFor=function(r){if(r instanceof e){r=r.getId()}else if(r!=null&&typeof r!=="string"){t(false,"setAlternativeLabelFor(): sId must be a string, an instance of sap.ui.base.ManagedObject or null");return this}this._sAlternativeId=r;o(this);return this};n.getLabelForRendering=function(){var e=this.getLabelFor()||this._sAlternativeId;var t=a(e);var r;i??=sap.ui.require("sap/ui/core/Element");if(t&&!t.isA("sap.ui.core.ILabelable")&&t.getIdForLabel&&t.getIdForLabel()){r=i.getElementById(t.getIdForLabel());if(r){t=r}}return u(t)?e:""};n.isLabelFor=function(e){var t=e.getId();var n=r[t];return n&&n.indexOf(this.getId())>-1};if(!n.getMetadata().getProperty("required")){return}n.__orig_setRequired=n.setRequired;n.setRequired=function(e){var t=this.getRequired(),r=this.__orig_setRequired.apply(this,arguments);if(this.getRequired()!==t){a(this.__sLabeledControl,true)}return r};n.isRequired=function(){var e=a(this.getLabelForRendering(),false);return f(this)||f(e)};n.isDisplayOnly=function(){if(this.getDisplayOnly){return this.getDisplayOnly()}else{return false}};n.isWrapping=function(){if(this.getWrapping){return this.getWrapping()}else{return false}};n.disableRequiredChangeCheck=function(e){this._bNoRequiredChangeCheck=e};n.attachRequiredChange=function(e){if(e&&!this._bNoRequiredChangeCheck){if(e.getMetadata().getProperty("required")){e.attachEvent("_change",l,this)}this._bRequiredAttached=true}};n.detachRequiredChange=function(e){if(e&&!this._bNoRequiredChangeCheck){if(e.getMetadata().getProperty("required")){e.detachEvent("_change",l,this)}this._bRequiredAttached=false}};function l(e){if(e.getParameter("name")=="required"){this.invalidate()}}n.__orig_onAfterRendering=n.onAfterRendering;n.onAfterRendering=function(e){var t;if(this.__orig_onAfterRendering){t=this.__orig_onAfterRendering.apply(this,arguments)}if(!this._bNoRequiredChangeCheck&&!this._bRequiredAttached&&this.__sLabeledControl){var r=a(this.__sLabeledControl,false);this.attachRequiredChange(r)}return t}};return d},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Lib", ["sap/base/assert","sap/base/config","sap/base/i18n/Localization","sap/base/i18n/ResourceBundle","sap/base/future","sap/base/Log","sap/base/util/deepExtend","sap/base/util/isEmptyObject","sap/base/util/isPlainObject","sap/base/util/LoaderExtensions","sap/base/util/fetch","sap/base/util/mixedFetch","sap/base/util/ObjectPath","sap/base/util/Version","sap/base/util/array/uniqueSort","sap/ui/Global","sap/ui/VersionInfo","sap/ui/base/DataType","sap/ui/base/EventProvider","sap/ui/base/Object","sap/ui/base/SyncPromise","sap/ui/core/_UrlResolver","sap/ui/core/Supportability"],function(e,n,t,r,i,a,s,o,u,l,c,f,d,p,h,y,g,m,b,v,_,S,j){"use strict";var L={};var w={};var T=new Set(["sap.suite.ui.generic.template","sap.ui.comp","sap.ui.layout","sap.ui.unified"]);function P(e,n){return sap.ui.require.toUrl(e.replace(/\./g,"/")+n)}function O(e,n){l.registerResourcePath(e.replace(/\./g,"/"),n)}function E(e,n){var t=e.modules,r=function(e){return/^jquery\.sap\./.test(e)?e:e.replace(/\./g,"/")};if(p(e.version||"1.0").compareTo("2.0")<0){t={};for(var i in e.modules){t[r(i)+".js"]=e.modules[i]}}sap.ui.require.preload(t,e.name,n)}var C={};n.get({name:"sapUiXxLibraryPreloadFiles",type:n.Type.StringArray,external:true}).forEach(function(e){var n=String(e).trim().split(/\s*:\s*/),t=n[0],r=n[1];if(n.length===1){r=t;t=""}if(/^(?:none|js|json|both)$/.test(r)){C[t]=r}});var x=[];var B;function M(e){var n=sap.ui.require("sap/ui/core/theming/ThemeManager");if(!B){if(!n){B=new Promise(function(e,n){sap.ui.require(["sap/ui/core/theming/ThemeManager"],function(n){e(n)},n)})}else{B=Promise.resolve(n)}}if(n&&e){n.reset()}return B}var R=Symbol("sap.ui.core.Lib");var z={configurable:true,enumerable:true,writable:false};function A(e){z.value=e;return z}function F(e){if(e&&typeof e==="object"&&!Object.isFrozen(e)){Object.freeze(e);for(var n in e){if(Object.hasOwn(e,n)){F(e[n])}}}}function q(){var e=n.get({name:"sapUiPreloadLibCss",type:n.Type.StringArray,external:true});if(e.length>0){if(e[0].startsWith("!")){e[0]=e[0].slice(1)}if(e[0]==="*"){e.shift();Object.keys(L).forEach(function(n){if(!e.includes(n)){e.unshift(n)}})}}return e}var k=v.extend("sap.ui.core.Lib",{constructor:function(n){v.call(this);e(typeof n==="object","A settings object must be given to the constructor of sap/ui/core/Lib");e(typeof n.name==="string"&&n.name,"The settings object that is given to the constructor of sap/ui/core/Lib must contain a 'name' property which is a non-empty string");if(n._key!==R){throw new Error("The constructor of sap/ui/core/Lib is restricted to the internal usage. To get an instance of Library with name '"+n.name+"', use the static method 'get' from sap/ui/core/Lib instead.")}this.name=n.name;var t=["dependencies","types","interfaces","controls","elements"];t.forEach(function(e){Object.defineProperty(this,e,A([]))}.bind(this));Object.defineProperty(this,"_resourceBundles",{value:{},writable:true});Object.defineProperty(this,"_loadingStatus",{value:null,writable:true});Object.defineProperty(this,"_settingsEnhanced",{value:false,writable:true});Object.defineProperty(this,"_manifestFailed",{value:false,writable:true})},getInterface:function(){return this},isSettingsEnhanced:function(){return this._settingsEnhanced},enhanceSettings:function(e){if(this._settingsEnhanced){return this}this._settingsEnhanced=true;var n,t,r;for(n in e){t=e[n];r=undefined;if(t!==undefined){if(Array.isArray(this[n])){if(this[n].length===0){r=t}else{r=h(this[n].concat(t))}}else if(this[n]===undefined){r=t}else if(n!="name"){i.warningThrows("library info setting ignored: "+n+"="+t)}if(r!==undefined){Object.defineProperty(this,n,A(r))}}}return this},_getFileType:function(e){var n;var t=C[this.name]||C[""]||"both";if(e===true){n="json"}else if(e===false){n="js"}else{n=t}if(t!=="both"&&n!=="both"&&t!==n){n="none"}return n},preload:function(e){if(e&&(e.hasOwnProperty("async")||e.hasOwnProperty("sync"))){i.errorThrows("The 'preload' function of class sap/ui/core/Lib only supports preloading a library asynchronously.",{suffix:"The given 'async' or 'sync' setting is ignored."})}if(e&&e.hasOwnProperty("json")){i.errorThrows("The 'preload' function of class sap/ui/core/Lib only supports preloading in JS Format.",{suffix:"The given 'json' setting is ignored."})}return this._preload(["url","lazy"].reduce(function(n,t){if(e&&e.hasOwnProperty(t)){n[t]=e[t]}return n},{}))},_preload:function(e){e=e||{};var n=this._getFileType(e.json),t=this.name.replace(/\./g,"/"),r=!!sap.ui.loader._.getModuleState(t+"/library.js"),i=k.isDepCacheEnabled();if(n==="none"){return e.sync?this:Promise.resolve(this)}if(this._loadingStatus==null&&e.url){O(this.name,e.url)}this._loadingStatus=this._loadingStatus||{};if(this._loadingStatus.pending){if(e.sync){if(e.lazy){return this}else if(this._loadingStatus.async){a.warning("request to load "+this.name+" synchronously while async loading is pending; this causes a duplicate request and should be avoided by caller")}else{a.warning("request to load "+this.name+" synchronously while sync loading is pending (cycle, ignored)");return this}}else if(this._loadingStatus.preloadFinished){return Promise.resolve(this)}}if(e.sync&&this._loadingStatus.pending===false||!e.sync&&this._loadingStatus.promise){return e.sync?this:this._loadingStatus.promise}if(e.lazy){a.debug("Lazy dependency to '"+this.name+"' encountered, loading library-preload-lazy.js");if(e.sync){try{sap.ui.requireSync(t+"/library-preload-lazy")}catch(e){a.error("failed to load '"+t+"/library-preload-lazy.js"+"' synchronously ("+(e&&e.message||e)+")")}return this}return sap.ui.loader._.loadJSResourceAsync(t+"/library-preload-lazy.js",true)}this._loadingStatus.pending=true;this._loadingStatus.async=!e.sync;var s;if(r){s=(e.sync?_:Promise).resolve()}else{s=n!=="json"?this._preloadJSFormat({fallbackToJSON:n!=="js",http2:i,sync:e.sync}):this._preloadJSONFormat({sync:e.sync})}this._loadingStatus.promise=s.then(function(n){n=n||this._getDependencies();this._loadingStatus.preloadFinished=true;var t=this.getManifest(),r;if(n&&n.length){if(!e.sync){n=g._getTransitiveDependencyForLibraries(n)}r=n.map(function(n){var t=k._get(n.name,true);return t._preload({sync:e.sync,lazy:n.lazy})})}else{r=[]}if(!e.sync&&t&&p(t._version).compareTo("1.9.0")>=0){r.push(this.loadResourceBundle())}var i=e.sync?_.all(r):Promise.all(r);return i.then(function(){this._loadingStatus.pending=false;return this}.bind(this))}.bind(this));return e.sync?this._loadingStatus.promise.unwrap():this._loadingStatus.promise},_preloadJSFormat:function(e){e=e||{};var n=this;var t=this.name.replace(/\./g,"/")+(e.http2?"/library-h2-preload":"/library-preload")+(e.sync?"":".js");var r;if(e.sync){r=_.resolve().then(function(){sap.ui.requireSync(t)})}else{r=sap.ui.loader._.loadJSResourceAsync(t)}return r.catch(function(r){if(e.fallbackToJSON){var i;if(e.sync){var s=r;while(s&&s.cause){s=s.cause}i=s&&s.name==="XHRLoadError"}else{i=true}if(i){a.error("failed to load '"+t+"' ("+(r&&r.message||r)+"), falling back to library-preload.json");return n._preloadJSONFormat({sync:e.sync})}}})},_preloadJSONFormat:function(e){e=e||{};var n=P(this.name,"/library-preload.json");c=f?f:c;return c(n,{headers:{Accept:c.ContentTypes.JSON}},e.sync).then(function(e){if(e.ok){return e.json().then(function(e){if(e){E(e,n);if(Array.isArray(e.dependencies)){return e.dependencies.map(function(e){return{name:e.replace(/\.library-preload$/,"")}})}else{return e.dependencies}}})}else{throw Error(e.statusText||e.status)}}).catch(function(e){a.error("failed to load '"+n+"': "+e.message)})},getManifest:function(e){if(!this.oManifest){var n=this.name.replace(/\./g,"/")+"/manifest.json";if(sap.ui.loader._.getModuleState(n)||e&&!this._manifestFailed){try{this.oManifest=l.loadResource(n,{dataType:"json",async:false,failOnError:!this.isSettingsEnhanced()});if(this._oManifest){F(this.oManifest)}else{this._manifestFailed=true}}catch(e){this._manifestFailed=true}}}return this.oManifest},_getDependencies:function(){var e=this.getManifest();var n=[];var t=e&&e["sap.ui5"]&&e["sap.ui5"].dependencies&&e["sap.ui5"].dependencies.libs;if(t){return Object.keys(t).reduce(function(e,n){if(!t[n].lazy){e.push({name:n})}else if(T.has(n)){e.push({name:n,lazy:true})}return e},n)}else{return n}},_getI18nSettings:function(){var e=this.getManifest(),n;if(e&&p(e._version).compareTo("1.9.0")>=0){n=e["sap.ui5"]&&e["sap.ui5"].library&&e["sap.ui5"].library.i18n}n=this._normalizeI18nSettings(n);return n},_normalizeI18nSettings:function(e){if(e==null||e===true){e={bundleUrl:"messagebundle.properties"}}else if(typeof e==="string"){e={bundleUrl:e}}else if(typeof e==="object"){e=s({},e)}return e},_includeTheme:function(e,n){var t=this.name,r=q().indexOf(t)!==-1;x.push({name:t,version:this.version,variant:e,preloadedCss:r});M().then(function(r){r.includeLibraryTheme(t,e,n)})},getResourceBundle:function(e){return this._loadResourceBundle(e,true)},loadResourceBundle:function(e){return this._loadResourceBundle(e)},_loadResourceBundle:function(n,i){var a=this,s=this.getManifest(i),o=!!s,u,l,c,f;e(n===undefined||typeof n==="string","sLocale must be a string or omitted");n=n||t.getLanguage();c=n+"/manifest-not-available";if(o){f=n;delete this._resourceBundles[c]}else{f=c}u=this._resourceBundles[f];if(!u||i&&u instanceof Promise){l=this._getI18nSettings();if(l){var d=P(this.name+"/",l.bundleUrl);w[d]=this;u=r.create({bundleUrl:d,supportedLocales:l.supportedLocales,fallbackLocale:l.fallbackLocale,locale:n,async:!i,activeTerminologies:t.getActiveTerminologies()});if(u instanceof Promise){u=u.then(function(e){a._resourceBundles[f]=e;return e})}this._resourceBundles[f]=u}}return i?u:Promise.resolve(u)}});k.getAllInstancesRequiringCss=function(){return x.slice()};k.isLoaded=function(e){return L[e]?true:false};k._get=function(e,n){var t=L[e];if(!t&&n){L[e]=t=new k({name:e,_key:R})}return t};k._getByBundleUrl=function(e){if(e){if(w[e]){return w[e]}var n=sap.ui.loader._.guessResourceName(e);if(n){for(var t in L){if(!L[t].isSettingsEnhanced()){continue}var r=t.replace(/\./g,"/");var i=L[t];if(r!==""&&n.startsWith(r+"/")){var a=n.replace(r+"/","");var s=i._getI18nSettings();if(s){var o=P(r,"/"+s.bundleUrl);a=P(r,"/"+a);if(a===o){w[e]=i;return i}w[e]=false}}}}}};k.all=function(){return k._all(false)};k._all=function(e){var n={};Object.keys(L).forEach(function(t){if(e||L[t].isSettingsEnhanced()){n[t]=L[t]}});return n};const U=Symbol("isProxy");function $(e,n){const t=new WeakMap;t.set(n,`${e}.`);const r={set(e,n,i){if(u(i)&&!i[U]){const s=o(i);let u=s;if(!s){if(m._isEnumCandidate(i)){e[n]=i;const r=t.get(e);m.registerEnum(`${r}${n}`,i);a.debug(`[Library API-Version 2] If you intend to use API-Version 2 in your library, make sure to call 'sap/ui/base/DataType.registerEnum' for ${r}${n}.`)}else{const t=n.charAt(0);if(t===t.toLowerCase()&&t!==t.toUpperCase()){u=true}else{e[n]=i}}}if(u){e[n]=new Proxy(i,r);const a=`${t.get(e)}${n}.`;t.set(i,a)}}else{e[n]=i}return true},get(e,n){if(n===U){return true}return e[n]}};return r}k.init=function(n){if(!sap.ui.require("sap/ui/core/Core")){throw new Error("Library "+n.name+": Library must not be used before the core is ready!")}e(typeof n==="object","mSettings given to 'sap/ui/core/Lib.init' must be an object");e(typeof n.name==="string"&&n.name,"mSettings given to 'sap/ui/core/Lib.init' must have the 'name' property set");var t="sap/ui/core/Lib.init";a.debug("Analyzing Library "+n.name,null,t);var r=k._get(n.name,true);r.enhanceSettings(n);var i=Object.create(null),s;i=d.create(n.name);const o=n.apiVersion??1;if(![1,2].includes(o)){throw new TypeError(`The library '${n.name}' has defined 'apiVersion: ${o}', which is an unsupported value. The supported values are: 1, 2 and undefined (defaults to 1).`)}if(o<2){const e=$(n.name,i);i=new Proxy(i,e);d.set(n.name,i)}for(s=0;s<r.dependencies.length;s++){var l=r.dependencies[s];var c=k._get(l,true);a.debug("resolve Dependencies to "+l,null,t);if(!c.isSettingsEnhanced()){a.warning("Dependency from "+n.name+" to "+l+" has not been resolved by library itself",null,t);k._load({name:l},{sync:true})}}m.registerInterfaceTypes(r.interfaces);function f(e){const n=d.get(e);if(n instanceof m){return` to ensure that the type is defined. You can then access it by calling 'DataType.getType("${e}")'.`}else if(u(n)){return`. You can then reference this type via the library's module export.`}else{return`.`}}for(s=0;s<r.types.length;s++){if(!/^(any|boolean|float|int|string|object|void)$/.test(r.types[s])){const e=r.types[s];sap.ui.loader._.declareModule(e.replace(/\./g,"/")+".js",()=>`Importing the pseudo module '${e.replace(/\./g,"/")}' is deprecated.`+` To access the type '${e}', please import '${r.name.replace(/\./g,"/")}/library'`+f(e)+` For more information, see documentation under 'Best Practices for Loading Modules'.`);var p=e.substring(0,e.lastIndexOf("."));if(d.get(p)===undefined){d.create(p)}}}(()=>{var e=r.controls.concat(r.elements);for(s=0;s<e.length;s++){sap.ui.lazyRequire(e[s],"new extend getMetadata")}})();if(!r.noLibraryCSS){var h={name:r.name,version:r.version,preloadedCss:q().indexOf(r.name)!==-1};x.push(h);M(!h.preloadedCss).then(function(e){e._includeLibraryThemeAndEnsureThemeRoot(h)})}r.sName=r.name;r.aControls=r.controls;k.fireLibraryChanged({name:n.name,stereotype:"library",operation:"add",metadata:r});return i};function I(e){return e.map(function(e){return e.name.replace(/\./g,"/")+"/library"})}function D(e){var n=I(e);return new Promise(function(t,r){sap.ui.require(n,function(){t(e)},r)})}k.load=function(e){if(typeof e==="string"){e={name:e}}else{e=["name","url"].reduce(function(n,t){if(e&&e.hasOwnProperty(t)){n[t]=e[t]}return n},{})}return k._load(e).then(function(e){return e[0]})};k._load=function(e,n){n=n||{};if(!Array.isArray(e)){e=[e]}var t={};var r=[];e.forEach(function(e){if(typeof e==="object"){if(e.hasOwnProperty("url")||e.hasOwnProperty("json")){t[e.name]=e}r.push(e)}else{r.push({name:e})}});var i=k.getPreloadMode()==="sync"||k.getPreloadMode()==="async",s=!n.preloadOnly;if(!n.sync){r=g._getTransitiveDependencyForLibraries(r)}var o=r.map(function(e){var n=k._get(e.name,true);if(n._loadingStatus==null&&t[e.name]&&t[e.name].url){O(e.name,t[e.name].url)}return n});if(n.sync){if(i){o.forEach(function(e){var n={sync:true};if(t[e.name]&&t[e.name].hasOwnProperty("json")){n.json=t[e.name].json}e._preload(n)})}if(s){I(o).forEach(function(e,n){if(o[n].isSettingsEnhanced()){return}sap.ui.requireSync(e);if(!o[n].isSettingsEnhanced()){a.warning("library "+o[n].name+" didn't initialize itself");k.init({name:o[n].name})}})}return o}const u=i?Promise.all(o.map(function(e){const n={};if(t[e.name]&&t[e.name].hasOwnProperty("json")){n.json=t[e.name].json}return e._preload(n)})):Promise.resolve(o);return s?u.then(D):u};k.getResourceBundleFor=function(e,n){var t=k._get(e,true);return t.getResourceBundle(n)};k._registerElement=function(e){var n=e.getName(),t=e.getLibraryName()||"";if(!t&&!n.includes(".")){return}let r=k._get(t);const i=e.isA("sap.ui.core.Control")?"controls":"elements";if(!r){d.create(t);r=k._get(t,true)}if(r[i].indexOf(n)<0){r[i].push(n);a.debug("Class "+n+" registered for library "+t);k.fireLibraryChanged({name:n,stereotype:e.getStereotype(),operation:"add",metadata:e})}};var J=new b;k.attachLibraryChanged=function(e,n){J.attachEvent("LibraryChanged",e,n)};k.detachLibraryChanged=function(e,n){J.detachEvent("LibraryChanged",e,n)};k.fireLibraryChanged=function(e){J.fireEvent("LibraryChanged",e)};r._enrichBundleConfig=function(e){if(!e.terminologies||!e.enhanceWith){var n=k._getByBundleUrl(e.url);if(n){var r=n._getI18nSettings();if(r){var i=n.name.replace(/\./g,"/");i=i.endsWith("/")?i:i+"/";i=sap.ui.require.toUrl(i);S._processResourceConfiguration(r,{alreadyResolvedOnRoot:true,relativeTo:i});e.fallbackLocale=e.fallbackLocale||r.fallbackLocale;e.supportedLocales=e.supportedLocales||r.supportedLocales;e.terminologies=e.terminologies||r.terminologies;e.enhanceWith=e.enhanceWith||r.enhanceWith;e.activeTerminologies=e.activeTerminologies||t.getActiveTerminologies()}}}return e};k.getVersionedLibCss=function(){return n.get({name:"sapUiVersionedLibCss",type:n.Type.Boolean,external:true})};k.isDepCacheEnabled=function(){return n.get({name:"sapUiXxDepCache",type:n.Type.Boolean,external:true})};k.getPreloadMode=function(){if(j.isDebugModeEnabled()===true){return""}let e=n.get({name:"sapUiPreload",type:n.Type.String,defaultValue:"auto",external:true});if(e==="auto"){if(window["sap-ui-optimized"]){e=sap.ui.loader.config().async?"async":"sync"}else{e=""}}return e};return k});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Patcher", ["sap/ui/Device"],function(t){"use strict";var e=document.createElement("title").style;var r=document.createElement("template");var i={value:function(t,e){if(t.tagName=="INPUT"){t.value=e==null?"":e}},checked:function(t,e){if(t.tagName=="INPUT"){t.checked=e==null?false:true}},selected:function(t,e){if(t.tagName=="OPTION"){t.selected=e==null?false:true}}};if(t.browser.safari){i.style=function(t,e){if(e==null){t.style="";return true}}}var n=function(t,e){if(t=="svg"){return document.createElementNS("http://www.w3.org/2000/svg","svg")}var r=e&&e.namespaceURI;if(!r||r=="http://www.w3.org/1999/xhtml"||e.localName=="foreignObject"){return document.createElement(t)}return document.createElementNS(r,t)};var s=function(){this._oRoot=null;this._oCurrent=null;this._oParent=null;this._oReference=null;this._oNewElement=null;this._oNewParent=null;this._oNewReference=null;this._iTagOpenState=0;this._sStyles="";this._sClasses="";this._mAttributes=Object.create(null)};s.prototype.setRootNode=function(t){if(this._oRoot){this.reset()}this._oRoot=t||document.createDocumentFragment()};s.prototype.getRootNode=function(){return this._oRoot};s.prototype.getCurrentNode=function(){return this._oCurrent};s.prototype.reset=function(){this._oRoot=this._oCurrent=this._oParent=this._oReference=this._oNewElement=this._oNewParent=this._oNewReference=null;this._iTagOpenState=0};s.prototype._walkOnTree=function(){this._oReference=null;if(!this._oCurrent){if(this._oRoot.nodeType==11){this._oParent=this._oRoot}else{this._oParent=this._oRoot.parentNode;this._oCurrent=this._oRoot}}else if(this._iTagOpenState){this._oParent=this._oCurrent;this._oCurrent=this._oCurrent.firstChild}else{this._oParent=this._oCurrent.parentNode;this._oCurrent=this._oCurrent.nextSibling}};s.prototype._matchElement=function(t){if(!t){return}if(!this._oCurrent){return}if(this._oCurrent.id==t||this._oCurrent==this._oRoot){return}var e=document.getElementById(t);if(e){this._oCurrent=this._oParent.insertBefore(e,this._oCurrent);return}if(this._oCurrent.id){this._oReference=this._oCurrent;this._oCurrent=null}};s.prototype._matchNodeName=function(t){if(!this._oCurrent){return}var e=this._oCurrent.nodeType==1?this._oCurrent.localName:this._oCurrent.nodeName;if(e==t){return}this._oReference=this._oCurrent;this._oCurrent=null};s.prototype._getAttributes=function(){for(var t=0,e=this._oCurrent.getAttributeNames();t<e.length;t++){this._mAttributes[e[t]]=this._oCurrent.getAttribute(e[t])}};s.prototype._setNewElement=function(t){if(!t){return}if(!this._oNewElement){this._oNewElement=this._oCurrent;this._oNewParent=this._oParent;this._oNewReference=this._oReference}else{this._oParent.insertBefore(this._oCurrent,this._oReference)}};s.prototype._insertNewElement=function(){if(this._oCurrent==this._oNewElement){this._oNewParent[this._oNewReference==this._oRoot?"replaceChild":"insertBefore"](this._oNewElement,this._oNewReference);this._oNewElement=this._oNewParent=this._oNewReference=null}};s.prototype.isCreating=function(){return Boolean(this._oNewElement)};s.prototype.alignWithDom=function(t,e){this._walkOnTree();if(!this._oCurrent||this._oCurrent.id!=t.id||this._oParent!=t.parentNode){this._oCurrent=this._oParent.insertBefore(t,this._oCurrent)}if(e){this._oCurrent=e(t)||this._oCurrent}this._iTagOpenState=0;return this};s.prototype.openStart=function(t,e){this._walkOnTree();this._matchElement(e);this._matchNodeName(t);if(this._oCurrent){this._getAttributes();this._iTagOpenState=2}else{this._oCurrent=n(t,this._oParent);this._setNewElement(this._oCurrent);this._iTagOpenState=1}if(e){this.attr("id",e)}return this};s.prototype.voidStart=s.prototype.openStart;s.prototype.attr=function(t,e){if(t==="style"){this._sStyles=e;return this}if(this._iTagOpenState==1){this._oCurrent.setAttribute(t,e);return this}var r=String(e);var n=this._mAttributes[t];var s=i[t];if(n!==undefined){delete this._mAttributes[t]}if(s&&s(this._oCurrent,r,n)){return this}if(n!==r){this._oCurrent.setAttribute(t,r)}return this};s.prototype.class=function(t){if(t){this._sClasses+=this._sClasses?" "+t:t}return this};s.prototype.style=function(t,r){if(!t||r==null||r==""){return this}r=r+"";if(r.includes(";")){e.setProperty(t,r);r=e.getPropertyValue(t)}this._sStyles+=(this._sStyles?" ":"")+(t+": "+r+";");return this};s.prototype.openEnd=function(){if(this._sClasses){this.attr("class",this._sClasses);this._sClasses=""}if(this._sStyles){if(this._mAttributes.style!=this._sStyles){this._oCurrent.style=this._sStyles}delete this._mAttributes.style;this._sStyles=""}if(this._iTagOpenState==1){return this}for(var t in this._mAttributes){var e=i[t];if(!e||!e(this._oCurrent,null)){this._oCurrent.removeAttribute(t)}delete this._mAttributes[t]}return this};s.prototype.voidEnd=function(){this.openEnd();this._iTagOpenState=0;this._insertNewElement();return this};s.prototype.text=function(t){this._walkOnTree();this._matchNodeName("#text");if(!this._oCurrent){this._oCurrent=document.createTextNode(t);this._oParent.insertBefore(this._oCurrent,this._oReference)}else if(this._oCurrent.data!=t){this._oCurrent.data=t}this._iTagOpenState=0;return this};s.prototype.close=function(t){if(this._iTagOpenState){this._iTagOpenState=0;if(this._oCurrent.lastChild){this._oCurrent.textContent=""}}else{var e=this._oCurrent.parentNode;for(var r=e.lastChild;r&&r!=this._oCurrent;r=e.lastChild){e.removeChild(r)}this._oCurrent=e}this._insertNewElement();return this};s.prototype.unsafeHtml=function(t,e,i){var n=null;var s=this._oCurrent;if(!s){n=this._oRoot}else if(this._iTagOpenState){n=s.firstChild;if(t){this._iTagOpenState=0;s.insertAdjacentHTML("afterbegin",t);this._oCurrent=n?n.previousSibling:s.lastChild}}else{n=s.nextSibling;if(t){if(s.nodeType==1){s.insertAdjacentHTML("afterend",t)}else{r.innerHTML=t;s.parentNode.insertBefore(r.content,n)}this._oCurrent=n?n.previousSibling:s.parentNode.lastChild}}if(t&&i){var o=[this._oCurrent];for(var h=this._oCurrent.previousSibling;h&&h!=s;h=h.previousSibling){o.unshift(h)}i(o)}if(e&&n&&n.id==e){n.remove()}return this};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/RenderManager", ["./ControlBehavior","./FocusHandler","./InvisibleRenderer","./LabelEnablement","./Patcher","sap/base/assert","sap/base/future","sap/base/Log","sap/base/security/encodeCSS","sap/base/security/encodeXML","sap/base/util/extend","sap/base/util/uid","sap/ui/base/Object","sap/ui/performance/Measurement","sap/ui/performance/trace/Interaction","sap/ui/thirdparty/jquery","sap/ui/util/ActivityDetection"],function(e,t,n,r,i,a,s,o,l,u,f,c,d,p,h,jQuery,g){"use strict";var m;var y=["renderControl","cleanupControlWithoutRendering","accessibilityState","icon"];var b=["write","writeEscaped","writeAcceleratorKey","writeControlData","writeElementData","writeAttribute","writeAttributeEscaped","addClass","writeClasses","addStyle","writeStyles","writeAccessibilityState","writeIcon","translate","getConfiguration","getHTML"];var v=["openStart","voidStart","attr","class","style","openEnd","voidEnd","text","unsafeHtml","close"];var C=["render","flush","destroy"];var S=document.createElement("template");var E="data-sap-ui-stylekey";var R="data-sap-ui-render";function A(){var e=this,r,s,l,f,c="",m=false,I,P="",O={},j={},T=[],N=new i,_=0,x,H;function F(){a(!(x=H=""));r=e.aBuffer=[];s=e.aRenderedControls=[];l=e.aStyleStack=[{}];I=undefined;m=false;_=0;c=""}function L(e,t){r.push(" ",e,'="',t,'"')}function V(e){var t=l[l.length-1];var n;if(e){n=e.aCustomStyleClasses}else if(e===false){n=[]}else{n=t.aCustomStyleClasses}if(t.aClasses||n){var r=[].concat(t.aClasses||[],n||[]);if(r.length){L("class",r.join(" "))}}if(!e){t.aCustomStyleClasses=null}t.aClasses=null}function q(){var e=l[l.length-1];if(e.aStyle&&e.aStyle.length){L(E,T.push(e.aStyle.join(" "))-1)}e.aStyle=null}function U(e,t){a(e&&typeof e=="string"&&/^[a-z_][a-zA-Z0-9_\-]*$/.test(e),"The "+t+" name provided '"+e+"' is not valid; it must contain alphanumeric characters, hyphens or underscores")}function W(e){a(c,"There is no open tag; '"+e+"' must not be called without an open tag")}function G(e){var t=e===undefined?!c:e;a(t,"There is an open tag; '"+c+"' tag has not yet ended with '"+(m?"voidEnd":"openEnd")+"'")}function X(e){U(e,"attr");a((e!="class"||H!="class"&&(H="attr"))&&(e!="style"||x!="style"&&(x="attr")),"Attributes 'class' and 'style' must not be written when the methods with the same name"+" have been called for the same element already")}function $(e){a(H!="attr"&&(H="class"),"Method class() must not be called after the 'class' attribute has been written for the same element");a(typeof e=="string"&&!/\s/.test(e)&&arguments.length===1,"Method 'class' must be called with exactly one class name")}function z(e){a(x!="attr"&&(x="style"),"Method style() must not be called after the 'style' attribute has been written for the same element");a(e&&typeof e=="string"&&!/\s/.test(e),"Method 'style' must be called with a non-empty string name")}this.write=function(e){a(typeof e==="string"||typeof e==="number","sText must be a string or number");r.push.apply(r,arguments);return this};this.writeEscaped=function(e,t){if(e!=null){e=u(String(e));if(t){e=e.replace(/&#xa;/g,"<br>")}r.push(e)}return this};this.writeAttribute=function(e,t){a(typeof e==="string","sName must be a string");a(typeof t==="string"||typeof t==="number"||typeof t==="boolean","value must be a string, number or boolean");r.push(" ",e,'="',t,'"');return this};this.writeAttributeEscaped=function(e,t){a(typeof e==="string","sName must be a string");r.push(" ",e,'="',u(String(t)),'"');return this};this.addStyle=function(e,t){a(typeof e==="string","sName must be a string");if(t!=null&&t!=""){a(typeof t==="string"||typeof t==="number","value must be a string or number");var n=l[l.length-1];if(!n.aStyle){n.aStyle=[]}n.aStyle.push(e+": "+t+";")}return this};this.writeStyles=function(){q();return this};this.addClass=function(e){if(e){a(typeof e==="string","sName must be a string");var t=l[l.length-1];if(!t.aClasses){t.aClasses=[]}t.aClasses.push(e)}return this};this.writeClasses=function(e){a(!e||typeof e==="boolean"||d.isObjectA(e,"sap.ui.core.Element"),"oElement must be empty, a boolean, or an sap.ui.core.Element");V(e);return this};this.openStart=function(e,t){U(e,"tag");G();a(!(x=H=""));c=e;_++;r.push("<"+e);if(t){if(typeof t=="string"){this.attr("id",t)}else{a(t&&d.isObjectA(t,"sap.ui.core.Element"),"vControlOrId must be an sap.ui.core.Element");this.attr("id",t.getId());M(this,t)}}return this};this.openEnd=function(e){W("openEnd");G(!m);a(e===undefined||e===true,"The private parameter bExludeStyleClasses must be true or omitted!");c="";V(e===true?false:undefined);q();r.push(">");return this};this.close=function(e){U(e,"tag");G();_--;r.push("</"+e+">");return this};this.voidStart=function(e,t){this.openStart(e,t);m=true;return this};this.voidEnd=function(e){W("voidEnd");G(m||!c);m=false;_--;c="";V(e?false:undefined);q();r.push(">");return this};this.unsafeHtml=function(e){G();r.push(e);return this};this.text=function(e){G();if(e!=null){e=u(String(e));r.push(e)}return this};this.attr=function(e,t){X(e);if(e=="style"){l[l.length-1].aStyle=[t]}else{r.push(" ",e,'="',u(String(t)),'"')}return this};this.class=function(e){if(e){$.apply(this,arguments);var t=l[l.length-1];if(!t.aClasses){t.aClasses=[]}t.aClasses.push(u(e))}return this};this.style=function(e,t){z(e);if(t!=null&&t!=""){a(typeof t==="string"||typeof t==="number","value must be a string or number");var n=l[l.length-1];if(!n.aStyle){n.aStyle=[]}n.aStyle.push(e+": "+t+";")}return this};j.openStart=function(e,t){U(e,"tag");G();a(!(x=H=""));c=e;_++;if(!t){N.openStart(e)}else if(typeof t=="string"){N.openStart(e,t)}else{N.openStart(e,t.getId());M(this,t)}return this};j.voidStart=function(e,t){this.openStart(e,t);m=true;return this};j.attr=function(e,t){X(e);W("attr");N.attr(e,t);return this};j.class=function(e){if(e){$.apply(this,arguments);W("class");N.class(e)}return this};j.style=function(e,t){z(e);W("style");N.style(e,t);return this};j.openEnd=function(e){if(e!==true){var t=l[l.length-1];var n=t.aCustomStyleClasses;if(n){n.forEach(N.class,N);t.aCustomStyleClasses=null}}W("openEnd");G(!m);a(e===undefined||e===true,"The private parameter bExludeStyleClasses must be true or omitted!");c="";N.openEnd();return this};j.voidEnd=function(e){if(!e){var t=l[l.length-1];var n=t.aCustomStyleClasses;if(n){n.forEach(N.class,N);t.aCustomStyleClasses=null}}W("voidEnd");G(m||!c);m=false;_--;c="";N.voidEnd();return this};j.text=function(e){G();if(e!=null){N.text(e)}return this};j.unsafeHtml=function(e){G();N.unsafeHtml(e);return this};j.close=function(e){U(e,"tag");G();_--;N.close(e);return this};function J(e){f=true;try{var t=new jQuery.Event("BeforeRendering");t.srcControl=e;e._bOnBeforeRenderingPhase=true;e._handleEvent(t)}finally{e._bOnBeforeRenderingPhase=false;f=false}}this.cleanupControlWithoutRendering=function(e){a(!e||d.isObjectA(e,"sap.ui.core.Control"),"oControl must be an sap.ui.core.Control or empty");if(!e){return}var t=e.getDomRef();if(t){J(e);A.preserveContent(t,false,false);if(!t.hasAttribute(D)){e._bNeedsRendering=false;e.bOutput=false}}};function K(e,t){if(t){J(e)}if(e.bOutput==true){var i=e.aBindParameters;if(i&&i.length>0){var a=e.$();i.forEach(function(e){a.off(e.sEventType,e.fnProxy)})}}var u=B(e);if(u==n){n.render(I?j:O,e);e.bOutput="invisible"}else if(u&&typeof u.render==="function"){var f={};if(e.aCustomStyleClasses&&e.aCustomStyleClasses.length>0){f.aCustomStyleClasses=e.aCustomStyleClasses}l.push(f);e._bRenderingPhase=true;if(I){var c=N.getCurrentNode();u.render(j,e);if(N.getCurrentNode()==c){N.unsafeHtml("",e.getId());e.bOutput=false}else{e.bOutput=true}}else{var d=r.length;u.render(O,e);e.bOutput=r.length!=d}e._bRenderingPhase=false;l.pop()}else{o.error("The renderer for class "+e.getMetadata().getName()+" is not defined or does not define a render function! Rendering of "+e.getId()+" will be skipped!")}s.push(e);e._bNeedsRendering=false;var p=e.getUIArea();if(p){p._onControlRendered(e)}}this.renderControl=function(e){a(!e||d.isObjectA(e,"sap.ui.core.Control"),"oControl must be an sap.ui.core.Control or empty");if(!e){return this}var i,s;var o=true;if(r.length){I=false}else if(I===undefined){J(e);o=false;s=B(e);if(A.getApiVersion(s)!=1){i=e.getDomRef()||n.getDomRef(e);if(A.isPreservedContent(i)){I=false}else{i&&t.storePatchingControlFocusInfo(i);N.setRootNode(i);I=true}}else{I=false}}else if(!P&&I){s=B(e);if(A.getApiVersion(s)==1){P=e.getId();I=false}}if(I){if(e._bNeedsRendering||!e.getParent()||N.isCreating()||!A.canSkipRendering(e)||!(i=i||e.getDomRef()||n.getDomRef(e))||i.hasAttribute(R)||i.querySelector("["+R+"]")){K(e,o)}else{N.alignWithDom(i)}}else{K(e,o);if(P&&P===e.getId()){N.unsafeHtml(r.join(""),P,ee);P="";I=true;r=[]}}return this};this.getHTML=function(e){a(e&&d.isObjectA(e,"sap.ui.core.Control"),"oControl must be an sap.ui.core.Control");var t=r;var n=r=this.aBuffer=[];this.renderControl(e);r=this.aBuffer=t;return n.join("")};function Z(e){a(!_,"RenderManager: Mismatched opening and closing tags. Verify renderers!");var n,r=s.length;for(n=0;n<r;n++){s[n]._sapui_bInAfterRenderingPhase=true}f=true;try{for(n=0;n<r;n++){var i=s[n];if(i.bOutput&&i.bOutput!=="invisible"){var l=new jQuery.Event("AfterRendering");l.srcControl=i;p.start(i.getId()+"---AfterRendering","AfterRendering of "+i.getMetadata().getName(),["rendering","after"]);i._handleEvent(l);p.end(i.getId()+"---AfterRendering")}}}finally{for(n=0;n<r;n++){delete s[n]._sapui_bInAfterRenderingPhase}f=false}try{t.restoreFocus(e)}catch(e){o.warning("Problems while restoring the focus after rendering: "+e,null)}for(n=0;n<r;n++){var i=s[n],u=i.aBindParameters,c;if(u&&u.length>0&&(c=i.getDomRef())){var d=jQuery(c);for(var h=0;h<u.length;h++){var g=u[h];d.on(g.sEventType,g.fnProxy)}}}}function Q(e,n,i){var a;if(!I){a=t.getControlFocusInfo();var s=r.join("");if(s&&T.length){if(i instanceof SVGElement&&i.localName!="foreignObject"){S.innerHTML="<svg>"+s+"</svg>";S.replaceWith.apply(S.content.firstChild,S.content.firstChild.childNodes)}else{S.innerHTML=s}ee(S.content.childNodes);e(S.content)}else{e(s)}}else{var o=N.getRootNode();if(o.nodeType==11){a=t.getControlFocusInfo();e(o.lastChild?o:"")}else{a=t.getPatchingControlFocusInfo()}N.reset()}Z(a);F();g.refresh();if(n){n()}}function Y(e,t){var n=e.getAttribute(E);if(n!=t){return 0}e.style=T[t];e.removeAttribute(E);return 1}function ee(e){if(!T.length){return}var t=0;e.forEach(function(e){if(e.nodeType==1){t+=Y(e,t);e.querySelectorAll("["+E+"]").forEach(function(e){t+=Y(e,t)})}});T=[]}this.flush=function(e,t,n){a(typeof e==="object"&&e.ownerDocument==document,"oTargetDomNode must be a DOM element");var r=h.notifyAsyncStep();if(!t&&typeof n!=="number"&&!n){A.preserveContent(e)}Q(function(t){for(var r=0;r<s.length;r++){var i=s[r].getDomRef();if(i&&!A.isPreservedContent(i)){if(A.isInlineTemplate(i)){jQuery(i).empty()}else{jQuery(i).remove()}}}if(typeof n==="number"){if(n<=0){k(e,"prepend",t)}else{var a=e.children[n-1];if(a){k(a,"after",t)}else{k(e,"append",t)}}}else if(!n){jQuery(e).html(t)}else{k(e,"append",t)}},r,e)};this.render=function(e,t){a(e&&d.isObjectA(e,"sap.ui.core.Control"),"oControl must be a control");a(typeof t==="object"&&t.ownerDocument==document,"oTargetDomNode must be a DOM element");if(f){o.error("Render must not be called within Before or After Rendering Phase. Call ignored.",null,this);return}var r=h.notifyAsyncStep();F();this.renderControl(e);Q(function(r){if(e&&t){var i=e.getDomRef();if(!i||A.isPreservedContent(i)){i=n.getDomRef(e)||document.getElementById(w.Dummy+e.getId())}var a=i&&i.parentNode!=t;if(a){if(!A.isPreservedContent(i)){if(A.isInlineTemplate(i)){jQuery(i).empty()}else{jQuery(i).remove()}}if(r){k(t,"append",r)}}else{if(r){if(i){if(A.isInlineTemplate(i)){jQuery(i).html(r)}else{k(i,"after",r);jQuery(i).remove()}}else{k(t,"append",r)}}else{if(A.isInlineTemplate(i)){jQuery(i).empty()}else{if(!e.getParent()||!e.getParent()._onChildRerenderedEmpty||!e.getParent()._onChildRerenderedEmpty(e,i)){jQuery(i).remove()}}}}}},r,t)};this.destroy=function(){F()};var te={};y.forEach(function(e){O[e]=j[e]=te[e]=this[e]},this);v.forEach(function(e){O[e]=te[e]=this[e]},this);b.forEach(function(e){O[e]=te[e]=this[e]},this);C.forEach(function(e){te[e]=this[e]},this);this.getRendererInterface=function(){return O};this.getInterface=function(){return te};F()}A.prototype.getConfiguration=function(){return sap.ui.require("sap/ui/core/Configuration")};A.prototype.translate=function(e){};A.prototype.writeAcceleratorKey=function(){return this};A.prototype.writeControlData=function(e){a(e&&d.isObjectA(e,"sap.ui.core.Control"),"oControl must be an sap.ui.core.Control");this.writeElementData(e);return this};A.prototype.writeElementData=function(e){a(e&&d.isObjectA(e,"sap.ui.core.Element"),"oElement must be an sap.ui.core.Element");this.attr("id",e.getId());M(this,e);return this};A.prototype.accessibilityState=function(t,n){if(!e.isAccessibilityEnabled()){return this}if(arguments.length==1&&!d.isObjectA(t,"sap.ui.core.Element")){n=t;t=null}var i={};if(t!=null){var a=t.getMetadata();var s=function(e,n,r){var s=a.getProperty(e);if(s&&t[s._sGetter]()===r){i[n]="true"}};var o=function(e,n){var s=a.getAssociation(e);if(s&&s.multiple){var o=t[s._sGetter]();if(e=="ariaLabelledBy"){var l=r.getReferencingLabels(t);var u=l.length;if(u){var f=[];for(var c=0;c<u;c++){if(o.indexOf(l[c])<0){f.push(l[c])}}o=f.concat(o)}}if(o.length>0){i[n]=o.join(" ")}}};s("editable","readonly",false);s("enabled","disabled",false);s("visible","hidden",false);if(r.isRequired(t)){i["required"]="true"}s("selected","selected",true);s("checked","checked",true);o("ariaDescribedBy","describedby");o("ariaLabelledBy","labelledby")}if(n){var l=function(e){var t=typeof e;return e===null||t==="number"||t==="string"||t==="boolean"};var u={};var f,c,p;for(f in n){c=n[f];if(l(c)){u[f]=c}else if(typeof c==="object"&&l(c.value)){p="";if(c.append&&(f==="describedby"||f==="labelledby")){p=i[f]?i[f]+" ":""}u[f]=p+c.value}}Object.assign(i,u)}if(d.isObjectA(t,"sap.ui.core.Element")){var h=t.getParent();if(h&&h.enhanceAccessibilityState){var g=Object.assign({},i);h.enhanceAccessibilityState(t,i);if(i.canSkipRendering==false||i.canSkipRendering==undefined&&d.isObjectA(t,"sap.ui.core.Control")&&A.canSkipRendering(t)&&JSON.stringify(g)!=JSON.stringify(i)){this.attr(R,"")}delete i.canSkipRendering}}for(var m in i){if(i[m]!=null&&i[m]!==""){this.attr(m==="role"?m:"aria-"+m,i[m])}}return this};A.prototype.writeAccessibilityState=A.prototype.accessibilityState;A.prototype.icon=function(e,t,n){var r=sap.ui.require("sap/ui/core/IconPool");if(!r){s.warningThrows("sap/ui/core/IconPool must be loaded before sap.ui.core.RenderManager#icon can be called.",{suffix:"Falling back to synchronous loading of IconPool"},"SyncXHR",null,function(){return{type:"SyncXHR",name:"rendermanager-icon"}});r=sap.ui.requireSync("sap/ui/core/IconPool")}var i=r.isIconURI(e),a=false,u,d,p,h,g;if(typeof t==="string"){t=[t]}if(i){d=r.getIconInfo(e);if(!d){o.error("An unregistered icon: "+e+" is used in sap.ui.core.RenderManager's writeIcon method.");return this}if(!t){t=[]}t.push("sapUiIcon");if(!d.suppressMirroring){t.push("sapUiIconMirrorInRTL")}}if(i){this.openStart("span")}else{this.voidStart("img")}if(Array.isArray(t)){t.forEach(function(e){this.class(e)},this)}if(i){p={"data-sap-ui-icon-content":d.content,role:"presentation",title:d.text||null};this.style("font-family","'"+l(d.fontFamily)+"'")}else{p={role:"presentation",alt:"",src:e}}n=f(p,n);if(!n.id){n.id=c()}if(n.role==="presentation"){n["aria-hidden"]=true}if(i){h=n.alt||n.title||d.text||d.name;g=n.id+"-label";if(n["aria-labelledby"]){a=true;n["aria-labelledby"]+=" "+g}else if(!n.hasOwnProperty("aria-label")){n["aria-label"]=h}}if(typeof n==="object"){for(u in n){if(n.hasOwnProperty(u)&&n[u]!==null){this.attr(u,n[u])}}}if(i){this.openEnd();if(a){this.openStart("span");this.style("display","none");this.attr("id",g);this.openEnd();this.text(h);this.close("span")}this.close("span")}else{this.voidEnd()}return this};A.prototype.writeIcon=A.prototype.icon;A.prototype.getRenderer=function(e){a(e&&d.isObjectA(e,"sap.ui.core.Control"),"oControl must be an sap.ui.core.Control");return A.getRenderer(e)};var w=A.RenderPrefixes={Invisible:n.PlaceholderPrefix,Dummy:"sap-ui-dummy-",Temporary:"sap-ui-tmp-"};A.getRenderer=function(e){a(e&&d.isObjectA(e,"sap.ui.core.Control"),"oControl must be an sap.ui.core.Control");return e.getMetadata().getRenderer()};A.forceRepaint=function(e){var t=e?window.document.getElementById(e):null;var n=typeof e=="string"?t:e;if(n){o.debug("forcing a repaint for "+(n.id||String(n)));var r=n.style.display;var i=document.activeElement;n.style.display="none";n.offsetHeight;n.style.display=r;if(document.activeElement!==i&&i){i.focus()}}};A.createInvisiblePlaceholderId=function(e){return n.createInvisiblePlaceholderId(e)};var I="sap-ui-preserve",P="sap-ui-static",D="data-sap-ui-preserve",O="data-sap-ui-area";function j(){var e=jQuery(document.getElementById(I));if(e.length===0){e=jQuery("<div></div>",{"aria-hidden":"true",id:I}).addClass("sapUiHidden").addClass("sapUiForcedHidden").css("width","0").css("height","0").css("overflow","hidden").appendTo(document.body)}return e}function T(e){var t=jQuery("<div></div>",{id:w.Dummy+e.id}).addClass("sapUiHidden");if(e.hasAttribute(R)){t.attr(R,"")}t.insertBefore(e)}var N=[];A.attachPreserveContent=function(e,t){A.detachPreserveContent(e);N.push({fn:e,context:t})};A.detachPreserveContent=function(e){N=N.filter(function(t){return t.fn!==e})};A.preserveContent=function(e,n,r,i){a(typeof e==="object"&&e.ownerDocument==document,"oRootNode must be a DOM element");m=m?m:sap.ui.require("sap/ui/core/Element");N.forEach(function(t){t.fn.call(t.context||A,{domNode:e})});var s=j();function o(t){while(t&&t!=e&&t.parentNode){t=t.parentNode;if(t.hasAttribute(D)){return true}if(t.hasAttribute("data-sap-ui")){break}}}function l(e,t,n){if(e===t){return true}for(var r=t.getParent();r;r=r.isA("sap.ui.core.UIComponent")?r.oContainer:r.getParent()){if(r.isA("sap.ui.core.Control")){if(!r.getVisible()){return false}var i=r.getDomRef();if(i&&!i.contains(n)){return false}}if(r===e){return true}}}function u(n){if(n.id===I||n.id===P){return}var a=n.getAttribute(D);if(a){let r;if(i){r=m.getElementById(a);if(r&&l(i,r,n)){return}}if(n===e||o(n)){T(n)}else if(r&&n.hasAttribute(R)){T(n)}t.trackFocusForPreservedElement(n);s.append(n)}else if(r&&n.id){t.trackFocusForPreservedElement(n);A.markPreservableContent(jQuery(n),n.id);s.append(n);return}if(!n.hasAttribute(O)){var f=n.firstChild;while(f){n=f;f=f.nextSibling;if(n.nodeType===1){u(n)}}}}p.start(e.id+"---preserveContent","preserveContent for "+e.id,["rendering","preserve"]);if(n){u(e)}else{jQuery(e).children().each(function(e,t){u(t)})}p.end(e.id+"---preserveContent")};A.findPreservedContent=function(e){a(typeof e==="string","sId must be a string");var t=j(),n=t.children("["+D+"='"+e.replace(/(:|\.)/g,"\\$1")+"']");return n};A.markPreservableContent=function(e,t){e.attr(D,t)};A.isPreservedContent=function(e){return e&&e.getAttribute(D)&&e.parentNode&&e.parentNode.id==I};A.getPreserveAreaRef=function(){return j()[0]};var _="data-sap-ui-template";A.markInlineTemplate=function(e){e.attr(_,"")};A.isInlineTemplate=function(e){return e&&e.hasAttribute(_)};A.getApiVersion=function(e){return e&&e.hasOwnProperty("apiVersion")?e.apiVersion:1};A.canSkipRendering=function(e,t){var n=this.getRenderer(e);var r=this.getApiVersion(n)==4;if(!r&&t!=2){return false}var i=r&&!e.hasRenderingDelegate();if(t){var a=e.getDomRef();if(a){a.toggleAttribute(R,!i)}}return i};function M(e,t){var n=t.getId();e.attr("data-sap-ui",n);if(d.isObjectA(t,"sap.ui.core.Control")&&!A.canSkipRendering(t)){e.attr(R,"")}if(t.__slot){e.attr("slot",t.__slot)}t.getCustomData().forEach(function(n){var r=n._checkWriteToDom(t);if(r){e.attr(r.key.toLowerCase(),r.value)}});var r=t.getDragDropConfig().some(function(e){return e.isDraggable(t)});if(!r){var i=t.getParent();if(i&&i.getDragDropConfig){r=i.getDragDropConfig().some(function(e){return e.isDraggable(t)})}}if(r){e.attr("draggable","true");e.attr("data-sap-ui-draggable","true")}return this}var x={before:"beforebegin",prepend:"afterbegin",append:"beforeend",after:"afterend"};function k(e,t,n){if(typeof n=="string"){e.insertAdjacentHTML(x[t],n)}else{e[t](n)}}function B(e){var t=e.getMetadata();var r=!e.getVisible()&&t.getProperty("visible")._oParent.getName()=="sap.ui.core.Control";return r?n:t.getRenderer()}return A},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Renderer", ["sap/base/Log","sap/base/i18n/Localization","sap/base/util/isPlainObject","sap/base/util/ObjectPath","sap/base/assert","sap/base/util/extend"],function(e,r,t,a,n,i){"use strict";var s={};var u;function c(e,r){n(this!=null,"BaseRenderer must be a non-null object");n(typeof e==="string"&&e,"Renderer.extend must be called with a non-empty name for the new renderer");n(r==null||t(r)&&Object.keys(r).every(function(e){return r[e]!==undefined}),"oRendererInfo can be omitted or must be a plain object without any undefined property values");var s=Object.create(this);s.extend=c;i(s,r);(()=>{a.set(e,s)})();return s}s.extend=function(e,r){if(typeof e==="string"){return c.call(this,e,r)}else if(this===s){var t=Object.create(e||null);t._super=e;t.extend=c;return t}else{throw new TypeError("The signature extend(BaseRenderer) without a name can only be called on sap.ui.core.Renderer")}};s.getTextAlign=function(t,a){u=sap.ui.require("sap/ui/core/library");if(!u){e.warning("Synchronous loading of a library.js. Ensure that 'sap/ui/core/library.js' is loaded"+" before sap.ui.core.Renderer#getTextAlign is called.","SyncXHR",null,function(){return{type:"SyncXHR",name:"renderer-getTextAlign"}});u=sap.ui.requireSync("sap/ui/core/library")}var n=u.TextAlign;var i=u.TextDirection;var s="",c=r.getRTL();switch(t){case n.End:switch(a){case i.LTR:s="right";break;case i.RTL:s="left";break;default:s=c?"left":"right";break}break;case n.Begin:switch(a){case i.LTR:s="left";break;case i.RTL:s="right";break;default:s=c?"right":"left";break}break;case n.Right:if(!c||a==i.LTR){s="right"}break;case n.Center:s="center";break;case n.Left:if(c||a==i.RTL){s="left"}break}return s};return s},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Rendering", ["sap/base/config","sap/base/Log","sap/ui/base/EventProvider","sap/ui/performance/trace/Interaction","sap/ui/performance/Measurement"],(e,n,t,r,d)=>{"use strict";const a=n.getLogger("sap.ui.Rendering",e.get({name:"sapUiXxDebugRendering",type:e.Type.Boolean,external:true,freeze:true})?n.Level.DEBUG:Math.min(n.Level.INFO,n.getLevel()));const i=20,s=new t,p=[];let o,u={};let g=[];let U=false;const f=e=>{try{d.start("renderPendingUIUpdates","Render pending UI updates in all UIAreas");a.debug("Render pending UI updates: start ("+(e||"by timer")+")");let n=0;const t=i>0;U=true;do{if(t){n++;if(n>i){U=false;throw new Error("Rendering has been re-started too many times ("+n+"). Add URL parameter sap-ui-xx-debugRendering=true for a detailed analysis.")}if(n>1){a.debug("Render pending UI updates: iteration "+n)}}if(o){if(o!==c){clearTimeout(o)}o=undefined;if(p.length>0){p.pop()()}}l();const e=u;u={};for(const n in e){e[n].rerender()}}while(t&&o);U=false;c.fireUIUpdated();a.debug("Render pending UI updates: finished");d.end("renderPendingUIUpdates")}catch(e){const n=c.fireUIUpdated({failed:e});if(n){throw e}}};const c={notifyInteractionStep(){p.push(r.notifyAsyncStep())},addPrerenderingTask(e,n){if(n){g.unshift(e)}else{g.push(e)}},renderPendingUIUpdates(e,n){if(n!==undefined){p.push(r.notifyAsyncStep());o=setTimeout(f.bind(null,e),n)}else{f(e)}},suspend(){o=c},resume(e){c.renderPendingUIUpdates(e,0)},isPending(){return!!(o||U)},attachUIUpdated(e,n){s.attachEvent("UIUpdated",e,n)},detachUIUpdated(e,n){s.detachEvent("UIUpdated",e,n)},fireUIUpdated(e){return s.fireEvent("UIUpdated",e,true)},getLogger(){return a},invalidateUIArea(e){u[e.getId()]=e;if(!o){a.debug("Registering timer for delayed re-rendering");c.renderPendingUIUpdates("invalidated UIArea",0)}}};const l=()=>{const e=g.slice();g=[];e.forEach(e=>{e()})};return c});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Supportability", ["sap/base/config"],e=>{"use strict";const t={isDebugModeEnabled(){let t=window["sap-ui-debug"]===true||e.get({name:"sapUiDebug",type:e.Type.Boolean,external:true});try{t=t||/^(?:true|x|X)$/.test(window.localStorage.getItem("sap-ui-debug"))}catch(e){}return t},isControlInspectorEnabled(){return e.get({name:"sapUiInspect",type:e.Type.Boolean,external:true})},isStatisticsEnabled(){var t=e.get({name:"sapUiStatistics",type:e.Type.Boolean,defaultValue:e.get({name:"sapStatistics",type:e.Type.Boolean,external:true}),external:true});try{t=t||window.localStorage.getItem("sap-ui-statistics")=="X"}catch(e){}return t},getSupportSettings(){return e.get({name:"sapUiSupport",type:e.Type.StringArray,defaultValue:null,external:true})},getTestRecorderSettings(){return e.get({name:"sapUiTestRecorder",type:e.Type.StringArray,defaultValue:null,external:true})},collectOriginInfo(){return e.get({name:"sapUiOriginInfo",type:e.Type.Boolean,external:true})}};return t});
/*!
 * copyright
 */
sap.ui.predefine("sap/ui/core/Theming", ["sap/base/assert","sap/base/config","sap/base/Event","sap/base/Eventing","sap/base/future","sap/base/Log","sap/base/i18n/Localization","sap/base/util/deepEqual","sap/ui/core/theming/ThemeHelper"],function(e,t,n,i,a,o,s,r,c){"use strict";const h=t.getWritableInstance();const l=new i;const g=document.querySelector("link[rel=icon]")?.getAttribute("href");let f;const p={getTheme:()=>{let e=h.get({name:"sapTheme",type:h.Type.String,defaultValue:h.get({name:"sapUiTheme",type:h.Type.String,external:true}),external:true});if(e===""){const t=c.getDefaultThemeInfo();e=`${t.DEFAULT_THEME}${t.DARK_MODE?"_dark":""}`}const t=e.indexOf("@");if(t>=0){const n=T(e.slice(t+1));e=t>0?e.slice(0,t):e;if(n!==p.getThemeRoot(e)){p.setThemeRoot(e,n)}}e=c.validateAndFallbackTheme(e,p.getThemeRoot(e));return e},setTheme:e=>{if(e){if(e.indexOf("@")!==-1){throw new TypeError("Providing a theme root as part of the theme parameter is not allowed.")}const t=p.getTheme();h.set("sapTheme",e);const n=p.getTheme();const i=t!==n;if(i){const e={theme:{new:n,old:t}};m(e)}if(!f&&i){u({theme:n})}}},getThemeRoot:(e,t)=>{const n=h.get({name:"sapUiThemeRoots",type:h.Type.MergedObject});let i;e??=p.getTheme();if(n[e]&&typeof n[e]==="string"){i=n[e]}else if(n[e]&&typeof n[e]==="object"){i=n[e][t]||n[e][""]}return i},setThemeRoot:(t,n,i,a)=>{e(typeof t==="string","sThemeName must be a string");e(typeof n==="string","sThemeBaseUrl must be a string");const o={name:"sapUiThemeRoots",type:h.Type.MergedObject};const s=h.get(Object.assign(o,{defaultValue:{}}));const c=h.get(Object.assign(o,{defaultValue:{}}));if(typeof i==="boolean"){a=i;i=undefined}c[t]??={};if(typeof c[t]==="string"){c[t]={"":c[t]};s[t]={"":s[t]}}if(i){for(let e=0;e<i.length;e++){const a=i[e];c[t][a]=n}}else{c[t][""]=n}if(!r(s,c)){const e={};h.set("sapUiThemeRoots",c);if(i){e["themeRoots"]={new:Object.assign({},c[t]),old:Object.assign({},s[t])}}else{e["themeRoots"]={new:n,old:s[t]?.[""]}}e["themeRoots"].forceUpdate=a&&t===p.getTheme();m(e)}},getFavicon:async()=>{const e=g||sap.ui.require.toUrl("sap/ui/core/themes/base/icons/favicon.ico");const t=h.get({name:"sapUiFavicon",type:e=>{const t=e.toString();if(["","false"].includes(t.toLowerCase())){return false}else if(["x","true"].includes(t.toLowerCase())){return true}if(!e||new URL(e,window.location.origin).href.startsWith(window.location.origin)){return t}else{o.error("Absolute URLs are not allowed for favicon. The configured favicon will be ignored.",undefined,"sap.ui.core.theming.Theming");return true}}});if(!t){return t}if(typeof t==="string"){return t}else if(f&&!c.isStandardTheme(p.getTheme())){const t=await new Promise(e=>{sap.ui.require(["sap/ui/core/theming/Parameters"],t=>{const n=t.get({name:"sapUiFavicon",_restrictedParseUrls:true,callback:t=>{e(t)}});if(n!==undefined){e(n)}})});return t||e}return e},setFavicon:async e=>{if(typeof e==="string"&&!new URL(e,window.location.origin).href.startsWith(window.location.origin)){throw new TypeError("Path to favicon must be relative to the current origin")}h.set("sapUiFavicon",e);const t=await p.getFavicon();if(t){await new Promise((e,n)=>{sap.ui.require(["sap/ui/util/Mobile"],n=>{n.setIcons({favicon:t});e()},n)})}else{document.querySelector("link[rel=icon]")?.remove()}},attachAppliedOnce:e=>{const t="applied";if(f){if(f.themeLoaded){e.call(null,new n(t,{theme:p.getTheme()}))}else{l.attachEventOnce(t,e)}}else{e.call(null,new n(t,{theme:p.getTheme()}))}},attachApplied:e=>{const t="applied";l.attachEvent(t,e);if(f){if(f.themeLoaded){e.call(null,new n(t,{theme:p.getTheme()}))}}else{e.call(null,new n(t,{theme:p.getTheme()}))}},detachApplied:e=>{l.detachEvent("applied",e)},attachChange:e=>{l.attachEvent("change",e)},detachChange:e=>{l.detachEvent("change",e)},attachThemeScopingChanged:e=>{l.attachEvent("themeScopingChanged",e)},detachThemeScopingChanged:e=>{l.detachEvent("themeScopingChanged",e)},fireThemeScopingChanged:e=>{l.fireEvent("themeScopingChanged",e)},notifyContentDensityChanged:()=>{u({theme:p.getTheme()})},registerThemeManager:e=>{f=e;f._attachThemeApplied(function(e){u(n.getParameters(e))});s.attachChange(function(e){var t=e.rtl;if(t!==undefined){f._updateThemeUrls(p.getTheme())}})}};function m(e){if(e){l.fireEvent("change",e)}}function u(e){l.fireEvent("applied",e)}function d(e,t){const n=h.get({name:"sapAllowedThemeOrigins",type:h.Type.String});return!!n?.split(",").some(n=>{try{n=t&&!n.startsWith("//")?"//"+n:n;return n==="*"||e===new URL(n.trim(),window.location.href).origin}catch(e){a.errorThrows("sapAllowedThemeOrigins provides invalid theme origin: "+n,{cause:e});return false}})}function T(e){const t=e.startsWith("//");let n,i;try{n=new URL(e,window.location.href);n.search="";if(n.origin&&d(n.origin,t)){i=n.toString()}else{n=new URL(n.pathname,window.location.href);i=n.toString()}if(t){i=i.replace(n.protocol,"")}i+=(i.endsWith("/")?"":"/")+"UI5/"}catch(e){}return i}p.attachApplied(()=>{p.getFavicon().then(e=>{if(e){sap.ui.require(["sap/ui/util/Mobile"],t=>{t.setIcons({favicon:e})})}})});return p});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/UIAreaRegistry", ["sap/base/Log","sap/ui/base/ManagedObjectRegistry"],(r,e)=>{"use strict";const a=function(e,a,t){var i="adding UIArea with duplicate id '"+e+"'";r.error(i);throw new Error("Error: "+i)};const t=e.create({onDuplicate:a});return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/_UrlResolver", ["sap/ui/thirdparty/URI"],function(e){"use strict";var r={};r._processResourceConfiguration=function(e,a){a=a||{};var i=a.alreadyResolvedOnRoot||false;var n=e.bundleUrlRelativeTo||a.relativeTo;var o;if(n==="manifest"){o=a.manifestBaseURI}else if(n==="component"){o=a.baseURI}else{o=n||a.baseURI}Object.keys(e).forEach(function(s){if(s==="bundleUrl"&&!i){var t=e[s];var f=r._resolveUri(t,o);e[s]=f&&f.toString()}if(s==="terminologies"){var u=e[s];for(var l in u){r._processResourceConfiguration(u[l],{relativeTo:n,baseURI:a.baseURI,manifestBaseURI:a.manifestBaseURI})}}if(s==="enhanceWith"){var v=e[s]||[];for(var R=0;R<v.length;R++){r._processResourceConfiguration(v[R],{relativeTo:n,baseURI:a.baseURI,manifestBaseURI:a.manifestBaseURI})}}})};function a(r){if(r&&r instanceof e){return r}return new e(r)}r._resolveUri=function(e,i){return r._resolveUriRelativeTo(a(e),a(i))};r._resolveUriRelativeTo=function(r,a){if(r.is("absolute")||r.path()&&r.path()[0]==="/"){return r}var i=new e(document.baseURI).search("");a=a.absoluteTo(i);return r.absoluteTo(a).relativeTo(i)};return r});
//# sourceMappingURL=Eventing-preload-0.js.map
