//@ui5-bundle Library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/future", ["sap/base/assert","sap/base/config","sap/base/Log"],(e,s,r)=>{"use strict";const f=s.get({name:"sapUiXxFuture",type:s.Type.Boolean,external:true});let i=f;function a(e,s,f,...a){if(i){throw new Error(s,{cause:f?.cause})}if(f){if(f.suffix){s+=" "+f.suffix}if(f.cause){a.unshift(f.cause)}if(!f.cause&&!f.suffix){a.unshift(f)}}r[e]("[FUTURE FATAL] "+s,...a)}function t(e,s,f,a,t,...n){if(i){s(new Error(a,{cause:t?.cause}));return}if(t){if(t.suffix){a+=" "+t.suffix}if(t.cause){n.unshift(t.cause)}if(!t.cause&&!t.suffix){n.unshift(t)}}e();r[f]("[FUTURE FATAL] "+a,...n)}const n={get active(){return i},set active(e){i=!!(e??f)},fatalThrows(...e){a("fatal",...e)},errorThrows(...e){a("error",...e)},warningThrows(...e){a("warning",...e)},assertThrows(s,r){const f=typeof r==="function"?r():r;if(!s&&i){throw new Error(r)}e(s,"[FUTURE FATAL] "+f)},warningRejects(e,s,...r){t(e,s,"warning",...r)}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/i18n/LanguageFallback", ["sap/base/Log"],function(e){"use strict";const n=/(?:^|-)(saptrc|sappsd|saprigi)(?:-|$)/i;const r=/^((?:[A-Z]{2,3}(?:-[A-Z]{3}){0,3})|[A-Z]{4}|[A-Z]{5,8})(?:-([A-Z]{4}))?(?:-([A-Z]{2}|[0-9]{3}))?((?:-[0-9A-Z]{5,8}|-[0-9][0-9A-Z]{3})*)((?:-[0-9A-WYZ](?:-[0-9A-Z]{2,8})+)*)(?:-(X(?:-[0-9A-Z]{1,8})+))?$/i;const i={he:"iw",yi:"ji",nb:"no"};const t={iw:"he",ji:"yi"};const a=function(e,t){var a;if(typeof e==="string"&&(a=r.exec(e.replace(/_/g,"-")))){var s=a[1].toLowerCase();if(!t){s=i[s]||s}var o=a[2]?a[2].toLowerCase():undefined;var l=a[3]?a[3].toUpperCase():undefined;var f=a[4]?a[4].slice(1):undefined;var c=a[6];if(c&&(a=n.exec(c))||f&&(a=n.exec(f))){return"en_US_"+a[1].toLowerCase()}if(s==="zh"&&!l){if(o==="hans"){l="CN"}else if(o==="hant"){l="TW"}}if(s==="sr"&&o==="latn"){if(t){s="sr_Latn"}else{s="sh"}}return s+(l?"_"+l+(f?"_"+f.replace("-","_"):""):"")}};const s=function(e,n){if(e===""){return e}var r=a(e,n);if(r===undefined){throw new TypeError("Locale '"+e+"' is not a valid BCP47 language tag")}return r};const o=function(e,n){var i;if(typeof e==="string"&&(i=r.exec(e.replace(/_/g,"-")))){var a=i[1].toLowerCase();var s=i[2]?i[2].toLowerCase():undefined;if(n&&a==="sh"&&!s){a="sr_Latn"}else if(!n&&a==="sr"&&s==="latn"){a="sh"}a=t[a]||a;return a+(i[3]?"-"+i[3].toUpperCase()+(i[4]?"-"+i[4].slice(1).replace("_","-"):""):"")}};const l=function(e,n){if(!n||n.length===0||n.includes(e)){return e}e=o(e,true);if(e){e=a(e,true)}if(n.includes(e)){return e}return undefined};const f=function(n,r,i,t,a){r=r&&r.map(function(e){return s(e,true)});if(!a){var o=i!==undefined;i=o?i:"en";i=s(i);if(i!==""&&!l(i,r)){var f="The fallback locale '"+i+"' is not contained in the list of supported locales ['"+r.join("', '")+"']"+t+" and will be ignored.";if(o){throw new Error(f)}e.error(f)}}var c=[],u;while(n!=null){u=l(n,r);if(u!==undefined&&c.indexOf(u)===-1){c.push(u)}if(!n){n=null}else if(n==="zh_HK"){n="zh_TW"}else if(n.lastIndexOf("_")>=0){n=n.slice(0,n.lastIndexOf("_"))}else if(a){n=null}else if(i){n=i;i=null}else{n=""}}return c};const c=function(e,n,r){return f(a(e),n,r,"")};return{convertLocaleToBCP47:o,calculate:f,getFallbackLocales:c,normalize:a}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/i18n/ResourceBundle", ["sap/base/assert","sap/base/future","sap/base/Log","sap/base/i18n/LanguageFallback","sap/base/i18n/Localization","sap/base/strings/formatMessage","sap/base/util/Properties","sap/base/util/merge"],function(e,r,t,n,a,s,o,i){"use strict";var l={en_US_saptrc:"1Q",en_US_sappsd:"2Q",en_US_saprigi:"3Q"};var u="en";const c={_oCache:new Map,_delete(e){this._oCache.delete(e)},_load(e){return o.create(e)},_set(e,r){this._oCache.set(e,r)},get(e,r,t){if(this._oCache.has(e)){const r=this._oCache.get(e);if(t){return Promise.resolve(r)}else if(!(r instanceof Promise)){return r}}const n=this._load(r);if(n instanceof Promise){n.then(r=>{if(r){this._set(e,r)}else{this._delete(e)}}).catch(r=>{this._delete(e);throw r})}if(n){this._set(e,n)}return n}};function f(e){var r;r=a.getLanguage();r=n.normalize(r);return r||e}var h=/^((?:[^?#]*\/)?[^\/?#]*)(\.[^.\/?#]+)((?:\?([^#]*))?(?:#(.*))?)$/;var p=[".properties",".hdbtextbundle"];function d(e){var r=h.exec(e);if(!r||p.indexOf(r[2])<0){throw new Error("resource URL '"+e+"' has unknown type (should be one of "+p.join(",")+")")}return{url:e,prefix:r[1],ext:r[2],query:r[4],hash:r[5]||"",suffix:r[2]+(r[3]||"")}}function g(e,t,s,o,i,l,c){this.sLocale=n.normalize(t)||f(l===undefined?u:l);this.oUrlInfo=d(e);this.bIncludeInfo=s;this.bAsync=o;this.aCustomBundles=[];this.aPropertyFiles=[];this.aPropertyOrigins=[];this.aLocales=[];this._aFallbackLocales=n.calculate(this.sLocale,i||a.getSupportedLanguages(),l," of the bundle '"+this.oUrlInfo.url+"'",c);if(o){return b(this).then(()=>this,e=>{r.errorThrows(e.message);return this})}m(this)}g.prototype._enhance=function(e){if(e instanceof g){this.aCustomBundles.push(e)}else{t.error("Custom resource bundle is either undefined or not an instanceof sap/base/i18n/ResourceBundle. Therefore this custom resource bundle will be ignored!")}};g.prototype.getText=function(r,t,n){var a=this._getTextFromProperties(r,t);if(a!=null){return a}a=this._getTextFromFallback(r,t);if(a!=null){return a}if(n){return undefined}else{e(false,"could not find any translatable text for key '"+r+"' in bundle file(s): '"+this.aPropertyOrigins.join("', '")+"'");return this._formatValue(r,r,t)}};g.prototype._formatValue=function(e,t,n){if(typeof e==="string"){if(n!==undefined&&!Array.isArray(n)){r.errorThrows("sap/base/i18n/ResourceBundle: value for parameter 'aArgs' is not of type array")}if(n){e=s(e,n)}if(this.bIncludeInfo){e=new String(e);e.originInfo={source:"Resource Bundle",url:this.oUrlInfo.url,locale:this.sLocale,key:t}}}return e};g.prototype._getTextFromFallback=function(e,r){var t,n;for(n=this.aCustomBundles.length-1;n>=0;n--){t=this.aCustomBundles[n]._getTextFromFallback(e,r);if(t!=null){return t}}while(typeof t!=="string"&&this._aFallbackLocales.length){var a=m(this);if(a){t=a.getProperty(e);if(typeof t==="string"){return this._formatValue(t,e,r)}}}return null};g.prototype._getTextFromProperties=function(e,r){var t=null,n;for(n=this.aCustomBundles.length-1;n>=0;n--){t=this.aCustomBundles[n]._getTextFromProperties(e,r);if(t!=null){return t}}for(n=0;n<this.aPropertyFiles.length;n++){t=this.aPropertyFiles[n].getProperty(e);if(typeof t==="string"){return this._formatValue(t,e,r)}}return null};g.prototype.hasText=function(e){return this.aPropertyFiles.length>0&&typeof this.aPropertyFiles[0].getProperty(e)==="string"};g.prototype._recreate=function(){if(!this._mCreateFactoryParams){var e=new Error("ResourceBundle instance can't be recreated as it has not been created by the ResourceBundle.create factory.");if(this.bAsync){return Promise.reject(e)}else{throw e}}else{return g.create(this._mCreateFactoryParams)}};function b(e){if(e._aFallbackLocales.length){return _(e,true).then(function(r){return r||b(e)})}return Promise.resolve(null)}function m(e){while(e._aFallbackLocales.length){var r=_(e,false);if(r){return r}}return null}function _(e,r){var t=e._aFallbackLocales.shift();if(t!=null){var a=e.oUrlInfo,s,o;if(a.ext===".hdbtextbundle"){if(l[t]){s=a.prefix+a.suffix+"?"+(a.query?a.query+"&":"")+"sap-language="+l[t]+(a.hash?"#"+a.hash:"")}else{s=a.url}o={"Accept-Language":n.convertLocaleToBCP47(t)||"*"}}else{s=a.prefix+(t?"_"+t:"")+a.suffix}var i=JSON.stringify({url:new URL(s,document.baseURI).href,headers:o});var u={url:s,headers:o,async:!!r,returnNullIfMissing:true};const h=c.get(i,u,u.async);var f=function(r){if(r){e.aPropertyFiles.push(r);e.aPropertyOrigins.push(s);e.aLocales.push(t)}return r};return r?h.then(f):f(h)}return r?Promise.resolve(null):null}g._getUrl=function(e,r){var t=e;if(r){r=r.replace(/\./g,"/");t=sap.ui.require.toUrl(r)+".properties"}return t};function y(e,r,t,n,a,s,o){if(!r){return[]}var i=[];r.forEach(function(r){if(r.fallbackLocale===undefined){r.fallbackLocale=s}if(r.supportedLocales===undefined){r.supportedLocales=o}var l=g._getUrl(r.bundleUrl,r.bundleName);var u=new g(l,t,n,a,r.supportedLocales,r.fallbackLocale);i.push(u);if(r.terminologies){i=i.concat(v(e,r.terminologies,t,n,a))}});return i}function v(e,r,t,n,a){if(!e){return[]}e=e.filter(function(e){return r.hasOwnProperty(e)});e.reverse();return e.map(function(e){var s=r[e];var o=g._getUrl(s.bundleUrl,s.bundleName);var i=s.supportedLocales;return new g(o,t,n,a,i,null,true)})}g.create=function(e){var r=i({},e);e=i({url:"",includeInfo:false},e);if(e.bundleUrl||e.bundleName){e.url=e.url||g._getUrl(e.bundleUrl,e.bundleName)}e=g._enrichBundleConfig(e);var t=new g(e.url,e.locale,e.includeInfo,!!e.async,e.supportedLocales,e.fallbackLocale);if(t instanceof Promise){t=t.then(function(e){e._mCreateFactoryParams=r;return e})}else{t._mCreateFactoryParams=r}var n=[];if(e.terminologies){n=n.concat(v(e.activeTerminologies,e.terminologies,e.locale,e.includeInfo,!!e.async))}if(e.enhanceWith){n=n.concat(y(e.activeTerminologies,e.enhanceWith,e.locale,e.includeInfo,!!e.async,e.fallbackLocale,e.supportedLocales))}if(n.length){if(t instanceof Promise){t=t.then(function(e){return Promise.all(n).then(function(r){r.forEach(e._enhance,e)}).then(function(){return e})})}else{n.forEach(t._enhance,t)}}return t};g._enrichBundleConfig=function(e){return e};g._getFallbackLocales=n.getFallbackLocales;g._getPropertiesCache=function(){return c._oCache};return g});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/strings/formatMessage", ["sap/base/assert"],function(r){"use strict";var e=/('')|'([^']+(?:''[^']*)*)(?:'|$)|\{([0-9]+(?:\s*,[^{}]*)?)\}|[{}]/g;var t=function(t,n){r(typeof t==="string"||t instanceof String,"pattern must be string");if(arguments.length>2||n!=null&&!Array.isArray(n)){n=Array.prototype.slice.call(arguments,1)}n=n||[];return t.replace(e,function(r,e,t,s,a){if(e){return"'"}else if(t){return t.replace(/''/g,"'")}else if(s){return String(n[parseInt(s)])}throw new Error("formatMessage: pattern syntax error at pos. "+a)})};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/ObjectPath", [],function(){"use strict";var r={};var e=globalThis;function t(r){return Array.isArray(r)?r.slice():r.split(".")}r.create=function(r,n){var a=n||e;var o=t(r);for(var i=0;i<o.length;i++){var u=o[i];if(a[u]===null||a[u]!==undefined&&(typeof a[u]!=="object"&&typeof a[u]!=="function")){throw new Error("Could not set object-path for '"+o.join(".")+"', path segment '"+u+"' already exists.")}a[u]=a[u]||{};a=a[u]}return a};r.get=function(r,n){var a=n||e;var o=t(r);var i=o.pop();for(var u=0;u<o.length&&a;u++){a=a[o[u]]}return a?a[i]:undefined};r.set=function(n,a,o){o=o||e;var i=t(n);var u=i.pop();var f=r.create(i,o);f[u]=a};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/Properties", ["sap/base/util/LoaderExtensions"],function(e){"use strict";var r=function(){this.mProperties={};this.aKeys=null};r.prototype.getProperty=function(e,r){var t=this.mProperties[e];if(typeof t=="string"){return t}else if(r){return r}return null};r.prototype.getKeys=function(){if(!this.aKeys){this.aKeys=Object.keys(this.mProperties)}return this.aKeys};r.prototype.setProperty=function(e,r){if(typeof r!="string"){return}if(typeof this.mProperties[e]!="string"&&this.aKeys){this.aKeys.push(String(e))}this.mProperties[e]=r};r.prototype.clone=function(){var e=new r;e.mProperties=Object.assign({},this.mProperties);return e};var t=typeof chrome==="object"||typeof v8==="object"?function(e,r){if(r>2&&40*r>e.length){Number(e)}return e}:function(e){return e};var n=/(?:\r\n|\r|\n|^)[ \t\f]*/;var i=/(\\u[0-9a-fA-F]{0,4})|(\\.)|(\\$)|([ \t\f]*[ \t\f:=][ \t\f]*)/g;var s=/(\\u[0-9a-fA-F]{0,4})|(\\.)|(\\$)/g;var o={"\\f":"\f","\\n":"\n","\\r":"\r","\\t":"\t"};function f(e,r){var f=e.split(n),u,l,a,c,p,h,y,g;function d(e){if(c){c=c+e;g++}else{c=e;g=0}}r.mProperties={};for(p=0;p<f.length;p++){u=f[p];if(u===""||u.charAt(0)==="#"||u.charAt(0)==="!"){continue}l=i;l.lastIndex=y=0;a=null;c="";while((h=l.exec(u))!==null){if(y<h.index){d(u.slice(y,h.index))}y=l.lastIndex;if(h[1]){if(h[1].length!==6){throw new Error("Incomplete Unicode Escape '"+h[1]+"'")}d(String.fromCharCode(parseInt(h[1].slice(2),16)))}else if(h[2]){d(o[h[2]]||h[2].slice(1))}else if(h[3]){u=f[++p];l.lastIndex=y=0}else if(h[4]){a=c;c="";l=s;l.lastIndex=y}}if(y<u.length){d(u.slice(y))}if(a==null){a=c;c=""}r.mProperties[a]=t(c,c?g:0)}}r.create=function(t){t=Object.assign({url:undefined,headers:{}},t);var n=!!t.async,i=new r,s;function o(e){if(typeof e==="string"){f(e,i);return i}return t.returnNullIfMissing?null:i}if(typeof t.url==="string"){s=e.loadResource({url:t.url,dataType:"text",headers:t.headers,failOnError:false,async:n})}if(n){if(!s){return Promise.resolve(o(null))}return s.then(function(e){return o(e)},function(e){throw e instanceof Error?e:new Error("Problem during loading of property file '"+t.url+"': "+e)})}return o(s)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/Version", [],function(){"use strict";var t=/^[0-9]+(?:\.([0-9]+)(?:\.([0-9]+))?)?(.*)$/;function n(r,i,e,o){if(r instanceof n){return r}if(!(this instanceof n)){return new n(r,i,e,o)}var u;if(typeof r==="string"){u=t.exec(r)}else if(Array.isArray(r)){u=r}else{u=arguments}u=u||[];function f(t){t=parseInt(t);return isNaN(t)?0:t}r=f(u[0]);i=f(u[1]);e=f(u[2]);o=String(u[3]||"");this.toString=function(){return r+"."+i+"."+e+o};this.getMajor=function(){return r};this.getMinor=function(){return i};this.getPatch=function(){return e};this.getSuffix=function(){return o};this.compareTo=function(t,u,f,s){var a=n.apply(window,arguments);return r-a.getMajor()||i-a.getMinor()||e-a.getPatch()||(o<a.getSuffix()?-1:o===a.getSuffix()?0:1)}}n.prototype.inRange=function(t,n){return this.compareTo(t)>=0&&this.compareTo(n)<0};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/array/uniqueSort", ["sap/base/assert"],function(r){"use strict";var a=function(a){r(Array.isArray(a),"uniqueSort: input parameter must be an Array");var e=a.length;if(e>1){a.sort();var i=0;for(var t=1;t<e;t++){if(a.indexOf(a[t])===t){a[++i]=a[t]}}if(++i<e){a.splice(i,e-i)}}return a};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/deepExtend", ["./_merge"],function(r){"use strict";var u=function(){var u=[true,true];u.push.apply(u,arguments);return r.apply(null,u)};return u});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/isEmptyObject", [],function(){"use strict";var r=function r(n){for(var e in n){return false}return true};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/merge", ["./_merge"],function(e){"use strict";var r=function(){var r=[true,false];r.push.apply(r,arguments);return e.apply(null,r)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/resolveReference", ["sap/base/util/ObjectPath"],function(t){"use strict";var n=Object.create(null);function e(e,i,o){var r,f;if(i&&e[0]in i){f=e.length>1?t.get(e.slice(0,-1),i):i;r=f&&f[e[e.length-1]];if(typeof r==="function"&&o.bindContext){r=r.bind(o.rootContext||f)}return r}return n}var i=function(i,o,r){o=o||{};r=r||{};r.bindContext=r.bindContext!==false;r.bindDotContext=r.bindDotContext!==false;var f=i.split("."),u=f.shift()||".",d=u===".",b=n;f.unshift(u);if(r.preferDotContext&&!d){b=e(f,o["."],{bindContext:r.bindContext&&r.bindDotContext,rootContext:o["."]})}if(b===n){b=e(f,o,{bindContext:r.bindContext&&(d?r.bindDotContext:f.length>1),rootContext:d?o["."]:undefined})}if(!d){if(b===n&&r.useProbingRequire){b=sap.ui.require(i.replace(/\./g,"/"));if(b===undefined){b=n}}if(b===n){b=t.get(i)}}return b===n?undefined:b};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/Global", ["sap/ui/VersionInfo","sap/base/Log","sap/base/assert","sap/base/util/ObjectPath"],function(e,a,r,t){"use strict";if(globalThis.OpenAjax&&globalThis.OpenAjax.hub){OpenAjax.hub.registerLibrary("sap","http://www.sap.com/","0.1",{})}var n;let s={version:"1.136.0",buildinfo:{lastchange:"",buildtime:"20250513-1245"}};s=Object.assign(sap.ui,s);var o=sap.ui.loader._.getSyncCallBehavior();sap.ui.getVersionInfo=function(r){if(r&&r.async){a.info("Do not use deprecated function 'sap.ui.getVersionInfo'. Use"+" 'sap/ui/VersionInfo' module's asynchronous .load function instead")}else{a.warning("Do not use deprecated function 'sap.ui.getVersionInfo' synchronously! Use"+" 'sap/ui/VersionInfo' module's asynchronous .load function instead","Deprecation",null,function(){return{type:"sap.ui.getVersionInfo",name:"Global"}})}return e._load(r)};sap.ui.namespace=function(e){r(false,"sap.ui.namespace is long time deprecated and shouldn't be used");return t.create(e)};sap.ui.lazyRequire=function(e,s,i){r(typeof e==="string"&&e,"lazyRequire: sClassName must be a non-empty string");r(!s||typeof s==="string","lazyRequire: sMethods must be empty or a string");if(o===2){a.error("[nosync] lazy stub creation ignored for '"+e+"'");return}var u=e.replace(/\//gi,"."),l=u.lastIndexOf("."),c=u.substr(0,l),p=u.substr(l+1),f=t.create(c),y=f[p],d=(s||"new").split(" "),b=d.indexOf("new");i=i||u;if(!y){if(b>=0){y=function(){if(o){if(o===1){a.error("[nosync] lazy stub for constructor '"+u+"' called")}}else{a.debug("lazy stub for constructor '"+u+"' called.")}sap.ui.requireSync(i.replace(/\./g,"/"));var t=f[p];r(typeof t==="function","lazyRequire: oRealClass must be a function after loading");if(t._sapUiLazyLoader){throw new Error("lazyRequire: stub '"+u+"'has not been replaced by module '"+i+"'")}var s=Object.create(t.prototype);if(!(this instanceof y)){n=n||sap.ui.require("sap/ui/base/Object");if(n&&s instanceof n){a.error("Constructor "+e+' has been called without "new" operator!',null,null,function(){try{throw new Error}catch(e){return e}})}}var l=t.apply(s,arguments);if(l&&(typeof l==="function"||typeof l==="object")){s=l}return s};y._sapUiLazyLoader=true;d.splice(b,1)}else{y={}}f[p]=y}d.forEach(function(e){if(!y[e]){y[e]=function(){if(o){if(o===1){a.error("[no-sync] lazy stub for method '"+u+"."+e+"' called")}}else{a.debug("lazy stub for method '"+u+"."+e+"' called.")}sap.ui.requireSync(i.replace(/\./g,"/"));var t=f[p];r(typeof t==="function"||typeof t==="object","lazyRequire: oRealClass must be a function or object after loading");r(typeof t[e]==="function","lazyRequire: method must be a function");if(t[e]._sapUiLazyLoader){throw new Error("lazyRequire: stub '"+u+"."+e+"' has not been replaced by loaded module '"+i+"'")}return t[e].apply(t,arguments)};y[e]._sapUiLazyLoader=true}})};sap.ui.lazyRequire._isStub=function(e){r(typeof e==="string"&&e,"lazyRequire._isStub: sClassName must be a non-empty string");var a=e.lastIndexOf("."),n=e.slice(0,a),s=e.slice(a+1),o=t.get(n||"");return!!(o&&typeof o[s]==="function"&&o[s]._sapUiLazyLoader)};sap.ui.resource=function(e,a){r(typeof e==="string","sLibraryName must be a string");r(typeof a==="string","sResourcePath must be a string");return sap.ui.require.toUrl((String(e).replace(/\./g,"/")+"/"+a).replace(/^\/*/,""))};sap.ui.localResources=function(e){r(e,"sNamespace must not be empty");var a={};a[e.replace(/\./g,"/")]="./"+e.replace(/\./g,"/");sap.ui.loader.config({paths:a})};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/VersionInfo", ["sap/base/util/LoaderExtensions"],function(n){"use strict";let e;var r={get _content(){return e}};r.load=function(n){n=n||{};n.async=true;return r._load(n)};var i=null;var t;var a;function s(n){e=n;t=null;a=null}Object.defineProperty(sap.ui,"versioninfo",{configurable:true,enumerable:true,get:function(){return e},set:function(n){s(n)}});r._load=function(t){if(typeof t!=="object"){t={library:t}}t.async=t.async===true;t.failOnError=t.failOnError!==false;if(!e){if(t.async&&i instanceof Promise){return i.then(function(){return r._load(t)})}var a=function(n){i=null;if(n===null){return undefined}s(n);return r._load(t)};var o=function(n){i=null;throw n};var f=n.loadResource("sap-ui-version.json",{async:t.async,failOnError:t.async||t.failOnError});if(f instanceof Promise){i=f;return f.then(a,o)}else{return a(f)}}else{var l;if(typeof t.library!=="undefined"){var u=e.libraries;if(u){for(var c=0,d=u.length;c<d;c++){if(u[c].name===t.library){l=u[c];break}}}}else{l=e}return t.async?Promise.resolve(l):l}};function o(){if(e){if(e.libraries&&!t){t={};e.libraries.forEach(function(n,e){t[n.name]={};var r=n.manifestHints&&n.manifestHints.dependencies&&n.manifestHints.dependencies.libs;for(var i in r){if(!r[i].lazy){t[n.name][i]=true}}})}if(e.components&&!a){a={};Object.keys(e.components).forEach(function(n){var r=e.components[n];a[n]={library:r.library,hasOwnPreload:r.hasOwnPreload||false,dependencies:[]};var i=r.manifestHints&&r.manifestHints.dependencies&&r.manifestHints.dependencies.libs;for(var t in i){if(!i[t].lazy){a[n].dependencies.push(t)}}})}}}r._getTransitiveDependencyForLibraries=function(n){o();const e=Object.create(null);function r(n,r){if(e[n]==null){e[n]={name:n,...r&&{lazy:r}}}else{if(e[n].lazy&&!r){delete e[n].lazy}}}for(const{name:e,lazy:i}of n){r(e,i);if(t?.[e]){for(const n in t[e]){r(n,i)}}}return Object.values(e)};r._getTransitiveDependencyForComponent=function(n){o();if(a){return a[n]}};r._reset=function(){s()};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/DataType", ["sap/base/future","sap/base/util/ObjectPath","sap/base/assert","sap/base/Log","sap/base/util/isPlainObject","sap/base/util/resolveReference","sap/base/i18n/date/_EnumHelper"],function(e,t,n,r,a,i,u){"use strict";var o=function(){throw new Error};o.prototype.getName=function(){return undefined};o.prototype.getBaseType=function(){return undefined};o.prototype.getPrimitiveType=function(){var e=this;while(e.getBaseType()){e=e.getBaseType()}return e};o.prototype.getComponentType=function(){return undefined};o.prototype.getDefaultValue=function(){return undefined};o.prototype.isArrayType=function(){return false};o.prototype.isEnumType=function(){return false};o.prototype.getEnumValues=function(){return undefined};o.prototype.parseValue=function(e){return e};o.prototype.isValid=undefined;o.prototype.setNormalizer=function(e){n(typeof e==="function","DataType.setNormalizer: fnNormalizer must be a function");this._fnNormalizer=typeof e==="function"?e:undefined};o.prototype.normalize=function(e){return this._fnNormalizer?this._fnNormalizer(e):e};function s(e,t,n){t=t||{};var r=n||o.prototype;var a=Object.create(r);a.getName=function(){return e};if(t.hasOwnProperty("defaultValue")){var i=t.defaultValue;a.getDefaultValue=function(){return i}}if(t.isValid){var u=t.isValid;a.isValid=r.isValid?function(e){if(!r.isValid(e)){return false}return u(e)}:u}if(t.parseValue){a.parseValue=t.parseValue}a.getBaseType=function(){return n};return a}var f={any:s("any",{defaultValue:null,isValid:function(e){return true}}),boolean:s("boolean",{defaultValue:false,isValid:function(e){return typeof e==="boolean"},parseValue:function(e){return e=="true"}}),int:s("int",{defaultValue:0,isValid:function(e){return typeof e==="number"&&(isNaN(e)||Math.floor(e)==e)},parseValue:function(e){return parseInt(e)}}),float:s("float",{defaultValue:0,isValid:function(e){return typeof e==="number"},parseValue:function(e){return parseFloat(e)}}),string:s("string",{defaultValue:"",isValid:function(e){return typeof e==="string"||e instanceof String},parseValue:function(e){return e}}),object:s("object",{defaultValue:null,isValid:function(e){return typeof e==="object"||typeof e==="function"},parseValue:function(e){return e?JSON.parse(e):null}}),function:s("function",{defaultValue:null,isValid:function(e){return e==null||typeof e==="function"},parseValue:function(e,t){if(e===""){return undefined}if(!/^\.?[A-Z_\$][A-Z0-9_\$]*(\.[A-Z_\$][A-Z0-9_\$]*)*$/i.test(e)){throw new Error("Function references must consist of dot separated "+"simple identifiers (A-Z, 0-9, _ or $) only, but was '"+e+"'")}var n,r=t&&t.context,a=t&&t.locals;n=i(e,Object.assign({".":r},a));if(n&&this.isValid(n)){return n}throw new TypeError("The string '"+e+"' couldn't be resolved to a function")}})};var p=s("array",{defaultValue:[]});function l(e){n(e instanceof o,"DataType.<createArrayType>: componentType must be a DataType");var t=Object.create(o.prototype);t.getName=function(){return e.getName()+"[]"};t.getComponentType=function(){return e};t.isValid=function(t){if(t===null){return true}if(Array.isArray(t)){for(var n=0;n<t.length;n++){if(!e.isValid(t[n])){return false}}return true}return false};t.parseValue=function(t){var n=t.split(",");for(var r=0;r<n.length;r++){n[r]=e.parseValue(n[r])}return n};t.isArrayType=function(){return true};t.getBaseType=function(){return p};return t}const c=Object.create(null);function y(e,t){var n={},r;for(var a in t){var i=t[a];if(!r){r=i}if(typeof i!=="string"){throw new Error("Value "+i+" for enum type "+e+" is not a string")}if(!n.hasOwnProperty(i)||a==i){n[i]=a}}var u=Object.create(o.prototype);u.getName=function(){return e};u.isValid=function(e){return typeof e==="string"&&n.hasOwnProperty(e)};u.parseValue=function(e){return t[e]};u.getDefaultValue=function(){return r};u.getBaseType=function(){return f.string};u.isEnumType=function(){return true};u.getEnumValues=function(){return t};return u}o.getType=function(i){n(i&&typeof i==="string","sTypeName must be a non-empty string");var u=f[i];if(!(u instanceof o)){if(i.indexOf("[]",i.length-2)>0){var s=i.slice(0,-2),p=this.getType(s);u=p&&l(p);if(u){f[i]=u}}else if(i!=="array"){u=c[i];if(u==null){u=t.get(i);if(u!=null){r.error(`[DEPRECATED] The type '${i}' was accessed via globals. Defining types via globals is deprecated. `+`In case the referenced type is an enum: require the module 'sap/ui/base/DataType' and call the static 'DataType.registerEnum' API. `+`In case the referenced type is non-primitive, please note that only primitive types (and those derived from them) are supported for ManagedObject properties. `+`If the given type is an interface or a subclass of ManagedObject, you can define a "0..1" aggregation instead of a property`)}}if(u instanceof o){f[i]=u}else if(a(u)){u=f[i]=y(i,u);delete c[i]}else if(u){e.warningThrows("'"+i+"' is not a valid data type. Falling back to type 'any'.");u=f.any}else{e.errorThrows("data type '"+i+"' could not be found.");u=undefined}}}return u};o.createType=function(t,r,a){n(typeof t==="string"&&t,"DataType.createType: type name must be a non-empty string");n(a==null||a instanceof o||typeof a==="string"&&a,"DataType.createType: base type must be empty or a DataType or a non-empty string");if(/[\[\]]/.test(t)){e.errorThrows("DataType.createType: array types ('something[]') must not be created with createType, "+"they're created on-the-fly by DataType.getType")}if(typeof a==="string"){a=o.getType(a)}a=a||f.any;if(a.isArrayType()||a.isEnumType()){e.errorThrows("DataType.createType: base type must not be an array- or enum-type")}if(t==="array"||f[t]instanceof o){if(t==="array"||f[t].getBaseType()==null){throw new Error("DataType.createType: primitive or hidden type "+t+" can't be re-defined")}e.warningThrows("DataTypes.createType: type "+t+" is redefined. "+"This is an unsupported usage of DataType and might cause issues.")}var i=f[t]=s(t,r,a);return i};var d=new Set;o.registerInterfaceTypes=function(e){e.forEach(function(e){d.add(e);(()=>{t.set(e,e)})()})};o.registerEnum=function(e,t){c[e]=t};o._isEnumCandidate=function(e){return!Object.keys(e).some(t=>{const n=typeof e[t];return n==="object"||n==="function"})};o.isInterfaceType=function(e){return d.has(e)};o.createType("sap.ui.core.ID",{isValid:function(e){return/^([A-Za-z_][-A-Za-z0-9_.:]*)$/.test(e)}},o.getType("string"));u.inject(o.registerEnum);return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/Event", ["./Object","sap/base/assert"],function(t,e){"use strict";var r=t.extend("sap.ui.base.Event",{constructor:function(e,r,n){t.apply(this);if(arguments.length>0){this.init(e,r,n)}}});r.prototype.init=function(r,n,s){e(typeof r==="string","Event.init: sId must be a string");e(t.isObjectA(n,"sap.ui.base.EventProvider"),"Event.init: oSource must be an EventProvider");this.sId=r;this.oSource=n;this.mParameters=s||{};this.bCancelBubble=false;this.bPreventDefault=false};r.prototype.reset=function(){this.sId="";this.oSource=null;this.mParameters=null;this.bCancelBubble=false;this.bPreventDefault=false};r.prototype.getId=function(){return this.sId};r.prototype.getSource=function(){return this.oSource};r.prototype.getParameters=function(){return this.mParameters};r.prototype.getParameter=function(t){e(typeof t==="string"&&t,"Event.getParameter: sName must be a non-empty string");return this.mParameters[t]};r.prototype.cancelBubble=function(){this.bCancelBubble=true};r.prototype.preventDefault=function(){this.bPreventDefault=true};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/EventProvider", ["./Event","./Object","sap/base/assert","sap/base/Log"],function(t,e,n,i){"use strict";var r=e.extend("sap.ui.base.EventProvider",{constructor:function(){e.call(this);this.mEventRegistry={}}});var o="EventHandlerChange";r.M_EVENTS={EventHandlerChange:o};r.prototype.attachEvent=function(t,e,i,r){var a=this.mEventRegistry;n(typeof t==="string"&&t,"EventProvider.attachEvent: sEventId must be a non-empty string");if(typeof e==="function"){r=i;i=e;e=undefined}n(typeof i==="function","EventProvider.attachEvent: fnFunction must be a function");n(!r||typeof r==="object","EventProvider.attachEvent: oListener must be empty or an object");r=r===this?undefined:r;var s=a[t];if(!Array.isArray(s)){s=a[t]=[]}s.push({oListener:r,fFunction:i,oData:e});if(a[o]){this.fireEvent(o,{EventId:t,type:"listenerAttached",listener:r,func:i,data:e})}return this};r.prototype.attachEventOnce=function(t,e,i,r){if(typeof e==="function"){r=i;i=e;e=undefined}n(typeof i==="function","EventProvider.attachEventOnce: fnFunction must be a function");var o=function(){this.detachEvent(t,o);i.apply(r||this,arguments)};o.oOriginal={fFunction:i,oListener:r,oData:e};this.attachEvent(t,e,o,undefined);return this};r.prototype.detachEvent=function(t,e,i){var r=this.mEventRegistry;n(typeof t==="string"&&t,"EventProvider.detachEvent: sEventId must be a non-empty string");n(typeof e==="function","EventProvider.detachEvent: fnFunction must be a function");n(!i||typeof i==="object","EventProvider.detachEvent: oListener must be empty or an object");var a=r[t];if(!Array.isArray(a)){return this}var s,f;i=i===this?undefined:i;for(var v=0,u=a.length;v<u;v++){if(a[v].fFunction===e&&a[v].oListener===i){s=a[v];a.splice(v,1);break}}if(!s){for(var v=0,u=a.length;v<u;v++){f=a[v].fFunction.oOriginal;if(f&&f.fFunction===e&&f.oListener===i){s=f;a.splice(v,1);break}}}if(a.length==0){delete r[t]}if(s&&r[o]){this.fireEvent(o,{EventId:t,type:"listenerDetached",listener:s.oListener,func:s.fFunction,data:s.oData})}return this};r.prototype.fireEvent=function(e,n,r,o){if(typeof n==="boolean"){o=r;r=n}var a=this,s=false,f,v,u,c,h;do{f=a.mEventRegistry[e];if(Array.isArray(f)){f=f.slice();v=new t(e,this,n);for(u=0,c=f.length;u<c;u++){h=f[u];const t=h.fFunction.call(h.oListener||a,v,h.oData);if(typeof t?.then==="function"){t.catch?.(t=>{i.error(`EventProvider.fireEvent: Event Listener for event '${e}' failed during execution.`,t)})}}o=o&&!v.bCancelBubble}a=a.getEventingParent()}while(o&&a);if(v){s=v.bPreventDefault}return r?!s:this};r.prototype.hasListeners=function(t){return!!this.mEventRegistry[t]};r.getEventList=function(t){return t.mEventRegistry};r.hasListener=function(t,e,i,r){n(typeof e==="string"&&e,"EventProvider.hasListener: sEventId must be a non-empty string");n(typeof i==="function","EventProvider.hasListener: fnFunction must be a function");n(!r||typeof r==="object","EventProvider.hasListener: oListener must be empty or an object");var o=t&&t.mEventRegistry[e];if(o){for(var a=0,s=o.length;a<s;a++){if(o[a].fFunction===i&&o[a].oListener===r){return true}}}return false};r.prototype.getEventingParent=function(){return null};r.prototype.toString=function(){if(this.getMetadata){return"EventProvider "+this.getMetadata().getName()}else{return"EventProvider"}};r.prototype.destroy=function(){this.mEventRegistry={};e.prototype.destroy.apply(this,arguments)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/Metadata", ["sap/base/util/ObjectPath","sap/base/assert","sap/base/Log","sap/base/util/array/uniqueSort"],function(t,e,a,s){"use strict";function r(t){return typeof t==="function"}var n=function(a,s){e(typeof a==="string"&&a,"Metadata: sClassName must be a non-empty string");e(typeof s==="object","Metadata: oClassInfo must be empty or an object");if(!s||typeof s.metadata!=="object"){s={metadata:s||{},constructor:t.get(a)};s.metadata.__version=1}s.metadata??={};s.metadata.__version=s.metadata.__version||2;if(!r(s.constructor)){throw Error("constructor for class "+a+" must have been declared before creating metadata for it")}this._sClassName=a;this._oClass=s.constructor;this.extend(s)};n.prototype.extend=function(t){this.applySettings(t);this.afterApplySettings()};n.prototype.applySettings=function(s){var o=this,i=s.metadata,p;if(i.baseType){var c,u=r(i.baseType);if(u){c=i.baseType;if(!r(c.getMetadata)){throw new TypeError("baseType must be a UI5 class with a static getMetadata function")}}if(!u){c=t.get(i.baseType);if(!r(c)){a.fatal("base class '"+i.baseType+"' does not exist")}}if(c.getMetadata){this._oParent=c.getMetadata();e(c===c.getMetadata().getClass(),"Metadata: oParentClass must match the class in the parent metadata")}else{this._oParent=new n(i.baseType,{})}}else{this._oParent=undefined}this._bAbstract=!!i["abstract"];this._bFinal=!!i["final"];this._sStereotype=i.stereotype||(this._oParent?this._oParent._sStereotype:"object");this._bDeprecated=!!i["deprecated"];this._aInterfaces=i.interfaces||[];this._aPublicMethods=i.publicMethods||[];this._bInterfacesUnique=false;p=this._oClass.prototype;for(var f in s){if(f!=="metadata"&&f!=="constructor"){p[f]=s[f];if(!f.match(/^_|^on|^init$|^exit$/)){o._aPublicMethods.push(f)}}}};n.prototype.afterApplySettings=function(){if(this._oParent){this._aAllPublicMethods=this._oParent._aAllPublicMethods.concat(this._aPublicMethods);this._bInterfacesUnique=false}else{this._aAllPublicMethods=this._aPublicMethods}};n.prototype.getStereotype=function(){return this._sStereotype};n.prototype.getName=function(){return this._sClassName};n.prototype.getClass=function(){return this._oClass};n.prototype.getParent=function(){return this._oParent};n.prototype._dedupInterfaces=function(){if(!this._bInterfacesUnique){s(this._aInterfaces);s(this._aPublicMethods);s(this._aAllPublicMethods);this._bInterfacesUnique=true}};n.prototype.getPublicMethods=function(){this._dedupInterfaces();return this._aPublicMethods};n.prototype.getAllPublicMethods=function(){this._dedupInterfaces();return this._aAllPublicMethods};n.prototype.getInterfaces=function(){this._dedupInterfaces();return this._aInterfaces};n.prototype.isInstanceOf=function(t){if(this._oParent){if(this._oParent.isInstanceOf(t)){return true}}var e=this._aInterfaces;for(var a=0,s=e.length;a<s;a++){if(e[a]===t){return true}}return false};Object.defineProperty(n.prototype,"_mImplementedTypes",{get:function(){if(this===n.prototype){throw new Error("sap.ui.base.Metadata: The '_mImplementedTypes' property must not be accessed on the prototype")}var t=Object.create(this._oParent?this._oParent._mImplementedTypes:null);t[this._sClassName]=true;var e=this._aInterfaces,a=e.length;while(a-- >0){if(!t[e[a]]){t[e[a]]=true}}Object.defineProperty(this,"_mImplementedTypes",{value:Object.freeze(t),writable:false,configurable:false});return t},configurable:true});n.prototype.isA=function(t){var e=this._mImplementedTypes;if(Array.isArray(t)){for(var a=0;a<t.length;a++){if(t[a]in e){return true}}return false}return t in e};n.prototype.isAbstract=function(){return this._bAbstract};n.prototype.isFinal=function(){return this._bFinal};n.prototype.isDeprecated=function(){return this._bDeprecated};n.prototype.addPublicMethods=function(t){var e=t instanceof Array?t:arguments;Array.prototype.push.apply(this._aPublicMethods,e);Array.prototype.push.apply(this._aAllPublicMethods,e);this._bInterfacesUnique=false};n.prototype.getStaticProperty=function(t){let e=this;while(e&&!(t in e.getClass())){e=e.getParent()}const a=e?.getClass();return a?.[t]};n.createClass=function(s,o,i,p){if(typeof s==="string"){p=i;i=o;o=s;s=null}e(!s||r(s));e(typeof o==="string"&&!!o);e(!i||typeof i==="object");e(!p||r(p));p=p||n;if(r(p.preprocessClassInfo)){i=p.preprocessClassInfo(i)}i=i||{};i.metadata=i.metadata||{};if(!i.hasOwnProperty("constructor")){i.constructor=undefined}var c=i.constructor;e(!c||r(c));if(s){if(!c){if(i.metadata.deprecated){c=function(){a.warning("Usage of deprecated class: "+o);s.apply(this,arguments)}}else{c=function(){s.apply(this,arguments)}}}c.prototype=Object.create(s.prototype);c.prototype.constructor=c;i.metadata.baseType=s}else{c=c||function(){};delete i.metadata.baseType}i.constructor=c;t.set(o,c);var u=new p(o,i);c.getMetadata=c.prototype.getMetadata=function(){return u};if(!c.getMetadata().isFinal()){c.extend=function(t,e,a){return n.createClass(c,t,e,a||p)}}return c};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/Object", ["./Metadata","sap/base/Log"],function(t,e){"use strict";var n=t.createClass("sap.ui.base.Object",{constructor:function(){if(!(this instanceof n)){throw Error('Cannot instantiate object: "new" is missing!')}}});n.prototype.destroy=function(){};n.prototype.getInterface=function(){var t=new n._Interface(this,this.getMetadata().getAllPublicMethods());this.getInterface=function(){return t};return t};n.defineClass=function(n,r,a){var i=new(a||t)(n,r);var s=i.getClass();s.getMetadata=s.prototype.getMetadata=function(){return i};if(!i.isFinal()){s.extend=function(e,n,r){return t.createClass(s,e,n,r||a)}}e.debug("defined class '"+n+"'"+(i.getParent()?" as subclass of "+i.getParent().getName():""));return i};n.prototype.isA=function(t){return this.getMetadata().isA(t)};n.isA=function(t,e){return t instanceof n&&t.isA(e)};n.isObjectA=function(t,e){return t instanceof n&&t.isA(e)};n._Interface=function(t,e,r){if(!t){return t}function a(t,e){return function(){var a=t[e].apply(t,arguments);if(r){return this}else{return a instanceof n?a.getInterface():a}}}if(!e){return{}}var i;for(var s=0,o=e.length;s<o;s++){i=e[s];if(!t[i]||typeof t[i]==="function"){this[i]=a(t,i)}}};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Lib", ["sap/base/assert","sap/base/config","sap/base/i18n/Localization","sap/base/i18n/ResourceBundle","sap/base/future","sap/base/Log","sap/base/util/deepExtend","sap/base/util/isEmptyObject","sap/base/util/isPlainObject","sap/base/util/LoaderExtensions","sap/base/util/fetch","sap/base/util/mixedFetch","sap/base/util/ObjectPath","sap/base/util/Version","sap/base/util/array/uniqueSort","sap/ui/Global","sap/ui/VersionInfo","sap/ui/base/DataType","sap/ui/base/EventProvider","sap/ui/base/Object","sap/ui/base/SyncPromise","sap/ui/core/_UrlResolver","sap/ui/core/Supportability"],function(e,n,t,r,i,a,s,o,u,l,c,f,d,p,h,y,g,m,b,v,_,S,j){"use strict";var L={};var w={};var T=new Set(["sap.suite.ui.generic.template","sap.ui.comp","sap.ui.layout","sap.ui.unified"]);function P(e,n){return sap.ui.require.toUrl(e.replace(/\./g,"/")+n)}function O(e,n){l.registerResourcePath(e.replace(/\./g,"/"),n)}function E(e,n){var t=e.modules,r=function(e){return/^jquery\.sap\./.test(e)?e:e.replace(/\./g,"/")};if(p(e.version||"1.0").compareTo("2.0")<0){t={};for(var i in e.modules){t[r(i)+".js"]=e.modules[i]}}sap.ui.require.preload(t,e.name,n)}var C={};n.get({name:"sapUiXxLibraryPreloadFiles",type:n.Type.StringArray,external:true}).forEach(function(e){var n=String(e).trim().split(/\s*:\s*/),t=n[0],r=n[1];if(n.length===1){r=t;t=""}if(/^(?:none|js|json|both)$/.test(r)){C[t]=r}});var x=[];var B;function M(e){var n=sap.ui.require("sap/ui/core/theming/ThemeManager");if(!B){if(!n){B=new Promise(function(e,n){sap.ui.require(["sap/ui/core/theming/ThemeManager"],function(n){e(n)},n)})}else{B=Promise.resolve(n)}}if(n&&e){n.reset()}return B}var R=Symbol("sap.ui.core.Lib");var z={configurable:true,enumerable:true,writable:false};function A(e){z.value=e;return z}function F(e){if(e&&typeof e==="object"&&!Object.isFrozen(e)){Object.freeze(e);for(var n in e){if(Object.hasOwn(e,n)){F(e[n])}}}}function q(){var e=n.get({name:"sapUiPreloadLibCss",type:n.Type.StringArray,external:true});if(e.length>0){if(e[0].startsWith("!")){e[0]=e[0].slice(1)}if(e[0]==="*"){e.shift();Object.keys(L).forEach(function(n){if(!e.includes(n)){e.unshift(n)}})}}return e}var k=v.extend("sap.ui.core.Lib",{constructor:function(n){v.call(this);e(typeof n==="object","A settings object must be given to the constructor of sap/ui/core/Lib");e(typeof n.name==="string"&&n.name,"The settings object that is given to the constructor of sap/ui/core/Lib must contain a 'name' property which is a non-empty string");if(n._key!==R){throw new Error("The constructor of sap/ui/core/Lib is restricted to the internal usage. To get an instance of Library with name '"+n.name+"', use the static method 'get' from sap/ui/core/Lib instead.")}this.name=n.name;var t=["dependencies","types","interfaces","controls","elements"];t.forEach(function(e){Object.defineProperty(this,e,A([]))}.bind(this));Object.defineProperty(this,"_resourceBundles",{value:{},writable:true});Object.defineProperty(this,"_loadingStatus",{value:null,writable:true});Object.defineProperty(this,"_settingsEnhanced",{value:false,writable:true});Object.defineProperty(this,"_manifestFailed",{value:false,writable:true})},getInterface:function(){return this},isSettingsEnhanced:function(){return this._settingsEnhanced},enhanceSettings:function(e){if(this._settingsEnhanced){return this}this._settingsEnhanced=true;var n,t,r;for(n in e){t=e[n];r=undefined;if(t!==undefined){if(Array.isArray(this[n])){if(this[n].length===0){r=t}else{r=h(this[n].concat(t))}}else if(this[n]===undefined){r=t}else if(n!="name"){i.warningThrows("library info setting ignored: "+n+"="+t)}if(r!==undefined){Object.defineProperty(this,n,A(r))}}}return this},_getFileType:function(e){var n;var t=C[this.name]||C[""]||"both";if(e===true){n="json"}else if(e===false){n="js"}else{n=t}if(t!=="both"&&n!=="both"&&t!==n){n="none"}return n},preload:function(e){if(e&&(e.hasOwnProperty("async")||e.hasOwnProperty("sync"))){i.errorThrows("The 'preload' function of class sap/ui/core/Lib only supports preloading a library asynchronously.",{suffix:"The given 'async' or 'sync' setting is ignored."})}if(e&&e.hasOwnProperty("json")){i.errorThrows("The 'preload' function of class sap/ui/core/Lib only supports preloading in JS Format.",{suffix:"The given 'json' setting is ignored."})}return this._preload(["url","lazy"].reduce(function(n,t){if(e&&e.hasOwnProperty(t)){n[t]=e[t]}return n},{}))},_preload:function(e){e=e||{};var n=this._getFileType(e.json),t=this.name.replace(/\./g,"/"),r=!!sap.ui.loader._.getModuleState(t+"/library.js"),i=k.isDepCacheEnabled();if(n==="none"){return e.sync?this:Promise.resolve(this)}if(this._loadingStatus==null&&e.url){O(this.name,e.url)}this._loadingStatus=this._loadingStatus||{};if(this._loadingStatus.pending){if(e.sync){if(e.lazy){return this}else if(this._loadingStatus.async){a.warning("request to load "+this.name+" synchronously while async loading is pending; this causes a duplicate request and should be avoided by caller")}else{a.warning("request to load "+this.name+" synchronously while sync loading is pending (cycle, ignored)");return this}}else if(this._loadingStatus.preloadFinished){return Promise.resolve(this)}}if(e.sync&&this._loadingStatus.pending===false||!e.sync&&this._loadingStatus.promise){return e.sync?this:this._loadingStatus.promise}if(e.lazy){a.debug("Lazy dependency to '"+this.name+"' encountered, loading library-preload-lazy.js");if(e.sync){try{sap.ui.requireSync(t+"/library-preload-lazy")}catch(e){a.error("failed to load '"+t+"/library-preload-lazy.js"+"' synchronously ("+(e&&e.message||e)+")")}return this}return sap.ui.loader._.loadJSResourceAsync(t+"/library-preload-lazy.js",true)}this._loadingStatus.pending=true;this._loadingStatus.async=!e.sync;var s;if(r){s=(e.sync?_:Promise).resolve()}else{s=n!=="json"?this._preloadJSFormat({fallbackToJSON:n!=="js",http2:i,sync:e.sync}):this._preloadJSONFormat({sync:e.sync})}this._loadingStatus.promise=s.then(function(n){n=n||this._getDependencies();this._loadingStatus.preloadFinished=true;var t=this.getManifest(),r;if(n&&n.length){if(!e.sync){n=g._getTransitiveDependencyForLibraries(n)}r=n.map(function(n){var t=k._get(n.name,true);return t._preload({sync:e.sync,lazy:n.lazy})})}else{r=[]}if(!e.sync&&t&&p(t._version).compareTo("1.9.0")>=0){r.push(this.loadResourceBundle())}var i=e.sync?_.all(r):Promise.all(r);return i.then(function(){this._loadingStatus.pending=false;return this}.bind(this))}.bind(this));return e.sync?this._loadingStatus.promise.unwrap():this._loadingStatus.promise},_preloadJSFormat:function(e){e=e||{};var n=this;var t=this.name.replace(/\./g,"/")+(e.http2?"/library-h2-preload":"/library-preload")+(e.sync?"":".js");var r;if(e.sync){r=_.resolve().then(function(){sap.ui.requireSync(t)})}else{r=sap.ui.loader._.loadJSResourceAsync(t)}return r.catch(function(r){if(e.fallbackToJSON){var i;if(e.sync){var s=r;while(s&&s.cause){s=s.cause}i=s&&s.name==="XHRLoadError"}else{i=true}if(i){a.error("failed to load '"+t+"' ("+(r&&r.message||r)+"), falling back to library-preload.json");return n._preloadJSONFormat({sync:e.sync})}}})},_preloadJSONFormat:function(e){e=e||{};var n=P(this.name,"/library-preload.json");c=f?f:c;return c(n,{headers:{Accept:c.ContentTypes.JSON}},e.sync).then(function(e){if(e.ok){return e.json().then(function(e){if(e){E(e,n);if(Array.isArray(e.dependencies)){return e.dependencies.map(function(e){return{name:e.replace(/\.library-preload$/,"")}})}else{return e.dependencies}}})}else{throw Error(e.statusText||e.status)}}).catch(function(e){a.error("failed to load '"+n+"': "+e.message)})},getManifest:function(e){if(!this.oManifest){var n=this.name.replace(/\./g,"/")+"/manifest.json";if(sap.ui.loader._.getModuleState(n)||e&&!this._manifestFailed){try{this.oManifest=l.loadResource(n,{dataType:"json",async:false,failOnError:!this.isSettingsEnhanced()});if(this._oManifest){F(this.oManifest)}else{this._manifestFailed=true}}catch(e){this._manifestFailed=true}}}return this.oManifest},_getDependencies:function(){var e=this.getManifest();var n=[];var t=e&&e["sap.ui5"]&&e["sap.ui5"].dependencies&&e["sap.ui5"].dependencies.libs;if(t){return Object.keys(t).reduce(function(e,n){if(!t[n].lazy){e.push({name:n})}else if(T.has(n)){e.push({name:n,lazy:true})}return e},n)}else{return n}},_getI18nSettings:function(){var e=this.getManifest(),n;if(e&&p(e._version).compareTo("1.9.0")>=0){n=e["sap.ui5"]&&e["sap.ui5"].library&&e["sap.ui5"].library.i18n}n=this._normalizeI18nSettings(n);return n},_normalizeI18nSettings:function(e){if(e==null||e===true){e={bundleUrl:"messagebundle.properties"}}else if(typeof e==="string"){e={bundleUrl:e}}else if(typeof e==="object"){e=s({},e)}return e},_includeTheme:function(e,n){var t=this.name,r=q().indexOf(t)!==-1;x.push({name:t,version:this.version,variant:e,preloadedCss:r});M().then(function(r){r.includeLibraryTheme(t,e,n)})},getResourceBundle:function(e){return this._loadResourceBundle(e,true)},loadResourceBundle:function(e){return this._loadResourceBundle(e)},_loadResourceBundle:function(n,i){var a=this,s=this.getManifest(i),o=!!s,u,l,c,f;e(n===undefined||typeof n==="string","sLocale must be a string or omitted");n=n||t.getLanguage();c=n+"/manifest-not-available";if(o){f=n;delete this._resourceBundles[c]}else{f=c}u=this._resourceBundles[f];if(!u||i&&u instanceof Promise){l=this._getI18nSettings();if(l){var d=P(this.name+"/",l.bundleUrl);w[d]=this;u=r.create({bundleUrl:d,supportedLocales:l.supportedLocales,fallbackLocale:l.fallbackLocale,locale:n,async:!i,activeTerminologies:t.getActiveTerminologies()});if(u instanceof Promise){u=u.then(function(e){a._resourceBundles[f]=e;return e})}this._resourceBundles[f]=u}}return i?u:Promise.resolve(u)}});k.getAllInstancesRequiringCss=function(){return x.slice()};k.isLoaded=function(e){return L[e]?true:false};k._get=function(e,n){var t=L[e];if(!t&&n){L[e]=t=new k({name:e,_key:R})}return t};k._getByBundleUrl=function(e){if(e){if(w[e]){return w[e]}var n=sap.ui.loader._.guessResourceName(e);if(n){for(var t in L){if(!L[t].isSettingsEnhanced()){continue}var r=t.replace(/\./g,"/");var i=L[t];if(r!==""&&n.startsWith(r+"/")){var a=n.replace(r+"/","");var s=i._getI18nSettings();if(s){var o=P(r,"/"+s.bundleUrl);a=P(r,"/"+a);if(a===o){w[e]=i;return i}w[e]=false}}}}}};k.all=function(){return k._all(false)};k._all=function(e){var n={};Object.keys(L).forEach(function(t){if(e||L[t].isSettingsEnhanced()){n[t]=L[t]}});return n};const U=Symbol("isProxy");function $(e,n){const t=new WeakMap;t.set(n,`${e}.`);const r={set(e,n,i){if(u(i)&&!i[U]){const s=o(i);let u=s;if(!s){if(m._isEnumCandidate(i)){e[n]=i;const r=t.get(e);m.registerEnum(`${r}${n}`,i);a.debug(`[Library API-Version 2] If you intend to use API-Version 2 in your library, make sure to call 'sap/ui/base/DataType.registerEnum' for ${r}${n}.`)}else{const t=n.charAt(0);if(t===t.toLowerCase()&&t!==t.toUpperCase()){u=true}else{e[n]=i}}}if(u){e[n]=new Proxy(i,r);const a=`${t.get(e)}${n}.`;t.set(i,a)}}else{e[n]=i}return true},get(e,n){if(n===U){return true}return e[n]}};return r}k.init=function(n){if(!sap.ui.require("sap/ui/core/Core")){throw new Error("Library "+n.name+": Library must not be used before the core is ready!")}e(typeof n==="object","mSettings given to 'sap/ui/core/Lib.init' must be an object");e(typeof n.name==="string"&&n.name,"mSettings given to 'sap/ui/core/Lib.init' must have the 'name' property set");var t="sap/ui/core/Lib.init";a.debug("Analyzing Library "+n.name,null,t);var r=k._get(n.name,true);r.enhanceSettings(n);var i=Object.create(null),s;i=d.create(n.name);const o=n.apiVersion??1;if(![1,2].includes(o)){throw new TypeError(`The library '${n.name}' has defined 'apiVersion: ${o}', which is an unsupported value. The supported values are: 1, 2 and undefined (defaults to 1).`)}if(o<2){const e=$(n.name,i);i=new Proxy(i,e);d.set(n.name,i)}for(s=0;s<r.dependencies.length;s++){var l=r.dependencies[s];var c=k._get(l,true);a.debug("resolve Dependencies to "+l,null,t);if(!c.isSettingsEnhanced()){a.warning("Dependency from "+n.name+" to "+l+" has not been resolved by library itself",null,t);k._load({name:l},{sync:true})}}m.registerInterfaceTypes(r.interfaces);function f(e){const n=d.get(e);if(n instanceof m){return` to ensure that the type is defined. You can then access it by calling 'DataType.getType("${e}")'.`}else if(u(n)){return`. You can then reference this type via the library's module export.`}else{return`.`}}for(s=0;s<r.types.length;s++){if(!/^(any|boolean|float|int|string|object|void)$/.test(r.types[s])){const e=r.types[s];sap.ui.loader._.declareModule(e.replace(/\./g,"/")+".js",()=>`Importing the pseudo module '${e.replace(/\./g,"/")}' is deprecated.`+` To access the type '${e}', please import '${r.name.replace(/\./g,"/")}/library'`+f(e)+` For more information, see documentation under 'Best Practices for Loading Modules'.`);var p=e.substring(0,e.lastIndexOf("."));if(d.get(p)===undefined){d.create(p)}}}(()=>{var e=r.controls.concat(r.elements);for(s=0;s<e.length;s++){sap.ui.lazyRequire(e[s],"new extend getMetadata")}})();if(!r.noLibraryCSS){var h={name:r.name,version:r.version,preloadedCss:q().indexOf(r.name)!==-1};x.push(h);M(!h.preloadedCss).then(function(e){e._includeLibraryThemeAndEnsureThemeRoot(h)})}r.sName=r.name;r.aControls=r.controls;k.fireLibraryChanged({name:n.name,stereotype:"library",operation:"add",metadata:r});return i};function I(e){return e.map(function(e){return e.name.replace(/\./g,"/")+"/library"})}function D(e){var n=I(e);return new Promise(function(t,r){sap.ui.require(n,function(){t(e)},r)})}k.load=function(e){if(typeof e==="string"){e={name:e}}else{e=["name","url"].reduce(function(n,t){if(e&&e.hasOwnProperty(t)){n[t]=e[t]}return n},{})}return k._load(e).then(function(e){return e[0]})};k._load=function(e,n){n=n||{};if(!Array.isArray(e)){e=[e]}var t={};var r=[];e.forEach(function(e){if(typeof e==="object"){if(e.hasOwnProperty("url")||e.hasOwnProperty("json")){t[e.name]=e}r.push(e)}else{r.push({name:e})}});var i=k.getPreloadMode()==="sync"||k.getPreloadMode()==="async",s=!n.preloadOnly;if(!n.sync){r=g._getTransitiveDependencyForLibraries(r)}var o=r.map(function(e){var n=k._get(e.name,true);if(n._loadingStatus==null&&t[e.name]&&t[e.name].url){O(e.name,t[e.name].url)}return n});if(n.sync){if(i){o.forEach(function(e){var n={sync:true};if(t[e.name]&&t[e.name].hasOwnProperty("json")){n.json=t[e.name].json}e._preload(n)})}if(s){I(o).forEach(function(e,n){if(o[n].isSettingsEnhanced()){return}sap.ui.requireSync(e);if(!o[n].isSettingsEnhanced()){a.warning("library "+o[n].name+" didn't initialize itself");k.init({name:o[n].name})}})}return o}const u=i?Promise.all(o.map(function(e){const n={};if(t[e.name]&&t[e.name].hasOwnProperty("json")){n.json=t[e.name].json}return e._preload(n)})):Promise.resolve(o);return s?u.then(D):u};k.getResourceBundleFor=function(e,n){var t=k._get(e,true);return t.getResourceBundle(n)};k._registerElement=function(e){var n=e.getName(),t=e.getLibraryName()||"";if(!t&&!n.includes(".")){return}let r=k._get(t);const i=e.isA("sap.ui.core.Control")?"controls":"elements";if(!r){d.create(t);r=k._get(t,true)}if(r[i].indexOf(n)<0){r[i].push(n);a.debug("Class "+n+" registered for library "+t);k.fireLibraryChanged({name:n,stereotype:e.getStereotype(),operation:"add",metadata:e})}};var J=new b;k.attachLibraryChanged=function(e,n){J.attachEvent("LibraryChanged",e,n)};k.detachLibraryChanged=function(e,n){J.detachEvent("LibraryChanged",e,n)};k.fireLibraryChanged=function(e){J.fireEvent("LibraryChanged",e)};r._enrichBundleConfig=function(e){if(!e.terminologies||!e.enhanceWith){var n=k._getByBundleUrl(e.url);if(n){var r=n._getI18nSettings();if(r){var i=n.name.replace(/\./g,"/");i=i.endsWith("/")?i:i+"/";i=sap.ui.require.toUrl(i);S._processResourceConfiguration(r,{alreadyResolvedOnRoot:true,relativeTo:i});e.fallbackLocale=e.fallbackLocale||r.fallbackLocale;e.supportedLocales=e.supportedLocales||r.supportedLocales;e.terminologies=e.terminologies||r.terminologies;e.enhanceWith=e.enhanceWith||r.enhanceWith;e.activeTerminologies=e.activeTerminologies||t.getActiveTerminologies()}}}return e};k.getVersionedLibCss=function(){return n.get({name:"sapUiVersionedLibCss",type:n.Type.Boolean,external:true})};k.isDepCacheEnabled=function(){return n.get({name:"sapUiXxDepCache",type:n.Type.Boolean,external:true})};k.getPreloadMode=function(){if(j.isDebugModeEnabled()===true){return""}let e=n.get({name:"sapUiPreload",type:n.Type.String,defaultValue:"auto",external:true});if(e==="auto"){if(window["sap-ui-optimized"]){e=sap.ui.loader.config().async?"async":"sync"}else{e=""}}return e};return k});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Supportability", ["sap/base/config"],e=>{"use strict";const t={isDebugModeEnabled(){let t=window["sap-ui-debug"]===true||e.get({name:"sapUiDebug",type:e.Type.Boolean,external:true});try{t=t||/^(?:true|x|X)$/.test(window.localStorage.getItem("sap-ui-debug"))}catch(e){}return t},isControlInspectorEnabled(){return e.get({name:"sapUiInspect",type:e.Type.Boolean,external:true})},isStatisticsEnabled(){var t=e.get({name:"sapUiStatistics",type:e.Type.Boolean,defaultValue:e.get({name:"sapStatistics",type:e.Type.Boolean,external:true}),external:true});try{t=t||window.localStorage.getItem("sap-ui-statistics")=="X"}catch(e){}return t},getSupportSettings(){return e.get({name:"sapUiSupport",type:e.Type.StringArray,defaultValue:null,external:true})},getTestRecorderSettings(){return e.get({name:"sapUiTestRecorder",type:e.Type.StringArray,defaultValue:null,external:true})},collectOriginInfo(){return e.get({name:"sapUiOriginInfo",type:e.Type.Boolean,external:true})}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/_UrlResolver", ["sap/ui/thirdparty/URI"],function(e){"use strict";var r={};r._processResourceConfiguration=function(e,a){a=a||{};var i=a.alreadyResolvedOnRoot||false;var n=e.bundleUrlRelativeTo||a.relativeTo;var o;if(n==="manifest"){o=a.manifestBaseURI}else if(n==="component"){o=a.baseURI}else{o=n||a.baseURI}Object.keys(e).forEach(function(s){if(s==="bundleUrl"&&!i){var t=e[s];var f=r._resolveUri(t,o);e[s]=f&&f.toString()}if(s==="terminologies"){var u=e[s];for(var l in u){r._processResourceConfiguration(u[l],{relativeTo:n,baseURI:a.baseURI,manifestBaseURI:a.manifestBaseURI})}}if(s==="enhanceWith"){var v=e[s]||[];for(var R=0;R<v.length;R++){r._processResourceConfiguration(v[R],{relativeTo:n,baseURI:a.baseURI,manifestBaseURI:a.manifestBaseURI})}}})};function a(r){if(r&&r instanceof e){return r}return new e(r)}r._resolveUri=function(e,i){return r._resolveUriRelativeTo(a(e),a(i))};r._resolveUriRelativeTo=function(r,a){if(r.is("absolute")||r.path()&&r.path()[0]==="/"){return r}var i=new e(document.baseURI).search("");a=a.absoluteTo(i);return r.absoluteTo(a).relativeTo(i)};return r});
sap.ui.require.preload({
	"sap/ui/thirdparty/URI.js":function(){
/*!
 * URI.js - Mutating URLs
 *
 * Version: 1.19.11
 *
 * Author: Rodney Rehm
 * Web: http://medialize.github.io/URI.js/
 *
 * Licensed under
 *   MIT License http://www.opensource.org/licenses/mit-license
 *
 */
(function(e,t){"use strict";if(typeof module==="object"&&module.exports){module.exports=t(require("./punycode"),require("./IPv6"),require("./SecondLevelDomains"))}else if(typeof define==="function"&&define.amd){e.URI=t(e.punycode,e.IPv6,e.SecondLevelDomains,e);define("sap/ui/thirdparty/URI",[],function(){return e.URI})}else{e.URI=t(e.punycode,e.IPv6,e.SecondLevelDomains,e)}})(this,function(e,t,r,n){"use strict";var i=n&&n.URI;function s(e,t){var r=arguments.length>=1;var n=arguments.length>=2;if(!(this instanceof s)){if(r){if(n){return new s(e,t)}return new s(e)}return new s}if(e===undefined){if(r){throw new TypeError("undefined is not a valid argument for URI")}if(typeof location!=="undefined"){e=location.href+""}else{e=""}}if(e===null){if(r){throw new TypeError("null is not a valid argument for URI")}}this.href(e);if(t!==undefined){return this.absoluteTo(t)}return this}function a(e){return/^[0-9]+$/.test(e)}s.version="1.19.11";var o=s.prototype;var u=Object.prototype.hasOwnProperty;function h(e){return e.replace(/([.*+?^=!:${}()|[\]\/\\])/g,"\\$1")}function f(e){if(e===undefined){return"Undefined"}return String(Object.prototype.toString.call(e)).slice(8,-1)}function p(e){return f(e)==="Array"}function l(e,t){var r={};var n,i;if(f(t)==="RegExp"){r=null}else if(p(t)){for(n=0,i=t.length;n<i;n++){r[t[n]]=true}}else{r[t]=true}for(n=0,i=e.length;n<i;n++){var s=r&&r[e[n]]!==undefined||!r&&t.test(e[n]);if(s){e.splice(n,1);i--;n--}}return e}function c(e,t){var r,n;if(p(t)){for(r=0,n=t.length;r<n;r++){if(!c(e,t[r])){return false}}return true}var i=f(t);for(r=0,n=e.length;r<n;r++){if(i==="RegExp"){if(typeof e[r]==="string"&&e[r].match(t)){return true}}else if(e[r]===t){return true}}return false}function d(e,t){if(!p(e)||!p(t)){return false}if(e.length!==t.length){return false}e.sort();t.sort();for(var r=0,n=e.length;r<n;r++){if(e[r]!==t[r]){return false}}return true}function m(e){var t=/^\/+|\/+$/g;return e.replace(t,"")}s._parts=function(){return{protocol:null,username:null,password:null,hostname:null,urn:null,port:null,path:null,query:null,fragment:null,preventInvalidHostname:s.preventInvalidHostname,duplicateQueryParameters:s.duplicateQueryParameters,escapeQuerySpace:s.escapeQuerySpace}};s.preventInvalidHostname=false;s.duplicateQueryParameters=false;s.escapeQuerySpace=true;s.protocol_expression=/^[a-z][a-z0-9.+-]*$/i;s.idn_expression=/[^a-z0-9\._-]/i;s.punycode_expression=/(xn--)/i;s.ip4_expression=/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;s.ip6_expression=/^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/;s.find_uri_expression=/\b((?:[a-z][\w-]+:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]+|\(([^\s()<>]+|(\([^\s()<>]+\)))*\))+(?:\(([^\s()<>]+|(\([^\s()<>]+\)))*\)|[^\s`!()\[\]{};:'".,<>?«»“”‘’]))/gi;s.findUri={start:/\b(?:([a-z][a-z0-9.+-]*:\/\/)|www\.)/gi,end:/[\s\r\n]|$/,trim:/[`!()\[\]{};:'".,<>?«»“”„‘’]+$/,parens:/(\([^\)]*\)|\[[^\]]*\]|\{[^}]*\}|<[^>]*>)/g};s.leading_whitespace_expression=/^[\x00-\x20\u00a0\u1680\u2000-\u200a\u2028\u2029\u202f\u205f\u3000\ufeff]+/;s.ascii_tab_whitespace=/[\u0009\u000A\u000D]+/g;s.defaultPorts={http:"80",https:"443",ftp:"21",gopher:"70",ws:"80",wss:"443"};s.hostProtocols=["http","https"];s.invalid_hostname_characters=/[^a-zA-Z0-9\.\-:_]/;s.domAttributes={a:"href",blockquote:"cite",link:"href",base:"href",script:"src",form:"action",img:"src",area:"href",iframe:"src",embed:"src",source:"src",track:"src",input:"src",audio:"src",video:"src"};s.getDomAttribute=function(e){if(!e||!e.nodeName){return undefined}var t=e.nodeName.toLowerCase();if(t==="input"&&e.type!=="image"){return undefined}return s.domAttributes[t]};function g(e){return escape(e)}function _(e){return encodeURIComponent(e).replace(/[!'()*]/g,g).replace(/\*/g,"%2A")}s.encode=_;s.decode=decodeURIComponent;s.iso8859=function(){s.encode=escape;s.decode=unescape};s.unicode=function(){s.encode=_;s.decode=decodeURIComponent};s.characters={pathname:{encode:{expression:/%(24|26|2B|2C|3B|3D|3A|40)/gi,map:{"%24":"$","%26":"&","%2B":"+","%2C":",","%3B":";","%3D":"=","%3A":":","%40":"@"}},decode:{expression:/[\/\?#]/g,map:{"/":"%2F","?":"%3F","#":"%23"}}},reserved:{encode:{expression:/%(21|23|24|26|27|28|29|2A|2B|2C|2F|3A|3B|3D|3F|40|5B|5D)/gi,map:{"%3A":":","%2F":"/","%3F":"?","%23":"#","%5B":"[","%5D":"]","%40":"@","%21":"!","%24":"$","%26":"&","%27":"'","%28":"(","%29":")","%2A":"*","%2B":"+","%2C":",","%3B":";","%3D":"="}}},urnpath:{encode:{expression:/%(21|24|27|28|29|2A|2B|2C|3B|3D|40)/gi,map:{"%21":"!","%24":"$","%27":"'","%28":"(","%29":")","%2A":"*","%2B":"+","%2C":",","%3B":";","%3D":"=","%40":"@"}},decode:{expression:/[\/\?#:]/g,map:{"/":"%2F","?":"%3F","#":"%23",":":"%3A"}}}};s.encodeQuery=function(e,t){var r=s.encode(e+"");if(t===undefined){t=s.escapeQuerySpace}return t?r.replace(/%20/g,"+"):r};s.decodeQuery=function(e,t){e+="";if(t===undefined){t=s.escapeQuerySpace}try{return s.decode(t?e.replace(/\+/g,"%20"):e)}catch(t){return e}};var v={encode:"encode",decode:"decode"};var y;var b=function(e,t){return function(r){try{return s[t](r+"").replace(s.characters[e][t].expression,function(r){return s.characters[e][t].map[r]})}catch(e){return r}}};for(y in v){s[y+"PathSegment"]=b("pathname",v[y]);s[y+"UrnPathSegment"]=b("urnpath",v[y])}var w=function(e,t,r){return function(n){var i;if(!r){i=s[t]}else{i=function(e){return s[t](s[r](e))}}var a=(n+"").split(e);for(var o=0,u=a.length;o<u;o++){a[o]=i(a[o])}return a.join(e)}};s.decodePath=w("/","decodePathSegment");s.decodeUrnPath=w(":","decodeUrnPathSegment");s.recodePath=w("/","encodePathSegment","decode");s.recodeUrnPath=w(":","encodeUrnPathSegment","decode");s.encodeReserved=b("reserved","encode");s.parse=function(e,t){var r;if(!t){t={preventInvalidHostname:s.preventInvalidHostname}}e=e.replace(s.leading_whitespace_expression,"");e=e.replace(s.ascii_tab_whitespace,"");r=e.indexOf("#");if(r>-1){t.fragment=e.substring(r+1)||null;e=e.substring(0,r)}r=e.indexOf("?");if(r>-1){t.query=e.substring(r+1)||null;e=e.substring(0,r)}e=e.replace(/^(https?|ftp|wss?)?:+[/\\]*/i,"$1://");e=e.replace(/^[/\\]{2,}/i,"//");if(e.substring(0,2)==="//"){t.protocol=null;e=e.substring(2);e=s.parseAuthority(e,t)}else{r=e.indexOf(":");if(r>-1){t.protocol=e.substring(0,r)||null;if(t.protocol&&!t.protocol.match(s.protocol_expression)){t.protocol=undefined}else if(e.substring(r+1,r+3).replace(/\\/g,"/")==="//"){e=e.substring(r+3);e=s.parseAuthority(e,t)}else{e=e.substring(r+1);t.urn=true}}}t.path=e;return t};s.parseHost=function(e,t){if(!e){e=""}e=e.replace(/\\/g,"/");var r=e.indexOf("/");var n;var i;if(r===-1){r=e.length}if(e.charAt(0)==="["){n=e.indexOf("]");t.hostname=e.substring(1,n)||null;t.port=e.substring(n+2,r)||null;if(t.port==="/"){t.port=null}}else{var a=e.indexOf(":");var o=e.indexOf("/");var u=e.indexOf(":",a+1);if(u!==-1&&(o===-1||u<o)){t.hostname=e.substring(0,r)||null;t.port=null}else{i=e.substring(0,r).split(":");t.hostname=i[0]||null;t.port=i[1]||null}}if(t.hostname&&e.substring(r).charAt(0)!=="/"){r++;e="/"+e}if(t.preventInvalidHostname){s.ensureValidHostname(t.hostname,t.protocol)}if(t.port){s.ensureValidPort(t.port)}return e.substring(r)||"/"};s.parseAuthority=function(e,t){e=s.parseUserinfo(e,t);return s.parseHost(e,t)};s.parseUserinfo=function(e,t){var r=e;var n=e.indexOf("\\");if(n!==-1){e=e.replace(/\\/g,"/")}var i=e.indexOf("/");var a=e.lastIndexOf("@",i>-1?i:e.length-1);var o;if(a>-1&&(i===-1||a<i)){o=e.substring(0,a).split(":");t.username=o[0]?s.decode(o[0]):null;o.shift();t.password=o[0]?s.decode(o.join(":")):null;e=r.substring(a+1)}else{t.username=null;t.password=null}return e};s.parseQuery=function(e,t){if(!e){return{}}e=e.replace(/&+/g,"&").replace(/^\?*&*|&+$/g,"");if(!e){return{}}var r={};var n=e.split("&");var i=n.length;var a,o,h;for(var f=0;f<i;f++){a=n[f].split("=");o=s.decodeQuery(a.shift(),t);h=a.length?s.decodeQuery(a.join("="),t):null;if(o==="__proto__"){continue}else if(u.call(r,o)){if(typeof r[o]==="string"||r[o]===null){r[o]=[r[o]]}r[o].push(h)}else{r[o]=h}}return r};s.build=function(e){var t="";var r=false;if(e.protocol){t+=e.protocol+":"}if(!e.urn&&(t||e.hostname)){t+="//";r=true}t+=s.buildAuthority(e)||"";if(typeof e.path==="string"){if(e.path.charAt(0)!=="/"&&r){t+="/"}t+=e.path}if(typeof e.query==="string"&&e.query){t+="?"+e.query}if(typeof e.fragment==="string"&&e.fragment){t+="#"+e.fragment}return t};s.buildHost=function(e){var t="";if(!e.hostname){return""}else if(s.ip6_expression.test(e.hostname)){t+="["+e.hostname+"]"}else{t+=e.hostname}if(e.port){t+=":"+e.port}return t};s.buildAuthority=function(e){return s.buildUserinfo(e)+s.buildHost(e)};s.buildUserinfo=function(e){var t="";if(e.username){t+=s.encode(e.username)}if(e.password){t+=":"+s.encode(e.password)}if(t){t+="@"}return t};s.buildQuery=function(e,t,r){var n="";var i,a,o,h;for(a in e){if(a==="__proto__"){continue}else if(u.call(e,a)){if(p(e[a])){i={};for(o=0,h=e[a].length;o<h;o++){if(e[a][o]!==undefined&&i[e[a][o]+""]===undefined){n+="&"+s.buildQueryParameter(a,e[a][o],r);if(t!==true){i[e[a][o]+""]=true}}}}else if(e[a]!==undefined){n+="&"+s.buildQueryParameter(a,e[a],r)}}}return n.substring(1)};s.buildQueryParameter=function(e,t,r){return s.encodeQuery(e,r)+(t!==null?"="+s.encodeQuery(t,r):"")};s.addQuery=function(e,t,r){if(typeof t==="object"){for(var n in t){if(u.call(t,n)){s.addQuery(e,n,t[n])}}}else if(typeof t==="string"){if(e[t]===undefined){e[t]=r;return}else if(typeof e[t]==="string"){e[t]=[e[t]]}if(!p(r)){r=[r]}e[t]=(e[t]||[]).concat(r)}else{throw new TypeError("URI.addQuery() accepts an object, string as the name parameter")}};s.setQuery=function(e,t,r){if(typeof t==="object"){for(var n in t){if(u.call(t,n)){s.setQuery(e,n,t[n])}}}else if(typeof t==="string"){e[t]=r===undefined?null:r}else{throw new TypeError("URI.setQuery() accepts an object, string as the name parameter")}};s.removeQuery=function(e,t,r){var n,i,a;if(p(t)){for(n=0,i=t.length;n<i;n++){e[t[n]]=undefined}}else if(f(t)==="RegExp"){for(a in e){if(t.test(a)){e[a]=undefined}}}else if(typeof t==="object"){for(a in t){if(u.call(t,a)){s.removeQuery(e,a,t[a])}}}else if(typeof t==="string"){if(r!==undefined){if(f(r)==="RegExp"){if(!p(e[t])&&r.test(e[t])){e[t]=undefined}else{e[t]=l(e[t],r)}}else if(e[t]===String(r)&&(!p(r)||r.length===1)){e[t]=undefined}else if(p(e[t])){e[t]=l(e[t],r)}}else{e[t]=undefined}}else{throw new TypeError("URI.removeQuery() accepts an object, string, RegExp as the first parameter")}};s.hasQuery=function(e,t,r,n){switch(f(t)){case"String":break;case"RegExp":for(var i in e){if(u.call(e,i)){if(t.test(i)&&(r===undefined||s.hasQuery(e,i,r))){return true}}}return false;case"Object":for(var a in t){if(u.call(t,a)){if(!s.hasQuery(e,a,t[a])){return false}}}return true;default:throw new TypeError("URI.hasQuery() accepts a string, regular expression or object as the name parameter")}switch(f(r)){case"Undefined":return t in e;case"Boolean":var o=Boolean(p(e[t])?e[t].length:e[t]);return r===o;case"Function":return!!r(e[t],t,e);case"Array":if(!p(e[t])){return false}var h=n?c:d;return h(e[t],r);case"RegExp":if(!p(e[t])){return Boolean(e[t]&&e[t].match(r))}if(!n){return false}return c(e[t],r);case"Number":r=String(r);case"String":if(!p(e[t])){return e[t]===r}if(!n){return false}return c(e[t],r);default:throw new TypeError("URI.hasQuery() accepts undefined, boolean, string, number, RegExp, Function as the value parameter")}};s.joinPaths=function(){var e=[];var t=[];var r=0;for(var n=0;n<arguments.length;n++){var i=new s(arguments[n]);e.push(i);var a=i.segment();for(var o=0;o<a.length;o++){if(typeof a[o]==="string"){t.push(a[o])}if(a[o]){r++}}}if(!t.length||!r){return new s("")}var u=new s("").segment(t);if(e[0].path()===""||e[0].path().slice(0,1)==="/"){u.path("/"+u.path())}return u.normalize()};s.commonPath=function(e,t){var r=Math.min(e.length,t.length);var n;for(n=0;n<r;n++){if(e.charAt(n)!==t.charAt(n)){n--;break}}if(n<1){return e.charAt(0)===t.charAt(0)&&e.charAt(0)==="/"?"/":""}if(e.charAt(n)!=="/"||t.charAt(n)!=="/"){n=e.substring(0,n).lastIndexOf("/")}return e.substring(0,n+1)};s.withinString=function(e,t,r){r||(r={});var n=r.start||s.findUri.start;var i=r.end||s.findUri.end;var a=r.trim||s.findUri.trim;var o=r.parens||s.findUri.parens;var u=/[a-z0-9-]=["']?$/i;n.lastIndex=0;while(true){var h=n.exec(e);if(!h){break}var f=h.index;if(r.ignoreHtml){var p=e.slice(Math.max(f-3,0),f);if(p&&u.test(p)){continue}}var l=f+e.slice(f).search(i);var c=e.slice(f,l);var d=-1;while(true){var m=o.exec(c);if(!m){break}var g=m.index+m[0].length;d=Math.max(d,g)}if(d>-1){c=c.slice(0,d)+c.slice(d).replace(a,"")}else{c=c.replace(a,"")}if(c.length<=h[0].length){continue}if(r.ignore&&r.ignore.test(c)){continue}l=f+c.length;var _=t(c,f,l,e);if(_===undefined){n.lastIndex=l;continue}_=String(_);e=e.slice(0,f)+_+e.slice(l);n.lastIndex=f+_.length}n.lastIndex=0;return e};s.ensureValidHostname=function(t,r){var n=!!t;var i=!!r;var a=false;if(i){a=c(s.hostProtocols,r)}if(a&&!n){throw new TypeError("Hostname cannot be empty, if protocol is "+r)}else if(t&&t.match(s.invalid_hostname_characters)){if(!e){throw new TypeError('Hostname "'+t+'" contains characters other than [A-Z0-9.-:_] and Punycode.js is not available')}if(e.toASCII(t).match(s.invalid_hostname_characters)){throw new TypeError('Hostname "'+t+'" contains characters other than [A-Z0-9.-:_]')}}};s.ensureValidPort=function(e){if(!e){return}var t=Number(e);if(a(t)&&t>0&&t<65536){return}throw new TypeError('Port "'+e+'" is not a valid port')};s.noConflict=function(e){if(e){var t={URI:this.noConflict()};if(n.URITemplate&&typeof n.URITemplate.noConflict==="function"){t.URITemplate=n.URITemplate.noConflict()}if(n.IPv6&&typeof n.IPv6.noConflict==="function"){t.IPv6=n.IPv6.noConflict()}if(n.SecondLevelDomains&&typeof n.SecondLevelDomains.noConflict==="function"){t.SecondLevelDomains=n.SecondLevelDomains.noConflict()}return t}else if(n.URI===this){n.URI=i}return this};o.build=function(e){if(e===true){this._deferred_build=true}else if(e===undefined||this._deferred_build){this._string=s.build(this._parts);this._deferred_build=false}return this};o.clone=function(){return new s(this)};o.valueOf=o.toString=function(){return this.build(false)._string};function Q(e){return function(t,r){if(t===undefined){return this._parts[e]||""}else{this._parts[e]=t||null;this.build(!r);return this}}}function A(e,t){return function(r,n){if(r===undefined){return this._parts[e]||""}else{if(r!==null){r=r+"";if(r.charAt(0)===t){r=r.substring(1)}}this._parts[e]=r;this.build(!n);return this}}}o.protocol=Q("protocol");o.username=Q("username");o.password=Q("password");o.hostname=Q("hostname");o.port=Q("port");o.query=A("query","?");o.fragment=A("fragment","#");o.search=function(e,t){var r=this.query(e,t);return typeof r==="string"&&r.length?"?"+r:r};o.hash=function(e,t){var r=this.fragment(e,t);return typeof r==="string"&&r.length?"#"+r:r};o.pathname=function(e,t){if(e===undefined||e===true){var r=this._parts.path||(this._parts.hostname?"/":"");return e?(this._parts.urn?s.decodeUrnPath:s.decodePath)(r):r}else{if(this._parts.urn){this._parts.path=e?s.recodeUrnPath(e):""}else{this._parts.path=e?s.recodePath(e):"/"}this.build(!t);return this}};o.path=o.pathname;o.href=function(e,t){var r;if(e===undefined){return this.toString()}this._string="";this._parts=s._parts();var n=e instanceof s;var i=typeof e==="object"&&(e.hostname||e.path||e.pathname);if(e.nodeName){var a=s.getDomAttribute(e);e=e[a]||"";i=false}if(!n&&i&&e.pathname!==undefined){e=e.toString()}if(typeof e==="string"||e instanceof String){this._parts=s.parse(String(e),this._parts)}else if(n||i){var o=n?e._parts:e;for(r in o){if(r==="query"){continue}if(u.call(this._parts,r)){this._parts[r]=o[r]}}if(o.query){this.query(o.query,false)}}else{throw new TypeError("invalid input")}this.build(!t);return this};o.is=function(e){var t=false;var n=false;var i=false;var a=false;var o=false;var u=false;var h=false;var f=!this._parts.urn;if(this._parts.hostname){f=false;n=s.ip4_expression.test(this._parts.hostname);i=s.ip6_expression.test(this._parts.hostname);t=n||i;a=!t;o=a&&r&&r.has(this._parts.hostname);u=a&&s.idn_expression.test(this._parts.hostname);h=a&&s.punycode_expression.test(this._parts.hostname)}switch(e.toLowerCase()){case"relative":return f;case"absolute":return!f;case"domain":case"name":return a;case"sld":return o;case"ip":return t;case"ip4":case"ipv4":case"inet4":return n;case"ip6":case"ipv6":case"inet6":return i;case"idn":return u;case"url":return!this._parts.urn;case"urn":return!!this._parts.urn;case"punycode":return h}return null};var x=o.protocol;var P=o.port;var I=o.hostname;o.protocol=function(e,t){if(e){e=e.replace(/:(\/\/)?$/,"");if(!e.match(s.protocol_expression)){throw new TypeError('Protocol "'+e+"\" contains characters other than [A-Z0-9.+-] or doesn't start with [A-Z]")}}return x.call(this,e,t)};o.scheme=o.protocol;o.port=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e!==undefined){if(e===0){e=null}if(e){e+="";if(e.charAt(0)===":"){e=e.substring(1)}s.ensureValidPort(e)}}return P.call(this,e,t)};o.hostname=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e!==undefined){var r={preventInvalidHostname:this._parts.preventInvalidHostname};var n=s.parseHost(e,r);if(n!=="/"){throw new TypeError('Hostname "'+e+'" contains characters other than [A-Z0-9.-]')}e=r.hostname;if(this._parts.preventInvalidHostname){s.ensureValidHostname(e,this._parts.protocol)}}return I.call(this,e,t)};o.origin=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e===undefined){var r=this.protocol();var n=this.authority();if(!n){return""}return(r?r+"://":"")+this.authority()}else{var i=s(e);this.protocol(i.protocol()).authority(i.authority()).build(!t);return this}};o.host=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e===undefined){return this._parts.hostname?s.buildHost(this._parts):""}else{var r=s.parseHost(e,this._parts);if(r!=="/"){throw new TypeError('Hostname "'+e+'" contains characters other than [A-Z0-9.-]')}this.build(!t);return this}};o.authority=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e===undefined){return this._parts.hostname?s.buildAuthority(this._parts):""}else{var r=s.parseAuthority(e,this._parts);if(r!=="/"){throw new TypeError('Hostname "'+e+'" contains characters other than [A-Z0-9.-]')}this.build(!t);return this}};o.userinfo=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e===undefined){var r=s.buildUserinfo(this._parts);return r?r.substring(0,r.length-1):r}else{if(e[e.length-1]!=="@"){e+="@"}s.parseUserinfo(e,this._parts);this.build(!t);return this}};o.resource=function(e,t){var r;if(e===undefined){return this.path()+this.search()+this.hash()}r=s.parse(e);this._parts.path=r.path;this._parts.query=r.query;this._parts.fragment=r.fragment;this.build(!t);return this};o.subdomain=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e===undefined){if(!this._parts.hostname||this.is("IP")){return""}var r=this._parts.hostname.length-this.domain().length-1;return this._parts.hostname.substring(0,r)||""}else{var n=this._parts.hostname.length-this.domain().length;var i=this._parts.hostname.substring(0,n);var a=new RegExp("^"+h(i));if(e&&e.charAt(e.length-1)!=="."){e+="."}if(e.indexOf(":")!==-1){throw new TypeError("Domains cannot contain colons")}if(e){s.ensureValidHostname(e,this._parts.protocol)}this._parts.hostname=this._parts.hostname.replace(a,e);this.build(!t);return this}};o.domain=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(typeof e==="boolean"){t=e;e=undefined}if(e===undefined){if(!this._parts.hostname||this.is("IP")){return""}var r=this._parts.hostname.match(/\./g);if(r&&r.length<2){return this._parts.hostname}var n=this._parts.hostname.length-this.tld(t).length-1;n=this._parts.hostname.lastIndexOf(".",n-1)+1;return this._parts.hostname.substring(n)||""}else{if(!e){throw new TypeError("cannot set domain empty")}if(e.indexOf(":")!==-1){throw new TypeError("Domains cannot contain colons")}s.ensureValidHostname(e,this._parts.protocol);if(!this._parts.hostname||this.is("IP")){this._parts.hostname=e}else{var i=new RegExp(h(this.domain())+"$");this._parts.hostname=this._parts.hostname.replace(i,e)}this.build(!t);return this}};o.tld=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(typeof e==="boolean"){t=e;e=undefined}if(e===undefined){if(!this._parts.hostname||this.is("IP")){return""}var n=this._parts.hostname.lastIndexOf(".");var i=this._parts.hostname.substring(n+1);if(t!==true&&r&&r.list[i.toLowerCase()]){return r.get(this._parts.hostname)||i}return i}else{var s;if(!e){throw new TypeError("cannot set TLD empty")}else if(e.match(/[^a-zA-Z0-9-]/)){if(r&&r.is(e)){s=new RegExp(h(this.tld())+"$");this._parts.hostname=this._parts.hostname.replace(s,e)}else{throw new TypeError('TLD "'+e+'" contains characters other than [A-Z0-9]')}}else if(!this._parts.hostname||this.is("IP")){throw new ReferenceError("cannot set TLD on non-domain host")}else{s=new RegExp(h(this.tld())+"$");this._parts.hostname=this._parts.hostname.replace(s,e)}this.build(!t);return this}};o.directory=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e===undefined||e===true){if(!this._parts.path&&!this._parts.hostname){return""}if(this._parts.path==="/"){return"/"}var r=this._parts.path.length-this.filename().length-1;var n=this._parts.path.substring(0,r)||(this._parts.hostname?"/":"");return e?s.decodePath(n):n}else{var i=this._parts.path.length-this.filename().length;var a=this._parts.path.substring(0,i);var o=new RegExp("^"+h(a));if(!this.is("relative")){if(!e){e="/"}if(e.charAt(0)!=="/"){e="/"+e}}if(e&&e.charAt(e.length-1)!=="/"){e+="/"}e=s.recodePath(e);this._parts.path=this._parts.path.replace(o,e);this.build(!t);return this}};o.filename=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(typeof e!=="string"){if(!this._parts.path||this._parts.path==="/"){return""}var r=this._parts.path.lastIndexOf("/");var n=this._parts.path.substring(r+1);return e?s.decodePathSegment(n):n}else{var i=false;if(e.charAt(0)==="/"){e=e.substring(1)}if(e.match(/\.?\//)){i=true}var a=new RegExp(h(this.filename())+"$");e=s.recodePath(e);this._parts.path=this._parts.path.replace(a,e);if(i){this.normalizePath(t)}else{this.build(!t)}return this}};o.suffix=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e===undefined||e===true){if(!this._parts.path||this._parts.path==="/"){return""}var r=this.filename();var n=r.lastIndexOf(".");var i,a;if(n===-1){return""}i=r.substring(n+1);a=/^[a-z0-9%]+$/i.test(i)?i:"";return e?s.decodePathSegment(a):a}else{if(e.charAt(0)==="."){e=e.substring(1)}var o=this.suffix();var u;if(!o){if(!e){return this}this._parts.path+="."+s.recodePath(e)}else if(!e){u=new RegExp(h("."+o)+"$")}else{u=new RegExp(h(o)+"$")}if(u){e=s.recodePath(e);this._parts.path=this._parts.path.replace(u,e)}this.build(!t);return this}};o.segment=function(e,t,r){var n=this._parts.urn?":":"/";var i=this.path();var s=i.substring(0,1)==="/";var a=i.split(n);if(e!==undefined&&typeof e!=="number"){r=t;t=e;e=undefined}if(e!==undefined&&typeof e!=="number"){throw new Error('Bad segment "'+e+'", must be 0-based integer')}if(s){a.shift()}if(e<0){e=Math.max(a.length+e,0)}if(t===undefined){return e===undefined?a:a[e]}else if(e===null||a[e]===undefined){if(p(t)){a=[];for(var o=0,u=t.length;o<u;o++){if(!t[o].length&&(!a.length||!a[a.length-1].length)){continue}if(a.length&&!a[a.length-1].length){a.pop()}a.push(m(t[o]))}}else if(t||typeof t==="string"){t=m(t);if(a[a.length-1]===""){a[a.length-1]=t}else{a.push(t)}}}else{if(t){a[e]=m(t)}else{a.splice(e,1)}}if(s){a.unshift("")}return this.path(a.join(n),r)};o.segmentCoded=function(e,t,r){var n,i,a;if(typeof e!=="number"){r=t;t=e;e=undefined}if(t===undefined){n=this.segment(e,t,r);if(!p(n)){n=n!==undefined?s.decode(n):undefined}else{for(i=0,a=n.length;i<a;i++){n[i]=s.decode(n[i])}}return n}if(!p(t)){t=typeof t==="string"||t instanceof String?s.encode(t):t}else{for(i=0,a=t.length;i<a;i++){t[i]=s.encode(t[i])}}return this.segment(e,t,r)};var S=o.query;o.query=function(e,t){if(e===true){return s.parseQuery(this._parts.query,this._parts.escapeQuerySpace)}else if(typeof e==="function"){var r=s.parseQuery(this._parts.query,this._parts.escapeQuerySpace);var n=e.call(this,r);this._parts.query=s.buildQuery(n||r,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace);this.build(!t);return this}else if(e!==undefined&&typeof e!=="string"){this._parts.query=s.buildQuery(e,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace);this.build(!t);return this}else{return S.call(this,e,t)}};o.setQuery=function(e,t,r){var n=s.parseQuery(this._parts.query,this._parts.escapeQuerySpace);if(typeof e==="string"||e instanceof String){n[e]=t!==undefined?t:null}else if(typeof e==="object"){for(var i in e){if(u.call(e,i)){n[i]=e[i]}}}else{throw new TypeError("URI.addQuery() accepts an object, string as the name parameter")}this._parts.query=s.buildQuery(n,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace);if(typeof e!=="string"){r=t}this.build(!r);return this};o.addQuery=function(e,t,r){var n=s.parseQuery(this._parts.query,this._parts.escapeQuerySpace);s.addQuery(n,e,t===undefined?null:t);this._parts.query=s.buildQuery(n,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace);if(typeof e!=="string"){r=t}this.build(!r);return this};o.removeQuery=function(e,t,r){var n=s.parseQuery(this._parts.query,this._parts.escapeQuerySpace);s.removeQuery(n,e,t);this._parts.query=s.buildQuery(n,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace);if(typeof e!=="string"){r=t}this.build(!r);return this};o.hasQuery=function(e,t,r){var n=s.parseQuery(this._parts.query,this._parts.escapeQuerySpace);return s.hasQuery(n,e,t,r)};o.setSearch=o.setQuery;o.addSearch=o.addQuery;o.removeSearch=o.removeQuery;o.hasSearch=o.hasQuery;o.normalize=function(){if(this._parts.urn){return this.normalizeProtocol(false).normalizePath(false).normalizeQuery(false).normalizeFragment(false).build()}return this.normalizeProtocol(false).normalizeHostname(false).normalizePort(false).normalizePath(false).normalizeQuery(false).normalizeFragment(false).build()};o.normalizeProtocol=function(e){if(typeof this._parts.protocol==="string"){this._parts.protocol=this._parts.protocol.toLowerCase();this.build(!e)}return this};o.normalizeHostname=function(r){if(this._parts.hostname){if(this.is("IDN")&&e){this._parts.hostname=e.toASCII(this._parts.hostname)}else if(this.is("IPv6")&&t){this._parts.hostname=t.best(this._parts.hostname)}this._parts.hostname=this._parts.hostname.toLowerCase();this.build(!r)}return this};o.normalizePort=function(e){if(typeof this._parts.protocol==="string"&&this._parts.port===s.defaultPorts[this._parts.protocol]){this._parts.port=null;this.build(!e)}return this};o.normalizePath=function(e){var t=this._parts.path;if(!t){return this}if(this._parts.urn){this._parts.path=s.recodeUrnPath(this._parts.path);this.build(!e);return this}if(this._parts.path==="/"){return this}t=s.recodePath(t);var r;var n="";var i,a;if(t.charAt(0)!=="/"){r=true;t="/"+t}if(t.slice(-3)==="/.."||t.slice(-2)==="/."){t+="/"}t=t.replace(/(\/(\.\/)+)|(\/\.$)/g,"/").replace(/\/{2,}/g,"/");if(r){n=t.substring(1).match(/^(\.\.\/)+/)||"";if(n){n=n[0]}}while(true){i=t.search(/\/\.\.(\/|$)/);if(i===-1){break}else if(i===0){t=t.substring(3);continue}a=t.substring(0,i).lastIndexOf("/");if(a===-1){a=i}t=t.substring(0,a)+t.substring(i+3)}if(r&&this.is("relative")){t=n+t.substring(1)}this._parts.path=t;this.build(!e);return this};o.normalizePathname=o.normalizePath;o.normalizeQuery=function(e){if(typeof this._parts.query==="string"){if(!this._parts.query.length){this._parts.query=null}else{this.query(s.parseQuery(this._parts.query,this._parts.escapeQuerySpace))}this.build(!e)}return this};o.normalizeFragment=function(e){if(!this._parts.fragment){this._parts.fragment=null;this.build(!e)}return this};o.normalizeSearch=o.normalizeQuery;o.normalizeHash=o.normalizeFragment;o.iso8859=function(){var e=s.encode;var t=s.decode;s.encode=escape;s.decode=decodeURIComponent;try{this.normalize()}finally{s.encode=e;s.decode=t}return this};o.unicode=function(){var e=s.encode;var t=s.decode;s.encode=_;s.decode=unescape;try{this.normalize()}finally{s.encode=e;s.decode=t}return this};o.readable=function(){var t=this.clone();t.username("").password("").normalize();var r="";if(t._parts.protocol){r+=t._parts.protocol+"://"}if(t._parts.hostname){if(t.is("punycode")&&e){r+=e.toUnicode(t._parts.hostname);if(t._parts.port){r+=":"+t._parts.port}}else{r+=t.host()}}if(t._parts.hostname&&t._parts.path&&t._parts.path.charAt(0)!=="/"){r+="/"}r+=t.path(true);if(t._parts.query){var n="";for(var i=0,a=t._parts.query.split("&"),o=a.length;i<o;i++){var u=(a[i]||"").split("=");n+="&"+s.decodeQuery(u[0],this._parts.escapeQuerySpace).replace(/&/g,"%26");if(u[1]!==undefined){n+="="+s.decodeQuery(u[1],this._parts.escapeQuerySpace).replace(/&/g,"%26")}}r+="?"+n.substring(1)}r+=s.decodeQuery(t.hash(),true);return r};o.absoluteTo=function(e){var t=this.clone();var r=["protocol","username","password","hostname","port"];var n,i,a;if(this._parts.urn){throw new Error("URNs do not have any generally defined hierarchical components")}if(!(e instanceof s)){e=new s(e)}if(t._parts.protocol){return t}else{t._parts.protocol=e._parts.protocol}if(this._parts.hostname){return t}for(i=0;a=r[i];i++){t._parts[a]=e._parts[a]}if(!t._parts.path){t._parts.path=e._parts.path;if(!t._parts.query){t._parts.query=e._parts.query}}else{if(t._parts.path.substring(-2)===".."){t._parts.path+="/"}if(t.path().charAt(0)!=="/"){n=e.directory();n=n?n:e.path().indexOf("/")===0?"/":"";t._parts.path=(n?n+"/":"")+t._parts.path;t.normalizePath()}}t.build();return t};o.relativeTo=function(e){var t=this.clone().normalize();var r,n,i,a,o;if(t._parts.urn){throw new Error("URNs do not have any generally defined hierarchical components")}e=new s(e).normalize();r=t._parts;n=e._parts;a=t.path();o=e.path();if(a.charAt(0)!=="/"){throw new Error("URI is already relative")}if(o.charAt(0)!=="/"){throw new Error("Cannot calculate a URI relative to another relative URI")}if(r.protocol===n.protocol){r.protocol=null}if(r.username!==n.username||r.password!==n.password){return t.build()}if(r.protocol!==null||r.username!==null||r.password!==null){return t.build()}if(r.hostname===n.hostname&&r.port===n.port){r.hostname=null;r.port=null}else{return t.build()}if(a===o){r.path="";return t.build()}i=s.commonPath(a,o);if(!i){return t.build()}var u=n.path.substring(i.length).replace(/[^\/]*$/,"").replace(/.*?\//g,"../");r.path=u+r.path.substring(i.length)||"./";return t.build()};o.equals=function(e){var t=this.clone();var r=new s(e);var n={};var i={};var a={};var o,h,f;t.normalize();r.normalize();if(t.toString()===r.toString()){return true}o=t.query();h=r.query();t.query("");r.query("");if(t.toString()!==r.toString()){return false}if(o.length!==h.length){return false}n=s.parseQuery(o,this._parts.escapeQuerySpace);i=s.parseQuery(h,this._parts.escapeQuerySpace);for(f in n){if(u.call(n,f)){if(!p(n[f])){if(n[f]!==i[f]){return false}}else if(!d(n[f],i[f])){return false}a[f]=true}}for(f in i){if(u.call(i,f)){if(!a[f]){return false}}}return true};o.preventInvalidHostname=function(e){this._parts.preventInvalidHostname=!!e;return this};o.duplicateQueryParameters=function(e){this._parts.duplicateQueryParameters=!!e;return this};o.escapeQuerySpace=function(e){this._parts.escapeQuerySpace=!!e;return this};return s});
}
});
//# sourceMappingURL=Library-preload.js.map
