/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/now","sap/base/util/Version","sap/base/assert","sap/base/Log","sap/ui/dom/includeScript","sap/ui/dom/includeStylesheet","sap/ui/security/FrameOptions","sap/ui/performance/Measurement","sap/ui/performance/trace/Interaction","sap/base/util/LoaderExtensions","sap/ui/Device","sap/ui/thirdparty/jquery","ui5loader-autoconfig","jquery.sap.stubs"],function(now,Version,assert,Log,includeScript,includeStylesheet,FrameOptions,Measurement,Interaction,LoaderExtensions,Device,jQuery){"use strict";if(!jQuery){throw new Error("Loading of jQuery failed")}var ui5loader=sap.ui.loader;if(!ui5loader||!ui5loader._){throw new Error("The UI5 compatilbility module requires a UI5 specific AMD implementation")}var _ui5loader=ui5loader._;(function(){jQuery.support=jQuery.support||{};jQuery.support.retina=Device.support.retina;jQuery.support.touch=Device.support.touch;jQuery.support.cssTransforms=true;jQuery.support.cssTransforms3d=true;jQuery.support.cssTransitions=true;jQuery.support.cssAnimations=true;jQuery.support.cssGradients=true;jQuery.support.flexBoxPrefixed=false;jQuery.support.flexBoxLayout=false;jQuery.support.newFlexBoxLayout=true;jQuery.support.hasFlexBoxSupport=true})();jQuery.sap=jQuery.sap||{};jQuery.sap.Version=Version;jQuery.sap.now=now;var fnMakeLocalStorageAccessor=function(e,r,t){return function(o){try{if(o!=null||r==="string"){if(o){localStorage.setItem(e,r==="boolean"?"X":o)}else{localStorage.removeItem(e)}t(o)}o=localStorage.getItem(e);return r==="boolean"?o==="X":o}catch(r){Log.warning("Could not access localStorage while accessing '"+e+"' (value: '"+o+"', are cookies disabled?): "+r.message)}}};jQuery.sap.debug=fnMakeLocalStorageAccessor.call(this,"sap-ui-debug","",function(e){alert("Usage of debug sources is "+(e?"on":"off")+" now.\nFor the change to take effect, you need to reload the page.")});jQuery.sap.setReboot=fnMakeLocalStorageAccessor.call(this,"sap-ui-reboot-URL","string",function(e){if(e){alert("Next time this app is launched (only once), it will load UI5 from:\n"+e+".\nPlease reload the application page now.")}});jQuery.sap.statistics=fnMakeLocalStorageAccessor.call(this,"sap-ui-statistics","boolean",function(e){alert("Usage of Gateway statistics "+(e?"on":"off")+" now.\nFor the change to take effect, you need to reload the page.")});jQuery.sap.log=Object.assign(Log.getLogger(),{Level:Log.Level,getLogger:Log.getLogger,getLogEntries:Log.getLogEntries,addLogListener:Log.addLogListener,removeLogListener:Log.removeLogListener,logSupportInfo:Log.logSupportInfo,LogLevel:Log.Level,getLog:Log.getLogEntries});var sWindowName=typeof window==="undefined"||window.top==window?"":"["+window.location.pathname.split("/").slice(-1)[0]+"] ";jQuery.sap.assert=function(e,r){if(!e){var t=typeof r==="function"?r():r;assert(e,sWindowName+t)}};jQuery.sap.factory=function e(r){jQuery.sap.assert(typeof r=="object","oPrototype must be an object (incl. null)");function t(){}t.prototype=r;return t};jQuery.sap.newObject=function e(r){jQuery.sap.assert(typeof r=="object","oPrototype must be an object (incl. null)");return Object.create(r||null)};jQuery.sap.getter=function(e){return function(){return e}};jQuery.sap.getObject=function(e,r,t){var o=t||window,s=(e||"").split("."),a=s.length,n=isNaN(r)?0:a-r,u;if(sap.ui.loader._.getSyncCallBehavior()&&t===window){Log.error("[nosync] getObject called to retrieve global name '"+e+"'")}for(u=0;o&&u<a;u++){if(!o[s[u]]&&u<n){o[s[u]]={}}o=o[s[u]]}return o};jQuery.sap.setObject=function(e,r,t){var o=t||window,s=(e||"").split("."),a=s.length,n;if(a>0){for(n=0;o&&n<a-1;n++){if(!o[s[n]]){o[s[n]]={}}o=o[s[n]]}o[s[a-1]]=r}};jQuery.sap.measure=Measurement;jQuery.sap.measure.clearInteractionMeasurements=()=>{Interaction.clear()};jQuery.sap.measure.startInteraction=(e,r)=>{Interaction.start(e,r)};jQuery.sap.measure.endInteraction=e=>{Interaction.end(e)};jQuery.sap.measure.getPendingInteractionMeasurement=()=>Interaction.getPending();jQuery.sap.measure.filterInteractionMeasurements=e=>Interaction.filter(e);jQuery.sap.measure.getAllInteractionMeasurements=e=>Interaction.getAll(e);jQuery.sap.measure.getRequestTimings=function(){if(performance.getEntriesByType){return performance.getEntriesByType("resource")}return[]};jQuery.sap.measure.clearRequestTimings=function(){if(performance.clearResourceTimings){performance.clearResourceTimings()}};jQuery.sap.measure.setRequestBufferSize=function(e){if(performance.setResourceTimingBufferSize){performance.setResourceTimingBufferSize(e)}};(function(){var e=LoaderExtensions.getKnownSubtypes(),r;(function(){var t="";for(var o in e){t=(t?t+"|":"")+"(?:(?:"+e[o].join("\\.|")+"\\.)?"+o+")"}t="\\.(?:"+t+"|[^./]+)$";r=new RegExp(t)})();function t(e){if(/^jquery\.sap\./.test(e)){return e}return e.replace(/\./g,"/")}jQuery.sap.getModulePath=function(e,r){return jQuery.sap.getResourcePath(t(e),r)};jQuery.sap.getResourcePath=function(e,t){if(arguments.length===1&&e!=""){var o=e.split(/\//);var s=r.exec(o[o.length-1]);if(s){t=s[0];o[o.length-1]=o[o.length-1].slice(0,s.index);e=o.join("/")}else{t=""}}return _ui5loader.getResourcePath(e,t)};jQuery.sap.registerModulePath=function e(r,t){jQuery.sap.assert(!/\//.test(r),"module name must not contain a slash.");r=r.replace(/\./g,"/");t=t||".";LoaderExtensions.registerResourcePath(r,t)};jQuery.sap.registerResourcePath=LoaderExtensions.registerResourcePath;jQuery.sap.registerModuleShims=function(e){jQuery.sap.assert(typeof e==="object","mShims must be an object");ui5loader.config({shim:e})};jQuery.sap.isDeclared=function e(r,o){var s=_ui5loader.getModuleState(t(r)+".js");return s&&(o||s>0)};jQuery.sap.isResourceLoaded=function e(r){return!!_ui5loader.getModuleState(r)};jQuery.sap.getAllDeclaredModules=LoaderExtensions.getAllRequiredModules;jQuery.sap.declare=function(e,r){var o=e;if(typeof e==="object"){o=e.modName;e=t(e.modName)+(e.type?"."+e.type:"")+".js"}else{e=t(e)+".js"}_ui5loader.declareModule(e);if(r!==false){jQuery.sap.getObject(o,1)}};jQuery.sap.require=function(r){if(arguments.length>1){for(var o=0;o<arguments.length;o++){jQuery.sap.require(arguments[o])}return this}if(typeof r==="object"){jQuery.sap.assert(!r.type||e.js.indexOf(r.type)>=0,"type must be empty or one of "+e.js.join(", "));r=t(r.modName)+(r.type?"."+r.type:"")}else{r=t(r)}sap.ui.requireSync(r)};Object.defineProperty(jQuery.sap.require,"_hook",{get:function(){return _ui5loader.translate},set:function(e){jQuery.sap.assert(false,"jquery.sap.global: legacy hook for code transformation should no longer be used");_ui5loader.translate=e}});jQuery.sap.preloadModules=function(e,r,t){Log.error("jQuery.sap.preloadModules was never a public API and has been removed. Migrate to Core.loadLibrary()!")};jQuery.sap.registerPreloadedModules=function(e){var r=e.modules;if(Version(e.version||"1.0").compareTo("2.0")<0){r={};for(var o in e.modules){r[t(o)+".js"]=e.modules[o]}}sap.ui.require.preload(r,e.name,e.url)};jQuery.sap.unloadResources=_ui5loader.unloadResources;jQuery.sap.getResourceName=function(e,r){return t(e)+(r==null?".js":r)};jQuery.sap.loadResource=LoaderExtensions.loadResource;jQuery.sap._loadJSResourceAsync=_ui5loader.loadJSResourceAsync})();jQuery.sap.includeScript=includeScript;jQuery.sap.includeStyleSheet=includeStylesheet;jQuery.sap.FrameOptions=FrameOptions;jQuery.sap.globalEval=function(){eval(arguments[0])};(function(){var e=Device.browser;var r=e.name;if(!jQuery.browser){jQuery.browser=function(e){var r=/(webkit)[ \/]([\w.]+)/,t=/(opera)(?:.*version)?[ \/]([\w.]+)/,o=/(mozilla)(?:.*? rv:([\w.]+))?/,e=e.toLowerCase(),s=r.exec(e)||t.exec(e)||e.indexOf("compatible")<0&&o.exec(e)||[],a={};if(s[1]){a[s[1]]=true;a.version=s[2]||"0";if(a.webkit){a.safari=true}}return a}(window.navigator.userAgent)}if(r===e.BROWSER.CHROME){jQuery.browser.safari=false;jQuery.browser.chrome=true}else if(r===e.BROWSER.SAFARI){jQuery.browser.safari=true;jQuery.browser.chrome=false}if(r){jQuery.browser.fVersion=e.version;jQuery.browser.mobile=e.mobile}})();return jQuery});
//# sourceMappingURL=jquery.sap.global.js.map