/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["sap/base/assert","sap/base/config","sap/base/Eventing","sap/base/Log","sap/base/i18n/Localization","sap/base/i18n/LanguageTag","sap/base/i18n/date/CalendarType","sap/base/i18n/date/CalendarWeekNumbering","sap/base/util/deepEqual","sap/base/util/extend","sap/base/util/isEmptyObject"],(e,t,a,r,n,s,i,o,u,m,l)=>{"use strict";const d=new a;const g=t.getWritableInstance();const p={};let c;let y;let f=false;const b={"":{pattern:null},1:{pattern:"dd.MM.yyyy"},2:{pattern:"MM/dd/yyyy"},3:{pattern:"MM-dd-yyyy"},4:{pattern:"yyyy.MM.dd"},5:{pattern:"yyyy/MM/dd"},6:{pattern:"yyyy-MM-dd"},7:{pattern:"Gyy.MM.dd"},8:{pattern:"Gyy/MM/dd"},9:{pattern:"Gyy-MM-dd"},A:{pattern:"yyyy/MM/dd"},B:{pattern:"yyyy/MM/dd"},C:{pattern:"yyyy/MM/dd"}};const C={"":{short:null,medium:null,dayPeriods:null},0:{short:"HH:mm",medium:"HH:mm:ss",dayPeriods:null},1:{short:"hh:mm a",medium:"hh:mm:ss a",dayPeriods:["AM","PM"]},2:{short:"hh:mm a",medium:"hh:mm:ss a",dayPeriods:["am","pm"]},3:{short:"KK:mm a",medium:"KK:mm:ss a",dayPeriods:["AM","PM"]},4:{short:"KK:mm a",medium:"KK:mm:ss a",dayPeriods:["am","pm"]}};const A={"":{groupingSeparator:null,decimalSeparator:null}," ":{groupingSeparator:".",decimalSeparator:","},X:{groupingSeparator:",",decimalSeparator:"."},Y:{groupingSeparator:" ",decimalSeparator:","}};function P(e,t){if(!e){throw new TypeError(t)}}function h(e,a){t._.invalidate();const r=p[e];if(a!=null){p[e]=a}else{delete p[e]}if((r!=null||a!=null)&&!u(r,a)){const t=!c;c??={};c[e]=a;if(t){F()}}}function T(e){let t;if(e&&typeof e==="string"){try{t=new s(e)}catch(e){}}else if(e instanceof s){t=e}return t}const S={attachChange(e){d.attachEvent("change",e)},detachChange(e){d.detachEvent("change",e)},getLanguageTag(){function e(){let e=new s(n.getLanguage());if(!l(p)||S.getCalendarWeekNumbering()!==o.Default){let t=e.toString();if(t.indexOf("-x-")<0){t+="-x-sapufmt"}else if(t.indexOf("-sapufmt")<=t.indexOf("-x-")){t+="-sapufmt"}e=new s(t)}return e}return g.get({name:"sapUiFormatLocale",type:function(e){return new s(e)},defaultValue:e,external:true})},setLanguageTag(e){const t=T(e);P(e==null||t,"vLanguageTag must be a BCP47 language tag or Java Locale id or null");const a=S.getLanguageTag();g.set("sapUiFormatLocale",t?.toString());const r=S.getLanguageTag();if(a.toString()!==r.toString()){const e=!c;c??={};c.languageTag=r.toString();if(e){F()}}},_set:h,getCustomUnits(){return p["units"]?.["short"]},setCustomUnits(e){let t=null;if(e){t={short:e}}h("units",t)},addCustomUnits(e){const t=S.getCustomUnits();if(t){e=m({},t,e)}S.setCustomUnits(e)},setUnitMappings(e){h("unitMappings",e)},addUnitMappings(e){const t=S.getUnitMappings();if(t){e=m({},t,e)}S.setUnitMappings(e)},getUnitMappings(){return p["unitMappings"]},getDatePattern(t){e(t=="short"||t=="medium"||t=="long"||t=="full","sStyle must be short, medium, long or full");return p["dateFormats-"+t]},setDatePattern(e,t){P(e=="short"||e=="medium"||e=="long"||e=="full","sStyle must be short, medium, long or full");h("dateFormats-"+e,t)},getTimePattern(t){e(t=="short"||t=="medium"||t=="long"||t=="full","sStyle must be short, medium, long or full");return p["timeFormats-"+t]},setTimePattern(e,t){P(e=="short"||e=="medium"||e=="long"||e=="full","sStyle must be short, medium, long or full");h("timeFormats-"+e,t)},getNumberSymbol(t){e(["group","decimal","plusSign","minusSign"].includes(t),"sType must be decimal, group, plusSign or minusSign");return p["symbols-latn-"+t]},setNumberSymbol(e,t){P(["group","decimal","plusSign","minusSign"].includes(e),"sType must be decimal, group, plusSign or minusSign");h("symbols-latn-"+e,t)},getCustomCurrencies(){return p["currency"]},setCustomCurrencies(e){P(typeof e==="object"||e==null,"mCurrencyDigits must be an object");Object.keys(e||{}).forEach(function(t){P(typeof t==="string");P(typeof e[t]==="object")});h("currency",e)},addCustomCurrencies(e){const t=S.getCustomCurrencies();if(t){e=m({},t,e)}S.setCustomCurrencies(e)},_setDayPeriods(t,a){e(t=="narrow"||t=="abbreviated"||t=="wide","sWidth must be narrow, abbreviated or wide");h("dayPeriods-format-"+t,a)},getABAPDateFormat(){const e=g.get({name:"sapUiABAPDateFormat",type:t.Type.String,defaultValue:g.get({name:"sapUiLegacyDateFormat",type:t.Type.String,external:true}),external:true});return e?e.toUpperCase():undefined},setABAPDateFormat(e){e=e?String(e).toUpperCase():"";P(b.hasOwnProperty(e),"sFormatId must be one of ['1','2','3','4','5','6','7','8','9','A','B','C'] or empty");const t=!c;const a=S.getABAPDateFormat();if(a!==e||!f){c??={};g.set("sapUiABAPDateFormat",e);c.ABAPDateFormat=e;S.setDatePattern("short",b[e].pattern);S.setDatePattern("medium",b[e].pattern);if(t){F()}}},getABAPTimeFormat(){const e=g.get({name:"sapUiABAPTimeFormat",type:t.Type.String,defaultValue:g.get({name:"sapUiLegacyTimeFormat",type:t.Type.String,external:true}),external:true});return e?e.toUpperCase():undefined},setABAPTimeFormat(e){e=e||"";P(C.hasOwnProperty(e),"sFormatId must be one of ['0','1','2','3','4'] or empty");const t=!c;const a=S.getABAPTimeFormat();if(a!==e||!f){c??={};g.set("sapUiABAPTimeFormat",e);c.ABAPTimeFormat=e;S.setTimePattern("short",C[e]["short"]);S.setTimePattern("medium",C[e]["medium"]);S._setDayPeriods("abbreviated",C[e].dayPeriods);if(t){F()}}},getABAPNumberFormat(){const e=g.get({name:"sapUiABAPNumberFormat",type:t.Type.String,defaultValue:g.get({name:"sapUiLegacyNumberFormat",type:t.Type.String,external:true}),external:true});return e?e.toUpperCase():undefined},setABAPNumberFormat(e){e=e?e.toUpperCase():"";P(A.hasOwnProperty(e),"sFormatId must be one of [' ','X','Y'] or empty");const t=!c;const a=S.getABAPNumberFormat();if(a!==e||!f){c??={};g.set("sapUiABAPNumberFormat",e);c.ABAPNumberFormat=e;S.setNumberSymbol("group",A[e].groupingSeparator);S.setNumberSymbol("decimal",A[e].decimalSeparator);if(t){F()}}},setCustomIslamicCalendarData(e){P(Array.isArray(e),"aCustomCalendarData must be an Array");const t=!c;c??={};y=c.customIslamicCalendarData=e.slice();if(t){F()}},getCustomIslamicCalendarData(){return y?.slice()??undefined},setTrailingCurrencyCode(e){P(typeof e==="boolean","bTrailingCurrencyCode must be a boolean");g.set("sapUiTrailingCurrencyCode",e)},getTrailingCurrencyCode(){return g.get({name:"sapUiTrailingCurrencyCode",type:t.Type.Boolean,defaultValue:true,external:true})},getCustomLocaleData(){return p},getCalendarWeekNumbering(){let e=o.Default;try{e=g.get({name:"sapUiCalendarWeekNumbering",type:o,defaultValue:o.Default,external:true})}catch(e){}return e},setCalendarWeekNumbering(e){t._.checkEnum(o,e,"calendarWeekNumbering");const a=g.get({name:"sapUiCalendarWeekNumbering",type:o,defaultValue:o.Default,external:true});if(a!==e){const t=!c;c??={};g.set("sapUiCalendarWeekNumbering",e);c.calendarWeekNumbering=e;if(t){F()}}},getCalendarType(){let e,a=g.get({name:"sapUiCalendarType",type:t.Type.String,external:true});a??=null;if(a){for(e in i){if(e.toLowerCase()===a.toLowerCase()){return e}}r.warning("Parameter 'calendarType' is set to "+a+" which isn't a valid value and therefore ignored. The calendar type is determined from format setting and current locale")}const s=S.getABAPDateFormat();switch(s){case"1":case"2":case"3":case"4":case"5":case"6":return i.Gregorian;case"7":case"8":case"9":return i.Japanese;case"A":case"B":return i.Islamic;case"C":return i.Persian;default:return n.getPreferredCalendarType()}},setCalendarType(e){const t=S.getCalendarType();g.set("sapUiCalendarType",e);const a=S.getCalendarType();if(t!==a){const e=!c;c??={};c.calendarType=a;if(e){F()}}}};function F(){d.fireEvent("change",c);c=undefined}function M(){const e=S.getABAPDateFormat();if(e!==undefined){S.setABAPDateFormat(e)}const t=S.getABAPNumberFormat();if(t!==undefined){S.setABAPNumberFormat(t)}const a=S.getABAPTimeFormat();if(a!==undefined){S.setABAPTimeFormat(a)}f=true}M();return S});
//# sourceMappingURL=Formatting.js.map