/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/assert","sap/base/future","sap/base/Log","sap/base/i18n/LanguageFallback","sap/base/i18n/Localization","sap/base/strings/formatMessage","sap/base/util/Properties","sap/base/util/merge"],function(e,r,t,n,a,s,o,i){"use strict";var l={en_US_saptrc:"1Q",en_US_sappsd:"2Q",en_US_saprigi:"3Q"};var u="en";const c={_oCache:new Map,_delete(e){this._oCache.delete(e)},_load(e){return o.create(e)},_set(e,r){this._oCache.set(e,r)},get(e,r,t){if(this._oCache.has(e)){const r=this._oCache.get(e);if(t){return Promise.resolve(r)}else if(!(r instanceof Promise)){return r}}const n=this._load(r);if(n instanceof Promise){n.then(r=>{if(r){this._set(e,r)}else{this._delete(e)}}).catch(r=>{this._delete(e);throw r})}if(n){this._set(e,n)}return n}};function f(e){var r;r=a.getLanguage();r=n.normalize(r);return r||e}var h=/^((?:[^?#]*\/)?[^\/?#]*)(\.[^.\/?#]+)((?:\?([^#]*))?(?:#(.*))?)$/;var p=[".properties",".hdbtextbundle"];function d(e){var r=h.exec(e);if(!r||p.indexOf(r[2])<0){throw new Error("resource URL '"+e+"' has unknown type (should be one of "+p.join(",")+")")}return{url:e,prefix:r[1],ext:r[2],query:r[4],hash:r[5]||"",suffix:r[2]+(r[3]||"")}}function g(e,t,s,o,i,l,c){this.sLocale=n.normalize(t)||f(l===undefined?u:l);this.oUrlInfo=d(e);this.bIncludeInfo=s;this.bAsync=o;this.aCustomBundles=[];this.aPropertyFiles=[];this.aPropertyOrigins=[];this.aLocales=[];this._aFallbackLocales=n.calculate(this.sLocale,i||a.getSupportedLanguages(),l," of the bundle '"+this.oUrlInfo.url+"'",c);if(o){return b(this).then(()=>this,e=>{r.errorThrows(e.message);return this})}m(this)}g.prototype._enhance=function(e){if(e instanceof g){this.aCustomBundles.push(e)}else{t.error("Custom resource bundle is either undefined or not an instanceof sap/base/i18n/ResourceBundle. Therefore this custom resource bundle will be ignored!")}};g.prototype.getText=function(r,t,n){var a=this._getTextFromProperties(r,t);if(a!=null){return a}a=this._getTextFromFallback(r,t);if(a!=null){return a}if(n){return undefined}else{e(false,"could not find any translatable text for key '"+r+"' in bundle file(s): '"+this.aPropertyOrigins.join("', '")+"'");return this._formatValue(r,r,t)}};g.prototype._formatValue=function(e,t,n){if(typeof e==="string"){if(n!==undefined&&!Array.isArray(n)){r.errorThrows("sap/base/i18n/ResourceBundle: value for parameter 'aArgs' is not of type array")}if(n){e=s(e,n)}if(this.bIncludeInfo){e=new String(e);e.originInfo={source:"Resource Bundle",url:this.oUrlInfo.url,locale:this.sLocale,key:t}}}return e};g.prototype._getTextFromFallback=function(e,r){var t,n;for(n=this.aCustomBundles.length-1;n>=0;n--){t=this.aCustomBundles[n]._getTextFromFallback(e,r);if(t!=null){return t}}while(typeof t!=="string"&&this._aFallbackLocales.length){var a=m(this);if(a){t=a.getProperty(e);if(typeof t==="string"){return this._formatValue(t,e,r)}}}return null};g.prototype._getTextFromProperties=function(e,r){var t=null,n;for(n=this.aCustomBundles.length-1;n>=0;n--){t=this.aCustomBundles[n]._getTextFromProperties(e,r);if(t!=null){return t}}for(n=0;n<this.aPropertyFiles.length;n++){t=this.aPropertyFiles[n].getProperty(e);if(typeof t==="string"){return this._formatValue(t,e,r)}}return null};g.prototype.hasText=function(e){return this.aPropertyFiles.length>0&&typeof this.aPropertyFiles[0].getProperty(e)==="string"};g.prototype._recreate=function(){if(!this._mCreateFactoryParams){var e=new Error("ResourceBundle instance can't be recreated as it has not been created by the ResourceBundle.create factory.");if(this.bAsync){return Promise.reject(e)}else{throw e}}else{return g.create(this._mCreateFactoryParams)}};function b(e){if(e._aFallbackLocales.length){return _(e,true).then(function(r){return r||b(e)})}return Promise.resolve(null)}function m(e){while(e._aFallbackLocales.length){var r=_(e,false);if(r){return r}}return null}function _(e,r){var t=e._aFallbackLocales.shift();if(t!=null){var a=e.oUrlInfo,s,o;if(a.ext===".hdbtextbundle"){if(l[t]){s=a.prefix+a.suffix+"?"+(a.query?a.query+"&":"")+"sap-language="+l[t]+(a.hash?"#"+a.hash:"")}else{s=a.url}o={"Accept-Language":n.convertLocaleToBCP47(t)||"*"}}else{s=a.prefix+(t?"_"+t:"")+a.suffix}var i=JSON.stringify({url:new URL(s,document.baseURI).href,headers:o});var u={url:s,headers:o,async:!!r,returnNullIfMissing:true};const h=c.get(i,u,u.async);var f=function(r){if(r){e.aPropertyFiles.push(r);e.aPropertyOrigins.push(s);e.aLocales.push(t)}return r};return r?h.then(f):f(h)}return r?Promise.resolve(null):null}g._getUrl=function(e,r){var t=e;if(r){r=r.replace(/\./g,"/");t=sap.ui.require.toUrl(r)+".properties"}return t};function y(e,r,t,n,a,s,o){if(!r){return[]}var i=[];r.forEach(function(r){if(r.fallbackLocale===undefined){r.fallbackLocale=s}if(r.supportedLocales===undefined){r.supportedLocales=o}var l=g._getUrl(r.bundleUrl,r.bundleName);var u=new g(l,t,n,a,r.supportedLocales,r.fallbackLocale);i.push(u);if(r.terminologies){i=i.concat(v(e,r.terminologies,t,n,a))}});return i}function v(e,r,t,n,a){if(!e){return[]}e=e.filter(function(e){return r.hasOwnProperty(e)});e.reverse();return e.map(function(e){var s=r[e];var o=g._getUrl(s.bundleUrl,s.bundleName);var i=s.supportedLocales;return new g(o,t,n,a,i,null,true)})}g.create=function(e){var r=i({},e);e=i({url:"",includeInfo:false},e);if(e.bundleUrl||e.bundleName){e.url=e.url||g._getUrl(e.bundleUrl,e.bundleName)}e=g._enrichBundleConfig(e);var t=new g(e.url,e.locale,e.includeInfo,!!e.async,e.supportedLocales,e.fallbackLocale);if(t instanceof Promise){t=t.then(function(e){e._mCreateFactoryParams=r;return e})}else{t._mCreateFactoryParams=r}var n=[];if(e.terminologies){n=n.concat(v(e.activeTerminologies,e.terminologies,e.locale,e.includeInfo,!!e.async))}if(e.enhanceWith){n=n.concat(y(e.activeTerminologies,e.enhanceWith,e.locale,e.includeInfo,!!e.async,e.fallbackLocale,e.supportedLocales))}if(n.length){if(t instanceof Promise){t=t.then(function(e){return Promise.all(n).then(function(r){r.forEach(e._enhance,e)}).then(function(){return e})})}else{n.forEach(t._enhance,t)}}return t};g._enrichBundleConfig=function(e){return e};g._getFallbackLocales=n.getFallbackLocales;g._getPropertiesCache=function(){return c._oCache};return g});
//# sourceMappingURL=ResourceBundle.js.map