/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/core/InvisibleText","sap/f/CardRenderer","sap/ui/core/Lib","sap/f/cards/util/CardBadgeEnabler","sap/f/library","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/dom/jquery/Focusable"],function(e,t,i,s,r,n,a,o){"use strict";var d=3e3,h=n.cards.SemanticRole;var l=e.extend("sap.f.CardBase",{metadata:{library:"sap.f",interfaces:["sap.f.ICard","sap.m.IBadge","sap.f.IGridContainerItem"],properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"auto"},semanticRole:{type:"sap.f.cards.SemanticRole",defaultValue:h.Region}},aggregations:{_cardBadges:{type:"sap.m.ObjectStatus",multiple:true,visibility:"hidden"},_oInvisibleCardBadgeText:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},events:{press:{}}},renderer:i});r.call(l.prototype);l.prototype.init=function(){this._oRb=s.getResourceBundleFor("sap.f");this._ariaContentText=new t({id:this.getId()+"-ariaContentText"});this._ariaContentText.setText(this._oRb.getText("ARIA_LABEL_CARD_CONTENT"));this._ariaText=new t({id:this.getId()+"-ariaText"});this._ariaText.setText(this._oRb.getText("ARIA_ROLEDESCRIPTION_CARD"));this._describedByInteractiveText=new t({id:this.getId()+"-describedByInteractive"});this._describedByInteractiveText.setText(this._oRb.getText("ARIA_ACTIVATE_CARD"));this._describedByCardTypeText=new t({id:this.getId()+"-describedByCardTypeText"});this._describedByCardTypeText.setText(this._oRb.getText("ARIA_ROLEDESCRIPTION_CARD"));this._sGridItemRole=null;this.initCardBadgeEnablement()};l.prototype.exit=function(){this._oRb=null;if(this._ariaContentText){this._ariaContentText.destroy();this._ariaContentText=null}if(this._ariaText){this._ariaText.destroy();this._ariaText=null}this._describedByInteractiveText.destroy();this._describedByInteractiveText=null;this._describedByCardTypeText.destroy();this._describedByCardTypeText=null;if(this._invisibleTitle){this._invisibleTitle.destroy();this._invisibleTitle=null}this.destroyCardBadgeEnablement()};l.prototype.setAggregation=function(t,i){var s;if(t==="header"||t==="_header"){s=this.getAggregation(t);if(s){s.detachEvent("_change",this._onHeaderVisibilityChange,this)}if(i){i.attachEvent("_change",this._onHeaderVisibilityChange,this)}}return e.prototype.setAggregation.apply(this,arguments)};l.prototype._onHeaderVisibilityChange=function(e){if(e.getParameters().name==="visible"){setTimeout(function(){this.invalidate()}.bind(this),0)}};l.prototype.getCardHeader=function(){return null};l.prototype.getCardHeaderPosition=function(){return null};l.prototype.getCardContent=function(){return null};l.prototype.getFocusDomRef=function(){if(this.isRoleListItem()){return this.getDomRef()}return this.getCardHeader()?this.getCardHeader().getFocusDomRef():this.getDomRef()};l.prototype._getHeaderAggregation=function(){return this.getCardHeader()};l.prototype.onmousedown=function(){this._hideBadge()};l.prototype.onsapenter=function(){this._hideBadge()};l.prototype.onfocusin=function(e){if(e.target!==this.getDomRef()){this.oLastFocusedElement=e.target}this._startBadgeHiding()};l.prototype._startBadgeHiding=function(){if(this._iHideBadgeTimeout){return}this._iHideBadgeTimeout=setTimeout(this._hideBadge.bind(this),d)};l.prototype._hideBadge=function(){const e=this._getCardBadgeCustomData();if(e?.length>0){this._hideBadges()}this._iHideBadgeTimeout=null};l.prototype._getAriaLabelledIds=function(){var e=this.getCardHeader();const i=this._getBlockingMessageAriaLabelledByIds();if(e&&e.getVisible()){if(e._getTitle&&e._getTitle()){if(i){return e._getTitle().getId()+" "+i}return e._getTitle().getId()}}else if(e?.getTitle()){if(!this._invisibleTitle){this._invisibleTitle=new t({id:this.getId()+"-invisibleTitle"})}this._invisibleTitle.setText(e.getTitle());return this._invisibleTitle.getId()}return this._ariaText.getId()};l.prototype._getAriaDescribedByIds=function(){const e=this._getCardBadgeCustomData().length>0;const t=[];t.push(this._describedByCardTypeText.getId());if(this.isInteractive()&&this.isRoleListItem()){t.push(this._describedByInteractiveText.getId())}if(e){t.push(this._getInvisibleCardBadgeText().getId())}return t.join(" ")};l.prototype._getBlockingMessageAriaLabelledByIds=function(){if(!this.getCardContent()?.getAggregation("_blockingMessage")){return""}const e=this.getCardContent().getAggregation("_blockingMessage")._getIllustratedMessage();const t=e._getTitle().sId;const i=e._getDescription()?.sId;if(e._getDescription().getText()){return t+" "+i}return t};l.prototype.onkeydown=function(e){if(e.code==="F7"){this._handleF7Key(e);return}if(e.target===this.getDomRef()&&!e.ctrlKey&&!e.metaKey){if(e.which===o.ENTER){this._handleTap(e)}else if(e.which===o.SPACE){e.preventDefault()}else if(e.which===o.SHIFT||e.which===o.ESCAPE){this._bPressedEscapeOrShift=true}}};l.prototype.onkeyup=function(e){if(e.target===this.getDomRef()){if(e.which===o.SPACE&&!this._bPressedEscapeOrShift){this._handleTap(e)}else if(e.which===o.SHIFT||e.which===o.ESCAPE){this._bPressedEscapeOrShift=false}}};l.prototype.ontap=function(e){if(this.isMouseInteractionDisabled()){return}this._handleTap(e)};l.prototype._handleTap=function(e){if(!this.isInteractive()||e.isMarked()||!this.isRoleListItem()){return}if(this.getFocusDomRef()?.matches(":has(:focus-within)")){return}this.firePress({originalEvent:e});e.preventDefault();e.stopPropagation()};l.prototype._handleF7Key=function(e){if(!this.isInteractive()||!this.isRoleListItem()){return}const t=e.target;const i=this.$().firstFocusableDomRef();if(t!==this.getDomRef()){this.getDomRef().focus()}else if(this.oLastFocusedElement&&!i.classList.contains("sapMListUl")){this.oLastFocusedElement.focus()}else if(i){i.focus()}e.preventDefault();e.stopPropagation()};l.prototype.getAriaRoleDescription=function(){var e=this.getCardHeader();if(e){return e.getAriaRoleDescription()}return null};l.prototype.isInteractive=function(){const e=this.hasListeners("press");if(e&&!this.isRoleListItem()){a.error("The full card cannot be interactive if the 'semanticRole' is not 'ListItem' or the control is not placed inside a sap.f.GridContainer",this)}return e};l.prototype.isMouseInteractionDisabled=function(){return false};l.prototype.setGridItemRole=function(e){this._sGridItemRole=e};l.prototype.getGridItemRole=function(){return this._sGridItemRole};l.prototype.isRoleListItem=function(){return this.getSemanticRole()===h.ListItem||this.getGridItemRole()};return l});
//# sourceMappingURL=CardBase.js.map