/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/Device","sap/ui/core/Control","sap/ui/core/Lib","sap/ui/core/library","sap/ui/core/IconPool","sap/ui/core/theming/Parameters","sap/m/ToggleButton","sap/m/Button","./DynamicPageHeaderRenderer","sap/ui/core/InvisibleMessage"],function(t,e,n,o,i,s,a,r,u,p,l){"use strict";var g=i.InvisibleMessageMode;var _=n.extend("sap.f.DynamicPageHeader",{metadata:{library:"sap.f",properties:{pinnable:{type:"boolean",group:"Appearance",defaultValue:true},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true},_pinButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_collapseButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},designtime:"sap/f/designtime/DynamicPageHeader.designtime"},renderer:p});_._getResourceBundle=function(){return o.getResourceBundleFor("sap.f")};_.UNPRESSED_PIN_ICON="sap-icon://pushpin-off";_.ARIA={ARIA_CONTROLS:"aria-controls",ARIA_LABEL:"aria-label",LABEL_EXPANDED:_._getResourceBundle().getText("EXPANDED_HEADER"),LABEL_COLLAPSED:_._getResourceBundle().getText("SNAPPED_HEADER"),LABEL_PINNED:_._getResourceBundle().getText("PIN_HEADER"),TOOLTIP_COLLAPSE_BUTTON:_._getResourceBundle().getText("COLLAPSE_HEADER_BUTTON_TOOLTIP"),STATE_TRUE:"true",STATE_FALSE:"false"};_.prototype.init=function(){this._bShowCollapseButton=true;this._oInvisibleMessage=null;this._oLandmarkInfo=null};_.prototype.onAfterRendering=function(){this._initPinButtonARIAState();if(!this._oInvisibleMessage){this._oInvisibleMessage=l.getInstance()}if(this.getPinnable()){this._setPressedStatePinIcon()}this._applyAriaAttributes()};_.prototype._togglePinButton=function(t){this._getPinButton().setPressed(t);this._getPinButton().setIcon(t?this._sPressedStatePinIconURI:_.UNPRESSED_PIN_ICON)};_.prototype._setShowPinBtn=function(t){this._getPinButton().toggleStyleClass("sapUiHidden",!t)};_.prototype._pinUnpinFireEvent=function(t){this.fireEvent("_pinUnpinPress");this._togglePinButton(t.getSource().getPressed())};_.prototype._onCollapseButtonPress=function(){this.fireEvent("_headerVisualIndicatorPress")};_.prototype._onCollapseButtonMouseOver=function(){this.fireEvent("_visualIndicatorMouseOver")};_.prototype._onCollapseButtonMouseOut=function(){this.fireEvent("_visualIndicatorMouseOut")};_.prototype._applyAriaAttributes=function(){var t=this.$(),e=this._oLandmarkInfo&&this._oLandmarkInfo.getHeaderContentLabel();if(e){var n=this._oLandmarkInfo.getHeaderContentLabel();t.attr(_.ARIA.ARIA_LABEL,n)}else{t.attr(_.ARIA.ARIA_LABEL,_.ARIA.LABEL_EXPANDED)}};_.prototype._setLandmarkInfo=function(t){this._oLandmarkInfo=t;this._applyAriaAttributes()};_.prototype._initPinButtonARIAState=function(){var t;if(this.getPinnable()){t=this._getPinButtonJQueryRef();t.attr(_.ARIA.ARIA_CONTROLS,this.getId())}};_.prototype._updateARIAState=function(t){var e=this.$();if(t){e.attr(_.ARIA.ARIA_LABEL,_.ARIA.LABEL_EXPANDED)}else{e.attr(_.ARIA.ARIA_LABEL,_.ARIA.LABEL_COLLAPSED)}};_.prototype._getPinButton=function(){if(!this.getAggregation("_pinButton")){var t=new r({id:this.getId()+"-pinBtn",icon:_.UNPRESSED_PIN_ICON,tooltip:_.ARIA.LABEL_PINNED,press:this._pinUnpinFireEvent.bind(this)}).addStyleClass("sapFDynamicPageHeaderPinButton");this.setAggregation("_pinButton",t,true)}return this.getAggregation("_pinButton")};_.prototype._getCollapseButton=function(){if(!this.getAggregation("_collapseButton")){var t=new u({id:this.getId()+"-collapseBtn",icon:"sap-icon://slim-arrow-up",press:this._onCollapseButtonPress.bind(this),tooltip:_.ARIA.TOOLTIP_COLLAPSE_BUTTON}).addStyleClass("sapFDynamicPageToggleHeaderIndicator");t.onmouseover=this._onCollapseButtonMouseOver.bind(this);t.onmouseout=this._onCollapseButtonMouseOut.bind(this);this.setAggregation("_collapseButton",t,true)}return this.getAggregation("_collapseButton")};_.prototype._toggleCollapseButton=function(t){this._setShowCollapseButton(t);this._getCollapseButton().toggleStyleClass("sapUiHidden",!t)};_.prototype._getShowCollapseButton=function(){return this._bShowCollapseButton&&!!this.getContent().length};_.prototype._setShowCollapseButton=function(t){this._bShowCollapseButton=!!t};_.prototype._focusCollapseButton=function(){var t=_._getResourceBundle().getText("EXPANDED_HEADER");this._getCollapseButton().$().trigger("focus");this._oInvisibleMessage.announce(t,g.Polite)};_.prototype._focusPinButton=function(){this._getPinButtonJQueryRef().trigger("focus")};_.prototype._getPinButtonJQueryRef=function(){return this._getPinButton().$()};_.prototype._getState=function(){var t=this.getContent(),n=t.length>0,o=this.getPinnable()&&n&&!e.system.phone,i=this._getPinButton(),s=this._getCollapseButton();s.toggleStyleClass("sapUiHidden",!this._getShowCollapseButton());return{content:t,headerHasContent:n,headerPinnable:o,hasContent:t.length>0,pinButton:i,collapseButton:s}};_.prototype.onThemeChanged=function(){var t=this._getPinButton();this._setPressedStatePinIcon();t.setIcon(t.getPressed()?this._sPressedStatePinIconURI:_.UNPRESSED_PIN_ICON)};_.prototype._setPressedStatePinIcon=function(){this._sPressedStatePinIconURI=s.getIconURI(a.get({name:"_sap_f_DynamicPageHeader_PinButton_Icon"}))};return _});
//# sourceMappingURL=DynamicPageHeader.js.map