/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Localization","sap/ui/core/ControlBehavior","sap/ui/core/Lib","sap/ui/core/RenderManager","sap/ui/thirdparty/jquery","./library","sap/ui/core/library","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/core/Control","sap/ui/util/Storage","sap/m/library","sap/m/NavContainer","sap/ui/core/Configuration","sap/ui/dom/units/Rem","./FlexibleColumnLayoutRenderer","sap/base/Log","sap/base/assert","sap/base/util/isEmptyObject","sap/base/util/merge","sap/ui/core/InvisibleMessage","sap/ui/dom/jquery/Focusable"],function(e,t,o,n,jQuery,i,s,r,a,u,l,d,h,m,p,g,C,c,f,_,y){"use strict";var v=i.LayoutType;var M=s.InvisibleMessageMode;var E=u.extend("sap.f.FlexibleColumnLayout",{metadata:{interfaces:["sap.ui.core.IPlaceholderSupport"],properties:{autoFocus:{type:"boolean",group:"Behavior",defaultValue:true},layout:{type:"sap.f.LayoutType",defaultValue:v.OneColumn},defaultTransitionNameBeginColumn:{type:"string",group:"Appearance",defaultValue:"slide"},defaultTransitionNameMidColumn:{type:"string",group:"Appearance",defaultValue:"slide"},defaultTransitionNameEndColumn:{type:"string",group:"Appearance",defaultValue:"slide"},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:d.BackgroundDesign.Transparent},restoreFocusOnBackNavigation:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{beginColumnPages:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getBeginColumn",aggregation:"pages"}},midColumnPages:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getMidColumn",aggregation:"pages"}},endColumnPages:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getEndColumn",aggregation:"pages"}},landmarkInfo:{type:"sap.f.FlexibleColumnLayoutAccessibleLandmarkInfo",multiple:false},_beginColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_midColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_endColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"}},associations:{initialBeginColumnPage:{type:"sap.ui.core.Control",multiple:false},initialMidColumnPage:{type:"sap.ui.core.Control",multiple:false},initialEndColumnPage:{type:"sap.ui.core.Control",multiple:false}},events:{stateChange:{parameters:{layout:{type:"sap.f.LayoutType"},maxColumnsCount:{type:"int"},isNavigationArrow:{type:"boolean"},isResize:{type:"boolean"}}},beginColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterBeginColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},midColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterMidColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},endColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterEndColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},columnResize:{parameters:{beginColumn:{type:"boolean"},midColumn:{type:"boolean"},endColumn:{type:"boolean"}}},columnsDistributionChange:{parameters:{media:{type:"string"},layout:{type:"string"},columnsSizes:{type:"string"}}}}},renderer:g});E.DEFAULT_COLUMN_LABELS={FirstColumn:"FCL_BEGIN_COLUMN_REGION_TEXT",MiddleColumn:"FCL_MID_COLUMN_REGION_TEXT",LastColumn:"FCL_END_COLUMN_REGION_TEXT"};E.COLUMN_RESIZING_ANIMATION_DURATION=560;E.PINNED_COLUMN_CLASS_NAME="sapFFCLPinnedColumn";E.ANIMATED_COLUMN_CLASS_NAME="sapFFCLAnimatedColumn";E.COLUMN_ORDER=["begin","mid","end"];E.COLUMN_SEPARATOR_WIDTH=p.toPx("1rem");E.prototype.init=function(){this._iWidth=0;this._oColumnFocusInfo={begin:{},mid:{},end:{}};this._initNavContainers();this._oLayoutHistory=new b;this._oAnimationEndListener=new L;this._oRenderedColumnPagesBoolMap={};this._oColumnWidthInfo={begin:0,mid:0,end:0};this._keyListeners={increase:this._resizeColumnOnKeypress.bind(this,"inc",1),decrease:this._resizeColumnOnKeypress.bind(this,"dec",1),increaseMore:this._resizeColumnOnKeypress.bind(this,"incMore",2),decreaseMore:this._resizeColumnOnKeypress.bind(this,"decMore",2),max:this._resizeColumnOnKeypress.bind(this,"max",1),min:this._resizeColumnOnKeypress.bind(this,"min",1)};this._enableKeyboardListeners();this._oInvisibleMessage=null;this._boundColumnSeparatorMove=this._onColumnSeparatorMove.bind(this);this._boundColumnSeparatorMoveEnd=this._onColumnSeparatorMoveEnd.bind(this);this._oLocalStorage={};this._bNeverRendered=true;this._oBeginColumnWidth={tablet:0,desktop:0}};E.prototype._announceMessage=function(e){var t=E._getResourceBundle().getText(e);if(this._oInvisibleMessage){this._oInvisibleMessage.announce(t,M.Polite)}};E.prototype._enableKeyboardListeners=function(){this.onsaprightmodifiers=this._keyListeners.increase;this.onsapleftmodifiers=this._keyListeners.decrease;this.onsapright=this._keyListeners.increaseMore;this.onsapleft=this._keyListeners.decreaseMore;this.onsapend=this._keyListeners.max;this.onsaphome=this._keyListeners.min;this._keyboardEnabled=true};E.prototype._onNavContainerRendered=function(e){var t=e.srcControl,o=t.getPages().length>0,n=this._hasAnyColumnPagesRendered();this._setColumnPagesRendered(t.getId(),o);if(this._hasAnyColumnPagesRendered()!==n){this._hideShowColumnSeparators();this._updateSeparatorsAriaPositionInfo()}};E.prototype._createNavContainer=function(e){var t=e.charAt(0).toUpperCase()+e.slice(1);var o=new h(this.getId()+"-"+e+"ColumnNav",{autoFocus:this.getAutoFocus(),navigate:function(t){this._handleNavigationEvent(t,false,e)}.bind(this),afterNavigate:function(t){this._handleNavigationEvent(t,true,e)}.bind(this),defaultTransitionName:this["getDefaultTransitionName"+t+"Column"]()});o.addDelegate({onAfterRendering:this._onNavContainerRendered},this);this["_"+e+"ColumnFocusOutDelegate"]={onfocusout:function(t){this._oColumnFocusInfo[e]=t.target}};o.addEventDelegate(this["_"+e+"ColumnFocusOutDelegate"],this);return o};E.prototype.setLandmarkInfo=function(e){this.setAggregation("landmarkInfo",e);e?.attachEvent("_changeColumnsLabel",this._onColumnsLabelChanged,this);return this};E.prototype.destroyLandmarkInfo=function(){var e=this.getLandmarkInfo();e?.detachEvent("_changeColumnsLabel",this._onColumnsLabelChanged,this);return this.destroyAggregation("landmarkInfo")};E.prototype._formatColumnLandmarkInfo=function(e,t){var o=null;if(e){o=e["get"+t+"Label"]()}return{role:"region",label:o||E._getResourceBundle().getText(E.DEFAULT_COLUMN_LABELS[t])}};E.prototype._onColumnsLabelChanged=function(e){var t=e.getParameter("column"),o=e.getParameter("label"),n=this._$columns?.[t];n?.length&&n.attr("aria-label",o)};E.prototype._handleNavigationEvent=function(e,t,o){var n,i;if(t){n="after"+(o.charAt(0).toUpperCase()+o.slice(1))+"ColumnNavigate"}else{n=o+"ColumnNavigate"}i=this.fireEvent(n,e.mParameters,true);if(!i){e.preventDefault()}};E.prototype._getColumnByStringName=function(e){if(e==="end"){return this._getEndColumn()}else if(e==="mid"){return this._getMidColumn()}else{return this._getBeginColumn()}};E.prototype._getBeginColumn=function(){return this.getAggregation("_beginColumnNav")};E.prototype._getMidColumn=function(){return this.getAggregation("_midColumnNav")};E.prototype._getEndColumn=function(){return this.getAggregation("_endColumnNav")};E.prototype._flushColumnContent=function(e){var t=this.getAggregation("_"+e+"ColumnNav"),o=(new n).getInterface();o.renderControl(t);o.flush(this._$columns[e].find(".sapFFCLColumnContent")[0],undefined,true);o.destroy()};E.prototype.setLayout=function(e){e=this.validateProperty("layout",e);var t=this.getLayout();if(t===e){return this}var o=this.setProperty("layout",e,true);this._oLayoutHistory.addEntry(e);this._resizeColumns();return o};E.prototype.setAutoFocus=function(e){e=this.validateProperty("autoFocus",e);var t=this.getAutoFocus();if(t===e){return this}this._getNavContainers().forEach(function(t){t.setAutoFocus(e)});return this.setProperty("autoFocus",e,true)};E.prototype.onBeforeRendering=function(){var e=this._$columns;if(!this._oInvisibleMessage){this._oInvisibleMessage=y.getInstance()}this._deregisterResizeHandler();this._oAnimationEndListener.cancelAll();if(this.$().length){E.COLUMN_ORDER.slice().forEach(function(t){e&&e[t]&&e[t].removeClass(E.ANIMATED_COLUMN_CLASS_NAME)})}};E.prototype.onAfterRendering=function(){this._measureControlWidth();this._registerResizeHandler();this._cacheDOMElements();this._resizeColumns();this._flushColumnContent("begin");this._flushColumnContent("mid");this._flushColumnContent("end");this._fireStateChange(false,false);this._bNeverRendered=false};E.prototype.setLayoutData=function(e){if(e.isA("sap.f.FlexibleColumnLayoutData")){e.attachEvent("_layoutDataPropertyChanged",this._layoutDataPropertyChanged,this)}return this.setAggregation("layoutData",e)};E.prototype.destroyLayoutData=function(e){if(e.isA("sap.f.FlexibleColumnLayoutData")){e.dettachEvent("_layoutDataPropertyChanged",this._layoutDataPropertyChanged,this)}return this.destroyAggregation("layoutData",e)};E.prototype._layoutDataPropertyChanged=function(e){var t=e.getParameter("srcControl"),o=this.getLayoutData(),n=this._getMediaKey(),i=e.getParameter("newValue"),s,r;if(e.getParameter("layout")===this.getLayout()&&(t===o?.getDesktopLayoutData()&&n==="desktop"||t===o?.getTabletLayoutData()&&n==="tablet")){if(this._oMoveInfo){s=this._convertColumnPxWidthToPercent(this._oMoveInfo.columnWidths,this.getLayout());r=Object.values(s).join("/")}if(!i||r===e.getParameter("newValue")){return}this._resizeColumns({hasAnimations:false})}};E.prototype.onLayoutDataChange=function(e){var t=e.srcControl;if(t.isA("sap.f.FlexibleColumnLayoutData")){this.invalidate()}};E.prototype.onmousedown=function(e){if(this._ignoreMouse){return}var t=this._getColumnSeparator(e.target);if(!t){return}this._ignoreTouch=true;this._onColumnSeparatorMoveStart(e,t)};E.prototype.ontouchstart=function(e){if(this._ignoreTouch){return}var t=this._getColumnSeparator(e.target);if(!t){return}if(!e.changedTouches||!e.changedTouches[0]){return}this._ignoreMouse=true;this._onColumnSeparatorMoveStart(e.changedTouches[0],t,true)};E.prototype._restoreFocusToColumn=function(e){var t=this._oColumnFocusInfo[e],o=this._getColumnByStringName(e);if(this._isFocusInCurrentColumn(o)){return}if(!t||f(t)){t=this._getFirstFocusableElement(e)}jQuery(t).trigger("focus")};E.prototype._getFirstFocusableElement=function(e){var t=this._getColumnByStringName(e),o=t.getCurrentPage();if(o){return o.$().firstFocusableDomRef()}return null};E.prototype._isFocusInSomeOfThePreviousColumns=function(e){var t=this._getLastVisibleColumnForLayout(e),o=E.COLUMN_ORDER.indexOf(t)-1,n;for(;o>=0;o--){n=this._getColumnByStringName(E.COLUMN_ORDER[o]);if(n&&n._isFocusInControl(n)){return true}}return false};E.prototype._isFocusInCurrentColumn=function(e){return e._isFocusInControl(e)};E.prototype._getControlWidth=function(){if(this._iWidth===0){this._measureControlWidth()}return this._iWidth};E.prototype._measureControlWidth=function(){if(this.$().is(":visible")){this._iWidth=this.$().width()}else{this._iWidth=0}};E.prototype.exit=function(){this._removeNavContainersFocusOutDelegate();this._oRenderedColumnPagesBoolMap=null;this._oColumnFocusInfo=null;this._oLocalStorage=null;this._deregisterResizeHandler();this._handleEvent(jQuery.Event("Destroy"));this._detachMoveListeners()};E.prototype._removeNavContainersFocusOutDelegate=function(){E.COLUMN_ORDER.forEach(function(e){this._getColumnByStringName(e).removeEventDelegate(this["_"+e+"ColumnFocusOutDelegate"])},this)};E.prototype._registerResizeHandler=function(){c(!this._iResizeHandlerId,"Resize handler already registered");this._iResizeHandlerId=a.register(this,this._onResize.bind(this))};E.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){a.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null}};E.prototype._initNavContainers=function(){this.setAggregation("_beginColumnNav",this._createNavContainer("begin"),true);this.setAggregation("_midColumnNav",this._createNavContainer("mid"),true);this.setAggregation("_endColumnNav",this._createNavContainer("end"),true)};E.prototype._getNavContainers=function(){return[this._getBeginColumn(),this._getMidColumn(),this._getEndColumn()]};E.prototype._cacheDOMElements=function(){this._cacheColumns();if(!r.system.phone){this._cacheColumnSeparators();this._$overlay=this.$("overlay");this._$overlaySeparator=this.$("overlaySeparator")}};E.prototype._cacheColumns=function(){this._$columns={begin:this.$("beginColumn"),mid:this.$("midColumn"),end:this.$("endColumn")}};E.prototype._cacheColumnSeparators=function(){this._oColumnSeparators={begin:this.$("separator-begin"),end:this.$("separator-end")}};E.prototype._getVisibleColumnsCount=function(e){return this._getVisibleColumnsForLayout(e).length};E.prototype._getVisibleColumnsForLayout=function(e){return E.COLUMN_ORDER.filter(function(t){return this._getColumnSizeForLayout(t,e)!==0},this)};E.prototype._getVisibleColumnSeparatorsCount=function(){if(!this._oColumnSeparators){return 0}return Object.keys(this._oColumnSeparators).filter(function(e){return this._oColumnSeparators[e].data("visible")},this).length};E.prototype._getTotalColumnsWidth=function(e){var t=this._getRequiredColumnSeparatorsForLayout(e).length;return this._getControlWidth()-t*E.COLUMN_SEPARATOR_WIDTH};E.prototype._resizeColumns=function(e){var t=E.COLUMN_ORDER.slice(),o,n,i,s,r,a,u,l,d;if(!this.isActive()){return}e=_(this._getDefaultResizeOptions(),e);n=e.layout;s=this._getVisibleColumnsCount(n);if(s===0){return}o=e.hasAnimations;i=e.previousLayout;u=s===3&&n===v.ThreeColumnsEndExpanded;r=e.columnWidths||this._getAllColumnSizesForLayout(n,true);a=this._getLastVisibleColumnForLayout(n);l=e.restoreFocusOnBackNavigation&&i&&this._isNavigatingBackward(n,i)&&!this._isFocusInSomeOfThePreviousColumns(i);d=o&&i?this._getAnimationEndStatusForColumns():{};if(o&&i){this._pinColumnsBeforeResize(n,i,r);this._oAnimationEndListener.cancelAll()}t.slice().forEach(function(e){this._$columns[e].removeClass(E.ANIMATED_COLUMN_CLASS_NAME)}.bind(this));this._hideShowColumnSeparators();t.forEach(function(t){var s=r[t],h=o&&this._shouldRevealColumn(t,n,i),m=o&&this._shouldConcealColumn(t,n,i);this._resizeColumn(t,{width:s,shouldRestoreFocus:l&&t===a,shouldInsetColumn:u&&t==="mid",shouldRevealColumn:h,shouldConcealColumn:m,hidden:s===0&&this._oColumnWidthInfo[t]===0,autoSize:s>0&&t==="mid",hasAnimations:o,previousAnimationCompleted:!d[this._$columns[t]],updateContextualSettings:e.updateContextualSettings,updateMediaCSSClases:e.updateMediaCSSClases})},this);if(e.updateDetailedActiveClasses){this._addDetailedActiveClasses(n)}if(o){this._attachAfterAllColumnsResizedOnce(this._updateSeparatorsAriaPositionInfo.bind(this))}else{this._updateSeparatorsAriaPositionInfo()}};E.prototype._resizeColumn=function(e,t){var o=this._$columns[e],n=o.get(0),i=t.width,s=T(i,this._getControlWidth(),t.shouldInsetColumn),u=t.autoSize,l=t.hasAnimations,d=!i,h=this._canResizeColumnWithAnimation(e,t),m=l,p=this._afterColumnResize.bind(this,e,_(t,{resumeResizeHandler:m&&!d})),g=function(){a.resume(n);n.querySelector(".sapFFCLColumnContent").style.width=""};if(u){s=""}o.toggleClass("sapFFCLColumnActive",i>0||t.shouldConcealColumn);o.toggleClass("sapFFCLColumnInset",t.shouldInsetColumn);o.removeClass("sapFFCLColumnHidden sapFFCLColumnOnlyActive sapFFCLColumnLastActive sapFFCLColumnFirstActive");if(m){a.suspend(n)}if(h){o.addClass(E.ANIMATED_COLUMN_CLASS_NAME);o.width(s);this._attachAfterColumnResizedOnce(e,p,g)}else if(u&&l){o.width(s);this._attachAfterAllColumnsResizedOnce(p,g)}else{o.width(s);p()}if(t.updateContextualSettings&&!r.system.phone&&i){this._updateColumnContextualSettings(e,i)}if(t.updateMediaCSSClases&&!r.system.phone&&i){this._updateColumnCSSClasses(e,i)}};E.prototype._afterColumnResize=function(e,t){var o=this._$columns[e],n=t.shouldRevealColumn,i=t.shouldConcealColumn,s=t.width,r=t.shouldRestoreFocus;o.toggleClass("sapFFCLColumnHidden",s===0);if(n||i||t.autoSize){o[0].querySelector(".sapFFCLColumnContent").style.width=""}o.toggleClass(E.PINNED_COLUMN_CLASS_NAME,false);o.toggleClass(E.ANIMATED_COLUMN_CLASS_NAME,false);if(i){o.removeClass("sapFFCLColumnActive")}if(t.resumeResizeHandler){a.resume(o[0])}this._cacheColumnWidth(e,s);if(r){this._restoreFocusToColumn(e)}};E.prototype._pinColumnsBeforeResize=function(e,t,o){E.COLUMN_ORDER.slice().forEach(function(n){var i=this._shouldConcealColumn(n,e,t),s=this._shouldRevealColumn(n,e,t),r=i||s,a=this._$columns[n],u=a[0];if(s){u.querySelector(".sapFFCLColumnContent").style.width=o[n]+"px"}else if(i){u.querySelector(".sapFFCLColumnContent").style.width=u.offsetWidth+"px"}a.toggleClass(E.PINNED_COLUMN_CLASS_NAME,r)},this)};E.prototype._getAnimationEndStatusForColumns=function(){var e={};E.COLUMN_ORDER.slice().forEach(function(t){e[t]=this._oAnimationEndListener.isWaitingForColumnResizeEnd(this._$columns[t])},this);return e};E.prototype._getAllColumnSizesForLayout=function(e,t){var o={};E.COLUMN_ORDER.slice().forEach(function(t){var n=this._getColumnSizeForLayout(t,e),i=this._convertColumnPercentWidthToPx(n,e);o[t]=i},this);if(t){this._normalizeColumnWidths(o,this._getVisibleColumnsForLayout(e))}return o};E.prototype._getDefaultResizeOptions=function(){var e=t.getAnimationMode();return{layout:this.getLayout(),previousLayout:this._getPreviousLayout(),restoreFocusOnBackNavigation:this.getRestoreFocusOnBackNavigation(),updateDetailedActiveClasses:true,updateContextualSettings:true,updateMediaCSSClases:true,hasAnimations:e!==m.AnimationMode.none&&e!==m.AnimationMode.minimal}};E.prototype._getPreviousLayout=function(){return this._getLayoutHistory().getEntry(1,true)||v.OneColumn};E.prototype._addDetailedActiveClasses=function(t){var o=E.COLUMN_ORDER.slice(),n=e.getRTL(),i=o.filter(function(e){return this._getColumnSizeForLayout(e,t)>0},this);if(n){o.reverse()}if(i.length===1){this._$columns[i[0]].addClass("sapFFCLColumnOnlyActive")}if(i.length>1){this._$columns[i[0]].addClass("sapFFCLColumnFirstActive");this._$columns[i[i.length-1]].addClass("sapFFCLColumnLastActive")}};E.prototype._resizeColumnOnKeypress=function(e,t,o){var n=this._getColumnSeparator(o.target),i,s;if(!n){return}var r=this._getControlWidth();var a=0;switch(e){case"inc":a=t;break;case"incMore":a=t*10;break;case"dec":a=0-t;break;case"decMore":a=0-t*10;break;case"max":a=r;break;case"min":a=0-r;break;default:C.warn("[FlexibleColumnLayout] Invalid keyboard resize type");break}i=n&&n.getBoundingClientRect().x;s=i+a;this._onColumnSeparatorMoveStart({pageX:i},n);this._onColumnSeparatorMove({pageX:s});this._onColumnSeparatorMoveEnd({pageX:s})};E.prototype._onColumnSeparatorMoveStart=function(t,o,n){var i=e.getRTL(),s=this._getDraggedSeparatorStartOffset(o,i);this._oMoveInfo={cursorStartX:t.pageX,cursorX:t.pageX,columnWidths:{begin:this._$columns.begin.get(0).offsetWidth,mid:this._$columns.mid.get(0).offsetWidth,end:this._$columns.end.get(0).offsetWidth},separator:o,separatorPosition:{x:s,direction:i?"right":"left"},layout:this.getLayout(),rtl:i};this._enterInteractiveResizeMode(n)};E.prototype._getDraggedSeparatorStartOffset=function(e,t){if(t){return this.getDomRef().clientWidth-e.offsetLeft-e.offsetWidth}return e.offsetLeft};E.prototype._onColumnSeparatorMove=function(e){if(e.preventDefault&&!e.changedTouches){e.preventDefault()}var t=F(e);this._previewResizedColumnsOnMoveSeparator(t)};E.prototype._onColumnSeparatorMoveEnd=function(e){var t=F(e);this._previewResizedColumnsOnMoveSeparator(t,true);this._saveResizedColumWidths();if(this._oMoveInfo.layout==this.getLayout()){this._exitInteractiveResizeMode();return}this.setLayout(this._oMoveInfo.layout);try{this._fireStateChange(true,false)}finally{this._exitInteractiveResizeMode()}};E.prototype._getColumnSeparator=function(e){var t=e,o=this.getId();if(t.classList.contains("sapFFCLColumnSeparatorGripIcon")){t=e.parentElement}if(t.classList.contains("sapFFCLColumnSeparatorDecorationBefore")||t.classList.contains("sapFFCLColumnSeparatorDecorationAfter")||t.classList.contains("sapFFCLColumnSeparatorGrip")){t=t.parentElement}if(!t.id||t.id.indexOf(o+"-separator")!==0){return null}return t};E.prototype._enterInteractiveResizeMode=function(e){var t=this._oMoveInfo.separatorPosition;this.toggleStyleClass("sapFFLActiveResize",true);this._$overlaySeparator.css(t.direction,t.x);this._oMoveInfo.separator.style.visibility="hidden";this._attachMoveListeners(e)};E.prototype._exitInteractiveResizeMode=function(){this.toggleStyleClass("sapFFLActiveResize",false);this._oMoveInfo.separator.style.visibility="";this._oMoveInfo.separator.focus();this._updateAriaPositionInfo(this._oMoveInfo.separator);this._ignoreMouse=false;this._ignoreTouch=false;this._oMoveInfo=null;this._detachMoveListeners()};E.prototype._attachMoveListeners=function(e){if(e){document.addEventListener("touchend",this._boundColumnSeparatorMoveEnd);document.addEventListener("touchmove",this._boundColumnSeparatorMove)}else{document.addEventListener("mouseup",this._boundColumnSeparatorMoveEnd);document.addEventListener("mousemove",this._boundColumnSeparatorMove)}};E.prototype._detachMoveListeners=function(){document.removeEventListener("mouseup",this._boundColumnSeparatorMoveEnd);document.removeEventListener("mousemove",this._boundColumnSeparatorMove);document.removeEventListener("touchend",this._boundColumnSeparatorMoveEnd);document.removeEventListener("touchmove",this._boundColumnSeparatorMove)};E.prototype._previewResizedColumnsOnMoveSeparator=function(e,t){var o=function(t){var o=e-t;return this._oMoveInfo.rtl?-o:o}.bind(this);this._oMoveInfo.offsetFromPreviousPosition=o(this._oMoveInfo.cursorX);this._oMoveInfo.offsetFromStartPosition=o(this._oMoveInfo.cursorStartX);this._oMoveInfo.cursorX=e;if(!this._oMoveInfo.offsetFromStartPosition){return}if(!this._oMoveInfo.offsetFromPreviousPosition&&!t){return}var n=S(this._oMoveInfo.separator,this._oMoveInfo.layout,this.getMaxColumnsCount()),i=P(this._oMoveInfo.separator),s=this._oMoveInfo.offsetFromStartPosition>0,r=n[s?0:1],a=n.find(e=>this._oMoveInfo.columnWidths[e]===0),u=this._getVisibleColumnSeparatorsCount(),l=0,d=0,h,m=this._oMoveInfo.layout,p,g,C,c;if(a&&a!==r){return}this._oMoveInfo.columnWidths[n[0]]+=this._oMoveInfo.offsetFromPreviousPosition;this._oMoveInfo.columnWidths[n[1]]-=this._oMoveInfo.offsetFromPreviousPosition;this._oMoveInfo.columnEnlargedByDragging=r;C=_({},this._oMoveInfo.columnWidths);this._normalizeColumnWidths(C,n);h=this._oMoveInfo.columnWidths[n[1]]-C[n[1]];this._offsetDraggedColumnSeparator(this._oMoveInfo.offsetFromPreviousPosition+h);this._toggleColumnVisibility(r,true);p=this._getNextLayoutOnResizeByDrag(C,m,i,s,t);g=p!==m;if(g){this._hideShowColumnSeparators(p);l=u-this._getRequiredColumnSeparatorsForLayout(p).length;if(l){d=E.COLUMN_SEPARATOR_WIDTH*l;C.mid+=d}c=E.COLUMN_ORDER.some(function(e){return this._shouldRevealColumn(e,p,m)||this._shouldConcealColumn(e,p,m)},this);C=this._mergeColumnWidthsOnInteractiveLayoutChange({oldWidths:this._getAllColumnSizesForLayout(p,true),newWidths:{[n[0]]:C[n[0]],[n[1]]:C[n[1]]},layout:p,columnEnlargedByDragging:r});this._oMoveInfo.layout=p;this._oMoveInfo.cursorStartX=e}this._oMoveInfo.columnWidths=C;if(c||t){this._resizeColumns({columnWidths:C,layout:p,previousLayout:m,updateMediaCSSClases:t,updateDetailedActiveClasses:t,restoreFocusOnBackNavigation:false})}else{this._$columns.begin.css("width",this._oMoveInfo.columnWidths.begin+"px");this._$columns.end.css("width",this._oMoveInfo.columnWidths.end+"px");n.forEach(function(e){this._updateColumnContextualSettings(e,this._oMoveInfo.columnWidths[e])},this)}if(g){this.fireEvent("_liveStateChange",{layout:p,maxColumnsCount:this.getMaxColumnsCount()})}};E.prototype._mergeColumnWidthsOnInteractiveLayoutChange=function(e){var t=e.oldWidths,o=e.newWidths,n=e.layout,i=e.columnEnlargedByDragging,s=Object.keys(o),r=this._getTotalColumnsWidth(n),a=function(e){return o[e]>=E.COLUMN_MIN_WIDTH},u=function(e){e.mid=r-e.begin-e.end;return e},l;if(s.indexOf("mid")>-1){l=s.find(e=>e!=="mid")}else{l=i}if(!a(l)){return t}return u(_(t,{[l]:o[l]}))};E.prototype._offsetDraggedColumnSeparator=function(e){this._oMoveInfo.separatorPosition.x+=e;this._$overlaySeparator.css(this._oMoveInfo.separatorPosition.direction,this._oMoveInfo.separatorPosition.x)};E.prototype._toggleColumnVisibility=function(e,t){this._$columns[e].toggleClass("sapFFCLColumnHidden",!t);this._$columns[e].toggleClass("sapFFCLColumnActive",t)};E.prototype._normalizeColumnWidths=function(e,t){var o=t.length;if(o<2){return}var n=function(t){if(this._isColumnAllowedToHaveBelowMinWidth(t)){return}var o=e[t]-E.COLUMN_MIN_WIDTH,n,s;if(o<0){e[t]=E.COLUMN_MIN_WIDTH;n=i(t);s=e[n];e[n]=s-Math.abs(o)}}.bind(this);function i(n){if(o===2){return t.find(function(e){return e!==n})}if(["begin","end"].indexOf(n)>-1){return"mid"}return e.begin>e.end?"begin":"end"}t.forEach(n)};E.prototype._isColumnAllowedToHaveBelowMinWidth=function(e){if(!this._oMoveInfo){return false}if(e===this._oMoveInfo.columnEnlargedByDragging){return true}return!this._isColumnAdjacentToDraggedSeparator(e)};E.prototype._convertColumnPercentWidthToPx=function(e,t){if(!e){return 0}var o=this._getTotalColumnsWidth(t);return Math.round(o*e/100)};E.prototype._convertColumnPxWidthToPercent=function(e,t){if(!e){return 0}var o=this._getTotalColumnsWidth(t),n=function(e){return e/o*100};if(typeof e==="number"){return n(e)}if(typeof e==="object"){var i=Object.assign({},e);Object.keys(i).forEach(function(e){var t=i[e];if(t){i[e]=n(t)}},this);return i}return null};E.prototype._isValidWidthDistributionForLayout=function(e,t){var o=e.split("/").map(e=>parseFloat(e)),n=o.reduce(function(e,t){return parseFloat(e)+t}),i;if(Math.round(n)!==100){return false}i=o.map(function(e){return this._convertColumnPercentWidthToPx(e,t)},this);if(i.some(function(e){return e>0&&e<E.COLUMN_MIN_WIDTH})){return false}return this._verifyColumnWidthsMatchLayout({begin:i[0],mid:i[1],end:i[2]},t)};E.prototype._saveResizedColumWidths=function(){var e=this._oMoveInfo.layout,t=this._convertColumnPxWidthToPercent(this._oMoveInfo.columnWidths,e),o=Object.values(t).join("/"),n;if(this._isValidWidthDistributionForLayout(o,e)){n=this._getMediaKey();this.fireColumnsDistributionChange({media:n,layout:e,columnsSizes:o});this._oBeginColumnWidth[n]=t.begin}};E.prototype._getMediaKey=function(e){var t;if(!e){e=this.getMaxColumnsCount()}t=e===3?"desktop":"tablet";return t};E.prototype._getNextLayoutOnResizeByDrag=function(e,t,o,n,i){function s(e){return e.from===t&&e.separator===o&&e.forward===n}var r=e.begin,a=Math.ceil(this._convertColumnPxWidthToPercent(r,t)),u=this.getMaxColumnsCount(),l=u===2;if(s({from:v.TwoColumnsMidExpanded,separator:"begin",forward:true})&&e.begin>=e.mid){return v.TwoColumnsBeginExpanded}if(s({from:v.TwoColumnsBeginExpanded,separator:"begin",forward:false})&&e.begin<e.mid){return v.TwoColumnsMidExpanded}if(s({from:v.ThreeColumnsMidExpanded,separator:"begin",forward:true})&&a>=33){return v.ThreeColumnsMidExpandedEndHidden}if(s({from:v.ThreeColumnsMidExpandedEndHidden,separator:"begin",forward:false})&&a<33){return v.ThreeColumnsMidExpanded}if(s({from:v.ThreeColumnsMidExpandedEndHidden,separator:"end",forward:false})&&(e.end>=E.COLUMN_MIN_WIDTH||i)){return v.ThreeColumnsMidExpanded}if(s({from:v.ThreeColumnsMidExpanded,separator:"end",forward:false})&&e.mid<e.end){return v.ThreeColumnsEndExpanded}if(s({from:v.ThreeColumnsEndExpanded,separator:"end",forward:true})&&e.mid>=e.end){return v.ThreeColumnsMidExpanded}if(s({from:v.ThreeColumnsMidExpandedEndHidden,separator:"begin",forward:true})&&e.begin>=e.mid){return v.ThreeColumnsBeginExpandedEndHidden}if(s({from:v.ThreeColumnsBeginExpandedEndHidden,separator:"begin",forward:false})&&e.begin<e.mid){return v.ThreeColumnsMidExpandedEndHidden}if(s({from:v.ThreeColumnsMidExpanded,separator:"begin",forward:true})&&l&&(r>=E.COLUMN_MIN_WIDTH||i)){return v.ThreeColumnsMidExpandedEndHidden}if(s({from:v.TwoColumnsMidExpandedEndHidden,separator:"end",forward:false})&&l&&(e.end>=E.COLUMN_MIN_WIDTH||i)){return v.ThreeColumnsMidExpanded}return t};E.prototype._verifyColumnWidthsMatchLayout=function(e,t){var o=this.getMaxColumnsCount(),n=e.begin,i=Math.ceil(this._convertColumnPxWidthToPercent(n,t)),s={[v.TwoColumnsBeginExpanded]:function(){return e.begin>=e.mid},[v.TwoColumnsMidExpanded]:function(){return e.mid>e.begin},[v.ThreeColumnsEndExpanded]:function(){return e.end>e.mid&&i<33},[v.ThreeColumnsBeginExpandedEndHidden]:function(){return e.begin>=e.mid&&e.end===0},[v.ThreeColumnsMidExpanded]:function(){return e.mid>=e.end&&(o===3&&i<33||o===2&&i===0)},[v.ThreeColumnsMidExpandedEndHidden]:function(){return e.mid>e.begin&&e.end===0&&(o===3&&i>=33||o===2&&n>=E.COLUMN_MIN_WIDTH)}};return s[t]()};E.prototype._getSeparatorMovementRange=function(e){var t=P(e),o=this.getLayout(),n=this.getMaxColumnsCount(),i=this._getMaxColumnsCountForLayout(o,E.DESKTOP_BREAKPOINT),s=n===3,r=n===2,a=i===3,u=this._iWidth,l=E.COLUMN_MIN_WIDTH,d=E.COLUMN_MIN_WIDTH,h;if(s&&t==="end"){l=this._$columns["begin"].get(0).offsetWidth+E.COLUMN_MIN_WIDTH;if(o===v.ThreeColumnsMidExpandedEndHidden){d=0}}if(r){if(t==="begin"&a){l=0}if(t==="end"&&o===v.ThreeColumnsMidExpandedEndHidden){d=0}}d+=E.COLUMN_SEPARATOR_WIDTH;h=u-l-d;return{from:l,to:l+h}};E.prototype._updateAriaPositionInfo=function(e){var t=this._getSeparatorMovementRange(e),o=t.to-t.from,n=t.from,i=e.offsetLeft,s=i-n,r=s/o*100,a=r.toFixed(2);e.setAttribute("aria-valuenow",a)};E.prototype._updateSeparatorsAriaPositionInfo=function(){if(!this._oColumnSeparators){return}Object.values(this._oColumnSeparators).forEach(function(e){if(e.get(0).style.display!=="none"){this._updateAriaPositionInfo(e.get(0))}},this)};E.prototype._getColumnWidth=function(e){var t=this._$columns[e].get(0),o=t.style.width,n=parseInt(o),i;if(/px$/.test(o)){return n}i=/%$/.test(o);if(i&&n===100){return this._getControlWidth()}if(i&&n===0){return 0}return t.offsetWidth};E.prototype._cacheColumnWidth=function(e,t){var o;if(this._oColumnWidthInfo[e]!==t){o={};E.COLUMN_ORDER.forEach(function(t){o[t+"Column"]=t===e});this.fireColumnResize(o)}this._oColumnWidthInfo[e]=t};E.prototype._getLastVisibleColumnForLayout=function(e){var t=E.COLUMN_ORDER.slice(),o=this._getMaxColumnsCountForLayout(e,E.DESKTOP_BREAKPOINT);if(o>1){return t[o-1]}if(e===v.OneColumn){return"begin"}if(e===v.MidColumnFullScreen){return"mid"}if(e===v.EndColumnFullScreen){return"end"}};E.prototype._isNavigatingBackward=function(e,t){return[v.MidColumnFullScreen,v.EndColumnFullScreen].indexOf(t)>-1||E.COLUMN_ORDER.indexOf(this._getLastVisibleColumnForLayout(t))>E.COLUMN_ORDER.indexOf(this._getLastVisibleColumnForLayout(e))};E.prototype._shouldRevealColumn=function(e,t,o){var n=this._getMaxColumnsCountForLayout(t,E.DESKTOP_BREAKPOINT),i=this._getLastVisibleColumnForLayout(t),s=e===i,r=this._getLastVisibleColumnForLayout(o),a=this._getMaxColumnsCountForLayout(o,E.DESKTOP_BREAKPOINT),u=this._isFullScreenLayout(o),l=this._isFullScreenLayout(t);return n>a&&!(o===v.MidColumnFullScreen||o===v.EndColumnFullScreen)&&s||u&&l&&r!==e&&s};E.prototype._isFullScreenLayout=function(e){return e===v.OneColumn||e===v.MidColumnFullScreen||e===v.EndColumnFullScreen};E.prototype._isInteractivelyResizedColumn=function(e){return this._oMoveInfo&&this._isColumnAdjacentToDraggedSeparator(e)};E.prototype._isColumnAdjacentToDraggedSeparator=function(e){return this._oMoveInfo&&this._oMoveInfo.separator&&(this._$columns[e][0]===this._oMoveInfo.separator.previousElementSibling||this._$columns[e][0]===this._oMoveInfo.separator.nextElementSibling)};E.prototype._shouldConcealColumn=function(e,t,o){var n=this._getMaxColumnsCountForLayout(t,E.DESKTOP_BREAKPOINT),i=this._getMaxColumnsCountForLayout(o,E.DESKTOP_BREAKPOINT),s=this._getLastVisibleColumnForLayout(o),r=this._getLastVisibleColumnForLayout(t),a=this._isFullScreenLayout(o),u=this._isFullScreenLayout(t);return n<i&&e===s&&!(o===v.MidColumnFullScreen||o===v.EndColumnFullScreen)&&this._getColumnSizeForLayout(e,t)===0||a&&u&&e!==r&&s===e};E.prototype._canResizeColumnWithAnimation=function(e,t){var o,n=t.width,i=t.hasAnimations,s=t.hidden,r=!t.previousAnimationCompleted;if(!i||s){return false}if(this._isInteractivelyResizedColumn(e)){return false}o=this._$columns[e];if(r){return o.width()!==n}if(this._bNeverRendered||t.autoSize){return false}return this._getColumnWidth(e)!==n};E.prototype._propagateContextualSettings=function(){};E.prototype._updateColumnContextualSettings=function(e,t){var o,n;o=this.getAggregation("_"+e+"ColumnNav");if(!o){return}n=o._getContextualSettings();if(!n||n.contextualWidth!==t){o._applyContextualSettings({contextualWidth:t})}};E.prototype._updateColumnCSSClasses=function(e,t){var o="";this._$columns[e].removeClass("sapUiContainer-Narrow sapUiContainer-Medium sapUiContainer-Wide sapUiContainer-ExtraWide");if(t<r.media._predefinedRangeSets[r.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0]){o="Narrow"}else if(t<r.media._predefinedRangeSets[r.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1]){o="Medium"}else if(t<r.media._predefinedRangeSets[r.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2]){o="Wide"}else{o="ExtraWide"}this._$columns[e].addClass("sapUiContainer-"+o)};E.prototype._getColumnSizeForLayout=function(e,t){var o=this._getColumnWidthDistributionForLayout(t),n=o.split("/"),i={begin:0,mid:1,end:2},s=n[i[e]];return parseFloat(s)};E.prototype.getMaxColumnsCount=function(){return this._getMaxColumnsCountForWidth(this._getControlWidth())};E.prototype._getMaxColumnsCountForWidth=function(e){if(e>=E.DESKTOP_BREAKPOINT){return 3}if(e>=E.TABLET_BREAKPOINT&&e<E.DESKTOP_BREAKPOINT){return 2}if(e>0){return 1}return 0};E.prototype._getMaxColumnsCountForLayout=function(e,t){var o=this._getMaxColumnsCountForWidth(t),n=this._getColumnWidthDistributionForLayout(e,false,o),i=n.split("/"),s={begin:0,mid:1,end:2},r,a,u=0;Object.keys(s).forEach(function(e){r=i[s[e]];a=parseInt(r);if(a){u++}});return u};E.prototype._onResize=function(e){var t=e.oldSize.width,o=e.size.width,n,i;this._iWidth=o;if(o===0){return}n=this._getMaxColumnsCountForWidth(t);i=this._getMaxColumnsCountForWidth(o);this._resizeColumns();if(i!==n){this._fireStateChange(false,true)}};E.prototype._setColumnPagesRendered=function(e,t){this._oRenderedColumnPagesBoolMap[e]=t};E.prototype._hasAnyColumnPagesRendered=function(){return Object.keys(this._oRenderedColumnPagesBoolMap).some(function(e){return this._oRenderedColumnPagesBoolMap[e]},this)};E.prototype._getRequiredColumnSeparatorsForLayout=function(e){var t={},o=[],n;if(r.system.phone){return[]}n=this.getMaxColumnsCount();if(n>1){t[v.TwoColumnsBeginExpanded]=["begin"];t[v.TwoColumnsMidExpanded]=["begin"];t[v.ThreeColumnsMidExpanded]=["begin","end"];t[v.ThreeColumnsEndExpanded]=["end"];t[v.ThreeColumnsMidExpandedEndHidden]=["begin","end"];t[v.ThreeColumnsBeginExpandedEndHidden]=["begin"];if(typeof t[e]==="object"){o=t[e]}}return o};E.prototype._hideShowColumnSeparators=function(e){var t=[],o;if(!this.isActive()||r.system.phone){return}e||(e=this.getLayout());t=this._getRequiredColumnSeparatorsForLayout(e);o=this._hasAnyColumnPagesRendered();Object.keys(this._oColumnSeparators).forEach(function(e){this._toggleSeparator(e,t.indexOf(e)!==-1,o)},this)};E.prototype._toggleSeparator=function(e,t,o){this._oColumnSeparators[e].toggle(t&&o);this._oColumnSeparators[e].data("visible",t)};E.prototype._fireStateChange=function(e,t){if(this._getControlWidth()===0){return}this.fireStateChange({isNavigationArrow:e,isResize:t,layout:this.getLayout(),maxColumnsCount:this.getMaxColumnsCount()})};E.prototype.setInitialBeginColumnPage=function(e){this._getBeginColumn().setInitialPage(e);this.setAssociation("initialBeginColumnPage",e,true);return this};E.prototype.setInitialMidColumnPage=function(e){this._getMidColumn().setInitialPage(e);this.setAssociation("initialMidColumnPage",e,true);return this};E.prototype.setInitialEndColumnPage=function(e){this._getEndColumn().setInitialPage(e);this.setAssociation("initialEndColumnPage",e,true);return this};E.prototype.to=function(e,t,o,n){if(this._getBeginColumn().getPage(e)){this._getBeginColumn().to(e,t,o,n)}else if(this._getMidColumn().getPage(e)){this._getMidColumn().to(e,t,o,n)}else{this._getEndColumn().to(e,t,o,n)}return this};E.prototype.backToPage=function(e,t,o){if(this._getBeginColumn().getPage(e)){this._getBeginColumn().backToPage(e,t,o)}else if(this._getMidColumn().getPage(e)){this._getMidColumn().backToPage(e,t,o)}else{this._getEndColumn().backToPage(e,t,o)}return this};E.prototype._safeBackToPage=function(e,t,o,n){if(this._getBeginColumn().getPage(e)){this._getBeginColumn()._safeBackToPage(e,t,o,n)}else if(this._getMidColumn().getPage(e)){this._getMidColumn()._safeBackToPage(e,t,o,n)}else{this._getEndColumn()._safeBackToPage(e,t,o,n)}};E.prototype.toBeginColumnPage=function(e,t,o,n){this._getBeginColumn().to(e,t,o,n);return this};E.prototype.toMidColumnPage=function(e,t,o,n){this._getMidColumn().to(e,t,o,n);return this};E.prototype.toEndColumnPage=function(e,t,o,n){this._getEndColumn().to(e,t,o,n);return this};E.prototype.backBeginColumn=function(e,t){return this._getBeginColumn().back(e,t)};E.prototype.backMidColumn=function(e,t){return this._getMidColumn().back(e,t)};E.prototype.backEndColumn=function(e,t){return this._getEndColumn().back(e,t)};E.prototype.backBeginColumnToPage=function(e,t,o){return this._getBeginColumn().backToPage(e,t,o)};E.prototype.backMidColumnToPage=function(e,t,o){return this._getMidColumn().backToPage(e,t,o)};E.prototype.backEndColumnToPage=function(e,t,o){return this._getEndColumn().backToPage(e,t,o)};E.prototype.backToTopBeginColumn=function(e,t){this._getBeginColumn().backToTop(e,t);return this};E.prototype.backToTopMidColumn=function(e,t){this._getMidColumn().backToTop(e,t);return this};E.prototype.backToTopEndColumn=function(e,t){this._getEndColumn().backToTop(e,t);return this};E.prototype.getCurrentBeginColumnPage=function(){return this._getBeginColumn().getCurrentPage()};E.prototype.getCurrentMidColumnPage=function(){return this._getMidColumn().getCurrentPage()};E.prototype.getCurrentEndColumnPage=function(){return this._getEndColumn().getCurrentPage()};E.prototype.setDefaultTransitionNameBeginColumn=function(e){this.setProperty("defaultTransitionNameBeginColumn",e,true);this._getBeginColumn().setDefaultTransitionName(e);return this};E.prototype.setDefaultTransitionNameMidColumn=function(e){this.setProperty("defaultTransitionNameMidColumn",e,true);this._getMidColumn().setDefaultTransitionName(e);return this};E.prototype.setDefaultTransitionNameEndColumn=function(e){this.setProperty("defaultTransitionNameEndColumn",e,true);this._getEndColumn().setDefaultTransitionName(e);return this};E.prototype._getLayoutHistory=function(){return this._oLayoutHistory};E.prototype._getColumnWidthDistributionForLayout=function(e,t,o){var n=this.getLayoutData(),i=this._getMediaKey(o),s=n?.isA("sap.f.FlexibleColumnLayoutData")&&(i==="desktop"?n.getDesktopLayoutData():n.getTabletLayoutData()),r="get"+e,a=s?.[r]?.(),u=a&&this._isValidWidthDistributionForLayout(a,e),l=this._oBeginColumnWidth[i],d,h;o||(o=this.getMaxColumnsCount());if(o===0){d="0/0/0"}else if(o>1&&a&&u){d=a}else{d=this._getDefaultColumnWidthDistributionForLayout(e,o)}h=d.split("/");l=A(l,e);if(l&&!this._isFullScreenLayout(e)&&parseInt(h[0])!==0){h[0]=l;h=h.map(function(e){return parseFloat(e)});I(h)}if(t){d=h.map(function(e){return Math.round(parseFloat(e))});I(d)}if(t){return d}else{return h.join("/")}};E.prototype._getDefaultColumnWidthDistributionForLayout=function(e,t){var o={};o[v.OneColumn]="100/0/0";o[v.MidColumnFullScreen]="0/100/0";o[v.EndColumnFullScreen]="0/0/100";if(t===1){o[v.TwoColumnsBeginExpanded]="0/100/0";o[v.TwoColumnsMidExpanded]="0/100/0";o[v.ThreeColumnsMidExpanded]="0/0/100";o[v.ThreeColumnsEndExpanded]="0/0/100";o[v.ThreeColumnsMidExpandedEndHidden]="0/0/100";o[v.ThreeColumnsBeginExpandedEndHidden]="0/0/100"}else{o[v.TwoColumnsBeginExpanded]="67/33/0";o[v.TwoColumnsMidExpanded]="33/67/0";o[v.ThreeColumnsMidExpanded]=t===2?"0/67/33":"25/50/25";o[v.ThreeColumnsEndExpanded]=t===2?"0/33/67":"25/25/50";o[v.ThreeColumnsMidExpandedEndHidden]="33/67/0";o[v.ThreeColumnsBeginExpandedEndHidden]="67/33/0"}return o[e]};E.prototype._attachAfterColumnResizedOnce=function(e,t,o){this._oAnimationEndListener.waitForColumnResizeEnd(this._$columns[e]).then(t).catch(function(){o&&o()})};E.prototype._attachAfterAllColumnsResizedOnce=function(e,t){this._oAnimationEndListener.waitForAllColumnsResizeEnd().then(e).catch(function(){t&&t()})};E.DESKTOP_BREAKPOINT=1280;E.TABLET_BREAKPOINT=960;E.COLUMN_MIN_WIDTH=312;E.STORAGE_PREFIX_TABLET="sap-f-fcl-tablet-column-width-distributions";E.STORAGE_PREFIX_DESKTOP="sap-f-fcl-desktop-column-width-distributions";E._getResourceBundle=function(){return o.getResourceBundleFor("sap.f")};E.prototype.showPlaceholder=function(e){var t=sap.ui.require("sap/ui/core/Placeholder");if(!t||!t.isEnabled()){return}switch(e&&e.aggregation){case"beginColumnPages":return this.getAggregation("_beginColumnNav").showPlaceholder(e);case"midColumnPages":return this.getAggregation("_midColumnNav").showPlaceholder(e);default:return this.getAggregation("_endColumnNav").showPlaceholder(e)}};E.prototype.hidePlaceholder=function(e){switch(e.aggregation){case"beginColumnPages":this.getAggregation("_beginColumnNav").hidePlaceholder(e);break;case"midColumnPages":this.getAggregation("_midColumnNav").hidePlaceholder(e);break;default:this.getAggregation("_endColumnNav").hidePlaceholder(e)}};E.prototype.needPlaceholder=function(e,t){var o;switch(e){case"beginColumnPages":o=this.getAggregation("_beginColumnNav");break;case"midColumnPages":o=this.getAggregation("_midColumnNav");break;default:o=this.getAggregation("_endColumnNav")}return!t||o.getCurrentPage()!==t};function b(){this._aLayoutHistory=[]}b.prototype.addEntry=function(e){if(typeof e!=="undefined"){this._aLayoutHistory.push(e)}};b.prototype.getEntry=function(e,t){var o=this._aLayoutHistory;if(t){o=this._aLayoutHistory.slice().reverse()}return o[e]};b.prototype.getClosestEntryThatMatches=function(e){var t;for(t=this._aLayoutHistory.length-1;t>=0;t--){if(e.indexOf(this._aLayoutHistory[t])!==-1){return this._aLayoutHistory[t]}}};function L(){this._oListeners={};this._aPendingPromises=[];this._oPendingPromises={};this._oCancelPromises={};this._oPendingPromiseAll=null}L.prototype.waitForColumnResizeEnd=function(e){var t=e.get(0).id,o;if(!this._oPendingPromises[t]){o=new Promise(function(o,n){C.debug("FlexibleColumnLayout","wait for column "+t+" to resize");this._attachTransitionEnd(e,function(){C.debug("FlexibleColumnLayout","completed column "+t+" resize");this._cleanUp(e);o()}.bind(this));this._oCancelPromises[t]={cancel:function(){C.debug("FlexibleColumnLayout","cancel column "+t+" resize");this._cleanUp(e);n()}.bind(this)}}.bind(this));this._aPendingPromises.push(o);this._oPendingPromises[t]=o}return this._oPendingPromises[t]};L.prototype.waitForAllColumnsResizeEnd=function(){if(!this._oPendingPromiseAll){this._oPendingPromiseAll=new Promise(function(e,t){this.iTimer=setTimeout(function(){Promise.all(this._aPendingPromises).then(function(){C.debug("FlexibleColumnLayout","completed all columns resize");e()},0).catch(function(){t()});this.iTimer=null}.bind(this))}.bind(this))}return this._oPendingPromiseAll};L.prototype.isWaitingForColumnResizeEnd=function(e){var t=e.get(0).id;return!!this._oListeners[t]};L.prototype.cancelAll=function(){Object.keys(this._oCancelPromises).forEach(function(e){this._oCancelPromises[e].cancel()},this);this._oPendingPromises={};this._aPendingPromises=[];this._oCancelPromises={};this._oPendingPromiseAll=null;this._oListeners={};if(this.iTimer){clearTimeout(this.iTimer);this.iTimer=null}C.debug("FlexibleColumnLayout","detached all listeners for columns resize")};L.prototype._attachTransitionEnd=function(e,t){var o=e.get(0).id;if(!this._oListeners[o]){e.on("webkitTransitionEnd transitionend",t);this._oListeners[o]=t}};L.prototype._detachTransitionEnd=function(e){var t=e.get(0).id;if(this._oListeners[t]){e.off("webkitTransitionEnd transitionend",this._oListeners[t]);this._oListeners[t]=null}};L.prototype._cleanUp=function(e){if(e.length){var t=e.get(0).id;this._detachTransitionEnd(e);delete this._oPendingPromises[t];delete this._oCancelPromises[t]}};function T(e,t,o){var n;if(e===t){return"100%"}n=o?e-E.COLUMN_SEPARATOR_WIDTH:e;return n+"px"}function P(e){return e.classList.contains("sapFFCLColumnSeparatorBegin")?"begin":"end"}function S(e,t,o){var n=e.classList.contains("sapFFCLColumnSeparatorBegin");if(o===2&&t==v.ThreeColumnsMidExpandedEndHidden){return n?["begin","mid"]:["begin","end"]}if(o===2&&t==v.ThreeColumnsMidExpanded){return n?["begin","end"]:["mid","end"]}return n?["begin","mid"]:["mid","end"]}function F(e){var t=e;if(e.changedTouches&&e.changedTouches[0]){t=t.changedTouches[0]}return t.pageX}function I(e){var t={begin:0,mid:1,end:2},o=e.reduce((e,t)=>e+t,0);if(o!==100){e[t.mid]=100-(e[t.begin]+e[t.end])}}function A(e,t){if((t===v.ThreeColumnsMidExpanded||t==v.ThreeColumnsEndExpanded)&&Math.floor(e)>=33){return 32}return e}return E});
//# sourceMappingURL=FlexibleColumnLayout.js.map