/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./GridContainerRenderer","./GridContainerSettings","./GridContainerUtils","./GridNavigationMatrix","./delegate/GridContainerItemNavigation","./library","./dnd/GridKeyboardDragAndDrop","sap/base/i18n/Localization","sap/base/strings/capitalize","sap/ui/core/Lib","sap/ui/core/RenderManager","sap/ui/base/ManagedObjectObserver","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/ResizeHandler","sap/ui/core/InvisibleMessage","sap/ui/core/Theming","sap/ui/Device","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery"],function(e,t,i,s,r,n,o,a,l,u,p,h,d,g,c,m,f,y,_,jQuery){"use strict";function v(e){var t=e.getLayoutData();return t?t.getColumns():1}function C(e){var t=e.getLayoutData();return t?t.getActualRows():1}function I(e){var t=e.getLayoutData();return t?t.hasAutoHeight():true}var R=d.extend("sap.f.GridContainer",{metadata:{library:"sap.f",interfaces:["sap.f.dnd.IGridDroppable"],properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:""},minHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"2rem"},containerQuery:{type:"boolean",group:"Behavior",defaultValue:false},snapToRow:{type:"boolean",group:"Appearance",defaultValue:false},allowDenseFill:{type:"boolean",group:"Appearance",defaultValue:false},inlineBlockLayout:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Control",multiple:true,singularName:"item",dnd:true},layout:{type:"sap.f.GridContainerSettings",defaultClass:t,multiple:false},layoutXS:{type:"sap.f.GridContainerSettings",defaultClass:t,multiple:false},layoutS:{type:"sap.f.GridContainerSettings",defaultClass:t,multiple:false},layoutM:{type:"sap.f.GridContainerSettings",defaultClass:t,multiple:false},layoutL:{type:"sap.f.GridContainerSettings",defaultClass:t,multiple:false},layoutXL:{type:"sap.f.GridContainerSettings",defaultClass:t,multiple:false},_defaultLayout:{type:"sap.f.GridContainerSettings",defaultClass:t,multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{layoutChange:{parameters:{layout:{type:"string"}}},columnsChange:{parameters:{columns:{type:"int"}}},borderReached:{parameters:{event:{type:"jQuery.Event"},direction:{type:"sap.f.NavigationDirection"},row:{type:"int"},column:{type:"int"}}}},dnd:{draggable:false,droppable:true},designtime:"sap/f/designtime/GridContainer.designtime"},renderer:e});R.prototype.bUseExtendedChangeDetection=true;R.prototype.getActiveLayoutSettings=function(){var e=this.getAggregation(this._sActiveLayout);if(!e&&this._sActiveLayout==="layoutXS"){e=this.getAggregation("layoutS")}if(!e){e=this.getAggregation("layout")||this.getAggregation("_defaultLayout")}return e};R.prototype._onBeforeItemRendering=function(){var e=this.getParent();if(e._resizeListeners[this.getId()]){c.deregister(e._resizeListeners[this.getId()]);delete e._resizeListeners[this.getId()]}e._reflectItemVisibilityToWrapper(this);if(this.isA("sap.f.IGridContainerItem")){this.setGridItemRole("listitem")}};R.prototype._onAfterItemRendering=function(){var e=this.getParent();e._resizeListeners[this.getId()]=c.register(this,e._resizeItemHandler);e._setItemNavigationItems();e._applyItemAutoRows(this)};R.prototype._reflectItemVisibilityToWrapper=function(e){var t=i.getItemWrapper(e),s;if(!t){return}s=jQuery(t);if(e.getVisible()&&s.hasClass("sapFGridContainerInvisiblePlaceholder")){s.removeClass("sapFGridContainerInvisiblePlaceholder")}else if(!e.getVisible()&&!s.hasClass("sapFGridContainerInvisiblePlaceholder")){s.addClass("sapFGridContainerInvisiblePlaceholder")}};R.prototype._onItemChange=function(e){if(e.name!=="items"||!e.child){return}if(e.mutation==="insert"){e.child.addEventDelegate(this._itemDelegate,e.child)}else if(e.mutation==="remove"){e.child.removeEventDelegate(this._itemDelegate,e.child)}};R.prototype._deregisterResizeListeners=function(){var e,t;for(e in this._resizeListeners){t=this._resizeListeners[e];c.deregister(t)}delete this._resizeListeners;y.resize.detachHandler(this._resizeDeviceHandler)};R.prototype._setItemNavigationItems=function(){if(!this._isRenderingFinished){return}var e=[];if(!this._oItemNavigation){this._oItemNavigation=(new r).setCycling(false).setDisabledModifiers({sapnext:["alt","meta","ctrl"],sapprevious:["alt","meta","ctrl"]}).setTableMode(true,true).setFocusedIndex(0);this.addDelegate(this._oItemNavigation)}this.getItems().map(t=>{e.push(i.getItemFocusDomRef(t))});this._oItemNavigation.setRootDomRef(this.getDomRef());this._oItemNavigation.setItemDomRefs(e)};R.prototype._detectActiveLayout=function(){var e=this.getContainerQuery()&&this.getDomRef()?this._getComputedWidth():y.resize.width,t=y.media.getCurrentRange("GridContainerRangeSet",e),i="layout"+t.name,s=this.getActiveLayoutSettings(),r=false;if(!e){return false}if(this._sActiveLayout!==i){this.addStyleClass("sapFGridContainer"+l(i));if(this._sActiveLayout){this.removeStyleClass("sapFGridContainer"+l(this._sActiveLayout))}this._sActiveLayout=i;r=s!==this.getActiveLayoutSettings();this.fireLayoutChange({layout:this._sActiveLayout})}return r};R.prototype._detectColumnsChange=function(){var e=this.getActiveLayoutSettings(),t=this.$().innerWidth(),i;if(!e){return}i=e.getComputedColumnsCount(t);if(this._iColumns!==i){this.fireColumnsChange({columns:i});this._iColumns=i}};R.prototype._getActiveGridStyles=function(){var e=this.getActiveLayoutSettings(),t=e.getColumns()||"auto-fill",i=e.getColumnSize(),s=e.getMinColumnSize(),r=e.getMaxColumnSize(),n={"grid-gap":e.getGap()};if(s&&r){n["grid-template-columns"]="repeat("+t+", minmax("+s+", "+r+"))"}else{n["grid-template-columns"]="repeat("+t+", "+i+")"}if(this.getInlineBlockLayout()){n["grid-auto-rows"]="min-content"}else{n["grid-auto-rows"]=e.getRowSize()}return n};R.prototype.init=function(){this._oRb=u.getResourceBundleFor("sap.f");this.setAggregation("_defaultLayout",new t);this._initRangeSet();this._resizeListeners={};this._oItemNavigation=null;this._itemDelegate={onBeforeRendering:this._onBeforeItemRendering,onAfterRendering:this._onAfterItemRendering};this._itemsObserver=new h(this._onItemChange.bind(this));this._itemsObserver.observe(this,{aggregations:["items"]});this._resizeHandler=this._resize.bind(this);this._resizeDeviceHandler=this._resizeDevice.bind(this);y.resize.attachHandler(this._resizeDeviceHandler);this._resizeItemHandler=this._resizeItem.bind(this);this._bThemeApplied=false;this._handleThemeAppliedBound=this._handleThemeApplied.bind(this);f.attachApplied(this._handleThemeAppliedBound)};R.prototype.insertItem=function(e,t){this.insertAggregation("items",e,t,true);if(!this.getDomRef()||!e.getVisible()){this.invalidate();return this}t=Math.max(0,Math.min(t,this.getItems().length-1));var i=(new p).getInterface(),s=this._createItemWrapper(e),r=this.getDomRef("listUl"),n=r.children[t];if(n){r.insertBefore(s,n)}else{r.appendChild(s)}i.render(e,s);i.destroy();return this};R.prototype.removeItem=function(e){var t=this.removeAggregation("items",e,true),i=this.getDomRef("listUl"),s=t.getDomRef();if(!i||!s){this.invalidate();return t}i.removeChild(s.parentElement);return t};R.prototype.onBeforeRendering=function(){this._detectActiveLayout();var e=this._resizeListeners[this.getId()];if(e){c.deregister(e)}m.getInstance();this._isRenderingFinished=false;this._lastGridWidth=null;this._lastViewportWidth=null};R.prototype.onAfterRendering=function(){this._resizeListeners[this.getId()]=c.register(this.getDomRef(),this._resizeHandler);this._isRenderingFinished=true;this._setItemNavigationItems();this._applyLayout(true);if(this.getItems().length===1&&this._forceFocus){this.focusItem(0);this._forceFocus=false}};R.prototype.exit=function(){this._deregisterResizeListeners();if(this._itemsObserver){this._itemsObserver.disconnect();delete this._itemsObserver}if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;this._oItemNavigation=null}this._forceFocus=null;if(this._checkColumnsTimeout){clearTimeout(this._checkColumnsTimeout);this._checkColumnsTimeout=null}f.detachApplied(this._handleThemeAppliedBound)};R.prototype._initRangeSet=function(){if(!y.media.hasRangeSet("GridContainerRangeSet")){y.media.initRangeSet("GridContainerRangeSet",[375,600,1024,1440],"px",["XS","S","M","L","XL"])}};R.prototype._resize=function(){if(!this._isWidthChanged()){return}var e=this._detectActiveLayout();this._applyLayout(e)};R.prototype._resizeDevice=function(){if(!this.getContainerQuery()){this._resize()}};R.prototype._isWidthChanged=function(){var e=this._getComputedWidth(),t=y.resize.width;if(this._lastGridWidth===e&&this._lastViewportWidth===t){return false}this._lastGridWidth=e;this._lastViewportWidth=t;return true};R.prototype._getComputedWidth=function(){if(!this.getDomRef()){return null}return this.getDomRef().getBoundingClientRect().width};R.prototype._resizeItem=function(e){this._applyItemAutoRows(e.control)};R.prototype._applyLayout=function(e){if(!this._isRenderingFinished){return}if(e){this.$("listUl").css(this._getActiveGridStyles());this.getItems().forEach(this._applyItemAutoRows.bind(this))}this._checkColumns()};R.prototype._checkColumns=function(){if(this._checkColumnsTimeout){clearTimeout(this._checkColumnsTimeout);this._checkColumnsTimeout=null}this._checkColumnsTimeout=setTimeout(function(){this._detectColumnsChange();this._enforceMaxColumns()}.bind(this),0)};R.prototype._applyItemAutoRows=function(e){if(!this._isRenderingFinished){return}if(this.getInlineBlockLayout()){return}if(I(e)){var t=e.$(),i=this.getActiveLayoutSettings(),s=e.getDomRef()?e.getDomRef().getBoundingClientRect().height:0,r=i.calculateRowsForItem(Math.round(s));if(!r){return}t.parent().css({"grid-row":"span "+Math.max(r,C(e))})}};R.prototype._enforceMaxColumns=function(){var e=this.getActiveLayoutSettings(),t;if(!e){return}t=e.getComputedColumnsCount(this.$("listUl").innerWidth());if(!t){return}this.getItems().forEach(function(e){e.$().parent().css("grid-column","span "+Math.min(v(e),t))})};R.prototype._createItemWrapper=function(t){var i=e.getStylesForItemWrapper(t,this),s=i.styles,r=i.classes,n=document.createElement("div");n.setAttribute("id",e.generateWrapperId(t,this));if(!t.isA("sap.f.IGridContainerItem")){n.setAttribute("tabindex","0");n.classList.add("sapFGCFocusable")}else{t.setGridItemRole("listitem")}s.forEach(function(e,t){n.style.setProperty(t,e)});r.forEach(function(e){n.classList.add(e)});return n};R.prototype.onItemNavigationBorderReached=function(e){this.fireEvent("borderReached",e)};R.prototype._isListItem=function(e){return e.isA("sap.f.IGridContainerItem")};R.prototype._moveItem=function(e){if(!e.ctrlKey){return}const t=e.srcControl;const s=t?.isA("sap.f.IGridContainerItem");if(!s&&!e.target.classList.contains("sapFGridContainerItemWrapper")){return}var r=s?t:g.closestTo(e.target.firstElementChild),n=this.getItems().length,l=this.indexOfItem(r),u=-1,p,h=[];switch(e.keyCode){case _.ARROW_RIGHT:u=a.getRTL()?l-1:l+1;if(u>=0&&u<n){p=i.createConfig(this,this.getItems()[u]);p.dropPosition="After";h=[p]}break;case _.ARROW_LEFT:u=a.getRTL()?l+1:l-1;if(u>=0&&u<n){p=i.createConfig(this,this.getItems()[u]);p.dropPosition="Before";h=[p]}break;case _.ARROW_UP:h=i.findDropTargetsAbove(this,r);h.forEach(function(e){e.dropPosition="Before"});break;case _.ARROW_DOWN:h=i.findDropTargetsBelow(this,r);h.forEach(function(e){e.dropPosition=this.indexOfItem(e.item)!==-1?"After":"Before"}.bind(this));break;default:break}e.stopPropagation();o.fireDnD(r,h,e);this._setItemNavigationItems()};R.prototype.onsapincreasemodifiers=R.prototype._moveItem;R.prototype.onsapdecreasemodifiers=R.prototype._moveItem;R.prototype.focusItem=function(e){var t,i=this._oItemNavigation;this._forceFocus=true;this._setItemNavigationItems();t=i.getItemDomRefs();if(t[e]){i.focusItem(e)}};R.prototype.focusItemByDirection=function(e,t,i){this._oItemNavigation.focusItemByDirection(this,e,t,i)};R.prototype.getNavigationMatrix=function(){if(!this._bThemeApplied){return null}var e=this.getItems().reduce(function(e,t){if(t.getVisible()){e.push(i.getItemWrapper(t))}return e},[]);return s.create(this.getDomRef("listUl"),e)};R.prototype._handleThemeApplied=function(){this._bThemeApplied=true;f.detachApplied(this._handleThemeAppliedBound)};["onkeypress","onkeyup","onkeydown","onsapenter","onsapselect","onsapspace"].forEach(function(e){R.prototype[e]=function(t){if(!t.target?.classList.contains("sapFGCFocusable")){return}if(e==="onsapspace"){t.preventDefault()}var i=g.closestTo(t.target.firstChild);if(i){var s=i.getFocusDomRef(),r=g.closestTo(s);if(r&&r[e]){r[e].call(r,t)}}}});return R});
//# sourceMappingURL=GridContainer.js.map