/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./delegate/GridItemNavigation","./GridListRenderer","./GridNavigationMatrix","./library","sap/m/ListBase","sap/ui/base/ManagedObjectObserver","sap/ui/core/Theming","sap/ui/Device","sap/ui/layout/cssgrid/GridLayoutDelegate","sap/ui/layout/cssgrid/GridLayoutBase"],function(e,t,i,o,a,r,n,s,d,p){"use strict";var h=o.NavigationDirection;var u=a.extend("sap.f.GridList",{metadata:{library:"sap.f",interfaces:["sap.ui.layout.cssgrid.IGridConfigurable","sap.f.dnd.IGridDroppable"],aggregations:{customLayout:{type:"sap.ui.layout.cssgrid.GridLayoutBase",multiple:false}},events:{borderReached:{parameters:{event:{type:"jQuery.Event"},direction:{type:"sap.f.NavigationDirection"},row:{type:"int"},column:{type:"int"}}}}},renderer:t});u.prototype.init=function(){a.prototype.init.apply(this,arguments);this._oItemDelegate={onAfterRendering:this._onAfterItemRendering};this._addGridLayoutDelegate();this._oGridObserver=new r(u.prototype._onGridChange.bind(this));this._oGridObserver.observe(this,{aggregations:["items"]});this._bThemeApplied=false;this._handleThemeAppliedBound=this._handleThemeApplied.bind(this);n.attachApplied(this._handleThemeAppliedBound)};u.prototype.exit=function(){this._removeGridLayoutDelegate();if(this._oGridObserver){this._oGridObserver.disconnect();this._oGridObserver=null}n.detachApplied(this._handleThemeAppliedBound);a.prototype.exit.apply(this,arguments)};u.prototype.onAfterPageLoaded=function(){a.prototype.onAfterPageLoaded.apply(this,arguments);if(this._oItemNavigation){this._oItemNavigation.resetFocusPosition()}};u.prototype.onItemNavigationBorderReached=function(e){var t=this.getGrowingInfo();if(e.direction===h.Down&&t&&t.actual!==t.total){return}this.fireEvent("borderReached",e)};u.prototype.getGridDomRefs=function(){return[this.getItemsContainerDomRef()]};u.prototype.focusItemByDirection=function(e,t,i){this._oItemNavigation.focusItemByDirection(this,e,t,i)};u.prototype.getNavigationMatrix=function(){if(!this._bThemeApplied){return null}var e=this.getItems().reduce(function(e,t){if(t.getDomRef()){e.push(t.getDomRef())}return e},[]);return i.create(this.getItemsContainerDomRef(),e)};u.prototype.getGridLayoutConfiguration=u.prototype.getCustomLayout;u.prototype._startItemNavigation=function(t){if(!s.system.desktop){return}if(!this._oItemNavigation){this._oItemNavigation=new e;this._oItemNavigation.setCycling(false).setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"]}).setFocusedIndex(0);this.addDelegate(this._oItemNavigation)}a.prototype._startItemNavigation.apply(this,arguments)};u.prototype._addGridLayoutDelegate=function(){if(!this.oGridLayoutDelegate){this.oGridLayoutDelegate=new d;this.addEventDelegate(this.oGridLayoutDelegate,this)}};u.prototype._removeGridLayoutDelegate=function(){if(this.oGridLayoutDelegate){this.removeEventDelegate(this.oGridLayoutDelegate);this.oGridLayoutDelegate.destroy();this.oGridLayoutDelegate=null}};u.prototype._onGridChange=function(e){var t;if(e.name!=="items"||!e.child){return}if(e.mutation==="insert"){t=!e.child.isA("sap.ui.core.HTML");e.child.addDelegate(this._oItemDelegate,t,e.child)}else if(e.mutation==="remove"){e.child.removeEventDelegate(this._oItemDelegate,e.child)}};u.prototype._onAfterItemRendering=function(){p.setItemStyles(this)};u.prototype.updateItems=function(){a.prototype.updateItems.apply(this,arguments);this.invalidate()};u.prototype.onLayoutDataChange=function(e){p.setItemStyles(e.srcControl)};u.prototype._handleThemeApplied=function(){this._bThemeApplied=true;n.detachApplied(this._handleThemeAppliedBound)};return u});
//# sourceMappingURL=GridList.js.map