/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/core/IntervalTrigger","sap/ui/core/Lib","sap/ui/core/format/DateFormat","sap/ui/core/date/UniversalDate","sap/ui/core/library","sap/ui/events/KeyCodes","sap/m/library","sap/m/Text","sap/f/cards/util/addTooltipIfTruncated","sap/base/Log"],function(e,t,i,a,s,r,o,n,p,l,u){"use strict";const d=6e4;const h=i.getResourceBundleFor("sap.f");const f=r.TextAlign;const m=n.WrappingType;var g=e.extend("sap.f.cards.BaseHeader",{metadata:{library:"sap.f",interfaces:["sap.m.IBar"],abstract:true,properties:{dataTimestamp:{type:"string",defaultValue:""},statusVisible:{type:"boolean",defaultValue:true},dataTimestampUpdating:{type:"boolean",defaultValue:false,visibility:"hidden"},focusable:{type:"boolean",defaultValue:true,visibility:"hidden"},useTileLayout:{type:"boolean",group:"Appearance",visibility:"hidden"},headingLevel:{type:"string",visibility:"hidden",defaultValue:"3"},wrappingType:{type:"sap.m.WrappingType",group:"Appearance",defaultValue:m.Normal},useTooltips:{type:"boolean",visibility:"hidden",defaultValue:false},href:{type:"string"},target:{type:"string"}},aggregations:{infoSection:{type:"sap.ui.core.Control",multiple:true,singularName:"infoSection"},_dataTimestamp:{type:"sap.m.Text",multiple:false,visibility:"hidden"},toolbar:{type:"sap.ui.core.Control",multiple:false},_error:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},bannerLines:{type:"sap.m.Text",group:"Appearance",multiple:true}},events:{press:{}}}});g.prototype._setRootAccessibilityRole=function(){};g.prototype._setRootAriaLevel=function(){};g.prototype._applyContextClassFor=function(){};g.prototype.init=function(){this._oRb=i.getResourceBundleFor("sap.f");this._oToolbarDelegate={onfocusin:this._onToolbarFocusin,onfocusout:this._onToolbarFocusout,onAfterRendering:this._addMarginToHeaderText}};g.prototype.exit=function(){this._removeTimestampListener();if(this._oToolbarDelegate){this._oToolbarDelegate=null}this._oRb=null};g.prototype.onBeforeRendering=function(){var e=this.getToolbar(),t=this.getBannerLines();if(e){e.addStyleClass("sapFCardHeaderToolbar");e.removeEventDelegate(this._oToolbarDelegate,this);if(e.updateVisibility){e.updateVisibility()}}if(t){t.forEach(e=>{e.setTextAlign(f.End);e.setWrapping(false)})}};g.prototype.onAfterRendering=function(){var e=this.getToolbar();if(e){e.addEventDelegate(this._oToolbarDelegate,this)}this._addMarginToHeaderText();this.getBannerLines()?.forEach(e=>{this._enhanceText(e)})};g.prototype.getFocusDomRef=function(){return this.getDomRef("focusable")};g.prototype.getTitleId=function(){return null};g.prototype.isLink=function(){return!!this.getHref()};g.prototype.onkeydown=function(e){if((e.which===o.SPACE||e.which===o.ENTER||e.which===o.ESCAPE||e.which===o.SHIFT)&&!e.ctrlKey&&!e.metaKey){if(e.which===o.SPACE){e.preventDefault()}if(e.which===o.ENTER){this._handleTap(e)}if(e.which===o.SHIFT||e.which===o.ESCAPE){this._bPressedEscapeOrShift=true}}};g.prototype.onkeyup=function(e){if(e.which===o.SPACE){if(!this._bPressedEscapeOrShift&&!this._hasModifierKeys(e)){this._handleTap(e)}}if(e.which===o.SHIFT||e.which===o.ESCAPE){this._bPressedEscapeOrShift=false}};g.prototype.ontap=function(e){if(this.isLink()&&e.ctrlKey){return}this._handleTap(e)};g.prototype._handleTap=function(e){if(!e.target.closest(".sapFCardSectionClickable")||!this.isInteractive()||this._isInsideToolbar(e.target)){return}this.firePress({originalEvent:e});e.preventDefault();e.stopPropagation()};g.prototype._onToolbarFocusin=function(){this.addStyleClass("sapFCardHeaderToolbarFocused")};g.prototype._onToolbarFocusout=function(){this.removeStyleClass("sapFCardHeaderToolbarFocused")};g.prototype._addMarginToHeaderText=function(){const e=this.getToolbar();const t=this.getDomRef().getElementsByClassName("sapFCardHeaderText")[0];if(t&&e){if(e.getVisible()){t.style.marginInlineEnd=e.getDomRef().offsetWidth+"px"}else{t.style.marginInlineEnd=0}}};g.prototype.setDataTimestamp=function(e){var t=this.getDataTimestamp();if(t&&!e){this.destroyAggregation("_dataTimestamp");this._removeTimestampListener()}this.setProperty("dataTimestamp",e);if(e){this._updateDataTimestamp();this._addTimestampListener()}return this};g.prototype.setDataTimestampUpdating=function(e){var t=this._createDataTimestamp();this.setProperty("dataTimestampUpdating",e);if(e){t.setText("updating...");t.addStyleClass("sapFCardDataTimestampUpdating");this._removeTimestampListener()}else{t.removeStyleClass("sapFCardDataTimestampUpdating")}return this};g.prototype._createDataTimestamp=function(){var e=this.getAggregation("_dataTimestamp");if(!e){e=new p({id:this.getId()+"-dataTimestamp",wrapping:false,textAlign:"End"});e.addStyleClass("sapFCardDataTimestamp");this.setAggregation("_dataTimestamp",e)}return e};g.prototype._updateDataTimestamp=function(){var e=this._createDataTimestamp(),t=this.getDataTimestamp(),i,r,o;if(!t){e.setText("");return}i=a.getDateTimeInstance({relative:true});r=new s(t);o=i.format(r);if(r.getTime()+59e3>Date.now()){o=h.getText("CARD_HEADER_DATETIMESTAMP_NOW")}e.setText(o);e.removeStyleClass("sapFCardDataTimestampUpdating")};g.prototype._addTimestampListener=function(){g.getTimestampIntervalTrigger().addListener(this._updateDataTimestamp,this);this._bHasTimestampListener=true};g.prototype._removeTimestampListener=function(){if(!this._bHasTimestampListener){return}g.getTimestampIntervalTrigger().removeListener(this._updateDataTimestamp,this);this._bHasTimestampListener=false};g.getTimestampIntervalTrigger=function(){if(!g._oTimestampIntervalTrigger){g._oTimestampIntervalTrigger=new t(d)}return g._oTimestampIntervalTrigger};g.prototype.getTitleAriaRole=function(){return"heading"};g.prototype.getFocusableElementAriaRole=function(){if(this.isLink()){return"link"}return this.hasListeners("press")?"button":"group"};g.prototype.getAriaHeadingLevel=function(){return this.getProperty("headingLevel")};g.prototype.getAriaRoleDescription=function(){return this.hasListeners("press")?this._oRb.getText("ARIA_ROLEDESCRIPTION_INTERACTIVE_CARD_HEADER"):this._oRb.getText("ARIA_ROLEDESCRIPTION_CARD_HEADER")};g.prototype._getBannerLinesIds=function(){return this.getBannerLines().map(e=>e.getId()).join(" ")};g.prototype.isInteractive=function(){return this.hasListeners("press")};g.prototype.isFocusable=function(){if(!this.getProperty("focusable")){return false}const e=this.getParent();if(e&&e.isA("sap.f.CardBase")&&e.isRoleListItem()){return this.isInteractive()}return true};g.prototype._isInsideToolbar=function(e){var t=this.getToolbar();return t&&t.getDomRef()&&t.getDomRef().contains(e)};g.prototype._enhanceText=function(e){if(this.getProperty("useTooltips")){l(e)}};g.prototype._hasModifierKeys=function(e){return e.altKey||e.ctrlKey||e.metaKey};return g});
//# sourceMappingURL=BaseHeader.js.map