/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BaseHeader","./NumericIndicators","sap/base/Log","sap/m/library","sap/m/Text","sap/m/ObjectStatus","sap/f/cards/NumericHeaderRenderer","sap/ui/core/library","sap/m/Avatar","sap/ui/core/InvisibleText"],function(t,e,i,a,s,r,n,p,l,o){"use strict";const g=p.ValueState;const u=a.AvatarShape;const d=a.AvatarColor;const h=a.AvatarImageFitType;const c=a.AvatarSize;var y=t.extend("sap.f.cards.NumericHeader",{metadata:{library:"sap.f",interfaces:["sap.f.cards.IHeader"],properties:{title:{type:"string",group:"Appearance"},titleMaxLines:{type:"int",defaultValue:3},subtitle:{type:"string",group:"Appearance"},subtitleMaxLines:{type:"int",defaultValue:2},statusText:{type:"string",defaultValue:""},iconDisplayShape:{type:"sap.m.AvatarShape",defaultValue:u.Circle},iconSrc:{type:"sap.ui.core.URI",defaultValue:""},iconInitials:{type:"string",defaultValue:""},iconAlt:{type:"string",defaultValue:""},iconBackgroundColor:{type:"sap.m.AvatarColor",defaultValue:d.Transparent},iconVisible:{type:"boolean",defaultValue:true},iconSize:{type:"sap.m.AvatarSize",defaultValue:c.S},iconFitType:{type:"sap.m.AvatarImageFitType",defaultValue:h.Cover},unitOfMeasurement:{type:"string",group:"Data"},number:{type:"string",group:"Data"},numberSize:{type:"string",group:"Appearance",defaultValue:"L"},numberVisible:{type:"boolean",defaultValue:true},scale:{type:"string",group:"Data"},trend:{type:"sap.m.DeviationIndicator",group:"Appearance",defaultValue:"None"},state:{type:"sap.m.ValueColor",group:"Appearance",defaultValue:"Neutral"},details:{type:"string",group:"Appearance"},detailsState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:g.None},detailsMaxLines:{type:"int",defaultValue:1},sideIndicatorsAlignment:{type:"sap.f.cards.NumericHeaderSideIndicatorsAlignment",group:"Appearance",defaultValue:"Begin"}},aggregations:{sideIndicators:{type:"sap.f.cards.NumericSideIndicator",multiple:true,forwarding:{getter:"_getNumericIndicators",aggregation:"sideIndicators"}},microChart:{type:"sap.ui.core.Control",multiple:false},_title:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_subtitle:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_avatar:{type:"sap.m.Avatar",multiple:false,visibility:"hidden"},_unitOfMeasurement:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_details:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_numericIndicators:{type:"sap.f.cards.NumericIndicators",multiple:false,visibility:"hidden"}}},renderer:n});y.prototype.init=function(){t.prototype.init.apply(this,arguments);this.data("sap-ui-fastnavgroup","true",true)};y.prototype.exit=function(){t.prototype.exit.apply(this,arguments)};y.prototype.onBeforeRendering=function(){t.prototype.onBeforeRendering.apply(this,arguments);this._getTitle().setText(this.getTitle()).setMaxLines(this.getTitleMaxLines()).setWrappingType(this.getWrappingType());this._enhanceText(this._getTitle());this._getSubtitle().setText(this.getSubtitle()).setMaxLines(this.getSubtitleMaxLines()).setWrappingType(this.getWrappingType());this._enhanceText(this._getSubtitle());this._getUnitOfMeasurement().setText(this.getUnitOfMeasurement());this._getAvatar().setDisplayShape(this.getIconDisplayShape()).setSrc(this.getIconSrc()).setInitials(this.getIconInitials()).setTooltip(this.getIconAlt()).setBackgroundColor(this.getIconBackgroundColor()).setDisplaySize(this.getIconSize()).setImageFitType(this.getIconFitType());this._getDetails().setText(this.getDetails()).setMaxLines(this.getDetailsMaxLines()).setWrappingType(this.getWrappingType());if(!this.isPropertyInitial("detailsState")){Object.values(g).forEach(t=>{this._getDetails().removeStyleClass(`sapFCardNumericHeaderDetailsState${t}`)});this._getDetails().addStyleClass(`sapFCardNumericHeaderDetailsState${this.getDetailsState()}`)}this._enhanceText(this._getDetails());this._getNumericIndicators().setNumber(this.getNumber()).setNumberSize(this.getNumberSize()).setScale(this.getScale()).setTrend(this.getTrend()).setState(this.getState()).setSideIndicatorsAlignment(this.getSideIndicatorsAlignment()).setNumberVisible(this.getNumberVisible())};y.prototype.shouldShowIcon=function(){return this.getIconVisible()};y.prototype.enhanceAccessibilityState=function(t,e){if(t===this.getAggregation("_title")){e.role=this.getTitleAriaRole();e.level=this.getAriaHeadingLevel()}};y.prototype.getTitleId=function(){return this._getTitle().getId()};y.prototype._getTitle=function(){var t=this.getAggregation("_title");if(!t){t=new s({id:this.getId()+"-title",wrapping:true,maxLines:this.getTitleMaxLines()}).addStyleClass("sapFCardTitle");this.setAggregation("_title",t)}return t};y.prototype._getSubtitle=function(){var t=this.getAggregation("_subtitle");if(!t){t=new s({id:this.getId()+"-subtitle",wrapping:true,maxLines:this.getSubtitleMaxLines()});this.setAggregation("_subtitle",t)}return t};y.prototype._getAvatar=function(){var t=this.getAggregation("_avatar");if(!t){t=(new l).addStyleClass("sapFCardIcon");this.setAggregation("_avatar",t)}return t};y.prototype._getUnitOfMeasurement=function(){var t=this.getAggregation("_unitOfMeasurement");if(!t){t=new s({id:this.getId()+"-unitOfMeasurement",wrapping:false}).addStyleClass("sapFCardHeaderUnitOfMeasurement");this.setAggregation("_unitOfMeasurement",t)}return t};y.prototype._getDetails=function(){var t=this.getAggregation("_details");if(!t){t=new s(this._getDetailsId()).addStyleClass("sapFCardHeaderDetails");this.setAggregation("_details",t)}return t};y.prototype._getDetailsId=function(){return this.getId()+"-details"};y.prototype._getNumericIndicators=function(){var t=this.getAggregation("_numericIndicators");if(!t){t=new e;this.setAggregation("_numericIndicators",t)}return t};y.prototype._getAriaLabelledBy=function(){const t=[];if(this.getParent()&&this.getParent()._ariaText){t.push(this.getParent()._ariaText.getId())}if(this.getTitle()){t.push(this._getTitle().getId())}if(this.getSubtitle()){t.push(this._getSubtitle().getId())}if(this.getStatusText()){t.push(this.getId()+"-status")}if(this.getDataTimestamp()){t.push(this.getId()+"-dataTimestamp")}t.push(this._getUnitOfMeasurement().getId());if(this.getIconSrc()||this.getIconInitials()){t.push(this._getAvatar().getId())}if(this.getNumber()||this.getScale()){t.push(this._getNumericIndicators()._getMainIndicator().getId())}t.push(this._getSideIndicatorIds());if(this.getDetails()){t.push(this._getDetailsId())}t.push(this._getBannerLinesIds());return t.filter(t=>!!t).join(" ")};y.prototype._getSideIndicatorIds=function(){return this.getSideIndicators().map(function(t){return t.getId()}).join(" ")};y.prototype.isLoading=function(){return false};y.prototype.attachPress=function(){var e=Array.prototype.slice.apply(arguments);e.unshift("press");t.prototype.attachEvent.apply(this,e);this.invalidate();return this};y.prototype.detachPress=function(){var e=Array.prototype.slice.apply(arguments);e.unshift("press");t.prototype.detachEvent.apply(this,e);this.invalidate();return this};return y});
//# sourceMappingURL=NumericHeader.js.map