/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/IconPool","sap/ui/base/EventProvider","sap/ui/base/ManagedObjectObserver","sap/ui/Device","sap/ui/core/Lib","sap/ui/core/ShortcutHintsMixin","sap/ui/core/library","sap/m/library","sap/m/OverflowToolbarButton","sap/m/OverflowToolbarLayoutData","./SemanticContainer"],function(t,e,o,n,i,r,s,a,h,u,c){"use strict";var _=a.ButtonType;var l=s.aria.HasPopup;var p=c.extend("sap.f.semantic.SemanticShareMenu",{constructor:function(t,e){c.call(this,t,e);this._aShareMenuActions=[];this._aCustomShareActions=[];this._oObserver=new o(p.prototype._onShareMenuButtonChanges.bind(this));this._onShareButtonClickRef=this._onShareButtonClick.bind(this);this._setMode(p._Mode.initial)}});p._Mode={initial:"initial",menu:"menu"};p.prototype.addCustomAction=function(t){this._onControlAdded(t);this._oObserver.observe(t,{properties:["visible"]});this._callContainerAggregationMethod("insertButton",t,this._getCustomActionInsertIndex());this._aCustomShareActions.push(t);return this};p.prototype.insertCustomAction=function(t,e){if(this._aCustomShareActions.indexOf(t)<0){this._onControlAdded(t);this._oObserver.observe(t,{properties:["visible"]});this._aCustomShareActions.splice(e,0,t)}this._callContainerAggregationMethod("insertButton",t,this._getCustomActionInsertIndex(e));return this};p.prototype.getCustomActions=function(){return this._aCustomShareActions.slice()};p.prototype.indexOfCustomAction=function(t){return this._aCustomShareActions.indexOf(t)};p.prototype.removeCustomAction=function(t){var e=this._callContainerAggregationMethod("removeButton",t);this._oObserver.unobserve(t,{properties:["visible"]});this._aCustomShareActions.splice(this._aCustomShareActions.indexOf(t),1);this._onControlRemoved();return e};p.prototype.removeAllCustomActions=function(){var t=[];this._aCustomShareActions.forEach(function(e){var o=this._callContainerAggregationMethod("removeButton",e);if(o){t.push(e)}},this);this._aCustomShareActions=[];this._onControlRemoved();return t};p.prototype.destroyCustomActions=function(){this.removeAllCustomActions(true).forEach(function(t){t.destroy()});return this};p.prototype.addContent=function(t){var e=this._getControl(t);if(this._aShareMenuActions.indexOf(t)<0){this._onControlAdded(e);this._oObserver.observe(e,{properties:["visible"]});this._aShareMenuActions.push(t)}this._preProcessOverflowToolbarButton(e);this._callContainerAggregationMethod("insertButton",e,this._getSemanticActionInsertIndex(t));return this};p.prototype.removeContent=function(t){var e=this._getControl(t);this._oObserver.unobserve(e,{properties:["visible"]});this._callContainerAggregationMethod("removeButton",e);this._aShareMenuActions.splice(this._aShareMenuActions.indexOf(t),1);this._postProcessOverflowToolbarButton(t);this._onControlRemoved();return this};p.prototype.destroy=function(){if(this._oShareMenuBtn){this._oShareMenuBtn.destroy()}this._oShareMenuBtn=null;this._aShareMenuActions=null;this._aCustomShareActions=null;return c.prototype.destroy.call(this)};p.prototype.exit=function(){this._oObserver.disconnect();this._oObserver=null};p.prototype._getMode=function(){return this._mode};p.prototype._setMode=function(t){if(this._getMode()===t){return this}if(t===p._Mode.initial){if(this._getMode()){this._fireContentChanged(true)}this._mode=p._Mode.initial;return this}if(t===p._Mode.menu){this._mode=p._Mode.menu;this._fireContentChanged(false)}return this};p.prototype._fireContentChanged=function(t){e.prototype.fireEvent.call(this._getParent(),"_shareMenuContentChanged",{bEmpty:t})};p.prototype._onShareButtonClick=function(){var t=this._getContainer();t.openBy(this._oShareMenuBtn)};p.prototype._getVisibleActions=function(){var t=this._aShareMenuActions.concat(this._aCustomShareActions),e=t.map(function(t){return this._getControl(t)},this).filter(function(t){return t.getVisible()});return e};p.prototype._onShareMenuButtonChanges=function(){var t=this._getVisibleActions();this._getShareMenuButton().setVisible(t.length>1);this.fireEvent("_visibleActionsChanged",{visibleActionsCount:t.length})};p.prototype._getShareMenuButton=function(){var e,o,s;if(!this._oShareMenuBtn){e=this._getContainer();o=i.getResourceBundleFor("sap.f");s="SEMANTIC_CONTROL_ACTION_SHARE_SHORTCUT";if(n.os.macintosh){s+="_MAC"}this._oShareMenuBtn=new h(e.getId()+"-shareButton",{ariaHasPopup:l.Menu,icon:t.getIconURI("action"),tooltip:o.getText("SEMANTIC_CONTROL_ACTION_SHARE"),layoutData:new u({closeOverflowOnInteraction:false}),text:o.getText("SEMANTIC_CONTROL_ACTION_SHARE"),type:_.Transparent,press:this._onShareButtonClickRef});r.addConfig(this._oShareMenuBtn,{addAccessibilityLabel:true,message:o.getText(s)})}return this._oShareMenuBtn};p.prototype._getCustomActionInsertIndex=function(t){var e=this._aCustomShareActions.length;if(t===undefined){return this._aShareMenuActions.length+e}t=t>=e?e:t;t+=this._aShareMenuActions.length;return t};p.prototype._getSemanticActionInsertIndex=function(t){this._aShareMenuActions.sort(this._sortControlByOrder.bind(this));return this._aShareMenuActions.indexOf(t)};p.prototype._onControlAdded=function(t){if(this._isInitialMode()){this._setMode(p._Mode.menu,t)}};p.prototype._onControlRemoved=function(){var t=this._aShareMenuActions.length,e=this._aCustomShareActions.length,o=t+e===0;if(this._isMenuMode()&&o){this._setMode(p._Mode.initial)}};p.prototype._preProcessOverflowToolbarButton=function(t){if(t instanceof h){t._bInOverflow=true}};p.prototype._postProcessOverflowToolbarButton=function(t){if(t instanceof h){delete t._bInOverflow}};p.prototype._isInitialMode=function(){return this._getMode()===p._Mode.initial};p.prototype._isMenuMode=function(){return this._getMode()===p._Mode.menu};return p});
//# sourceMappingURL=SemanticShareMenu.js.map