/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Select","sap/ui/core/Element","sap/ui/core/InvisibleText","sap/ui/Device","sap/ui/core/Lib","./ActionSelectRenderer"],function(t,e,o,s,i,n){"use strict";var r=t.extend("sap.m.ActionSelect",{metadata:{library:"sap.m",associations:{buttons:{type:"sap.m.Button",multiple:true,singularName:"button"}}},renderer:n});r.prototype.init=function(){t.prototype.init.call(this);this.getList().addEventDelegate({onfocusin:this.onfocusinList},this)};r.prototype.hasContent=function(){return t.prototype.hasContent.call(this)||!!this.getButtons().length};r.prototype.addContentToFlex=function(){var t=this.getSimpleFixFlex();this.getButtons().forEach(function(o){t.addFlexContent(e.getElementById(o))})};r.prototype._onBeforeRenderingPopover=function(){t.prototype._onBeforeRenderingPopover.call(this);var e=this.getPicker();e&&e._setAriaRoleApplication(true);this._updateTutorMessage()};r.prototype.onAfterRenderingPicker=function(){t.prototype.onAfterRenderingPicker.call(this);var e=this.getPicker(),o=this.getRenderer();e.addStyleClass(o.CSS_CLASS+"Picker");e.addStyleClass(o.ACTION_SELECT_CSS_CLASS+"Picker");e.addStyleClass(o.ACTION_SELECT_CSS_CLASS+"Picker-CTX")};r.prototype.createPickerCloseButton=function(){};r.prototype.removeButton=function(t){var e=this.getSimpleFixFlex();if(e){if(typeof t==="number"){t=this.getButtons()[t]}e.removeFlexContent(t)}return this.removeAssociation("buttons",t)};r.prototype.removeAllButtons=function(){var t=this.getSimpleFixFlex();if(t){this.getButtons().forEach(function(o){t.removeFlexContent(e.getElementById(o))})}return this.removeAllAssociation("buttons")};r.prototype.onsaptabprevious=function(t){var o=this.getButtons(),s=this.getPicker(),i;this._bProcessChange=false;if(t.isMarked()||!this.getEnabled()){return}t.setMarked();if(s&&s.isOpen()&&o.length>0){for(i=o.length-1;i>=0;i--){if(e.getElementById(o[i]).getEnabled()){e.getElementById(o[i]).focus();t.preventDefault();break}}}};r.prototype.onsaptabnext=function(t){var o=this.getButtons(),s=this.getPicker(),i;this._bProcessChange=false;if(t.isMarked()||!this.getEnabled()){return}t.setMarked();if(s&&s.isOpen()&&o.length>0){for(i=0;i<o.length;i++){if(e.getElementById(o[i]).getEnabled()){e.getElementById(o[i]).focus();t.preventDefault();break}}}};r.prototype.onsapfocusleave=function(e){var o=this.getButtons();var s=o.indexOf(e.relatedControlId)===-1;if(s){t.prototype.onsapfocusleave.apply(this,arguments)}this._toggleListFocusIndication(true)};r.prototype.onfocusinList=function(t){if(document.activeElement!==this.getList().getDomRef()&&!s.system.phone){this.focus()}};r.prototype.onfocusin=function(){t.prototype.onfocusin.apply(this,arguments);this._toggleListFocusIndication(false)};r.prototype._toggleListFocusIndication=function(t){var e=this.getSelectedItem();if(this.isOpen()&&e){e.$().toggleClass("sapMActionSelectItemWithoutFocus",t)}};r.prototype._updateTutorMessage=function(){var t=this.getPicker(),e=t.getAriaLabelledBy(),s=!!this.getButtons().length,n;if(!this._sTutorMessageId){this._sTutorMessageId=this._getTutorMessageId();this._oTutorMessageText=new o(this._sTutorMessageId,{text:i.getResourceBundleFor("sap.m").getText("ACTION_SELECT_TUTOR_MESSAGE")}).toStatic()}n=e.indexOf(this._sTutorMessageId)===-1;if(n&&s){t.addAriaLabelledBy(this._sTutorMessageId)}else{if(!s){t.removeAriaLabelledBy(this._sTutorMessageId)}}};r.prototype._getTutorMessageId=function(){return this.getId()+"-tutorMessage"};r.prototype.exit=function(){t.prototype.exit.call(this);if(this._oTutorMessageText){this._oTutorMessageText.destroy();this._oTutorMessageText=null}};return r});
//# sourceMappingURL=ActionSelect.js.map