/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Dialog","./Popover","./library","sap/ui/core/Control","sap/ui/core/ControlBehavior","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/core/delegate/ItemNavigation","sap/ui/core/InvisibleText","sap/ui/Device","./ActionSheetRenderer","./Button","sap/ui/thirdparty/jquery"],function(t,e,n,i,o,s,a,r,p,l,c,h,jQuery){"use strict";var u=n.ButtonType;var f=n.DialogType;var d=n.PlacementType;var g=i.extend("sap.m.ActionSheet",{metadata:{library:"sap.m",properties:{placement:{type:"sap.m.PlacementType",group:"Appearance",defaultValue:d.Bottom},showCancelButton:{type:"boolean",group:"Appearance",defaultValue:true},cancelButtonText:{type:"string",group:"Appearance",defaultValue:null},title:{type:"string",group:"Appearance",defaultValue:null}},aggregations:{buttons:{type:"sap.m.Button",multiple:true,singularName:"button"},_cancelButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_invisibleAriaTexts:{type:"sap.ui.core.InvisibleText",multiple:true,visibility:"hidden"}},defaultAggregation:"buttons",events:{cancelButtonTap:{deprecated:true},beforeOpen:{},afterOpen:{},beforeClose:{parameters:{origin:{type:"sap.m.Button"}}},afterClose:{parameters:{origin:{type:"sap.m.Button"}}},cancelButtonPress:{}},designtime:"sap/m/designtime/ActionSheet.designtime"},renderer:c});g.prototype.init=function(){this._fnOrientationChange=this._orientationChange.bind(this);this._actionSelected=null};g.prototype.exit=function(){l.resize.detachHandler(this._fnOrientationChange);if(this._parent){this._parent.destroy();this._parent=null}if(this._oCancelButton){this._oCancelButton.destroy();this._oCancelButton=null}this._clearItemNavigation()};g.prototype._clearItemNavigation=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation}};g.prototype._setItemNavigation=function(){var t=this._getAllButtons(),e=[],n=this.getDomRef();if(n){this._oItemNavigation.setRootDomRef(n);for(var i=0;i<t.length;i++){if(t[i].getEnabled()&&t[i].getVisible()){e.push(t[i].getFocusDomRef())}}if(this._oCancelButton){e.push(this._oCancelButton.getFocusDomRef())}this._oItemNavigation.setItemDomRefs(e);this._oItemNavigation.setSelectedIndex(0);this._oItemNavigation.setPageSize(5);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]})}};g.prototype.onmousedown=function(t){if(t.srcControl.isA("sap.m.Button")&&this.getButtons().indexOf(t.srcControl)!==-1){this._actionSelected=t.srcControl}};g.prototype.onsaptabnext=function(t){t.preventDefault()};g.prototype.onsaptabprevious=function(t){t.preventDefault()};g.prototype.onBeforeRendering=function(){var t,e;this._clearItemNavigation();t=this.getTitle();if(this._parent&&!this.isPropertyInitial("title")&&this._parent.getTitle()!==t){if(l.system.phone){this._parent.setTitle(t);this._parent.setShowHeader(!!t)}if(t){this._parent.addStyleClass("sapMActionSheetDialogWithTitle")}else{this._parent.removeStyleClass("sapMActionSheetDialogWithTitle")}}e=this.getPlacement();if(this._parent&&!l.system.phone&&!this.isPropertyInitial("placement")&&this._parent.setPlacement()!==e){this._parent.setPlacement(e)}};g.prototype.onAfterRendering=function(){this._oItemNavigation=new r;this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation);this._setItemNavigation()};g.prototype.sapfocusleave=function(){this.close()};g.prototype.openBy=function(n){var i=this;if(!this._parent){var o=this.getParent();if(o){this.setParent(null)}if(!l.system.phone){this._parent=new e({placement:this.getPlacement(),showHeader:false,content:[this],beforeOpen:function(){i.fireBeforeOpen()},afterOpen:function(){i.focus();i.fireAfterOpen()},beforeClose:function(){i.fireBeforeClose()},afterClose:function(){if(i.getShowCancelButton()){i.fireCancelButtonTap();i.fireCancelButtonPress()}i._onAfterClose(i._actionSelected);i._actionSelected=null},ariaLabelledBy:this.getPopupHiddenLabelId()||undefined}).addStyleClass("sapMActionSheetPopover");this._parent._setAriaRoleApplication(true)}else{this._parent=new t({title:this.getTitle(),type:f.Standard,content:[this],beforeOpen:function(){i.fireBeforeOpen()},afterOpen:function(){i.focus();i.fireAfterOpen()},beforeClose:function(t){i.fireBeforeClose({origin:t.getParameter("origin")})},afterClose:function(t){i._actionSelected=t.getParameter("origin");i._onAfterClose(i._actionSelected);i._actionSelected=null;l.resize.detachHandler(i._fnOrientationChange)}}).addStyleClass("sapMActionSheetDialog");if(this.getTitle()){this._parent.addStyleClass("sapMActionSheetDialogWithTitle")}else{this._parent.addAriaLabelledBy(this.getPopupHiddenLabelId()||undefined)}if(!l.system.phone){this._parent.setBeginButton(this._getCancelButton())}if(l.system.phone){this._parent.oPopup.setModal(true);this._parent._setDimensions=function(){t.prototype._setDimensions.apply(this);this.$("cont").css("max-height","")};this._parent._adjustScrollingPane=function(){var t=this.$().height();this.$("cont").css("max-height",t);if(this._oScroller){this._oScroller.refresh()}}}}if(o){o.addDependent(this._parent)}}if(!l.system.phone){this._parent.openBy(n)}else{this._parent.open();l.resize.attachHandler(this._fnOrientationChange)}};g.prototype.close=function(){if(this._parent){this._parent.close()}};g.prototype.isOpen=function(){return!!this._parent&&this._parent.isOpen()};g.prototype._createCancelButton=function(){if(!this._oCancelButton){var t=this.getCancelButtonText()?this.getCancelButtonText():a.getResourceBundleFor("sap.m").getText("ACTIONSHEET_CANCELBUTTON_TEXT"),e=this;this._oCancelButton=new h(this.getId()+"-cancelBtn",{text:t,type:u.Reject,press:function(){if(l.system.phone&&e._parent){e._parent._oCloseTrigger=this}e.close();e.fireCancelButtonTap();e.fireCancelButtonPress()}}).addStyleClass("sapMActionSheetButton sapMActionSheetCancelButton sapMBtnTransparent sapMBtnInverted");if(l.system.phone){this.setAggregation("_cancelButton",this._oCancelButton,true)}}return this};g.prototype._getCancelButton=function(){if(l.system.phone&&this.getShowCancelButton()){this._createCancelButton();return this._oCancelButton}return null};g.prototype.setCancelButtonText=function(t){this.setProperty("cancelButtonText",t,true);if(this._oCancelButton){this._oCancelButton.setText(t)}return this};g.prototype._preProcessActionButton=function(t){var e=t.getType();if(e!==u.Accept&&e!==u.Reject){t.setType(u.Transparent)}t.addStyleClass("sapMBtnInverted");if(!t.getIcon()){t.addStyleClass("sapMActionSheetButtonNoIcon")}t.addStyleClass("sapMActionSheetButton");this._parent&&this._parent.invalidate();return this};g.prototype._buttonSelected=function(){if(l.system.phone&&this._parent){this._parent._oCloseTrigger=this}this.close()};g.prototype._orientationChange=function(){this._parent._adjustScrollingPane()};g.prototype._addAriaHiddenTexts=function(t){var e=t.getId(),n;if(o.isAccessibilityEnabled()){n=new p(e+"-actionSheetHiddenText");this.addAggregation("_invisibleAriaTexts",n,false);t.addAriaDescribedBy(n.getId())}};g.prototype._removeAriaHiddenTexts=function(t){t.getAriaDescribedBy().forEach(function(e){var n=s.getElementById(e);if(n instanceof p&&e.indexOf("actionSheetHiddenText")>-1){this.removeAggregation("_invisibleAriaTexts",n,false);t.removeAriaDescribedBy(n);n.destroy()}},this)};g.prototype.addButton=function(t){this.addAggregation("buttons",t,false);this._addAriaHiddenTexts(t);this._preProcessActionButton(t);t.attachPress(this._buttonSelected,this);return this};g.prototype.insertButton=function(t,e){this.insertAggregation("buttons",t,e,false);this._addAriaHiddenTexts(t);this._preProcessActionButton(t);t.attachPress(this._buttonSelected,this);return this};g.prototype.removeButton=function(t){var e=this.removeAggregation("buttons",t,false);if(e){e.detachPress(this._buttonSelected,this);this._removeAriaHiddenTexts(e)}return e};g.prototype.removeAllButtons=function(){var t=this.removeAllAggregation("buttons",false),e=this;jQuery.each(t,function(t,n){n.detachPress(e._buttonSelected,e);e._removeAriaHiddenTexts(n)});return t};g.prototype.clone=function(){var t=this.getButtons();for(var e=0;e<t.length;e++){t[e].detachPress(this._buttonSelected,this)}var n=i.prototype.clone.apply(this,arguments);for(var o=0;o<t.length;o++){t[o].attachPress(this._buttonSelected,this)}return n};g.prototype._getAllButtons=function(){return this.getButtons()};g.prototype.getPopupHiddenLabelId=function(){return p.getStaticId("sap.m","ACTIONSHEET_AVAILABLE_ACTIONS")};g.prototype._applyContextualSettings=function(){i.prototype._applyContextualSettings.call(this)};g.prototype._onAfterClose=function(t){this.fireAfterClose({origin:t})};return g});
//# sourceMappingURL=ActionSheet.js.map