/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/core/IconPool","./AvatarRenderer","sap/ui/core/Lib","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/core/Icon","./library","sap/ui/core/library","sap/ui/core/InvisibleText","sap/m/imageUtils/getCacheBustedUrl"],function(t,e,a,i,s,o,r,n,l,p,h){"use strict";var u=n.AvatarType;var c=n.AvatarImageFitType;var g=n.AvatarColor;var d=n.AvatarBadgeColor;var f=n.AvatarSize;var I=n.AvatarShape;var _=l.aria.HasPopup;var y=l.ValueState;var A=Object.keys(g).filter(function(t){return t.indexOf("Accent")!==-1});var v="sap-icon://avatar-icon-none";var b=t.extend("sap.m.Avatar",{metadata:{library:"sap.m",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},initials:{type:"string",group:"Data",defaultValue:null},displayShape:{type:"sap.m.AvatarShape",group:"Appearance",defaultValue:I.Circle},displaySize:{type:"sap.m.AvatarSize",group:"Appearance",defaultValue:f.S},customDisplaySize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"3rem"},customFontSize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"1.125rem"},imageFitType:{type:"sap.m.AvatarImageFitType",group:"Appearance",defaultValue:c.Cover},fallbackIcon:{type:"string",group:"Data",defaultValue:null},backgroundColor:{type:"sap.m.AvatarColor",group:"Appearance",defaultValue:g.Accent6},showBorder:{type:"boolean",group:"Appearance",defaultValue:false},badgeIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},badgeTooltip:{type:"string",group:"Data",defaultValue:null},decorative:{type:"boolean",group:"Accessibility",defaultValue:false},ariaHasPopup:{type:"sap.ui.core.aria.HasPopup",group:"Accessibility",defaultValue:_.None},badgeValueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:y.None},badgeIconColor:{type:"sap.m.AvatarBadgeColor",group:"Appearance",defaultValue:d.Accent6},enabled:{type:"boolean",group:"Behavior",defaultValue:true},active:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{detailBox:{type:"sap.m.LightBox",multiple:false,bindable:"bindable"},_badge:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_icon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}},dnd:{draggable:true,droppable:false},designtime:"sap/m/designtime/Avatar.designtime"},renderer:a});b.DEFAULT_CIRCLE_PLACEHOLDER="sap-icon://person-placeholder";b.DEFAULT_SQUARE_PLACEHOLDER="sap-icon://product";b.AVATAR_BADGE_TOOLTIP={"sap-icon://zoom-in":i.getResourceBundleFor("sap.m").getText("AVATAR_TOOLTIP_ZOOMIN"),"sap-icon://camera":i.getResourceBundleFor("sap.m").getText("AVATAR_TOOLTIP_CAMERA"),"sap-icon://edit":i.getResourceBundleFor("sap.m").getText("AVATAR_TOOLTIP_EDIT")};b.prototype.init=function(){this._sActualType=null;this._bIsDefaultIcon=true;this._sImageFallbackType=null;this._sPickedRandomColor=null;this._badgeRef=null;this._bImageLoadError=false};b.prototype.onBeforeRendering=function(){if(this._getImageCustomData()&&!this._iCacheBustingValue){this._setNewCacheBustingValue();this._validateSrc(this._getAvatarSrc())}};b.prototype.onAfterRendering=function(){this._checkInitialsHolderWidth();if(this._bImageLoadError){this._cleanCSS()}};b.prototype.setSrc=function(t){var a=e.isIconURI(t),i=this.getAggregation("detailBox");this._bImageLoadError=false;this.setProperty("src",t);this._validateSrc(this._getAvatarSrc());this._handleDetailBoxPress(a,i);return this};b.prototype.onThemeChanged=function(){this._checkInitialsHolderWidth()};b.prototype.exit=function(){if(this._fnLightBoxOpen){this._fnLightBoxOpen=null}if(this._badgeRef){this._badgeRef.destroy()}if(this._oInvisibleText){this._oInvisibleText.destroy();this._oInvisibleText=null}this._sPickedRandomColor=null};b.prototype.setDetailBox=function(t){var a=this.getDetailBox(),i=this.getSrc(),s=e.isIconURI(i);if(t){if(t===a){return this}this._handleDetailBoxPress(s,t)}else if(this._fnLightBoxOpen){this.detachPress(this._fnLightBoxOpen,a);this._fnLightBoxOpen=null}return this.setAggregation("detailBox",t)};b.prototype._handleDetailBoxPress=function(t,e){var a=this.getDetailBox();if(a){this.detachPress(this._fnLightBoxOpen,a)}if(!t&&e){this._fnLightBoxOpen=e.open;this.attachPress(this._fnLightBoxOpen,e)}};b.prototype.destroyDetailBox=function(){var t=this.getDetailBox();if(t){this.detachPress(this._fnLightBoxOpen,t);this._fnLightBoxOpen=null}return this.destroyAggregation("detailBox")};b.prototype.setBadgeValueState=function(t){Object.keys(y).forEach(function(e){this.toggleStyleClass("sapFAvatar"+e,e===t)}.bind(this));this.setProperty("badgeValueState",t,true);return this};b.prototype.setBadgeIconColor=function(t){Object.keys(d).forEach(function(t){if(t.indexOf("Accent")!==-1){this.removeStyleClass("sapFAvatarBadgeColor"+t)}}.bind(this));if(t&&t.indexOf("Accent")!==-1){this.addStyleClass("sapFAvatarBadgeColor"+t)}this.setProperty("badgeIconColor",t,true);return this};b.prototype.clone=function(){var e=t.prototype.clone.apply(this,arguments),a=e.getDetailBox();if(a){e.detachPress(this._fnLightBoxOpen,this.getDetailBox());e._fnLightBoxOpen=a.open;e.attachPress(e._fnLightBoxOpen,a)}return e};b.prototype.attachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);t.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")){this.$().attr("tabindex","0");this.$().attr("role","button")}return this};b.prototype.detachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);t.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")){this.$().removeAttr("tabindex");this.$().attr("role","img")}return this};b.prototype.ontap=function(){this._handlePress()};b.prototype.onkeydown=function(t){if(t.which===s.SHIFT||t.which===s.ESCAPE){this._bShouldInterupt=this._bSpacePressed}if(t.which===s.SPACE){this._bSpacePressed=true;t.preventDefault()}if(t.which===s.ENTER){this._handlePress()}};b.prototype.onkeyup=function(t){if(t.which===s.SPACE){if(!this._bShouldInterupt){this._handlePress()}this._bShouldInterupt=false;this._bSpacePressed=false;t.stopPropagation()}};b.prototype._handlePress=function(){if(!this.getEnabled()||this._bIsDefaultIcon&&this.getDetailBox()){return}this.firePress({})};b.prototype._areInitialsValid=function(t){var e=/^[a-zA-Z\xc0-\xd6\xd8-\xdc\xe0-\xf6\xf8-\xfc]{1,3}$/;if(!e.test(t)){o.warning("Initials should consist of only 1,2 or 3 latin letters",this);this._sActualType=u.Icon;this._bIsDefaultIcon=true;return false}return true};b.prototype._validateSrc=function(t){if(!t){return this}if(e.isIconURI(t)){this._sActualType=u.Icon;this._bIsDefaultIcon=e.getIconInfo(t)?false:true}else{this._sActualType=u.Image;this.preloadedImage=new window.Image;this.preloadedImage.src=t;this.preloadedImage.onload=this._onImageLoad.bind(this);this.preloadedImage.onerror=this._onImageError.bind(this,t)}return this};b.prototype._getDisplayIcon=function(t){return e.isIconURI(t)&&e.getIconInfo(t)?e.createControlByURI({src:t}):null};b.prototype._getActualDisplayType=function(){var t=this._getAvatarSrc(),e=this.getInitials();if(t){return this._sActualType}else if(e&&this._areInitialsValid(e)){this._sActualType=u.Initials}else{o.warning("No src and initials were provided",this);this._sActualType=u.Icon;this._bIsDefaultIcon=true}return this._sActualType};b.prototype._getImageFallbackType=function(){var t=this.getInitials();this._sImageFallbackType=t&&this._areInitialsValid(t)?u.Initials:u.Icon;return this._sImageFallbackType};b.prototype._getDefaultIconPath=function(t){var a=null,i=this.getFallbackIcon();if(i&&e.isIconURI(i)){a=i}else if(t===I.Circle){a=b.DEFAULT_CIRCLE_PLACEHOLDER}else if(t===I.Square){a=b.DEFAULT_SQUARE_PLACEHOLDER}return a};b.prototype._getIcon=function(){var t=this.getSrc(),a=this.getAggregation("_icon"),i=this.getDisplayShape(),s=e.isIconURI(t),o=this._getDefaultIconPath(i);if(this._bIsDefaultIcon){t=o}if(!a){a=e.createControlByURI({alt:"Image placeholder",src:s?t:o});this.setAggregation("_icon",a)}else if(a.getSrc()!==t&&(s||t===o)){a.setSrc(t)}return a};b.prototype._getDefaultTooltip=function(){return i.getResourceBundleFor("sap.m").getText("AVATAR_TOOLTIP")};b.prototype._getBadgeIconSource=function(){var t,a=this.getSrc(),i=e.isIconURI(a);if(this.getDetailBox()&&!i){t="sap-icon://zoom-in"}else if(this.getBadgeIcon()!==""){if(this._getDisplayIcon(this.getBadgeIcon())){t=this.getBadgeIcon()}else{o.warning("No valid Icon URI source for badge affordance was provided")}}return t};b.prototype._getBadgeTooltip=function(){var t=this._getDefaultTooltip(),e=this.getBadgeIcon();if(this.getBadgeTooltip()){t=this.getBadgeTooltip()}else if(e&&b.AVATAR_BADGE_TOOLTIP[this.getBadgeIcon()]){t=b.AVATAR_BADGE_TOOLTIP[e]}return t};b.prototype._handleEmptyBadgeIcon=function(){var t=this.getBadgeIcon(),e=this._getBadgeTooltip();if(t===v){if(!this._badgeRef){this.setAggregation("_badge",new r({src:"",tooltip:e}))}else{this._badgeRef.setTooltip(e)}this._badgeRef=this.getAggregation("_badge");return this._badgeRef}return null};b.prototype._getBadge=function(){var t=this._getBadgeIconSource(),e=this._getBadgeTooltip(),a=this._handleEmptyBadgeIcon();if(a){return a}if(!t){return}if(!this._badgeRef){this.setAggregation("_badge",new r({src:t,tooltip:e}))}this._badgeRef=this.getAggregation("_badge");return this._badgeRef};b.prototype._onImageLoad=function(){if(this._bIsDefaultIcon){this._bIsDefaultIcon=false;this.getDetailBox()&&this.invalidate()}this._bImageLoadError=false;delete this.preloadedImage};b.prototype._onImageError=function(t){if(this.getSrc()!==t){return}this._cleanCSS();if(!this._bIsDefaultIcon){this._bIsDefaultIcon=true;this.getDetailBox()&&this.invalidate()}delete this.preloadedImage;this._bImageLoadError=true};b.prototype._cleanCSS=function(){var t=this._getImageFallbackType();this.$().removeClass("sapFAvatarImage").addClass("sapFAvatar"+t)};b.prototype._getActualBackgroundColor=function(){var t=this.getBackgroundColor();if(t===g.Random){if(this._sPickedRandomColor){return this._sPickedRandomColor}t=this._sPickedRandomColor=g[A[A.length*Math.random()<<0]]}else{this._sPickedRandomColor=null}return t};b.prototype._checkInitialsHolderWidth=function(){var t=this.$(),e=this.getInitials().length;this.$oInitialsHolder=t.children(".sapFAvatarInitialsHolder");if(this.$oInitialsHolder.length!==0&&e===3){var a=t[0].offsetWidth,i=this.$oInitialsHolder[0].offsetWidth;if(i>=a){this._wideInitialsIcon()}}};b.prototype._wideInitialsIcon=function(){var t=this.$(),e=t.children(".sapFAvatarHiddenIcon");e.removeClass("sapFAvatarHiddenIcon");this.$oInitialsHolder.css("display","none");t.removeClass("sapFAvatarInitials");t.addClass("sapFAvatarIcon")};b.prototype._getInvisibleText=function(){if(!this._oInvisibleText&&this.sInitials){this._oInvisibleText=new p({id:this.getId()+"-InvisibleText"});this._oInvisibleText.setText(this.sInitials).toStatic()}return this._oInvisibleText};b.prototype._getAriaLabelledBy=function(){var t=this.getAriaLabelledBy(),e;this.sInitials=this.getInitials();if(this.sInitials&&t.length>0){e=this._getInvisibleText().getId();t.push(e)}return t};b.prototype._getImageCustomData=function(t){var e=this.getCustomData().filter(function(t){return t.isA("sap.m.ImageCustomData")});return e.length?e[0]:undefined};b.prototype._setNewCacheBustingValue=function(){if(this._getImageCustomData()){this._iCacheBustingValue=Date.now()}};b.prototype._getAvatarSrc=function(){var t=this._getImageCustomData(),e=this.getSrc();if(t&&e){var a={sUrl:e,sParamName:t.getParamName(),sParamValue:this._iCacheBustingValue};return h(a)}return e};b.prototype.refreshAvatarCacheBusting=function(){this._setNewCacheBustingValue();this._validateSrc(this._getAvatarSrc());this.invalidate()};return b});
//# sourceMappingURL=Avatar.js.map