/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/core/Lib","sap/ui/core/ShortcutHintsMixin","sap/ui/core/EnabledPropagator","sap/ui/core/AccessKeysEnablement","sap/ui/core/IconPool","sap/ui/Device","sap/ui/core/ContextMenuSupport","sap/ui/core/library","./ButtonRenderer","sap/ui/events/KeyCodes","sap/ui/core/LabelEnablement","sap/m/BadgeEnabler","sap/ui/core/InvisibleText","sap/base/Log","sap/m/Image"],function(e,t,i,s,a,n,o,r,u,c,l,h,p,g,d,f,_){"use strict";var b=c.TextDirection;var y=e.ButtonType;var m=e.ButtonAccessibilityType;var v=e.ButtonAccessibleRole;var B=e.BadgeState;var I=e.BadgeStyle;var T=c.aria.HasPopup;var A=1,S=9999;var E=t.extend("sap.m.Button",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.ui.core.IAccessKeySupport","sap.m.IToolbarInteractiveControl"],library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:""},type:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:y.Default},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},iconFirst:{type:"boolean",group:"Appearance",defaultValue:true},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:b.Inherit},ariaHasPopup:{type:"sap.ui.core.aria.HasPopup",group:"Accessibility",defaultValue:T.None},accessibleRole:{type:"sap.m.ButtonAccessibleRole",group:"Accessibility",defaultValue:v.Default},highlightAccKeysRef:{type:"boolean",defaultValue:false,visibility:"hidden"},accesskey:{type:"string",defaultValue:"",visibility:"hidden"},badgeStyle:{type:"sap.m.BadgeStyle",group:"Misc",defaultValue:I.Default}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tap:{deprecated:true},press:{}},designtime:"sap/m/designtime/Button.designtime",dnd:{draggable:true,droppable:false}},renderer:l});a.call(E.prototype);u.apply(E.prototype);g.call(E.prototype);E.prototype.init=function(){this._onmouseenter=this._onmouseenter.bind(this);this._buttonPressed=false;s.addConfig(this,{event:"press",position:"0 0",addAccessibilityLabel:true},this);this.initBadgeEnablement({position:"topRight",selector:{suffix:"inner"},style:this.getBadgeStyle()});this._oBadgeData={value:"",state:""};this._badgeMinValue=A;this._badgeMaxValue=S;n.registerControl(this)};E.prototype.setBadgeStyle=function(e){this._oBadgeConfig.style=e;this.setProperty("badgeStyle",e);return this};E.prototype.badgeValueFormatter=function(e){var t=parseInt(e),i=this.getBadgeCustomData(),s=i.getVisible();if(isNaN(t)){return false}if(t<this._badgeMinValue){s&&i.setVisible(false)}else{!s&&i.setVisible(true);if(t>this._badgeMaxValue&&e.indexOf("+")===-1){e=this._badgeMaxValue<1e3?this._badgeMaxValue+"+":"999+"}}return e};E.prototype.setBadgeMinValue=function(e){var t=this.getBadgeCustomData().getValue();if(e&&!isNaN(e)&&e>=A&&e!=this._badgeMinValue&&e<=this._badgeMaxValue){this._badgeMinValue=e;this.badgeValueFormatter(t);this.invalidate()}else{f.warning("minValue is not valid (it is is less than minimum allowed badge value ["+A+"] or greater than maximum badge value ["+this._badgeMaxValue+"])",this)}return this};E.prototype.setBadgeMaxValue=function(e){if(e&&!isNaN(e)&&e<=S&&e!=this._badgeMaxValue&&e>=this._badgeMinValue){this._badgeMaxValue=e;this.invalidate()}else{f.warning("maxValue is not valid (it is is greater than than maximum allowed badge value ["+S+"] or less than minimum badge value ["+this._badgeMinValue+"])",this)}return this};E.prototype.onBadgeUpdate=function(e,t){if(this._oBadgeData.value!==e||this._oBadgeData.state!==t){if(t===B.Disappear){e=""}this._updateBadgeInvisibleText(e);this._oBadgeData={value:e,state:t}}};E.prototype._updateBadgeInvisibleText=function(e){var t=i.getResourceBundleFor("sap.m"),s,a;e=e.toString().trim();a=e.indexOf("+");if(a!==-1){s=t.getText("BUTTON_BADGE_MORE_THAN_ITEMS",[e.substr(0,a)])}else{switch(e){case"":s="";break;case"1":s=t.getText("BUTTON_BADGE_ONE_ITEM",[e]);break;default:s=t.getText("BUTTON_BADGE_MANY_ITEMS",[e])}}this._getBadgeInvisibleText().setText(s)};E.prototype._getBadgeInvisibleText=function(){if(!this._oBadgeInvisibleText){this._oBadgeInvisibleText=new d(this.getId()+"-badge").toStatic()}return this._oBadgeInvisibleText};E.prototype.exit=function(){if(this._image){this._image.destroy()}if(this._iconBtn){this._iconBtn.destroy()}if(this._oBadgeInvisibleText){this._oBadgeInvisibleText.destroy();this._oBadgeData=null}this._bFocused=null;this.$().off("mouseenter",this._onmouseenter)};E.prototype.setType=function(e){this.setProperty("type",e);switch(e){case y.Critical:this._sTypeIconURI="sap-icon://alert";break;case y.Negative:this._sTypeIconURI="sap-icon://error";break;case y.Success:this._sTypeIconURI="sap-icon://sys-enter-2";break;case y.Neutral:this._sTypeIconURI="sap-icon://information";break;case y.Back:case y.Up:this._sTypeIconURI="sap-icon://nav-back";break;default:this._sTypeIconURI=null}return this};E.prototype.onBeforeRendering=function(){this._bRenderActive=this._bActive;this._updateAccessKey();this.$().off("mouseenter",this._onmouseenter)};E.prototype._updateAccessKey=function(){var e=this.getText();if(e){this.setProperty("accesskey",e[0].toLowerCase())}};E.prototype.onAfterRendering=function(){if(this._bRenderActive){this._activeButton();this._bRenderActive=this._bActive}if(this._bFocused){this._toggleLiveChangeAnnouncement("polite")}this.$().on("mouseenter",this._onmouseenter)};E.prototype.ontouchstart=function(e){e.setMarked();if(this._bRenderActive){delete this._bRenderActive}if(e.targetTouches.length===1){this._buttonPressed=true;this._activeButton()}if(this.getEnabled()&&this.getVisible()){if((r.browser.safari||r.browser.firefox)&&(e.originalEvent&&e.originalEvent.type==="mousedown")){this._setButtonFocus()}this._sTouchStartTargetId=e.target.id.replace(this.getId(),"")}else{this._sTouchStartTargetId=""}};E.prototype.ontouchend=function(e){var t,i,s=e.which===3||e.ctrlKey&&e.which===1;this._buttonPressed=e.originalEvent&&e.originalEvent.buttons&1;this._inactiveButton();if(this._bRenderActive){delete this._bRenderActive;if(!s){this.ontap(e,true)}}t=e.target.id.replace(this.getId(),"");i=this._buttonPressed===0&&!s&&(this._sTouchStartTargetId==="-BDI-content"&&["-content","-inner","-img"].includes(t)||this._sTouchStartTargetId==="-content"&&["-inner","-img"].includes(t)||this._sTouchStartTargetId==="-img"&&t!=="-img");if(i){this.ontap(e,true)}this._sTouchStartTargetId=""};E.prototype.ontouchcancel=function(){this._buttonPressed=false;this._sTouchStartTargetId="";this._inactiveButton()};E.prototype.ontap=function(e,t){e.setMarked();delete this._bRenderActive;if(this.bFromTouchEnd){return}if(this.getEnabled()&&this.getVisible()){if(r.system.desktop&&(e.originalEvent&&e.originalEvent.type==="touchend")){this.focus()}this.fireTap({});this.firePress({})}this.bFromTouchEnd=t;if(this.bFromTouchEnd){setTimeout(function(){delete this.bFromTouchEnd}.bind(this),0)}};E.prototype.onkeydown=function(e){if((e.which===h.SPACE||e.which===h.ENTER||e.which===h.ESCAPE||e.which===h.SHIFT)&&!e.ctrlKey&&!e.metaKey){if(e.which===h.SPACE||e.which===h.ENTER){e.setMarked();this._activeButton()}if(e.which===h.ENTER){this.firePress({})}if(e.which===h.SPACE){this._bPressedSpace=true}if(this._bPressedSpace){if(e.which===h.SHIFT||e.which===h.ESCAPE){this._bPressedEscapeOrShift=true;this._inactiveButton()}}}else{if(this._bPressedSpace){e.preventDefault()}}};E.prototype.onkeyup=function(e){if(e.which===h.ENTER){e.setMarked();this._inactiveButton()}if(e.which===h.SPACE){if(!this._bPressedEscapeOrShift){e.setMarked();this._inactiveButton();this.firePress({})}else{this._bPressedEscapeOrShift=false}this._bPressedSpace=false}if(e.which===h.ESCAPE){this._bPressedSpace=false}};E.prototype._onmouseenter=function(e){if(this._buttonPressed&&e.originalEvent&&e.originalEvent.buttons&1){this._activeButton()}};E.prototype.onfocusin=function(){this._bFocused=true;this._toggleLiveChangeAnnouncement("polite")};E.prototype.onfocusout=function(){this._buttonPressed=false;this._bFocused=false;this._sTouchStartTargetId="";this._inactiveButton();this._toggleLiveChangeAnnouncement("off")};E.prototype._toggleLiveChangeAnnouncement=function(e){if(this._getText()){this.$("BDI-content").attr("aria-live",e)}else if(this._getAppliedIcon()){this.$("tooltip").attr("aria-live",e)}};E.prototype._activeButton=function(){if(!this._isUnstyled()){this.$("inner").addClass("sapMBtnActive")}this._bActive=this.getEnabled();if(this._bActive){if(this._getAppliedIcon()&&this.getActiveIcon()&&this._image){this._image.setSrc(this.getActiveIcon())}}};E.prototype._inactiveButton=function(){if(!this._isUnstyled()){this.$("inner").removeClass("sapMBtnActive")}this._bActive=false;if(this.getEnabled()){if(this._getAppliedIcon()&&this.getActiveIcon()&&this._image){this._image.setSrc(this._getAppliedIcon())}}};E.prototype._isHoverable=function(){return this.getEnabled()&&r.system.desktop};E.prototype._getImage=function(e,t,i,s){var a=o.isIconURI(t),n;if(this._image&&this._image.isA("sap.m.Image")&&a||this._image&&this._image.isA("sap.ui.core.Icon")&&!a){this._image.destroy();this._image=undefined}n=this.getIconFirst();if(this._image){this._image.setSrc(t);if(this._image.isA("sap.m.Image")){this._image.setActiveSrc(i);this._image.setDensityAware(s)}}else{this._image=o.createControlByURI({id:e,src:t,activeSrc:i,densityAware:s,useIconTooltip:false},_).addStyleClass("sapMBtnCustomIcon").setParent(this,null,true)}this._image.addStyleClass("sapMBtnIcon");this._image.toggleStyleClass("sapMBtnIconLeft",n);this._image.toggleStyleClass("sapMBtnIconRight",!n);return this._image};E.prototype._getInternalIconBtn=function(e,t){var i=this._iconBtn;if(i){i.setSrc(t)}else{i=o.createControlByURI({id:e,src:t,useIconTooltip:false},_).setParent(this,null,true)}i.addStyleClass("sapMBtnIcon");i.addStyleClass("sapMBtnIconLeft");this._iconBtn=i;return this._iconBtn};E.prototype._isUnstyled=function(){var e=false;if(this.getType()===y.Unstyled){e=true}return e};E.prototype.getPopupAnchorDomRef=function(){return this.getDomRef("inner")};E.prototype._getText=function(){return this.getText()};E.prototype._getTooltip=function(){var e,t;e=this.getTooltip_AsString();if(!e&&!this._getText()){t=o.getIconInfo(this._getAppliedIcon());if(t){e=t.text?t.text:t.name}}return e};E.prototype._getAppliedIcon=function(){return this.getIcon()||this._sTypeIconURI};E.prototype.getAccessibilityInfo=function(){var e=this._getText()||this.getTooltip_AsString(),t=this.getAccessibleRole();if(!e&&this._getAppliedIcon()){var s=o.getIconInfo(this._getAppliedIcon());if(s){e=s.text||s.name}}return{role:t===v.Default?"button":t.toLowerCase(),type:i.getResourceBundleFor("sap.m").getText("ACC_CTR_TYPE_BUTTON"),description:e,focusable:this.getEnabled(),enabled:this.getEnabled()}};E.prototype._setButtonFocus=function(){setTimeout(function(){this.focus()}.bind(this),0)};E.prototype._determineSelfReferencePresence=function(){var e=this.getAriaLabelledBy(),t=e.indexOf(this.getId())!==-1,i=p.getReferencingLabels(this).length>0,s=this.getParent(),a=!!(s&&s.enhanceAccessibilityState);return!t&&this._getText()&&(e.length>0||i||a||this._isBadgeButton())};E.prototype._determineAccessibilityType=function(){var e=this.getAriaLabelledBy().length>0,t=this.getAriaDescribedBy().length>0,i=p.getReferencingLabels(this).length>0,s=this.getType()!==y.Default,a=e||i||this._determineSelfReferencePresence(),n=t||s||this._isBadgeButton(),o;if(!a&&!n){o=m.Default}else if(a&&!n){o=m.Labelled}else if(!a&&n){o=m.Described}else if(a&&n){o=m.Combined}return o};E.prototype._isBadgeButton=function(){return this._oBadgeData&&this._oBadgeData.value!==""&&this._oBadgeData.State!==B.Disappear};E.prototype._getTitleAttribute=function(e){return this.getTooltip()};E.prototype._getToolbarInteractive=function(){return true};return E});
//# sourceMappingURL=Button.js.map