/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/base/i18n/Localization","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/Theming","sap/ui/Device","sap/ui/core/Lib","sap/ui/core/ResizeHandler","sap/ui/core/library","sap/m/IllustratedMessage","sap/m/IllustratedMessageType","./CarouselRenderer","sap/ui/events/KeyCodes","sap/base/Log","sap/base/util/isPlainObject","sap/m/ImageHelper","sap/ui/thirdparty/jquery","sap/ui/core/IconPool","./CarouselLayout","sap/ui/dom/jquery/Selectors"],function(e,t,i,s,a,r,o,n,h,g,l,d,u,p,c,f,jQuery){"use strict";var _=h.BusyIndicatorSize;var I=e.CarouselArrowsPlacement;var m=e.CarouselPageIndicatorPlacementType;var P=e.BackgroundDesign;var A=e.BorderDesign;var v=e.CarouselScrollMode;var y=10;var C=20;var T=t.getRTL();function S(e){e=e.originalEvent||e;var t=e.touches&&e.touches[0];return{x:t?t.clientX:e.clientX,y:t?t.clientY:e.clientY}}function b(e,t){e.style["transform"]="translate3d("+t+"px, 0, 0)"}var D=i.extend("sap.m.Carousel",{metadata:{library:"sap.m",designtime:"sap/m/designtime/Carousel.designtime",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},loop:{type:"boolean",group:"Misc",defaultValue:false},showPageIndicator:{type:"boolean",group:"Appearance",defaultValue:true},pageIndicatorPlacement:{type:"sap.m.CarouselPageIndicatorPlacementType",group:"Appearance",defaultValue:m.Bottom},showBusyIndicator:{type:"boolean",group:"Appearance",defaultValue:true,deprecated:true},arrowsPlacement:{type:"sap.m.CarouselArrowsPlacement",group:"Appearance",defaultValue:I.Content},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:P.Translucent},pageIndicatorBackgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:P.Solid},pageIndicatorBorderDesign:{type:"sap.m.BorderDesign",group:"Appearance",defaultValue:A.Solid}},defaultAggregation:"pages",aggregations:{pages:{type:"sap.ui.core.Control",multiple:true,singularName:"page"},customLayout:{type:"sap.m.CarouselLayout",multiple:false},_emptyPage:{type:"sap.m.IllustratedMessage",multiple:false,visibility:"hidden"}},associations:{activePage:{type:"sap.ui.core.Control",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{loadPage:{deprecated:true,parameters:{pageId:{type:"string"}}},unloadPage:{deprecated:true,parameters:{pageId:{type:"string"}}},pageChanged:{parameters:{oldActivePageId:{type:"string"},newActivePageId:{type:"string"},activePages:{type:"array"}}},beforePageChanged:{parameters:{activePages:{type:"array"}}}}},renderer:d});D._INNER_SELECTOR=".sapMCrslInner";D._PAGE_INDICATOR_SELECTOR=".sapMCrslBulleted";D._PAGE_INDICATOR_ARROWS_SELECTOR=".sapMCrslIndicatorArrow";D._CONTROLS=".sapMCrslControls";D._ITEM_SELECTOR=".sapMCrslItem";D._LEFTMOST_CLASS="sapMCrslLeftmost";D._RIGHTMOST_CLASS="sapMCrslRightmost";D._MODIFIERNUMBERFORKEYBOARDHANDLING=10;D._BULLETS_TO_NUMBERS_THRESHOLD=9;D.prototype.init=function(){this._aAllActivePages=[];this._aAllActivePagesIndexes=[];this._iFocusedPageIndex=-1;this._bShouldFireEvent=true;this._handleThemeAppliedBound=this._handleThemeApplied.bind(this);this.data("sap-ui-fastnavgroup","true",true);this._oRb=o.getResourceBundleFor("sap.m")};D.prototype.exit=function(){if(this._oArrowLeft){this._oArrowLeft.destroy();delete this._oArrowLeft}if(this._oArrowRight){this._oArrowRight.destroy();delete this._oArrowRight}if(this._sResizeListenerId){n.deregister(this._sResizeListenerId);this._sResizeListenerId=null}this.$().off("afterSlide");this._aAllActivePages=null;this._aAllActivePagesIndexes=null;if(this._bThemeAppliedAttached){a.detachApplied(this._handleThemeAppliedBound);this._bThemeAppliedAttached=false}};D.prototype.onBeforeRendering=function(){if(!this.getActivePage()&&this.getPages().length>0){this.setAssociation("activePage",this.getPages()[0].getId(),true)}var e=this.getActivePage();if(e){this._updateActivePages(e);if(this._iFocusedPageIndex===-1){this._iFocusedPageIndex=this._aAllActivePagesIndexes[0]}}if(this._sResizeListenerId){n.deregister(this._sResizeListenerId);this._sResizeListenerId=null}return this};D.prototype._resize=function(){var e=this.$().find("> .sapMCrslInner");if(this._iResizeTimeoutId){clearTimeout(this._iResizeTimeoutId);delete this._iResizeTimeoutId}e.addClass("sapMCrslNoTransition");e.addClass("sapMCrslHideNonActive");if(this.getPages().length>1){this._setWidthOfPages(this._getNumberOfItemsToShow())}this._updateTransformValue();this._iResizeTimeoutId=setTimeout(function(){e.removeClass("sapMCrslNoTransition");e.removeClass("sapMCrslHideNonActive")})};D.prototype._getNumberOfItemsToShow=function(){var e=this.getPages().length,t=this.getCustomLayout(),i=1;if(t&&t.isA("sap.m.CarouselLayout")){i=Math.max(t.getVisiblePagesCount(),1)}if(i>1&&e<i){return e}return i};D.prototype.onAfterRendering=function(){var e=this._getActivePageIndex();var t=this.$().find(D._INNER_SELECTOR)[0];var i=this.getPages().length;if(!i){return}this._iCurrSlideIndex=Math.min(e,i-this._getNumberOfItemsToShow());if(this.getPages().length&&this.getPages()[this._getPageIndex(this.getActivePage())].getId()!==this.getActivePage()){this.setAssociation("activePage",this.getPages()[e].getId(),true)}if(!this._bThemeAppliedAttached){this._bThemeAppliedAttached=true;a.attachApplied(this._handleThemeAppliedBound)}this._sResizeListenerId=n.register(t,this._resize.bind(this))};D.prototype.getFocusDomRef=function(){if(!this.getPages().length){return this.getDomRef("noData")}if(this._iFocusedPageIndex===-1){return null}const e=this.getPages()[this._iFocusedPageIndex].getId();return this.getDomRef(e+"-slide")};D.prototype._handleThemeApplied=function(){this._initialize();a.detachApplied(this._handleThemeAppliedBound);this._bThemeAppliedAttached=false};D.prototype._onBeforePageChanged=function(e,t){var i=this.getPages()[t].getId();this._updateActivePages(i);this.fireBeforePageChanged({activePages:this._aAllActivePagesIndexes})};D.prototype._setWidthOfPages=function(e){var t=this.$().find(".sapMCrslItem"),i;if(!t.length){return}i=this._calculatePagesWidth(e);t.each(function(e,t){t.style.width=i+"%"})};D.prototype._calculatePagesWidth=function(e){var t=this.$().width(),i=this.getDomRef().querySelector(".sapMCrslFluid .sapMCrslItem"),s=parseFloat(window.getComputedStyle(i).marginRight),a=(t-s*(e-1))/e,r=a/t*100;return r};D.prototype._moveToPage=function(e,t){if(!this._bIsInitialized||this.getPages().length===0){return}var i=this.$(),s=i.find("> .sapMCrslInner"),a=s.children(),r=this._iCurrSlideIndex,o=a.length,n=this._getNumberOfItemsToShow(),h=this.getLoop(),g=this.getDomRef().contains(document.activeElement);if(h&&n!==1&&(e<0||e>o-1)){return}if(e<0){if(h){e=o-1}else{e=0}}else if(e>o-1){if(h){e=0}else{e=o-1}}if(e+n>o-1){e=o-n}var l=true;if(e===r){l=false}if(l){this._onBeforePageChanged(r,e)}this._iOffsetDrag=0;this._iCurrSlideIndex=e;this._updateTransformValue();this._initActivePages();this._updateItemsAttributes(t);if(l){this._changeActivePage(this._aAllActivePagesIndexes[0])}if(g||this._bPageIndicatorArrowPress){this._focusPage(t);this._bPageIndicatorArrowPress=false}};D.prototype._changeActivePage=function(e){var t=this.getActivePage();if(this._sOldActivePageId){t=this._sOldActivePageId;delete this._sOldActivePageId}var i=this.getPages()[e].getId();this.setAssociation("activePage",i,true);if(!r.system.desktop){jQuery(document.activeElement).trigger("blur")}if(this._bShouldFireEvent){p.debug("sap.m.Carousel: firing pageChanged event: old page: "+t+", new page: "+i);this.firePageChanged({oldActivePageId:t,newActivePageId:i,activePages:this._aAllActivePagesIndexes})}this._adjustArrowsVisibility();this._updatePageIndicator()};D.prototype._focusPage=function(e){this._iFocusedPageIndex=e;const t=this.getDomRef(this.getPages()[e].getId()+"-slide");if(!t.contains(document.activeElement)){t.focus({preventScroll:true})}};D.prototype._updateItemsAttributes=function(e){this.$().find(D._ITEM_SELECTOR).each(function(t,i){var s=t===e;i.setAttribute("aria-selected",s);i.setAttribute("aria-hidden",!this._isPageDisplayed(t));i.setAttribute("tabindex",s?0:-1)}.bind(this))};D.prototype._updatePageIndicator=function(){this.$("slide-number").text(this._getPageIndicatorText(this._iCurrSlideIndex+1))};D.prototype._getPageIndicatorText=function(e){return this._oRb.getText("CAROUSEL_PAGE_INDICATOR_TEXT",[e,this.getPages().length-this._getNumberOfItemsToShow()+1])};D.prototype._adjustArrowsVisibility=function(){if(this._loops()||this.getPages().length<=1){return}var e=this.$("hud");var t=this.$("arrow-previous");var i=this.$("arrow-next");var s=this._aAllActivePagesIndexes[0];var a=this._aAllActivePagesIndexes[this._aAllActivePagesIndexes.length-1];if(this.getArrowsPlacement()===I.Content){e.removeClass(D._LEFTMOST_CLASS).removeClass(D._RIGHTMOST_CLASS)}else{t.removeClass(D._LEFTMOST_CLASS);i.removeClass(D._RIGHTMOST_CLASS)}if(s===0){if(this.getArrowsPlacement()===I.Content){e.addClass(D._LEFTMOST_CLASS)}else{t.addClass(D._LEFTMOST_CLASS)}}if(a===this.getPages().length-1){if(this.getArrowsPlacement()===I.Content){e.addClass(D._RIGHTMOST_CLASS)}else{i.addClass(D._RIGHTMOST_CLASS)}}};D.prototype.setActivePage=function(e){var t=null;if(typeof e=="string"){t=e}else if(e instanceof i){t=e.getId()}if(t){if(t===this.getActivePage()){return this}var s=this._getPageIndex(t);this._sOldActivePageId=this.getActivePage();this._moveToPage(s,s)}this.setAssociation("activePage",t,true);return this};D.prototype._getNavigationArrow=function(e){if(!this["_oArrow"+e]){this["_oArrow"+e]=f.getImageControl(this.getId()+"-arrowScroll"+e,this["_oArrow"+e],this,{src:"sap-icon://slim-arrow-"+e.toLowerCase(),useIconTooltip:false})}return this["_oArrow"+e]};D.prototype._getEmptyPage=function(){if(!this.getAggregation("_emptyPage")){var e=new g({illustrationType:l.NoData,enableVerticalResponsiveness:true});this.setAggregation("_emptyPage",e)}return this.getAggregation("_emptyPage")};D.prototype._calculateSlideIndex=function(e,t){const i=this.getCustomLayout();let s;if(i&&i.getScrollMode()===v.VisiblePages){const i=this._getNumberOfItemsToShow();s=t>0?e+i:Math.max(0,e-i)}else{s=t>0?e+1:e-1}return s};D.prototype.previous=function(){const e=this._calculateSlideIndex(this._iCurrSlideIndex,-1);let t=this._iFocusedPageIndex;if(this._aAllActivePagesIndexes.at(-1)===this._iFocusedPageIndex){t=this._iFocusedPageIndex-1}this._moveToPage(e,this._makeInRange(t,false));return this};D.prototype.next=function(){const e=this._calculateSlideIndex(this._iCurrSlideIndex,1);let t=this._iFocusedPageIndex;if(this._aAllActivePagesIndexes[0]===this._iFocusedPageIndex){t=this._iFocusedPageIndex+1}this._moveToPage(e,this._makeInRange(t,false));return this};D.prototype._getPageIndex=function(e){var t,i=0;for(t=0;t<this.getPages().length;t++){if(this.getPages()[t].getId()===e){i=t;break}}return i};D.prototype._getActivePageIndex=function(){var e=0,t=this.getActivePage();if(t){e=this._getPageIndex(t)}return e};D.prototype.ontouchstart=function(e){if(!this.getPages().length||!this._bIsInitialized){return}const t=e.target.tagName.toLowerCase();if(["input","textarea","select"].indexOf(t)>-1||e.target.isContentEditable){return}if(this._isPageIndicatorArrow(e.target)){this._bPageIndicatorArrowPress=true;e.preventDefault();return}if(e.target.draggable){e.target.draggable=false}if(e.isMarked("delayedMouseEvent")){return}var i=s.closestTo(e.target);if(i&&(i.isA("sap.m.Slider")||i.isA("sap.m.Switch")||i.isA("sap.m.IconTabBar"))){this._bDragCanceled=true;return}this._bDragging=true;this._bDragCanceled=false;this._mCurrentXY=S(e);this._iDx=0;this._iDy=0;this._bDragThresholdMet=false;this.$().addClass("sapMCrslDragging");this._bLockLeft=this._iCurrSlideIndex===1;this._bLockRight=this._iCurrSlideIndex===this.getPages().length-1};D.prototype.ontouchmove=function(e){if(this._isPageIndicatorArrow(e.target)){return}if(!this._bDragging||this._bDragCanceled||e.isMarked("delayedMouseEvent")){return}e.setMarked();var t=this.$().width();var i=S(e);this._iDx=this._mCurrentXY.x-i.x;this._iDy=this._mCurrentXY.y-i.y;if(this._bDragThresholdMet||Math.abs(this._iDx)>Math.abs(this._iDy)&&Math.abs(this._iDx)>y){this._bDragThresholdMet=true;if(c(e.touches[0])){e.preventDefault()}if(this._bLockLeft&&this._iDx<0){this._iDx=this._iDx*-t/(this._iDx-t)}else if(this._bLockRight&&this._iDx>0){this._iDx=this._iDx*t/(this._iDx+t)}this._iOffsetDrag=-this._iDx;this._updateTransformValue()}else if(Math.abs(this._iDy)>Math.abs(this._iDx)&&Math.abs(this._iDy)>y){this._bDragCanceled=true}};D.prototype.ontouchend=function(e){if(this._isPageIndicatorArrow(e.target)){return}if(!this._bDragging||e.isMarked("delayedMouseEvent")){return}this._bDragging=false;this.$().removeClass("sapMCrslDragging");if(!this._bDragCanceled&&Math.abs(this._iDx)>C){if(this._iDx>0){T?this.previous():this.next()}else{T?this.next():this.previous()}}else{this._iOffsetDrag=0;this._updateTransformValue()}};D.prototype.onsaptabprevious=function(e){this._bDirection=false;if(this._isSlide(e.target)||e.target===this.getDomRef("noData")){this._forwardTab(false)}};D.prototype.onsaptabnext=function(e){this._bDirection=true;var t=this._getActivePageTabbables();if(!t.length||e.target===t.get(-1)){this._forwardTab(true)}};D.prototype._forwardTab=function(e){this.getDomRef(e?"after":"before").focus()};D.prototype._getActivePageTabbables=function(){return this.$(this.getPages()[this._iFocusedPageIndex].getId()+"-slide").find(":sapTabbable")};D.prototype._focusPrevious=function(e){var t=this.getFocusDomRef();if(!t){return}var i=jQuery(t);var s=this._getActivePageTabbables();i.add(s).eq(-1).trigger("focus")};D.prototype.onfocusin=function(e){if(e.target===this.getDomRef("before")&&!this.getDomRef().contains(e.relatedTarget)){this.getFocusDomRef().focus();return}if(e.target===this.getDomRef("after")&&!this.getDomRef().contains(e.relatedTarget)){this._focusPrevious(e);return}if(this._isSlide(e.target)){this.addStyleClass("sapMCrslShowArrows")}this._handlePageElemFocus(e.target);this._updateItemsAttributes(this._iFocusedPageIndex);this.saveLastFocusReference(e);this._bDirection=undefined};D.prototype.onfocusout=function(e){if(this._isSlide(e.target)){this.removeStyleClass("sapMCrslShowArrows")}};D.prototype._handlePageElemFocus=function(e){var t;if(this._isSlide(e)){t=s.closestTo(jQuery(e).find(".sapMCrsPage")[0])}else{t=this._getClosestPage(e)}if(t){var i=t.getId();this._iFocusedPageIndex=this._getPageIndex(i)}};D.prototype.onkeydown=function(e){if(e.keyCode==u.F7){this._handleF7Key(e);return}if(!this._isSlide(e.target)){return}switch(e.keyCode){case 189:case u.NUMPAD_MINUS:this._fnSkipToIndex(e,-1,false);break;case u.PLUS:case u.NUMPAD_PLUS:this._fnSkipToIndex(e,1,false);break}};D.prototype.onsapright=function(e){this._fnSkipToIndex(e,1,false)};D.prototype.onsapup=function(e){this._fnSkipToIndex(e,1,false)};D.prototype.onsapleft=function(e){this._fnSkipToIndex(e,-1,false)};D.prototype.onsapdown=function(e){this._fnSkipToIndex(e,-1,false)};D.prototype.onsaphome=function(e){this._fnSkipToIndex(e,-this._iFocusedPageIndex,true)};D.prototype.onsapend=function(e){this._fnSkipToIndex(e,this.getPages().length-this._iFocusedPageIndex-1,true)};D.prototype.onsaprightmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,D._MODIFIERNUMBERFORKEYBOARDHANDLING,true)}};D.prototype.onsapupmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,D._MODIFIERNUMBERFORKEYBOARDHANDLING,true)}};D.prototype.onsappageup=function(e){this._fnSkipToIndex(e,D._MODIFIERNUMBERFORKEYBOARDHANDLING,true)};D.prototype.onsapleftmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,-D._MODIFIERNUMBERFORKEYBOARDHANDLING,true)}};D.prototype.onsapdownmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,-D._MODIFIERNUMBERFORKEYBOARDHANDLING,true)}};D.prototype.onsappagedown=function(e){this._fnSkipToIndex(e,-D._MODIFIERNUMBERFORKEYBOARDHANDLING,true)};D.prototype.saveLastFocusReference=function(e){var t=this._getClosestPage(e.target),i;if(this._bDirection===undefined){return}if(this._lastFocusablePageElement===undefined){this._lastFocusablePageElement={}}if(t){i=t.getId();this._lastFocusablePageElement[i]=e.target}};D.prototype._getActivePageLastFocusedElement=function(){if(this._lastFocusablePageElement){return this._lastFocusablePageElement[this.getActivePage()]}};D.prototype._updateActivePages=function(e){var t=this._getPageIndex(e),i=this._getNumberOfItemsToShow(),s=this.getPages(),a;if(!s.length){return}if(t>s.length-i){t=s.length-i}a=t+i;this._aAllActivePages=[];this._aAllActivePagesIndexes=[];for(var r=t;r<a;r++){this._aAllActivePages.push(s[r].getId());this._aAllActivePagesIndexes.push(r)}};D.prototype._fnSkipToIndex=function(e,t,i){if(!this._isSlide(e.target)){return}e.preventDefault();var s=this._makeInRange(this._iFocusedPageIndex+t,i);var a=this.getActivePage();var r=this._iCurrSlideIndex+t;if(i){r=Math.max(0,Math.min(r,this.getPages().length-this._getNumberOfItemsToShow()))}if(!this._isPageDisplayed(s)){this._bShouldFireEvent=false;this._moveToPage(r,s);this._bShouldFireEvent=true;this._sOldActivePageId=a}this._changeActivePage(this._aAllActivePagesIndexes[0]);this._updateItemsAttributes(s);this._focusPage(s)};D.prototype._isPageDisplayed=function(e){return this._aAllActivePagesIndexes.includes(e)};D.prototype._handleF7Key=function(e){var t=this._getActivePageLastFocusedElement();if(this._isSlide(e.target)&&t){t.focus()}else{this.getFocusDomRef().focus()}};D.prototype._isSlide=function(e){return e.id.endsWith("slide")&&e.parentElement===this.getDomRef().querySelector(D._INNER_SELECTOR)};D.prototype._isPageIndicatorArrow=function(e){return e.classList.contains("sapMCrslArrow")};D.prototype._loops=function(){return this.getLoop()&&this._getNumberOfItemsToShow()===1};D.prototype._makeInRange=function(e,t){var i=this.getPages().length;var s=e;var a=this._loops();if(e>=i){if(a&&!t){s=0}else{s=i-1}}else if(e<0){if(a&&!t){s=i-1}else{s=0}}return s};D.prototype._getClosestPage=function(e){return s.closestTo(e.closest(".sapMCrsPage"))};D.prototype.setShowBusyIndicator=function(){p.warning("sap.m.Carousel: Deprecated function 'setShowBusyIndicator' called. Does nothing.");return this};D.prototype.getShowBusyIndicator=function(){p.warning("sap.m.Carousel: Deprecated function 'getShowBusyIndicator' called. Does nothing.");return false};D.prototype.setBusyIndicatorSize=function(e){if(!(e in _)){e=_.Medium}return i.prototype.setBusyIndicatorSize.call(this,e)};D.prototype.onclick=function(e){var t=e.target;switch(t.id){case this.getId()+"-arrow-next":this.next();break;case this.getId()+"-arrow-previous":this.previous();break}};D.prototype._initialize=function(){var e=this.$().find("> .sapMCrslInner"),t=this._getNumberOfItemsToShow();this._bIsInitialized=false;if(this._iTimeoutId){clearTimeout(this._iTimeoutId);delete this._iTimeoutId}e.addClass("sapMCrslNoTransition");this._iOffsetDrag=0;this._initActivePages();this._bIsInitialized=true;if(t>1){this._setWidthOfPages(t)}this._adjustArrowsVisibility();this._updateItemsAttributes(this._getActivePageIndex());this._updatePageIndicator();this._updateTransformValue();this._iTimeoutId=setTimeout(function(){e.removeClass("sapMCrslNoTransition")},50)};D.prototype._updateTransformValue=function(){if(this.getPages().length===0){return}var e=this.$(),t=e.find("> .sapMCrslInner"),i=t.children(),s=i.eq(0),a=i.eq(this._iCurrSlideIndex),r,o,n,h;if(!t.length){return}r=a.prop("offsetLeft")+a.prop("clientWidth");o=s.prop("offsetLeft")+s.prop("clientWidth");n=o-r;h=Math.round(n+this._iOffsetDrag);b(t[0],h)};D.prototype._initActivePages=function(){var e="sapMCrslActive",t=this.$(),i=t.find("> .sapMCrslInner"),s=i.children(),a=this.getDomRef().id,r=a.replace(/(:|\.)/g,"\\$1")+"-pageIndicator",o=this._iCurrSlideIndex,n;for(n=0;n<s.length;n++){if(n<o||n>o+this._getNumberOfItemsToShow()-1){s.eq(n).removeClass(e)}else{s.eq(n).addClass(e)}}t.find("span[data-slide]").removeClass(e);t.find("#"+r+" > [data-slide='"+(o+1)+"']").addClass(e)};return D});
//# sourceMappingURL=Carousel.js.map