/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/Device","sap/ui/core/Lib","sap/ui/unified/ColorPickerDisplayMode","./Button","./ResponsivePopover","./ColorPalette","./library"],function(e,t,o,r,a,l,n,i){"use strict";var s=i.PlacementType;var p=e.extend("sap.m.ColorPalettePopover",{metadata:{library:"sap.m",publicMethods:["openBy","close"],properties:{defaultColor:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null},colors:{type:"sap.ui.core.CSSColor[]",group:"Appearance",defaultValue:["gold","darkorange","indianred","darkmagenta","cornflowerblue","deepskyblue","darkcyan","olivedrab","darkslategray","azure","white","lightgray","darkgray","dimgray","black"]},selectedColor:{type:"sap.ui.core.CSSColor",defaultValue:null},showDefaultColorButton:{type:"boolean",group:"Appearance",defaultValue:true},showMoreColorsButton:{type:"boolean",group:"Appearance",defaultValue:true},showRecentColorsSection:{type:"boolean",group:"Appearance",defaultValue:true},displayMode:{type:"sap.ui.unified.ColorPickerDisplayMode",group:"Appearance",defaultValue:r.Default}},events:{colorSelect:{parameters:{value:{type:"sap.ui.core.CSSColor"},defaultAction:{type:"boolean"}}},liveChange:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}}}},renderer:{apiVersion:2}});var u=o.getResourceBundleFor("sap.m");var c={COLOR_PALETTE_PROPS:{colors:"setColors",selectedColor:"setSelectedColor",defaultColor:"_setDefaultColor",showDefaultColorButton:"_setShowDefaultColorButton",showMoreColorsButton:"_setShowMoreColorsButton",showRecentColorsSection:"_setShowRecentColorsSection",displayMode:"_setDisplayMode"},POPOVER_METHODS:{getDomRef:"",close:"",openBy:""}};p.prototype.init=function(){this._oPopover=null;this._bPopoverDestroying=null};p.prototype.exit=function(){this._bPopoverDestroying=true;if(this._oPopover){this._oPopover.removeDelegate(this._oPopover._onAfterRenderingDelegate);this._oPopover.destroy();this._oPopover=null}};p.prototype.setColorPickerSelectedColor=function(e){this._getPalette().setColorPickerSelectedColor(e);return this};p.prototype._getPalette=function(){return this._ensurePopover().getContent()[0]};p.prototype._ensurePopover=function(){if(!this._oPopover){this._oPopover=this._createPopover()}return this._oPopover};p.prototype._createPopover=function(){var e,o=this._createColorPalette(),r;e=new l(this.getId()+"-colorPalettePopover",{showHeader:t.system.phone,placement:s.VerticalPreferredBottom,showArrow:false,showCloseButton:false,title:u.getText("COLOR_PALETTE_TITLE"),content:o,afterOpen:o._focusSelectedElement.bind(o)}).addStyleClass("sapMColorPaletteContainer");if(t.system.phone){e.setEndButton(new a({text:u.getText("COLOR_PALETTE_CANCEL"),press:function(){e.close()}}))}o.attachEvent("_beforeOpenColorPicker",function(){e.close()});o.attachEvent("_colorNotSelected",function(t){this._handleNextOrPreviousUponPaletteClose(t);e.close()}.bind(this));o.attachEvent("colorSelect",function(t){this._handleNextOrPreviousUponPaletteClose(t);e.close();const o=t.getParameter("value");this.setSelectedColor(o);this.fireColorSelect({value:o,defaultAction:t.getParameter("defaultAction")})}.bind(this));r={onAfterRendering:function(){var e=this.$();e.attr("aria-modal","true");e.attr("aria-label",this.getTitle())}};e.addEventDelegate(r,e);e._onAfterRenderingDelegate=r;return e};p.prototype._createColorPalette=function(){var e=new n(this.getId()+"-palette",{liveChange:function(e){this.fireLiveChange(e.getParameters())}.bind(this)});e._setShowDefaultColorButton(this.getShowDefaultColorButton());e._setShowMoreColorsButton(this.getShowMoreColorsButton());e._setShowRecentColorsSection(this.getShowRecentColorsSection());return e};p.prototype._handleNextOrPreviousUponPaletteClose=function(e){var t=e.getParameter("_originalEvent");if(!t){return}if(t.type==="saptabnext"||t.type==="saptabprevious"){t.stopPropagation();t.preventDefault()}};p.prototype.setProperty=function(t,o,r){var a;if(c.COLOR_PALETTE_PROPS[t]!==undefined){a=c.COLOR_PALETTE_PROPS[t]||t;n.prototype[a].call(this._getPalette(),o)}return e.prototype.setProperty.apply(this,arguments)};Object.keys(c.POPOVER_METHODS).forEach(function(e){var t=c.COLOR_PALETTE_PROPS[e]||e;p.prototype[e]=function(){if(this._bPopoverDestroying){return null}var e=this._ensurePopover();return e[t].apply(e,arguments)}});return p});
//# sourceMappingURL=ColorPalettePopover.js.map