/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Input","./ComboBoxTextField","./ComboBoxBaseRenderer","./SuggestionsPopover","sap/ui/base/ManagedObjectObserver","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/core/SeparatorItem","sap/ui/core/InvisibleText","sap/ui/base/ManagedObject","sap/base/Log","./library","sap/ui/Device","sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/m/inputUtils/forwardItemProperties","sap/m/inputUtils/highlightDOMElements","sap/m/inputUtils/highlightItemsWithContains","sap/m/inputUtils/ListHelpers","sap/ui/core/IconPool"],function(t,e,i,s,o,n,r,a,u,l,p,h,c,d,g,jQuery,f,I,y,m,b){"use strict";var v=h.PlacementType;var S=["value","enabled","name","placeholder","editable","textAlign","textDirection","valueState","valueStateText"];var P=e.extend("sap.m.ComboBoxBase",{metadata:{library:"sap.m",abstract:true,defaultAggregation:"items",properties:{showSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},open:{type:"boolean",defaultValue:false},showClearIcon:{type:"boolean",defaultValue:false},effectiveShowClearIcon:{type:"boolean",defaultValue:false,visibility:"hidden"}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"},picker:{type:"sap.ui.core.PopupInterface",multiple:false,visibility:"hidden"}},events:{loadItems:{}},dnd:{draggable:false,droppable:true}},renderer:i});P.prototype.oncompositionend=function(t){e.prototype.oncompositionend.apply(this,arguments);if(!c.browser.firefox){this.handleInputValidation(t,this.isComposingCharacter())}};P.prototype.shouldShowClearIcon=function(){return this.getProperty("effectiveShowClearIcon")&&!!this.getValue()&&this.getEditable()&&this.getEnabled()};P.prototype.updateItems=function(t){this.bItemsUpdated=false;var e=this.getItems().length;var i;this.destroyItems();this.updateAggregation("items");this.bItemsUpdated=true;if(this.hasLoadItemsEventListeners()){if(this.isOpen()){m.fillList(this.getItems(),this._getList(),this._mapItemToListItem.bind(this));this.setRecreateItems(false)}this.onItemsLoaded()}i=this._getList();if(i&&e===this.getItems().length){i.setBusy(false);i.setShowNoData(!this.getItems().length);this.bInitialBusyIndicatorState=false}};P.prototype.setFilterFunction=function(t){if(t===null||t===undefined){this.fnFilter=null;return this}if(typeof t!=="function"){p.warning("Passed filter is not a function and the default implementation will be used")}else{this.fnFilter=t}return this};P.prototype.highlightList=function(t){var e=[];e=this._getList().$().find(".sapMSLIInfo [id$=-infoText], .sapMSLITitleOnly [id$=-titleText]");if(this.useHighlightItemsWithContains()){y(e,t)}else{I(e,t)}};P.prototype.useHighlightItemsWithContains=function(){return false};P.prototype._decoratePopupInput=function(t){if(t){this.setTextFieldHandler(t);t.setShowClearIcon(this.getShowClearIcon())}return t};P.prototype.setTextFieldHandler=function(t){var e=this,i=t._handleEvent;t._handleEvent=function(t){i.apply(this,arguments);if(/keydown|keyup|sapdown|sapup|saphome|sapend|sappagedown|sappageup|input/.test(t.type)){e._handleEvent(t)}}};P.prototype.refreshItems=function(){this.bItemsUpdated=false;this.refreshAggregation("items")};P.prototype.loadItems=function(t,e){var i=typeof t==="function";if(this.hasLoadItemsEventListeners()&&this.getItems().length===0){this._bOnItemsLoadedScheduled=false;if(i){e=jQuery.extend({action:t,busyIndicator:true,busyIndicatorDelay:300},e);this.aMessageQueue.push(e);if(this.iLoadItemsEventInitialProcessingTimeoutID===-1&&e.busyIndicator){this.iLoadItemsEventInitialProcessingTimeoutID=setTimeout(function t(){this.setInternalBusyIndicatorDelay(0);this.setInternalBusyIndicator(true)}.bind(this),e.busyIndicatorDelay)}}if(!this.bProcessingLoadItemsEvent){this.bProcessingLoadItemsEvent=true;this.fireLoadItems()}}else if(i){t.call(this)}};P.prototype.onItemsLoaded=function(){this.bProcessingLoadItemsEvent=false;clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);if(this.bInitialBusyIndicatorState!==this.getBusy()){this.setInternalBusyIndicator(this.bInitialBusyIndicatorState)}if(this.iInitialBusyIndicatorDelay!==this.getBusyIndicatorDelay()){this.setInternalBusyIndicatorDelay(this.iInitialBusyIndicatorDelay)}for(var t=0,e,i,s;t<this.aMessageQueue.length;t++){e=this.aMessageQueue.shift();t--;s=t+1===this.aMessageQueue.length;i=s?null:this.aMessageQueue[t+1];if(typeof e.action==="function"){if(e.name==="input"&&!s&&i.name==="input"){continue}e.action.call(this)}}};P.prototype.hasLoadItemsEventListeners=function(){return this.hasListeners("loadItems")};P.prototype._scheduleOnItemsLoadedOnce=function(){if(!this._bOnItemsLoadedScheduled&&!this.isBound("items")&&this.hasLoadItemsEventListeners()&&this.bProcessingLoadItemsEvent){this._bOnItemsLoadedScheduled=true;setTimeout(this.onItemsLoaded.bind(this),0)}};P.prototype.getPickerInvisibleTextId=function(){return u.getStaticId("sap.m","COMBOBOX_AVAILABLE_OPTIONS")};P.prototype._getGroupHeaderInvisibleText=function(){if(!this._oGroupHeaderInvisibleText){this._oGroupHeaderInvisibleText=new u;this._oGroupHeaderInvisibleText.toStatic()}return this._oGroupHeaderInvisibleText};P.prototype._isListInSuggestMode=function(){return this._getList().getItems().some(function(t){return!t.getVisible()&&m.getItemByListItem(this.getItems(),t).getEnabled()},this)};P.prototype.getSelectable=function(t){return t._bSelectable};P.prototype._setItemsShownWithFilter=function(t){this._bItemsShownWithFilter=t};P.prototype._getItemsShownWithFilter=function(){return this._bItemsShownWithFilter};P.prototype._getClearIcon=function(){if(this._oClearIcon){return this._oClearIcon}this._oClearIcon=this.addEndIcon({src:b.getIconURI("decline"),noTabStop:true,visible:false,alt:this._oRb.getText("INPUT_CLEAR_ICON_ALT"),useIconTooltip:false,decorative:false,press:this.handleClearIconPress.bind(this)},0);this._oClearIcon.addStyleClass("sapMComboBoxBaseClearIcon");return this._oClearIcon};P.prototype.handleClearIconPress=function(t){};P.prototype.onkeyup=function(t){if(!this.getEnabled()||!this.getEditable()){return}this.getShowClearIcon()&&this.setProperty("effectiveShowClearIcon",!!this.getValue())};P.prototype.onkeydown=function(t){e.prototype.onkeydown.apply(this,arguments);var i=this._getSuggestionsPopover();if(this.areHotKeysPressed(t)){if(i&&i.isOpen()){i.setValueStateActiveState(true);i._handleValueStateLinkNav(this,t);i.updateFocus(this,null)}else{this._handleValueStateLinkNav()}}};P.prototype.setValue=function(t){e.prototype.setValue.apply(this,arguments);this.setProperty("effectiveShowClearIcon",!!t);return this};P.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oRb=r.getResourceBundleFor("sap.m");this.setPickerType(c.system.phone?"Dialog":"Dropdown");this._setItemsShownWithFilter(false);this.bItemsUpdated=false;this.bOpenedByKeyboardOrButton=false;this._bShouldClosePicker=false;this.bProcessingLoadItemsEvent=false;this.iLoadItemsEventInitialProcessingTimeoutID=-1;this.aMessageQueue=[];this.bInitialBusyIndicatorState=this.getBusy();this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();this._bOnItemsLoadedScheduled=false;this._bDoTypeAhead=true;this.getArrowIcon().addEventDelegate({onmousedown:function(t){this._bShouldClosePicker=this.isOpen()}},this);this.getArrowIcon().attachPress(this._handlePopupOpenAndItemsLoad.bind(this,true,this));this.fnFilter=null;var t=new o(function(t){var e=t.mutation;var i=t.child;var s={remove:"detachEvent",insert:"attachEvent"};var o={remove:"handleItemRemoval",insert:"handleItemInsertion"};if(!i[s[e]]||!this[o[e]]){return}i[s[e]]("_change",this.onItemChange,this);this.setRecreateItems(true);this[o[e]](i)}.bind(this));t.observe(this,{aggregations:["items"]})};P.prototype.handleItemRemoval=function(t){};P.prototype.handleItemInsertion=function(t){};P.prototype.setRecreateItems=function(t){this._bRecreateItems=t};P.prototype.getRecreateItems=function(){return this._bRecreateItems};P.prototype.onBeforeRendering=function(){var t=this.isOpen(),i=t?this._getSuggestionsPopover()._getValueStateHeader().getText():null,s=t?this._getSuggestionsPopover()._getValueStateHeader().getValueState():null;e.prototype.onBeforeRendering.apply(this,arguments);if(t&&(this.getValueStateText()&&i!==this.getValueStateText()||this.getValueState()!==s||this.getFormattedValueStateText())){this._updateSuggestionsPopoverValueState(true)}};P.prototype._handlePopupOpenAndItemsLoad=function(t,e){var i;if(!this.getEnabled()||!this.getEditable()){return}if(t&&this._getItemsShownWithFilter()){this._bShouldClosePicker=false;this.toggleIconPressedStyle(true);this.bOpenedByKeyboardOrButton=false;this.clearFilter();this._setItemsShownWithFilter(false);return}if(this._bShouldClosePicker){this._bShouldClosePicker=false;this.close();return}this.loadItems();this.bOpenedByKeyboardOrButton=t;if(this.isPlatformTablet()){this.syncPickerContent();i=this.getPicker();i.setInitialFocus(i)}if(e){i=this.getPicker();i&&i.setInitialFocus(e)}this.open()};P.prototype.exit=function(){e.prototype.exit.apply(this,arguments);this._oRb=null;if(this._getGroupHeaderInvisibleText()){this._getGroupHeaderInvisibleText().destroy();this._oGroupHeaderInvisibleText=null}if(this._oSuggestionPopover){this._oSuggestionPopover.destroy();this._oSuggestionPopover=null}clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);this.aMessageQueue=null;this.fnFilter=null};P.prototype.onsapshow=function(t){if(!this.getEnabled()||!this.getEditable()){return}t.setMarked();if(t.keyCode===g.F4){this.onF4(t)}if(this._getItemsShownWithFilter()){this.loadItems(this._handlePopupOpenAndItemsLoad.bind(this,true));return}if(this.isOpen()){this.close();return}this.selectText(0,this.getValue().length);this.loadItems();this.bOpenedByKeyboardOrButton=true;this.open()};P.prototype.onF4=function(t){t.preventDefault()};P.prototype.onsapescape=function(t){if(this.getEnabled()&&this.getEditable()&&this.isOpen()){t.setMarked();t.preventDefault();this.close()}else{e.prototype.onsapescape.apply(this,arguments)}};P.prototype.onsaphide=P.prototype.onsapshow;P.prototype.onsapfocusleave=function(t){if(!t.relatedControlId){e.prototype.onsapfocusleave.apply(this,arguments);return}var i=n.getElementById(t.relatedControlId);if(i===this){return}var s=this.getPicker(),o=i&&i.getFocusDomRef();if(s&&d(s.getFocusDomRef(),o)){return}e.prototype.onsapfocusleave.apply(this,arguments)};P.prototype.getPopupAnchorDomRef=function(){return this.getDomRef()};P.prototype.addContent=function(t){};P.prototype.getList=function(){p.warning("[Warning]:","You are attempting to use deprecated method 'getList()', please refer to SAP note 2746748.",this);return this._getList()};P.prototype._getList=function(){var t=this._oSuggestionPopover&&this._oSuggestionPopover.getItemsContainer();if(this.bIsDestroyed||!t){return null}return t};P.prototype.setPickerType=function(t){this._sPickerType=t};P.prototype.getPickerType=function(){return this._sPickerType};P.prototype._updateSuggestionsPopoverValueState=function(t){var e=this._getSuggestionsPopover();if(!e){return}var i=this.getValueState(),s=this.getValueState()!==e._getValueStateHeader().getValueState(),o=this.getFormattedValueStateText(),n=this.getValueStateText(),r=o!==null||s;if(e.isOpen()&&!r){this.setFormattedValueStateText(e._getValueStateHeader().getFormattedText())}e.updateValueState(i,o||n,this.getShowValueStateMessage(),t)};P.prototype.shouldValueStateMessageBeOpened=function(){var t=e.prototype.shouldValueStateMessageBeOpened.apply(this,arguments);return t&&!this.isOpen()};P.prototype.onPropertyChange=function(t,e){var i=t.getParameter("newValue"),s=t.getParameter("name"),o="set"+s.charAt(0).toUpperCase()+s.slice(1),n=e&&e.srcControl||this.getPickerTextField();if(this.getInputForwardableProperties().indexOf(s)>-1&&n&&typeof n[o]==="function"){n[o](i)}};P.prototype.getInputForwardableProperties=function(){return S};P.prototype.isPickerDialog=function(){return this.getPickerType()==="Dialog"};P.prototype.isPlatformTablet=function(){var t=!c.system.combi,e=c.system.tablet&&t;return e};P.prototype.getDropdownSettings=function(){return{showArrow:false,placement:v.VerticalPreferredBottom,offsetX:0,offsetY:0,bounce:false,ariaLabelledBy:this.getPickerInvisibleTextId()||undefined}};P.prototype._configureList=function(){};P.prototype.createPicker=function(t){var e=this.getAggregation("picker");if(e){return e}this._oSuggestionPopover=this._createSuggestionsPopover();e=this._oSuggestionPopover.getPopover();this.setAggregation("picker",e,true);this.configPicker(e);return e};P.prototype.configPicker=function(t){};P.prototype._hasShowSelectedButton=function(){return false};P.prototype._createSuggestionsPopover=function(){var e=new s(this);e.decorateParent(this);e.createSuggestionPopup(this,{showSelectedButton:this._hasShowSelectedButton()},t);this._decoratePopupInput(e.getInput());e.initContent(this.getId());this.forwardEventHandlersToSuggPopover(e);this._configureList(e.getItemsContainer());return e};P.prototype.forwardEventHandlersToSuggPopover=function(t){t.setOkPressHandler(this._handleOkPress.bind(this));t.setCancelPressHandler(this._handleCancelPress.bind(this));t.setInputLabels(this.getLabels.bind(this))};P.prototype._handleOkPress=function(){var t=this,e=t.getPickerTextField();t.updateDomValue(e.getValue());t.onChange();t.close()};P.prototype._handleCancelPress=function(){this.close();this.revertSelection()};P.prototype.setSelectable=function(t,e){if(this.indexOfItem(t)<0){return}t._bSelectable=e;var i=m.getListItem(t);if(i){i.setVisible(e)}};P.prototype.onBeforeOpen=function(){this.closeValueStateMessage();this._updateSuggestionsPopoverValueState();if(!this._getItemsShownWithFilter()){this.toggleIconPressedStyle(true)}};P.prototype.onBeforeClose=function(){this.bOpenedByKeyboardOrButton=false;this._setItemsShownWithFilter(false);this._updateSuggestionsPopoverValueState()};P.prototype.getPicker=function(){var t=this.getAggregation("picker");if(t&&!t.bIsDestroyed&&!this.bIsDestroyed){return t}return null};P.prototype._getSuggestionsPopover=function(){return this._oSuggestionPopover};P.prototype.getValueStateLinks=function(){var t=this.getPicker()&&this.getPicker().getCustomHeader()&&typeof this.getPicker().getCustomHeader().getFormattedText==="function",e=t&&this.getPicker().getCustomHeader().getFormattedText(),i=e&&e.getControls();return i||[]};P.prototype.getPickerTextField=function(){var t=this._getSuggestionsPopover();return t?t.getInput():null};P.prototype.getPickerTitle=function(){var t=this.getPicker(),e=t&&t.getCustomHeader();if(this.isPickerDialog()&&e){return e.getContentMiddle()[0]}return null};P.prototype.revertSelection=function(){};P.prototype.hasContent=function(){return this.getItems().length>0};P.prototype.syncPickerContent=function(){};P.prototype.open=function(){var t=this.getPicker();if(t){t.open()}return this};P.prototype.getVisibleItems=function(){return m.getVisibleItems(this.getItems())};P.prototype.isItemSelected=function(){};P.prototype.getKeys=function(t){t=t||this.getItems();for(var e=0,i=[];e<t.length;e++){i[e]=t[e].getKey()}return i};P.prototype.findItem=function(t,e){var i="get"+t.charAt(0).toUpperCase()+t.slice(1);for(var s=0,o=this.getItems();s<o.length;s++){if(o[s][i]()===e){return o[s]}}return null};P.prototype.getItemByText=function(t){return this.findItem("text",t)};P.prototype.clearFilter=function(){this.getItems().forEach(function(t){var e=m.getListItem(t);if(e){e.setVisible(t.getEnabled()&&this.getSelectable(t))}},this)};P.prototype.onItemChange=function(t,e){f({item:t.getSource(),propName:t.getParameter("name"),propValue:t.getParameter("newValue")},e)};P.prototype.clearSelection=function(){};P.prototype.setInternalBusyIndicator=function(t){this.bInitialBusyIndicatorState=this.getBusy();return this.setBusy.apply(this,arguments)};P.prototype.setInternalBusyIndicatorDelay=function(t){this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();return this.setBusyIndicatorDelay.apply(this,arguments)};P.prototype.getItemAt=function(t){return this.getItems()[+t]||null};P.prototype.getFirstItem=function(){return this.getItems()[0]||null};P.prototype.getLastItem=function(){var t=this.getItems();return t[t.length-1]||null};P.prototype.getEnabledItems=function(t){return m.getEnabledItems(t||this.getItems())};P.prototype.getItemByKey=function(t){return this.findItem("key",t)};P.prototype.addItemGroup=function(t,e,i){e=e||new a({text:l.escapeSettingsValue(t.text)||l.escapeSettingsValue(t.key)});this.addAggregation("items",e,i);if(this._getList()&&e.isA("sap.ui.core.SeparatorItem")){this._getList().addItem(this._mapItemToListItem(e))}return e};P.prototype.isOpen=function(){var t=this.getPicker();return!!(t&&t.isOpen())};P.prototype.close=function(){var t=this.getPicker();if(t){t.close()}return this};P.prototype.intersectItems=function(t,e){return t.filter(function(t){return e.map(function(t){return t.getId()}).indexOf(t.getId())!==-1})};P.prototype.showItems=function(t){var e=this.fnFilter,i=function(){if(!this.getItems().length){return}this.detachLoadItems(i);this.setFilterFunction(t||function(){return true});this.applyShowItemsFilters();this._handlePopupOpenAndItemsLoad(false,this);this.setFilterFunction(e)}.bind(this);if(!this.getEnabled()||!this.getEditable()){return}this._setItemsShownWithFilter(true);this.attachLoadItems(i);this.loadItems(i)};P.prototype._getFormattedValueStateText=function(){if(this.isOpen()){return this._getSuggestionsPopover()._getValueStateHeader().getFormattedText()}else{return e.prototype.getFormattedValueStateText.call(this)}};P.prototype.applyShowItemsFilters=function(){};P.prototype.getValueStateLinksForAcc=function(){const t=this._getFormattedValueStateText();if(!t){return[]}return t.getControls()};return P});
//# sourceMappingURL=ComboBoxBase.js.map