/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Formatting","sap/ui/core/Locale","sap/ui/thirdparty/jquery","sap/ui/core/Control","./library","./DatePicker","./DateTimePicker","./TimePicker","sap/ui/model/type/Date","sap/ui/model/type/Time","sap/ui/model/type/DateTime","sap/ui/model/odata/type/ODataType","sap/ui/core/library","sap/ui/Device","./DateTimeInputRenderer","sap/ui/core/date/UI5Date"],function(e,t,jQuery,a,r,i,s,o,l,u,n,p,c,h,y,g){"use strict";var d=r.DateTimeInputType;var m=c.TextDirection;var f=c.TextAlign;var v=c.ValueState;var D=a.extend("sap.m.DateTimeInput",{metadata:{interfaces:["sap.m.IToolbarInteractiveControl"],library:"sap.m",deprecated:true,designtime:"sap/m/designtime/DateTimeInput.designtime",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:v.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},showValueStateMessage:{type:"boolean",group:"Misc",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:f.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:m.Inherit},type:{type:"sap.m.DateTimeInputType",group:"Data",defaultValue:d.Date},displayFormat:{type:"string",group:"Appearance",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},dateValue:{type:"object",group:"Data",defaultValue:null}},aggregations:{_picker:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"string"},dateValue:{type:"object"},valid:{type:"boolean"}}}}},renderer:y});!function(e,t,a){var i=r.getLocaleData();jQuery.extend(e,{_types:{Date:{valueFormat:i.getDatePattern("short"),displayFormat:i.getDatePattern("medium")},Time:{valueFormat:i.getTimePattern("short"),displayFormat:i.getTimePattern("short")},DateTime:{valueFormat:i.getDateTimePattern("short"),displayFormat:i.getDateTimePattern("short")}}});["Time","Date"].forEach(function(t,a){["valueFormat","displayFormat"].forEach(function(r){var i=e._types;i.DateTime[r]=i.DateTime[r].replace("{"+a+"}",i[t][r])})})}(D.prototype,jQuery,h);D.prototype.init=function(){this.setType(d.Date)};D.prototype.onBeforeRendering=function(){b.call(this)};D.prototype.getFocusDomRef=function(){var e=V.call(this);return e.getFocusDomRef()};D.prototype.getIdForLabel=function(){var e=V.call(this);return e.getIdForLabel()};function T(a){var r;switch(a){case d.DateTime:r=new s(this.getId()+"-Picker");break;case d.Time:r=new o(this.getId()+"-Picker",{localeId:new t(e.getLanguageTag()).toString()});break;default:r=new i(this.getId()+"-Picker");break}r.setDisplayFormat(this.getDisplayFormat()||this._types[a].displayFormat);r.setValueFormat(this.getValueFormat()||this._types[a].valueFormat);if(this.getDateValue()){r.setDateValue(this.getDateValue())}r.setEnabled(this.getEnabled());r.setEditable(this.getEditable());r.setValueState(this.getValueState());r.setValueStateText(this.getValueStateText());r.setShowValueStateMessage(this.getShowValueStateMessage());r.setName(this.getName());r.setPlaceholder(this.getPlaceholder());r.setTextAlign(this.getTextAlign());r.setTextDirection(this.getTextDirection());r.setWidth("100%");r.attachChange(P,this);var l=this.getAriaLabelledBy();for(var u=0;u<l.length;u++){r.addAriaLabelledBy(l[u])}return r}D.prototype.setType=function(e){if(e==this.getType()&&V.call(this)){return this}this.destroyAggregation("_picker");var t=T.call(this,e);this.setAggregation("_picker",t);this.setProperty("type",e);return this};D.prototype.setWidth=function(e){this.setProperty("width",e);if(this.getDomRef()){e=this.getWidth();this.$().css("width",e)}return this};D.prototype.setValue=function(e){b.call(this);e=this.validateProperty("value",e);if(e.toLowerCase()=="now"){return this.setDateValue(g.getInstance())}if(e===this.getValue()){return this}this.setProperty("value",e,true);var t=V.call(this);t.setValue(e);var a=t.getDateValue();this.setProperty("dateValue",a,true);return this};D.prototype.setDateValue=function(e){if(!this._isValidDate(e)){throw new Error("Date must be a JavaScript date object; "+this)}b.call(this);this.setProperty("dateValue",e,true);var t=V.call(this);t.setDateValue(e);var a=t.getValue();this.setProperty("value",a,true);return this};D.prototype.setDisplayFormat=function(e){this.setProperty("displayFormat",e,true);var t=V.call(this);t.setDisplayFormat(e||this._types[this.getType()].displayFormat);return this};D.prototype.setValueFormat=function(e){this.setProperty("valueFormat",e,true);var t=V.call(this);t.setValueFormat(e||this._types[this.getType()].ValueFormat);return this};D.prototype.setEnabled=function(e){this.setProperty("enabled",e,true);var t=V.call(this);t.setEnabled(e);return this};D.prototype.setEditable=function(e){this.setProperty("editable",e,true);var t=V.call(this);t.setEditable(e);return this};D.prototype.setValueState=function(e){this.setProperty("valueState",e,true);var t=V.call(this);t.setValueState(e);return this};D.prototype.setValueStateText=function(e){this.setProperty("valueStateText",e,true);var t=V.call(this);t.setValueStateText(e);return this};D.prototype.setShowValueStateMessage=function(e){this.setProperty("showValueStateMessage",e,true);var t=V.call(this);t.setShowValueStateMessage(e);return this};D.prototype.setName=function(e){this.setProperty("name",e,true);var t=V.call(this);t.setName(e);return this};D.prototype.setPlaceholder=function(e){this.setProperty("placeholder",e,true);var t=V.call(this);t.setPlaceholder(e);return this};D.prototype.setTextAlign=function(e){this.setProperty("textAlign",e,true);var t=V.call(this);t.setTextAlign(e);return this};D.prototype.setTextDirection=function(e){this.setProperty("textDirection",e,true);var t=V.call(this);t.setTextDirection(e);return this};D.prototype.addAriaLabelledBy=function(e){this.addAssociation("ariaLabelledBy",e,true);var t=V.call(this);t.addAriaLabelledBy(e);return this};D.prototype.removeAriaLabelledBy=function(e){this.removeAssociation("ariaLabelledBy",e,true);var t=V.call(this);t.removeAriaLabelledBy(e);return this};D.prototype.removeAllAriaLabelledBy=function(){this.removeAssociation("ariaLabelledBy",true);var e=V.call(this);e.removeAllAriaLabelledBy();return this};D.prototype.getAccessibilityInfo=function(){var e=V.call(this);return e&&e.getAccessibilityInfo?e.getAccessibilityInfo():null};D.prototype._getPickerByTypeAndPattern=function(e,t,a){var r=/[DdYyMLWwGQUur]/,i=/[HhKkmsa]/,s=i.test(a),o=r.test(a),l=s&&!o,u=o&&!s,n=o&&s,p,c;switch(e){case d.Time:case d.Date:case d.DateTime:if(l&&t.getMetadata().getName()!=="sap.m.TimePicker"){p=d.Time}else if(u&&t.getMetadata().getName()!=="sap.m.DatePicker"){p=d.Date}else if(n&&t.getMetadata().getName()!=="sap.m.DateTimePicker"){p=d.DateTime}break;default:{throw"Invalid type: "+e+". Expected is one of the sap.m.DateTimeInputType"}}if(p){this.destroyAggregation("_picker");c=T.call(this,p);this.setAggregation("_picker",c)}return c||t};D.prototype._getBoundValueTypePattern=function(){var e=this.getBinding("value"),t=e&&e.getType()&&e.getType();if(t instanceof l||t instanceof u||t instanceof n){return t.getOutputPattern()}if(t instanceof p&&t.oFormat){return t.oFormat.oFormatOptions.pattern}return undefined};D.prototype._getToolbarInteractive=function(){return true};function V(){return this.getAggregation("_picker")}D.prototype._isValidDate=function(e){return!e||Object.prototype.toString.call(e)==="[object Date]"};function b(){if(this._getBoundValueTypePattern()){var e=this._getBoundValueTypePattern();var t=V.call(this);t=this._getPickerByTypeAndPattern(this.getType(),t,e);if(t.getValueFormat()!=e){t.setValueFormat(e)}if(t.getDisplayFormat()!=e){t.setDisplayFormat(e)}}}function P(e){var t=e.getParameter("value");var a;var r=e.getParameter("valid");this.setProperty("value",t,true);if(r){a=e.oSource.getDateValue();this.setProperty("dateValue",a,true)}this.fireChange({value:t,newValue:t,valid:r,dateValue:a,newDateValue:a})}return D});
//# sourceMappingURL=DateTimeInput.js.map