/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Formatting","sap/base/i18n/Localization","sap/ui/core/Lib","sap/ui/core/Locale","sap/ui/thirdparty/jquery","./InputBase","./DatePicker","sap/ui/model/type/Date","./library","sap/ui/core/library","sap/ui/core/Control","sap/ui/Device","sap/ui/core/format/DateFormat","sap/ui/core/LocaleData","./TimePickerClocks","./DateTimePickerRenderer","./SegmentedButton","./SegmentedButtonItem","./ResponsivePopover","./Button","sap/ui/core/IconPool","sap/ui/core/Theming","sap/ui/core/date/UI5Date","sap/ui/core/InvisibleText","sap/ui/dom/jquery/cursorPos"],function(e,t,i,o,jQuery,s,n,a,r,p,l,u,h,g,c,d,f,m,_,y,T,C,P,S){"use strict";var D=r.PlacementType,v=r.ButtonType,z="Phone";var w=n.extend("sap.m.DateTimePicker",{metadata:{library:"sap.m",properties:{minutesStep:{type:"int",group:"Misc",defaultValue:1},secondsStep:{type:"int",group:"Misc",defaultValue:1},showCurrentTimeButton:{type:"boolean",group:"Behavior",defaultValue:false},showTimezone:{type:"boolean",group:"Behavior"},timezone:{type:"string",group:"Data"},showFooter:{type:"boolean",group:"Misc",defaultValue:false}},designtime:"sap/m/designtime/DateTimePicker.designtime",dnd:{draggable:false,droppable:true}},constructor:function(e,t,i){var o;if(typeof e!=="string"&&e!==undefined){i=t;t=e;e=t&&t.id}o=t?Object.keys(t).sort(function(e,t){if(e==="timezone"){return-1}else if(t==="timezone"){return 1}return 0}).reduce(function(e,i){e[i]=t[i];return e},{}):t;n.call(this,e,o,i)},renderer:d});var k={Short:"short",Medium:"medium",Long:"long",Full:"full"};var b=l.extend("sap.m.internal.DateTimePickerPopup",{metadata:{library:"sap.m",properties:{forcePhoneView:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{_switcher:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},calendar:{type:"sap.ui.core.Control",multiple:false},clocks:{type:"sap.ui.core.Control",multiple:false}}},renderer:{apiVersion:2,render:function(e,t){e.openStart("div",t);e.class("sapMDateTimePopupCont").class("sapMTimePickerDropDown");e.openEnd();var i=t.getAggregation("_switcher");if(i){e.openStart("div");e.class("sapMTimePickerSwitch");e.openEnd();e.renderControl(i);e.close("div")}var o=t.getCalendar();if(o){e.renderControl(o)}e.openStart("div");e.class("sapMTimePickerSep");e.openEnd();e.close("div");var s=t.getClocks();if(s){e.renderControl(s)}e.close("div")}},init:function(){},onBeforeRendering:function(){var e=this.getAggregation("_switcher");if(!e){var t=i.getResourceBundleFor("sap.m");var o=t.getText("DATETIMEPICKER_DATE");var s=t.getText("DATETIMEPICKER_TIME");e=new f(this.getId()+"-Switch",{selectedKey:"Cal",items:[new m(this.getId()+"-Switch-Cal",{key:"Cal",text:o}),new m(this.getId()+"-Switch-Clk",{key:"Clk",text:s})]});e.attachSelectionChange(this._handleSelectionChange,this);this.setAggregation("_switcher",e)}if(u.system.phone||jQuery("html").hasClass("sapUiMedia-Std-Phone")||this.getForcePhoneView()){e.setVisible(true);e.setSelectedKey("Cal");this.getCalendar().attachSelect(function(){this._addCalendarDelegate()}.bind(this));this._addCalendarDelegate()}else{e.setVisible(false)}},_addCalendarDelegate:function(){var e=this.getAggregation("_switcher"),t={onAfterRendering:function(){this._switchVisibility(e.getSelectedKey());this.getCalendar().removeDelegate(t)}.bind(this)};this.getCalendar().addDelegate(t)},_handleSelectionChange:function(e){var t=e.getParameter("item").getKey();this._switchVisibility(t);if(t==="Clk"){this.getClocks()._focusActiveButton()}},_switchVisibility:function(e){var t=this.getCalendar(),i=this.getClocks();if(!t||!i){return}if(e==="Cal"){t.$().css("display","");i.$().css("display","none");t.getFocusDomRef()&&t.getFocusDomRef().focus()}else{t.$().css("display","none");i.$().css("display","")}},switchToTime:function(){var e=this.getAggregation("_switcher");if(e&&e.getVisible()){e.setSelectedKey("Clk");this._switchVisibility("Clk")}},getSpecialDates:function(){return this._oDateTimePicker.getSpecialDates()}});w.prototype.init=function(){n.prototype.init.apply(this,arguments);this._bOnlyCalendar=false};w.prototype.setShowFooter=function(e){return this};w.prototype.setTimezone=function(e){var t,i,o;if(this.getTimezone()===e){return this}this.setProperty("timezone",e);if(this._oTimezonePopup){this._oTimezonePopup.setTitle(this._getTranslatedTimezone(true))}if(this._isTimezoneBinding()){t=this.getDateValue()||this._parseValue(this.getValue(),false);i=this._formatValue(t,false);o=this._parseValue(i,true);if(o){this.setProperty("dateValue",o);this.setProperty("value",this._formatValue(o,true))}}return this};w.prototype.ontap=function(e){if(e.target.parentElement.classList.contains("sapMDTPTimezoneLabel")){this._togglePopoverOpen(this._getTimezoneNamePopup(),e.target);return}n.prototype.ontap.apply(this,arguments)};w.prototype.onAfterRendering=function(){n.prototype.onAfterRendering.apply(this,arguments);if(this._getShowTimezone()){C.attachApplied(this._adjustInnerMaxWidth.bind(this))}};w.prototype._formatValueAndUpdateOutput=function(e,t){delete this._prefferedValue;var i=e?this._formatValue(e):t;if(!e){var o=this._fallbackParse(t);if(typeof o==="string"){this._bValid=true;this._prefferedValue=o;i=o}}if(!this.getDomRef()){return}if(this._bPreferUserInteraction){this.handleInputValueConcurrency(i)}else if(this._$input.val()!==i){this._$input.val(i);this._curpos=this._$input.cursorPos()}};w.prototype._fallbackParse=function(e){return this._getFallbackParser().parse(e)?"":null};w.prototype._getFallbackParser=function(){if(!this._fallbackParser){this._fallbackParser=h.getDateTimeWithTimezoneInstance({showDate:false,showTime:false,showTimezone:true})}return this._fallbackParser};w.prototype.getIconSrc=function(){return T.getIconURI("date-time")};w.prototype.exit=function(){n.prototype.exit.apply(this,arguments);if(this._oClocks){this._oClocks.destroy();delete this._oClocks}this._oTimezonePopup=undefined;this._oPopupContent=undefined;C.detachApplied(this._adjustInnerMaxWidth);u.media.detachHandler(this._handleWindowResize,this)};w.prototype.setDisplayFormat=function(e){n.prototype.setDisplayFormat.apply(this,arguments);if(this._oClocks){this._oClocks.setValueFormat(F.call(this));this._oClocks.setDisplayFormat(F.call(this))}return this};w.prototype.setMinutesStep=function(e){this.setProperty("minutesStep",e,true);if(this._oClocks){this._oClocks.setMinutesStep(e)}return this};w.prototype._getDefaultValueStyle=function(){return k.Medium};w.prototype.setMinDate=function(e){n.prototype.setMinDate.call(this,e);if(e){this._oMinDate.setHours(e.getHours(),e.getMinutes(),e.getSeconds())}return this};w.prototype.setMaxDate=function(e){n.prototype.setMaxDate.call(this,e);if(e){this._oMaxDate.setHours(e.getHours(),e.getMinutes(),e.getSeconds())}return this};w.prototype.setSecondsStep=function(e){this.setProperty("secondsStep",e,true);if(this._oClocks){this._oClocks.setSecondsStep(e)}return this};w.prototype.setShowCurrentTimeButton=function(e){var t=this._oClocks;t&&t.setShowCurrentTimeButton(e);return this.setProperty("showCurrentTimeButton",e)};w.prototype._adjustInnerMaxWidth=function(){var e=this.$().find(".sapMDummyContent"),t;if(!e||!e.length){return}t=e[0].getBoundingClientRect().width;this.$("inner").css("max-width",t+2+"px")};w.prototype._getTimezoneNamePopup=function(){var e;if(this._oTimezonePopup){this._oTimezonePopup.setTitle(this._getTranslatedTimezone(true));return this._oTimezonePopup}this._oTimezonePopup=new _({showArrow:false,placement:D.VerticalPreferredBottom,offsetX:0,offsetY:3,horizontalScrolling:false,title:this._getTranslatedTimezone(true)});this.addDependent(this._oTimezonePopup);if(u.system.phone){e=i.getResourceBundleFor("sap.m");this._oTimezonePopup.setEndButton(new y({text:e.getText("SUGGESTIONSPOPOVER_CLOSE_BUTTON"),type:v.Emphasized,press:function(){this._oTimezonePopup.close()}.bind(this)}))}return this._oTimezonePopup};w.prototype._getFormatInstance=function(e){return h.getDateTimeInstance(e)};w.prototype._togglePopoverOpen=function(e,t){if(e.isOpen()){e.close()}else{e.openBy(t||this.getDomRef())}};w.prototype._getFormatterWithTimezoneInstance=function(e){var t=this._getTimezoneFormatterCacheName(e);if(!this[t]){this[t]=h.getDateTimeWithTimezoneInstance(this._getTimezoneFormatOptions(e))}return this[t]};w.prototype._getBindingFormatOptions=function(){var e=this.getBinding("value")||this.getBinding("dateValue"),t;if(e){t=e.getType()}if(this._isSupportedBindingType(t)){return jQuery.extend({},t.getFormatOptions())}};w.prototype._getTimezoneFormatOptions=function(t){var i=this._getBindingFormatOptions()||{},o=t?this.getDisplayFormat():this.getValueFormat(),s=this.getBinding("value")||this.getBinding("dateValue"),n=s&&s.getType&&s.getType();if(t||!this._getTimezone()||n&&!n.isA(["sap.ui.model.odata.type.DateTimeWithTimezone"])){i.showTimezone=false}if(!t&&n&&n.isA(["sap.ui.model.odata.type.DateTimeWithTimezone"])){i.showTimezone=true}if(i.relative===undefined){i.relative=false}if(i.calendarType===undefined){i.calendarType=t?this.getDisplayFormatType():e.getCalendarType()}if(i.strictParsing===undefined){i.strictParsing=true}if(o&&!this._isSupportedBindingType(n)){i[this._checkStyle(o)?"style":"pattern"]=o}i.showDate=true;i.showTime=true;return i};w.prototype._getTimezoneFormatterCacheName=function(e){return e?"_oDisplayFormatWithTimezone":"_oValueFormatWithTimezone"};w.prototype._getShowTimezone=function(){var e=this.getBinding("value")||this.getBinding("dateValue"),t=e&&e.getType();if(this.getShowTimezone()===undefined&&t&&t.isA(["sap.ui.model.odata.type.DateTimeWithTimezone"])){return t.getFormatOptions().showTimezone!==false}return this.getShowTimezone()};w.prototype._getTimezone=function(e){var i=this.getBinding("value")||this.getBinding("dateValue"),o=i&&i.getType();if(!this.getTimezone()&&o&&o.isA(["sap.ui.model.odata.type.DateTimeWithTimezone"])&&i.aValues[1]){return i.aValues[1]}return this.getTimezone()||e&&t.getTimezone()};w.prototype._getTranslatedTimezone=function(t){return g.getInstance(new o(e.getLanguageTag())).getTimezoneTranslations()[this._getTimezone(t)]};w.prototype._checkStyle=function(e){if(n.prototype._checkStyle.apply(this,arguments)){return true}else if(e.indexOf("/")>0){var t=[k.Short,k.Medium,k.Long,k.Long];var i=false;for(var o=0;o<t.length;o++){var s=t[o];for(var a=0;a<t.length;a++){var r=t[a];if(e==s+"/"+r){i=true;break}}if(i){break}}return i}return false};w.prototype._isTimezoneBinding=function(){var e=this.getBinding("value")||this.getBinding("dateValue"),t=e&&e.getType();return t&&t.isA(["sap.ui.model.odata.type.DateTimeWithTimezone"])};w.prototype._parseValue=function(e,t,i){if(this._isTimezoneBinding()){var o=this._getFormatterWithTimezoneInstance().parse(e,i||this._getTimezone(true));if(o){return o[0]}return null}return n.prototype._parseValue.apply(this,arguments)};w.prototype._formatValue=function(e,t,i){if(!e){return""}if(this._isTimezoneBinding()){return this._getFormatterWithTimezoneInstance(!t).format(e,i||this._getTimezone(true))}return n.prototype._formatValue.apply(this,arguments)};w.prototype._getPickerParser=function(){if(!this._isTimezoneBinding()){return n.prototype._getFormatter.apply(this,arguments)}if(!this._clocksParser){this._clocksParser=h.getDateTimeWithTimezoneInstance({showTimezone:false,calendarType:this.getDisplayFormatType()})}return this._clocksParser};w.prototype._getLocaleBasedPattern=function(t){var i=g.getInstance(new o(e.getLanguageTag())),s=t.indexOf("/");if(s>0){return i.getCombinedDateTimePattern(t.substr(0,s),t.substr(s+1))}else{return i.getCombinedDateTimePattern(t,t)}};w.prototype._createPopup=function(){var e,t,o,s,n,a;if(!this._oPopup){o=i.getResourceBundleFor("sap.m");s=o.getText("TIMEPICKER_SET");n=o.getText("TIMEPICKER_CANCEL");this._oPopupContent=new b(this.getId()+"-PC");this._oPopupContent._oDateTimePicker=this;this._oOKButton=new y(this.getId()+"-OK",{text:s,type:v.Emphasized,press:B.bind(this)});var r=this._getValueStateHeader();this._oPopup=new _(this.getId()+"-RP",{showCloseButton:false,showHeader:false,placement:D.VerticalPreferedBottom,beginButton:this._oOKButton,content:[r,this._oPopupContent],ariaLabelledBy:S.getStaticId("sap.m",this._getAccessibleNameLabel()),afterOpen:V.bind(this),afterClose:A.bind(this)});r.setPopup(this._oPopup._oControl);if(u.system.phone){e=this.$("inner").attr("aria-labelledby");t=e?document.getElementById(e)?.textContent:"";this._oPopup.setTitle(t);this._oPopup.setShowHeader(true);this._oPopup.setShowCloseButton(true)}else{this._oPopup._getPopup().setDurations(0,0);this._oPopup.setEndButton(new y(this.getId()+"-Cancel",{text:n,press:I.bind(this)}))}this._oPopup.addStyleClass("sapMDateTimePopup");a=this._oPopup.getAggregation("_popup");if(a.setShowArrow){a.setShowArrow(false)}this.setAggregation("_popup",this._oPopup,true)}};w.prototype._getAccessibleNameLabel=function(){return"DATETIMEPICKER_POPOVER_ACCESSIBLE_NAME"};w.prototype._openPopup=function(e){if(!this._oPopup){return}if(!e){e=this.getDomRef()}this.addStyleClass(s.ICON_PRESSED_CSS_CLASS);var t=this._oPopup.getAggregation("_popup");t.oPopup.setExtraContent([e]);this._oPopup.openBy(e||this)};w.prototype._createPopupContent=function(){var e=!this._oCalendar;n.prototype._createPopupContent.apply(this,arguments);if(e){this._oPopupContent.setCalendar(this._oCalendar);this._oCalendar.attachSelect(M,this)}if(!this._oClocks){this._oClocks=new c(this.getId()+"-Clocks",{minutesStep:this.getMinutesStep(),secondsStep:this.getSecondsStep(),valueFormat:F.call(this),displayFormat:F.call(this),localeId:this.getLocaleId(),showCurrentTimeButton:this.getShowCurrentTimeButton()});this._oPopupContent.setClocks(this._oClocks)}};w.prototype._attachAfterRenderingDelegate=function(){};w.prototype._selectFocusedDateValue=function(e){var t=this._oCalendar;t.removeAllSelectedDates();t.addSelectedDate(e);return this};w.prototype._fillDateRange=function(){var e=this.getDateValue(),t=true,i;if(e){e=P.getInstance(e.getTime());this._oOKButton.setEnabled(true)}else{t=false;e=this.getInitialFocusedDateValue();if(!e){e=P.getInstance();this._oCalendar.removeAllSelectedDates()}this._oOKButton.setEnabled(false)}if(e.getTime()<this._oMinDate.getTime()){e=this._oMinDate}else if(e.getTime()>this._oMaxDate.getTime()){e=this._oMaxDate}if(this._isTimezoneBinding()){i=this._getPickerParser().format(e,this._getTimezone(true));e=this._getPickerParser().parse(i)[0]}this._oCalendar.focusDate(e);if(t){if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=e.getTime()){this._oDateRange.setStartDate(e)}}this._oClocks._setTimeValues(e)};w.prototype._getSelectedDate=function(){var e=n.prototype._getSelectedDate.apply(this,arguments),t,i,o,s;if(e){t=this._oClocks.getTimeValues();i=this._oClocks._getDisplayFormatPattern();if(i.search("h")>=0||i.search("H")>=0){e.setHours(t.getHours())}if(i.search("m")>=0){e.setMinutes(t.getMinutes())}if(i.search("s")>=0){e.setSeconds(t.getSeconds())}if(e.getTime()<this._oMinDate.getTime()){e=P.getInstance(this._oMinDate.getTime())}else if(e.getTime()>this._oMaxDate.getTime()){e=P.getInstance(this._oMaxDate.getTime())}}if(this._isTimezoneBinding()){o=this._getPickerParser().format(e);s=this._getPickerParser().parse(o,this._getTimezone(true));e=s&&s[0]}return e};w.prototype.getLocaleId=function(){return new o(e.getLanguageTag()).toString()};w.prototype.getAccessibilityInfo=function(){var e=n.prototype.getAccessibilityInfo.apply(this,arguments);e.type=i.getResourceBundleFor("sap.m").getText("ACC_CTR_TYPE_DATETIMEINPUT");return e};function B(e){this._handleCalendarSelect()}function I(e){this.onsaphide(e);if(!this.getDateValue()){this._oCalendar.removeAllSelectedDates()}}w.prototype._handleWindowResize=function(e){var t=this.getAggregation("_popup").getContent()[1].getAggregation("_switcher"),i=this.getAggregation("_popup").getContent()[1].getCalendar(),o=this.getAggregation("_popup").getContent()[1].getClocks();if(e.name===z){t.setVisible(true);this.getAggregation("_popup").getContent()[1]._switchVisibility(t.getSelectedKey())}else{t.setVisible(false);o.$().css("display","");i.$().css("display","")}};function V(e){this._oClocks._showFirstClock();this._oCalendar.focus();u.media.attachHandler(this._handleWindowResize,this);this.fireAfterValueHelpOpen()}function A(){this.removeStyleClass(s.ICON_PRESSED_CSS_CLASS);this._oCalendar._closePickers();u.media.detachHandler(this._handleWindowResize,this);this.fireAfterValueHelpClose()}function F(){var t=this.getDisplayFormat();var i;var s=this.getBinding("value");if(s&&s.oType&&s.oType instanceof a){t=s.oType.getOutputPattern()}else if(s&&s.oType&&s.oType.oFormat){t=s.oType.oFormat.oFormatOptions.pattern}else{t=this.getDisplayFormat()}if(!t){t=k.Medium}var n=t.indexOf("/");if(n>0&&this._checkStyle(t)){t=t.substr(n+1)}if(t==k.Short||t==k.Medium||t==k.Long||t==k.Full){var r=new o(e.getLanguageTag());var p=g.getInstance(r);i=p.getTimePattern(t)}else{i=t}return i}function M(e){this._oPopupContent.switchToTime();this._oPopupContent.getClocks()._focusActiveButton();this._oOKButton.setEnabled(true)}return w});
//# sourceMappingURL=DateTimePicker.js.map