/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/AnimationMode","sap/ui/core/ControlBehavior","sap/base/i18n/Localization","sap/ui/core/Lib","./Bar","./InstanceManager","./AssociativeOverflowToolbar","./ToolbarSpacer","./Title","./library","sap/m/Image","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/IconPool","sap/ui/core/Popup","sap/ui/core/delegate/ScrollEnablement","sap/ui/core/RenderManager","sap/ui/core/InvisibleText","sap/ui/core/theming/Parameters","sap/ui/core/util/ResponsivePaddingsEnablement","sap/ui/Device","sap/ui/core/library","sap/ui/events/KeyCodes","./TitlePropagationSupport","./DialogRenderer","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/core/Configuration","sap/ui/dom/units/Rem","sap/ui/dom/jquery/Focusable"],function(e,t,i,o,s,r,n,a,l,h,u,p,g,c,d,f,_,y,b,m,S,v,R,T,D,A,jQuery,I,B){"use strict";var C=v.OpenState;var O=h.ButtonType;var M=h.DialogType;var P=h.DialogRoleType;var w=v.ValueState;var E=v.TitleLevel;var z=h.TitleAlignment;var H=t.getAnimationMode();var x=H!==e.none&&H!==e.minimal;var F=x?300:10;var L=17;var W=B.toPx(1);var V=5;var $=3;var N=p.extend("sap.m.Dialog",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},title:{type:"string",group:"Appearance",defaultValue:null},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},type:{type:"sap.m.DialogType",group:"Appearance",defaultValue:M.Standard},state:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:w.None},stretchOnPhone:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},stretch:{type:"boolean",group:"Appearance",defaultValue:false},contentWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},horizontalScrolling:{type:"boolean",group:"Behavior",defaultValue:true},verticalScrolling:{type:"boolean",group:"Behavior",defaultValue:true},resizable:{type:"boolean",group:"Behavior",defaultValue:false},draggable:{type:"boolean",group:"Behavior",defaultValue:false},escapeHandler:{type:"function",group:"Behavior",defaultValue:null},role:{type:"sap.m.DialogRoleType",group:"Data",defaultValue:P.Dialog,visibility:"hidden"},closeOnNavigation:{type:"boolean",group:"Behavior",defaultValue:true},titleAlignment:{type:"sap.m.TitleAlignment",group:"Misc",defaultValue:z.Auto}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},subHeader:{type:"sap.m.IBar",multiple:false},customHeader:{type:"sap.m.IBar",multiple:false},beginButton:{type:"sap.m.Button",multiple:false},endButton:{type:"sap.m.Button",multiple:false},buttons:{type:"sap.m.Button",multiple:true,singularName:"button"},footer:{type:"sap.m.Toolbar",multiple:false},_header:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_icon:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_toolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"},_valueState:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},associations:{leftButton:{type:"sap.m.Button",multiple:false,deprecated:true},rightButton:{type:"sap.m.Button",multiple:false,deprecated:true},initialFocus:{type:"sap.ui.core.Control",multiple:false},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{beforeOpen:{allowPreventDefault:true},afterOpen:{},beforeClose:{allowPreventDefault:true,parameters:{origin:{type:"sap.m.Button"}}},afterClose:{parameters:{origin:{type:"sap.m.Button"}}}},designtime:"sap/m/designtime/Dialog.designtime"},renderer:D});m.call(N.prototype,{header:{suffix:"header"},subHeader:{selector:".sapMDialogSubHeader .sapMIBar"},content:{selector:".sapMDialogScrollCont"},footer:{selector:".sapMDialogFooter .sapMIBar"}});T.call(N.prototype,"content",function(){return this._headerTitle?this._headerTitle.getId():false});N._bPaddingByDefault=I.getCompatibilityVersion("sapMDialogWithPadding").compareTo("1.16")<0;N._initIcons=function(){if(N._mIcons){return}N._mIcons={};N._mIcons[w.Success]=c.getIconURI("sys-enter-2");N._mIcons[w.Warning]=c.getIconURI("alert");N._mIcons[w.Error]=c.getIconURI("error");N._mIcons[w.Information]=c.getIconURI("information")};N._getHeaderToolbarAriaLabelledByText=function(){if(!N._oHeaderToolbarInvisibleText){N._oHeaderToolbarInvisibleText=new y("__headerActionsToolbar-invisibleText",{text:o.getResourceBundleFor("sap.m").getText("ARIA_LABEL_TOOLBAR_HEADER_ACTIONS")}).toStatic()}return N._oHeaderToolbarInvisibleText};N._getFooterToolbarAriaLabelledByText=function(){if(!N._oFooterToolbarInvisibleText){N._oFooterToolbarInvisibleText=new y("__footerActionsToolbar-invisibleText",{text:o.getResourceBundleFor("sap.m").getText("ARIA_LABEL_TOOLBAR_FOOTER_ACTIONS")}).toStatic()}return N._oFooterToolbarInvisibleText};N.prototype.init=function(){var e=this;this._oManuallySetSize=null;this._oManuallySetPosition=null;this._bRTL=i.getRTL();this._scrollContentList=["sap.m.NavContainer","sap.m.Page","sap.m.ScrollContainer","sap.m.SplitContainer","sap.m.MultiInput","sap.m.SimpleFixFlex"];this.oPopup=new d;this.oPopup.setShadow(true);this.oPopup.setNavigationMode("SCOPE");this.oPopup.setModal(true);this.oPopup.setAnimations(jQuery.proxy(this._openAnimation,this),jQuery.proxy(this._closeAnimation,this));this.oPopup._applyPosition=function(t,i){e._setDimensions();e._adjustScrollingPane();if(e._oManuallySetPosition){t.at={left:e._oManuallySetPosition.x,top:e._oManuallySetPosition.y}}else{t.at=e._calcPosition()}e._deregisterResizeObserver();d.prototype._applyPosition.call(this,t);e._registerResizeObserver()};if(N._bPaddingByDefault){this.addStyleClass("sapUiPopupWithPadding")}this._initTitlePropagationSupport();this._initResponsivePaddingsEnablement();this._oAriaDescribedbyText=new y({id:this.getId()+"-ariaDescribedbyText"})};N.prototype.onBeforeRendering=function(){this._loadVerticalMargin();var e=this._getAnyHeader();if(!N._bPaddingByDefault&&this.hasStyleClass("sapUiPopupWithPadding")){A.warning("Usage of CSS class 'sapUiPopupWithPadding' is deprecated. Use 'sapUiContentPadding' instead",null,"sap.m.Dialog")}if(this._hasSingleScrollableContent()){this.setVerticalScrolling(false);this.setHorizontalScrolling(false);A.info("VerticalScrolling and horizontalScrolling in sap.m.Dialog with ID "+this.getId()+" has been disabled because there's scrollable content inside")}else if(!this._oScroller){this._oScroller=new f(this,this.getId()+"-scroll",{horizontal:this.getHorizontalScrolling(),vertical:this.getVerticalScrolling()})}if(this._oScroller){this._oScroller.setVertical(this.getVerticalScrolling());this._oScroller.setHorizontal(this.getHorizontalScrolling())}this._createToolbarButtons();if(t.isAccessibilityEnabled()&&this.getState()!=w.None){if(!this._oValueState){this._oValueState=new y;this.setAggregation("_valueState",this._oValueState);this.addAriaLabelledBy(this._oValueState.getId())}this._oValueState.setText(this.getValueStateString(this.getState()))}if(e&&e.setTitleAlignment){e.setTitleAlignment(this.getTitleAlignment())}if(e&&this._getTitles(e).length===0){e._setRootAccessibilityRole("heading");e._setRootAriaLevel("2")}this._oAriaDescribedbyText.setText(this._getAriaDescribedByText())};N.prototype.onAfterRendering=function(){this._$scrollPane=this.$("scroll");this._$content=this.$("cont");this._$dialog=this.$();if(this.isOpen()){this._setInitialFocus()}};N.prototype.exit=function(){r.removeDialogInstance(this);this._deregisterResizeObserver();this._deregisterWithinAreaResizeObserver();if(this.oPopup){this.oPopup.detachOpened(this._handleOpened,this);this.oPopup.detachClosed(this._handleClosed,this);this.oPopup.destroy();this.oPopup=null}if(this._oScroller){this._oScroller.destroy();this._oScroller=null}if(this._header){this._header.destroy();this._header=null}if(this._headerTitle){this._headerTitle.destroy();this._headerTitle=null}if(this._iconImage){this._iconImage.destroy();this._iconImage=null}if(this._toolbarSpacer){this._toolbarSpacer.destroy();this._toolbarSpacer=null}if(this._oAriaDescribedbyText){this._oAriaDescribedbyText.destroy();this._oAriaDescribedbyText=null}};N.prototype.open=function(){var e=this.oPopup;e.setInitialFocusId(this.getId());var t=e.getOpenState();switch(t){case C.OPEN:case C.OPENING:return this;case C.CLOSING:this._bOpenAfterClose=true;break;default:}if(!this.fireBeforeOpen()){return this}this._oCloseTrigger=null;e.attachOpened(this._handleOpened,this);this._iLastWidthAndHeightWithScroll=null;e.setContent(this);e.open();this._registerWithinAreaResizeObserver();r.addDialogInstance(this);return this};N.prototype.close=function(){this._bOpenAfterClose=false;var e=this.oPopup;var t=this.oPopup.getOpenState();if(t===C.CLOSED||t===C.CLOSING){return this}if(!this.fireBeforeClose({origin:this._oCloseTrigger})){return this}this._deregisterWithinAreaResizeObserver();h.closeKeyboard();e.attachClosed(this._handleClosed,this);this._bDisableRepositioning=false;this._oManuallySetPosition=null;this._oManuallySetSize=null;e.close();this._deregisterResizeObserver();return this};N.prototype.isOpen=function(){return!!this.oPopup&&this.oPopup.isOpen()};N.prototype.setIcon=function(e){this._bHasCustomIcon=true;return this.setProperty("icon",e)};N.prototype.setState=function(e){var t;this.setProperty("state",e);if(this._bHasCustomIcon){return this}if(e===w.None){t=""}else{N._initIcons();t=N._mIcons[e]}this.setProperty("icon",t);return this};N.prototype._handleOpened=function(){this.oPopup.detachOpened(this._handleOpened,this);this._setInitialFocus();this.fireAfterOpen()};N.prototype._handleClosed=function(){if(!this.oPopup){return}this.oPopup.detachClosed(this._handleClosed,this);if(this.getDomRef()){_.preserveContent(this.getDomRef());this.$().remove()}r.removeDialogInstance(this);this.fireAfterClose({origin:this._oCloseTrigger});if(this._bOpenAfterClose){this._bOpenAfterClose=false;this.open()}};N.prototype.onfocusin=function(e){var t=e.target;if(t.id===this.getId()+"-firstfe"){var i=this._getAnyFooter()?.$().lastFocusableDomRef()||this.$("cont").lastFocusableDomRef()||this.getSubHeader()&&this.getSubHeader().$().firstFocusableDomRef()||this._getAnyHeader()&&this._getAnyHeader().$().lastFocusableDomRef();if(i){i.focus()}}else if(t.id===this.getId()+"-lastfe"){var o=this._getFocusableHeader()||this._getAnyHeader()&&this._getAnyHeader().$().firstFocusableDomRef()||this.getSubHeader()&&this.getSubHeader().$().firstFocusableDomRef()||this.$("cont").firstFocusableDomRef()||this.$("footer").firstFocusableDomRef();if(o){o.focus()}}};N.prototype._getPromiseWrapper=function(){var e=this;return{reject:function(){e.currentPromise.reject()},resolve:function(){e.currentPromise.resolve()}}};N.prototype.onsapescape=function(e){var t=this.getEscapeHandler(),i={},o=this;if(this._isSpaceOrEnterPressed){return}if(e.originalEvent&&e.originalEvent._sapui_handledByControl){return}this._oCloseTrigger=null;if(typeof t==="function"){new Promise(function(e,s){i.resolve=e;i.reject=s;o.currentPromise=i;t(o._getPromiseWrapper())}).then(function(e){o.close()}).catch(function(){A.info("Disallow dialog closing")})}else{this.close()}e.stopPropagation()};N.prototype.onkeyup=function(e){if(this._isSpaceOrEnter(e)){this._isSpaceOrEnterPressed=false}};N.prototype.onkeydown=function(e){if(this._isSpaceOrEnter(e)){this._isSpaceOrEnterPressed=true}var t=e.which||e.keyCode;if((e.ctrlKey||e.metaKey)&&t===R.ENTER){var i=this._findFirstPositiveButton();if(i){i.firePress();e.stopPropagation();e.preventDefault();return}}this._handleKeyboardDragResize(e)};N.prototype._findFirstPositiveButton=function(){var e;if(this.getFooter()){e=this.getFooter().getContent().filter(function(e){return e.isA("sap.m.Button")})}else{e=this.getButtons()}for(var t=0;t<e.length;t++){var i=e[t];if(i.getType()===O.Accept||i.getType()===O.Emphasized){return i}}};N.prototype._handleKeyboardDragResize=function(e){if(e.target!==this._getFocusableHeader()||[R.ARROW_LEFT,R.ARROW_RIGHT,R.ARROW_UP,R.ARROW_DOWN].indexOf(e.keyCode)===-1){return}if(!this.getResizable()&&e.shiftKey||!this.getDraggable()&&!e.shiftKey){return}var t=this._$dialog,i=this.getDomRef().getBoundingClientRect(),o={left:i.x,top:i.y},s=this._getAreaDimensions(),r=t.width(),n=t.height(),a=t.outerHeight(true),l=e.shiftKey,h,u;this._bDisableRepositioning=true;if(l){this._oManuallySetSize=true;this.$("cont").height("").width("")}switch(e.keyCode){case R.ARROW_LEFT:if(l){r-=W}else{o.left-=W}break;case R.ARROW_RIGHT:if(l){r+=W}else{o.left+=W}break;case R.ARROW_UP:if(l){n-=W}else{o.top-=W}break;case R.ARROW_DOWN:if(l){n+=W}else{o.top+=W}break}if(l){u=s.bottom-o.top-a+n;if(e.keyCode===R.ARROW_DOWN){u-=W}h={width:Math.min(r,s.right-o.left),height:Math.min(n,u)}}else{h={left:Math.min(Math.max(s.left,o.left),s.right-r),top:Math.min(Math.max(s.top,o.top),s.bottom-a)}}t.css(h)};N.prototype._isSpaceOrEnter=function(e){var t=e.which||e.keyCode;return t==R.SPACE||t==R.ENTER};N.prototype._openAnimation=function(e,t,i){e.addClass("sapMDialogOpen");setTimeout(i,F)};N.prototype._closeAnimation=function(e,t,i){e.removeClass("sapMDialogOpen");setTimeout(i,F)};N.prototype._setDimensions=function(){var e=this.$(),t=this.getStretch(),i=this.getType()===M.Message,o={};if(!t){if(!this._oManuallySetSize){o.width=this.getContentWidth()||undefined;o.height=this.getContentHeight()||undefined}else{o.width=this._oManuallySetSize.width;o.height=this._oManuallySetSize.height}}if(o.width=="auto"){o.width=undefined}if(o.height=="auto"){o.height=undefined}if(t&&!i){this.$().addClass("sapMDialogStretched")}if(this.getStretchOnPhone()&&S.system.phone){this.$().addClass("sapMDialogStretched")}e.css(o);e.css(this._calcMaxSizes());if(!this._oManuallySetSize&&!this._bDisableRepositioning){e.css(this._calcPosition())}if(window.navigator.userAgent.toLowerCase().indexOf("chrome")!==-1&&this.getStretch()){e.find("> footer").css({bottom:"0.001px"})}};N.prototype._adjustScrollingPane=function(){if(this._oScroller){this._oScroller.refresh()}};N.prototype._onResize=function(){if(!this.getDomRef()){return}var e=this.$(),t=this.$("cont"),i=this.getContentWidth(),o=this._calcMaxSizes().maxWidth,s=this.getSubHeader()?.getDomRef(),r=(this.getCustomHeader()||this._header)?.getDomRef();if(r||s){const e=r?r.getBoundingClientRect().height:0;const t=s?s.getBoundingClientRect().height:0;this.getDomRef().style.paddingTop=e+t+"px"}if(this._oManuallySetSize){t.css({width:"auto"});return}if(S.system.desktop&&!S.browser.chrome){var n=t.width()+"x"+t.height(),a=e.css("min-width")!==e.css("width");if(n!==this._iLastWidthAndHeightWithScroll&&a){if(this._hasVerticalScrollbar()&&(!i||i=="auto")&&!this.getStretch()&&t.width()<o){e.addClass("sapMDialogVerticalScrollIncluded");t.css({"padding-right":L});this._iLastWidthAndHeightWithScroll=n}else{e.removeClass("sapMDialogVerticalScrollIncluded");t.css({"padding-right":""});this._iLastWidthAndHeightWithScroll=null}}else if(!this._hasVerticalScrollbar()||!a){e.removeClass("sapMDialogVerticalScrollIncluded");t.css({"padding-right":""});this._iLastWidthAndHeightWithScroll=null}}if(!this._oManuallySetSize&&!this._bDisableRepositioning){this._positionDialog()}};N.prototype._hasVerticalScrollbar=function(){var e=this.$("cont");return e[0].clientHeight<e[0].scrollHeight};N.prototype._positionDialog=function(){var e=this.$();e.css(this._calcMaxSizes());e.css(this._calcPosition())};N.prototype._calcPosition=function(){var e=this._getAreaDimensions(),t=this.$(),i,o,s;if(S.system.phone&&this.getStretch()){i=0;o=0}else if(this.getStretch()){i=this._percentOfSize(e.width,V);o=this._percentOfSize(e.height,$)}else{i=(e.width-t.outerWidth())/2;o=(e.height-t.outerHeight())/2}s={top:Math.round(e.top+o)};if(this._bRTL){s.right=Math.round(window.innerWidth-e.right+i)}else{s.left=Math.round(e.left+i)}return s};N.prototype._calcMaxSizes=function(){var e=this._getAreaDimensions(),t=this.$(),i=t.find(".sapMDialogTitleGroup").height()||0,o=t.find(".sapMDialogSubHeader").height()||0,s=t.find("> footer").height()||0,r=i+o+s,n,a;if(S.system.phone&&this.getStretch()){a=e.width;n=e.height-r}else{a=this._percentOfSize(e.width,100-2*V);n=this._percentOfSize(e.height,100-2*$)-r}return{maxWidth:Math.floor(a),maxHeight:Math.floor(n)}};N.prototype._getAreaDimensions=function(){var e=d.getWithinAreaDomRef(),t;if(e===window){t={left:0,top:0,width:e.innerWidth,height:e.innerHeight}}else{var i=e.getBoundingClientRect(),o=jQuery(e);t={left:i.left+parseFloat(o.css("border-left-width")),top:i.top+parseFloat(o.css("border-top-width")),width:e.clientWidth,height:e.clientHeight}}t.right=t.left+t.width;t.bottom=t.top+t.height;return t};N.prototype._percentOfSize=function(e,t){return Math.round(e*t/100)};N.prototype._createHeader=function(){if(!this._header){this._header=new s(this.getId()+"-header",{titleAlignment:this.getTitleAlignment(),ariaLabelledBy:N._getHeaderToolbarAriaLabelledByText()});this.setAggregation("_header",this._header)}};N.prototype._applyTitleToHeader=function(){var e=this.getProperty("title");if(this._headerTitle){this._headerTitle.setText(e)}else{this._headerTitle=new l(this.getId()+"-title",{text:e,level:E.H1}).addStyleClass("sapMDialogTitle");this._header.addContentMiddle(this._headerTitle)}};N.prototype._hasSingleScrollableContent=function(){var e=this.getContent();while(e.length===1&&e[0]instanceof p&&e[0].isA("sap.ui.core.mvc.View")){e=e[0].getContent()}if(e.length===1&&e[0]instanceof p&&e[0].isA(this._scrollContentList)){return true}return false};N.prototype._getFocusDomRef=function(){var e=this.getInitialFocus();if(e){return document.getElementById(e)}return this._getFocusableHeader()||this._getFirstFocusableContentSubHeader()||this._getFirstFocusableContentElement()||this._getFirstVisibleButtonDomRef()||this.getDomRef()};N.prototype._getFirstVisibleButtonDomRef=function(){var e=this.getBeginButton(),t=this.getEndButton(),i=this.getButtons(),o;if(e&&e.getVisible()){o=e.getDomRef()}else if(t&&t.getVisible()){o=t.getDomRef()}else if(i&&i.length>0){for(var s=0;s<i.length;s++){if(i[s].getVisible()){o=i[s].getDomRef();break}}}return o};N.prototype._getFocusableHeader=function(){if(!this._isDraggableOrResizable()){return null}return this.$().find("header .sapMDialogTitleGroup")[0]};N.prototype._getFirstFocusableContentSubHeader=function(){var e=this.$().find(".sapMDialogSubHeader");return e.firstFocusableDomRef()};N.prototype._getFirstFocusableContentElement=function(){var e=this.$("cont");return e.firstFocusableDomRef()};N.prototype._setInitialFocus=function(){var e=this._getFocusDomRef(),t;if(e&&e.id){t=g.getElementById(e.id)}if(t){if(t.getVisible&&!t.getVisible()){this.focus();return}e=t.getFocusDomRef()}if(!e){this.setInitialFocus("");e=this._getFocusDomRef()}if(!this.getInitialFocus()){this.setAssociation("initialFocus",e?e.id:this.getId(),true)}if(S.system.desktop||e&&!/input|textarea|select/i.test(e.tagName)){if(e){e.focus()}}else{this.focus()}};N.prototype.getScrollDelegate=function(){return this._oScroller};N.prototype._isToolbarEmpty=function(){var e=this._oToolbar.getContent().filter(function(e){return e.getMetadata().getName()!=="sap.m.ToolbarSpacer"});return e.length===0};N.prototype._getAnyHeader=function(){var e=this.getCustomHeader();if(e){return e}else{var t=this.getShowHeader();if(!t){return null}this._createHeader();this._applyTitleToHeader();this._applyIconToHeader();return this._header}};N.prototype._getAnyFooter=function(){return this.getFooter()||this._getToolbar()};N.prototype._deregisterWithinAreaResizeObserver=function(){var e=d.getWithinAreaDomRef();if(e===window){S.resize.detachHandler(this._onResize,this)}else if(this._oWithinAreaResizeObserver){this._oWithinAreaResizeObserver.disconnect();this._oWithinAreaResizeObserver=null}};N.prototype._registerWithinAreaResizeObserver=function(){var e=d.getWithinAreaDomRef();if(e===window){S.resize.attachHandler(this._onResize,this)}else{this._oWithinAreaResizeObserver=new ResizeObserver(()=>{window.requestAnimationFrame(()=>{this._onResize()})});this._oWithinAreaResizeObserver.observe(e)}this._onResize()};N.prototype._deregisterResizeObserver=function(){if(this._oResizeObserver){this._oResizeObserver.disconnect();this._oResizeObserver=null}};N.prototype._registerResizeObserver=function(){if(!this._oResizeObserver){this._oResizeObserver=new ResizeObserver(()=>{window.requestAnimationFrame(()=>{this._onResize()})});this._oResizeObserver.observe(this.getDomRef("scrollCont"));if(this.getDomRef().getElementsByClassName("sapMDialogTitleGroup")&&this.getDomRef().getElementsByClassName("sapMDialogTitleGroup").length>0){this._oResizeObserver.observe(this.getDomRef().getElementsByClassName("sapMDialogTitleGroup")[0])}}this._onResize()};N.prototype._attachHandler=function(e){var t=this;if(!this._oButtonDelegate){this._oButtonDelegate={ontap:function(){t._oCloseTrigger=this},onkeyup:function(){t._oCloseTrigger=this},onkeydown:function(){t._oCloseTrigger=this}}}if(e){e.addDelegate(this._oButtonDelegate,true,e)}};N.prototype._createToolbarButtons=function(){if(this.getFooter()){return}var e=this._getToolbar();var t=this.getButtons();var i=this.getBeginButton();var o=this.getEndButton(),s=this,r=[i,o];r.forEach(function(e){if(e&&s._oButtonDelegate){e.removeDelegate(s._oButtonDelegate)}});e.removeAllContent();if(!("_toolbarSpacer"in this)){this._toolbarSpacer=new a}e.addContent(this._toolbarSpacer);r.forEach(function(e){s._attachHandler(e)});if(t&&t.length){t.forEach(function(t){e.addContent(t)})}else{if(i){e.addContent(i)}if(o){e.addContent(o)}}};N.prototype._getToolbar=function(){if(!this._oToolbar){this._oToolbar=new n(this.getId()+"-footer",{ariaLabelledBy:N._getFooterToolbarAriaLabelledByText()}).addStyleClass("sapMTBNoBorders");this._oToolbar.addDelegate({onAfterRendering:function(){if(this.getType()===M.Message){this.$("footer").removeClass("sapContrast sapContrastPlus")}}},false,this);this.setAggregation("_toolbar",this._oToolbar)}return this._oToolbar};N.prototype.getValueStateString=function(e){var t=o.getResourceBundleFor("sap.m");switch(e){case w.Success:return t.getText("LIST_ITEM_STATE_SUCCESS");case w.Warning:return t.getText("LIST_ITEM_STATE_WARNING");case w.Error:return t.getText("LIST_ITEM_STATE_ERROR");case w.Information:return t.getText("LIST_ITEM_STATE_INFORMATION");default:return""}};N.prototype._isDraggableOrResizable=function(){return!this.getStretch()&&(this.getDraggable()||this.getResizable())};N.prototype._getAriaDescribedByText=function(){var e=o.getResourceBundleFor("sap.m");if(this.getResizable()&&this.getDraggable()){return e.getText("DIALOG_HEADER_ARIA_DESCRIBEDBY_DRAGGABLE_RESIZABLE")}if(this.getDraggable()){return e.getText("DIALOG_HEADER_ARIA_DESCRIBEDBY_DRAGGABLE")}if(this.getResizable()){return e.getText("DIALOG_HEADER_ARIA_DESCRIBEDBY_RESIZABLE")}return""};N.prototype._loadVerticalMargin=function(){$=b.get({name:"_sap_m_Dialog_VerticalMargin",callback:function(e){$=parseFloat(e)}});if($){$=parseFloat($)}else{$=3}};N.prototype.setSubHeader=function(e){this.setAggregation("subHeader",e);if(e){e.setVisible=function(t){e.setProperty("visible",t);this.invalidate()}.bind(this)}return this};N.prototype.setLeftButton=function(e){if(typeof e==="string"){e=g.getElementById(e)}this.setBeginButton(e);return this.setAssociation("leftButton",e)};N.prototype.setRightButton=function(e){if(typeof e==="string"){e=g.getElementById(e)}this.setEndButton(e);return this.setAssociation("rightButton",e)};N.prototype.getLeftButton=function(){var e=this.getBeginButton();return e?e.getId():null};N.prototype.getRightButton=function(){var e=this.getEndButton();return e?e.getId():null};N.prototype.setBeginButton=function(e){if(e&&e.isA("sap.m.Button")){e.addStyleClass("sapMDialogBeginButton")}return this.setAggregation("beginButton",e)};N.prototype.setEndButton=function(e){if(e&&e.isA("sap.m.Button")){e.addStyleClass("sapMDialogEndButton")}return this.setAggregation("endButton",e)};N.prototype.getAggregation=function(e,t,i){var o=p.prototype.getAggregation.apply(this,Array.prototype.slice.call(arguments,0,2));if(e==="buttons"&&o&&o.length===0){this.getBeginButton()&&o.push(this.getBeginButton());this.getEndButton()&&o.push(this.getEndButton())}return o};N.prototype.getAriaLabelledBy=function(){var e=this._getAnyHeader(),t=this.getAssociation("ariaLabelledBy",[]).slice();var i=this.getSubHeader();if(i){var o=this._getTitles(i);if(o.length){t=o.map(function(e){return e.getId()}).concat(t)}}if(e){var s=this._getTitles(e);if(s.length){t=s.map(function(e){return e.getId()}).concat(t)}else{t.unshift(e.getId())}}return t};N.prototype._applyIconToHeader=function(){var e=this.getIcon();if(!e){if(this._iconImage){this._iconImage.destroy();this._iconImage=null}return}if(!this._iconImage){this._iconImage=c.createControlByURI({id:this.getId()+"-icon",src:e,useIconTooltip:false},u).addStyleClass("sapMDialogIcon");this._header.insertAggregation("contentMiddle",this._iconImage,0)}this._iconImage.setSrc(e)};N.prototype.setInitialFocus=function(e){return this.setAssociation("initialFocus",e,true)};N.prototype.invalidate=function(e){if(this.isOpen()){p.prototype.invalidate.call(this,e)}};function k(e){var t=jQuery(e);var i=g.closestTo(e);if(t.parents(".sapMDialogSection").length){return false}if(!i||i.isA("sap.m.IBar")){return true}return t.hasClass("sapMDialogTitleGroup")}if(S.system.desktop){N.prototype.ondblclick=function(e){if(k(e.target)){var t=this.$("cont");this._bDisableRepositioning=false;this._oManuallySetPosition=null;this._oManuallySetSize=null;this.oPopup&&this.oPopup._applyPosition(this.oPopup._oLastPosition,true);t.css({height:"100%"})}};N.prototype.onmousedown=function(e){if(e.which===3){return}if(!this._isDraggableOrResizable()){return}var t;var i=this;var o=jQuery(document);var s=jQuery(e.target);var r=e.target.closest(".sapMDialogResizeHandle")&&this.getResizable();var n=function(e){t=t?clearTimeout(t):setTimeout(function(){e()},0)};var a=this._getAreaDimensions();var l=this.getDomRef().getBoundingClientRect();var h={x:e.clientX,y:e.clientY,width:i._$dialog.width(),height:i._$dialog.height(),outerHeight:i._$dialog.outerHeight(),position:{x:l.x,y:l.y}};var u;function p(){var e=i.$(),t=i.$("cont"),s,n;i.removeStyleClass("sapMDialogDisableSelection");o.off("mouseup",p);o.off("mousemove",u);if(r){s=parseInt(e.height());n=parseInt(e.css("border-top-width"))+parseInt(e.css("border-bottom-width"));t.height(s+n)}}if(k(e.target)&&this.getDraggable()||r){i._bDisableRepositioning=true}if(k(e.target)&&this.getDraggable()){u=function(t){t.preventDefault();if(t.buttons===0){p();return}n(function(){i._bDisableRepositioning=true;i._oManuallySetPosition={x:Math.max(a.left,Math.min(t.clientX-e.clientX+h.position.x,a.right-h.width)),y:Math.max(a.top,Math.min(t.clientY-e.clientY+h.position.y,a.bottom-h.outerHeight))};i._$dialog.css({top:i._oManuallySetPosition.y,left:i._oManuallySetPosition.x,right:i._bRTL?"":undefined})})}}else if(r){var g={};var c=parseInt(i._$dialog.css("min-width"));var d=h.x+h.width-c;var f=s.width()-e.offsetX;var _=s.height()-e.offsetY;u=function(e){n(function(){i._bDisableRepositioning=true;i.$("cont").height("").width("");if(e.clientY+_>a.bottom){e.clientY=a.bottom-_}if(e.clientX+f>a.right){e.clientX=a.right-f}i._oManuallySetSize={width:h.width+e.clientX-h.x,height:h.height+e.clientY-h.y};if(i._bRTL){g.left=Math.min(Math.max(e.clientX,0),d);i._oManuallySetSize.width=h.width+h.x-Math.max(e.clientX,0)}g.width=i._oManuallySetSize.width;g.height=i._oManuallySetSize.height;i._$dialog.css(g)})}}else{return}this.addStyleClass("sapMDialogDisableSelection");o.on("mousemove",u);o.on("mouseup",p);e.stopPropagation()}}N.prototype._applyContextualSettings=function(){p.prototype._applyContextualSettings.call(this)};N.prototype._getTitles=function(e){return e.findAggregatedObjects(true,function(e){return e.isA("sap.m.Title")})};return N});
//# sourceMappingURL=Dialog.js.map