/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Lib","sap/ui/core/date/UI5Date","sap/ui/core/Element","./Label","./StepInput","./DateTimePicker","sap/ui/unified/Calendar","sap/ui/unified/DateRange","sap/ui/unified/calendar/MonthPicker","sap/ui/unified/calendar/CustomMonthPicker","sap/ui/core/format/TimezoneUtil"],function(e,t,a,n,r,o,i,s,c,u,l){"use strict";var g=a.extend("sap.m.DynamicDateOption",{metadata:{library:"sap.m",properties:{key:{type:"string"},valueTypes:{type:"string[]"}}}});g.prototype.getText=function(e){return this.getKey()};g.prototype.getValueHelpUITypes=function(e){throw new Error("Need implementation for method getValueHelpUITypes. Option: "+this.getKey())};g.prototype.createValueHelpUI=function(e,t){var a=e.getValue()&&Object.assign({},e.getValue()),r=this.getValueHelpUITypes(e),o=r.length,i=[],s;if(!e.aControlsByParameters){e.aControlsByParameters={}}e.aControlsByParameters[this.getKey()]=[];if(a&&a.values){a.values=a.values.map(function(e){return e})}for(var c=0;c<r.length;c++){if(r[c].getText()){i.push(new n({text:r[c].getText(),width:"100%"}))}s=this._createControl(c,r[c].getType(),a,t,o);i.push(s);e.aControlsByParameters[this.getKey()].push(s)}return i};g.prototype.validateValueHelpUI=function(e){var t=this.getValueHelpUITypes();for(var a=0;a<t.length;a++){var n=e.aControlsByParameters[this.getKey()][a];switch(t[a].getType()){case"int":if(n._isLessThanMin(n.getValue())||n._isMoreThanMax(n.getValue())){return false}break;case"month":case"custommonth":case"date":case"daterange":if(!n.getSelectedDates()||n.getSelectedDates().length==0){return false}break;case"datetime":if(!n.getDateValue()){return false}break}}return true};g.prototype.getValueHelpOutput=function(e){var t=this.getValueHelpUITypes(),a={},n;a.operator=this.getKey();a.values=[];for(var r=0;r<t.length;r++){var o=e.aControlsByParameters[this.getKey()][r];switch(t[r].getType()){case"int":n=o.getValue();break;case"month":case"date":if(!o.getSelectedDates().length){return null}n=o.getSelectedDates()[0].getStartDate();break;case"custommonth":if(!o.getSelectedDates()||!o.getSelectedDates().length){return null}n=[o.getSelectedDates()[0].getStartDate().getMonth(),o.getSelectedDates()[0].getStartDate().getFullYear()];break;case"datetime":if(!o.getDateValue()){return null}n=o.getDateValue();break;case"daterange":if(!o.getSelectedDates().length){return null}var i=o.getSelectedDates()[0].getEndDate()||o.getSelectedDates()[0].getStartDate();n=[o.getSelectedDates()[0].getStartDate(),i];break;default:break}if(Array.isArray(n)){a.values=Array.prototype.concat.apply(a.values,n)}else{n&&a.values.push(n)}}return a};g.prototype.getGroup=function(){return 0};g.prototype.getGroupHeader=function(){var t=this.getGroup()>-1&&this.getGroup()<7?this.getGroup():0;return e.getResourceBundleFor("sap.m").getText("DDR_OPTIONS_GROUP_"+t)};g.prototype.format=function(e){throw new Error("Need implementation for method format. Option: "+this.getKey())};g.prototype.parse=function(e){throw new Error("Need implementation for method parse. Option: "+this.getKey())};g.prototype.toDates=function(e,t){throw new Error("Need implementation for method toDates. Option: "+this.getKey())};g.prototype.enhanceFormattedValue=function(){return false};g.prototype._createControl=function(e,t,a,n,r){var o;switch(t){case"int":o=this._createIntegerControl(a,e,n);break;case"date":o=this._createDateControl(a,e,n);break;case"datetime":if(r===1){o=this._createDateTimeInnerControl(a,e,n)}else if(r===2){o=this._createDateTimeControl(a,e,n)}break;case"daterange":o=this._createDateRangeControl(a,e,n);break;case"month":o=this._createMonthControl(a,e,n);break;case"custommonth":o=this._createCustomMonthControl(a,e,n);break;default:break}return o};g.prototype._createIntegerControl=function(e,t,a){var n=new r({width:"120px"});if(e&&this.getKey()===e.operator){n.setValue(e.values[t])}if(a instanceof Function){n.attachChange(function(){a(this)},this)}return n};g.prototype._createDateTimeControl=function(e,t,a,n,r){var i=new o({timezone:l.getLocalTimezone(),calendarWeekNumbering:r});if(e&&this.getKey()===e.operator){i.setDateValue(e.values[t])}if(a instanceof Function){i.attachChange(function(){a(this)},this)}return i};g.prototype._createDateControl=function(e,a,n,r){var o=new i({width:"100%",calendarWeekNumbering:r});var c;if(e&&this.getKey()===e.operator){c=t.getInstance(e.values[a].getTime());o.addSelectedDate(new s({startDate:c}))}if(n instanceof Function){o.attachSelect(function(){n(this)},this)}return o};g.prototype._createDateTimeInnerControl=function(e,a,n,r){var i=new o({width:"100%",calendarWeekNumbering:r}),c;i._createPopup();i._createPopupContent();c=i._oPopupContent;c.setForcePhoneView(true);c.getCalendar().removeAllSelectedDates();if(e&&this.getKey()===e.operator){var u=t.getInstance(e.values[a]);c.getCalendar().addSelectedDate(new s({startDate:u}));c.getClocks()._setTimeValues(u)}if(n instanceof Function){c.getClocks().getAggregation("_clocks").forEach(function(e){e.attachChange(function(e){n(this)}.bind(this))}.bind(this));if(c.getClocks().getAggregation("_buttonAmPm")){c.getClocks().getAggregation("_buttonAmPm").attachSelectionChange(function(e){n(this)}.bind(this))}c.getCalendar().attachSelect(function(){n(this)},this)}return c};g.prototype._createDateRangeControl=function(e,a,n,r){var o=new i({intervalSelection:true,width:"100%",calendarWeekNumbering:r});if(e&&this.getKey()===e.operator){var c=t.getInstance(e.values[a].getTime());var u=t.getInstance(e.values[a+1].getTime());o.addSelectedDate(new s({startDate:c,endDate:u}))}if(n instanceof Function){o.attachSelect(function(){n(this)},this)}return o};g.prototype._createMonthControl=function(e,a,n){var r=new c,o=t.getInstance(),i=e&&this.getKey()===e.operator?e.values[a]:o.getMonth();r.setMonth(i);r.addSelectedDate(new s({startDate:o}));if(n instanceof Function){r.attachSelect(function(){n(this)},this)}return r};g.prototype._createCustomMonthControl=function(e,a,n){var r=new u,o=t.getInstance(),i=e&&a>=0&&this.getKey()===e.operator?e.values[a]:o.getMonth(),c=e&&a>=0&&this.getKey()===e.operator?e.values[a+1]:o.getFullYear();o.setDate(1);o.setMonth(i);o.setFullYear(c);r.addSelectedDate(new s({startDate:o}));if(n instanceof Function){r.attachSelect(function(){n(this)},this)}return r};return g});
//# sourceMappingURL=DynamicDateOption.js.map