/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/base/i18n/date/CalendarWeekNumbering","sap/ui/core/InvisibleText","sap/ui/core/Element","sap/ui/core/Control","sap/ui/core/Lib","sap/ui/core/ListItem","sap/ui/core/library","sap/ui/core/Renderer","sap/ui/core/message/MessageMixin","sap/m/DynamicDateFormat","sap/ui/core/IconPool","sap/ui/core/Icon","sap/ui/core/LabelEnablement","sap/ui/core/date/UniversalDate","sap/ui/core/format/DateFormat","sap/ui/base/ManagedObjectObserver","sap/ui/Device","./Label","./GroupHeaderListItem","./StandardListItem","./StandardListItemRenderer","./Button","./List","./Input","./InputRenderer","./Toolbar","./ResponsivePopover","./Page","./NavContainer","./DynamicDateRangeRenderer","./StandardDynamicDateOption","./library","sap/ui/thirdparty/jquery","sap/ui/unified/calendar/CalendarUtils","sap/ui/core/CustomData"],function(e,t,i,o,n,a,s,r,u,p,l,T,E,h,g,d,A,S,D,c,y,f,_,R,I,N,O,v,L,m,C,U,b,jQuery,M,Y){"use strict";var H=r.ValueState,P=b.ToolbarDesign,F=b.ToolbarStyle,w=b.ListType,V=b.ListMode,X=b.ListSeparators,k=a.getResourceBundleFor("sap.m");var K={TODAY:new U({key:"TODAY",valueTypes:[]}),YESTERDAY:new U({key:"YESTERDAY",valueTypes:[]}),TOMORROW:new U({key:"TOMORROW",valueTypes:[]}),FIRSTDAYWEEK:new U({key:"FIRSTDAYWEEK",valueTypes:[]}),LASTDAYWEEK:new U({key:"LASTDAYWEEK",valueTypes:[]}),FIRSTDAYMONTH:new U({key:"FIRSTDAYMONTH",valueTypes:[]}),LASTDAYMONTH:new U({key:"LASTDAYMONTH",valueTypes:[]}),FIRSTDAYQUARTER:new U({key:"FIRSTDAYQUARTER",valueTypes:[]}),LASTDAYQUARTER:new U({key:"LASTDAYQUARTER",valueTypes:[]}),FIRSTDAYYEAR:new U({key:"FIRSTDAYYEAR",valueTypes:[]}),LASTDAYYEAR:new U({key:"LASTDAYYEAR",valueTypes:[]}),THISWEEK:new U({key:"THISWEEK",valueTypes:[]}),THISMONTH:new U({key:"THISMONTH",valueTypes:[]}),THISQUARTER:new U({key:"THISQUARTER",valueTypes:[]}),THISYEAR:new U({key:"THISYEAR",valueTypes:[]}),LASTWEEK:new U({key:"LASTWEEK",valueTypes:[]}),LASTMONTH:new U({key:"LASTMONTH",valueTypes:[]}),LASTQUARTER:new U({key:"LASTQUARTER",valueTypes:[]}),LASTYEAR:new U({key:"LASTYEAR",valueTypes:[]}),NEXTWEEK:new U({key:"NEXTWEEK",valueTypes:[]}),NEXTMONTH:new U({key:"NEXTMONTH",valueTypes:[]}),NEXTQUARTER:new U({key:"NEXTQUARTER",valueTypes:[]}),NEXTYEAR:new U({key:"NEXTYEAR",valueTypes:[]}),LASTMINUTES:new U({key:"LASTMINUTES",valueTypes:["int"]}),LASTHOURS:new U({key:"LASTHOURS",valueTypes:["int"]}),LASTDAYS:new U({key:"LASTDAYS",valueTypes:["int"]}),LASTWEEKS:new U({key:"LASTWEEKS",valueTypes:["int"]}),LASTMONTHS:new U({key:"LASTMONTHS",valueTypes:["int"]}),LASTQUARTERS:new U({key:"LASTQUARTERS",valueTypes:["int"]}),LASTYEARS:new U({key:"LASTYEARS",valueTypes:["int"]}),NEXTMINUTES:new U({key:"NEXTMINUTES",valueTypes:["int"]}),NEXTHOURS:new U({key:"NEXTHOURS",valueTypes:["int"]}),NEXTDAYS:new U({key:"NEXTDAYS",valueTypes:["int"]}),NEXTWEEKS:new U({key:"NEXTWEEKS",valueTypes:["int"]}),NEXTMONTHS:new U({key:"NEXTMONTHS",valueTypes:["int"]}),NEXTQUARTERS:new U({key:"NEXTQUARTERS",valueTypes:["int"]}),NEXTYEARS:new U({key:"NEXTYEARS",valueTypes:["int"]}),LASTMINUTESINCLUDED:new U({key:"LASTMINUTESINCLUDED",valueTypes:["int","included"]}),LASTHOURSINCLUDED:new U({key:"LASTHOURSINCLUDED",valueTypes:["int","included"]}),LASTDAYSINCLUDED:new U({key:"LASTDAYSINCLUDED",valueTypes:["int","included"]}),LASTWEEKSINCLUDED:new U({key:"LASTWEEKSINCLUDED",valueTypes:["int","included"]}),LASTMONTHSINCLUDED:new U({key:"LASTMONTHSINCLUDED",valueTypes:["int","included"]}),LASTQUARTERSINCLUDED:new U({key:"LASTQUARTERSINCLUDED",valueTypes:["int","included"]}),LASTYEARSINCLUDED:new U({key:"LASTYEARSINCLUDED",valueTypes:["int","included"]}),NEXTMINUTESINCLUDED:new U({key:"NEXTMINUTESINCLUDED",valueTypes:["int","included"]}),NEXTHOURSINCLUDED:new U({key:"NEXTHOURSINCLUDED",valueTypes:["int","included"]}),NEXTDAYSINCLUDED:new U({key:"NEXTDAYSINCLUDED",valueTypes:["int","included"]}),NEXTWEEKSINCLUDED:new U({key:"NEXTWEEKSINCLUDED",valueTypes:["int","included"]}),NEXTMONTHSINCLUDED:new U({key:"NEXTMONTHSINCLUDED",valueTypes:["int","included"]}),NEXTQUARTERSINCLUDED:new U({key:"NEXTQUARTERSINCLUDED",valueTypes:["int","included"]}),NEXTYEARSINCLUDED:new U({key:"NEXTYEARSINCLUDED",valueTypes:["int","included"]}),FROM:new U({key:"FROM",valueTypes:["date"]}),TO:new U({key:"TO",valueTypes:["date"]}),FROMDATETIME:new U({key:"FROMDATETIME",valueTypes:["datetime"]}),TODATETIME:new U({key:"TODATETIME",valueTypes:["datetime"]}),YEARTODATE:new U({key:"YEARTODATE",valueTypes:[]}),DATETOYEAR:new U({key:"DATETOYEAR",valueTypes:[]}),TODAYFROMTO:new U({key:"TODAYFROMTO",valueTypes:["int","int"]}),QUARTER1:new U({key:"QUARTER1",valueTypes:[]}),QUARTER2:new U({key:"QUARTER2",valueTypes:[]}),QUARTER3:new U({key:"QUARTER3",valueTypes:[]}),QUARTER4:new U({key:"QUARTER4",valueTypes:[]}),SPECIFICMONTH:new U({key:"SPECIFICMONTH",valueTypes:["int"]}),SPECIFICMONTHINYEAR:new U({key:"SPECIFICMONTHINYEAR",valueTypes:["int","int"]}),DATERANGE:new U({key:"DATERANGE",valueTypes:["date","date"]}),DATE:new U({key:"DATE",valueTypes:["date"]}),DATETIME:new U({key:"DATETIME",valueTypes:["datetime"]}),DATETIMERANGE:new U({key:"DATETIMERANGE",valueTypes:["datetime","datetime"]})};var x=["DATE","TODAY","YESTERDAY","TOMORROW","FIRSTDAYWEEK","LASTDAYWEEK","FIRSTDAYMONTH","LASTDAYMONTH","FIRSTDAYQUARTER","LASTDAYQUARTER","FIRSTDAYYEAR","LASTDAYYEAR","DATERANGE","DATETIMERANGE","FROM","TO","FROMDATETIME","TODATETIME","YEARTODATE","DATETOYEAR","LASTMINUTES","LASTHOURS","LASTDAYS","LASTWEEKS","LASTMONTHS","LASTQUARTERS","LASTYEARS","NEXTMINUTES","NEXTHOURS","NEXTDAYS","NEXTWEEKS","NEXTMONTHS","NEXTQUARTERS","NEXTYEARS","LASTMINUTESINCLUDED","LASTHOURSINCLUDED","LASTDAYSINCLUDED","LASTWEEKSINCLUDED","LASTMONTHSINCLUDED","LASTQUARTERSINCLUDED","LASTYEARSINCLUDED","NEXTMINUTESINCLUDED","NEXTHOURSINCLUDED","NEXTDAYSINCLUDED","NEXTWEEKSINCLUDED","NEXTMONTHSINCLUDED","NEXTQUARTERSINCLUDED","NEXTYEARSINCLUDED","TODAYFROMTO","THISWEEK","LASTWEEK","NEXTWEEK","SPECIFICMONTH","SPECIFICMONTHINYEAR","THISMONTH","LASTMONTH","NEXTMONTH","THISQUARTER","LASTQUARTER","NEXTQUARTER","QUARTER1","QUARTER2","QUARTER3","QUARTER4","THISYEAR","LASTYEAR","NEXTYEAR","DATETIME"];var G={SingleDates:1,DateRanges:2,Weeks:3,Month:4,Quarters:5,Years:6};var W=n.extend("sap.m.DynamicDateRange",{metadata:{library:"sap.m",properties:{value:{type:"object",group:"Data"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:H.None},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueStateText:{type:"string",group:"Misc",defaultValue:null},required:{type:"boolean",group:"Misc",defaultValue:false},enableGroupHeaders:{type:"boolean",group:"Behavior",defaultValue:true},formatter:{type:"object"},standardOptions:{type:"string[]",group:"Behavior",defaultValue:["DATE","TODAY","YESTERDAY","TOMORROW","FIRSTDAYWEEK","LASTDAYWEEK","FIRSTDAYMONTH","LASTDAYMONTH","FIRSTDAYQUARTER","LASTDAYQUARTER","FIRSTDAYYEAR","LASTDAYYEAR","DATERANGE","DATETIMERANGE","FROM","TO","FROMDATETIME","TODATETIME","YEARTODATE","DATETOYEAR","LASTMINUTES","LASTHOURS","LASTDAYS","LASTWEEKS","LASTMONTHS","LASTQUARTERS","LASTYEARS","LASTMINUTESINCLUDED","LASTHOURSINCLUDED","LASTDAYSINCLUDED","LASTWEEKSINCLUDED","LASTMONTHSINCLUDED","LASTQUARTERSINCLUDED","LASTYEARSINCLUDED","NEXTMINUTES","NEXTHOURS","NEXTDAYS","NEXTWEEKS","NEXTMONTHS","NEXTQUARTERS","NEXTYEARS","NEXTMINUTESINCLUDED","NEXTHOURSINCLUDED","NEXTDAYSINCLUDED","NEXTWEEKSINCLUDED","NEXTMONTHSINCLUDED","NEXTQUARTERSINCLUDED","NEXTYEARSINCLUDED","TODAYFROMTO","THISWEEK","LASTWEEK","NEXTWEEK","SPECIFICMONTH","SPECIFICMONTHINYEAR","THISMONTH","LASTMONTH","NEXTMONTH","THISQUARTER","LASTQUARTER","NEXTQUARTER","QUARTER1","QUARTER2","QUARTER3","QUARTER4","THISYEAR","LASTYEAR","NEXTYEAR","DATETIME"]},hideInput:{type:"boolean",group:"Misc",defaultValue:false},calendarWeekNumbering:{type:"sap.base.i18n.date.CalendarWeekNumbering",group:"Appearance",defaultValue:null},showClearIcon:{type:"boolean",defaultValue:false}},aggregations:{customOptions:{type:"sap.m.DynamicDateOption",multiple:true},_input:{type:"sap.m.Input",multiple:false,visibility:"hidden"},_popup:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{change:{parameters:{value:{type:"object"},valid:{type:"boolean"}}}}},renderer:C});p.call(W.prototype);var B=["LASTMINUTES","LASTHOURS","LASTMINUTESINCLUDED","LASTHOURSINCLUDED"];var Q=["NEXTMINUTES","NEXTHOURS","NEXTMINUTESINCLUDED","NEXTHOURSINCLUDED"];var j=B.concat(Q);var q=["LASTMINUTES","LASTHOURS","LASTDAYS","LASTWEEKS","LASTMONTHS","LASTQUARTERS","LASTYEARS"];var z=["NEXTMINUTES","NEXTHOURS","NEXTDAYS","NEXTWEEKS","NEXTMONTHS","NEXTQUARTERS","NEXTYEARS"];var J=["LASTMINUTESINCLUDED","LASTHOURSINCLUDED","LASTDAYSINCLUDED","LASTWEEKSINCLUDED","LASTMONTHSINCLUDED","LASTQUARTERSINCLUDED","LASTYEARSINCLUDED"];var $=["NEXTMINUTESINCLUDED","NEXTHOURSINCLUDED","NEXTDAYSINCLUDED","NEXTWEEKSINCLUDED","NEXTMONTHSINCLUDED","NEXTQUARTERSINCLUDED","NEXTYEARSINCLUDED"];W.prototype.init=function(){var e=!S.support.touch||S.system.desktop?true:false;this._oInput=new ee(this.getId()+"-input",{valueHelpIconSrc:T.getIconURI("sap-icon://check-availability"),valueHelpRequest:this._toggleOpen.bind(this),showSuggestion:true,suggest:this._handleSuggest.bind(this)});this._oListItemDelegate=undefined;this._onBeforeInputRenderingDelegate={onBeforeRendering:function(){this._oInput._getValueHelpIcon().setVisible(true)}};this._oInput._getValueHelpIcon().setDecorative(e);this._oInput._getValueHelpIcon().setTooltip(k.getText("OPEN_PICKER_TEXT"));this._oInput.addDelegate(this._onBeforeInputRenderingDelegate,this);this.setAggregation("_input",this._oInput,false);this._oInput._setControlOrigin(this);this._oInput.attachChange(this._handleInputChange,this);this.oValueObserver=new A(function(){delete this.oBoundValueFormatter}.bind(this));this.oValueObserver.observe(this,{bindings:["value"]})};W.prototype.exit=function(){this._oInput.removeDelegate(this._onBeforeInputRenderingDelegate);this._onBeforeInputRenderingDelegate=undefined;this.oValueObserver.destroy();this._infoDatesFooter=undefined;this.aInputControls=undefined;this._removeAllListItemDelegates()};W.prototype._removeAllListItemDelegates=function(){if(this._oOptionsList){this._oOptionsList.getItems().forEach(function(e){e.removeDelegate(this._oListItemDelegate)},this)}};W.prototype.getValue=function(){return this.getProperty("value")};W.prototype.getFormatter=function(){return this.getProperty("formatter")};W.prototype.setFormatter=function(e){this.setProperty("formatter",e);return this};W.prototype.setTooltip=function(e){this._oInput.setTooltip(e);return n.prototype.setTooltip.apply(this,arguments)};W.prototype.setShowClearIcon=function(e){this.setProperty("showClearIcon",e);this._oInput.setShowClearIcon(e);return this};W.prototype.onBeforeRendering=function(){this._updateInputValue(this.getValue());this._oInput.setEditable(this.getEditable());this._oInput.setEnabled(this.getEnabled());this._oInput.setRequired(this.getRequired());this._oInput.setName(this.getName());this._oInput.setWidth(this.getWidth());this._oInput.setPlaceholder(this.getPlaceholder());this._oInput.setValueState(this.getValueState());this._oInput.setValueStateText(this.getValueStateText());this.setValue(this._substituteMissingValue(this.getValue()))};W.prototype.setValue=function(e){var t=e&&e.operator;e=this._substituteValue(e);this.setProperty("value",e);this._oSelectedOption=this.getOption(t);this._updateInputValue(e);return this};W.prototype._toggleOpen=function(){if(this._oPopup&&this._oPopup.isOpen()){this._closePopup()}else{this.open()}};W.prototype.open=function(e){if(this.getEditable()&&this.getEnabled()){this._createPopup();this._createPopupContent();if(!this._oListItemDelegate){this._oListItemDelegate={onsapshow:this._closePopup.bind(this),onsaphide:this._closePopup.bind(this)}}this._removeAllListItemDelegates();this._oOptionsList.destroyAggregation("items");this._collectValueHelpItems(this._getOptions(),true).map(function(e){if(typeof e==="string"){return this._createHeaderListItem(e)}if(e.getKey()==="FROMDATETIME"){e._bAdditionalTimeText=!!this._findOption("FROM")}else if(e.getKey()==="TODATETIME"){e._bAdditionalTimeText=!!this._findOption("TO")}else if(e.getKey()==="DATETIMERANGE"){e._bAdditionalTimeText=!!this._findOption("DATERANGE")}return this._createListItem(e)},this).forEach(function(e){e.addDelegate(this._oListItemDelegate,this);this._oOptionsList.addItem(e)},this);this._oNavContainer.to(this._oNavContainer.getPages()[0]);this._openPopup(e)}};W.prototype._findOption=function(e){return this._getOptions().find(function(t){return t.getKey()===e})};W.prototype.addStandardOption=function(e){var t=this.getStandardOptions();if(t.indexOf(e)===-1){t.push(e)}this.setStandardOptions(t)};W.prototype.getFocusDomRef=function(){return this.getAggregation("_input")&&this.getAggregation("_input").getFocusDomRef()};W.prototype._updateInputValue=function(e){var t;if(e&&e.operator!=="PARSEERROR"){t=this._enhanceInputValue(this._formatValue(e),e);this._oInput.setValue(t)}else if(e===undefined){this._oInput.setValue("")}};W.prototype._handleSuggest=function(e){this._bSuggestionMode=true;if(this._oPopup&&this._oPopup.isOpen()){this._closePopup()}var t=e.getParameter("suggestValue");this._oInput.removeAllSuggestionItems();var i=this._getOptions().filter(function(e){var i={operator:e.getKey(),values:[]},o=e.getValueHelpUITypes(this);if(o.length&&o[0].getType()){return false}var n=this.getOption(i.operator).format(i,this._getFormatter()).toLowerCase();var a=n.indexOf(t.toLowerCase());return a===0||a>0&&n[a-1]===" "},this);this._collectValueHelpItems(i,true).forEach(function(e){if(e.getKey){var t={operator:e.getKey(),values:[]};this._addSuggestionItem(t)}else{this._addSuggestionGroupItem(e)}},this);var o=t.match(/\d+/);if(!o){this._bSuggestionMode=false;return}i=this._getOptions().filter(function(e){return e.getValueHelpUITypes(this).length===1&&e.getValueHelpUITypes(this)[0].getType()==="int"},this);this._collectValueHelpItems(i,false).forEach(function(e){if(e.getKey){var t={operator:e.getKey(),values:[parseInt(o[0])]};this._addSuggestionItem(t)}else{this._addSuggestionGroupItem(e)}},this);this._bSuggestionMode=false};W.prototype.getOption=function(e){return this._getOptions().find(function(t){return t.getKey()===e})};W.prototype.toDates=function(e){var t=e.operator;return this.getOption(t).toDates(e,this.getCalendarWeekNumbering())};W.prototype._getGroups=function(){if(!this.oDynamicDateRangeGroups){this.oDynamicDateRangeGroups=JSON.parse(JSON.stringify(G))}return this.oDynamicDateRangeGroups};W.prototype._getCustomGroupHeader=function(e){var t=this._customGroupHeaders.find(t=>t.name===e);return t.header};W.prototype.addGroup=function(e,t){this._getGroups()[e]=Object.keys(this._getGroups()).length+1;if(!this._customGroupHeaders){this._customGroupHeaders=[]}this._customGroupHeaders.push({name:e,header:t})};W.prototype.setGroupHeader=function(e,t){this._customGroupHeaders.find(t=>t.name===e).header=t};W.prototype.removeCustomGroups=function(){const e=Object.keys(G).length;for(const t in this._getGroups()){if(this._getGroups()[t]>e){delete this._getGroups()[t]}}delete this._customGroupHeaders};W.prototype._getOptions=function(){var e=this.getStandardOptions();var t=e.map(function(e){return K[e]},this);var i=t.filter(Boolean);var o=this.getAggregation("customOptions");if(o){return i.concat(o)}return i};W.prototype._getValueHelpTypeForFormatter=function(){var e=this._oSelectedOption?this._oSelectedOption.getKey():"",t=this.lastOptionsIndex(e),i=this.nextOptionsIndex(e),o=this._oNavContainer?this._oNavContainer.getPages()[1].getContent()[3]||[]:[],n=o,a=this.getAggregation("_input").getAggregation("suggestionItems"),s=this.getValue(),r=this.getStandardOptions(),u="",p=[],l=[],T,E,h,g;if(!s&&!n&&a&&a.length&&a[a.length-1].getCustomData){T=a[a.length-1].getCustomData()[0]}if(this._bSuggestionMode&&a&&a.length&&a[a.length-1].getCustomData){T=a[a.length-1].getCustomData()[0]}r.forEach(function(e){if(this.lastOptionsIndex(e)>-1){p.push(e)}else if(this.nextOptionsIndex(e)>-1){l.push(e)}}.bind(this));if(T){g=T.getValue();t=B.indexOf(g);i=Q.indexOf(g)}if(T&&g){if(j.indexOf(g)>-1){h="datetime";return h}}if(this._oNavContainer||this._oNavContainer&&(t>-1||i>-1)){if((B.indexOf(e)>-1||Q.indexOf(e)>-1)&&n){u=this._oSelectedOption.getKey().slice(0,4)+n.getSelectedKey()}if(j.indexOf(u)>-1){h="datetime";return h}}E=this._oSelectedOption?this._oSelectedOption.getValueHelpUITypes():[];return E&&E.length?E[0].getType():""};W.prototype._getDatesLabelFormatter=function(){var e,t=this._getValueHelpTypeForFormatter();switch(t){case"datetime":e=Object.create(this._getFormatter()._dateTimeFormatter.oFormatOptions);e.singleIntervalValue=true;e.interval=true;this._oDatesLabelFormatter=d.getDateTimeInstance(e);break;default:e=Object.create(this._getFormatter()._dateFormatter.oFormatOptions);e.singleIntervalValue=true;e.interval=true;this._oDatesLabelFormatter=d.getInstance(e)}return this._oDatesLabelFormatter};W.prototype._destroyInputControls=function(){if(!this.aInputControls){return}this.aInputControls.forEach(function(e){e.destroy()});this.aInputControls=undefined};W.prototype._addSuggestionItem=function(e){var t=this.toDates(e,this.getCalendarWeekNumbering());var i=[];for(var o=0;o<t.length;o++){i[o]=t[o]}var n=new s({text:this.getOption(e.operator).format(e,this._getFormatter()),additionalText:"",customData:[new Y({key:"operator",value:e.operator})]});this._oInput.addSuggestionItem(n);n.setAdditionalText(this._getDatesLabelFormatter().format(i))};W.prototype._addSuggestionGroupItem=function(e){this._oInput.addSuggestionItemGroup({text:e})};W.prototype._handleInputChange=function(e){var t=e.getParameter("value");var i=this._parseValue(this._stripValue(t));var o=this.getValue();var n=t.trim()===""||!!i;if(this._isDateRange(i)){this._swapDates(i.values)}if(!n){this.setValue({operator:"PARSEERROR",values:[k.getText("DDR_WRONG_VALUE"),t]})}else{this.setValue(i)}this.fireChange({value:this.getValue(),prevValue:o,valid:n})};W.prototype._isDateRange=function(e){return Boolean(e&&(e.operator==="DATERANGE"||e.operator==="DATETIMERANGE"))};W.prototype._swapDates=function(e){if(e.length>1&&e[0].getTime()>e[1].getTime()){e.reverse()}};W.prototype._enhanceInputValue=function(e,t){var i=this.getOption(t.operator);if(!i){return null}if(i.enhanceFormattedValue()||t.operator==="LASTDAYS"&&t.values[0]<=1||t.operator==="NEXTDAYS"&&t.values[0]<=1){return e+" ("+this._toDatesString(t)+")"}return e};W.prototype._stripValue=function(e){var t=e.indexOf("(");var i=e.lastIndexOf(")");var o=e;if(t!==-1&&i!==-1&&t<i){o=e.slice(0,t)+e.slice(i+1);o=o.trim()}return o};W.prototype._toDatesString=function(e){var t=this.toDates(e,this.getCalendarWeekNumbering());var i=[];for(var o=0;o<t.length;o++){i[o]=t[o]}return this._getDatesLabelFormatter().format(i)};W.prototype._getPickerParser=function(){if(!this._calendarParser){this._calendarParser=d.getDateTimeWithTimezoneInstance({showTimezone:false})}return this._calendarParser};W.prototype._createPopup=function(){if(!this._oPopup){this._oPopup=new v(this.getId()+"-RP",{contentHeight:"512px",contentWidth:"320px",showCloseButton:false,showArrow:false,showHeader:false,placement:b.PlacementType.VerticalPreferedBottom,ariaLabelledBy:[i.getStaticId("sap.m","INPUT_AVALIABLE_VALUES")]});this._oPopup.addStyleClass("sapMDDRPopover");this._oPopup.attachValidationError(function(e){e.bCancelBubble=true});if(S.system.phone){this._oPopup.addStyleClass("sapUiNoContentPadding")}else{this._oPopup._oControl._getSingleNavContent=function(){return null}}this._oPopup.attachBeforeOpen(function(){var e=this.getValue(),t;if(!e){return}t=this._determineOptionFocus(e);if(t&&e.operator!=="PARSEERROR"){t.setSelected(true)}},this);this._oPopup.attachAfterOpen(function(){var e=this._oNavContainer.getPages()[0];this._applyNavContainerPageFocus(e)},this);this._oPopup.attachAfterClose(function(){this._oPreviousSelectedOption=this._oSelectedOption;this._setFooterVisibility(false)},this);this._oPopup.setBeginButton(new _({type:b.ButtonType.Emphasized,text:k.getText("DYNAMIC_DATE_RANGE_CONFIRM"),press:this._applyValue.bind(this)}));this._oPopup.setEndButton(new _({text:k.getText("DYNAMIC_DATE_RANGE_CANCEL"),press:function(){this._oSelectedOption=this._oPreviousSelectedOption;this._oDatesLabelFormatter=null;this._closePopup()}.bind(this)}));this._setFooterVisibility(false);this._oPopup._getPopup().setAutoClose(true);this.setAggregation("_popup",this._oPopup,true)}};W.prototype._collectValueHelpItems=function(e,t){var i;var o;var n=[];var a=e;a.sort(function(e,t){var i=Number(e.getGroup())?e.getGroup():this._getGroups()[e.getGroup()];var o=Number(t.getGroup())?t.getGroup():this._getGroups()[t.getGroup()];var n=i-o;if(n){return n}return x.indexOf(e.getKey())-x.indexOf(t.getKey())}.bind(this));if(t){a=a.reduce(function(e,t){if(U.LastXKeys.indexOf(t.getKey())!==-1){if(i){return e}i=true}if(U.NextXKeys.indexOf(t.getKey())!==-1){if(o){return e}o=true}e.push(t);return e},[])}if(this.getEnableGroupHeaders()){a=a.reduce(function(e,t){var i=Number(t.getGroup())?t.getGroup():this._getGroups()[t.getGroup()];var o=Object.keys(this._getGroups()).find(e=>this._getGroups()[e]===i);var a=this._customGroupHeaders&&this._customGroupHeaders.find(e=>e.name===o);var s=a?this.getGroupHeader(o):t.getGroupHeader();if(n.indexOf(s)===-1){n.push(s);e.push(s)}e.push(t);return e}.bind(this),[])}return a};W.prototype.getGroupHeader=function(e){var t=this._getGroups()[e];if(t>=this._getGroups()["SingleDates"]&&t<=this._getGroups()["Years"]){return k.getText("DDR_OPTIONS_GROUP_"+t)}return this._getCustomGroupHeader(e)};W.prototype._createListItem=function(e){var t=this._isFixedOption(e);return new te(this.getId()+"-option-"+e.getKey().replaceAll(" ",""),{type:t?w.Active:w.Navigation,title:e.getText(this),wrapping:true,optionKey:e.getKey(),press:this._handleOptionPress.bind(this)})};W.prototype._createHeaderListItem=function(e){var t=new c;t.setTitle(e);t._bGroupHeader=true;return t};W.prototype._handleOptionPress=function(e){var t=e.getSource().getOptionKey(),i=this.getOption(t);if(this._oPreviousSelectedOption&&this._oPreviousSelectedOption.getKey()!==t){this._oDatesLabelFormatter=null}this._oPreviousSelectedOption=this._oSelectedOption;this._oSelectedOption=i;if(this._isFixedOption(i)){this._applyValue()}else{var o=this._createInfoDatesFooter();this._destroyInputControls();this.aInputControls=i.createValueHelpUI(this,this._updateInternalControls.bind(this));var n=this._oNavContainer.getPages()[1];n.removeAllContent();this.aInputControls.forEach(function(e){n.addContent(e)});n.setFooter(o);n.setTitle(i.getText(this));this._setFooterVisibility(true);this._updateInternalControls(i);this._oNavContainer.to(n)}};W.prototype._isFixedOption=function(e){return!e.getValueHelpUITypes(this).length};W.prototype._createInfoDatesFooter=function(){this._infoDatesFooter=new O({design:P.Info,style:F.Clear,content:[new D({text:k.getText("DDR_INFO_DATES_EMPTY_HINT")})]});return this._infoDatesFooter};W.prototype._getDatesLabel=function(){return this._infoDatesFooter.getContent()[0]};W.prototype._updateDatesLabel=function(){var e=this._oSelectedOption.getValueHelpOutput(this),t=[],i,o;var n=this.toDates(e,this.getCalendarWeekNumbering());if(!e||!e.operator||!this.getOption(e.operator)){return}for(var a=0;a<n.length;a++){t[a]=M._createUTCDate(n[a],true)}if(this._isDateRange(e)){this._swapDates(t)}if(t){o=this._oSelectedOption.getKey();if(o==="FROMDATETIME"||o==="TODATETIME"||o==="FROM"||o==="TO"){t.push(null)}i=this._getDatesLabelFormatter().format(t,true);this._getDatesLabel().setText(k.getText("DDR_INFO_DATES",[i]))}};W.prototype._setApplyButtonEnabled=function(e){if(!this._oPopup){return}var t=this._oPopup.getBeginButton();if(t.getVisible()){t.setEnabled(e)}};W.prototype._updateInternalControls=function(e){var t=e.validateValueHelpUI(this);if(t){if(e.alignValueHelpUI){e.alignValueHelpUI(this)}this._updateDatesLabel()}this._setApplyButtonEnabled(t)};W.prototype._setFooterVisibility=function(e){var t;if(!this._oPopup){return}t=this._oPopup.getAggregation("_popup");if(S.system.phone){this._oPopup.getBeginButton().setVisible(e)}else{t.getFooter().setVisible(e)}e&&t.invalidate();return this};W.prototype._createPopupContent=function(){var e=new L({showHeader:false,showNavButton:false}),t=new L({showHeader:true,showNavButton:true}).addStyleClass("sapMDynamicDateRangePopover");t.attachNavButtonPress(function(){this._setFooterVisibility(false);this._oNavContainer.back()},this);if(S.system.phone){e.setShowHeader(true);e.setTitle(this._getOptionsPageTitleText())}if(!this._oOptionsList){this._oOptionsList=new R({showSeparators:X.None,mode:V.SingleSelectMaster})}if(!this._oNavContainer){this._oNavContainer=new m({autoFocus:false});this._oNavContainer.addPage(e);this._oNavContainer.setInitialPage(e);this._oNavContainer.addPage(t);this._oNavContainer.attachAfterNavigate(this._navContainerAfterNavigate,this);this._oPopup.addContent(this._oNavContainer)}this._oNavContainer.getPages()[0].removeAllContent();this._oNavContainer.getPages()[0].addContent(this._oOptionsList);return this._oOptionsList};W.prototype._determineOptionFocus=function(e){var t=this._oOptionsList.getItems(),i=t.filter(function(t){return t.getOptionKey&&t.getOptionKey()===e.operator})[0];if(!i){if(q.indexOf(e.operator)>-1){i=t.filter(function(e){return e.getOptionKey&&e.getOptionKey()===q[0]})[0]}else if(this.nextOptionsIndex(e.operator)>-1){i=t.filter(function(e){return e.getOptionKey&&e.getOptionKey()===z[0]})[0]}}return i};W.prototype._applyNavContainerPageFocus=function(e){var t=this.getValue(),i=this._oNavContainer.getPages()[0],o;if(e===i&&t){o=this._determineOptionFocus(t)||o}if(!e.getDomRef()){return}if(!o){o=jQuery(e.getDomRef().querySelector("section")).firstFocusableDomRef()}if(o){o.focus()}this._reApplyFocusToElement(e,t)};W.prototype._reApplyFocusToElement=function(e,t){};W.prototype._getOptionsPageTitleText=function(){return h.getReferencingLabels(this).concat(this.getAriaLabelledBy()).reduce(function(e,t){var i=o.getElementById(t);return e+" "+(i.getText?i.getText():"")},"").trim()};W.prototype._navContainerAfterNavigate=function(e){var t=this._oNavContainer.getPages()[1],i=e.getParameters()["to"];if(i===t){this.aInputControls.forEach(function(e){if(e.$().firstFocusableDomRef()){e.addAriaLabelledBy&&e.addAriaLabelledBy(i.getId()+"-title");if(!this._isCalendarBasedControl(e)&&e.addAriaDescribedBy){e.addAriaDescribedBy(i.getFooter().getContent()[0])}}},this)}if(this._oPopup&&this._oPopup.isOpen()){this._applyNavContainerPageFocus(i)}else{this.focus()}};W.prototype._isCalendarBasedControl=function(e){return e.isA("sap.ui.unified.Calendar")||e.isA("sap.ui.unified.calendar.CustomMonthPicker")||e.isA("sap.ui.unified.calendar.MonthPicker")||e.isA("sap.ui.unified.calendar.YearPicker")||e.isA("sap.ui.unified.calendar.YearRangePicker")||e.isA("sap.ui.unified.calendar.Month")};W.prototype.openBy=function(e){this.open(e)};W.prototype._openPopup=function(e){if(!this._oPopup){return}this._oPopup._getPopup().setExtraContent([this._oInput.getDomRef()]);this._oPopup.openBy(e||this._oInput)};W.prototype._applyValue=function(){this._oOutput=this._oSelectedOption.getValueHelpOutput(this);var e=this.toDates(this._oOutput,this.getCalendarWeekNumbering());for(var t=0;t<e.length;t++){if(this._oOutput.values[t]instanceof Date&&e[t]instanceof g){this._oOutput.values[t]=e[t].getJSDate()}}if(this._isDateRange(this._oOutput)){this._swapDates(this._oOutput.values)}var i=this.getValue();this.setValue(this._oOutput);this.fireChange({prevValue:i,value:this.getValue(),valid:true});this._closePopup()};W.prototype._closePopup=function(){this._setFooterVisibility(false);this._oNavContainer.to(this._oNavContainer.getPages()[0]);this._oPopup.close()};W.prototype._getFormatter=function(){var e=this.getFormatter(),t;if(e){return e}if(this.oBoundValueFormatter){return this.oBoundValueFormatter}t=this.getBinding("value");if(t&&t.getType()){this.oBoundValueFormatter=l.getInstance(t.getType().oFormatOptions);return this.oBoundValueFormatter}if(!this.oDefaultFormatter){this.oDefaultFormatter=l.getInstance()}return this.oDefaultFormatter};W.prototype._formatValue=function(e){var t=this.getOption(e.operator);return t?t.format(e,this._getFormatter()):""};W.prototype._parseValue=function(e){var t=this.parse(e,this._getFormatter(),this._getOptions()).filter(function(e){return this._getOptions().find(function(t){return t.getKey()===e.operator})},this);return t.length?t[0]:null};W.prototype.parse=function(t,i){if(typeof t!=="string"){e.error("DynamicDateFormat can only parse a String.");return[]}var o=[],n;var a=this._getOptions();for(var s=0;s<a.length;s++){n=a[s]&&a[s].parse(t.trim(),i);if(n){n.operator=a[s].getKey();o.push(n)}}return o};W.prototype._substituteValue=function(e){var t,i,o;if(!e||!e.operator||!e.values){return e}t=e.operator;i=e.values;if(t==="LASTDAYS"&&i[0]===1&&this.getStandardOptions().includes("YESTERDAY")){o={operator:"YESTERDAY",values:[]}}else if(t==="NEXTDAYS"&&i[0]===1&&this.getStandardOptions().includes("TOMORROW")){o={operator:"TOMORROW",values:[]}}else if((t==="LASTDAYS"||t==="NEXTDAYS")&&i[0]===0){o={operator:"TODAY",values:[]}}return o?o:e};W.prototype.getIdForLabel=function(){return this.getAggregation("_input").getIdForLabel()};W.prototype._substituteMissingValue=function(e){var t=e;if(e&&e.operator==="YESTERDAY"&&!this.getStandardOptions().includes("YESTERDAY")&&this.getStandardOptions().includes("LASTDAYS")){t={operator:"LASTDAYS",values:[1]}}else if(e&&e.operator==="TOMORROW"&&!this.getStandardOptions().includes("TOMORROW")&&this.getStandardOptions().includes("NEXTDAYS")){t={operator:"NEXTDAYS",values:[1]}}return t};W.prototype.lastOptionsIndex=function(e){return q.concat(J).indexOf(e)%q.length};W.prototype.nextOptionsIndex=function(e){return z.concat($).indexOf(e)%z.length};W.toDates=function(e,t){return K[e.operator].toDates(e,t).map(function(e){if(e instanceof Date){return e}return e.getJSDate()})};var Z=u.extend(N);Z.apiVersion=2;Z.writeInnerAttributes=function(e,t){if(t.getShowSuggestion()||t.getShowValueStateMessage()){e.attr("autocomplete","off")}var i=t._getControlOrigin?t._getControlOrigin():null,o=this.getAccessibilityState(t);if(i&&i.isA("sap.m.DynamicDateRange")){e.accessibilityState(i,o)}e.attr("type","text")};Z.getAccessibilityState=function(e){var t=N.getAccessibilityState(e),i=e._getControlOrigin(),o=i.getAriaLabelledBy(),n=h.getReferencingLabels(i),a=i.getAriaDescribedBy().join(" "),s;s=n.concat(o).join(" ");if(a){t.describedby=a}if(s){t.labelledby=s}t.roledescription=k.getText("ACC_CTR_TYPE_DYNAMIC_DATE_RANGE");t.role=this.getAriaRole();if(e.getEditable()&&e.getEnabled()){t.haspopup=r.aria.HasPopup.ListBox.toLowerCase()}t.controls=i._oPopup&&i._oPopup.getDomRef()?i._oPopup.getDomRef().id:undefined;return t};var ee=I.extend("sap.m.internal.DynamicDateRangeInput",{metadata:{library:"sap.m"},renderer:Z});ee.prototype._setControlOrigin=function(e){this._oOriginControl=e;return this._oOriginControl};ee.prototype._getControlOrigin=function(){return this._oOriginControl};ee.prototype.preventChangeOnFocusLeave=function(e){return this.bFocusoutDueRendering};ee.prototype.onsapshow=function(e){if(!this.getEnabled()||!this.getEditable()){return}this.bValueHelpRequested=true;this._fireValueHelpRequest(false);e.preventDefault();e.stopPropagation()};ee.prototype.onsaphide=ee.prototype.onsapshow;ee.prototype.shouldSuggetionsPopoverOpenOnMobile=function(e){var t=e.srcControl instanceof E;return this.isMobileDevice()&&this.getEditable()&&this.getEnabled()&&this.getShowSuggestion()&&!t&&!this._bClearButtonPressed};ee.prototype.onfocusin=function(e){var t=this._getControlOrigin()._oPopup;I.prototype.onfocusin.apply(this,arguments);if(t&&t.isOpen()&&!S.system.tablet&&!S.system.mobile){this._getControlOrigin()._closePopup()}};var te=y.extend("sap.m.DynamicDateRangeListItem",{metadata:{library:"sap.m",properties:{optionKey:{type:"string",group:"Misc",defaultValue:null}}},renderer:f});te.prototype.hasActiveType=function(){return true};te.prototype.isIncludedIntoSelection=function(){return false};te.prototype.onsapspace=function(e){e.preventDefault()};te.prototype.getNavigationControl=function(){var e=y.prototype.getNavigationControl.apply(this,arguments),t=this.getOptionKey(),i=["SPECIFICMONTH","DATE","DATERANGE","FROM","TO"].includes(t),o=["DATETIME","DATETIMERANGE","FROMDATETIME","TODATETIME"].includes(t),n;if(i||o){e.addStyleClass("sapMDDRDateOption");n=i?T.getIconURI("appointment-2"):T.getIconURI("date-time")}else{n=T.getIconURI("slim-arrow-right")}e.setSrc(n);return e};return W});
//# sourceMappingURL=DynamicDateRange.js.map