/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./List","./library","sap/ui/core/Element","sap/ui/model/ChangeReason","sap/ui/model/Filter","./FacetFilterListRenderer","./FacetFilterItem","sap/base/Log","sap/ui/model/FilterOperator","sap/ui/model/FilterType"],function(e,t,i,s,r,o,l,a,n,c){"use strict";var h=t.ListMode;var u=t.FacetFilterListDataType;var p=e.extend("sap.m.FacetFilterList",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Appearance",defaultValue:null},wordWrap:{type:"boolean",group:"Appearance",defaultValue:false},multiSelect:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},active:{type:"boolean",group:"Behavior",defaultValue:true},enableCaseInsensitiveSearch:{type:"boolean",group:"Behavior",defaultValue:false,deprecated:false},allCount:{type:"int",group:"Appearance",defaultValue:null},sequence:{type:"int",group:"Behavior",defaultValue:-1},key:{type:"string",group:"Identification",defaultValue:null},showRemoveFacetIcon:{type:"boolean",group:"Misc",defaultValue:true},retainListSequence:{type:"boolean",group:"Misc",defaultValue:false},dataType:{type:"sap.m.FacetFilterListDataType",group:"Misc",defaultValue:u.String}},events:{listOpen:{allowPreventDefault:true},listClose:{parameters:{selectedItems:{type:"sap.m.FacetFilterItem[]"},allSelected:{type:"boolean"},selectedKeys:{type:"object"}}},search:{allowPreventDefault:true,parameters:{term:{type:"string"}}}}},renderer:o});p.prototype.setTitle=function(e){this.setProperty("title",e,true);this._updateFacetFilterButtonText();return this};p.prototype.setMultiSelect=function(e){this.setProperty("multiSelect",e,true);var t=e?h.MultiSelect:h.SingleSelectMaster;this.setMode(t);return this};p.prototype.setMode=function(t){if(t===h.MultiSelect||t===h.SingleSelectMaster){e.prototype.setMode.call(this,t);this.setProperty("multiSelect",t===h.MultiSelect?true:false,true)}return this};p.prototype._applySearch=function(){var e=this._getSearchValue();if(e===null){return}this._bSearchEventDefaultBehavior&&this._search(e,true);this._updateSelectAllCheckBox()};p.prototype.getSelectedItems=function(){var t=[];var i={};var s=e.prototype.getSelectedItems.apply(this,arguments);s.forEach(function(e){t.push(new l({text:e.getText(),key:e.getKey(),selected:true}));i[e.getKey()]=true});var r=this.getSelectedKeys();var o=Object.getOwnPropertyNames(r);if(s.length<o.length){o.forEach(function(e){if(!i[e]){t.push(new l({text:r[e],key:e,selected:true}))}})}return t};p.prototype.getSelectedItem=function(){var t=e.prototype.getSelectedItem.apply(this,arguments);var i=Object.getOwnPropertyNames(this.getSelectedKeys());if(!t&&i.length>0){t=new l({text:this.getSelectedKeys()[i[0]],key:i[0],selected:true})}return t};p.prototype.removeSelections=function(t){if(this._allowRemoveSelections){t?this.setSelectedKeys():e.prototype.removeSelections.call(this,t)}return this};p.prototype.getSelectedKeys=function(){var e={};var t=this._oSelectedKeys;Object.getOwnPropertyNames(t).forEach(function(i){e[i]=t[i]});return e};p.prototype.setSelectedKeys=function(t){this._oSelectedKeys={};var i=false;t&&Object.getOwnPropertyNames(t).forEach(function(e){this._addSelectedKey(e,t[e]);i=true},this);if(i){if(this.getMode()===h.MultiSelect){this.setActive(true)}this._selectItemsByKeys()}else{e.prototype.removeSelections.call(this)}};p.prototype._getNonGroupItems=function(){var e=[];this.getItems().forEach(function(t){if(t.getMode()!==h.None){e.push(t)}});return e};p.prototype.removeSelectedKey=function(e,t){if(this._removeSelectedKey(e,t)){this._getNonGroupItems().forEach(function(t){var i=t.getKey()||t.getText();e===i&&t.setSelected(false)})}};p.prototype.removeSelectedKeys=function(){this._oSelectedKeys={};e.prototype.removeSelections.call(this,true)};p.prototype.removeItem=function(t){var i=e.prototype.removeItem.apply(this,arguments);if(!this._filtering){i&&i.getSelected()&&this.removeSelectedKey(i.getKey(),i.getText());return i}};p.prototype.init=function(){this._firstTime=true;this._bSearchEventDefaultBehavior=true;this._saveBindInfo;this._oSelectedKeys={};e.prototype.init.call(this);this.setMode(h.MultiSelect);this.setIncludeItemInSelection(true);this.setGrowing(true);this.setRememberSelections(false);this._searchValue="";this.attachUpdateFinished(function(e){var t=e.getParameter("reason");t=t?t.toLowerCase():t;if(t==="change"){var i=this.getBinding("items"),r=i?i.getModel():null;if(r&&r.getProperty(i.getPath())){this._iAllItemsCount=r.getProperty(i.getPath()).length||0}this._oSelectedKeys={};this._getNonGroupItems().forEach(function(e){if(e.getSelected()){this._addSelectedKey(e.getKey(),e.getText())}},this)}if(t!==s.Filter.toLowerCase()){this._selectItemsByKeys()}this._updateFacetFilterButtonText();this._updateSelectAllCheckBox()});this._allowRemoveSelections=true;this._bOriginalActiveState;this._iAllItemsCount};p.prototype._resetItemsBinding=function(){if(this.isBound("items")){this._setSearchValue("");this._allowRemoveSelections=false;e.prototype._resetItemsBinding.apply(this,arguments);this._allowRemoveSelections=true}};p.prototype._fireListCloseEvent=function(){var e=this.getSelectedItems();var t=this.getSelectedKeys();var i=this.isAllSelectableSelected();this._firstTime=true;this.fireListClose({selectedItems:e,selectedKeys:t,allSelected:i})};p.prototype._updateActiveState=function(){var e=i.getElementById(this.getAssociation("allcheckbox"));if(Object.getOwnPropertyNames(this._oSelectedKeys).length>0||e&&e.getSelected()){this.setActive(true)}};p.prototype._handleSearchEvent=function(e){var t=e.getParameters()["query"];if(t===undefined){t=e.getParameters()["newValue"]}this._bSearchEventDefaultBehavior=this.fireSearch({term:t,clearButtonPressed:e.getParameters()["clearButtonPressed"]});this._bSearchEventDefaultBehavior?this._search(t):this._setSearchValue(t);this._updateSelectAllCheckBox()};p.prototype._search=function(e,t){var i,s,o,l,h,u,p,d,f=0,y=this.getBinding("items"),g=this.getBindingInfo("items");function S(e){return e&&(e.isA("sap.ui.model.odata.ODataModel")||e.isA("sap.ui.model.odata.v2.ODataModel")||e.isA("sap.ui.model.odata.v4.ODataModel"))}if(t||e!==this._searchValue){this._searchValue=e;if(g&&g.binding){i=g.binding.aFilters;if(i.length>0){f=i[0].aFilters.length;if(this._firstTime){this._saveBindInfo=i[0].aFilters[0][0];this._firstTime=false}}}if(y){if(e||f>0){d=g.template?g.template:g.factory();s=d.getBindingInfo("text").parts;h=s[0].path;if(h||h===""){o=[];s.forEach(function(t){o.push(new r(t.path,n.Contains,e))});if(this.getEnableCaseInsensitiveSearch()&&S(y.getModel())){o.forEach(function(e){e.bCaseSensitive=false})}p=new r(o,false);if(f>1){u=new r([p,this._saveBindInfo],true)}else{if(this._saveBindInfo>""&&l.sPath!=this._saveBindInfo.sPath){u=new r([p,this._saveBindInfo],true)}else{if(e==""){u=[]}else{u=new r([p],true)}}}y.filter(u,c.Control)}}else{y.filter([],c.Control)}}else{a.warning("No filtering performed","The list must be defined with a binding for search to work",this)}}};p.prototype._getSearchValue=function(){return this._searchValue};p.prototype._updateSelectAllCheckBox=function(){var e=this._getNonGroupItems(),t=e.length,s,r,o;function l(e){return e.getSelected()}if(this.getMode()===h.MultiSelect){s=i.getElementById(this.getAssociation("allcheckbox"));r=t>0&&t===e.filter(l).length;o=this.getActive()&&r;s&&s.setSelected(o)}};p.prototype._addSelectedKey=function(e,t){if(!e&&!t){a.error("Both sKey and sText are not defined. At least one must be defined.");return}if(this.getMode()===h.SingleSelectMaster){this.removeSelectedKeys()}if(!e){e=t}this._oSelectedKeys[e]=t||e};p.prototype._removeSelectedKey=function(e,t){if(!e&&!t){a.error("Both sKey and sText are not defined. At least one must be defined.");return false}if(!e){e=t}delete this._oSelectedKeys[e];return true};p.prototype._setSearchValue=function(e){this._searchValue=e};p.prototype._isItemSelected=function(e){return!!this._oSelectedKeys[e&&(e.getKey()||e.getText())]};p.prototype._updateFacetFilterButtonText=function(){if(this.getParent()&&this.getParent()._setButtonText){this.getParent()._setButtonText(this)}};p.prototype._selectItemsByKeys=function(){this._getNonGroupItems().forEach(function(e){e.setSelected(this._isItemSelected(e))},this);this._updateFacetFilterButtonText()};p.prototype._handleSelectAllClick=function(e){var t,i,s=this._getNonGroupItems(),r=s.length;s.forEach(function(t){if(e){this._addSelectedKey(t.getKey(),t.getText())}else{this._removeSelectedKey(t.getKey(),t.getText())}t.setSelected(e,true)},this);function o(e){return e.getSelected()}if(this.getMode()===h.MultiSelect){i=r>0&&r===s.filter(o).length;t=this._getOriginalActiveState()||e&&i;this.setActive(t)}setTimeout(this._updateSelectAllCheckBox.bind(this),0)};p.prototype.onItemTextChange=function(e,t){var i=e.getKey();if(this._oSelectedKeys[i]&&t&&!this._filtering){this._oSelectedKeys[i]=t}};p.prototype.onItemSelectedChange=function(t,i){var s;if(i){this._addSelectedKey(t.getKey(),t.getText())}else{this._removeSelectedKey(t.getKey(),t.getText())}e.prototype.onItemSelectedChange.apply(this,arguments);if(this.getMode()===h.MultiSelect){s=this._getOriginalActiveState()||i||this.getSelectedItems().length>1;this.setActive(s)}!this.getDomRef()&&this.getParent()&&this.getParent().getDomRef()&&this.getParent().invalidate();setTimeout(this._updateSelectAllCheckBox.bind(this),0)};p.prototype.updateItems=function(t){var i=document.activeElement;this._filtering=t===s.Filter;e.prototype.updateItems.apply(this,arguments);this._filtering=false;if(i&&i.getAttribute("id")!==document.activeElement.getAttribute("id")){this.focus()}if(!this.getGrowing()||t===s.Filter){this._selectItemsByKeys()}};p.prototype._getOriginalActiveState=function(){return this._bOriginalActiveState};p.prototype._preserveOriginalActiveState=function(){this._bOriginalActiveState=this.getActive()};p.prototype._showBusyIndicator=function(){e.prototype._showBusyIndicator.apply(this,arguments);this.fireEvent("listItemsChange")};p.prototype._hideBusyIndicator=function(){e.prototype._hideBusyIndicator.apply(this,arguments);this.fireEvent("listItemsChange")};return p});
//# sourceMappingURL=FacetFilterList.js.map