/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Element","sap/ui/core/library","sap/ui/core/Control","./FormattedTextAnchorGenerator","./FormattedTextRenderer","sap/base/Log","sap/base/security/URLListValidator","sap/base/security/sanitizeHTML","sap/ui/util/openWindow"],function(e,t,i,r,s,n,a,o,l,u){"use strict";var p=e.LinkConversion,c=i.TextDirection,f=i.TextAlign;var g=r.extend("sap.m.FormattedText",{metadata:{library:"sap.m",properties:{htmlText:{type:"string",group:"Misc",defaultValue:""},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},convertLinksToAnchorTags:{type:"sap.m.LinkConversion",group:"Behavior",defaultValue:p.None},convertedLinksDefaultTarget:{type:"string",group:"Behavior",defaultValue:"_blank"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:c.Inherit},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:f.Begin},disableStyleAttribute:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{controls:{type:"sap.m.Link",multiple:true,singularName:"control"}}},renderer:n});var h={ATTRIBS:{style:1,class:1,"a::href":1,"a::target":1,"a::title":1,dir:1},ELEMENTS:{a:{cssClass:"sapMLnk"},abbr:1,bdi:1,blockquote:1,br:1,cite:1,code:1,em:1,h1:{cssClass:"sapMTitle sapMTitleStyleH1"},h2:{cssClass:"sapMTitle sapMTitleStyleH2"},h3:{cssClass:"sapMTitle sapMTitleStyleH3"},h4:{cssClass:"sapMTitle sapMTitleStyleH4"},h5:{cssClass:"sapMTitle sapMTitleStyleH5"},h6:{cssClass:"sapMTitle sapMTitleStyleH6"},p:1,pre:1,strong:1,span:1,u:1,dl:1,dt:1,dd:1,ol:1,ul:1,li:1}},d={ATTRIBS:{"a::href":1,"a::target":1},ELEMENTS:{a:{cssClass:"sapMLnk"},br:1,em:1,strong:1,u:1}};g.prototype._renderingRules=h;g.prototype.init=function(){};function T(e,t){var i;var r,s,n=e==="a";var l=this._renderingRules.ELEMENTS[e].cssClass||"";for(var u=0;u<t.length;u+=2){r=t[u];s=t[u+1];if(!this._renderingRules.ATTRIBS[r]&&!this._renderingRules.ATTRIBS[e+"::"+r]){i="FormattedText: <"+e+"> with attribute ["+r+'="'+s+'"] is not allowed';a.warning(i,this);t[u+1]=null;continue}if(r=="href"){if(!o.validate(s)){a.warning("FormattedText: incorrect href attribute:"+s,this);t[u+1]="#";n=false}}if(r=="target"){n=false}if(l&&r.toLowerCase()=="class"){t[u+1]=l+" "+s;l=""}}if(n){t.push("target");t.push("_blank")}if(l){t.push("class");t.push(l)}return t}function y(e,t){if(this._renderingRules.ELEMENTS[e]){return T.call(this,e,t)}else{var i="<"+e+"> is not allowed";a.warning(i,this)}}function m(e){return l(e,{tagPolicy:y.bind(this),uriRewriter:function(e){if(o.validate(e)){return e}}})}function b(i){if(i.originalEvent.defaultPrevented){return}i.preventDefault();var r=t.getElementById(i.currentTarget.id);if(r&&r.isA("sap.m.Link")&&(r.getAccessibleRole()===e.LinkAccessibleRole.Button||!r.getHref())){return}u(i.currentTarget.href,i.currentTarget.target)}g.prototype.onAfterRendering=function(){this.$().find("a").on("click",b);var e=this.getControls(),t;e.forEach(function(e,i){t=this.getDomRef("$"+i);if(t){t.replaceWith(e.getDomRef())}else{e.getDomRef().style.display="none"}}.bind(this));this._sanitizeCSSPosition(this.getDomRef())};g.prototype.onBeforeRendering=function(){this.$().find("a").off("click",b)};g.prototype._sanitizeCSSPosition=function(e){if(!e){return}var t=document.createTreeWalker(e,NodeFilter.SHOW_ELEMENT),i=t.nextNode(),r=this.getDisableStyleAttribute();while(i){if(r){i.removeAttribute("style")}i.style.setProperty("position","static","important");i=t.nextNode()}};g.prototype._getDisplayHtml=function(){var e=this.getHtmlText(),t=this.getConvertLinksToAnchorTags();if(t===p.None){return e}e=s.generateAnchors(e,t,this.getConvertedLinksDefaultTarget());return m.call(this,e)};g.prototype.setHtmlText=function(e){return this.setProperty("htmlText",m.call(this,e))};g.prototype._setUseLimitedRenderingRules=function(e){this._renderingRules=e?d:h};g.prototype.getFocusDomRef=function(){return this.getDomRef()&&this.getDomRef().querySelector("a")};g.prototype.getAccessibilityInfo=function(){var e=this.getControls().map(function(e){return`${e.getAccessibilityInfo().type} ${e.getAccessibilityInfo().description}`.trim()});var t=this.getHtmlText().replace(/<[^>]*>/g,"");e.forEach(function(e,i){t=t.replace(`%%${i}`,e)});return{description:t}};return g});
//# sourceMappingURL=FormattedText.js.map