/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/base/i18n/Localization","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/EnabledPropagator","sap/ui/core/Lib","sap/ui/core/delegate/ItemNavigation","sap/ui/core/InvisibleText","sap/ui/core/ResizeHandler","sap/ui/core/Theming","sap/ui/Device","sap/m/Button","sap/m/IconTabFilter","sap/m/IconTabSeparator","sap/m/IconTabBarDragAndDropUtil","sap/ui/core/library","sap/m/IconTabHeaderRenderer","sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/events/KeyCodes"],function(e,t,i,s,o,r,a,n,l,d,h,f,p,g,c,u,v,jQuery,m,I){"use strict";var _=u.dnd.DropPosition;var y=e.BackgroundDesign;var b=e.IconTabHeaderMode;var T=e.IconTabDensityMode;var S=e.TabsOverflowMode;var w=e.IconTabFilterInteractionMode;var O=i.extend("sap.m.IconTabHeader",{metadata:{library:"sap.m",properties:{showSelection:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},selectedKey:{type:"string",group:"Data",defaultValue:null},visible:{type:"boolean",group:"Behavior",defaultValue:true},mode:{type:"sap.m.IconTabHeaderMode",group:"Appearance",defaultValue:b.Standard},showOverflowSelectList:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:y.Solid},enableTabReordering:{type:"boolean",group:"Behavior",defaultValue:false},maxNestingLevel:{type:"int",group:"Behavior",defaultValue:0},tabDensityMode:{type:"sap.m.IconTabDensityMode",group:"Appearance",defaultValue:T.Cozy},ariaTexts:{type:"object",group:"Accessibility",defaultValue:null},tabsOverflowMode:{type:"sap.m.TabsOverflowMode",group:"Behavior",defaultValue:S.End}},aggregations:{items:{type:"sap.m.IconTab",multiple:true,singularName:"item",dnd:{draggable:true,droppable:true,layout:"Horizontal"}},_overflow:{type:"sap.m.IconTabFilter",multiple:false,visibility:"hidden"},_startOverflow:{type:"sap.m.IconTabFilter",multiple:false,visibility:"hidden"}},events:{select:{parameters:{item:{type:"sap.m.IconTabFilter"},key:{type:"string"},previousKey:{type:"string"}}}}},renderer:v});var x=r.getResourceBundleFor("sap.m");o.apply(O.prototype,[true]);O.prototype.init=function(){this._bFireSelectEvent=false;this._aTabKeys=[];this._oAriaHeadText=null;this._bIsRendered=false;this._bThemeApplied=false;this._handleThemeAppliedBound=this._handleThemeApplied.bind(this)};O.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation}if(this._sResizeListenerId){l.deregister(this._sResizeListenerId);this._sResizeListenerId=null}if(this._aTabKeys){this._aTabKeys=null}if(this._oOverflow){this._oOverflow.removeEventDelegate(this._oOverflowEventDelegate);this._oOverflowEventDelegate=null;this._oOverflow=null}if(this._oStartOverflow){this._oStartOverflow.removeEventDelegate(this._oStartOverflowEventDelegate);this._oStartOverflowEventDelegate=null;this._oStartOverflow=null}if(this._oAriaHeadText){this._oAriaHeadText.destroy();this._oAriaHeadText=null}this._bRtl=null};O.prototype.onBeforeRendering=function(){this._bIsRendered=false;this._bRtl=t.getRTL();if(this._sResizeListenerId){l.deregister(this._sResizeListenerId);this._sResizeListenerId=null}this._updateSelection();this.destroyDragDropConfig();this._setsDragAndDropConfigurations()};O.prototype.onAfterRendering=function(){this._applyTabDensityMode();if(this.oSelectedItem){this._applySelectionToFilters();this.oSelectedItem._hideBadge()}if(this._bThemeApplied){this._setItemsForStrip()}else{d.attachApplied(this._handleThemeAppliedBound)}this._initItemNavigation();this._sResizeListenerId=l.register(this.getDomRef(),jQuery.proxy(this._fnResize,this));this.getItems().forEach(function(e){if(e._onAfterParentRendering){e._onAfterParentRendering()}});this._bIsRendered=true};O.prototype._isRendered=function(){return this._bIsRendered};O.prototype._getSelectList=function(){return this._getOverflow()._getSelectList()};O.prototype._getOverflow=function(){var e=this.getAggregation("_overflow");if(!e){e=new p({id:this.getId()+"-overflow",text:x.getText("ICONTABHEADER_OVERFLOW_MORE")});e._bIsOverflow=true;this._oOverflowEventDelegate={onsapnext:e.onsapdown};e.addEventDelegate(this._oOverflowEventDelegate,e);this.setAggregation("_overflow",e);this._oOverflow=e}return e};O.prototype._getStartOverflow=function(){var e=this.getAggregation("_startOverflow");if(!e){e=new p({id:this.getId()+"-startOverflow",text:x.getText("ICONTABHEADER_OVERFLOW_MORE")});e._bIsStartOverflow=true;this._oStartOverflowEventDelegate={onsapprevious:e.onsapdown};e.addEventDelegate(this._oStartOverflowEventDelegate,e);this.setAggregation("_startOverflow",e);this._oStartOverflow=e}return e};O.prototype._getInvisibleHeadText=function(){var e=this.getAriaTexts()||{};if(!this._oAriaHeadText){this._oAriaHeadText=new n({id:this.getId()+"-ariaHeadText"})}this._oAriaHeadText.setText(e.headerDescription);return this._oAriaHeadText};O.prototype._onItemNavigationFocusLeave=function(){if(!this.oSelectedItem){return}var e=this._oItemNavigation.getItemDomRefs().indexOf(this.oSelectedItem._getRootTab().getDomRef());this._oItemNavigation.setFocusedIndex(e)};O.prototype._onItemNavigationBeforeFocus=function(e){if(e.getParameter("event").target===this.getDomRef()){s.getElementById(this._oItemNavigation.getItemDomRefs()[e.getParameter("index")].getAttribute("id"))._closePopover()}};O.prototype.getTabFilters=function(){var e=[];this.getItems().forEach(function(t){if(t instanceof p){e.push(t)}});return e};O.prototype._setsDragAndDropConfigurations=function(){if(this.getEnableTabReordering()&&!this.getDragDropConfig().length){c.setDragDropAggregations(this,"Horizontal",this._getDropPosition())}};O.prototype._getDropPosition=function(){return this.getMaxNestingLevel()===0?_.Between:_.OnOrBetween};O.prototype.setSelectedKey=function(e){if(e===this.getSelectedKey()){if(this._isInsideIconTabBar()){this.getParent().setProperty("selectedKey",e,true)}return this}var t=this.getTabFilters(),i=this._isInsideIconTabBar(),s=true,o;if(t.length>0){e=e||t[0]._getNonEmptyKey()}if(this.$().length){o=this._findItemByKey(e);if(o){this.setSelectedItem(o,s)}else if(!i&&e){this.setSelectedItem(null)}}this.setProperty("selectedKey",e,true);return this};O.prototype.setSelectedItem=function(e,t){if(!e){if(this.oSelectedItem){this._removeSelectionFromFilters();this.oSelectedItem=null}return this}if(!this._isSelectable(e)){return this}var i=this.getParent();var s=this._isInsideIconTabBar();var o=this.getSelectedKey();var r=false;if(e.getContent().length===0&&this.oSelectedItem&&this.oSelectedItem.getContent().length===0){r=true}if(this.oSelectedItem&&this.oSelectedItem.getVisible()&&(!t&&s&&i.getExpandable()||this.oSelectedItem!==e)){this._removeSelectionFromFilters()}if(e.getVisible()){if(this.oSelectedItem===e){if(!t&&s&&i.getExpandable()){i._toggleExpandCollapse()}}else{if(s){i.$("content").attr("aria-labelledby",e._getRootTab().getId())}this.oSelectedItem=e;this._applySelectionToFilters();this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);if(s&&(i.getExpandable()||i.getExpanded())){var a=this.oSelectedItem.getContent();if(a.length>0){i._rerenderContent(a)}else{if(!r){i._rerenderContent(i.getContent())}}if(!t&&i.getExpandable()&&!i.getExpanded()){i._toggleExpandCollapse(true)}}}}this.oSelectedItem=e;var n=this.oSelectedItem._getNonEmptyKey();this.setProperty("selectedKey",n,true);if(s){i.setProperty("selectedKey",n,true)}if(s){t=t&&!i._bFireSelectEvent}else{t=t&&!this._bFireSelectEvent}if(!t){if(s){i.fireSelect({selectedItem:this.oSelectedItem,selectedKey:n,item:this.oSelectedItem,key:n,previousKey:o})}else{this.fireSelect({selectedItem:this.oSelectedItem,selectedKey:n,item:this.oSelectedItem,key:n,previousKey:o})}}this.oSelectedItem._startBadgeHiding();var l=this.oSelectedItem._getRootTab().getDomRef();if(!l||l.classList.contains("sapMITBFilterHidden")||this.getTabsOverflowMode()===S.End){this._setItemsForStrip()}return this};O.prototype.getVisibleTabFilters=function(){return this.getTabFilters().filter(function(e){return e.getVisible()})};O.prototype._initItemNavigation=function(){var e=[],t=-1,i=this.oSelectedItem&&this.oSelectedItem._getRootTab();if(this.$().hasClass("sapMITHStartOverflowList")){var s=this._getStartOverflow().getFocusDomRef();s.setAttribute("tabindex","-1");e.push(s)}this.getTabFilters().forEach(function(s){var o=this.getFocusDomRef(s);if(!o){return}o.setAttribute("tabindex","-1");e.push(o);if(s===i||s===this.oSelectedItem){t=e.indexOf(o)}}.bind(this));if(this.$().hasClass("sapMITHEndOverflowList")){var o=this._getOverflow().getFocusDomRef();o.setAttribute("tabindex","-1");e.push(o)}if(!this._oItemNavigation){this._oItemNavigation=(new a).setCycling(false).attachEvent(a.Events.FocusLeave,this._onItemNavigationFocusLeave,this).attachEvent(a.Events.BeforeFocus,this._onItemNavigationBeforeFocus,this).setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});this.addDelegate(this._oItemNavigation)}this._oItemNavigation.setRootDomRef(this.getDomRef()).setItemDomRefs(e).setPageSize(e.length).setSelectedIndex(t)};O.prototype.onThemeChanged=function(){this._applyTabDensityMode()};O.prototype._applyTabDensityMode=function(){var e=this.getTabDensityMode();this.$().removeClass("sapUiSizeCompact");switch(e){case T.Compact:this.$().addClass("sapUiSizeCompact");break;case T.Inherit:if(this.getDomRef()?.closest(".sapUiSizeCompact")){this.$().addClass("sapUiSizeCompact")}break}};O.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this._setItemsForStrip(this);d.detachApplied(this._handleThemeAppliedBound)};O.prototype.destroyItems=function(){this.oSelectedItem=null;this._aTabKeys=[];this.destroyAggregation("items");return this};O.prototype.addItem=function(e){if(!(e instanceof g)){var t=e.getKey();if(this._aTabKeys.indexOf(t)!==-1){m.warning("sap.m.IconTabHeader: duplicate key '"+t+"' inside the IconTabFilter. Please use unique keys.")}this._aTabKeys.push(t)}this.addAggregation("items",e);this._invalidateParentIconTabBar();return this};O.prototype.insertItem=function(e,t){if(!(e instanceof g)){var i=e.getKey();if(this._aTabKeys.indexOf(i)!==-1){m.warning("sap.m.IconTabHeader: duplicate key '"+i+"' inside the IconTabFilter. Please use unique keys.")}this._aTabKeys.push(i)}this.insertAggregation("items",e,t);this._invalidateParentIconTabBar()};O.prototype.removeAllItems=function(){var e=this.removeAllAggregation("items");this._aTabKeys=[];this.oSelectedItem=null;this._invalidateParentIconTabBar();return e};O.prototype.removeItem=function(e){e=this.removeAggregation("items",e);if(e&&!(e instanceof g)){var t=e.getKey();this._aTabKeys.splice(this._aTabKeys.indexOf(t),1)}if(this.oSelectedItem===e){this.oSelectedItem=null}this._invalidateParentIconTabBar();return e};O.prototype.updateAggregation=function(){this.oSelectedItem=null;i.prototype.updateAggregation.apply(this,arguments);this.invalidate()};O.prototype.removeAggregation=function(e,t,s){var o=this.getTabFilters();var r=i.prototype.removeAggregation.apply(this,arguments);if(s){return r}if(!this._getPreserveSelection()&&r&&r==this.oSelectedItem&&e=="items"){var a=o?Array.prototype.indexOf.call(o,r):-1;o=this.getTabFilters();a=Math.max(0,Math.min(a,o.length-1));var n=o[a];if(n){this.setSelectedItem(n,true)}else{var l=this.getParent();if(this._isInsideIconTabBar()&&l.getExpanded()){l.$("content").children().remove()}}}return r};O.prototype.removeAllAggregation=function(e,t){if(e=="items"){var s=this.getParent();if(this._isInsideIconTabBar()&&s.getExpanded()){s.$("content").children().remove()}}return i.prototype.removeAllAggregation.apply(this,arguments)};O.prototype._getPreserveSelection=function(){return this._bPreserveSelection};O.prototype._setPreserveSelection=function(e){this._bPreserveSelection=e};O.prototype._getDisplayText=function(e){var t=e.getText();if(this.isInlineMode()){var i=e.getCount();if(i){if(this._bRtl){t="("+i+") "+t}else{t+=" ("+i+")"}}}return t};O.prototype.isInlineMode=function(){return this.getMode()===b.Inline};O.prototype._checkTextOnly=function(){this._bTextOnly=this.getItems().every(function(e){return e instanceof g||!e.getIcon()});return this._bTextOnly};O.prototype._checkNoText=function(e){if(e.length>0){for(var t=0;t<e.length;t++){if(!(e[t]instanceof g)){if(e[t].getText().length>0){return false}}}}return true};O.prototype._checkInLine=function(e){var t;if(e.length>0){for(var i=0;i<e.length;i++){t=e[i];if(!(t instanceof g)){if(t.getIcon()||t.getCount()){this._bInLine=false;return false}}}}this._bInLine=true;return true};O.prototype._getItemsInStrip=function(){return this.getItems().filter(function(e){var t=e.getDomRef();return t&&!t.classList.contains("sapMITBFilterHidden")})};O.prototype._setItemsForStrip=function(){var e=this.getVisibleTabFilters();if(!this._bThemeApplied||!e.length){return}var t=this.getDomRef("head");if(!t){return}var i=this._getStartOverflow(),s=this._getOverflow(),o=this.getItems().filter(function(e){return e.getDomRef()}).map(function(e){return e.getDomRef()}),r=this.oSelectedItem&&this.oSelectedItem.getVisible()?this.oSelectedItem:e[0],a=(r._getRootTab()||r).getDomRef();if(!o.length||!a){return}i.$().removeClass("sapMITHOverflowVisible");s.$().removeClass("sapMITHOverflowVisible");this.$().removeClass("sapMITHStartOverflowList");this.$().removeClass("sapMITHEndOverflowList");o.forEach(function(e){e.classList.remove("sapMITBFilterHidden")});var n=o.reduce(function(e,t){return e+jQuery(t).outerWidth(true)},0),l=n>t.offsetWidth;if(!l){return}switch(this.getTabsOverflowMode()){case S.StartAndEnd:this._updateStartAndEndOverflow(o,a);break;case S.End:default:this._updateEndOverflow(o,a);break}};O.prototype._updateEndOverflow=function(e,t){var i=this._getOverflow(),s=this.getDomRef("head"),o,r,a,n;i.$().addClass("sapMITHOverflowVisible");this.$().addClass("sapMITHEndOverflowList");o=s.offsetWidth;a=this._getSelectedItemIndexAndSize(e,t);r=this._findLastVisibleItem(e,o,a.width);for(n=r+1;n<e.length;n++){e[n].classList.add("sapMITBFilterHidden")}i._updateExpandButtonBadge()};O.prototype._updateStartAndEndOverflow=function(e,t){var i=this._getStartOverflow(),s=this._getOverflow(),o=this.getDomRef("head"),r=o.offsetWidth,a=this._getSelectedItemIndexAndSize(e,t),n=this._hasStartOverflow(r,e,a),l=this._hasEndOverflow(r,e,a),d,h,f;if(!n){s.$().addClass("sapMITHOverflowVisible");this.$().addClass("sapMITHEndOverflowList");r=o.offsetWidth;h=this._findLastVisibleItem(e,r,a.width);for(f=h+1;f<e.length;f++){e[f].classList.add("sapMITBFilterHidden")}s._updateTabCountText();s._updateExpandButtonBadge();return}if(!l){i.$().addClass("sapMITHOverflowVisible");this.$().addClass("sapMITHStartOverflowList");r=o.offsetWidth;d=this._findFirstVisibleItem(e,r,a.width);for(f=d-1;f>=0;f--){e[f].classList.add("sapMITBFilterHidden")}i._updateTabCountText();i._updateExpandButtonBadge();return}i.$().addClass("sapMITHOverflowVisible");this.$().addClass("sapMITHStartOverflowList");s.$().addClass("sapMITHOverflowVisible");this.$().addClass("sapMITHEndOverflowList");r=o.offsetWidth;d=this._findFirstVisibleItem(e,r,a.width,a.index-1);h=this._findLastVisibleItem(e,r,a.width,d);for(f=d-1;f>=0;f--){e[f].classList.add("sapMITBFilterHidden")}for(f=h+1;f<e.length;f++){e[f].classList.add("sapMITBFilterHidden")}i._updateExpandButtonBadge();i._updateTabCountText();s._updateTabCountText();s._updateExpandButtonBadge()};O.prototype._hasStartOverflow=function(e,t,i){if(i.index===0){return false}var s,o=0;for(s=i.index-1;s>=0;s--){o+=this._getItemSize(t[s])}var r=e<o+i.width;if(!r){this._getOverflow().$().addClass("sapMITHOverflowVisible");this.$().addClass("sapMITHEndOverflowList");e=this.getDomRef("head").offsetWidth;r=e<o+i.width;this._getOverflow().$().removeClass("sapMITHOverflowVisible");this.$().removeClass("sapMITHEndOverflowList")}return r};O.prototype._hasEndOverflow=function(e,t,i){if(i.index>=t.length){return false}var s,o=0;for(s=i.index;s<t.length;s++){o+=this._getItemSize(t[s])}var r=e<o+i.width;if(!r){this._getStartOverflow().$().addClass("sapMITHOverflowVisible");this.$().addClass("sapMITHStartOverflowList");e=this.getDomRef("head").offsetWidth;r=e<o+i.width;this._getStartOverflow().$().removeClass("sapMITHOverflowVisible");this.$().removeClass("sapMITHStartOverflowList")}return r};O.prototype._getSelectedItemIndexAndSize=function(e,t){var i=e.indexOf(t),s=this._getItemSize(t),o;if(e[i-1]&&e[i-1].classList.contains("sapMITBSep")){o=e[i-1];s+=this._getItemSize(o)}e.splice(i,1);if(o){e.splice(i-1,1);i--}return{index:i,width:s}};O.prototype._findFirstVisibleItem=function(e,t,i,s){var o,r,a;if(s===undefined){s=e.length-1}o=s+1;for(r=s;r>=0;r--){a=this._getItemSize(e[r]);if(t<i+a){break}i+=a;o=r}return o};O.prototype._findLastVisibleItem=function(e,t,i,s){var o,r,a;s=s||0;o=s-1;for(r=s;r<e.length;r++){a=this._getItemSize(e[r]);if(t<i+a){break}i+=a;o=r}var n=e[r-1];if(n&&n.classList.contains("sapMITBSep")){o-=1}return o};O.prototype._getItemSize=function(e){var t=window.getComputedStyle(e),i=e.offsetWidth,s=Number.parseInt(t.marginLeft)+Number.parseInt(t.marginRight);return i+s};O.prototype._hasSubItems=function(){var e=this.getTabFilters(),t;for(t=0;t<e.length;t++){if(e[t].getItems().length>0){return true}}return false};O.prototype._handleActivation=function(e){var t=e.target.id,i=e.srcControl,o,r=jQuery(e.target);if(i instanceof f){return}var a=jQuery(document.getElementById(t));if(a.parents()&&Array.prototype.indexOf.call(a.parents(),this.$("content")[0])>-1){}else{if(t){e.preventDefault();if(r.hasClass("sapMITBFilterIcon")||r.hasClass("sapMITBCount")||r.hasClass("sapMITBText")||r.hasClass("sapMITBTab")||r.hasClass("sapMITBContentArrow")||r.hasClass("sapMITBSep")||r.hasClass("sapMITBSepIcon")){o=e.srcControl.getId().replace(/-icon$/,"");i=s.getElementById(o);if(i.getMetadata().isInstanceOf("sap.m.IconTab")&&!(i instanceof g)){if(!this._isSelectable(i)){if(i.getItems().length||i._isOverflow()){i._expandButtonPress()}return}if(i===this._getOverflow()||i===this._getStartOverflow()){i._expandButtonPress();return}this.setSelectedItem(i)}}else if(i.getMetadata().isInstanceOf("sap.m.IconTab")&&!(i instanceof g)){if(!this._isSelectable(i)){if(i.getItems().length||i._isOverflow()){i._expandButtonPress()}return}if(i===this._getOverflow()||i===this._getStartOverflow()){i._expandButtonPress();return}this.setSelectedItem(i)}}else{if(i.getMetadata().isInstanceOf("sap.m.IconTab")&&!(i instanceof g)){if(!this._isSelectable(i)){if(i.getItems().length||i._isOverflow()){i._expandButtonPress()}return}if(i===this._getOverflow()||i===this._getStartOverflow()){i._expandButtonPress();return}this.setSelectedItem(i)}}}};O.prototype._fnResize=function(){if(this._getOverflow()._oPopover){this._getOverflow()._oPopover.close()}if(this._getStartOverflow()._oPopover){this._getStartOverflow()._oPopover.close()}this._setItemsForStrip();this._initItemNavigation()};O.prototype._isSelectable=function(e){var t=e._getRealTab(),i=t.getInteractionMode();if(!t.getEnabled()){return false}if(!t.getItems().length||t._isOverflow()){return true}if(i===w.Auto){return!this._isInsideIconTabBar()||t._getNestedLevel()!==1||this.getParent().getContent().length||t.getContent().length}return i===w.Select};O.prototype._isInsideIconTabBar=function(){var e=this.getParent();return e instanceof i&&e.isA("sap.m.IconTabBar")};O.prototype._isInsideToolHeader=function(){var e=this.getParent();return e instanceof i&&e.isA("sap.tnt.ToolHeader")};O.prototype._invalidateParentIconTabBar=function(){if(this._isInsideIconTabBar()){this.getParent().invalidate()}};O.prototype.getFocusDomRef=function(e){var t=e||this.oSelectedItem;if(!t){return null}return t.getDomRef()};O.prototype.applyFocusInfo=function(e){if(e.focusDomRef){jQuery(e.focusDomRef).trigger("focus")}};O.prototype._updateSelection=function(){var e=this.getItems(),t=this.getSelectedKey(),i=0,s=this._isInsideIconTabBar(),o=this._isInsideToolHeader();if(!e.length){return}if(!this.oSelectedItem||t&&t!==this.oSelectedItem._getNonEmptyKey()){if(t){this.oSelectedItem=this._findItemByKey(t)}if(!this.oSelectedItem&&(s||!t)){for(i=0;i<e.length;i++){if(!(e[i]instanceof g)&&e[i].getVisible()){this.oSelectedItem=e[i];break}}}}if(!o&&this.oSelectedItem&&!this.oSelectedItem.getVisible()){for(i=0;i<e.length;i++){if(!(e[i]instanceof g)&&e[i].getVisible()){this.oSelectedItem=e[i];break}}}if(!this.oSelectedItem){return}if(!this._isSelectable(this.oSelectedItem)){this.setSelectedItem(this.oSelectedItem._getFirstAvailableSubFilter(),true);return}this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true)};O.prototype._findItemByKey=function(e){var t=this.getTabFilters(),i;for(var s=0;s<t.length;s++){if(t[s]._getNonEmptyKey()===e){return t[s]}i=t[s]._getAllSubFilters();for(var o=0;o<i.length;o++){if(i[o]._getNonEmptyKey()===e){return i[o]}}}};O.prototype._applySelectionToFilters=function(){if(this._isInsideIconTabBar()&&!this.getParent().getExpanded()){return}this.oSelectedItem.$().addClass("sapMITBSelected").attr({"aria-selected":true});if(this.oSelectedItem._getNestedLevel()!==1){var e=this.oSelectedItem._getRootTab();e.$().addClass("sapMITBSelected").attr({"aria-selected":true})}};O.prototype._removeSelectionFromFilters=function(){this.oSelectedItem.$().removeClass("sapMITBSelected").attr({"aria-selected":false});if(this.oSelectedItem._getNestedLevel()!==1){var e=this.oSelectedItem._getRootTab();e.$().removeClass("sapMITBSelected").attr({"aria-selected":false})}};O.prototype._getItemsForOverflow=function(e,t){var i=this._getItemsInStrip(),s=this.getTabsOverflowMode()===S.StartAndEnd,o,r=this.getItems(),a=[];if(s){o=r.indexOf(i[0]);r=e?r.slice(0,o):r.slice(o,r.length)}r.forEach(function(e){if(!h.system.phone&&i.indexOf(e)>-1){return}a.push(e);if(e.isA("sap.m.IconTabFilter")&&!t){e._getAllSubItems().forEach(function(e){a.push(e)})}});return a};O.prototype.ontouchstart=function(e){var t=e.targetTouches[0];if(e.which===3){return}else{this._iActiveTouch=t.identifier}};O.prototype.ontouchend=function(e){if(this._iActiveTouch===undefined){return}var t=0;var i=1;var s;if(e.which===s||e.which===t||e.which===i){this._handleActivation(e)}this._iActiveTouch=undefined};O.prototype.ontouchcancel=O.prototype.ontouchend;O.prototype.onkeydown=function(e){switch(e.which){case I.ENTER:this._handleActivation(e);e.preventDefault();break;case I.SPACE:e.preventDefault();break}};O.prototype.onkeyup=function(e){if(e.which===I.SPACE){this._handleActivation(e)}};O.prototype._handleDragAndDrop=function(e){var t=e.getParameter("dropPosition"),i=e.getParameter("draggedControl"),s=e.getParameter("droppedControl"),o=this,r=this.getMaxNestingLevel();if(t===_.On){o=s._getRealTab()}c.handleDrop(o,t,i._getRealTab(),s,false,r);if(i._getNestedLevel()>1){i._getRootTab()._closePopover()}this._setItemsForStrip();this._initItemNavigation();this._getOverflow()._setSelectListItems();this._getStartOverflow()._setSelectListItems();this._getSelectList()._initItemNavigation();i._getRealTab().$().trigger("focus");if(t===_.On){s._getRealTab().$().trigger("focus")}};O.prototype._moveTab=function(e,t,i){c.moveItem.call(this,e,t,i);this._setItemsForStrip();this._initItemNavigation()};O.prototype.ondragrearranging=function(e){if(!this.getEnableTabReordering()){return}var t=e.srcControl,i=this.indexOfItem(this._getItemsInStrip().pop());e.preventDefault();this._moveTab(t,e.keyCode,i);t.$().trigger("focus")};O.prototype.onsaphomemodifiers=O.prototype.ondragrearranging;O.prototype.onsapendmodifiers=O.prototype.ondragrearranging;O.prototype.onsapincreasemodifiers=O.prototype.ondragrearranging;O.prototype.onsapdecreasemodifiers=O.prototype.ondragrearranging;return O});
//# sourceMappingURL=IconTabHeader.js.map