/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/EnabledPropagator","sap/ui/core/IconPool","./delegate/ValueStateMessage","sap/ui/core/message/MessageMixin","sap/ui/core/InvisibleMessage","sap/ui/core/library","sap/ui/Device","sap/ui/core/Popup","sap/ui/dom/containsOrEquals","./InputBaseRenderer","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/core/Lib","sap/ui/dom/jquery/cursorPos","sap/ui/dom/jquery/getSelectedText","sap/ui/dom/jquery/selectText"],function(e,t,s,a,o,n,i,r,u,l,p,c,h,g,f,jQuery,d){"use strict";var y=u.TextDirection;var m=u.TextAlign;var V=u.ValueState;var S=t.extend("sap.m.InputBase",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.ui.core.ISemanticFormContent","sap.m.IToolbarInteractiveControl","sap.ui.core.ILabelable"],library:"sap.m",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:V.None},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueStateText:{type:"string",group:"Misc",defaultValue:null},showValueStateMessage:{type:"boolean",group:"Misc",defaultValue:true},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:m.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:y.Inherit},required:{type:"boolean",group:"Misc",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{change:{parameters:{value:{type:"string"}}}},aggregations:{formattedValueStateText:{type:"sap.m.FormattedText",multiple:false},_invisibleFormattedValueStateText:{type:"sap.m.FormattedText",multiple:false,visibility:"hidden"},_endIcon:{type:"sap.ui.core.Icon",multiple:true,visibility:"hidden"},_beginIcon:{type:"sap.ui.core.Icon",multiple:true,visibility:"hidden"}},designtime:"sap/m/designtime/InputBase.designtime"},renderer:h});a.call(S.prototype);o.insertFontFaceStyle();i.call(S.prototype);S.ICON_PRESSED_CSS_CLASS="sapMInputBaseIconPressed";S.ICON_CSS_CLASS="sapMInputBaseIcon";S.prototype.bShowLabelAsPlaceholder=!l.support.input.placeholder;S.prototype._getPlaceholder=function(){return this.getPlaceholder()||""};S.prototype._getInputValue=function(e){return e===undefined?this.$("inner").val()||"":e.toString()};S.prototype._getInputElementTagName=function(){if(!this._sInputTagElementName){this._sInputTagElementName=this._$input&&this._$input.get(0)&&this._$input.get(0).tagName}return this._sInputTagElementName};S.prototype.init=function(){this.setLastValue("");this.bRenderingPhase=false;this._oValueStateMessage=new n(this);this._aValueStateLinks=[];this._bIsComposingCharacter=false;this.setLastValueStateText("");this.setErrorMessageAnnouncementState(false);this.fnCloseValueStateOnClick=this.closeValueStateMessage.bind(this)};S.prototype._oLinkDelegate={onfocusout:function(e){var t=e.relatedTarget||e.relatedControlId&&s.getElementById(e.relatedControlId).getDomRef();const a=t&&c(this.getDomRef(),t);const o=t&&c(this._oValueStateMessage.getDomRef(),t);if(!a&&!o){this.closeValueStateMessage()}},onsapup:function(e){e.preventDefault();e.stopImmediatePropagation()},onsapdown:function(e){e.preventDefault();e.stopImmediatePropagation()}};S.prototype._oFirstLinkDelegate={onsaptabprevious:function(e){e.preventDefault();e.stopImmediatePropagation();this.getFocusDomRef().focus()}};S.prototype._oLastLinkDelegate={onsaptabnext:function(e){this.onsapfocusleave(e);this._oPreviousFocus&&p.applyFocusInfo(this._oPreviousFocus);setTimeout(()=>{this.closeValueStateMessage()},0)}};S.prototype.oncompositionstart=function(){this._bIsComposingCharacter=true};S.prototype.oncompositionend=function(e){this._bIsComposingCharacter=false;if(!l.browser.firefox){this._bCheckDomValue=true}};S.prototype.isComposingCharacter=function(){return this._bIsComposingCharacter};S.prototype.onBeforeRendering=function(){var e=this.getFocusDomRef();var t=this.getFormattedValueStateText();var s;if(!this._oInvisibleMessage){this._oInvisibleMessage=r.getInstance()}if(this._bCheckDomValue&&!this.bRenderingPhase){if(this.isActive()){this._sDomValue=this._getInputValue()}else{this._bCheckDomValue=false}}if(!t){s=false}else{var a=this.getAggregation("_invisibleFormattedValueStateText");s=t.getHtmlText()!==(a&&a.getHtmlText())}if(this.getValueState()===V.Error&&e){var o=s||this.getValueStateText()!==this.getLastValueStateText();this.setErrorMessageAnnouncementState(!e.hasAttribute("aria-invalid")||o)}if(s){a&&a.destroy();this.setAggregation("_invisibleFormattedValueStateText",t.clone())}this.bRenderingPhase=true};S.prototype.onAfterRendering=function(){var e=this.getValueState();var t=this.getFocusDomRef()===document.activeElement;var s=e===V.None;var a=document.getElementById(this.getValueStateMessageId()+"-sr");if(this._bCheckDomValue&&this._sDomValue!==this._getInputValue()){this.$("inner").val(this._sDomValue)}if(this.getErrorMessageAnnouncementState()&&this.hasStyleClass("sapMFocus")){if(a){const e=document.getElementById(this.getValueStateLinksShortcutsId());const t=e?e.textContent:"";const s=`${a.textContent} ${t}`;this._oInvisibleMessage.announce(s)}this.setErrorMessageAnnouncementState(false)}this._bCheckDomValue=false;this.bRenderingPhase=false;if(t){this[s?"closeValueStateMessage":"openValueStateMessage"]()}if(s){this.closeValueStateMessage()}if(this.getAggregation("_invisibleFormattedValueStateText")){this.getAggregation("_invisibleFormattedValueStateText").getControls().forEach(function(e){e.getDomRef()&&e.getDomRef().setAttribute("tabindex",-1)})}this.setLastValueStateText(this.getValueStateText())};S.prototype.exit=function(){if(this._oValueStateMessage){this._oValueStateMessage.destroy()}if(this._oInvisibleMessage){this._oInvisibleMessage.destroy();this._oInvisibleMessage=null}this._oValueStateMessage=null};S.prototype.ontouchstart=function(e){e.setMarked()};S.prototype.onfocusin=function(e){this.addStyleClass("sapMFocus");this.openValueStateMessage()};S.prototype.onfocusout=function(e){this.removeStyleClass("sapMFocus");if(!this._bClickOnValueStateLink(e)){this.closeValueStateMessage()}};S.prototype.onsapfocusleave=function(e){if(!this.preventChangeOnFocusLeave(e)){this.onChange(e)}};S.prototype.preventChangeOnFocusLeave=function(e){return this.bFocusoutDueRendering};S.prototype.getChangeEventParams=function(){return{}};S.prototype.ontap=function(e){if(!this.isMobileDevice()){this.openValueStateMessage()}return};S.prototype.onChange=function(e,t,s){t=t||this.getChangeEventParams();if(this.getDomRef()&&(!this.getEditable()||!this.getEnabled())){return}var a=this._getInputValue(s);if(a!==this.getLastValue()){this.setValue(a);a=this.getValue();this.setLastValue(a);this.fireChangeEvent(a,t);return true}else{this._bCheckDomValue=false}};S.prototype.fireChangeEvent=function(e,t){var s=jQuery.extend({value:e,newValue:e},t);this.fireChange(s)};S.prototype.onValueRevertedByEscape=function(e,t){this.fireEvent("liveChange",{value:e,escPressed:true,previousValue:t,newValue:e})};S.prototype.isMobileDevice=function(){return l.system.phone};S.prototype.onsapenter=function(e){if(l.browser.safari&&this.isComposingCharacter()){e.setMarked("invalid");return}this.onChange(e)};S.prototype.onsapescape=function(e){var t=this._getInputValue();if(t!==this.getLastValue()){e.setMarked();e.preventDefault();this.updateDomValue(this.getLastValue());this.onValueRevertedByEscape(this.getLastValue(),t)}};S.prototype.oninput=function(e){this._bCheckDomValue=true};S.prototype.onkeydown=function(e){if(this.getDomRef("inner")&&this.getDomRef("inner").getAttribute("readonly")&&e.keyCode==f.BACKSPACE){e.preventDefault()}};S.prototype.areHotKeysPressed=function(e){return(e.ctrlKey||e.metaKey)&&e.altKey&&e.which===f.F8};S.prototype._handleValueStateLinkNav=function(){const e=this._getValueStateLinks();e.length&&e[0].focus()};S.prototype.oncut=function(e){};S.prototype.selectText=function(e,t){this.$("inner").selectText(e,t);return this};S.prototype.getSelectedText=function(){return this.$("inner").getSelectedText()};S.prototype.setProperty=function(e,s,a){if(e=="value"){this._bCheckDomValue=false}return t.prototype.setProperty.apply(this,arguments)};S.prototype.getFocusInfo=function(){var e=t.prototype.getFocusInfo.call(this),s=this.getFocusDomRef();jQuery.extend(e,{cursorPos:0,selectionStart:0,selectionEnd:0});if(s){e.cursorPos=jQuery(s).cursorPos();try{e.selectionStart=s.selectionStart;e.selectionEnd=s.selectionEnd}catch(e){}}return e};S.prototype.applyFocusInfo=function(e){t.prototype.applyFocusInfo.call(this,e);this.$("inner").cursorPos(e.cursorPos);this.selectText(e.selectionStart,e.selectionEnd);return this};S.prototype.updateDomValue=function(e){var t=this.getFocusDomRef();if(!this.isActive()){return this}e=this._getInputValue(e);if(this._getInputValue()===e){return this}this._bCheckDomValue=true;if(this._getPreferUserInteraction()){this.handleInputValueConcurrency(e)}else{t.value=e}return this};S.prototype._setValueStateLinks=function(e){if(this.getFormattedValueStateText()&&this.getFormattedValueStateText().getHtmlText()&&this.getFormattedValueStateText().getControls().length){this._aValueStateLinks=this.getFormattedValueStateText().getControls();return}this._aValueStateLinks=e};S.prototype._getValueStateLinks=function(){return this._aValueStateLinks};S.prototype._bClickOnValueStateLink=function(e){const t=this._getValueStateLinks();const s=e&&e.relatedTarget;if(t.length){return t.some(function(e){return!!e.getDomRef&&s===e.getDomRef()})}if(s&&s.tagName==="A"&&s.parentElement.classList.contains("sapMFT")){this._setValueStateLinks([s]);this._attachValueStateLinkActions();return true}return false};S.prototype._attachValueStateLinkActions=function(){const e=this._getValueStateLinks();e.forEach(function(e,t){if(e.attachPress){e.attachPress(this.fnCloseValueStateOnClick,this);e.addDelegate(this._oLinkDelegate,this);if(t===0){e.addDelegate(this._oFirstLinkDelegate,this)}if(t===this._aValueStateLinks.length-1){e.addDelegate(this._oLastLinkDelegate,this)}}else{e.addEventListener("click",this.fnCloseValueStateOnClick)}},this)};S.prototype._detachValueStateLinkActions=function(){const e=this._getValueStateLinks();e.forEach(function(e,t){if(e.detachPress){e.detachPress(this.fnCloseValueStateOnClick,this);e.removeDelegate(this._oLinkDelegate,this);if(t===0){e.removeDelegate(this._oFirstLinkDelegate,this)}if(t===this._aValueStateLinks.length-1){e.removeDelegate(this._oLastLinkDelegate,this)}}},this)};S.prototype.handleInputValueConcurrency=function(e){var t=this.getFocusDomRef(),s=t&&this._getInputValue(),a=this.getProperty("value"),o=document.activeElement===t,n=this.isBound("value")&&this.isPropertyBeingUpdated("value");if(o&&n&&s&&a!==s){return this}t.value=e;if(o&&n&&!s){t.select()}};S.prototype.setPreferUserInteraction=function(e){this._setPreferUserInteraction(e)};S.prototype._setPreferUserInteraction=function(e){this._bPreferUserInteraction=e};S.prototype._getPreferUserInteraction=function(){return this._bPreferUserInteraction};S.prototype.closeValueStateMessage=function(){if(l.system.phone){setTimeout(function(){if(this._oValueStateMessage){this._detachValueStateLinkActions();this._oValueStateMessage.close();this._oPreviousFocus=null}}.bind(this),0)}else if(this._oValueStateMessage){this._detachValueStateLinkActions();this._oValueStateMessage.close();this._oPreviousFocus=null}};S.prototype.getDomRefForValueStateMessage=function(){return this.getDomRef("content")};S.prototype.getPopupAnchorDomRef=function(){return this.getDomRef()};S.prototype.iOpenMessagePopupDuration=0;S.prototype.getValueStateMessageId=function(){return this.getId()+"-message"};S.prototype.getValueStateLinksShortcutsId=function(){return this.getValueStateMessageId()+"-shortcuts"};S.prototype.getValueStateLinksShortcutsTextAcc=function(){const e=this.getValueStateLinksForAcc();if(!e.length){return""}let t="INPUTBASE_VALUE_STATE_LINK";let s="INPUTBASE_VALUE_STATE_LINKS";if(l.os.macintosh){t+="_MAC";s+="_MAC"}return d.getResourceBundleFor("sap.m").getText(e.length===1?t:s)};S.prototype.getErrorMessageAnnouncementState=function(){return this._bErrorStateShouldBeAnnounced};S.prototype.setErrorMessageAnnouncementState=function(e){this._bErrorStateShouldBeAnnounced=e};S.prototype.setLastValueStateText=function(e){this._sLastValueStateText=e};S.prototype.getLastValueStateText=function(){return this._sLastValueStateText};S.prototype.getLabels=function(){var e=this.getAriaLabelledBy().map(function(e){return s.getElementById(e)});var t=sap.ui.require("sap/ui/core/LabelEnablement");if(t){e=e.concat(t.getReferencingLabels(this).map(function(e){return s.getElementById(e)}))}return e};S.prototype.openValueStateMessage=function(){if(this._oValueStateMessage&&this.shouldValueStateMessageBeOpened()){this._oPreviousFocus=p.getCurrentFocusInfo();setTimeout(function(){if(!this.bIsDestroyed){this._setValueStateLinks([]);this._attachValueStateLinkActions();this._oValueStateMessage.open()}}.bind(this),0)}};S.prototype.shouldValueStateMessageBeOpened=function(){return this.getValueState()!==V.None&&this.getEditable()&&this.getEnabled()&&this.getShowValueStateMessage()};S.prototype._calculateIconsSpace=function(){var e=this.getAggregation("_endIcon")||[],t=this.getAggregation("_beginIcon")||[],s=e.concat(t),a,o;return s.reduce(function(e,t){a=t&&t.getDomRef()?parseFloat(getComputedStyle(t.getDomRef()).marginRight):0;o=t&&t.getDomRef()?t.getDomRef().offsetWidth:0;return e+o+a},0)};S.prototype.setValue=function(e){e=this.validateProperty("value",e);e=this._getInputValue(e);this.updateDomValue(e);if(e!==this.getProperty("value")){this.setLastValue(e)}this.setProperty("value",e,true);return this};S.prototype.getFocusDomRef=function(){return this.getDomRef("inner")};S.prototype.getIdForLabel=function(){return this.getId()+"-inner"};S.prototype.hasLabelableHTMLElement=function(){return true};S.prototype.getAccessibilityInfo=function(){var e=d.getResourceBundleFor("sap.m"),t=this.getRequired()?e.getText("ELEMENT_REQUIRED"):"",s=this.getRenderer();return{role:s.getAriaRole(this),type:e.getText("ACC_CTR_TYPE_INPUT"),description:[this.getValueDescriptionInfo(),s.getLabelledByAnnouncement(this),s.getDescribedByAnnouncement(this),t].join(" ").trim(),focusable:this.getEnabled(),enabled:this.getEnabled(),editable:this.getEnabled()&&this.getEditable()}};S.prototype.getValueDescriptionInfo=function(){return this.getValue()||d.getResourceBundleFor("sap.m").getText("INPUTBASE_VALUE_EMPTY")};S.prototype._addIcon=function(e,t,s){if(["begin","end"].indexOf(e)===-1){g.error('icon position is not "begin", neither "end", please check again the passed setting');return null}var a=o.createControlByURI(t).addStyleClass(S.ICON_CSS_CLASS);if(s!==undefined){this.insertAggregation("_"+e+"Icon",a,s)}else{this.addAggregation("_"+e+"Icon",a)}return a};S.prototype.addBeginIcon=function(e){return this._addIcon("begin",e)};S.prototype.addEndIcon=function(e,t){return this._addIcon("end",e,t)};Object.defineProperty(S.prototype,"_$input",{get:function(){return this.$("inner")}});S.prototype.setLastValue=function(e){this._lastValue=e;return this};S.prototype.getLastValue=function(){return this._lastValue};S.prototype.getFormFormattedValue=function(){return this.getValue()};S.prototype.getFormValueProperty=function(){return"value"};S.prototype.getFormObservingProperties=function(){return["value"]};S.prototype.getFormRenderAsControl=function(){return false};S.prototype._getToolbarInteractive=function(){return true};S.prototype.getValueStateLinksForAcc=function(){return[]};return S});
//# sourceMappingURL=InputBase.js.map