/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/ControlBehavior","./library","sap/ui/Device","sap/ui/core/InvisibleText","sap/ui/core/InvisibleRenderer","sap/ui/core/Configuration","sap/ui/core/Lib"],function(e,t,i,n,r,s,a){"use strict";var o=t.ListType;var d=t.ListMode;var l={apiVersion:2};l.renderInvisible=function(e,t){r.render(e,t,t.TagName)};l.renderHighlight=function(e,t){var i=t.getHighlight();if(i=="None"){return}e.openStart("div");e.class("sapMLIBHighlight");e.class("sapMLIBHighlight"+i);e.openEnd();e.close("div")};l.isModeMatched=function(e,t){var i=(sap.ui.require("sap/m/ListBaseRenderer")||{}).ModeOrder||{};return i[e]==t};l.renderMode=function(e,t,i){var n=t.getMode();if(!this.isModeMatched(n,i)){return}var r=t.getModeControl(true);if(r){this.renderModeContent(e,t,r)}};l.renderModeContent=function(e,t,i){this.decorateMode(i,t);e.renderControl(i)};l.decorateMode=function(t,i){t.removeStyleClass("sapMLIBSelectAnimation sapMLIBUnselectAnimation");if(e.getAnimationMode()===s.AnimationMode.none||!i.getListProperty("modeAnimationOn")){return}var n=i.getMode(),r=i.getListProperty("lastMode");if(!r||r==n){return}if(n==d.None){t.addStyleClass("sapMLIBUnselectAnimation")}else{t.addStyleClass("sapMLIBSelectAnimation")}};l.renderCounter=function(e,t){var i=t.getCounter();if(i){this.renderCounterContent(e,t,i)}};l.renderCounterContent=function(e,t,i){e.openStart("div",t.getId()+"-counter");e.attr("aria-label",a.getResourceBundleFor("sap.m").getText("LIST_ITEM_COUNTER",[i]));e.class("sapMLIBCounter");e.openEnd();e.text(i);e.close("div")};l.renderType=function(e,t){var i=t.getTypeControl(true);if(i){e.renderControl(i)}};l.openItemTag=function(e,t){e.openStart(t.TagName,t)};l.closeItemTag=function(e,t){e.close(t.TagName)};l.renderTabIndex=function(e,t){const i=t.getList();if(i?._skipGroupHeaderFocus()&&t.isGroupHeader()){return}e.attr("tabindex","-1")};l.renderTooltip=function(e,t){var i=t.getTooltip_AsString();if(i){e.attr("title",i)}};l.addFocusableClasses=function(e,t){if(i.system.desktop){e.class("sapMLIBFocusable");this.addLegacyOutlineClass(e,t)}};l.addLegacyOutlineClass=function(e,t){};l.getAriaAnnouncement=function(e,t){return n.getStaticId("sap.m",t||"LIST_ITEM_"+e.toUpperCase())};l.getAriaRole=function(e){if(e.isGroupHeader()){return"listitem"}var t=e.getList();return t&&t.getAriaRole()=="listbox"?"option":"listitem"};l.getAriaLabelledBy=function(e){if(!e.getContentAnnouncement&&e.getAriaLabelledBy().length){return e.getId()}};l.getAriaDescribedBy=function(e){if(e.getContentAnnouncement){return""}var t=[],i=e.getType();if(e.getListProperty("showUnread")&&e.getUnread()){t.push(this.getAriaAnnouncement("unread"))}if(e.getMode()==d.Delete){t.push(this.getAriaAnnouncement("delete"))}if(i==o.Navigation){t.push(this.getAriaAnnouncement("navigation"))}else{if(i==o.Detail||i==o.DetailAndActive){t.push(this.getAriaAnnouncement("detail"))}if(i==o.Active||i==o.DetailAndActive){t.push(this.getAriaAnnouncement("active"))}}return t.join(" ")};l.getAccessbilityPosition=function(e){var t=e.getList();return t&&t.getAccessbilityPosition&&t.getAccessbilityPosition(e)};l.getAccessibilityState=function(e){var t=this.getAriaLabelledBy(e),i=this.getAriaDescribedBy(e),n=this.getAriaRole(e),r=true,s={role:n};if(t){s.labelledby={value:t.trim(),append:true}}if(i){s.describedby={value:i.trim(),append:true}}if(e.getNavigated()){s.current=true}if(n==="listitem"){s.selected=null;if(e.isGroupHeader()){const t=e.getList();r=false;s.role=t?.getAriaRole()==="listbox"?"group":"listitem";if(e.getTitle){s.label=e.getTitle()}s.roledescription=a.getResourceBundleFor("sap.m").getText("LIST_ITEM_GROUP_HEADER");if(!t?._hasNestedGrouping()){const t=e.getGroupedItems();if(t&&t.length){s.owns=t.join(" ")}}}}else if(e.isSelectable()){s.selected=e.getSelected()}if(r){var o=this.getAccessbilityPosition(e);Object.assign(s,o)}return s};l.renderLIContent=function(e,t){};l.renderLISubList=function(e,t){e.openStart("ul");e.attr("role","list");e.attr("aria-labelledby",t.getId()+"-title");var i=t.getGroupedItems();if(i&&i.length){e.attr("aria-owns",i.join(" "))}e.openEnd();e.close("ul")};l.renderLIAttributes=function(e,t){};l.renderContentFormer=function(e,t){this.renderHighlight(e,t);this.renderMode(e,t,-1)};l.renderContentLatter=function(e,t){this.renderCounter(e,t);this.renderType(e,t);this.renderMode(e,t,1);this.renderNavigated(e,t)};l.renderLIContentWrapper=function(e,t){e.openStart("div",t.getId()+"-content").class("sapMLIBContent").openEnd();this.renderLIContent(e,t);const i=t.getList();if(i?._hasNestedGrouping()&&t.isGroupHeader()){this.renderLISubList(e,t)}e.close("div")};l.renderNavigated=function(e,t){if(!t.getNavigated()){return}e.openStart("div");e.class("sapMLIBNavigated");e.openEnd();e.close("div")};l.render=function(t,i){if(!i.getVisible()){this.renderInvisible(t,i);return false}this.openItemTag(t,i);t.class("sapMLIB");t.class("sapMLIB-CTX");t.class("sapMLIBShowSeparator");t.class("sapMLIBType"+i.getType());if(i.isActionable(true)){t.class("sapMLIBActionable");t.class("sapMLIBHoverable")}if(i.getSelected()){t.class("sapMLIBSelected")}if(i.getListProperty("showUnread")&&i.getUnread()){t.class("sapMLIBUnread")}this.addFocusableClasses(t,i);this.renderTooltip(t,i);this.renderTabIndex(t,i);if(e.isAccessibilityEnabled()){t.accessibilityState(i,this.getAccessibilityState(i))}this.renderLIAttributes(t,i);t.openEnd();this.renderContentFormer(t,i);this.renderLIContentWrapper(t,i);this.renderContentLatter(t,i);this.closeItemTag(t,i)};return l},true);
//# sourceMappingURL=ListItemBaseRenderer.js.map