/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/library","sap/ui/core/Control","./Button","./Dialog","./NavContainer","./List","./Page","./MenuListItem","./MenuItem","sap/ui/core/Lib","sap/ui/unified/Menu","sap/ui/unified/MenuItem","sap/ui/unified/MenuItemGroup","sap/ui/Device","sap/ui/core/EnabledPropagator","sap/ui/thirdparty/jquery","sap/ui/core/Popup","sap/ui/base/ManagedObject","sap/ui/core/Element"],function(e,t,i,n,s,o,a,r,l,u,g,p,m,h,d,_,jQuery,I,f,c){"use strict";var y=I.Dock;var C=e.ListType;var v=e.ListMode;var M=t.ItemSelectionMode;var S=i.extend("sap.m.Menu",{metadata:{interfaces:["sap.ui.core.IContextMenu"],library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.IMenuItem",multiple:true,singularName:"item",bindable:"bindable",defaultClass:u},_dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"},_menu:{type:"sap.ui.unified.Menu",multiple:false,visibility:"hidden"}},events:{itemSelected:{parameters:{item:{type:"sap.m.MenuItem"}}},closed:{},beforeClose:{allowPreventDefault:true}}},renderer:null});_.call(S.prototype);S.UNIFIED_MENU_ITEMS_ID_SUFFIX="-unifiedmenu";S.UNFIFIED_MENU_ITEMS_PROPS=m.getMetadata().getAllProperties();S.LIST_ITEMS_ID_SUFFIX="-menuinnerlist";S.MENU_LIST_ITEMS_PROPS=l.getMetadata().getAllProperties();S.prototype.init=function(){if(d.system.phone){this._initDialog()}this._bIsInitialized=false;this.attachEvent("propertyChanged",this._onPropertyChanged,this);this.attachEvent("aggregationChanged",this._onAggregationChanged,this)};S.prototype.exit=function(){var e=this._getMenu(),t=e&&e.getPopup(),i=this._getDialog();if(this._navContainerId){this._navContainerId=null}if(this._bIsInitialized){this._bIsInitialized=null}if(t){t.detachClosed(this._menuClosed,this);e.detachBeforeClose(this._handleVisualParentClose,this)}if(i){i.detachBeforeClose(this._handleVisualParentClose,this)}};S.prototype.invalidate=function(){};S.prototype.setTitle=function(e){var t=this._getNavContainer();this.setProperty("title",e,true);if(t&&t.getPages().length){t.getPages()[0].setTitle(e)}return this};S.prototype.openBy=function(e,t,i,n,s){if(d.system.phone){this._openDialog()}else{if(!this._bIsInitialized){this._initAllMenuItems();this._bIsInitialized=true}if(!i){i=y.BeginTop}if(!n){n=y.BeginBottom}if(!s){s="0 -2"}this._getMenu().open(t,e,i,n,e,s)}};S.prototype.close=function(){if(d.system.phone){this._getDialog()&&this._getDialog().close()}else{this._getVisualParent()&&this._getVisualParent().close()}};S.prototype.isOpen=function(){if(d.system.phone){return this._getDialog()&&this._getDialog().isOpen()}else{return this._getVisualParent()&&this._getVisualParent().isOpen()}};S.prototype._initDialog=function(){var e=new s({showHeader:false,stretch:true,content:this._initNavContainer(),buttons:[this._initCloseButton()]});e.addStyleClass("sapMRespMenuDialog");e.addStyleClass("sapUiNoContentPadding");this.setAggregation("_dialog",e,true);e.attachAfterClose(this._menuClosed,this);e.attachBeforeClose(this._handleVisualParentClose,this)};S.prototype._getDialog=function(){return this.getAggregation("_dialog")};S.prototype._openDialog=function(){if(!this._bIsInitialized){this._initAllPages();this._bIsInitialized=true}this._getNavContainer().to(this._getNavContainer().getPages()[0]);this._getDialog().open()};S.prototype._initAllMenuItems=function(){this._initMenuForItems(this.getItems())};S.prototype._setCustomEnhanceAccStateFunction=function(e){this._fnEnhanceUnifiedMenuAccState=e};S.prototype._initMenuForItems=function(e,t){var i=new p;i.attachBeforeClose(this._handleVisualParentClose,this);i._setCustomEnhanceAccStateFunction(this._fnEnhanceUnifiedMenuAccState);i.isCozy=this._isMenuCozy.bind(this,i);this.addStyleClass("sapMMenu");i.aCustomStyleClasses=this.aCustomStyleClasses;i.mCustomStyleClassMap=this.mCustomStyleClassMap;e.forEach(function(e){if(this._isMenuItemGroup(e)){this._addVisualMenuItemGroupFromItemsGroup(e,i)}else{this._addVisualMenuItemFromItem(e,i)}}.bind(this));if(t){t.setSubmenu(i)}else{i.getPopup().attachClosed(this._menuClosed,this);this.setAggregation("_menu",i,true)}i.attachItemSelect(this._handleMenuItemSelect,this)};S.prototype._handleVisualParentClose=function(e){if(!this.fireBeforeClose()){e.preventDefault()}};S.prototype._menuClosed=function(){this.fireClosed()};S.prototype._getMenu=function(){return this.getAggregation("_menu")};S.prototype._initCloseButton=function(){var e=g.getResourceBundleFor("sap.m");return new n({text:e.getText("MENU_CLOSE"),press:P.bind(this)})};function P(){this._getDialog().close()}S.prototype._initNavContainer=function(){var e=new o;this._navContainerId=e.getId();return e};S.prototype._getNavContainer=function(){return c.getElementById(this._navContainerId)};S.prototype._initAllPages=function(){this._initPageForParent(this)};S.prototype._initPageForParent=function(e){var t=e.getItems(),i=e instanceof S,n=i?e.getTitle():e.getText(),s=new a({mode:v.None}),o=new r({title:n,showNavButton:!i,content:s});if(!i){this._setBackButtonTooltipForPageWithParent(e,o)}o.attachNavButtonPress(function(){this._getNavContainer().back()},this);this._getNavContainer().addPage(o);t.forEach(function(e){this._addListItemFromItem(e,o)},this);this._updateListInset(s);s.attachEvent("itemPress",this._handleListItemPress,this);return o};S.prototype._handleListItemPress=function(e){var t=e.getParameter("listItem"),i=c.getElementById(t.getMenuItem()),n=i._getItems().length?i._getVisualChild():null,s=!t.getProperty("selected");if(n){this._getNavContainer().to(n)}else{this._getDialog().close();if(t._getItemSelectionMode()!==M.None){t.setSelected(s);i.setSelected(s)}this.fireItemSelected({item:i})}i.firePress()};S.prototype._setBackButtonTooltipForPageWithParent=function(e,t){var i=e.getParent(),n=g.getResourceBundleFor("sap.m"),s;s=i instanceof S?i.getTitle():i.getText();s=n.getText("MENU_PAGE_BACK_BUTTON")+" "+s;t.setNavButtonTooltip(s)};S.prototype._isMenuItemGroup=function(e){return!!e.getItemSelectionMode};S.prototype._createMenuListItemFromItem=function(e){var t=this._generateListItemId(e.getId()),i=c.getElementById(t),n=c.getElementById(e.getAssociation("_group"));if(i){return i}i=new l({id:t,type:e.getEnabled()?C.Active:C.Inactive,icon:e.getIcon(),title:this._handleSettingsValue(e.getText()),selected:e.getSelected(),startsSection:e.getStartsSection(),menuItem:e,tooltip:this._handleSettingsValue(e.getTooltip()),visible:e.getVisible(),enabled:e.getEnabled()});i.setAssociation("_group",n);e.aDelegates.forEach(function(e){i.addEventDelegate(e.oDelegate,e.vThis)});return i};S.prototype._createVisualMenuItemFromItem=function(e){var t=this._generateUnifiedMenuItemId(e.getId()),i=c.getElementById(t),n=e.getCustomData(),s=e.getEndContent();if(i){return i}i=new m({id:t,icon:e.getIcon(),text:this._handleSettingsValue(e.getText()),selected:e.getSelected(),shortcutText:this._handleSettingsValue(e.getShortcutText()),startsSection:e.getStartsSection(),tooltip:this._handleSettingsValue(e.getTooltip()),visible:e.getVisible(),enabled:e.getEnabled()});for(var o=0;o<n.length;o++){e._addCustomData(i,n[o])}s.forEach(t=>{e._addEndContent(i,t)});e.aDelegates.forEach(function(e){i.addEventDelegate(e.oDelegate,e.vThis)});return i};S.prototype._addVisualMenuItemFromItem=function(e,t,i){var n=this._createVisualMenuItemFromItem(e),s=this._isMenuItemGroup(t)?t.getParent():t,o=e.getItems(),a;e._setVisualParent(s);e._setVisualControl(n);if(o.length){a=o[0];if(this._isMenuItemGroup(a)){var r=a.getItems();a=r.length?r[0]:null}this._initMenuForItems(o,n);a&&e._setVisualChild(a._getVisualParent())}i===undefined?t.addItem(n):t.insertItem(n,i)};S.prototype._createVisualMenuItemGroupFromItemsGroup=function(e){var t=this._generateUnifiedMenuItemId(e.getId()),i=c.getElementById(t),n=e.getCustomData();if(i){return i}i=new h({id:t,itemSelectionMode:e.getItemSelectionMode()});e._setVisualControl(i);e._setParentMenu(this);for(var s=0;s<n.length;s++){e._addCustomData(i,n[s])}return i};S.prototype._addVisualMenuItemGroupFromItemsGroup=function(e,t,i){var n=this._createVisualMenuItemGroupFromItemsGroup(e),s=e.getItems();i===undefined?t.addItem(n):t.insertItem(n,i);for(var o=0;o<s.length;o++){this._addVisualMenuItemFromItem(s[o],n)}};S.prototype._addListItemFromItem=function(e,t,i){var n=e.getItems(),s=this._isMenuItemGroup(e),o;if(s){e._setParentMenu(this);e.getItems().forEach(e=>{this._addListItemFromItem(e,t,i);if(i!==undefined){i++}});return}var a=this._createMenuListItemFromItem(e),r=t.getContent()[0];e._setVisualParent(t);e._setVisualControl(a);if(n.length){this._initPageForParent(e);o=n[0];if(this._isMenuItemGroup(o)){n=o.getItems();o=n.length?n[0]:null}if(o){e._setVisualChild(o._getVisualParent())}}if(i===undefined){r.addItem(a)}else{r.insertItem(a,i)}r.invalidate()};S.prototype._connectVisualItem=function(e,t,i){if(!t||c.getElementById(e._getVisualControl())&&t.indexOfItem(e)!==-1){return}if(d.system.phone){this._addListItemFromItem(e,t,i);var n=t.getContent()[0];this._updateListInset(n)}else{this._addVisualMenuItemFromItem(e,t,i)}};S.prototype._updateListInset=function(e){var t=false,i="sapMListIcons",n=e.getItems();for(var s=0;s<n.length;s++){if(n[s].getIcon()){t=true;break}}if(t){e.addStyleClass(i)}else{e.removeStyleClass(i)}};S.prototype._getItems=function(){var e=[];const t=i=>{i.forEach(i=>{if(!this._isMenuItemGroup(i)){e.push(i)}else{t(i.getItems())}})};t(this.getItems());return e};S.prototype._handleMenuItemSelect=function(e){var t=e.getParameter("item"),i;if(!t){return}i=this._findMenuItemByUnfdMenuItem(t);i.setSelected(t.getSelected());if(i&&!i._getItems().length){this.fireItemSelected({item:i})}if(i){i.firePress()}};S.prototype._generateListItemId=function(e){return e+S.LIST_ITEMS_ID_SUFFIX};S.prototype._generateUnifiedMenuItemId=function(e){return e+S.UNIFIED_MENU_ITEMS_ID_SUFFIX};S.prototype._findMenuItemByUnfdMenuItem=function(e){var t=e.getId().slice(0,-S.UNIFIED_MENU_ITEMS_ID_SUFFIX.length);return c.getElementById(t)};S.prototype._isMenuCozy=function(e){if(!e.bCozySupported){return false}if(e.hasStyleClass("sapUiSizeCozy")){return true}if(V(e.oOpenerRef)){return true}return false};function V(e){if(!e){return false}e=e.$?e.$():jQuery(e);var t=e.closest(".sapUiSizeCompact,.sapUiSizeCondensed,.sapUiSizeCozy");return!t.hasClass("sapUiSizeCompact")&&!t.hasClass("sapUiSizeCondensed")||t.hasClass("sapUiSizeCozy")}S.prototype.addAggregation=function(e,t,n){i.prototype.addAggregation.apply(this,arguments);if(e==="items"){this._connectVisualItem(t,this._getVisualParent())}return this};S.prototype.insertAggregation=function(e,t,n,s){i.prototype.insertAggregation.apply(this,arguments);if(e==="items"){this._connectVisualItem(t,this._getVisualParent(),n)}return this};S.prototype.removeAggregation=function(e,t,n){var s=i.prototype.removeAggregation.apply(this,arguments);if(e==="items"){this._removeVisualItem(s)}return s};S.prototype.removeAllAggregation=function(e,t){var n=i.prototype.removeAllAggregation.apply(this,arguments);if(e==="items"){for(var s=0;s<n.length;s++){this._removeVisualItem(n[s])}}return n};S.prototype._removeVisualItem=function(e,t){var i=c.getElementById(e._getVisualControl()),n;if(i){n=i.getParent();n.removeItem(i);if(d.system.phone){this._removeSubPageForItem(e);if(n.getItems().length===0){if(t){t._setVisualChild(null);c.getElementById(t._getVisualControl()).invalidate()}}if(n){n.invalidate()}}}};S.prototype.destroyAggregation=function(e,t){if(e==="items"){for(var n=0;n<this.getItems().length;n++){this._removeVisualItem(this.getItems()[n])}}return i.prototype.destroyAggregation.apply(this,arguments)};S.prototype._removeSubPageForItem=function(e,t){var i;if(!t){for(var n=0;n<e.getItems().length;n++){this._removeSubPageForItem(e.getItems()[n])}}if(e._getVisualChild()){i=c.getElementById(e._getVisualChild());if(this._getNavContainer()&&i){this._getNavContainer().removePage(i)}!!i&&i.destroy()}};S.prototype._getVisualParent=function(){var e=this._getNavContainer(),t=this._getMenu();if(e&&e.getPages().length){return e.getPages()[0]}else{return t}};S.prototype._onPropertyChanged=function(e){e.cancelBubble();var t=e.getParameter("propertyKey"),i=e.getParameter("propertyValue"),n=d.system.phone?S.MENU_LIST_ITEMS_PROPS:S.UNFIFIED_MENU_ITEMS_PROPS,s=d.system.phone?this._generateListItemId:this._generateUnifiedMenuItemId,o,a;if(d.system.phone&&t==="text"){t="title"}if(!n[t]){return}o=s(e.getSource().getId());a=c.getElementById(o);if(a){a.setProperty(t,i);if(d.system.phone&&this._getDialog().isOpen()){this._getDialog().close()}}};S.prototype._onAggregationChanged=function(e){e.cancelBubble();var t=e.getParameter("aggregationName");switch(t){case"items":this._onItemsAggregationChanged(e);break;case"tooltip":this._onTooltipAggregationChanged(e);break;default:}};S.prototype._onTooltipAggregationChanged=function(e){var t=e.getSource()._getVisualControl(),i=e.getParameter("methodName"),n=e.getParameter("methodParams"),s;if(!t){return}s=c.getElementById(t);if(i==="set"){s.setTooltip(n.item)}if(i==="destroy"){s.destroyTooltip()}};S.prototype._onItemsAggregationChanged=function(e){var t=e.getSource(),i=e.getParameter("methodName"),n=e.getParameter("methodParams"),s;if(i==="add"||i==="insert"){if(i==="insert"){s=n.index}this._addOrInsertItem(t,n.item,s)}if(i==="remove"){this._removeVisualItem(n.item,t)}if(i==="removeall"){for(var o=0;o<n.items.length;o++){this._removeVisualItem(n.items[o],t)}}if(i==="destroy"){this._destroyItem(t)}};S.prototype._addOrInsertItem=function(e,t,i){var n;if(e._getVisualChild()){this._connectVisualItem(t,c.getElementById(e._getVisualChild()),i)}else{if(d.system.phone){this._initPageForParent(e);e._setVisualChild(e.getItems()[0]._getVisualParent());n=c.getElementById(e._getVisualControl());n&&n.invalidate()}else{this._initMenuForItems(e.getItems(),c.getElementById(e._getVisualControl()));e._setVisualChild(e._getItems()[0]._getVisualParent())}}};S.prototype._destroyItem=function(e){var t=c.getElementById(e._getVisualControl());if(t&&t.setMenuItem){t.setMenuItem(null)}this._removeSubPageForItem(e,true);e._setVisualChild(null);if(t&&t.setMenuItem){t.invalidate();t.setMenuItem(e)}};S.prototype.getDomRefId=function(){if(d.system.phone){return this._getDialog().getId()}else{return this._getMenu().getId()}};S.prototype.openAsContextMenu=function(e,t){if(d.system.phone){this._openDialog()}else{if(!this._bIsInitialized){this._initAllMenuItems();this._bIsInitialized=true}this._getMenu().openAsContextMenu(e,t)}};["addStyleClass","removeStyleClass","toggleStyleClass"].forEach(function(e){S.prototype[e]=function(t,n){var s=this._getDialog();i.prototype[e].apply(this,arguments);if(s){s[e].apply(s,arguments)}return this}});S.prototype.getSelectedItems=function(){return this._getItems().filter(e=>e.getSelected&&e.getSelected()&&e._getItemSelectionMode()!==M.None)};S.prototype._handleSettingsValue=function(e){if(typeof e!=="string"){return e}try{f.bindingParser(e);return e}catch{return f.escapeSettingsValue(e)}};return S});
//# sourceMappingURL=Menu.js.map