/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","./Button","./SplitButton","sap/ui/Device","sap/ui/core/Element","sap/ui/core/EnabledPropagator","sap/ui/core/library","sap/ui/core/Popup","sap/ui/core/LabelEnablement","./MenuButtonRenderer","sap/ui/events/KeyCodes"],function(t,e,o,n,i,r,s,a,u,p,l,h){"use strict";var c=t.MenuButtonMode;var g=a.TextDirection;var f=t.ButtonType;var d=u.Dock;var y=["buttonMode","useDefaultActionOnly","width","menuPosition"];var B=e.extend("sap.m.MenuButton",{metadata:{interfaces:["sap.m.IToolbarInteractiveControl"],library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:null},type:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:f.Default},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:g.Inherit},buttonMode:{type:"sap.m.MenuButtonMode",group:"Misc",defaultValue:c.Regular},menuPosition:{type:"sap.ui.core.Popup.Dock",group:"Misc",defaultValue:d.BeginBottom},useDefaultActionOnly:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{menu:{type:"sap.m.Menu",multiple:false,singularName:"menu"},_button:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{defaultAction:{},beforeMenuOpen:{}},defaultAggregation:"menu",designtime:"sap/m/designtime/MenuButton.designtime",dnd:{draggable:true,droppable:false}},renderer:l});s.call(B.prototype);B.prototype.init=function(){this._initButtonControl()};B.prototype.exit=function(){if(this._sDefaultText){this._sDefaultText=null}if(this._sDefaultIcon){this._sDefaultIcon=null}if(this._lastActionItemId){this._lastActionItemId=null}if(this.getMenu()){this.getMenu().detachClosed(this._menuClosed,this)}};B.prototype.onBeforeRendering=function(){if(!this._sDefaultText){this._sDefaultText=this.getText()}if(!this._sDefaultIcon){this._sDefaultIcon=this.getIcon()}this._updateButtonControl();this._attachMenuEvents()};B.prototype._getTextBtnContentDomRef=function(){return this._getButtonControl()._getTextButton().getDomRef("content")};B.prototype.onAfterRendering=function(){if(this._activeButton){this._activeButton.$().attr("aria-expanded","false");this._activeButton=null}};B.prototype.setButtonMode=function(t){var o=this.getTooltip(),n,i;e.prototype.setProperty.call(this,"buttonMode",t,true);this._getButtonControl().destroy();this._initButtonControl();n=this._getButtonControl();i=n.getMetadata().getAllProperties();for(var s in this.mProperties){if(this.mProperties.hasOwnProperty(s)&&y.indexOf(s)<0&&i.hasOwnProperty(s)){n.setProperty(s,this.mProperties[s],true)}}if(o){n.setTooltip(o)}if(!this._isSplitButton()&&this._sDefaultText){this.setText(this._sDefaultText)}else if(!this.getUseDefaultActionOnly()&&this._getLastSelectedItem()){this.setText(r.getElementById(this._getLastSelectedItem()).getText())}if(!this._isSplitButton()&&this._sDefaultIcon){this.setIcon(this._sDefaultIcon)}else if(!this.getUseDefaultActionOnly()&&this._getLastSelectedItem()){this.setIcon(r.getElementById(this._getLastSelectedItem()).getIcon())}this.invalidate();return this};B.prototype._initButton=function(){var t=new o(this.getId()+"-internalBtn",{width:"100%",ariaHasPopup:a.aria.HasPopup.Menu});t.attachPress(this._handleButtonPress,this);t.onkeydown=this.handleKeydown;return t};B.prototype._initSplitButton=function(){var t=new n(this.getId()+"-internalSplitBtn",{width:"100%"});t.attachPress(this._handleActionPress,this);t.attachArrowPress(this._handleButtonPress,this);t._getArrowButton().onkeydown=this.handleKeydown;return t};B.prototype._initButtonControl=function(){var t;if(this._isSplitButton()){t=this._initSplitButton()}else{t=this._initButton()}this.setAggregation("_button",t,true)};B.prototype._updateButtonControl=function(){this._getButtonControl().setText(this.getText())};B.prototype._getButtonControl=function(){return this.getAggregation("_button")};B.prototype._handleButtonPress=function(t){var e=this.getMenu(),o={zero:"0 0",plus2_right:"0 +2",minus2_right:"0 -2",plus2_left:"+2 0",minus2_left:"-2 0"};this.fireBeforeMenuOpen();if(!e){return}if(e.isOpen()&&!t.getParameter("keyboard")){e.close();this._bPopupOpen=false;return}if(!e.getTitle()){e.setTitle(this.getText())}var n=[this,t.getParameter("keyboard")];switch(this.getMenuPosition()){case d.BeginTop:n.push(d.BeginBottom,d.BeginTop,o.plus2_right);break;case d.BeginCenter:n.push(d.BeginCenter,d.BeginCenter,o.zero);break;case d.LeftTop:n.push(d.RightBottom,d.LeftBottom,o.plus2_left);break;case d.LeftCenter:n.push(d.RightCenter,d.LeftCenter,o.plus2_left);break;case d.LeftBottom:n.push(d.RightTop,d.LeftTop,o.plus2_left);break;case d.CenterTop:n.push(d.CenterBottom,d.CenterTop,o.plus2_left);break;case d.CenterCenter:n.push(d.CenterCenter,d.CenterCenter,o.zero);break;case d.CenterBottom:n.push(d.CenterTop,d.CenterBottom,o.minus2_right);break;case d.RightTop:n.push(d.LeftBottom,d.RightBottom,o.minus2_left);break;case d.RightCenter:n.push(d.LeftCenter,d.RightCenter,o.minus2_left);break;case d.RightBottom:n.push(d.LeftTop,d.RightTop,o.minus2_left);break;case d.EndTop:n.push(d.EndBottom,d.EndTop,o.plus2_right);break;case d.EndCenter:n.push(d.EndCenter,d.EndCenter,o.zero);break;case d.EndBottom:n.push(d.EndTop,d.EndBottom,o.minus2_right);break;case d.BeginBottom:default:n.push(d.BeginTop,d.BeginBottom,o.minus2_right);break}e.openBy.apply(e,n);if(this.getMenu()){this._bPopupOpen=true}this._writeAriaAttributes();if(this._isSplitButton()&&!i.system.phone){this._getButtonControl().setArrowState(true)}};B.prototype._handleActionPress=function(){var t=this._getLastSelectedItem(),e;if(!this.getUseDefaultActionOnly()&&t){e=r.getElementById(t);this.getMenu().fireItemSelected({item:e})}else{this.fireDefaultAction()}};B.prototype._menuClosed=function(){var t=this._getButtonControl(),e=t,o=this.getMenu(),n=o&&o._getMenu&&o._getMenu();if(this._isSplitButton()){t.setArrowState(false);e=t._getArrowButton()}if(n&&n._bLeavingMenu){this._bPopupOpen=false}e.$().removeAttr("aria-controls");e.$().attr("aria-expanded","false")};B.prototype._menuItemSelected=function(t){var e=t.getParameter("item");this.fireEvent("_menuItemSelected",{item:e});this._bPopupOpen=false;if(!this._isSplitButton()||this.getUseDefaultActionOnly()||!e){return}this._lastActionItemId=e.getId();!!this._sDefaultText&&this.setText(e.getText());!!this._sDefaultIcon&&this.setIcon(e.getIcon())};B.prototype._getLastSelectedItem=function(){return this._lastActionItemId};B.prototype._attachMenuEvents=function(){if(this.getMenu()){this.getMenu().attachClosed(this._menuClosed,this);this.getMenu().attachItemSelected(this._menuItemSelected,this)}};B.prototype._isSplitButton=function(){return this.getButtonMode()===c.Split};B.prototype.setProperty=function(t,o,n){function i(t){var e=[f.Up,f.Back,f.Unstyled];return e.indexOf(t)!==-1}if(t==="type"&&i(o)){return this}if(t==="text"){this._sDefaultText=o}switch(t){case"activeIcon":case"iconDensityAware":case"textDirection":case"visible":case"enabled":this._getButtonControl().setProperty(t,o);break}return e.prototype.setProperty.apply(this,arguments)};B.prototype.setTooltip=function(t){this._getButtonControl().setTooltip(t);return e.prototype.setTooltip.apply(this,arguments)};B.prototype.setText=function(t){e.prototype.setProperty.call(this,"text",t);this._getButtonControl().setText(t);return this};B.prototype.setType=function(t){e.prototype.setProperty.call(this,"type",t);this._getButtonControl().setType(t);return this};B.prototype.setIcon=function(t){e.prototype.setProperty.call(this,"icon",t);this._getButtonControl().setIcon(t);return this};B.prototype.addAriaLabelledBy=function(t){this.getAggregation("_button").addAssociation("ariaLabelledBy",t);return e.prototype.addAssociation.call(this,"ariaLabelledBy",t)};B.prototype.addAriaDescribedBy=function(t){this.getAggregation("_button").addAssociation("ariaDescribedBy",t);return e.prototype.addAssociation.call(this,"ariaDescribedBy",t)};B.prototype.removeAriaLabelledBy=function(t){this.getAggregation("_button").removeAssociation("ariaLabelledBy",t);return e.prototype.removeAssociation.call(this,"ariaLabelledBy",t)};B.prototype.removeAriaDescribedBy=function(t){this.getAggregation("_button").removeAssociation("ariaDescribedBy",t);return e.prototype.removeAssociation.call(this,"ariaDescribedBy",t)};B.prototype.removeAllAriaLabelledBy=function(t){this.getAggregation("_button").removeAllAssociation("ariaLabelledBy");return e.prototype.removeAllAssociation.call(this,"ariaLabelledBy")};B.prototype.removeAllAriaDescribedBy=function(){this.getAggregation("_button").removeAllAssociation("ariaDescribedBy");return e.prototype.removeAllAssociation.call(this,"ariaDescribedBy")};B.prototype.getFocusDomRef=function(){return this._getButtonControl().getDomRef()};B.prototype.onsapescape=function(t){var e=this.getMenu(),o=e&&e._getMenu&&e._getMenu();if(o&&this._bPopupOpen){o._bLeavingMenu=true;o.close();this._menuClosed();t.preventDefault()}};B.prototype.onsapup=function(t){this.openMenuByKeyboard();t.stopPropagation()};B.prototype.onsapdown=function(t){this.openMenuByKeyboard();t.stopPropagation()};B.prototype.onsapupmodifiers=function(t){this.openMenuByKeyboard();t.stopPropagation()};B.prototype.onsapdownmodifiers=function(t){this.openMenuByKeyboard();t.stopPropagation()};B.prototype.onsapshow=function(t){this.openMenuByKeyboard();!!t&&t.preventDefault()};B.prototype.ontouchstart=function(){this._bPopupOpen=this.getMenu()&&this.getMenu()._getMenu()&&this.getMenu()._getMenu().getPopup().isOpen()};B.prototype.handleKeydown=function(t){if((t.keyCode===h.ENTER||t.keyCode===h.TAB)&&this._bPopupOpen){this.getMenu().close();this._bPopupOpen=false}o.prototype.onkeydown.call(this,t)};B.prototype.openMenuByKeyboard=function(){if(!this._isSplitButton()){this._handleButtonPress(Object.create(null,{getParameter:{value:function(){return true}}}))}};B.prototype._writeAriaAttributes=function(){var t=this._getButtonControl(),e=this._isSplitButton()?t._getArrowButton():t,o=this.getMenu();if(o){e.$().attr("aria-controls",o.getDomRefId());e.$().attr("aria-expanded","true")}};B.prototype._getToolbarInteractive=function(){return true};B.prototype.getIdForLabel=function(){return this.getId()+"-internalBtn"};B.prototype._ensureBackwardsReference=function(){var t=this._getButtonControl(),e=t.getAriaLabelledBy(),o=p.getReferencingLabels(this);o.forEach(function(o){if(e&&e.indexOf(o)===-1){t.addAriaLabelledBy(o)}});return this};return B});
//# sourceMappingURL=MenuButton.js.map