/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/library","sap/ui/core/Element","sap/ui/core/Item","sap/ui/base/ManagedObjectObserver"],function(e,t,n,o,r){"use strict";var s=t.ItemSelectionMode;var a=o.extend("sap.m.MenuItem",{metadata:{interfaces:["sap.m.IMenuItem"],library:"sap.m",properties:{icon:{type:"string",group:"Appearance",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true},selected:{type:"boolean",group:"Behavior",defaultValue:false},shortcutText:{type:"string",group:"Appearance",defaultValue:""},startsSection:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.IMenuItem",multiple:true,singularName:"item",bindable:"bindable"},endContent:{type:"sap.ui.core.Control",multiple:true}},associations:{_group:{type:"sap.ui.unified.MenuItemGroup",group:"Behavior",visibility:"hidden"}},events:{press:{},propertyChanged:{parameters:{propertyKey:{type:"string"},propertyValue:{type:"any"}}},aggregationChanged:{parameters:{aggregationName:{type:"string"},methodName:{type:"string"},methodParams:{type:"object"}}}}}});a.UNIFIED_MENU_ITEMS_ID_SUFFIX="-unifiedmenu";a.prototype.exit=function(){if(this._sVisualChild){this._sVisualChild=null}if(this._sVisualParent){this._sVisualParent=null}if(this._sVisualControl){this._sVisualControl=null}};a.prototype.setProperty=function(e,t){o.prototype.setProperty.apply(this,arguments);this.fireEvent("propertyChanged",{propertyKey:e,propertyValue:t},false,true)};a.prototype.setAggregation=function(e,t,n){o.prototype.setAggregation.apply(this,arguments);this.fireEvent("aggregationChanged",{aggregationName:e,methodName:"set",methodParams:{item:t}},false,true);return this};a.prototype.addAggregation=function(e,t,r){var s=this._getVisualControl(),a;o.prototype.addAggregation.apply(this,arguments);if(e==="customData"&&s){a=n.getElementById(s);this._addCustomData(a,t)}else if(e==="endContent"&&s){a=n.getElementById(s);this._addEndContent(a,t)}this.fireEvent("aggregationChanged",{aggregationName:e,methodName:"add",methodParams:{item:t}},false,true);return this};a.prototype.insertAggregation=function(e,t,r,s){var i=this._getVisualControl(),u;o.prototype.insertAggregation.apply(this,arguments);if(e==="customData"&&i){u=n.getElementById(i);u.insertCustomData(t.clone(a.UNIFIED_MENU_ITEMS_ID_SUFFIX),r);this._observeCustomDataChanges(t)}else if(e==="endContent"&&i){u=n.getElementById(i);u.insertEndContent(t.clone(a.UNIFIED_MENU_ITEMS_ID_SUFFIX),r);this._observeEndContentChanges(t)}this.fireEvent("aggregationChanged",{aggregationName:e,methodName:"insert",methodParams:{item:t,index:r}},false,true);return this};a.prototype.removeAggregation=function(e,t,n){var r=o.prototype.removeAggregation.apply(this,arguments);if(e==="customData"){if(this.getCustomData().length===1){this._disconnectAndDestroyCustomDataObserver()}else if(t&&this._oCustomDataObserver){this._oCustomDataObserver.unobserve(t,{properties:["value"]})}}else if(e==="endContent"){if(this.getEndContent().length===1){this._disconnectAndDestroyEndContentObserver()}else if(t&&this._oEndContentObserver){if(!this.getEndContent().length){this._oEndContentObserver.unobserve(t,{aggregations:["endContent"]})}}}this.fireEvent("aggregationChanged",{aggregationName:e,methodName:"remove",methodParams:{item:r}},false,true);return r};a.prototype.removeAllAggregation=function(e,t){var n=o.prototype.removeAllAggregation.apply(this,arguments);if(e==="customData"){this._disconnectAndDestroyCustomDataObserver()}else if(e==="endContent"){this._disconnectAndDestroyEndContentObserver()}this.fireEvent("aggregationChanged",{aggregationName:e,methodName:"removeall",methodParams:{items:n}},false,true);return n};a.prototype.destroyAggregation=function(e,t){if(e==="customData"){this._disconnectAndDestroyCustomDataObserver()}else if(e==="endContent"){this._disconnectAndDestroyEndContentObserver()}this.fireEvent("aggregationChanged",{aggregationName:e,methodName:"destroy"},false,true);return o.prototype.destroyAggregation.apply(this,arguments)};a.prototype.destroy=function(){var e=n.getElementById(this._getVisualControl());if(e){e.destroy()}return o.prototype.destroy.apply(this,arguments)};a.prototype.addEventDelegate=function(e,t){o.prototype.addEventDelegate.apply(this,arguments);if(this._getVisualControl()){var r=n.getElementById(this._getVisualControl());r.addEventDelegate(e,t)}return this};a.prototype.removeEventDelegate=function(e){o.prototype.removeEventDelegate.apply(this,arguments);if(this._getVisualControl()){var t=n.getElementById(this._getVisualControl());t.removeEventDelegate(e)}return this};a.prototype.setSelected=function(e){var t=n.getElementById(this.getAssociation("_group"));if(e&&t&&t.getItemSelectionMode()===s.SingleSelect){t._clearSelectedItems()}this.setProperty("selected",e);return this};a.prototype._addCustomData=function(e,t){e.addCustomData(t.clone(a.UNIFIED_MENU_ITEMS_ID_SUFFIX,undefined,{}));this._observeCustomDataChanges(t)};a.prototype._addEndContent=function(e,t){e.addEndContent(t.clone(a.UNIFIED_MENU_ITEMS_ID_SUFFIX,undefined,{cloneChildren:true,cloneBindings:false}));this._observeEndContentChanges(t)};a.prototype._observeCustomDataChanges=function(e){this._getCustomDataObserver().observe(e,{properties:["value"]})};a.prototype._observeEndContentChanges=function(e){this._getEndContentObserver().observe(e,{properties:true})};a.prototype._customDataObserverCallbackFunction=function(e){n.getElementById(e.object.getId()+"-"+a.UNIFIED_MENU_ITEMS_ID_SUFFIX).setValue(e.current)};a.prototype._endContentObserverCallbackFunction=function(e){n.getElementById(e.object.getId()+"-"+a.UNIFIED_MENU_ITEMS_ID_SUFFIX).setProperty(e.name,e.current)};a.prototype._getCustomDataObserver=function(){if(!this._oCustomDataObserver){this._oCustomDataObserver=new r(this._customDataObserverCallbackFunction)}return this._oCustomDataObserver};a.prototype._getEndContentObserver=function(){if(!this._oEndContentObserver){this._oEndContentObserver=new r(this._endContentObserverCallbackFunction)}return this._oEndContentObserver};a.prototype._disconnectAndDestroyCustomDataObserver=function(){if(this._oCustomDataObserver){this._oCustomDataObserver.disconnect();this._oCustomDataObserver.destroy();this._oCustomDataObserver=null}};a.prototype._disconnectAndDestroyEndContentObserver=function(){if(this._oEndContentObserver){this._oEndContentObserver.disconnect();this._oEndContentObserver.destroy();this._oEndContentObserver=null}};a.prototype._setVisualChild=function(e){this._setInternalRef(e,"_sVisualChild")};a.prototype._setVisualParent=function(e){this._setInternalRef(e,"_sVisualParent")};a.prototype._setVisualControl=function(e){this._setInternalRef(e,"_sVisualControl")};a.prototype._setInternalRef=function(e,t){if(!e||typeof e==="string"){this[t]=e}else if(e.getId){this[t]=e.getId()}};a.prototype._getVisualChild=function(){return this._sVisualChild};a.prototype._getVisualParent=function(){return this._sVisualParent};a.prototype._getVisualControl=function(){return this._sVisualControl};a.prototype._getItems=function(){var e=[];const t=n=>{n.forEach(n=>{if(!n.getItemSelectionMode){e.push(n)}else{t(n.getItems())}})};t(this.getItems());return e};return a});
//# sourceMappingURL=MenuItem.js.map