/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/Device","sap/ui/core/library"],function(t,e,n){"use strict";var i=n.ItemSelectionMode;var s=t.extend("sap.m.MenuItemGroup",{metadata:{interfaces:["sap.m.IMenuItem"],library:"sap.m",properties:{itemSelectionMode:{type:"sap.ui.core.ItemSelectionMode",group:"Behavior",defaultValue:i.None}},aggregations:{items:{type:"sap.m.IMenuItem",multiple:true,singularName:"item"}},associations:{_menu:{type:"sap.m.Menu",visibility:"hidden"}}}});s.prototype.setItemSelectionMode=function(t,e){const n=this._getVisualControl();this.setProperty("itemSelectionMode",t,e);n&&n.setProperty("itemSelectionMode",t,e);if(t===i.SingleSelect){this._ensureSingleSelection()}return this};s.prototype.addItem=function(t,e){return this._addOrInsertItem(t,undefined,e)};s.prototype.insertItem=function(t,e,n){if(e===undefined){e=this.getItems().length}return this._addOrInsertItem(t,e,n)};s.prototype.removeItem=function(t,n){const i=this._findItemObject(t);var s,o,r,l;if(!i){return null}s=this._findVisualControlObject(i._getVisualControl());r=this._findParentMenuItemVisualControl(i);if(s){o=s.getParent();o&&o.removeItem(s)}l=this.removeAggregation("items",i,n);if(s&&!n){r&&r.invalidate();if(e.system.phone){const t=o.getParent().getParent();!o.getItems().length&&t.back()}else{const t=o.getParent();t&&!t._getItems().length&&t.close()}}return l};s.prototype.removeAllItems=function(t){const n=this.getItems();if(!n.length){return null}const i=e.system.phone,s=i?this._findVisualControlObject(n[0]._getVisualControl()):this._getVisualControl();if(i){const e=this._findParentMenuItemVisualControl(n[0]),i=s&&s.getParent();if(i){const e=i.getParent().getParent();n.forEach(e=>i.removeItem(e._getVisualControl(),t));!t&&!i.getItems().length&&e.back()}!t&&e&&e.invalidate()}else if(s){s.removeAllItems(t)}return this.removeAllAggregation("items",t)};s.prototype.destroyItems=function(n){const i=this.getItems(),s=e.system.phone;var o;if(!i.length){return this}if(s){let e,s;i.forEach(i=>{var o=this._findVisualControlObject(i._getVisualControl());if(o){e=o.getParent();s=t.getElementById(i._sVisualParent).getParent();o.destroy(n)}});!n&&e&&!e.getItems().length&&s.back()&&s.invalidate()}else{o=this._getVisualControl();o&&o.destroyItems(n)}this.destroyAggregation("items",n);return this};s.prototype._addOrInsertItem=function(t,e,n){const s=t.getSelected&&t.getSelected();t.setAssociation("_group",this);if(s&&this.getItemSelectionMode()===i.SingleSelect){this._clearSelectedItems()}this._addOrInsertVisualItem(t,e);if(e===undefined){return this.addAggregation("items",t,n)}return this.insertAggregation("items",t,e,n)};s.prototype._addOrInsertVisualItem=function(n,i){const s=this.getParent(),o=this._getParentMenu();if(!o){return}if(e.system.phone&&s){const e=s.isA("sap.m.Menu")?s._getVisualParent():t.getElementById(s._getVisualChild());if(!e){return}const r=this.getId(),l=this.getItems().length,a=this._findGroupFirstIndex(r),u=s._getVisualControl&&s._getVisualControl(),g=u&&this._findVisualControlObject(u);if(i===undefined||i>l){i=l}o._addListItemFromItem(n,e,a+i);g&&g.invalidate()}else{o._addVisualMenuItemFromItem(n,this._getVisualControl(),i)}};s.prototype._invalidateParentControls=function(){const t=this.getParent();if(t&&!t._getItems().length){const e=t.getParent();e&&e.invalidate();t.close()}};s.prototype._findGroupFirstIndex=function(t){const e=this.getParent(),n=e.getItems();let i=0;for(let s=0;s<n.length;s++){const o=n[s];if(o.getId()===t){break}else if(e._isMenuItemGroup(o)){i+=o.getItems().length}else{i++}}return i};s.prototype._findItemObject=function(t){if(typeof t==="number"){return this.getItems()[t]}else if(typeof t==="string"){return this.getItems().find(e=>e.getId()===t)}else{return t}};s.prototype._findVisualControlObject=function(e){if(typeof e==="string"){return t.getElementById(e)}else{return e}};s.prototype._findParentMenuItemVisualControl=function(t){const e=this._findVisualControlObject(this.getParent());return e&&e.isA("sap.m.MenuItem")?this._findVisualControlObject(e._getVisualControl()):null};s.prototype._clearSelectedItems=function(){this.getItems().forEach(t=>t.setSelected&&t.setSelected(false))};s.prototype._getVisualControl=function(){return this._oUnifiedGroup};s.prototype._setVisualControl=function(t){this._oUnifiedGroup=t};s.prototype._setParentMenu=function(t){this.setAssociation("_menu",t)};s.prototype._getParentMenu=function(){return t.getElementById(this.getAssociation("_menu"))};s.prototype._ensureSingleSelection=function(){const t=this.getItems(),e=t.map(t=>t.getSelected()),n=e.lastIndexOf(true);this._clearSelectedItems();if(n!==-1){t[n].setSelected(true)}};return s});
//# sourceMappingURL=MenuItemGroup.js.map