/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ResponsivePopover","./Button","./Toolbar","./Bar","sap/ui/core/Control","sap/ui/core/IconPool","./semantic/SemanticPage","./Popover","./MessageView","./MessageItem","sap/ui/Device","./MessagePopoverRenderer","sap/base/Log","sap/ui/base/ManagedObjectObserver","sap/ui/core/Lib","sap/ui/core/Messaging","sap/ui/thirdparty/jquery"],function(e,t,o,s,i,n,a,r,p,l,g,u,c,h,d,f,jQuery){"use strict";var m=i.extend("sap.m.MessagePopover",{metadata:{library:"sap.m",properties:{asyncDescriptionHandler:{type:"function",group:"Behavior",defaultValue:null},asyncURLHandler:{type:"function",group:"Behavior",defaultValue:null},placement:{type:"sap.m.VerticalPlacementType",group:"Behavior",defaultValue:"Vertical"},initiallyExpanded:{type:"boolean",group:"Behavior",defaultValue:true},groupItems:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MessageItem",multiple:true,singularName:"item",forwarding:{getter:"_getMessageView",aggregation:"items"}},headerButton:{type:"sap.m.Button",multiple:false,forwarding:{idSuffix:"-messageView",aggregation:"headerButton"}}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},itemSelect:{parameters:{item:{type:"sap.m.MessageItem"},messageTypeFilter:{type:"module:sap/ui/core/message/MessageType"}}},listSelect:{parameters:{messageTypeFilter:{type:"module:sap/ui/core/message/MessageType"}}},longtextLoaded:{},urlValidated:{},activeTitlePress:{parameters:{item:{type:"sap.m.MessageItem"}}}}},renderer:u});function _(e){return e.charAt(0).toUpperCase()+e.slice(1)}var y="sapMMsgPopover",v="320px",P="440px",M={back:n.getIconURI("nav-back"),close:n.getIconURI("decline"),information:n.getIconURI("message-information"),warning:n.getIconURI("message-warning"),error:n.getIconURI("message-error"),success:n.getIconURI("message-success")},B=["asyncDescriptionHandler","asyncURLHandler"],w={asyncDescriptionHandler:function(e){var t=e.item.getLongtextUrl();if(t){jQuery.ajax({type:"GET",url:t,success:function(t){e.item.setDescription(t);e.promise.resolve()},error:function(){var o="A request has failed for long text data. URL: "+t;c.error(o);e.promise.reject(o)}})}}};m.setDefaultHandlers=function(e){B.forEach(function(t){if(e.hasOwnProperty(t)){w[t]=e[t]}})};m.prototype.init=function(){var o=this;var s;this._oOpenByControl=null;this._oResourceBundle=d.getResourceBundleFor("sap.m");this._oMessageView=this._initMessageView();this._oMessageView.addEventDelegate({onBeforeRendering:function(){var e=o._oMessageView._oSegmentedButton.getVisible(),t=!o.getInitiallyExpanded()||e;o._oMessageView._oSegmentedButton.setVisible(t);o._oMessageView._listPage.setShowHeader(true)}});this._insertCloseBtn(this._oMessageView._oListHeader);this._insertCloseBtn(this._oMessageView._oDetailsHeader);this._oMessageView._oSegmentedButton.attachEvent("select",this._onSegButtonSelect,this);this._oPopover=new e(this.getId()+"-messagePopover",{showHeader:false,contentWidth:P,contentHeight:v,placement:this.getPlacement(),showCloseButton:false,verticalScrolling:false,horizontalScrolling:false,modal:false,afterOpen:function(e){o.fireAfterOpen({openBy:e.getParameter("openBy")});o.getInitiallyExpanded()&&o._oMessageView._restoreFocus()},afterClose:function(e){o._oMessageView._navContainer.removeAllPages().forEach(function(e){o._oMessageView._navContainer.addPage(e)});o.fireAfterClose({openBy:e.getParameter("openBy")})},beforeOpen:function(e){var t=o.getItems();if(!o.getBindingInfo("items")&&!t.length){o._bindToMessageModel()}o.fireBeforeOpen({openBy:e.getParameter("openBy")})},beforeClose:function(e){o.fireBeforeClose({openBy:e.getParameter("openBy")})}}).addStyleClass(y);this._oPopover._setAriaModal(false);this._oPopover.addContent(this._oMessageView);this._oPopover.addAssociation("ariaLabelledBy",this.getId()+"-messageView-HeadingDescr",true);s=this._oPopover.getAggregation("_popup");s.oPopup.setAutoClose(false);s.addEventDelegate({onBeforeRendering:this.onBeforeRenderingPopover,onAfterRendering:this.onAfterRenderingPopover},this);if(g.system.phone){this._oPopover.setBeginButton(new t({text:this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE"),press:this.close.bind(this)}))}B.forEach(function(e){if(w.hasOwnProperty(e)){this["set"+_(e)](w[e])}},this);this._observeItems()};m.prototype._bindToMessageModel=function(){var e=this;this.setModel(f.getMessageModel(),"message");this._oMessageItemTemplate=new l({type:"{message>type}",title:"{message>message}",description:"{message>description}",longtextUrl:"{message>longtextUrl}"});this.bindAggregation("items",{path:"message>/",template:e._oMessageItemTemplate})};m.prototype._observeItems=function(){var e=new h(function(e){var t=e.mutation;var o=e.child;switch(t){case"insert":o.attachEvent("_change",this.invalidate,this);break;case"remove":o.detachEvent("_change",this.invalidate,this);break;default:break}}.bind(this));e.observe(this._oMessageView,{aggregations:["items"]})};m.prototype.onBeforeRendering=function(){if(this.getDependents().indexOf(this._oPopover)===-1){this.addDependent(this._oPopover)}this._oPopover.setPlacement(this.getPlacement())};m.prototype.onBeforeRenderingPopover=function(){this._setInitialFocus();if(this._oOpenByControl&&!this._oOpenByControl.getVisible()){this._oPopover.close()}this._syncMessageView()};m.prototype.onAfterRenderingPopover=function(){if(this._oPopover._oControl._sFocusControlId){this._oPopover._oControl._sFocusControlId=null}};m.prototype.exit=function(){this._oResourceBundle=null;this._oOpenByControl=null;if(this._oMessageView){this._oMessageView.destroy();this._oMessageView=null}if(this._oPopover){this._oPopover.destroy();this._oPopover=null}};m.prototype.openBy=function(e){var t=this._oPopover.getAggregation("_popup"),i=e.getParent();this._oOpenByControl=e;if(t instanceof r){if(i instanceof o||i instanceof s||i instanceof a){t._minDimensions={width:400,height:128};t.setShowArrow(false);t.setResizable(true)}else{t.setShowArrow(true)}}if(this._oPopover){this._restoreExpansionDefaults();this._oPopover.openBy(e)}return this};m.prototype.close=function(){if(this._oPopover){this._oPopover.close()}return this};m.prototype.isOpen=function(){return this._oPopover?this._oPopover.isOpen():false};m.prototype.toggle=function(e){if(this.isOpen()){this.close()}else{this.openBy(e)}return this};m.prototype.getDomRef=function(e){return this._oPopover&&this._oPopover.getAggregation("_popup").getDomRef(e)};m.prototype._initMessageView=function(){var e=this,t;t=new p(this.getId()+"-messageView",{activeTitlePress:function(t){if(g.system.phone){e.close()}e.fireActiveTitlePress({item:t.getParameter("item")})},listSelect:function(t){e.fireListSelect({messageTypeFilter:t.getParameter("messageTypeFilter")})},itemSelect:function(t){e.fireItemSelect({messageTypeFilter:t.getParameter("messageTypeFilter"),item:t.getParameter("item")})},longtextLoaded:function(){e.fireLongtextLoaded()},urlValidated:function(){e.fireUrlValidated()}});t._makeAutomaticBinding=function(){var t=e.getItems();if(!e.getBindingInfo("items")&&!t.length){this._bindToMessageModel()}};return t};m.prototype._onSegButtonSelect=function(){if(this.isOpen()&&!this.getInitiallyExpanded()&&this._oPopover.hasStyleClass(y+"-init")){this._expandMsgPopover()}};m.prototype._restoreExpansionDefaults=function(){if(this._oMessageView&&!this.getInitiallyExpanded()&&this.getItems().length!=1){this._collapseMsgPopover();this._oMessageView._oSegmentedButton.setSelectedButton("none")}else{this._expandMsgPopover()}};m.prototype._expandMsgPopover=function(){var e=v,t=this._oPopover.$("cont").css("height");if(this.getInitiallyExpanded()&&t!=="0px"){e=parseFloat(t)?t:e}this._oPopover.setContentHeight(e).removeStyleClass(y+"-init")};m.prototype._collapseMsgPopover=function(){this._oPopover.addStyleClass(y+"-init").setContentHeight("auto")};m.prototype._insertCloseBtn=function(e){var o=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE"),s=new t({icon:M["close"],visible:!g.system.phone,tooltip:o,press:this.close.bind(this)}).addStyleClass(y+"CloseBtn");e.insertContent(s,3,true)};m.prototype._setInitialFocus=function(){if(this._oMessageView&&this._oMessageView._isListPage()&&this.getInitiallyExpanded()){this._oPopover.setInitialFocus(this._oMessageView._oLists[this._sCurrentList||"all"])}};m.prototype._syncMessageView=function(){if(this._oMessageView){this._oMessageView.setProperty("asyncDescriptionHandler",this.getAsyncDescriptionHandler(),true);this._oMessageView.setProperty("asyncURLHandler",this.getAsyncURLHandler(),true);this._oMessageView.setProperty("groupItems",this.getGroupItems(),false)}};m.prototype._getMessageView=function(){return this._oMessageView};m.prototype.setModel=function(e,t){if(this._oMessageView){this._oMessageView.setModel(e,t)}return i.prototype.setModel.apply(this,arguments)};m.prototype.navigateBack=function(){if(this._oMessageView){this._oMessageView.navigateBack()}};["invalidate","addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass","getBusyIndicatorDelay","setBusyIndicatorDelay","getVisible","setVisible","getBusy","setBusy","addCustomData","getCustomData","destroyCustomData","indexOfCustomData","insertCustomData","removeAllCustomData","removeCustomData"].forEach(function(e){m.prototype[e]=function(){if(this._oPopover&&this._oPopover[e]){var t=this._oPopover;var o=t[e].apply(t,arguments);return o===t?this:o}}});["setModel","bindAggregation","setAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation"].forEach(function(e){m.prototype["_"+e+"Old"]=m.prototype[e];m.prototype[e]=function(){var t=m.prototype["_"+e+"Old"].apply(this,arguments);this._bItemsChanged=true;if(this._oPopover){this._oPopover.invalidate()}if(["removeAggregation","removeAllAggregation"].indexOf(e)!==-1){return t}return this}});return m});
//# sourceMappingURL=MessagePopover.js.map